/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.api.Create;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private final IRubyObject io;
    private final RubyIO realIO;
    private final Ruby runtime;
    private final CallSite writeAdapter;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");
    private final Encoding encoding;

    public IOOutputStream(IRubyObject io2, Encoding encoding2, boolean checkAppend, boolean verifyCanWrite) {
        this.io = io2;
        this.runtime = io2.getRuntime();
        RubyIO realIO = this.realIO = this.getRealIO(io2);
        if (realIO == null || verifyCanWrite) {
            String site;
            if (io2.respondsTo("write")) {
                site = "write";
            } else if (checkAppend && io2.respondsTo("<<")) {
                site = "<<";
            } else {
                if (verifyCanWrite) {
                    throw io2.getRuntime().newArgumentError("Object: " + String.valueOf(io2) + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
                }
                site = "write";
            }
            this.writeAdapter = MethodIndex.getFunctionalCallSite(site);
        } else {
            this.writeAdapter = null;
        }
        this.encoding = encoding2;
    }

    protected RubyIO getRealIO(IRubyObject io2) {
        RubyIO tmpIO;
        RubyIO realIO = null;
        if (io2 instanceof RubyIO && this.fastWritable(tmpIO = (RubyIO)io2) && ((tmpIO = tmpIO.GetWriteIO()) == io2 || this.fastWritable(tmpIO))) {
            realIO = tmpIO;
        }
        return realIO;
    }

    protected boolean fastWritable(RubyIO io2) {
        return !io2.isClosed() && io2.isBuiltin("write");
    }

    public IOOutputStream(IRubyObject io2, boolean checkAppend, boolean verifyCanWrite) {
        this(io2, ASCIIEncoding.INSTANCE, checkAppend, verifyCanWrite);
    }

    public IOOutputStream(IRubyObject io2) {
        this(io2, true, true);
    }

    public IOOutputStream(IRubyObject io2, Encoding encoding2) {
        this(io2, encoding2, true, true);
    }

    @Override
    public void write(int bite) throws IOException {
        ThreadContext context = this.runtime.getCurrentContext();
        RubyIO realIO = this.realIO;
        if (realIO != null) {
            realIO.write(context, bite);
        } else {
            IRubyObject io2 = this.io;
            this.writeAdapter.call(context, io2, io2, (IRubyObject)Create.newSharedString(context, new ByteList(new byte[]{(byte)bite}, this.encoding, false)));
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        ThreadContext context = this.runtime.getCurrentContext();
        RubyIO realIO = this.realIO;
        if (realIO != null) {
            realIO.write(context, b2, off, len, this.encoding);
        } else {
            IRubyObject io2 = this.io;
            this.writeAdapter.call(context, io2, io2, (IRubyObject)RubyString.newStringLight(this.runtime, new ByteList(b2, off, len, this.encoding, false)));
        }
    }

    @Override
    public void close() throws IOException {
        ThreadContext context = this.runtime.getCurrentContext();
        RubyIO realIO = this.realIO;
        if (realIO != null) {
            realIO.close(context);
        } else {
            IRubyObject io2 = this.io;
            if (io2.respondsTo("close")) {
                this.closeAdapter.call(context, io2, io2);
            }
        }
    }
}

