/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.build.report.metrics.RemoteBuildMetricsReporter;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004B+\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0011\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0019\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0019\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0017H\u0096\u0001J\u001d\u0010\u0018\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001aH\u0096\u0001J\u0011\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0001J\u0019\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0017H\u0096\u0001J\u0019\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0017H\u0096\u0001J\u0019\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010#\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0001J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001aH\u0096\u0001J\u0019\u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010&\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0001R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/daemon/report/RemoteBuildMetricsReporterAdapter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "Lorg/jetbrains/kotlin/build/report/metrics/RemoteBuildMetricsReporter;", "delegate", "shouldReport", "", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "<init>", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;ZLorg/jetbrains/kotlin/daemon/common/CompilationResults;)V", "flush", "", "addAttribute", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addGcMetric", "metric", "", "value", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "addMetric", "", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "addTimeMetricMs", "time", "durationMs", "addTimeMetricNs", "durationNs", "endGcMetric", "name", "endMeasure", "getMetrics", "startGcMetric", "startMeasure", "kotlin-daemon"})
public final class RemoteBuildMetricsReporterAdapter
implements BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>,
RemoteBuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> {
    @NotNull
    private final BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> delegate;
    private final boolean shouldReport;
    @NotNull
    private final CompilationResults compilationResults;

    public RemoteBuildMetricsReporterAdapter(@NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> delegate, boolean shouldReport, @NotNull CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)compilationResults, (String)"compilationResults");
        this.delegate = delegate;
        this.shouldReport = shouldReport;
        this.compilationResults = compilationResults;
    }

    public void flush() {
        if (this.shouldReport) {
            BuildMetrics metrics = this.delegate.getMetrics();
            this.compilationResults.add(CompilationResultCategory.BUILD_METRICS.getCode(), (Serializable)metrics);
        }
    }

    public void startMeasure(@NotNull GradleBuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.delegate.startMeasure((BuildTime)time);
    }

    public void endMeasure(@NotNull GradleBuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.delegate.endMeasure((BuildTime)time);
    }

    public void addTimeMetricNs(@NotNull GradleBuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.delegate.addTimeMetricNs((BuildTime)time, durationNs);
    }

    public void addTimeMetricMs(@NotNull GradleBuildTime time, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.delegate.addTimeMetricMs((BuildTime)time, durationMs);
    }

    public void addMetric(@NotNull GradleBuildPerformanceMetric metric, long value) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.delegate.addMetric((BuildPerformanceMetric)metric, value);
    }

    public void addTimeMetric(@NotNull GradleBuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.delegate.addTimeMetric((BuildPerformanceMetric)metric);
    }

    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.delegate.addGcMetric(metric, value);
    }

    public void startGcMetric(@NotNull String name, @NotNull GcMetric value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.delegate.startGcMetric(name, value);
    }

    public void endGcMetric(@NotNull String name, @NotNull GcMetric value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.delegate.endGcMetric(name, value);
    }

    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.delegate.addAttribute(attribute);
    }

    @NotNull
    public BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> getMetrics() {
        return this.delegate.getMetrics();
    }

    public void addMetrics(@NotNull BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.delegate.addMetrics(metrics);
    }
}

