/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.Optional;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.TablePointer;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Table;

class MutableKeyColumn
extends AbstractDependantObject<Table>
implements Column {
    private static final long serialVersionUID = 6988029161945610279L;
    private final Column column;
    private int keyOrdinalPosition;

    MutableKeyColumn(Column column) {
        super(new TablePointer((Table)column.getParent()), column.getName());
        this.column = column;
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        int comparison = 0;
        if (obj instanceof MutableKeyColumn) {
            MutableKeyColumn other = (MutableKeyColumn)obj;
            comparison = this.keyOrdinalPosition - other.keyOrdinalPosition;
        }
        if (comparison == 0) {
            comparison = super.compareTo(obj);
        }
        return comparison;
    }

    @Override
    public ColumnDataType getColumnDataType() {
        return this.column.getColumnDataType();
    }

    @Override
    public int getDecimalDigits() {
        return this.column.getDecimalDigits();
    }

    @Override
    public String getDefaultValue() {
        return this.column.getDefaultValue();
    }

    @Override
    public int getOrdinalPosition() {
        return this.column.getOrdinalPosition();
    }

    @Override
    public Collection<Privilege<Column>> getPrivileges() {
        return this.column.getPrivileges();
    }

    @Override
    public Column getReferencedColumn() {
        return this.column.getReferencedColumn();
    }

    @Override
    public int getSize() {
        return this.column.getSize();
    }

    @Override
    public ColumnDataType getType() {
        return (ColumnDataType)this.column.getType();
    }

    @Override
    public String getWidth() {
        return this.column.getWidth();
    }

    @Override
    public boolean isAutoIncremented() {
        return this.column.isAutoIncremented();
    }

    @Override
    public boolean isColumnDataTypeKnown() {
        return this.column.isColumnDataTypeKnown();
    }

    @Override
    public boolean isGenerated() {
        return this.column.isGenerated();
    }

    @Override
    public boolean isHidden() {
        return this.column.isHidden();
    }

    @Override
    public boolean isNullable() {
        return this.column.isNullable();
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.column.isPartOfForeignKey();
    }

    @Override
    public boolean isPartOfIndex() {
        return this.column.isPartOfIndex();
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.column.isPartOfPrimaryKey();
    }

    @Override
    public boolean isPartOfUniqueIndex() {
        return this.column.isPartOfUniqueIndex();
    }

    public Optional<? extends Privilege<Column>> lookupPrivilege(String name) {
        return this.column.lookupPrivilege(name);
    }

    int getKeyOrdinalPosition() {
        return this.keyOrdinalPosition;
    }

    void setGenerated(boolean isGenerated) {
        if (this.column instanceof MutableColumn) {
            ((MutableColumn)this.column).setGenerated(isGenerated);
        }
    }

    void setKeyOrdinalPosition(int keyOrdinalPosition) {
        this.keyOrdinalPosition = keyOrdinalPosition;
    }
}

