/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.wire.AbstractFbWireService;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireService;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;

public class V10Service
extends AbstractFbWireService
implements FbWireService {
    public V10Service(WireServiceConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public void attach() throws SQLException {
        try {
            this.checkConnected();
            if (this.isAttached()) {
                throw new SQLException("Already attached to a service");
            }
            ServiceParameterBuffer spb = this.protocolDescriptor.createAttachServiceParameterBuffer((WireServiceConnection)this.connection);
            try (LockCloseable ignored = this.withLock();){
                try {
                    try {
                        this.sendAttachToBuffer(spb);
                        this.getXdrOut().flush();
                    }
                    catch (IOException e) {
                        throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
                    }
                    try {
                        this.authReceiveResponse(null);
                    }
                    catch (IOException e) {
                        throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
                    }
                }
                catch (SQLException e) {
                    this.safelyDetach();
                    throw e;
                }
                this.setAttached();
                this.afterAttachActions();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void processAttachResponse(GenericResponse genericResponse) {
    }

    protected void afterAttachActions() throws SQLException {
        this.getServiceInfo((ServiceParameterBuffer)null, this.getDescribeServiceRequestBuffer(), 1024, this.getServiceInformationProcessor());
        ((WireServiceConnection)this.connection).resetSocketTimeout();
    }

    protected void sendAttachToBuffer(ServiceParameterBuffer spb) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(82);
        xdrOut.writeInt(0);
        xdrOut.writeString(((WireServiceConnection)this.connection).getAttachObjectName(), this.getEncoding());
        xdrOut.writeTyped(spb);
    }

    @Override
    protected void internalDetach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    if (this.isAttached()) {
                        xdrOut.writeInt(83);
                        xdrOut.writeInt(this.getHandle());
                    }
                    xdrOut.writeInt(6);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                if (this.isAttached()) {
                    try {
                        this.wireOperations.readResponse(null);
                    }
                    catch (IOException ex) {
                        throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                    }
                }
                try {
                    this.closeConnection();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
            }
            catch (SQLException ex) {
                try {
                    this.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.setDetached();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int maxBufferLength) throws SQLException {
        try {
            Throwable throwable = null;
            try (LockCloseable ignored = this.withLock();){
                this.checkAttached();
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(84);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(0);
                    xdrOut.writeBuffer(serviceParameterBuffer != null ? serviceParameterBuffer.toBytes() : null);
                    xdrOut.writeBuffer(serviceRequestBuffer.toBytes());
                    xdrOut.writeInt(maxBufferLength);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    GenericResponse genericResponse = this.readGenericResponse(null);
                    byte[] byArray = genericResponse.getData();
                    return byArray;
                }
                catch (IOException ex) {
                    try {
                        throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void startServiceAction(ServiceRequestBuffer serviceRequestBuffer) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                xdrOut.writeInt(85);
                xdrOut.writeInt(this.getHandle());
                xdrOut.writeInt(0);
                xdrOut.writeBuffer(serviceRequestBuffer.toBytes());
                xdrOut.flush();
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
            try {
                this.readGenericResponse(null);
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket) throws IOException, SQLException {
        DbCryptCallback dbCryptCallback = ((WireServiceConnection)this.connection).createDbCryptCallback();
        this.wireOperations.authReceiveResponse(acceptPacket, dbCryptCallback, this::processAttachResponse);
    }
}

