/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.field.BlobListenableField;
import org.firebirdsql.jdbc.field.FBCloseableField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBLongVarCharField
extends FBStringField
implements FBCloseableField,
FBFlushableField,
BlobListenableField {
    private static final int BUFF_SIZE = 4096;
    private FBBlob blob;
    private boolean blobExplicitNull;
    private long length;
    private byte[] bytes;
    private InputStream binaryStream;
    private Reader characterStream;
    private FBObjectListener.BlobListener blobListener = FBObjectListener.NoActionBlobListener.instance();
    final FBBlob.Config blobConfig;

    FBLongVarCharField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType, GDSHelper gdsHelper) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.gdsHelper = gdsHelper;
        this.blobConfig = gdsHelper != null ? FBBlob.createConfig(fieldDescriptor, gdsHelper.getConnectionProperties()) : FBBlob.createConfig(fieldDescriptor.getSubType(), true, 16384, fieldDescriptor.getDatatypeCoder());
    }

    @Override
    public void setBlobListener(FBObjectListener.BlobListener blobListener) {
        this.blobListener = blobListener;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        finally {
            this.blob = null;
            this.blobExplicitNull = false;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0L;
            this.blobListener = null;
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        if (this.isNull()) {
            return null;
        }
        this.blob = new FBBlob(this.gdsHelper, this.getDatatypeCoder().decodeLong(this.getFieldData()), this.blobListener, this.blobConfig);
        return this.blob;
    }

    @Override
    public Clob getClob() throws SQLException {
        FBBlob blob = (FBBlob)this.getBlob();
        if (blob == null) {
            return null;
        }
        return new FBClob(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        try (InputStream in = blob.getBinaryStream();){
            int counter;
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            while ((counter = in.read(buff)) != -1) {
                bout.write(buff, 0, counter);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException ioex) {
            SQLException conversionException = this.invalidGetConversion("bytes[]", ioex.getMessage());
            conversionException.initCause(ioex);
            throw conversionException;
        }
    }

    @Override
    public byte[] getCachedData() throws SQLException {
        if (this.isNull()) {
            return this.bytes;
        }
        return this.getBytes();
    }

    @Override
    public FBFlushableField.CachedObject getCachedObject() throws SQLException {
        if (this.isNull()) {
            return new FBFlushableField.CachedObject(this.bytes, this.binaryStream, this.characterStream, this.length);
        }
        byte[] bytes = this.getBytes();
        return new FBFlushableField.CachedObject(bytes, null, null, bytes.length);
    }

    @Override
    public void setCachedObject(FBFlushableField.CachedObject cachedObject) {
        this.setNull();
        this.bytes = cachedObject.bytes;
        this.binaryStream = cachedObject.binaryStream;
        this.characterStream = cachedObject.characterStream;
        this.length = cachedObject.length;
        this.blobExplicitNull = this.bytes == null && this.binaryStream == null && this.characterStream == null;
    }

    @Override
    public String getString() throws SQLException {
        byte[] data = this.getBytes();
        if (data == null) {
            return null;
        }
        return this.applyTrimTrailing(this.getDatatypeCoder().decodeString(data));
    }

    @Override
    public void setBlob(FBBlob blob) throws SQLException {
        this.setNull();
        if (blob != null) {
            this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
            this.blob = blob;
            this.blobExplicitNull = false;
        }
    }

    @Override
    public void setBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull();
        } else if (blob instanceof FBBlob) {
            this.setBlob((FBBlob)blob);
        } else {
            FBBlob fbb = this.createBlob();
            fbb.copyStream(blob.getBinaryStream());
            this.setBlob(fbb);
        }
    }

    @Override
    FBBlob createBlob() {
        return new FBBlob(this.gdsHelper, this.blobListener, this.blobConfig);
    }

    @Override
    public void setClob(FBClob clob) throws SQLException {
        this.setBlob(clob != null ? clob.getWrappedBlob() : null);
    }

    @Override
    public void setClob(Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull();
        } else if (clob instanceof FBClob) {
            this.setClob((FBClob)clob);
        } else {
            FBClob fbc = this.createClob();
            fbc.copyCharacterStream(clob.getCharacterStream());
            this.setClob(fbc);
        }
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) {
        this.setNull();
        if (in != null) {
            this.characterStream = in;
            this.length = length;
            this.blobExplicitNull = false;
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setNull();
        if (value != null) {
            this.setBytes(this.getDatatypeCoder().encodeString(value));
        }
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setNull();
        if (value != null) {
            this.bytes = value;
            this.length = value.length;
            this.blobExplicitNull = false;
        }
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) {
        this.setNull();
        if (in != null) {
            this.binaryStream = in;
            this.length = length;
            this.blobExplicitNull = false;
        }
    }

    @Override
    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length);
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, (int)this.length);
        } else if (this.blob == null && this.blobExplicitNull) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0L;
    }

    @Override
    public void setNull() {
        super.setNull();
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.blob = null;
            this.blobExplicitNull = true;
            this.binaryStream = null;
            this.characterStream = null;
            this.bytes = null;
            this.length = 0L;
        }
    }

    private void copyBinaryStream(InputStream in, long length) throws SQLException {
        FBBlob blob = this.createBlob();
        blob.copyStream(in, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blobExplicitNull = false;
    }

    private void copyCharacterStream(Reader in, long length) throws SQLException {
        FBClob clob = this.createClob();
        clob.copyCharacterStream(in, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(clob.getWrappedBlob().getBlobId()));
        this.blobExplicitNull = false;
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = this.createBlob();
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blobExplicitNull = false;
    }
}

