/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import oracle.jdbc.diagnostics.EncryptionStream;
import oracle.jdbc.diagnostics.MessageFormatUtils;
import oracle.jdbc.diagnostics.Releaser;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.diagnostics.SecuredLoggerImpl;
import oracle.jdbc.internal.Monitor;

final class SecuredFileLogHandler
extends StreamHandler
implements Monitor {
    private static final int MAX_LOCKS = 100;
    private static final ConcurrentHashMap<String, String> locks;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private MeteredStream meter;
    private final boolean append = false;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileChannel lockFileChannel;
    private File[] files;
    private X509Certificate certificate;
    private final String loggerId;
    private boolean isOpen = true;
    private Properties userProperties = null;
    private final SecuredLoggerImpl securedLogger;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    SecuredFileLogHandler(SecuredLoggerImpl securedLogger) throws RuntimeException {
        this.securedLogger = securedLogger;
        this.loggerId = securedLogger.getId();
        this.certificate = securedLogger.getCertificate();
        this.userProperties = securedLogger.getUserProperties();
        this.setFormatter(new SimpleFormatter());
        this.setFilter(SecuredLogger.DEFAULT_FILTER);
        this.setLevel(securedLogger.getLogLevel());
        this.configure();
        try {
            this.openFiles();
        }
        catch (IOException e2) {
            this.reportError(null, e2, 0);
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg) {
        if (this.isOpen) {
            this.publishLogRecordToFile(logLevel, eventId, logTime, className, methodName, debugMsg, new Object[0]);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Releaser releaser) {
        if (this.isOpen) {
            this.publishLogRecordToFile(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Releaser releaser) {
        if (this.isOpen) {
            this.publishLogRecordToFile(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Releaser releaser) {
        if (this.isOpen) {
            this.publishLogRecordToFile(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Object debugMsgParam4, Releaser releaser) {
        if (this.isOpen) {
            this.publishLogRecordToFile(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, debugMsgParam4);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Releaser releaser, Object ... debugMsgParams) {
        if (this.isOpen) {
            this.publishLogRecordToFile(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParams);
        }
    }

    private void publishLogRecordToFile(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object ... debugMsgParams) {
        LogRecord logRecord = new LogRecord(logLevel, debugMsg);
        logRecord.setSequenceNumber(eventId);
        logRecord.setSourceClassName(className);
        logRecord.setSourceMethodName(methodName);
        logRecord.setThreadID((int)Thread.currentThread().getId());
        logRecord.setMillis(logTime);
        if (debugMsgParams != null && debugMsgParams.length > 0) {
            logRecord.setParameters(MessageFormatUtils.formatLogParams(debugMsgParams));
        }
        this.publish(logRecord);
    }

    private void configure() {
        String cname = SecuredLogger.class.getName();
        String logLocation = SecuredLogger.getStringProperty(cname + ".logLocation", SecuredLogger.DEFAULT_LOG_LOCATION, this.userProperties);
        this.pattern = SecuredLogger.getStringProperty(cname + ".pattern", logLocation + "/jdbc_%u.log", this.userProperties);
        this.limit = SecuredLogger.getIntProperty(cname + ".limit", 0, this.userProperties);
        if (this.limit < 0) {
            this.limit = 0;
        }
        this.count = SecuredLogger.getIntProperty(cname + ".count", 1, this.userProperties);
        if (this.count <= 0) {
            this.count = 1;
        }
        this.setFilter(SecuredLogger.getFilterProperty(cname + ".filter", SecuredLogger.DEFAULT_FILTER, this.userProperties));
        this.setFormatter(SecuredLogger.getFormatterProperty(cname + ".formatter", new SimpleFormatter(), this.userProperties));
        try {
            this.setEncoding(SecuredLogger.getStringProperty(cname + ".encoding", null, this.userProperties));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    private void openFiles() throws IOException {
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        int unique = -1;
        while (true) {
            boolean available;
            if (++unique > 100) {
                throw new IOException("Couldn't get lock for " + this.pattern);
            }
            this.lockFileName = this.generate(this.pattern, 0, unique).toString() + ".lck";
            if (locks.get(this.lockFileName) != null) continue;
            try {
                this.lockFileChannel = FileChannel.open(Paths.get(this.lockFileName, new String[0]), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
            catch (FileAlreadyExistsException ix) {
                continue;
            }
            try {
                available = this.lockFileChannel.tryLock() != null;
            }
            catch (IOException ix) {
                available = true;
            }
            if (available) break;
            this.lockFileChannel.close();
        }
        locks.put(this.lockFileName, this.lockFileName);
        this.files = new File[this.count];
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.files[i2] = this.generate(this.pattern, i2, unique);
        }
        this.rotate();
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = word + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = word + "_" + this.loggerId + "_" + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (this.count > 1 && !sawg) {
            word = word + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = word + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private void rotate() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Level oldLevel = this.getLevel();
            this.setLevel(Level.OFF);
            super.close();
            for (int i2 = this.count - 2; i2 >= 0; --i2) {
                File f1 = this.files[i2];
                File f2 = this.files[i2 + 1];
                if (!f1.exists()) continue;
                if (f2.exists()) {
                    f2.delete();
                }
                f1.renameTo(f2);
            }
            try {
                this.open(this.files[0], false);
            }
            catch (IOException ix) {
                this.reportError(null, ix, 4);
            }
            this.setLevel(oldLevel);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            super.publish(record);
            this.flush();
            if (this.limit > 0 && this.meter.written >= this.limit) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public Object run() {
                        SecuredFileLogHandler.this.rotate();
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(SecuredFileLogHandler.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            super.close();
            if (this.lockFileName == null) {
                return;
            }
            try {
                this.lockFileChannel.close();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 3);
            }
            locks.remove(this.lockFileName);
            new File(this.lockFileName).delete();
            this.lockFileName = null;
            this.lockFileChannel = null;
        }
    }

    public void reset() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.close();
            this.openFiles();
        }
        catch (Exception e2) {
            this.reportError(null, e2, 0);
        }
    }

    public void disable() {
        this.close();
    }

    public void enable() {
        this.reset();
    }

    static {
        try {
            $$$methodRef$$$20 = SecuredFileLogHandler.class.getDeclaredConstructor(SecuredLoggerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = SecuredFileLogHandler.class.getDeclaredMethod("access$100", SecuredFileLogHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SecuredFileLogHandler.class.getDeclaredMethod("access$000", SecuredFileLogHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SecuredFileLogHandler.class.getDeclaredMethod("enable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SecuredFileLogHandler.class.getDeclaredMethod("disable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SecuredFileLogHandler.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SecuredFileLogHandler.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SecuredFileLogHandler.class.getDeclaredMethod("publish", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SecuredFileLogHandler.class.getDeclaredMethod("rotate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SecuredFileLogHandler.class.getDeclaredMethod("generate", String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SecuredFileLogHandler.class.getDeclaredMethod("openFiles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SecuredFileLogHandler.class.getDeclaredMethod("open", File.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SecuredFileLogHandler.class.getDeclaredMethod("configure", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SecuredFileLogHandler.class.getDeclaredMethod("publishLogRecordToFile", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SecuredFileLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Releaser.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SecuredFileLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SecuredFileLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SecuredFileLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SecuredFileLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SecuredFileLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SecuredFileLogHandler.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        locks = new ConcurrentHashMap();
    }

    private class MeteredStream
    extends OutputStream {
        final OutputStream out;
        int written;
        private EncryptionStream encStream;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
            try {
                this.encStream = EncryptionStream.newEncryptionStream(out, SecuredFileLogHandler.this.certificate);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void write(int b2) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.encStream.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.encStream.write(Arrays.copyOfRange(buff, off, off + len));
        }

        @Override
        public void flush() throws IOException {
            this.encStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.encStream.close();
        }

        static {
            try {
                $$$methodRef$$$5 = MeteredStream.class.getDeclaredConstructor(SecuredFileLogHandler.class, OutputStream.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = MeteredStream.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = MeteredStream.class.getDeclaredMethod("flush", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = MeteredStream.class.getDeclaredMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = MeteredStream.class.getDeclaredMethod("write", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = MeteredStream.class.getDeclaredMethod("write", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

