!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_kij
!! NAME
!! calc_kij
!! 
!! FUNCTION
!! Compute kij terms:
!!  kij=<phi_i|T|phi_j>-<tphi_i|T|tphi_j>
!!  where T is the kinetic operator
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  pawdata
!!    %indlmn(6,lmn_size)= Gives l,m,n,ln,lm,s for i=lmn
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!    %tphi(wav_meshsz,basis_size)= atomic pseudo partial waves
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %lmn_size= Number of elements for the paw basis
!!    %log_step= Logarithmic step corresponding to radial mesh
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!
!! OUTPUT
!!  pawarray
!!    %kij(lmn2_size)= Kinetic overlap operator
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      ctrap,laplacian
!!
!! SOURCE

 subroutine calc_kij(pawarray,pawdata,pawps,pshead)

 use defs_basis
 use defs_pawps

 implicit none
 
!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ib,ilm,ilmn,iln,jlm,jlmn,jln,j0lmn,klmn,meshsz
 real(dp) :: intg,tintg
 real(dp), allocatable :: chi(:,:),ff(:),tchi(:,:),tff(:),&
&                         y1(:),y2(:),ty1(:),ty2(:)

!--------------------------------------------------------

 meshsz=pshead%sph_meshsz

!First, compute |chi_i>=T|phi_i>
!---------------------------------
 allocate(chi (meshsz,pshead%basis_size))
 allocate(tchi(meshsz,pshead%basis_size))
 allocate(y1(meshsz-1),ty1(meshsz-1))
 allocate(y2(meshsz-1),ty2(meshsz-1))
 do ib=1,pshead%basis_size
  chi(1,ib)=zero;tchi(1,ib)=zero
  call laplacian(meshsz-1,pshead%log_step,pshead%orbitals(ib),&
&                pawdata%rad(2:meshsz),pawps%phi (2:meshsz,ib),&
&                chi (2:meshsz,ib),y1 ,y2 ,pawdata%rad_(2:meshsz))
  call laplacian(meshsz-1,pshead%log_step,pshead%orbitals(ib),&
&                pawdata%rad(2:meshsz),pawps%tphi(2:meshsz,ib),&
&                tchi(2:meshsz,ib),ty1,ty2,pawdata%rad_(2:meshsz))
 enddo
 deallocate(y1,ty1,y2,ty2)

!Now, compute calculate kij=<phi_i|T|phi_j>
!------------------------------------------
 allocate(ff(meshsz),tff(meshsz))
 pawarray%kij=zero
 do jlmn=1,pshead%lmn_size
  j0lmn=jlmn*(jlmn-1)/2
  jlm=pawdata%indlmn(4,jlmn);jln=pawdata%indlmn(5,jlmn)
  do ilmn=1,jlmn
   klmn=j0lmn+ilmn
   ilm=pawdata%indlmn(4,ilmn);iln=pawdata%indlmn(5,ilmn)
   if (jlm==ilm) then
    ff(1:meshsz)=pawps%phi(1:meshsz,iln)*chi(1:meshsz,jln)&
&               *pawdata%rad_(1:meshsz)
    call ctrap(meshsz,ff,pshead%log_step,intg)
    tff(1:meshsz)=pawps%tphi(1:meshsz,iln)*tchi(1:meshsz,jln)&
&                *pawdata%rad_(1:meshsz)
    call ctrap(meshsz,tff,pshead%log_step,tintg)
    pawarray%kij(klmn)=tintg-intg
   endif
  enddo
 enddo
 deallocate(ff,tff)

 deallocate(chi,tchi)

 pawarray%kij=pawarray%kij*0.5d0   ! Translate from Rydberg to Hartree

 end subroutine
!!***
