#!/bin/bash

find . -type f \( -name "*.yaml" -o -name "*.yml" \) | while read -r file; do
    echo "Processing: $file"

    # Generated by other tools, ignored by kubernetes
    yq -iY 'del(.metadata.annotations)' "$file"
    # Generated values, readonly
    yq -iY 'del(.metadata.creationTimestamp)' "$file"
    yq -iY 'del(.metadata.generation)' "$file"
    yq -iY 'del(.metadata.uid)' "$file"
    # Only needed for a client to request changes applied after resourceVersion xyz.
    yq -iY 'del(.metadata.resourceVersion)' "$file"
    # Kubernetes uses this to keep track of who has last modified a certain field
    yq -iY 'del(.metadata.managedFields)' "$file"

    # Generated by other tools, ignored by kubernetes
    yq -iY 'del(.spec.template.metadata.annotations)' "$file"
    # Generated values, readonly
    yq -iY 'del(.spec.template.metadata.creationTimestamp)' "$file"

    # Only contains a soft rule
    yq -iY 'del(.spec.template.spec.affinity)' "$file"

    # Readonly
    yq -iY 'del(.status)' "$file"

    yamlfmt "$file"
done
