//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_12.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root12(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[12] = {6.117598184216843e-01,1.157225588468522e-01,1.512616040532386e+00,2.833762148836217e+00,4.599245186127769e+00,
    6.844551566179677e+00,9.621353549856169e+00,1.300610461485263e+01,1.711692049382484e+01,2.215117489462539e+01,2.848807594654846e+01,3.709926260045671e+01
    };
  constexpr double aw[12] = {1.888803584880023e-01,1.323661905077027e-01,1.220414711938146e-01,4.522478359825252e-02,1.005122890789416e-02,
    1.331991849510925e-03,1.016161836761476e-04,4.182543866858831e-06,8.342501162049512e-08,6.711980709414892e-10,1.530806643037629e-12,4.074054225872852e-16
    };
  constexpr double x[6324] = {  8.556059077382223e-03,  1.774548803092799e-04,  2.747996582493804e-06,  3.760480783549002e-08,  4.787861644833646e-10,
  5.798061638560898e-12,  6.749347740287941e-14,  7.591936191192867e-16,  8.267230100357389e-18,  8.710926722882186e-20,  8.853651385109047e-22,  8.625525090814263e-24,
  7.605297891760691e-02,  1.521713724288045e-03,  2.190698811364138e-05,  2.639181632755442e-07,  2.722978429450082e-09,  2.318327973613955e-11,  1.367331269842075e-13,
 -7.069330236121908e-17, -1.781602701209171e-17, -3.385839364361933e-19, -4.379922693991793e-21, -4.236582609389194e-23,  2.060784478219854e-01,  3.834119424530152e-03,
  4.719641829807553e-05,  4.127354656824435e-07,  1.845441738692819e-09, -1.587311626280156e-11, -4.761199209612000e-13, -5.762393494352465e-15, -3.119195559371445e-17,
  2.969784468881680e-19,  9.804346576080830e-21,  1.265207571106243e-22,  3.891859702259681e-01,  6.476822547494824e-03,  6.086310858813063e-05,  2.150191365067702e-07,
 -3.462307339225081e-09, -6.624118742379169e-11, -3.623202915701119e-13,  4.816008388776045e-15,  1.169397521765660e-16,  7.846708560260753e-19, -8.559692698771566e-21,
 -2.474530648808681e-22,  6.123419957228243e-01,  8.738117225393686e-03,  5.144867363106200e-05, -2.591717533695847e-07, -7.050795255635951e-09, -2.055477136878286e-11,
  8.138566284352867e-13,  9.523817502575851e-15, -5.167896962716959e-17, -2.002099871668211e-18, -7.885022195897030e-21,  2.864864822714845e-22,  8.600700617306810e-01,
  1.003078784038841e-02,  2.049122941957932e-05, -6.511630153883829e-07, -3.664744957937888e-09,  7.234643057218197e-11,  7.009146783892020e-13, -9.160053982593010e-15,
 -1.377718187657145e-16,  1.168238909325900e-18,  2.731178977927583e-20, -1.333902680592506e-22,  1.115687235068283e+00,  1.004167174589815e-02, -1.878079860396946e-05,
 -6.505584220685429e-07,  3.484163510143752e-09,  7.174875005535634e-11, -6.767926453311028e-13, -8.953831783155386e-15,  1.334118856020631e-16,  1.112836108742879e-18,
 -2.634674226512067e-20, -1.202173424980655e-22,  1.362497442115990e+00,  8.796503550665708e-03, -4.923957112140425e-05, -2.722961532951759e-07,  6.752748495671405e-09,
 -1.682297332638434e-11, -7.792279596450599e-13,  8.561262578513876e-15,  5.134606994438264e-17, -1.798556032704780e-18,  6.347783374690273e-21,  2.555258016658064e-22,
  1.584850881378570e+00,  6.633649032574436e-03, -5.913144640127139e-05,  1.773300302763918e-07,  3.573054974358989e-09, -6.088600148492698e-11,  2.751507979802994e-13,
  4.932007294781904e-15, -1.016901587741328e-16,  5.546136812959840e-19,  8.712121374018638e-21, -2.035329315957882e-22,  1.769023764631177e+00,  4.104620609738037e-03,
 -4.774239585955345e-05,  3.830975267907948e-07, -1.297136759140932e-09, -2.014028658559798e-11,  4.566096421774162e-13, -4.677266403175549e-15,  1.514338994127665e-17,
  3.947484616213990e-19, -8.705790671596403e-21,  8.852458213613385e-23,  1.903907851181143e+00,  1.832947961978168e-03, -2.493745534158105e-05,  2.797156264037498e-07,
 -2.612880953803549e-09,  1.876701817498411e-11, -6.409197907923681e-14, -8.912931482389985e-16,  2.366638381327892e-17, -3.333545619300723e-19,  3.350580960890637e-21,
 -2.139119828254824e-23,  1.981538051926155e+00,  3.659601514581047e-04, -5.392352994950001e-06,  6.977071685060158e-08, -8.330486626600046e-10,  9.358406597356602e-12,
 -9.962579076979213e-14,  1.004942214998708e-15, -9.540395527126229e-18,  8.383520247047300e-20, -6.565280137238929e-22,  4.122084126934668e-24,  9.312900749337077e-03,
  2.013835366441958e-04,  3.249350690417629e-06,  4.628889284218787e-08,  6.128354299738887e-10,  7.706050131120255e-12,  9.297943798368643e-14,  1.081570167737545e-15,
  1.214333905135929e-17,  1.313772658367335e-19,  1.362896498882429e-21,  1.342523374983555e-23,  8.251149693690765e-02,  1.710414739567009e-03,  2.535128555838721e-05,
  3.113714540155373e-07,  3.218914198244911e-09,  2.636413335821711e-11,  1.246764980207760e-13, -8.734979518948383e-16, -3.363916517834458e-17, -5.544357863233027e-19,
 -6.486297808228557e-21, -5.228309886725398e-23,  2.222021075257509e-01,  4.231975592527656e-03,  5.231376446349476e-05,  4.390452425966217e-07,  1.400111282033916e-09,
 -2.933608441371359e-11, -6.492283931361899e-13, -6.502381146097783e-15, -1.202395790217313e-17,  8.083662853100205e-19,  1.589429860931589e-20,  1.434659908163249e-22,
  4.160819457832517e-01,  6.973003090574187e-03,  6.306585135919798e-05,  1.486049261742216e-07, -4.860879503471670e-09, -7.287265757058559e-11, -1.714381316804827e-13,
  8.921223008262269e-15,  1.361859984153393e-16,  2.019421919579836e-19, -2.099463979427418e-20, -3.032865299853223e-22,  6.480952068666510e-01,  9.135324639175170e-03,
  4.765184557296077e-05, -3.741255361576818e-07, -7.246219249717921e-09,  1.922813156442938e-12,  1.046260018024021e-12,  6.683732167420504e-15, -1.259344634005618e-16,
 -2.016243087861053e-18,  8.213193425524355e-21,  4.265722793939801e-22,  9.004703290052077e-01,  1.016258047770724e-02,  1.237590840946351e-05, -6.974051108041776e-07,
 -2.072755304877660e-09,  8.563845360419465e-11,  3.904487577026993e-13, -1.270091057624966e-14, -7.813364147710691e-17,  2.070956199321138e-18,  1.618159160740548e-20,
 -3.567210272242489e-22,  1.155505460842303e+00,  9.861249183075684e-03, -2.620873569498165e-05, -5.842907035621616e-07,  4.739024196642870e-09,  5.300922639476210e-11,
 -8.631973443948041e-13, -4.253044134871616e-15,  1.538904653806437e-16,  2.536307303867027e-20, -2.630524446833903e-20,  1.142733119527333e-22,  1.396877480205798e+00,
  8.391321756995683e-03, -5.187302661975093e-05, -1.678758677840429e-07,  6.249404922518199e-09, -3.251977605286254e-11, -5.257806554239830e-13,  9.236497917198734e-15,
 -6.559366671454968e-18, -1.367979655635485e-18,  1.397837867265321e-20,  9.174662372953554e-23,  1.610454104676006e+00,  6.169991165247719e-03, -5.669938236153086e-05,
  2.251565400004298e-07,  2.430742251964892e-09, -5.297249861926759e-11,  3.710751534164926e-13,  2.048293581821022e-15, -7.742894131533768e-17,  7.441703170841440e-19,
  1.302497096882822e-21, -1.305966241800064e-22,  1.784706950295523e+00,  3.740690341561434e-03, -4.328123350826642e-05,  3.596729153968628e-07, -1.600633651176800e-09,
 -1.068754558942660e-11,  3.341306463963913e-13, -4.025126408187011e-15,  2.398786047039183e-17,  1.201171532263283e-19, -5.159659297403291e-21,  7.047279856232554e-23,
  1.910860935665557e+00,  1.646191912234285e-03, -2.181960865907908e-05,  2.408215993480709e-07, -2.254545674882430e-09,  1.700470425063429e-11, -8.007601901533393e-14,
 -3.019552382777886e-16,  1.385177512663951e-17, -2.180103701652742e-19,  2.430006218194165e-21, -1.964928662741556e-23,  1.982920615313955e+00,  3.259571585150629e-04,
 -4.629296614408857e-06,  5.781835166540433e-08, -6.676786008444764e-10,  7.273166204235475e-12, -7.534192412257363e-14,  7.432139263139392e-16, -6.953031917330206e-18,
  6.100864533555932e-20, -4.900991648441863e-22,  3.402339118138209e-24,  1.017419429320973e-02,  2.297794557133216e-04,  3.869158509629388e-06,  5.745961937500669e-08,
  7.919714463383820e-10,  1.034965148874766e-11,  1.294968856594292e-13,  1.557619722045311e-15,  1.801390137480142e-17,  1.996513072229790e-19,  2.104131493541478e-21,
  2.076189855272291e-23,  8.978373086000198e-02,  1.929087477180178e-03,  2.941465718894122e-05,  3.672441618913578e-07,  3.773424338716011e-09,  2.892088929534672e-11,
  8.176428217958039e-14, -2.323924207032724e-15, -5.882837811161226e-17, -8.601354596730555e-19, -8.762255483268112e-21, -4.681770662546717e-23,  2.400008691134259e-01,
  4.671890309867826e-03,  5.769444372127917e-05,  4.558443606986997e-07,  6.427337257880959e-10, -4.711426854074100e-11, -8.313623389692005e-13, -6.286867868965881e-15,
  2.997551156017256e-17,  1.561710261253549e-18,  2.138071854870498e-20,  8.838976123785652e-23,  4.449922918546190e-01,  7.483229017562399e-03,  6.433389938224587e-05,
  5.904148738808767e-08, -6.336694094860141e-09, -7.349691126105971e-11,  1.391553154954603e-13,  1.320771861151813e-14,  1.251993760566988e-16, -8.940046783103986e-19,
 -3.321915592147141e-20, -2.218077963750176e-22,  6.853677342247808e-01,  9.496622472706535e-03,  4.247254286924424e-05, -4.883384639978156e-07, -6.944128714901543e-09,
  2.875953142804969e-11,  1.166742454793469e-12,  1.593287845827533e-15, -1.879934570925345e-16, -1.305504377027530e-18,  2.711169501865850e-20,  3.964562297159970e-22,
  9.412650417576833e-01,  1.022768137079550e-02,  3.865892594931384e-06, -7.164829739157698e-07, -2.962383484643390e-10,  9.053173507648252e-11,  1.172824487512215e-14,
 -1.391646474271188e-14,  3.943628026554497e-18,  2.369009982912479e-18, -1.813337705210243e-21, -4.293848816151219e-22,  1.194488628316837e+00,  9.624895458813414e-03,
 -3.273402451660994e-05, -5.011409851524454e-07,  5.585249463132674e-09,  3.141382255382311e-11, -9.145772864676408e-13,  4.960250952062070e-16,  1.375533889225044e-16,
 -8.755248192250257e-19, -1.770673350046507e-20,  2.554349172805732e-22,  1.429602369760633e+00,  7.969925888964620e-03, -5.331104007076337e-05, -7.368721008922301e-08,
  5.493469280216523e-09, -4.210026660893464e-11, -2.766985932896791e-13,  8.351849762704946e-15, -4.516059492238201e-17, -7.703022498817161e-19,  1.496391430158964e-20,
 -3.706248314375534e-23,  1.634244822419494e+00,  5.727787485177752e-03, -5.379750520365760e-05,  2.560714792961102e-07,  1.463654383223399e-09, -4.363359129585691e-11,
  3.977798272161087e-13, -6.406028781256909e-19, -5.088394336657438e-17,  7.033282592930691e-19, -2.827404208084451e-21, -5.988341307940077e-23,  1.799003914347629e+00,
  3.411255802999474e-03, -3.912456262553493e-05,  3.327517557251875e-07, -1.742861679014563e-09, -3.931398432437373e-12,  2.325728496041529e-13, -3.222509151709652e-15,
  2.528130850633384e-17, -3.119054146385396e-20, -2.577165122457608e-21,  4.707005070677179e-23,  1.917114059481415e+00,  1.482606401138101e-03, -1.913530686315863e-05,
  2.073631420176102e-07, -1.934124268910714e-09,  1.502488908095615e-11, -8.338074258858116e-14,  3.286732389021423e-17,  7.555588303304623e-18, -1.368818812216497e-19,
  1.658560442144576e-21, -1.527486960813252e-23,  1.984154526820450e+00,  2.915269081926651e-04, -3.995073196972414e-06,  4.820760255297276e-08, -5.387335259424514e-10,
  5.691438849249218e-12, -5.734206264938721e-14,  5.523529264247494e-16, -5.075673585203502e-18,  4.416198633059198e-20, -3.580134903358063e-22,  2.611348151686243e-24,
  1.115991191880916e-02,  2.637231090148098e-04,  4.642124501553651e-06,  7.197206226965465e-08,  1.033943502455457e-09,  1.405334449919679e-11,  1.823879582206456e-13,
  2.267262466641815e-15,  2.696234486860699e-17,  3.049795499227825e-19,  3.240533871798090e-21,  3.151216351185362e-23,  9.800013351105660e-02,  2.183103351611091e-03,
  3.420319851552612e-05,  4.323265724307819e-07,  4.364964991006292e-09,  2.985854947058683e-11, -1.481887538338360e-14, -4.773014833776445e-15, -9.651318718607717e-17,
 -1.241602575688851e-18, -9.943753481461004e-21,  4.553751631057082e-24,  2.596463287943395e-01,  5.155422268806319e-03,  6.319151412714159e-05,  4.574485443903456e-07,
 -5.125346242701934e-10, -6.901296680876589e-11, -9.843047910511052e-13, -4.257946588098113e-15,  1.021331079916033e-16,  2.448869321840458e-18,  2.152606992880595e-20,
 -1.118741859703974e-22,  4.759564591733689e-01,  7.998900742561021e-03,  6.438651657570095e-05, -5.379025710891526e-08, -7.741101123200818e-09, -6.530598004618374e-11,
  5.583020760773196e-13,  1.642748391191169e-14,  6.735344197819338e-17, -2.347995587655007e-18, -3.734698973633587e-20,  7.058285801193158e-23,  7.239940746491428e-01,
  9.811127389450915e-03,  3.596976550539159e-05, -5.933191046015980e-07, -6.088974011376519e-09,  5.658175520235047e-11,  1.121742407146474e-12, -4.934289252724050e-15,
 -2.117785780086685e-16,  6.855423210584036e-20,  3.973638707108268e-20,  1.432689919145045e-22,  9.821832358149180e-01,  1.022427380634209e-02, -4.700900686715393e-06,
 -7.068536472931101e-07,  1.486051966730460e-09,  8.622894572714793e-11, -3.636538654951471e-13, -1.247559984793760e-14,  8.354811176574257e-17,  1.940898205176089e-18,
 -1.871522680788296e-20, -3.102576563828853e-22,  1.232428577043838e+00,  9.340527742316460e-03, -3.819462889939917e-05, -4.079301365984575e-07,  5.997583371855295e-09,
  1.009457707603545e-11, -8.446455746800440e-13,  4.279622116958916e-15,  9.612075876835965e-17, -1.346948511168213e-18, -5.793795060911015e-21,  2.658075338577796e-22,
  1.460625519083647e+00,  7.541328851153738e-03, -5.369665895179228e-05,  7.187723996734169e-09,  4.603060290883329e-09, -4.611971255705921e-11, -6.644994367010138e-14,
  6.573856179625167e-15, -6.273172892411603e-17, -2.276946669405815e-19,  1.171059626557518e-20, -9.985272629788032e-23,  1.656315152541198e+00,  5.310034023019189e-03,
 -5.061126192834300e-05,  2.730242543810120e-07,  6.855934244409568e-10, -3.424858076594097e-11,  3.785917832657816e-13, -1.249791643538299e-15, -2.808489972707663e-17,
  5.536507818244318e-19, -4.302673467809995e-21, -1.130583764355083e-23,  1.812047558857828e+00,  3.113753176830602e-03, -3.530054851959092e-05,  3.045111669985252e-07,
 -1.772515048103538e-09,  6.573485268426665e-13,  1.533795667476287e-13, -2.447695360584602e-15,  2.274501534266113e-17, -9.903926873960349e-20, -9.582750424376222e-22,
  2.746457897621533e-23,  1.922753366295317e+00,  1.338973430038529e-03, -1.682305894267491e-05,  1.787131578475781e-07, -1.653439878626860e-09,  1.305798916307575e-11,
 -7.973228960973720e-14,  2.073720828023729e-16,  3.672225314579270e-18, -8.264908607152295e-20,  1.085041778063705e-21, -1.089838470114019e-23,  1.985260181010186e+00,
  2.617419420332897e-04, -3.464772635965975e-06,  4.042866838629144e-08, -4.375030706563922e-10,  4.483841809825577e-12, -4.392954434323483e-14,  4.128167528772476e-16,
 -3.717857032653234e-18,  3.192879004668986e-20, -2.586035337935655e-22,  1.931193186370009e-24,  1.229497550697109e-02,  3.046190176873141e-04,  5.615156939999915e-06,
  9.102500499023899e-08,  1.364476061838974e-09,  1.930106220909994e-11,  2.597961978465030e-13,  3.333688726612708e-15,  4.064483457159082e-17,  4.663201800722127e-19,
  4.930948530663789e-21,  4.581187020127117e-23,  1.073143904305568e-01,  2.478712892126103e-03,  3.982965759300439e-05,  5.068717829600013e-07,  4.945765490294266e-09,
  2.750617099138336e-11, -1.989563845966836e-13, -8.651014158218639e-15, -1.480133744242779e-16, -1.599582973963979e-18, -6.823772843649412e-21,  1.614126213092991e-22,
  2.813135023563514e-01,  5.682659093332914e-03,  6.858189470113677e-05,  4.368895899515287e-07, -2.136409232960007e-09, -9.361058210434070e-11, -1.043417768630806e-12,
  5.715553949402977e-16,  2.036963871094382e-16,  3.108804077340687e-18,  8.569343484820620e-21, -5.092384353446419e-22,  5.089750618149164e-01,  8.509211618608960e-03,
  6.295757958020759e-05, -1.872091339405358e-07, -8.875080083716689e-09, -4.623166987888444e-11,  1.033754901136906e-12,  1.695562050185176e-14, -4.216124135774613e-17,
 -3.651208711708636e-18, -2.443536284535915e-20,  5.305981579771028e-22,  7.637667950477092e-01,  1.006884521447710e-02,  2.830731571071287e-05, -6.802874692346076e-07,
 -4.703219156240150e-09,  8.109329525557753e-11,  8.913033706378114e-13, -1.135909705088552e-14, -1.801734216639492e-16,  1.674048146989936e-18,  3.770517216301519e-20,
 -2.421208633655028e-22,  1.022952134628434e+00,  1.015326925416857e-02, -1.298541817317327e-05, -6.698669502288606e-07,  3.096873868023270e-09,  7.367036602893048e-11,
 -6.662031349173493e-13, -8.851474415887014e-15,  1.372423681490530e-16,  9.848045752941411e-19, -2.734526905513938e-20, -7.303994235696411e-23,  1.269150885822296e+00,
  9.017029820800646e-03, -4.251080279777694e-05, -3.114086780475547e-07,  6.008068278908351e-09, -8.437247896670231e-12, -6.892353703993889e-13,  6.556697232269960e-15,
  4.610474233982178e-17, -1.364818863314284e-18,  4.281472717607850e-21,  1.819810622508553e-22,  1.489933909012981e+00,  7.113282251650315e-03, -5.319907114683222e-05,
  7.342931894757747e-08,  3.678434151446618e-09, -4.573709563186718e-11,  8.887476096428640e-14,  4.516723683531683e-15, -6.360914165077071e-17,  1.477076527543758e-19,
  7.016748885976351e-21, -1.061619584534763e-22,  1.676766456879868e+00,  4.918386657093762e-03, -4.729019521557072e-05,  2.789941589041983e-07,  8.819823896235966e-11,
 -2.566664726496978e-11,  3.337723092676971e-13, -1.863229020793893e-15, -1.128698399873622e-17,  3.805455532296597e-19, -4.169330996105214e-21,  1.397367746473213e-23,
  1.823960227811859e+00,  2.845485389366667e-03, -3.181555443881022e-05,  2.764342422301620e-07, -1.727698065451398e-09,  3.594772933678956e-12,  9.445745430847939e-14,
 -1.782209186258589e-15,  1.873978008224137e-17, -1.176286055875379e-19, -6.985175850334165e-23,  1.390416515290239e-23,  1.927853063681751e+00,  1.212536637736085e-03,
 -1.482894389517165e-05,  1.542456077886112e-07, -1.410887545311415e-09,  1.122489827638539e-11, -7.267338867763181e-14,  2.847836652162893e-16,  1.372737487744721e-18,
 -4.772976148026537e-20,  6.865981114880360e-22, -7.373980176902042e-24,  1.986254625533239e+00,  2.358517980355711e-04, -3.018844948641684e-06,  3.409245089836214e-08,
 -3.574982763239477e-10,  3.555790031353198e-12, -3.387679791771969e-14,  3.103958933006275e-16, -2.735676546738883e-18,  2.311711866491544e-20, -1.858430127356273e-22,
  1.400593578707066e-24,  1.361077760556790e-02,  3.543123185800901e-04,  6.852376325263634e-06,  1.163181599036308e-07,  1.821239879924853e-09,  2.682023742365782e-11,
  3.741676718831581e-13,  4.945206468832560e-15,  6.150983275090432e-17,  7.083919108705774e-19,  7.279632723820621e-21,  6.029590921941086e-23,  1.179069904012157e-01,
  2.823064920080666e-03,  4.640397642814584e-05,  5.900528956055101e-07,  5.425521512707440e-09,  1.923459952230652e-11, -5.164234275637945e-13, -1.434274275252522e-14,
 -2.080436048528637e-16, -1.644163891813867e-18,  7.157571009639719e-21,  5.147803696835809e-22,  3.051736336440291e-01,  6.251552805511237e-03,  7.355333380002311e-05,
  3.863887630843225e-07, -4.253494706051611e-09, -1.176194723755541e-10, -9.191593017317027e-13,  8.893912726475148e-15,  3.150196352655894e-16,  2.852905218757090e-18,
 -2.515096945148959e-20, -1.023597581541268e-21,  5.440015129790213e-01,  9.001411465540662e-03,  5.983334690091064e-05, -3.351024030566880e-07, -9.514480731501878e-09,
 -1.600383390082407e-11,  1.468823645358872e-12,  1.336855003442371e-14, -1.843434496902049e-16, -4.029267180991966e-18,  8.453378047495409e-21,  9.257625084687534e-22,
  8.044417563881201e-01,  1.026150089725627e-02,  1.974932154514649e-05, -7.415208384415344e-07, -2.896297767113615e-09,  9.808186828028089e-11,  5.035135623939735e-13,
 -1.589659653698940e-14, -9.629599036437768e-17,  2.865035530578718e-18,  1.957352234749984e-20, -5.506190269770421e-22,  1.063307864325870e+00,  1.001818059888300e-02,
 -2.068092127169361e-05, -6.094734315297182e-07,  4.392993335417255e-09,  5.522879991024916e-11, -8.487501341042706e-13, -4.105520086195141e-15,  1.528884719279472e-16,
 -1.020217449525119e-19, -2.534829536905037e-20,  1.515803889652409e-22,  1.304517448425691e+00,  8.663611632725620e-03, -4.567923576027875e-05, -2.174634560014275e-07,
  5.689451822231906e-09, -2.265299778567410e-11, -4.920626102795183e-13,  7.292660636529598e-15,  1.683669262004136e-18, -1.066436099401218e-18,  9.817681176696460e-21,
  7.026413804871639e-23,  1.517542755560129e+00,  6.692146253379488e-03, -5.199449301736486e-05,  1.251211639924606e-07,  2.794104573609844e-09, -4.230986339507643e-11,
  1.879803484909018e-13,  2.611666343145130e-15, -5.431428067411833e-17,  3.408761598829200e-19,  2.825230683616235e-21, -8.132069902960400e-23,  1.695704549824748e+00,
  4.553444528816304e-03, -4.394937831319345e-05,  2.767155851102012e-07, -3.494164525568780e-10, -1.831142866681521e-11,  2.783834740748900e-13, -2.035974664110892e-15,
 -4.075465397171390e-19,  2.295579983477838e-19, -3.317494751315458e-21,  2.269262005935469e-23,  1.834853474179615e+00,  2.603766048450859e-03, -2.866147454127001e-05,
  2.494736117905047e-07, -1.636841247369677e-09,  5.326786917075178e-12,  5.231664544524443e-14, -1.249804650904594e-15,  1.457658704091121e-17, -1.109407716434865e-19,
  3.448166828335979e-22,  5.723282327514318e-24,  1.932477149751639e+00,  1.100941574250109e-03, -1.310633276365910e-05,  1.333754065437711e-07, -1.203165745031809e-09,
  9.579975133604701e-12, -6.430840802287559e-14,  3.059354552336851e-16,  7.825047119550301e-20, -2.592975543850197e-20,  4.222628929022113e-22, -4.779924908397141e-24,
  1.987152191734469e+00,  2.132453683354797e-04, -2.641843980454291e-06,  2.890001590143652e-08, -2.938569681248604e-10,  2.837868210844053e-12, -2.629575456950557e-14,
  2.348479008288522e-16, -2.023565613459406e-18,  1.679151190944462e-20, -1.332730543410672e-22,  1.011108807963599e-24,  1.514726248384848e-02,  4.152541659091907e-04,
  8.442454081535744e-06,  1.502885531035523e-07,  2.459917827710857e-09,  3.770997511697015e-11,  5.444551656384632e-13,  7.383090690215487e-15,  9.291335137308427e-17,
  1.054584692987585e-18,  1.003217125547087e-20,  5.990290549262784e-23,  1.299886732648938e-01,  3.224119138584944e-03,  5.401556756806925e-05,  6.791146109823778e-07,
  5.649633759943862e-09,  1.217541523889083e-12, -1.019425671088401e-12, -2.183819925498432e-14, -2.551646622867783e-16, -7.408043092459045e-19,  4.258136797545942e-20,
  1.141242143496840e-21,  3.313841855084145e-01,  6.857183124825912e-03,  7.770043524796970e-05,  2.984214413691638e-07, -6.800053934014039e-09, -1.354661986341296e-10,
 -5.154936070879932e-13,  2.032795105026267e-14,  3.876364741179161e-16,  8.283544132065361e-19, -7.818108655351239e-20, -1.302109338597171e-21,  5.809353553575868e-01,
  9.461394081980795e-03,  5.489468489835306e-05, -4.878657637111053e-07, -9.455718595435129e-09,  2.294351714678331e-11,  1.739692922755734e-12,  5.296583596613997e-15,
 -3.130872514006106e-16, -2.839025468090787e-18,  5.104319728111897e-20,  9.206020108542227e-22,  8.457464823481112e-01,  1.038326725418392e-02,  1.063946194199441e-05,
 -7.716682584394700e-07, -8.512500464885311e-10,  1.045762116796310e-10,  3.156350895501107e-14, -1.722665495569986e-14,  1.473465963052956e-17,  3.127742874781510e-18,
 -6.760414566656360e-21, -5.944082285046228e-22,  1.103005160341413e+00,  9.824750001347646e-03, -2.754009227969151e-05, -5.314849478244489e-07,  5.287376476891003e-09,
  3.402217269745754e-11, -8.970684677728618e-13,  5.482933755202980e-16,  1.329861084212208e-16, -9.389253381466992e-19, -1.564892015241788e-20,  2.678804571781153e-22,
  1.338426634482417e+00,  8.289248773970477e-03, -4.775945028392527e-05, -1.306292472044287e-07,  5.134727779816833e-09, -3.203872566766155e-11, -2.923187072148222e-13,
  6.812350639552490e-15, -2.915884606149725e-17, -6.404165841564550e-19,  1.084931718780657e-20, -1.642318532381241e-23,  1.543489928181191e+00,  6.282893512744616e-03,
 -5.025187573273216e-05,  1.633238665623443e-07,  1.997981253017031e-09, -3.710525940406633e-11,  2.387368698650308e-13,  1.085352729660779e-15, -4.078131542221645e-17,
  3.922099797735582e-19, -9.045403957545786e-24, -4.723372595629476e-23,  1.713236000253267e+00,  4.215011238191551e-03, -4.067329775002838e-05,  2.685387855306800e-07,
 -6.534289722616736e-10, -1.230901705251993e-11,  2.222648627703490e-13, -1.940415528801043e-15,  5.713114588179843e-18,  1.172417046051087e-19, -2.297986962793847e-21,
  2.284726141289971e-23,  1.844828297393790e+00,  2.386012249229655e-03, -2.582122162285839e-05,  2.241936625576396e-07, -1.520326943002758e-09,  6.211576267676673e-12,
  2.327338531538828e-14, -8.441935778609302e-16,  1.087793978236046e-17, -9.356715433381967e-20,  4.945123422831667e-22,  1.681786196976541e-24,  1.936680907769257e+00,
  1.002179701758976e-03, -1.161527270347869e-05,  1.155766000988126e-07, -1.026308202818594e-09,  8.138895129418616e-12, -5.582645003701247e-14,  2.963892821400062e-16,
 -5.963157437940042e-19, -1.264213553926792e-20,  2.561634431676220e-22, -2.843644482920309e-24,  1.987964992683641e+00,  1.934219895308077e-04, -2.321486331954791e-06,
  2.462018457659944e-08, -2.429135234511438e-10,  2.278885606721527e-12, -2.054255258588867e-14,  1.788185899927095e-16, -1.505096922591349e-18,  1.226544679575870e-20,
 -9.488158852970048e-23,  7.573118098046576e-25,  1.695580678909048e-02,  4.907390536977753e-04,  1.050946482948714e-05,  1.964676128871098e-07,  3.363427114463418e-09,
  5.363155927026061e-11,  7.990937551861678e-13,  1.104580867372843e-14,  1.386455542259132e-16,  1.497319140184603e-18,  1.165392873411401e-20, -3.923930286748053e-24,
  1.438031712912484e-01,  3.690369994661878e-03,  6.270319683175810e-05,  7.681495478162498e-07,  5.374971682345057e-09, -3.151918877250403e-11, -1.746238059271272e-12,
 -2.998942328843941e-14, -2.369665376065586e-16,  2.199036664923606e-18,  1.102096113356304e-19,  1.927446295210964e-21,  3.600759180988448e-01,  7.491052009160813e-03,
  8.053769200975353e-05,  1.674926425010576e-07, -9.579718884263226e-09, -1.396029060205441e-10,  2.268965302521657e-13,  3.249736042923792e-14,  3.479837961021391e-16,
 -3.361030243882411e-18, -1.272324351062297e-19, -7.372480189652429e-22,  6.196186025971471e-01,  9.874611825750737e-03,  4.815512434339664e-05, -6.331887399906219e-07,
 -8.573503735546912e-09,  6.526516822385261e-11,  1.735604876324723e-12, -5.891091085371448e-15, -3.698735534369494e-16, -1.151563860483223e-19,  8.102353453806222e-20,
  3.585240792244694e-22,  8.873910180130382e-01,  1.043126975079029e-02,  1.366433520508851e-06, -7.686766412905164e-07,  1.209485504640256e-09,  9.969981950566075e-11,
 -4.279089315912040e-13, -1.505399709526541e-14,  1.166294015115287e-16,  2.389293940550161e-18, -2.833407029942503e-20, -3.459786801577438e-22,  1.141825215045426e+00,
  9.580400325299785e-03, -3.339162395592455e-05, -4.425997203312986e-07,  5.756105880477542e-09,  1.312266438838659e-11, -8.279448495929920e-13,  4.165815859841382e-15,
  9.083150079753302e-17, -1.322628951564009e-18, -3.563247727689709e-21,  2.651379849292895e-22,  1.370811455343616e+00,  7.902248751817675e-03, -4.885627559713269e-05,
 -5.391826962853410e-08,  4.438622607336054e-09, -3.688922505099827e-11, -1.175178904069758e-13,  5.591760641745124e-15, -4.471979867426304e-17, -2.359089644429457e-19,
  9.096661266406280e-21, -5.484424702343873e-23,  1.567830580298368e+00,  5.889207167064358e-03, -4.812364197163870e-05,  1.896738838052848e-07,  1.314927433881912e-09,
 -3.114540695445177e-11,  2.529582309260532e-13,  2.720721931866313e-18, -2.707935562941129e-17,  3.600914651725392e-19, -1.360904345592837e-21, -1.486545392007454e-23,
  1.729465408067903e+00,  3.902320068491619e-03, -3.752079609168524e-05,  2.563862556434159e-07, -8.505454474409123e-10, -7.602667590648998e-12,  1.710119622707932e-13,
 -1.705871557616501e-15,  8.516545547484295e-18,  4.488163663907043e-20, -1.332759482089516e-21,  2.116361946399738e-23,  1.853975674408537e+00,  2.189799844728998e-03,
 -2.327267145140826e-05,  2.008852646240335e-07, -1.392233849959269e-09,  6.522850167790448e-12,  4.030799934168959e-15, -5.460617335905761e-16,  7.879122941229525e-18,
 -7.273132416584592e-20,  5.425181000899300e-22,  1.020381754897429e-24,  1.940512187663735e+00,  9.145379530979053e-04, -1.032173562404953e-05,  1.003878724799606e-07,
 -8.762691261891346e-10,  6.896135530245398e-12, -4.785028667772711e-14,  2.717887370993382e-16, -8.924998528251521e-19, -4.387693614530521e-21,  1.691991332212667e-22,
 -1.101928266789991e-24,  1.988703319073197e+00,  1.759690931974891e-04, -2.047942095901769e-06,  2.107301182768643e-08, -2.018869496125150e-10,  1.840888332491575e-12,
 -1.614839316918019e-14,  1.370503927770398e-16, -1.124219534933069e-18,  9.095663991343313e-21, -6.431725757075842e-23,  6.601181037727063e-25,  1.910325422414974e-02,
  5.852489208351973e-04,  1.322904787991373e-05,  2.600203593222243e-07,  4.655706599412670e-09,  7.707550717556249e-11,  1.179218609665198e-12,  1.643162022514732e-14,
  2.004311256552696e-16,  1.904980757356329e-18,  6.858463314505277e-21, -2.657291722493413e-22,  1.596282621758927e-01,  4.230264560846832e-03,  7.240799542846000e-05,
  8.465292840694702e-07,  4.253481356780850e-09, -8.425433964916878e-11, -2.673121442318379e-12, -3.527839832254742e-14, -5.646705170106724e-17,  8.460535008149773e-18,
  2.049538923310343e-19,  2.187254873375235e-21,  3.913375046687353e-01,  8.140578856231867e-03,  8.153766717926331e-05, -7.493224364927008e-09, -1.223772081174671e-08,
 -1.221280136627548e-10,  1.267278631100382e-12,  4.067601165704765e-14,  1.314423679195734e-16, -8.655053702092134e-18, -1.242746594698445e-19,  1.064107228178311e-21,
  6.598362661785643e-01,  1.022724129941210e-02,  3.978399849103499e-05, -7.577391149792574e-07, -6.871861518295478e-09,  1.036218449684769e-10,  1.408894549066525e-12,
 -1.715161833528862e-14, -3.141141241715272e-16,  3.194232174383958e-18,  7.818083949213501e-20, -4.919814705620647e-22,  9.290801993749926e-01,  1.040578096130284e-02,
 -7.677952435711255e-06, -7.340656859334479e-07,  3.069127614890747e-09,  8.486463513269106e-11, -7.859395647851517e-13, -1.018750691164371e-14,  1.795904163467585e-16,
  1.064047940418920e-18, -3.503953306855996e-20,  4.680886845784281e-23,  1.179581140857552e+00,  9.293601358894251e-03, -3.814494937064744e-05, -3.494370410592726e-07,
  5.830809423697856e-09, -5.064283465405554e-12, -6.778363470886523e-13,  6.304898992391680e-15,  4.330659471050049e-17, -1.249630762734683e-18,  6.698678010012450e-21,
  1.953167990221598e-22,  1.401636281711624e+00,  7.509960960410672e-03, -4.910189206843634e-05,  1.109442023097695e-08,  3.684455662273055e-09, -3.799798541108344e-11,
  1.821296239261547e-14,  4.090247649438460e-15, -4.725661222152171e-17,  7.892360563055550e-20,  6.693947734130852e-21, -4.858077526029732e-23,  1.590632291118810e+00,
  5.513634833514360e-03, -4.574081364844311e-05,  2.060577289187151e-07,  7.522787688985440e-10, -2.515983380413853e-11,  2.427719121639152e-13, -6.676744517978831e-16,
 -1.517536266429863e-17,  3.010761547802229e-19, -1.390843214352988e-21,  1.235122989042075e-23,  1.744493500844111e+00,  3.614218706106242e-03, -3.453015179725971e-05,
  2.417684312878378e-07, -9.652605474920182e-10, -4.039587522767956e-12,  1.272430142510294e-13, -1.415967177593909e-15,  9.395877256371075e-18,  1.009070625165515e-20,
 -4.056672625121219e-22,  2.126293268073810e-23,  1.862377256792240e+00,  2.012892203263359e-03, -2.099139365314464e-05,  1.796537197975228e-07, -1.261910390561289e-09,
  6.462336510552827e-12, -8.092225237463980e-15, -3.315238534230122e-16,  5.665935012609772e-18, -4.969535050047941e-20,  6.236211718167692e-22,  2.939470620487241e-24,
  1.944012498021679e+00,  8.365544301254729e-04, -9.196846733751251e-06,  8.741107931289270e-08, -7.492312016879558e-10,  5.835721375577590e-12, -4.065486764644603e-14,
  2.419448135958882e-16, -9.354426618462856e-19,  1.946886932841022e-21,  1.608254957620487e-22,  7.099199559070323e-25,  1.989375955921127e+00,  1.605448152822549e-04,
 -1.813296928626959e-06,  1.811754055653561e-08, -1.686537526509073e-10,  1.495596866762939e-12, -1.276861666686346e-14,  1.058750286525680e-16, -8.360308326273284e-19,
  7.111575234524229e-21, -3.448333095865103e-23,  7.123294865377126e-25,  2.167763206942041e-02,  7.049566108731232e-04,  1.685255148598418e-05,  3.485517399106624e-07,
  6.521515259448024e-09,  1.116870605770383e-10,  1.739605679265811e-12,  2.396311522986254e-14,  2.696077290473195e-16,  1.768414355924138e-18, -1.939076409894669e-20,
 -1.060253586188767e-21,  1.777736185012354e-01,  4.851166495569104e-03,  8.290686446716771e-05,  8.972832120726683e-07,  1.847193308863382e-09, -1.601245818664088e-10,
 -3.628127753229073e-12, -3.045753557042714e-14,  4.162100500197126e-16,  1.824937518890947e-17,  2.706409083816813e-19,  2.465689351293863e-22,  4.251989251478689e-01,
  8.789018904095339e-03,  8.019874575121188e-05, -2.207929221676075e-07, -1.428276169850644e-08, -7.789005121461559e-11,  2.412148871620471e-12,  3.907113184282976e-14,
 -2.519196149542746e-16, -1.198483048308542e-17, -2.498316428627277e-20,  3.392610775913180e-21,  7.013217699974840e-01,  1.050744121654906e-02,  3.010528003159967e-05,
 -8.494543613808237e-07, -4.505534597314228e-09,  1.306630675767747e-10,  8.092052998103285e-13, -2.481542099466005e-14, -1.500284878077931e-16,  5.677171083860419e-18,
  4.155029446686500e-20, -1.093494144891430e-21,  9.705260266861683e-01,  1.031007889460709e-02, -1.613964963697237e-05, -6.724911093609860e-07,  4.558161393740189e-09,
  6.325442675187749e-11, -9.868477121096569e-13, -4.087712509416589e-15,  1.941375593665010e-16, -1.918059994914236e-19, -2.549560056386167e-20,  3.531230183007000e-22,
  1.216120891911070e+00,  8.973241633432626e-03, -4.178447210054635e-05, -2.577759453172824e-07,  5.581783455486607e-09, -1.909664380942775e-11, -4.882022721228011e-13,
  7.037912789900617e-15,  4.979357025526344e-18, -8.358396119269887e-19,  1.331119750382544e-20,  1.014998697261467e-22,  1.430892677554544e+00,  7.118623106342306e-03,
 -4.863995391762878e-05,  6.402569868514791e-08,  2.937278172361224e-09, -3.635305425009362e-11,  1.123422615469810e-13,  2.671395364895141e-15, -4.004939251253748e-17,
  3.106719452115170e-19,  5.051960750578447e-21, -2.783084924520859e-23,  1.611970878824753e+00,  5.157767493824557e-03, -4.321150163270680e-05,  2.143779716209602e-07,
  3.055906744483083e-10, -1.960285635456566e-11,  2.188392960056474e-13, -9.891802994065896e-16, -5.153757054823703e-18,  2.618955589371575e-19, -4.672204034588655e-22,
  2.577682463360592e-23,  1.758415890164481e+00,  3.349314698961752e-03, -3.172375964046256e-05,  2.258309882246377e-07, -1.018548635112378e-09, -1.427275585768991e-12,
  9.184818239620560e-14, -1.110787461709281e-15,  9.692298199893013e-18,  1.246928920056333e-20,  5.099082162657705e-22,  1.897019928498781e-23,  1.870106145262716e+00,
  1.853250932916104e-03, -1.895246923148676e-05,  1.604837681987950e-07, -1.135258171093890e-09,  6.175745171920683e-12, -1.506952233536631e-14, -1.737325668856525e-16,
  4.362726480472792e-18, -2.158597345205409e-20,  7.897304735567233e-22,  3.871057134445351e-24,  1.947217933006258e+00,  7.669801342364500e-04, -8.216153977722598e-06,
  7.630632529759520e-08, -6.417422502967072e-10,  4.938026615481467e-12, -3.427961661274924e-14,  2.144611202759798e-16, -7.381421640377889e-19,  9.408711082305363e-21,
  2.189412099633018e-22,  1.570838402061285e-24,  1.989990437468199e+00,  1.468643779042033e-04, -1.611141413369529e-06,  1.564268222638981e-08, -1.415808083599838e-10,
  1.221929570616717e-12, -1.014170708009578e-14,  8.301448349195173e-17, -5.971408802360725e-19,  6.372120578541751e-21, -2.647004136467372e-24,  6.798263829435921e-25,
  2.479633738523104e-02,  8.584670669278576e-04,  2.174296643413649e-05,  4.732807078405116e-07,  9.232370102556162e-09,  1.625148470433611e-10,  2.539204658098233e-12,
  3.334172915917421e-14,  3.039051414743685e-16, -4.202775083128960e-19, -1.050057854012473e-19, -3.137308096679724e-21,  1.985733359620433e-01,  5.557718014889412e-03,
  9.372987749193795e-05,  8.962329168577764e-07, -2.284502985400727e-09, -2.552475477330928e-10, -4.181085794311818e-12, -4.598577382404364e-15,  1.257779058270198e-15,
  2.780617146355270e-17,  1.613869469368357e-19, -6.045340563012236e-21,  4.616157876561175e-01,  9.416029703816926e-03,  7.613783274708068e-05, -4.582836193491700e-07,
 -1.517943347955441e-08, -8.179302794018067e-12,  3.328877017490525e-12,  2.423361159934761e-14, -6.613232271525196e-16, -9.588965577180144e-18,  1.499752985862598e-19,
  4.066365551094538e-21,  7.437671997049838e-01,  1.070648840167642e-02,  1.956828855634135e-05, -8.998251114679760e-07, -1.756313712029163e-09,  1.414014073600614e-10,
  7.960514145890822e-14, -2.612397024426791e-14,  7.205128615354425e-17,  6.315809205150623e-18, -1.029561786464691e-20, -1.193024011060006e-21,  1.011458864935210e+00,
  1.015000958793141e-02, -2.373445621056316e-05, -5.907530979294370e-07,  5.580713444579218e-09,  3.888599183837053e-11, -1.016583866992538e-12,  1.849972440874186e-15,
  1.729236973639689e-16, -8.729030163949951e-19, -8.564986896556522e-21,  3.499416139128077e-22,  1.251327816250259e+00,  8.628078026237520e-03, -4.435641503542901e-05,
 -1.720924824672619e-07,  5.098633058094243e-09, -2.845470529495568e-11, -2.926604697408132e-13,  6.825207035056303e-15, -1.477606712984791e-17, -2.509351506204365e-19,
  1.487000475670688e-20, -4.613423556075548e-23,  1.458594853074486e+00,  6.733321459501758e-03, -4.761312177908755e-05,  1.053751268757791e-07,  2.242538254831094e-09,
 -3.289239976527674e-11,  1.711448500927698e-13,  1.605363598026277e-15, -2.552931519654880e-17,  4.865268806914718e-19,  3.558282843595508e-21, -5.410398162465568e-23,
  1.631926937839744e+00,  4.822420753999706e-03, -4.062166907246232e-05,  2.164066902820078e-07, -3.624812645746121e-11, -1.469307836692760e-11,  1.902372225353433e-13,
 -1.004788896911305e-15,  4.184089317525317e-18,  2.621427567638892e-19,  2.875944607336587e-22, -1.196110163866887e-24,  1.771322338897515e+00,  3.106086022807207e-03,
 -2.911214984686660e-05,  2.094156788356770e-07, -1.027386326610272e-09,  4.394959208217071e-13,  6.519230459099277e-14, -7.880919764266366e-16,  1.067547526350012e-17,
  4.544585502115706e-20,  9.862899473730819e-22, -2.365758778187221e-24,  1.877227682520624e+00,  1.709034862095093e-03, -1.713164031090793e-05,  1.432867289213765e-07,
 -1.015674677823456e-09,  5.770985085510006e-12, -1.805129914362339e-14, -4.020300229647605e-17,  4.182886727075927e-18,  1.184738984713491e-20,  8.163486481409052e-22,
 -5.330080923874959e-24,  1.950159957473377e+00,  7.047462774774912e-04, -7.358965556759962e-06,  6.678583120607659e-08, -5.507346646829636e-10,  4.185081987233997e-12,
 -2.854175083197399e-14,  1.980606888499920e-16, -2.293631992120753e-19,  1.900159144936724e-20,  2.361221654299138e-22, -1.878634638817395e-24,  1.990553253539143e+00,
  1.346893605519049e-04, -1.436255277523755e-06,  1.356042740623923e-08, -1.193982080433472e-10,  1.004474764096898e-12, -8.050175250929162e-15,  6.760717167501530e-17,
 -3.636226570556222e-19,  6.720113879260718e-21,  1.450805748887008e-23, -9.482892097652350e-26,  2.861796247298647e-02,  1.057909666255715e-03,  2.842754165792340e-05,
  6.506487879297727e-07,  1.317318485361964e-08,  2.357067044192058e-10,  3.598994908905182e-12,  4.167974445871769e-14,  1.698636057426250e-16, -8.531117837858575e-18,
 -3.352250021896845e-19, -7.933689798387851e-21,  2.223705665569939e-01,  6.349531588757287e-03,  1.040793397846770e-04,  8.134393338621303e-07, -8.375801796336382e-09,
 -3.516370257950436e-10, -3.590816045441168e-12,  5.222606441022120e-14,  2.285360735078982e-15,  2.610118859170138e-17, -3.206013490338399e-19, -1.605889809436754e-20,
  5.004574736459684e-01,  9.999022673736086e-03,  6.919038536325642e-05, -6.979383200044877e-07, -1.450266236388976e-08,  7.719546814837716e-11,  3.669387892279664e-12,
 -9.750064253063420e-16, -8.604640931622511e-16, -6.248924266502896e-19,  2.755043172391392e-19,  9.587706334251224e-22,  7.868374675415531e-01,  1.081957978552556e-02,
  8.694779808133265e-06, -9.054394707318640e-07,  1.033790055394587e-09,  1.349995474315607e-10, -5.865597373184192e-13, -2.036105191603109e-14,  2.795878875709197e-16,
  4.878877377828949e-18, -6.108357814131515e-20, -1.137382421008656e-21,  1.051636464984029e+00,  9.933346369591228e-03, -3.026629983619453e-05, -4.965370777662234e-07,
  6.121750805640402e-09,  1.570411623797769e-11, -8.923608053967739e-13,  6.839504430115397e-15,  1.382092959214655e-16, -1.005582381756883e-18, -1.302707902817449e-21,
 -9.205610561651938e-23,  1.285119244802950e+00,  8.266307682847068e-03, -4.595189728584238e-05, -9.538478879684398e-08,  4.474482873685571e-09, -3.324313099514175e-11,
 -1.087564773876737e-13,  6.314631720966987e-15, -1.421830372513176e-17,  2.323388018118925e-19,  7.258398416738224e-21, -3.253702656887293e-22,  1.484775134603809e+00,
  6.358035985133310e-03, -4.615428442178175e-05,  1.362299658965311e-07,  1.629000691889387e-09, -2.832081451147864e-11,  2.074517170947663e-13,  1.089773702570942e-15,
 -6.296162905645086e-18,  5.497672060920669e-19, -1.406093620543793e-21, -1.925293857930045e-22,  1.650583079668913e+00,  4.507804295279064e-03, -3.803718771523635e-05,
  2.137147159510197e-07, -2.866162113211447e-10, -1.044109057643714e-11,  1.654053566015258e-13, -7.190777240028984e-16,  1.361252083094479e-17,  2.491599098354508e-19,
 -1.659258477850901e-21, -1.001780929647867e-22,  1.783296411200946e+00,  2.882962513526031e-03, -2.669724412917367e-05,  1.931260414888490e-07, -1.004530795960096e-09,
  1.779679278180879e-12,  4.820349491136300e-14, -4.137006632725089e-16,  1.286950123126265e-17,  6.824094444140391e-20, -2.855087205744933e-22, -6.252383751299169e-23,
  1.883800226867788e+00,  1.578591857279443e-03, -1.550597210691283e-05,  1.279356493089622e-07, -9.045978622106890e-10,  5.339972118074302e-12, -1.719853669163624e-14,
  1.059258929295362e-16,  5.079243436686744e-18,  3.274386422745973e-20,  1.268923951089489e-23, -3.489667555772235e-23,  1.952866071469123e+00,  6.489366019419190e-04,
 -6.607759381440599e-06,  5.860835054742369e-08, -4.734352310226600e-10,  3.566489499234512e-12, -2.298464569637367e-14,  2.031740295818269e-16,  5.807237024801253e-19,
  2.402214997001611e-20, -6.996103894842726e-23, -1.350506996097935e-23,  1.991070017571330e+00,  1.238192042445480e-04, -1.284361719247763e-06,  1.180089747267041e-08,
 -1.010932561768527e-10,  8.328985079704103e-13, -6.283102900502644e-15,  5.991553821804530e-17, -1.170119205729447e-19,  6.671388844727299e-21, -3.341789833043002e-23,
 -2.352012438404741e-24,  3.335946281701578e-02,  1.320535011498068e-03,  3.767182216705615e-05,  9.042290568658259e-07,  1.884717909279823e-08,  3.363055567446979e-10,
  4.772895698939780e-12,  3.879553083291672e-14, -4.837383293974883e-16, -3.129971191039749e-17, -8.713036251019217e-19, -1.728121709178058e-20,  2.494918281975369e-01,
  7.218371374736352e-03,  1.127910251491734e-04,  6.191379851118242e-07, -1.610593729163116e-08, -4.112621527504686e-10, -9.897923730259655e-13,  1.363842035703883e-13,
  2.801777104328008e-15, -3.135337604824755e-18, -1.176810202208280e-18, -2.063932051518183e-20,  5.415021917063640e-01,  1.051524814522797e-02,  5.948915925773861e-05,
 -9.129095366480582e-07, -1.209620139868306e-08,  1.618772639391566e-10,  3.268385099176530e-12, -2.675772162506524e-14, -6.894009148585119e-16,  9.570341690641870e-18,
  1.904671717938241e-19, -4.964393441260648e-21,  8.301867499378326e-01,  1.084615746845962e-02, -1.985109603213190e-06, -8.682375310260111e-07,  3.552672123631156e-09,
  1.152347659994591e-10, -1.008947209347229e-12, -9.175386887080177e-15,  3.988669996785432e-16,  1.395307327300041e-18, -1.145615260705555e-19, -1.330959042622140e-21,
  1.090850225983025e+00,  9.669063975836766e-03, -3.563026270109416e-05, -3.971663762749830e-07,  6.239616856470663e-09, -2.948932955321373e-12, -6.445562934617415e-13,
  1.065280862726016e-14,  9.822316651546950e-17, -1.346425959778610e-18, -2.109180882391360e-20, -8.163174676556834e-22,  1.317443646715237e+00,  7.895279938180797e-03,
 -4.668920197596557e-05, -2.919447955431059e-08,  3.797612083905524e-09, -3.377406434369373e-11,  6.314629687963402e-14,  6.015002645948767e-15, -5.071904494652069e-18,
  1.266686035346732e-19, -1.528953941609949e-20, -6.970826398302159e-22,  1.509479734528027e+00,  5.995742596838771e-03, -4.438092836850152e-05,  1.580433554124229e-07,
  1.114801426190592e-09, -2.298115586624980e-11,  2.379283073391792e-13,  1.173776709010686e-15,  9.864770160644272e-18,  2.601059561218076e-19, -1.471868455249354e-20,
 -4.142448383071531e-22,  1.668021814908882e+00,  4.213672641129752e-03, -3.550633508166854e-05,  2.076681102660230e-07, -4.570845349364841e-10, -6.656179115635991e-12,
  1.525643638721381e-13, -1.639316439310629e-16,  1.993645375585467e-17,  5.157309081228085e-20, -9.314782103690807e-21, -2.481703991623003e-22,  1.794415401249532e+00,
  2.678384475542677e-03, -2.447479707398981e-05,  1.773980806633285e-07, -9.580573027050083e-10,  2.846126377034238e-12,  4.270053270435509e-14,  2.834890861947274e-17,
  1.422868400686536e-17, -2.352161075468027e-20, -4.943090385739782e-21, -1.491309037241127e-22,  1.889875885012480e+00,  1.460446918419327e-03, -1.405413039497079e-05,
  1.142954043137887e-07, -8.015865524713537e-10,  4.982169505667254e-12, -1.180025949978452e-14,  2.836680610657809e-16,  5.782513530349284e-18, -1.013951623405355e-20,
 -2.478243618404648e-21, -7.833959531221962e-23,  1.955360373076184e+00,  5.987641894624739e-04, -5.947646763759800e-06,  5.157603496934764e-08, -4.071468926131654e-10,
  3.085969952145478e-12, -1.691762751968645e-14,  2.335962795751636e-16,  1.206744849143976e-18,  4.337586327769833e-21, -1.041036187844221e-21, -3.064062506058041e-23,
  1.991545604254701e+00,  1.140844717892613e-04, -1.151931182849879e-06,  1.030904145745841e-08, -8.580864001660236e-11,  7.020191954284923e-13, -4.625070503558235e-15,
  5.949722725660884e-17,  6.555132294724372e-20,  2.313162596775123e-21, -2.085548938082444e-22, -5.605476088537767e-24,  3.932103765567124e-02,  1.670992288047749e-03,
  5.057492134895823e-05,  1.266138517736998e-06,  2.679230910008099e-08,  4.608186834604252e-10,  5.415422154760741e-12, -3.144693952671736e-15, -2.454443434122575e-15,
 -8.503309801832535e-17, -1.906229656347849e-18, -2.947429443568841e-20,  2.802100138960116e-01,  8.145411051279410e-03,  1.184028735084793e-04,  2.958261462539191e-07,
 -2.420881214508979e-08, -3.795315829323940e-10,  3.992794693208457e-12,  2.135186087339467e-13,  1.647054009036355e-15, -6.530600213876954e-17, -1.804866471636099e-18,
 -3.128604447700164e-21,  5.844413423108638e-01,  1.094432390660797e-02,  4.749285990807402e-05, -1.076581508411558e-06, -8.146310625959582e-09,  2.291936125497059e-10,
  2.269655968101217e-12, -4.235590780222655e-14, -2.741697052643703e-16,  1.136980879749658e-17, -1.274700193080067e-19, -8.571256822994510e-21,  8.734752159926197e-01,
  1.078973379878025e-02, -1.199128587622197e-05, -7.943340216305807e-07,  5.601936817855294e-09,  8.939129432733077e-11, -1.086600903695116e-12,  3.389667793362110e-15,
  3.520256786334210e-16, -4.401749511641430e-18, -1.750770652650373e-19, -1.277231394339397e-21,  1.128928596905266e+00,  9.366645648129345e-03, -3.980163381201996e-05,
 -2.985376784034536e-07,  6.051723388165331e-09, -1.453631844428371e-11, -3.111820421261721e-13,  1.277661875224982e-14,  2.433279549243568e-17, -3.072197238698149e-18,
 -6.793734176795146e-20, -1.176863129368796e-21,  1.348276912074683e+00,  7.521347419217986e-03, -4.669683344442497e-05,  2.630273924469265e-08,  3.150830595481228e-09,
 -3.025743935781380e-11,  2.287658490492435e-13,  5.742722216244289e-15, -1.962686807722656e-17, -1.170966779397258e-18, -5.057693098908582e-20, -8.230804955598377e-22,
  1.532765005996209e+00,  5.648551619636364e-03, -4.239151749579843e-05,  1.725253314466148e-07,  7.151464829959311e-10, -1.683716870472563e-11,  2.755890982486025e-13,
  1.486928990760018e-15,  3.792405623654610e-18, -7.385959034732100e-19, -3.584346734001314e-20, -4.943633719306175e-22,  1.684323999654004e+00,  3.939456875414926e-03,
 -3.306194767356224e-05,  1.994884416080759e-07, -5.535957972125044e-10, -2.979048700823745e-12,  1.565382680921999e-13,  4.084379428565355e-16,  1.215789400691152e-17,
 -5.697502397791808e-19, -2.218713865364610e-20, -3.043121323678865e-22,  1.804750462923993e+00,  2.490845308123401e-03, -2.243593188483931e-05,  1.625813949907065e-07,
 -8.905658261171645e-10,  3.929428064537844e-12,  4.938911096675677e-14,  4.179464637056902e-16,  8.069894048721634e-18, -3.699944956840519e-19, -1.262931097089596e-20,
 -1.811549968986922e-22,  1.895501195117785e+00,  1.353289510945879e-03, -1.275629120592695e-05,  1.022548433289158e-07, -7.040282956124126e-10,  4.813985705612882e-12,
 -1.500289057880414e-15,  4.364049716907559e-16,  2.716610893416181e-18, -1.869547851403352e-19, -6.484717002867789e-21, -9.402595647762924e-23,  1.957664036937640e+00,
  5.535524797801182e-04, -5.365848903111477e-06,  4.553568011513534e-08, -3.489360339294336e-10,  2.762585999972224e-12, -9.886580446038405e-15,  2.638043320241635e-16,
  2.545674786304617e-19, -6.771973263609602e-20, -2.610130504156866e-21, -3.684272252543266e-23,  1.991984263140504e+00,  1.053415470827260e-04, -1.036014959702675e-06,
  9.042966194475540e-09, -7.274203240864659e-11,  6.112521916409130e-13, -2.931757814439599e-15,  6.079070541646591e-17, -6.720188174124156e-20, -1.161750628989768e-20,
 -4.972480869329072e-22, -6.798222397330110e-24,  4.692170047789637e-02,  2.144399199294135e-03,  6.866710367374273e-05,  1.775376646598125e-06,  3.724125524108826e-08,
  5.774372660716080e-10,  3.647425305600573e-12, -1.480186975648997e-13, -7.213290761040242e-15, -1.881226555342267e-16, -3.200295144468831e-18, -2.154729605677583e-20,
  3.146985854026886e-01,  9.099716251693512e-03,  1.194008574562972e-04, -1.449261370357357e-07, -3.033715323456483e-08, -2.086720751434839e-10,  1.025797656261098e-11,
  2.150471966504441e-13, -1.937322491185882e-15, -1.290875679843649e-16, -1.079689345254746e-18,  3.798394053472353e-20,  6.288940563345766e-01,  1.127074062081930e-02,
  3.395155570084045e-05, -1.167708578868471e-06, -3.117489202840661e-09,  2.687673951842057e-10,  1.011189235611149e-12, -4.628215826424290e-14, -4.376763910280248e-17,
 -7.355531253801549e-19, -4.488571467511205e-19, -4.610160791749271e-21,  9.163842402124255e-01,  1.065732611982551e-02, -2.093096153459522e-05, -6.917645513642442e-07,
  7.142439616640669e-09,  6.552754162163383e-11, -8.680008368957314e-13,  1.067397052314151e-14,  5.662436364447527e-17, -1.220802881876079e-17, -2.035834285277587e-19,
  3.335781609866689e-22,  1.165737956641217e+00,  9.035524711429306e-03, -4.281369601885504e-05, -2.043199922048339e-07,  5.715235694982933e-09, -1.774710339105683e-11,
  3.654171985062432e-14,  1.116657491474897e-14, -1.465241631259785e-16, -6.679147947161868e-18, -1.060293688743994e-19, -2.950715362642468e-22,  1.377618303471279e+00,
  7.149848519911483e-03, -4.609757952389179e-05,  7.222589382336074e-08,  2.613021807016686e-09, -2.296304480307722e-11,  3.712643508776227e-13,  3.984608269797207e-15,
 -1.059800600881439e-16, -3.801545729828666e-18, -7.637360490143603e-20, -1.905178202617823e-22,  1.554694304020898e+00,  5.317872027583573e-03, -4.026246952499658e-05,
  1.816470788977116e-07,  4.478442041203136e-10, -9.745165394866484e-12,  3.127219319133096e-13,  8.671375499346741e-16, -5.325995678949390e-17, -2.534691460191550e-18,
 -5.109105486724683e-20, -9.747538902028199e-23,  1.699567780260373e+00,  3.684382980679982e-03, -3.072252465736137e-05,  1.903627584789572e-07, -5.745587598265297e-10,
  9.333783668465474e-13,  1.689746896334192e-13,  2.739633450440008e-16, -2.720167198595501e-17, -1.681077254607612e-18, -3.161996258345485e-20, -6.096144803861753e-23,
  1.814366891882578e+00,  2.318925938479820e-03, -2.056763570531187e-05,  1.490297627388337e-07, -7.990912728876171e-10,  5.268218829382437e-12,  6.192486841207934e-14,
  3.512293485385053e-16, -1.605598613294123e-17, -1.008724760524599e-18, -1.827565280453458e-20, -3.844448039963750e-23,  1.900717763180330e+00,  1.255963243638738e-03,
 -1.159363734396719e-05,  9.176290450698292e-08, -6.071016397497417e-10,  4.926235828767842e-12,  1.052351369250730e-14,  3.581484552385449e-16, -9.571647286692643e-18,
 -5.156630748857029e-19, -9.417874806684992e-21, -2.030375148949686e-23,  1.959795725440414e+00,  5.127206183832137e-04, -4.851130231561632e-06,  4.038431669260252e-08,
 -2.954664514029022e-10,  2.611819525808370e-12, -2.913355547918705e-15,  2.098793375271598e-16, -4.410776777616936e-18, -1.992659213017221e-19, -3.757411302642045e-21,
 -7.815814567345938e-24,  1.992389713619088e+00,  9.746861104891661e-05, -9.340900007440976e-07,  7.973638963632829e-09, -6.108617718563120e-11,  5.605352854736533e-13,
 -1.353137351275051e-15,  4.757208649393446e-17, -9.076751325048798e-19, -3.651251247759598e-20, -7.085411812204668e-22, -1.406540398294712e-24,  5.674838515641561e-02,
  2.789983127028692e-03,  9.393812645224782e-05,  2.466415469582396e-06,  4.916500663176372e-08,  5.819892939512927e-10, -4.928600615026789e-12, -5.126792548432702e-13,
 -1.634068427370498e-14, -3.132779627285888e-16, -2.201027538662554e-18,  9.956868109233439e-20,  3.529849031223469e-01,  1.003949412910634e-02,  1.146601490854866e-04,
 -6.484676934306614e-07, -3.161616619703070e-08,  9.827171434873663e-11,  1.467565215956941e-11,  7.430963832149701e-14, -6.858881526879297e-15, -1.283679564236796e-16,
  1.302062582905819e-18,  6.270520544985639e-20,  6.744308474558312e-01,  1.148586998678002e-02,  1.982021753791216e-05, -1.173712073773306e-06,  2.394180115540718e-09,
  2.771716383607464e-10, -3.345099271346862e-13, -5.180479086919339e-14, -4.169634680908828e-16, -1.988796479097868e-17, -4.292336671561164e-19,  6.207130236596683e-21,
  9.586289405618829e-01,  1.045870922053885e-02, -2.850660612762917e-05, -5.680334241750175e-07,  8.268014269553117e-09,  4.802614726950701e-11, -6.206055125095643e-13,
  3.965962391859567e-15, -5.173902926192611e-16, -1.909176640609781e-17, -1.128385509904012e-19,  4.142566136370488e-21,  1.201181668091394e+00,  8.684736140033298e-03,
 -4.472817130812428e-05, -1.155744672508995e-07,  5.390601578951954e-09, -1.389940998778692e-11,  2.416005223467301e-13,  1.821465124741742e-15, -4.610158651524963e-16,
 -1.056109397480407e-17, -6.985942973845488e-20,  2.206010778610071e-21,  1.405486586980044e+00,  6.785213864139113e-03, -4.499352299639811e-05,  1.108734961906403e-07,
  2.249307398112564e-09, -1.324462186300825e-11,  4.105934377952227e-13, -2.179335125060596e-15, -2.962424671056118e-16, -6.613704346864025e-18, -5.218324016283906e-20,
  1.467100109625945e-21,  1.575335553605419e+00,  5.004601004256873e-03, -3.804481082725046e-05,  1.876647212197969e-07,  3.285564528950628e-10, -2.239428772241523e-12,
  2.966339079391770e-13, -2.685276304760429e-15, -1.800344717139256e-16, -4.402403064731273e-18, -3.455529301484561e-20,  9.679994887447831e-22,  1.713828002405472e+00,
  3.447586769143243e-03, -2.849199828726873e-05,  1.815395385724025e-07, -5.154932877016338e-10,  4.917848392398336e-12,  1.536347082314503e-13, -1.804998942750656e-15,
 -1.097054545393899e-16, -2.836428281534023e-18, -2.130095172395511e-20,  6.066498723841110e-22,  1.823324544107779e+00,  2.161329471655072e-03, -1.885224713575581e-05,
  1.371697873163165e-07, -6.785291394420347e-10,  6.775785809016707e-12,  5.810779692411071e-14, -8.826250281974838e-16, -6.509920150055174e-17, -1.677934578326150e-18,
 -1.233677773086498e-20,  3.540144254429376e-22,  1.905562868812227e+00,  1.167461223247512e-03, -1.054746119415789e-05,  8.285374033267024e-08, -5.055001267354474e-10,
  5.244780680031252e-12,  1.295764983798620e-14, -3.168577494494453e-16, -3.470029271889562e-17, -8.609372754878765e-19, -6.375854432142845e-21,  1.823101073172116e-22,
  1.961771950792516e+00,  4.757736105688931e-04, -4.393167152921845e-06,  3.607256160868188e-08, -2.435675904417360e-10,  2.588806454120560e-12, -2.966373108927591e-16,
 -7.463321694530849e-17, -1.420238444756186e-17, -3.369839733816792e-19, -2.547767814387589e-21,  7.224125958188013e-23,  1.992765226273999e+00,  9.036285277153661e-05,
 -8.439053110812700e-07,  7.084557645423588e-09, -5.011515894566763e-11,  5.393525756676120e-13, -6.640827675559926e-16, -7.892667246894146e-18, -2.715465301979518e-18,
 -6.246413823950104e-20, -4.806589731315523e-22,  1.353593675932985e-23,  6.961873309738194e-02,  3.674062806783915e-03,  1.286020533280284e-04,  3.333666068775008e-06,
  5.810831586567946e-08,  2.216320861084949e-10, -2.834582630683802e-11, -1.219142494070812e-12, -2.730770605287777e-14, -2.158949965567081e-16,  1.021183594595577e-17,
  5.322953272961933e-19,  3.949163733466617e-01,  1.091732450396855e-02,  1.039709826259604e-04, -1.119254730893790e-06, -2.610461053404030e-08,  4.468729913208964e-10,
  1.309067923066792e-11, -2.039046791527480e-13, -9.919090911470386e-15, -2.647531441985715e-17,  3.561264431061391e-18,  3.204130884280842e-20,  7.206037168586342e-01,
  1.158916064012639e-02,  6.145600819117372e-06, -1.092023741694636e-06,  7.728860809246820e-09,  2.494665578904838e-10, -2.098913753053793e-12, -7.915933423294071e-14,
 -1.342074614553860e-15, -2.782812204666551e-17,  1.290452988760352e-19,  1.960852006160424e-20,  9.999677657766122e-01,  1.020570743076948e-02, -3.450019810742457e-05,
 -4.288745429908809e-07,  9.076142728141960e-09,  3.193761094158255e-11, -8.483631065614021e-13, -2.400792602490036e-14, -1.227438696555603e-15, -1.831180728779827e-17,
  1.992727433899228e-19,  1.074717323745659e-20,  1.235198222907293e+00,  8.322810306689460e-03, -4.560575518872883e-05, -3.125099537096330e-08,  5.164570682065107e-09,
 -9.520728949515103e-12,  2.648005370961150e-14, -1.929856688137498e-14, -8.580088731803285e-16, -1.026668728482640e-17,  1.180475402407379e-19,  6.860682423886802e-21,
  1.431916813797484e+00,  6.431182574896769e-03, -4.345422409644022e-05,  1.452357403802238e-07,  2.071504804770795e-09, -5.424336421004351e-12,  1.791328919699084e-13,
 -1.570147196662191e-14, -5.495554305674170e-16, -6.637513071537323e-18,  7.370061072295251e-20,  4.625109437861281e-21,  1.594759627792341e+00,  4.709338719525297e-03,
 -3.576162008363255e-05,  1.929109009938713e-07,  3.448573014394426e-10,  3.173127305364404e-12,  1.156843763011977e-13, -1.113692873552076e-14, -3.486701336039254e-16,
 -4.424216487228057e-18,  4.852292780529949e-20,  3.062093553782152e-21,  1.727176087916342e+00,  3.228233124603887e-03, -2.635918330974113e-05,  1.742532671342009e-07,
 -3.868245823288216e-10,  7.503296852898266e-12,  3.781407699113747e-14, -7.043367882918957e-15, -2.178825278083836e-16, -2.831099844325068e-18,  3.118708918466025e-20,
  1.944312833597056e-21,  1.831678404513351e+00,  2.016921814433633e-03, -1.726666578713056e-05,  1.274598407153252e-07, -5.325321805596658e-10,  7.580140501454759e-12,
 -5.301515802764780e-15, -3.986275378064801e-15, -1.289525893479122e-16, -1.668173343056725e-18,  1.853851730600122e-20,  1.148468025269719e-21,  1.910070067716446e+00,
  1.086929073577441e-03, -9.598242538693992e-06,  7.561614574121516e-08, -3.989881832141679e-10,  5.293914759755799e-12, -1.635249475142443e-14, -1.951104352278398e-15,
 -6.747955400854029e-17, -8.560586833699152e-19,  9.589447613046936e-21,  5.952042840394885e-22,  1.963607407720507e+00,  4.422974305946720e-04, -3.981976033053702e-06,
  3.258751894233288e-08, -1.923468539166201e-10,  2.493535703175264e-12, -1.066628860914594e-14, -7.344455822174575e-16, -2.705637031242972e-17, -3.358582911832908e-19,
  3.783454846944420e-21,  2.362177413038540e-22,  1.993113695454624e+00,  8.393885073018426e-05, -7.633491977298129e-07,  6.367866120124618e-09, -3.956532037719138e-11,
  5.087693515062651e-13, -2.457364050865588e-15, -1.328976636468611e-16, -5.102016434080156e-18, -6.239379879430952e-20,  7.050323045480413e-22,  4.424196150881438e-23,
  8.664835195184575e-02,  4.878732358531339e-03,  1.741748746950236e-04,  4.248460675038149e-06,  5.244670089417534e-08, -9.700530677233252e-10, -7.499796530268320e-11,
 -2.080701874812544e-12, -2.025165021677117e-14,  8.622394875107432e-16,  4.849093764185202e-17,  1.159121970727516e-18,  4.401551399126075e-01,  1.168904556846236e-02,
  8.837725277947565e-05, -1.450946229052339e-06, -1.467319156498336e-08,  6.568259039470405e-10,  3.002481176419060e-12, -5.070739620311614e-13, -8.079638762334937e-15,
  1.327566066292826e-16,  4.239178287687179e-18,  1.239102805430073e-20,  7.669791356123863e-01,  1.158836782927398e-02, -6.063225073609179e-06, -9.320363476153239e-07,
  1.200619081984405e-08,  1.667994109707145e-10, -5.048863081873146e-12, -1.351424662658592e-13, -1.994911313859420e-15,  9.368283153577202e-20,  1.433098099554575e-18,
  4.267333711577023e-20,  1.040209536254248e+00,  9.911628452579977e-03, -3.875871985587102e-05, -2.799679717076920e-07,  9.431598633609489e-09, -1.455967610389273e-12,
 -2.152327081319450e-12, -7.117726783412076e-14, -1.598962998088351e-15,  2.598501478004301e-18,  9.532729272433721e-19,  2.551912656720016e-20,  1.267759359975505e+00,
  7.957853580766377e-03, -4.549178519412548e-05,  4.964988590289522e-08,  4.919431255045086e-09, -1.876396835461686e-11, -9.432589817941778e-13, -5.103081828734542e-14,
 -1.048607521762581e-15,  2.929346627983403e-18,  6.153337561238493e-19,  1.698563888294124e-20,  1.456958099838880e+00,  6.091075923302046e-03, -4.151585424740561e-05,
  1.775577438954277e-07,  1.959302633807062e-09, -8.576969032848017e-12, -5.358223254390998e-13, -3.605073324593229e-14, -6.719052198185689e-16,  2.039404978128303e-18,
  4.098659440084727e-19,  1.145547879354394e-20,  1.613039597237905e+00,  4.432604462033291e-03, -3.341134809126989e-05,  1.989567696798689e-07,  4.037580822767656e-10,
  8.206105679076191e-13, -3.718021486741458e-13, -2.414271899294745e-14, -4.308671774365000e-16,  1.317047254802810e-18,  2.715343760988527e-19,  7.589530837731073e-21,
  1.739680383150754e+00,  3.025629929736904e-03, -2.430038708675171e-05,  1.692315993736403e-07, -2.480822961092507e-10,  5.175686586559892e-12, -2.694565155511959e-13,
 -1.519858617221991e-14, -2.705386523636575e-16,  8.350074283972830e-19,  1.731617633750641e-19,  4.829617794367636e-21,  1.839479322435155e+00,  1.884772963902242e-03,
 -1.578341558262484e-05,  1.200982583942996e-07, -3.938602085894180e-10,  5.599718867888050e-12, -1.820095596050845e-13, -8.808100809608880e-15, -1.598007363793046e-16,
  5.044152333786366e-19,  1.025609276399462e-19,  2.857307574295840e-21,  1.914269816045238e+00,  1.013671980486771e-03, -8.725788786390100e-06,  7.003474584514497e-08,
 -3.028271282529531e-10,  3.977536370872958e-12, -1.049635892124928e-13, -4.466027570907705e-15, -8.316822804657208e-17,  2.698177272665391e-19,  5.317487788870884e-20,
  1.481557900946057e-21,  1.965315293448459e+00,  4.119571623895922e-04, -3.607814049188340e-06,  2.988614578662130e-08, -1.472491330060045e-10,  1.883398080449791e-12,
 -4.482018264168601e-14, -1.739295221412808e-15, -3.315801629759847e-17,  1.101602810658733e-19,  2.108515582178727e-20,  5.878616205283980e-22,  1.993437707019111e+00,
  7.812769775206860e-05, -6.904119756753038e-07,  5.811398769751570e-09, -3.038420676733733e-11,  3.849198524651219e-13, -8.736613846384049e-15, -3.219380655829991e-16,
 -6.228995485243913e-18,  2.100097987770336e-20,  3.945404236285429e-21,  1.100647976709771e-22,  1.092902333033453e-01,  6.488111148792116e-03,  2.291780688344694e-04,
  4.813994594538427e-06,  1.012703656048795e-08, -3.497827105671322e-09, -1.344243580468720e-10, -1.760609118730630e-12,  5.732475041797533e-14,  3.698691259754770e-15,
  8.327753353284868e-17, -3.177537893388842e-19,  4.882107686428479e-01,  1.232342500748407e-02,  6.998915107260990e-05, -1.581994525680902e-06, -2.093978864259714e-09,
  5.349225758106154e-10, -1.385245423258467e-11, -6.543271840482525e-13,  5.151197408428669e-17,  3.334562608524157e-16,  6.493072554885041e-18,  1.037838095900749e-19,
  8.131696429289350e-01,  1.149859382881058e-02, -1.601012403193635e-05, -7.212447230687965e-07,  1.378844823374753e-08, -6.493593793457450e-12, -9.622820771047181e-12,
 -1.835565632718482e-13, -4.104502153661707e-16,  1.056116633152781e-16,  4.095012065911944e-18,  7.514794980878692e-20,  1.079218224238135e+00,  9.590661404816460e-03,
 -4.122504775959350e-05, -1.328794443320492e-07,  8.696130273273254e-09, -8.239817418044637e-11, -4.780474678996825e-12, -1.109051699501863e-13, -4.897713253986408e-16,
  6.956580525316105e-17,  2.535771040279598e-18,  4.341384642011856e-20,  1.298868517260426e+00,  7.597601387855904e-03, -4.444157465518133e-05,  1.235777425731341e-07,
  4.183597553726690e-09, -6.203221110786411e-11, -2.782481700589678e-12, -7.643762075989922e-14, -2.823761792821564e-16,  4.654495900402018e-17,  1.649989372876562e-18,
  2.763197373206066e-20,  1.480672371437688e+00,  5.767985340446728e-03, -3.920603081843538e-05,  2.064508372231628e-07,  1.565633596223335e-09, -3.577096280434721e-11,
 -1.806147670600260e-12, -5.206454485370016e-14, -1.574697945002237e-16,  3.113372614396789e-17,  1.097219680589858e-18,  1.799216524824347e-20,  1.630250705429374e+00,
  4.174970271536247e-03, -3.098682747062213e-05,  2.048069356035339e-07,  2.686467313468383e-10, -1.763571949710616e-11, -1.214450157407226e-12, -3.431725323687462e-14,
 -9.168100980856786e-17,  2.054179625637507e-17,  7.223331927604145e-19,  1.163316745631359e-20,  1.751406869553166e+00,  2.839287268730904e-03, -2.229158184755656e-05,
  1.655776452055061e-07, -2.484356663206942e-10, -7.289169531058870e-12, -7.994345535650912e-13, -2.155650570496157e-14, -5.471501387659638e-17,  1.306168667778588e-17,
  4.580219932736825e-19,  7.275450467070319e-21,  1.846774864590379e+00,  1.764169738471649e-03, -1.437737306839731e-05,  1.143614063579035e-07, -3.483152351783793e-10,
 -2.253975189801713e-12, -4.902369018631944e-13, -1.255495892485972e-14, -3.173128316115821e-17,  7.733288833151174e-18,  2.702387037556258e-19,  4.250334273343762e-21,
  1.918190104270028e+00,  9.471498934811043e-04, -7.912390034402484e-06,  6.564140445026517e-08, -2.600480665027314e-10, -3.157309869534685e-13, -2.620479049622081e-13,
 -6.414159604163181e-15, -1.649552146079209e-17,  4.014444711674993e-18,  1.398022116168321e-19,  2.184040485142011e-21,  1.966907615062422e+00,  3.844915256794365e-04,
 -3.262312691313725e-06,  2.775445758547457e-08, -1.248611849688820e-10,  1.142944507466237e-13, -1.062866942120859e-13, -2.515710149001867e-15, -6.609087179275760e-18,
  1.594490166577507e-18,  5.537377148266176e-20,  8.614011371396209e-22,  1.993739601874991e+00,  7.287557885254963e-05, -6.233842354571129e-07,  5.371997688567103e-09,
 -2.562139409027555e-11,  4.659533209881442e-14, -2.014855052058942e-14, -4.677791237033190e-16, -1.247202702295594e-18,  2.987208753276106e-19,  1.035664511010583e-20,
  1.607527263978856e-22,  1.392707588498654e-01,  8.548844512817396e-03,  2.850088698395220e-04,  4.229838656285946e-06, -9.441442297549610e-08, -6.964662937551014e-09,
 -1.340635552123833e-10,  2.722139681502977e-12,  2.316046098679279e-13,  4.952301370195272e-15, -7.683300148427701e-17, -7.869182916195478e-18,  5.385041465225567e-01,
  1.280749828138576e-02,  5.108206776707621e-05, -1.554038461539980e-06,  3.851207681307983e-09, -4.076972498653202e-12, -2.993150904248637e-11, -4.006371651969593e-13,
  1.793232301279590e-14,  6.883688742212765e-16,  1.028261734256692e-17, -5.087733765635759e-20,  8.588582102355142e-01,  1.133954356279117e-02, -2.339101825127028e-05,
 -5.159335121623811e-07,  1.094465096297336e-08, -2.958017323703893e-10, -1.411340566872406e-11, -9.817688861193792e-14,  7.055704588454207e-15,  3.228668398983176e-16,
  5.918912880137892e-18, -4.951164436876508e-20,  1.116914287027831e+00,  9.256677166262899e-03, -4.206222978947109e-05, -1.420927493600058e-08,  5.652820550231755e-09,
 -2.330632654791288e-10, -7.569046934695210e-12, -6.355686064917942e-14,  4.232974046936156e-15,  1.994297934100867e-16,  3.388193320683798e-18, -3.912244049890114e-20,
  1.328558697623970e+00,  7.249016995159859e-03, -4.261169022144705e-05,  1.762404785626448e-07,  2.104927177912628e-09, -1.534575276242508e-10, -4.693989473885793e-12,
 -4.383617767969441e-14,  2.821922214471980e-15,  1.295799000730560e-16,  2.107683745379930e-18, -2.910287930239496e-20,  1.503133213828415e+00,  5.464600466509285e-03,
 -3.661090142614902e-05,  2.229330262706657e-07,  3.013260762604208e-10, -9.580802135364767e-11, -3.097587195035176e-12, -2.936725754055570e-14,  1.905658872814777e-15,
  8.560572003636362e-17,  1.354326002887555e-18, -2.100580993699001e-20,  1.646470415497378e+00,  3.936940752213121e-03, -2.852100719211263e-05,  2.043781512850087e-07,
 -4.513813742320301e-10, -5.773950174912947e-11, -2.060350689032709e-12, -1.899426235912829e-14,  1.264262151015241e-15,  5.603130437881642e-17,  8.686115732942285e-19,
 -1.460022235832109e-20,  1.762419817449063e+00,  2.668815904234110e-03, -2.033724202463319e-05,  1.591920861843220e-07, -6.336462277531917e-10, -3.334159274913621e-11,
 -1.328453614184623e-12, -1.172366806603886e-14,  8.045508481294096e-16,  3.539226276669523e-17,  5.401178473682590e-19, -9.613553729835616e-21,  1.853610052822896e+00,
  1.654537192456787e-03, -1.304235559465053e-05,  1.076709627824067e-07, -5.387294584066507e-10, -1.801294297145420e-11, -7.974223240861356e-13, -6.726176784684888e-15,
  4.754353662696538e-16,  2.083540996194354e-17,  3.141434283970902e-19, -5.825113462961819e-21,  1.921856990695944e+00,  8.869278272482468e-04, -7.151137935428149e-06,
  6.102839481085789e-08, -3.433889888790693e-10, -8.643420253216105e-12, -4.186714144697096e-13, -3.395426597288883e-15,  2.460968432350171e-16,  1.076630111688001e-17,
  1.608779756361369e-19, -3.069657555304881e-21,  1.968395444505189e+00,  3.596904313471968e-04, -2.941684057807778e-06,  2.561283097119017e-08, -1.536271652842081e-10,
 -3.235811095582964e-12, -1.676399680966054e-13, -1.320414863512912e-15,  9.748939161566393e-17,  4.262119367056677e-18,  6.330117356328169e-20, -1.230484711052337e-21,
  1.994021528327468e+00,  6.813927006184834e-05, -5.614462956912761e-07,  4.938860329541816e-09, -3.055579744636137e-11, -5.855547511086528e-13, -3.154941941564308e-14,
 -2.443387606339490e-16,  1.823360714434644e-17,  7.969880741085044e-19,  1.179738470127862e-20, -2.316146661471005e-22,  1.782963405442229e-01,  1.099474106535745e-02,
  3.216511678409501e-04,  1.472776400795462e-06, -2.548205388568127e-07, -8.305810537565930e-09,  6.391990015690888e-11,  1.159046769484099e-11,  2.536084511409275e-13,
 -6.678612473211637e-15, -5.021759653358627e-16, -6.696316647279083e-18,  5.904344809034852e-01,  1.314233562944980e-02,  3.266727908074605e-05, -1.534431121508039e-06,
 -3.881052850280523e-09, -7.668523395914111e-10, -2.892518036317041e-11,  6.287185566051086e-13,  4.701169789996939e-14,  7.505766782297910e-16, -1.746327711682709e-17,
 -1.440514612491328e-18,  9.038063737585369e-01,  1.113005611258540e-02, -2.878749751972372e-05, -4.068750393030693e-07,  1.601375589139346e-09, -6.298688718484499e-10,
 -1.169088816584487e-11,  3.470532382297888e-13,  2.115311693605899e-14,  3.688408609326406e-16, -8.286999037504257e-18, -6.774661882941766e-19,  1.153268541000302e+00,
  8.920614903567875e-03, -4.187665232809573e-05,  2.883894820268103e-08, -8.590097661369888e-10, -4.133672062494532e-10, -6.228713039783434e-12,  2.048053907667718e-13,
  1.268641902079659e-14,  2.136292931408415e-16, -5.348575664601098e-18, -3.971951022236375e-19,  1.356886822108822e+00,  6.916881414512417e-03, -4.041640874182032e-05,
  1.790714782760257e-07, -2.117411251892880e-09, -2.658623171583234e-10, -3.869093689327107e-12,  1.318043011534435e-13,  8.213216561765727e-15,  1.326911469183407e-16,
 -3.624005786425411e-18, -2.527259379546636e-19,  1.524422673899944e+00,  5.182323382049899e-03, -3.398347486262819e-05,  2.082696550048408e-07, -2.376049415002567e-09,
 -1.699858498263668e-10, -2.548468371583425e-12,  8.754967810148141e-14,  5.422506217183493e-15,  8.485993543962449e-17, -2.470954734035521e-18, -1.651077250042338e-19,
  1.661777063508959e+00,  3.718354376289276e-03, -2.615885296289887e-05,  1.851582781018637e-07, -2.111493504740819e-09, -1.069494229071782e-10, -1.688376825648130e-12,
  5.786465338049559e-14,  3.544890859781795e-15,  5.420931086624456e-17, -1.654647642650924e-18, -1.072539959680526e-19,  1.772781459121056e+00,  2.513524617194366e-03,
 -1.851552744610612e-05,  1.419438016305863e-07, -1.625430693606929e-09, -6.496331637663754e-11, -1.083806342724451e-12,  3.691713966025559e-14,  2.235132034117019e-15,
  3.361796369180393e-17, -1.062420307307139e-18, -6.736351714614308e-20,  1.860027455216628e+00,  1.555185724826057e-03, -1.181735862683882e-05,  9.510585056084994e-08,
 -1.093547998319244e-09, -3.693325966208113e-11, -6.479700232428931e-13,  2.192295307111029e-14,  1.313263376450239e-15,  1.952101701318494e-17, -6.327706053904004e-19,
 -3.948476480671714e-20,  1.925294768206721e+00,  8.325379215317519e-04, -6.459274708463804e-06,  5.359390304153340e-08, -6.181929124292287e-10, -1.855102413681932e-11,
 -3.391177758065913e-13,  1.140598637078237e-14,  6.774150711639186e-16,  9.987852912702630e-18, -3.296134728092320e-19, -2.033729882400214e-20,  1.969789018556784e+00,
  3.373382196046758e-04, -2.651936870994599e-06,  2.241419075208770e-08, -2.590981289048251e-10, -7.195466420833984e-12, -1.354807986929353e-13,  4.536981852506257e-15,
  2.678150710171520e-16,  3.928086209458706e-18, -1.311633570541879e-19, -8.033411355410704e-21,  1.994285464369920e+00,  6.387529101646415e-05, -5.056357651929674e-07,
  4.314363869659174e-09, -4.993035590186232e-11, -1.329965637160056e-12, -2.546513913277668e-14,  8.506471529020565e-16,  5.004063147142818e-17,  7.319208396070086e-19,
 -2.459417817277265e-20, -1.500383455942206e-21,  2.274205718385097e-01,  1.355784976884130e-02,  3.099820133280409e-04, -3.727353747979296e-06, -3.760381332504603e-07,
 -2.326673279875784e-09,  4.373083643009780e-10,  1.190299303610414e-11, -3.402758400799056e-13, -2.342457327761521e-14, -4.834010631629171e-17,  3.086745299100789e-17,
  6.434065993891730e-01,  1.332759787867617e-02,  1.327748822653954e-05, -1.747654594678180e-06, -2.377875950839236e-08, -1.063278941103613e-09,  1.198205875121107e-11,
  2.279103628167490e-12,  4.228641573532851e-14, -1.586511081807855e-15, -9.984538353642357e-17, -1.296375834049447e-18,  9.478343308192084e-01,  1.087962769275266e-02,
 -3.396874815599925e-05, -4.924751359053353e-07, -1.258094764042796e-08, -7.090285135191243e-10,  8.649737205525842e-12,  1.103299521410901e-12,  1.976490845872371e-14,
 -7.000900623748214e-16, -4.488732295491901e-17, -5.613322314000747e-19,  1.188281957302398e+00,  8.586084499210932e-03, -4.190471286430268e-05, -5.632209048560088e-08,
 -9.897942401157482e-09, -4.434953220275662e-10,  5.824576686024242e-12,  6.528564987680752e-13,  1.155737699471470e-14, -4.180898735878283e-16, -2.573974686837158e-17,
 -2.881235288774246e-19,  1.383919917851927e+00,  6.601141303061661e-03, -3.865782525730944e-05,  9.944071936899121e-08, -7.897658525100517e-09, -2.819242808761639e-10,
  3.877283456547360e-12,  4.182140690006371e-13,  7.277798310142983e-15, -2.715625704393979e-16, -1.611086059559439e-17, -1.633657769350216e-19,  1.544622786935702e+00,
  4.919531939402742e-03, -3.183210897529692e-05,  1.409445618720184e-07, -6.079255157314748e-09, -1.803743217830584e-10,  2.563336905142838e-12,  2.748045656238828e-13,
  4.698492445566722e-15, -1.803144909887480e-16, -1.039839467399597e-17, -9.709016250200199e-20,  1.676244972758050e+00,  3.517223689261907e-03, -2.421527737188333e-05,
  1.328589516999097e-07, -4.453027088004656e-09, -1.141152581948554e-10,  1.662809893935220e-12,  1.793970091456048e-13,  3.018918808547089e-15, -1.185742986126502e-16,
 -6.694542979352839e-18, -5.842503101761754e-20,  1.782549333835554e+00,  2.371666029661522e-03, -1.701436352196524e-05,  1.046365617132645e-07, -3.056139982886360e-09,
 -6.982092755368062e-11,  1.037528805970502e-12,  1.131383982100525e-13,  1.878623922903726e-15, -7.515722163735259e-17, -4.176950827450455e-18, -3.452716693500855e-20,
  1.866065849272374e+00,  1.464854268233636e-03, -1.080739275413166e-05,  7.115482846996072e-08, -1.911638231755624e-09, -3.998710212197209e-11,  6.033399208168495e-13,
  6.653356836073787e-14,  1.093013072765673e-15, -4.435022272459029e-17, -2.436499642251541e-18, -1.930376995637661e-20,  1.928525367335957e+00,  7.832377412782771e-04,
 -5.888760938549180e-06,  4.044808779721466e-08, -1.031146574129823e-09, -2.021399289706974e-11,  3.084989210884488e-13,  3.435436310191381e-14,  5.598429698665288e-16,
 -2.295273411345901e-17, -1.250683178904811e-18, -9.600740004908218e-21,  1.971097528915242e+00,  3.171163357189384e-04, -2.412998665390055e-06,  1.700246542148117e-08,
 -4.198652771781483e-10, -7.878373063998339e-12,  1.211804841021134e-13,  1.359337116965124e-14,  2.203024861418873e-16, -9.095026752206574e-18, -4.929280856816884e-19,
 -3.703581761761380e-21,  1.994533181208821e+00,  6.002153024595686e-05, -4.596115969130710e-07,  3.281048515495929e-09, -7.970945363214140e-11, -1.460291167468731e-12,
  2.255859850705931e-14,  2.541190360365224e-15,  4.105931243146388e-17, -1.701528353296374e-18, -9.195280531651631e-20, -6.827854530994417e-22,  2.861845497374338e-01,
  1.575711804077841e-02,  2.297010737406495e-04, -9.464333433648999e-06, -3.000995469196608e-07,  1.021891489273116e-08,  5.060815280432406e-10, -9.834567271261012e-12,
 -8.460519169573302e-13,  5.001653150319081e-15,  1.316047486131344e-15,  8.878677276204886e-18,  6.967856158870804e-01,  1.334206355283019e-02, -1.056441386594391e-05,
 -2.259122723352104e-06, -3.653712089595774e-08,  6.180237991628647e-11,  8.053877025600057e-11,  1.946962795299932e-12, -8.275056858746643e-14, -4.645874758719125e-15,
  1.192146273747231e-17,  7.158516737266686e-18,  9.907658219822519e-01,  1.057986838589194e-02, -4.148675390989010e-05, -7.845705956728041e-07, -2.195944819512194e-08,
 -9.533150074609381e-11,  4.207563534719294e-11,  9.836583536549257e-13, -3.637942401700514e-14, -2.132221965830214e-15,  1.024608947364729e-19,  2.946397580690888e-18,
  1.221946952280200e+00,  8.244859399604260e-03, -4.378062575389152e-05, -2.713359224727797e-07, -1.575886617299193e-08, -6.372933470894647e-11,  2.558212041739223e-11,
  5.841923972745464e-13, -2.097994485439192e-14, -1.224075000543978e-15,  6.950827136118981e-20,  1.626299750178095e-18,  1.409709984817794e+00,  6.294129166152345e-03,
 -3.838072844462773e-05, -6.267914685537269e-08, -1.157592141230530e-08, -3.557954656783961e-11,  1.648653328644486e-11,  3.723241479974565e-13, -1.328554526422075e-14,
 -7.650264407501742e-16,  3.144130978130881e-19,  9.980002125113941e-19,  1.563799661088829e+00,  4.669748271570858e-03, -3.082494372075587e-05,  2.097552924055802e-08,
 -8.396528029702756e-09, -1.842298978596245e-11,  1.081571778215555e-11,  2.430275204926841e-13, -8.672421064799384e-15, -4.927892053817441e-16,  3.847847941463465e-19,
  6.365973834944588e-19,  1.689934610471057e+00,  3.328517153367897e-03, -2.311176101441965e-05,  4.735575947890379e-08, -5.896498703276745e-09, -8.813006257554088e-12,
  7.031013287563872e-12,  1.576673698070329e-13, -5.637228763374235e-15, -3.166588161545576e-16,  3.485503739274807e-19,  4.067348249175657e-19,  1.791770425050357e+00,
  2.239650765824824e-03, -1.609066931906539e-05,  4.707576155927636e-08, -3.926679667919101e-09, -3.765617735186714e-12,  4.413118592710301e-12,  9.891301047866534e-14,
 -3.544552587239118e-15, -1.972525021768976e-16,  2.683002092328199e-19,  2.524697838954664e-19,  1.871756952141438e+00,  1.381238270781116e-03, -1.015904789476609e-05,
  3.563639898583165e-08, -2.403972996698295e-09, -1.345273768869718e-12,  2.583853881792169e-12,  5.792541698955677e-14, -2.080014859652435e-15, -1.149105130666208e-16,
  1.794619591949850e-19,  1.467483281856507e-19,  1.931566741107939e+00,  7.377623056244033e-04, -5.513459021066557e-06,  2.146807504745711e-08, -1.277508248128091e-09,
 -3.496382285866456e-13,  1.329376445249624e-12,  2.981628691838362e-14, -1.072402934035145e-15, -5.892650750552881e-17,  1.007825676632956e-19,  7.514599289614581e-20,
  1.972328503575702e+00,  2.985039959844388e-04, -2.253587083970291e-06,  9.320625260189022e-09, -5.151823549446731e-10, -4.382531026718815e-14,  5.246535315426051e-13,
  1.177275425640952e-14, -4.239143847617619e-16, -2.320882270400775e-17,  4.201405620628338e-20,  2.957152356830221e-20,  1.994766129765358e+00,  5.647854596816786e-05,
 -4.286891830774471e-07,  1.827355358585283e-09, -9.730310553608536e-11,  1.617158609642169e-15,  9.793726164165018e-14,  2.198281480389959e-15, -7.920627013928926e-17,
 -4.327855429889649e-18,  8.070557453973718e-21,  5.511907733243818e-21,  3.520787795128070e-01,  1.707796169672433e-02,  9.582513511597255e-05, -1.211399415300542e-05,
 -1.037794669206325e-08,  1.651864194910124e-08, -5.264580983142412e-11, -2.477947894020629e-11,  1.227599603520887e-13,  3.828808348346561e-14, -1.990978955110790e-16,
 -6.010014296415845e-17,  7.498001779391261e-01,  1.314001225867276e-02, -4.076678545626289e-05, -2.717469406045519e-06, -1.369271483846359e-08,  2.215117628495444e-09,
  7.740379603583898e-11, -2.610885550600769e-12, -1.592802326184959e-13,  2.358412373810258e-15,  2.843161044767029e-16, -2.849555942096426e-19,  1.032353747394211e+00,
  1.020458743166754e-02, -5.287688790919043e-05, -1.090163597583970e-06, -1.249530903200262e-08,  1.049538096534839e-09,  4.343023931008798e-11, -1.122818440140751e-12,
 -7.801295382439184e-14,  7.102960835936688e-16,  1.251639907946283e-16,  5.606038229930095e-19,  1.254199397280749e+00,  7.877444060266131e-03, -4.847268068090168e-05,
 -4.966098032665826e-07, -1.012125191773616e-08,  6.338151914113131e-10,  2.682431999314235e-11, -6.348194255619063e-13, -4.569042228108215e-14,  3.456524191586987e-16,
  6.975318945295710e-17,  3.972200822869499e-19,  1.434263321719531e+00,  5.981024689933920e-03, -4.019108045661957e-05, -2.297145517146143e-07, -7.834735198088259e-09,
  4.141446427512608e-10,  1.738860698527462e-11, -3.953910666137669e-13, -2.883722725146571e-14,  2.016486938419769e-16,  4.277433799966037e-17,  2.559852057413167e-19,
  1.581983913922279e+00,  4.421943820323709e-03, -3.134124808837101e-05, -1.006606374338700e-07, -5.844491191590545e-09,  2.766564651246556e-10,  1.143960055917827e-11,
 -2.547268942981311e-13, -1.868542496361593e-14,  1.261567298335085e-16,  2.720477535253001e-17,  1.632218920888648e-19,  1.702880289857553e+00,  3.144343982193518e-03,
 -2.308273334868356e-05, -3.822209146320301e-08, -4.174378921375751e-09,  1.830345631439768e-10,  7.448358266753168e-12, -1.638837024307538e-13, -1.205428754190822e-14,
  8.011980358705726e-17,  1.732733925201181e-17,  1.027226384681632e-19,  1.800473691129939e+00,  2.112152116564335e-03, -1.588472109597716e-05, -9.966531176518799e-09,
 -2.810439489948200e-09,  1.166663237097557e-10,  4.679706118529646e-12, -1.022309674397615e-13, -7.529517098876975e-15,  4.971499567177076e-17,  1.072581439105439e-17,
  6.259993146245486e-20,  1.877121173073650e+00,  1.301044426666780e-03, -9.951085976801457e-06,  6.972788995954205e-10, -1.733197531461915e-09,  6.917620142003810e-11,
  2.741745761312865e-12, -5.963166808719910e-14, -4.394929000253095e-15,  2.894954557125186e-17,  6.220448812827847e-18,  3.576517897087161e-20,  1.934430730767606e+00,
  6.943493930999731e-04, -5.372542397783147e-06,  2.896132919996526e-09, -9.255264520415433e-10,  3.593745269027646e-11,  1.411237142781988e-12, -3.061062763318848e-14,
 -2.256797938457615e-15,  1.485847045118713e-17,  3.179951863171618e-18,  1.805797266989418e-20,  1.973486978722222e+00,  2.807873498681430e-04, -2.188790360616103e-06,
  1.830107587389808e-09, -3.743778256428171e-10,  1.427856223629296e-11,  5.571190837330552e-13, -1.206498426694054e-14, -8.896477884563808e-16,  5.858533926140054e-18,
  1.249936175487801e-18,  7.034726195219864e-21,  1.994985287580038e+00,  5.311118820645112e-05, -4.156462751491046e-07,  4.125279229365882e-10, -7.082222083174164e-11,
  2.675322197180404e-12,  1.040133429594224e-13, -2.250715282338075e-15, -1.659749373422699e-16,  1.093285495840963e-18,  2.328310628194668e-19,  1.303747395190063e-21,
  4.210303932010789e-01,  1.728384426110212e-02, -4.045175593710291e-05, -9.918783145257325e-06,  2.582841021164278e-07,  8.477462486493035e-09, -5.212793289986651e-10,
 -4.647580827058271e-12,  8.648761861025407e-13, -4.630966982311482e-15, -1.287849120481600e-15,  2.333234376162977e-17,  8.015012439825132e-01,  1.268357799899014e-02,
 -7.299119714365616e-05, -2.514696364571787e-06,  4.088355845331419e-08,  2.768528568851294e-09, -4.073614241934107e-11, -4.569532612990554e-12,  6.947779331191969e-14,
  7.458892645741566e-15, -1.258821570555724e-16, -1.229022493140054e-17,  1.072240896210236e+00,  9.727737376577898e-03, -6.632235363813958e-05, -1.080662656958903e-06,
  1.513539758818820e-08,  1.488858464594098e-09, -1.274563625925984e-11, -2.357372747632034e-12,  1.932962849929067e-14,  3.622469627295904e-15, -2.892738600133146e-17,
 -5.644388905715782e-18,  1.284893488467893e+00,  7.464222025258678e-03, -5.489498651530136e-05, -5.308440659939711e-07,  6.816223496854626e-09,  9.290774359791963e-10,
 -5.938201206849915e-12, -1.411553474131768e-12,  8.163673127989088e-15,  2.089018196950393e-15, -1.046450147291855e-17, -3.125642712210926e-18,  1.457524880766653e+00,
  5.647089858882509e-03, -4.336738753610597e-05, -2.715727771251768e-07,  3.256207449041681e-09,  6.124497073388111e-10, -3.282044223634461e-12, -9.013012739522623e-13,
  4.159683683207048e-15,  1.302388852759586e-15, -4.714488541501442e-18, -1.896117011110785e-18,  1.599160991166092e+00,  4.165293291629363e-03, -3.288862078429565e-05,
 -1.385045462335077e-07,  1.551772125696107e-09,  4.095105571605587e-10, -1.960615142518995e-12, -5.880539545976880e-13,  2.323670914302594e-15,  8.361708114131378e-16,
 -2.390658497133492e-18, -1.194299719775041e-18,  1.715084267571168e+00,  2.957042669377288e-03, -2.379585679653002e-05, -6.827799805427621e-08,  7.053047168847179e-10,
  2.704350319720282e-10, -1.201580427311972e-12, -3.810405106629110e-13,  1.348207560820561e-15,  5.357295310889818e-16, -1.286880062020266e-18, -7.547104643105439e-19,
  1.808666583063711e+00,  1.984041834595162e-03, -1.618108906609463e-05, -3.157791007219792e-08,  2.910079587100292e-10,  1.719216823429073e-10, -7.262649904721866e-13,
 -2.387103626001051e-13,  7.798964296599351e-16,  3.329190705199507e-16, -7.031773150453177e-19, -4.643063085567630e-19,  1.882165684029878e+00,  1.221122268776106e-03,
 -1.005404707661031e-05, -1.321514366397775e-08,  1.011697536608964e-10,  1.016741771565740e-10, -4.150453651881728e-13, -1.396102448741386e-13,  4.307169217842971e-16,
  1.935870588267442e-16, -3.722996102860491e-19, -2.680199672080031e-19,  1.937122117027239e+00,  6.513209111111020e-04, -5.398078249079750e-06, -4.745468608033694e-09,
  2.554240049049708e-11,  5.270483617873423e-11, -2.102918519645642e-13, -7.178483364455041e-14,  2.127689209454314e-16,  9.913872922280923e-17, -1.784877920201607e-19,
 -1.365507722059704e-19,  1.974575136409823e+00,  2.632886783560748e-04, -2.191433184046392e-06, -1.315792379448576e-09,  2.968185221291720e-12,  2.090724116955242e-11,
 -8.223616481782056e-14, -2.832168476047570e-14,  8.178891734032201e-17,  3.901178996314038e-17, -6.728224464962942e-20, -5.355270377248801e-20,  1.995191092442438e+00,
  4.979135669360710e-05, -4.153720735092146e-07, -1.880808128397656e-10, -1.758243608990564e-13,  3.913766343049644e-12, -1.528006743694275e-14, -5.286062577292692e-15,
  1.505470276543234e-17,  7.271163279097709e-18, -1.225556469843794e-20, -9.963297133066274e-21,  4.888753068604556e-01,  1.656284410938363e-02, -1.312844332970447e-04,
 -5.102500321375550e-06,  3.066203486451807e-07, -2.907231975848061e-09, -3.431714433956759e-10,  1.339691478086361e-11,  1.513519872057539e-13, -2.342781722599335e-14,
  3.531656970895751e-16,  2.637730808968944e-17,  8.508971622230701e-01,  1.199373826317905e-02, -9.768963934041240e-05, -1.507033125506543e-06,  7.826961867121899e-08,
  6.993385489251135e-10, -1.087612607888768e-10,  2.320957508487984e-13,  1.663110458241278e-13, -2.732995608719357e-15, -2.251077006703915e-16,  7.764522117405964e-18,
  1.110017093276913e+00,  9.151457222998273e-03, -7.696374492386183e-05, -6.367047720876994e-07,  3.731620220989167e-08,  5.628267626552162e-10, -5.445728140113142e-11,
 -2.669448597126039e-13,  8.458913963409156e-14, -6.233660129928284e-16, -1.197105961455638e-16,  2.420548951996761e-18,  1.313836053141242e+00,  7.002735831245518e-03,
 -6.005629625514547e-05, -2.929694641552003e-07,  2.118855718980680e-08,  4.024217946759153e-10, -3.243879279782081e-11, -2.540996109681467e-13,  4.987334246734553e-14,
 -1.873653182925791e-16, -7.039863249036668e-17,  1.061483095116409e-18,  1.479401116655897e+00,  5.288864377422247e-03, -4.594497648564016e-05, -1.335588684496310e-07,
  1.291817497746986e-08,  2.842274938343451e-10, -2.070746053494304e-11, -1.945036591823304e-13,  3.147887234676085e-14, -5.804364699302457e-17, -4.410199443678654e-17,
  5.490127031527757e-19,  1.615286783874821e+00,  3.896538020326482e-03, -3.415391414061910e-05, -5.582744011628112e-08,  8.089155424593647e-09,  1.980909199091407e-10,
 -1.352637125443189e-11, -1.397658890705495e-13,  2.036560027263807e-14, -1.392276411505021e-17, -2.832987579458617e-17,  3.082955119327145e-19,  1.726527294718342e+00,
  2.763974291132283e-03, -2.438330417351216e-05, -1.861744485511610e-08,  5.056109508648656e-09,  1.344247812769919e-10, -8.778196010834578e-12, -9.604363846244195e-14,
  1.311455104038315e-14,  9.891049746965050e-19, -1.813581511091860e-17,  1.789820152789660e-19,  1.816341888617209e+00,  1.853401094641339e-03, -1.642748226880893e-05,
 -2.450633931021337e-09,  3.071618596904305e-09,  8.706960172575670e-11, -5.507650869039106e-12, -6.251627692282424e-14,  8.178325606983699e-15,  4.848319628266080e-18,
 -1.125693395775037e-17,  1.033775398416078e-19,  1.886888534583086e+00,  1.140227898766403e-03, -1.014095898885754e-05,  2.906331517653123e-09,  1.751680754036755e-09,
  5.216881801989652e-11, -3.225450141660891e-12, -3.751416522265197e-14,  4.767145321665312e-15,  4.531237767600299e-18, -6.538301077216839e-18,  5.696221679539739e-20,
  1.939640780041401e+00,  6.079905825007144e-04, -5.420421788720196e-06,  3.191779569248780e-09,  8.832712123347134e-10,  2.728589670535320e-11, -1.660221253643293e-12,
 -1.962245448359581e-14,  2.445387377958647e-15,  2.919657216879260e-18, -3.345225892848181e-18,  2.807482807120958e-20,  1.975593168810004e+00,  2.457246823210471e-04,
 -2.194175956610377e-06,  1.720899574144731e-09,  3.437646894520213e-10,  1.088634174113123e-11, -6.555081233219386e-13, -7.825783866081723e-15,  9.633021753801699e-16,
  1.299779801928890e-18, -1.315487310945349e-18,  1.077264748640894e-20,  1.995383604946548e+00,  4.646488823027843e-05, -4.152561333406332e-07,  3.689443408225710e-10,
  6.367455720148152e-11,  2.044119245844581e-12, -1.223980259079751e-13, -1.468927190084941e-15,  1.796451164182406e-16,  2.571472424590093e-19, -2.450926258931879e-19,
  1.980773721865714e-21,  5.527473796934723e-01,  1.534436537839152e-02, -1.660942539005203e-04, -9.805416557749712e-07,  1.965032246286685e-07, -6.738476255399252e-09,
  7.383867175846920e-13,  8.775034908484444e-12, -3.025155898877230e-13, -1.411183505844711e-15,  4.504216399810648e-16, -1.307103288994973e-17,  8.972249020771904e-01,
  1.116136386208330e-02, -1.082294105291012e-04, -2.732487134346249e-07,  6.923568814548705e-08, -1.366020922419837e-09, -5.057157301476575e-11,  2.996925212501613e-12,
 -1.603872431893878e-15, -4.256983598879386e-15,  1.104883340706173e-16,  3.366293193383156e-18,  1.145357997995929e+00,  8.515737535310326e-03, -8.087524043047509e-05,
 -1.818109875126744e-08,  3.629171727155128e-08, -5.749034062842210e-10, -3.236480914104771e-11,  1.445892103606373e-12,  1.261642448664438e-14, -2.291609761181651e-15,
  3.453371835713473e-17,  2.416536866558034e-18,  1.340872426836157e+00,  6.514323448443622e-03, -6.140856209044270e-05,  6.871514017204231e-08,  2.172073068636583e-08,
 -3.034629560227216e-10, -2.129248332004929e-11,  8.351509863142250e-13,  1.112255423284484e-14, -1.369678054854803e-15,  1.425450255007373e-17,  1.557442067605366e-18,
  1.499816611457331e+00,  4.918662785618524e-03, -4.620781467358611e-05,  9.167189655181345e-08,  1.373341280586692e-08, -1.765091231790016e-10, -1.433835292832797e-11,
  5.210998044555717e-13,  8.369598227566943e-15, -8.676237496437851e-16,  6.763128668019011e-18,  1.018374037379827e-18,  1.630325587379397e+00,  3.623012284682177e-03,
 -3.397427836957576e-05,  8.757519567831237e-08,  8.841283605681643e-09, -1.070292781715375e-10, -9.678953645003360e-12,  3.346609818921220e-13,  5.977678755085166e-15,
 -5.615954338729322e-16,  3.448882002774898e-18,  6.700134664847763e-19,  1.737193759774423e+00,  2.569518229003191e-03, -2.407021905143798e-05,  7.223667733070138e-08,
  5.649111525556807e-09, -6.539656573011246e-11, -6.419466569954363e-12,  2.144303962808862e-13,  4.097059586145717e-15, -3.614482297484683e-16,  1.815591178758085e-18,
  4.352835217816474e-19,  1.823493761120909e+00,  1.722783899101048e-03, -1.612820971546084e-05,  5.335588722254967e-08,  3.492849161804563e-09, -3.908815028280175e-11,
 -4.088449784478588e-12,  1.332514701723531e-13,  2.663667698521709e-15, -2.252158158108459e-16,  9.552320285115639e-19,  2.727825476793109e-19,  1.891288153772499e+00,
  1.059767601945652e-03, -9.917372178012032e-06,  3.501315331619368e-08,  2.019731729469346e-09, -2.203417186595881e-11, -2.419398693281519e-12,  7.748020982123065e-14,
  1.597507103748737e-15, -1.311713847055814e-16,  4.840849803588246e-19,  1.594544476405004e-19,  1.941986633950831e+00,  5.650477700309834e-04, -5.286471933855447e-06,
  1.949024435085504e-08,  1.029136816285749e-09, -1.102154058832601e-11, -1.254235581651163e-12,  3.967699817244673e-14,  8.353988063092362e-16, -6.724088817128815e-17,
  2.225752780533629e-19,  8.192859613493622e-20,  1.976541238181156e+00,  2.283582521382124e-04, -2.136165709276152e-06,  8.093652676842013e-09,  4.034220597889119e-10,
 -4.267320750334497e-12, -4.974787364559340e-13,  1.561265547930821e-14,  3.331381527863366e-16, -2.647498262063444e-17,  8.114398905611096e-20,  3.230335103989975e-20,
  1.995562875652429e+00,  4.317991462217084e-05, -4.038949982560378e-07,  1.552398525490182e-09,  7.502256608423410e-11, -7.882455221579620e-13, -9.311544473352316e-14,
  2.909888768529922e-15,  6.252898133290573e-17, -4.935920416206233e-18,  1.448452237945793e-20,  6.026876188696706e-21,  6.114551849313937e-01,  1.401209383635684e-02,
 -1.632591171705002e-04,  1.150567559444345e-06,  7.632096400743305e-08, -4.817309712225401e-09,  1.214438546363106e-10,  6.263376275670752e-13, -1.658779403572676e-13,
  5.737792504612666e-15, -2.974647470531705e-17, -5.537512637564558e-18,  9.401413953646912e-01,  1.029887588755815e-02, -1.059025413736980e-04,  5.769588294904450e-07,
  3.606799320346271e-08, -1.686047695473118e-09,  1.641642705307065e-11,  1.451878646666829e-12, -6.664289497538366e-14,  3.342325674713572e-16,  7.345675118579221e-17,
 -2.863324433893545e-18,  1.178138084799367e+00,  7.876654870128338e-03, -7.808785155143208e-05,  4.420310609943492e-07,  2.026421903556210e-08, -8.833940524539442e-10,
  4.044559578304564e-12,  9.174687202250886e-13, -3.235400230223251e-14, -1.601836553932438e-16,  4.502732953403654e-17, -1.178369026124019e-18,  1.365959960834454e+00,
  6.031660223709373e-03, -5.876670550272894e-05,  3.480772216933849e-07,  1.247239105848270e-08, -5.328347578320637e-10,  9.904532482852988e-13,  5.991110305963074e-13,
 -1.851315816321201e-14, -1.942483461379736e-16,  2.825527334334155e-17, -5.885825497981128e-19,  1.518763702787129e+00,  4.556771890523890e-03, -4.395228309924209e-05,
  2.696357070442916e-07,  7.990116158532551e-09, -3.406133867995093e-10,  4.927489501137772e-14,  4.011341928814588e-13, -1.142945398622667e-14, -1.608188643384068e-16,
  1.834167583055167e-17, -3.268043604637764e-19,  1.644283801308601e+00,  3.357598431785075e-03, -3.217698022608862e-05,  2.026438896291958e-07,  5.176350100965765e-09,
 -2.218792466312391e-10, -2.302272530193255e-13,  2.695584251026833e-13, -7.271885274810494e-15, -1.203911845380082e-16,  1.204186750649352e-17, -1.913166077854962e-19,
  1.747094181925973e+00,  2.381817321371406e-03, -2.272543687450271e-05,  1.459529514417692e-07,  3.316629570591772e-09, -1.433897105070137e-10, -2.713721457106884e-13,
  1.781428791812621e-13, -4.623572659771012e-15, -8.483666321874713e-17,  7.819833940706348e-18, -1.139224229402153e-19,  1.830132127847352e+00,  1.597181994693250e-03,
 -1.519200687859807e-05,  9.900834971928068e-08,  2.052551710259868e-09, -8.957124782380340e-11, -2.260137308704735e-13,  1.131381171569119e-13, -2.855558790594614e-15,
 -5.614807386701752e-17,  4.901319561779125e-18, -6.684171963666036e-20,  1.895371917578143e+00,  9.826085341057083e-04, -9.325931583521944e-06,  6.143772019766309e-08,
  1.186842908384512e-09, -5.224692947531587e-11, -1.560728350639698e-13,  6.680709419447645e-14, -1.652521296106392e-15, -3.407710373600128e-17,  2.866022283295337e-18,
 -3.719088892571987e-20,  1.944164084893517e+00,  5.239460744678272e-04, -4.965260142986797e-06,  3.296265560141734e-08,  6.044853327678309e-10, -2.680554533113457e-11,
 -8.894608755099755e-14,  3.457862834342928e-14, -8.432921064848639e-16, -1.796185421920348e-17,  1.473076302594287e-18, -1.843923448366931e-20,  1.977421249670174e+00,
  2.117572403330522e-04, -2.004796145373750e-06,  1.337662737408084e-08,  2.368438931877462e-10, -1.055899027658053e-11, -3.734354349675431e-14,  1.370065903446451e-14,
 -3.310516778880103e-16, -7.198554540579571e-18,  5.809670442360431e-19, -7.099659770574425e-21,  1.995729277387757e+00,  4.004183600438915e-05, -3.788964725399201e-07,
  2.535010013683369e-09,  4.403022299794319e-11, -1.968989357009856e-12, -7.195872277104254e-15,  2.562929193545847e-15, -6.162242474095422e-17, -1.354681186239638e-18,
  1.084084499637210e-19, -1.307621653517801e-21,  6.649998003003085e-01,  1.277570782883565e-02, -1.447965880482006e-04,  1.756761192236036e-06,  8.194102184563192e-09,
 -2.117708637739395e-09,  9.223093893308073e-11, -1.902461328625600e-12, -1.290931766328728e-14,  2.433550882914727e-15, -8.699781191089282e-17,  1.168300437592567e-18,
  9.796970174416753e-01,  9.486788351645304e-03, -9.653200261531830e-05,  9.154676120740645e-07,  8.436720020535061e-09, -1.019570851155023e-09,  3.173507023960615e-11,
 -1.459251269121586e-13, -2.844362236544890e-14,  1.204538904792357e-15, -1.360832411911016e-17, -8.018397419045048e-19,  1.208434990106728e+00,  7.277407817002759e-03,
 -7.138521336747908e-05,  6.368520922972702e-07,  5.057417935331630e-09, -5.905701053645776e-10,  1.623818728936061e-11,  3.230941202289223e-14, -1.849599131257087e-14,
  6.131778634081963e-16, -1.504740301700672e-18, -6.081383827645121e-19,  1.389176549083068e+00,  5.580848600723692e-03, -5.372727866266019e-05,  4.681554162357286e-07,
  3.062702820741983e-09, -3.747706739585073e-10,  9.645959348047446e-12,  5.575594460874666e-14, -1.221702082005862e-14,  3.568204039751512e-16,  9.627463548329899e-19,
 -4.140297397738486e-19,  1.536310451675565e+00,  4.219767972469852e-03, -4.016561705941635e-05,  3.460937205653244e-07,  1.878973256330172e-09, -2.470846161910518e-10,
  6.106255917416906e-12,  5.054719134189328e-14, -8.225684060874441e-15,  2.218477918567346e-16,  1.361596791123194e-18, -2.807534985383113e-19,  1.657216318046221e+00,
  3.110988987212781e-03, -2.938991717488270e-05,  2.517351793269863e-07,  1.152493065089649e-09, -1.643082339975718e-10,  3.952453124644046e-12,  3.969020548713024e-14,
 -5.544491850511532e-15,  1.415879101320005e-16,  1.215788149689451e-18, -1.893490476503690e-19,  1.756269928715738e+00,  2.207708570861967e-03, -2.074751931028426e-05,
  1.771006062616584e-07,  6.962390806926817e-10, -1.077358543972704e-10,  2.543559514070512e-12,  2.882739666850810e-14, -3.670759712719868e-15,  9.014332407229043e-17,
  9.364261308472518e-19, -1.251773744829110e-19,  1.836285920185327e+00,  1.480823118011466e-03, -1.386446575006407e-05,  1.181022973776216e-07,  4.065315799276603e-10,
 -6.800630779446880e-11,  1.584454123460085e-12,  1.947651661621935e-14, -2.333852628791307e-15,  5.570031845348423e-17,  6.532545432347676e-19, -7.943240789176377e-20,
  1.899158158751650e+00,  9.111948678052625e-04, -8.508422780376023e-06,  7.238511937946874e-08,  2.228219380585939e-10, -3.996819480677193e-11,  9.225098146747675e-13,
  1.199200788279410e-14, -1.379067404331290e-15,  3.223694611152133e-17,  4.099428867217705e-19, -4.684952949626992e-20,  1.946183109355127e+00,  4.859305188787272e-04,
 -4.528987061962469e-06,  3.849981040425992e-08,  1.084708237208709e-10, -2.061473520433257e-11,  4.727355370219562e-13,  6.383894121671388e-15, -7.140962439419334e-16,
  1.644960057811878e-17,  2.207882671153803e-19, -2.422238662033090e-20,  1.978237288584265e+00,  1.964095586030076e-04, -1.828365549936309e-06,  1.553523908369807e-08,
  4.109111903134539e-11, -8.148470552370202e-12,  1.860811743408564e-13,  2.574866734228108e-15, -2.830096013796776e-16,  6.456952773979102e-18,  8.967078976399705e-20,
 -9.589367776064350e-21,  1.995883588060861e+00,  3.714137076660819e-05, -3.455230841218988e-07,  2.935149614611391e-09,  7.490308317148923e-12, -1.522304132315122e-12,
  3.468676094863519e-14,  4.862094889580786e-16, -5.294831444149022e-17,  1.201814852317689e-18,  1.699187528742478e-20, -1.792978997607080e-21,  7.139191767434558e-01,
  1.170136053278141e-02, -1.239866041138715e-04,  1.651174463316516e-06, -1.631555142630312e-08, -5.303037920811634e-10,  4.222821006005347e-11, -1.469211925859912e-12,
  2.649517764030388e-14,  1.534585504335919e-16, -2.865272163122621e-17,  1.050011012806446e-18,  1.016170754071870e+00,  8.759475906530879e-03, -8.528255709056499e-05,
  9.259334979499084e-07, -5.048171558360968e-09, -3.746067603270149e-10,  2.043410236659372e-11, -5.051837462548468e-13,  1.178562485581992e-15,  4.244442963438608e-16,
 -1.757624183341141e-17,  2.922931772275637e-19,  1.236451787626668e+00,  6.737508044142108e-03, -6.358017206476223e-05,  6.438075711389386e-07, -3.047353495041234e-09,
 -2.378617013472023e-10,  1.187651734879093e-11, -2.528724976908616e-13, -1.369352506511121e-15,  2.892892879410938e-16, -9.582151906026664e-18,  9.125623502150845e-20,
  1.410676414798250e+00,  5.173846883221783e-03, -4.802213514363434e-05,  4.696586254419345e-07, -2.170471634711604e-09, -1.572619734766575e-10,  7.563281983363791e-12,
 -1.474822006877680e-13, -1.521363629289874e-15,  1.951889013710438e-16, -5.764713823283731e-18,  3.095828798855402e-20,  1.552573469060268e+00,  3.915243323255786e-03,
 -3.596916119238690e-05,  3.446266594790371e-07, -1.605186272780836e-09, -1.060160278135522e-10,  5.004276447003763e-12, -9.205766873668822e-14, -1.264849799832697e-15,
  1.329907338829823e-16, -3.654329075572424e-18,  9.460938234226180e-21,  1.669209323450118e+00,  2.888050776330257e-03, -2.634990669557615e-05,  2.491178269715710e-07,
 -1.178547116866768e-09, -7.144321839145978e-11,  3.339130487926551e-12, -5.895222172024238e-14, -9.582437364435858e-16,  9.030952364673903e-17, -2.361548709174919e-18,
  1.424069278169427e-21,  1.764782341600643e+00,  2.050276941868693e-03, -1.861557425304746e-05,  1.743942790727767e-07, -8.382933166742735e-10, -4.723869791059684e-11,
  2.196215827346466e-12, -3.762967978443997e-14, -6.828475731432480e-16,  6.008607063695022e-17, -1.516319456384574e-18, -1.305257663678169e-21,  1.841996394200321e+00,
  1.375597321355412e-03, -1.244620827835832e-05,  1.158498643757229e-07, -5.647063187947310e-10, -2.998054820979323e-11,  1.390039428138134e-12, -2.329590847615608e-14,
 -4.560894257318879e-16,  3.833282526369111e-17, -9.425346647299085e-19, -1.839377072415040e-21,  1.902672320354859e+00,  8.466098943544418e-04, -7.640765883838344e-06,
  7.079692737836262e-08, -3.490222603515648e-10, -1.768234806529712e-11,  8.187552815217162e-13, -1.350099546053235e-14, -2.787720633109162e-16,  2.270457317095086e-17,
 -5.477897014846544e-19, -1.510476901353753e-21,  1.948057299181965e+00,  4.515489262184780e-04, -4.068114972143471e-06,  3.757500697535870e-08, -1.868303706236166e-10,
 -9.140930517256029e-12,  4.230219847583242e-13, -6.895623637404854e-15, -1.477014813964594e-16,  1.177576904008571e-17, -2.803310416885094e-19, -9.344036896121735e-22,
  1.978994855154349e+00,  1.825287501044823e-04, -1.642561033247254e-06,  1.514054750351743e-08, -7.572207499975581e-11, -3.618170017226167e-12,  1.674102442972115e-13,
 -2.708354031846356e-15, -5.939933630480769e-17,  4.671805789080290e-18, -1.102433244154186e-19, -4.093677554713907e-22,  1.996026848455241e+00,  3.451810144060677e-05,
 -3.104349072518784e-07,  2.858373542300473e-09, -1.434143856634966e-11, -6.764269158482626e-13,  3.129668081214142e-14, -5.042574568808849e-16, -1.119927239682383e-17,
  8.745298045698858e-19, -2.053961048156730e-20, -8.048335015504736e-23,  7.588593689296902e-01,  1.078377553251809e-02, -1.059444839000314e-04,  1.348082836924936e-06,
 -1.962470196585726e-08,  8.445627273260196e-11,  1.265694179029374e-11, -6.799713297829472e-13,  2.009440506908013e-14, -3.298986659403378e-16, -1.188168330501392e-18,
  2.798256104662131e-19,  1.049912008432887e+00,  8.119867801491336e-03, -7.482955438142306e-05,  8.072774298921262e-07, -8.715500201437668e-09, -3.974560849728201e-11,
  8.300015873581977e-12, -3.322226563341079e-13,  7.046810267667213e-15, -1.395679174859288e-17, -5.078953563031856e-18,  2.093685003390603e-19,  1.262431931724578e+00,
  6.258667659319607e-03, -5.626042144060529e-05,  5.700818006313676e-07, -5.521328815675603e-09, -3.551274834644089e-11,  5.280740524268146e-12, -1.934390868401801e-13,
  3.491006333729910e-15,  2.146950797921496e-17, -3.657043401503165e-18,  1.226978919749478e-19,  1.430638065633074e+00,  4.811440956508768e-03, -4.267036555574206e-05,
  4.181970572219054e-07, -3.841333787104248e-09, -2.578381699284420e-11,  3.518782659463976e-12, -1.232467332178582e-13,  2.010622122928522e-15,  2.351979013835486e-17,
 -2.532284344238556e-18,  7.669458708306163e-20,  1.567684346451717e+00,  3.643472236944206e-03, -3.203905996576093e-05,  3.075951700183054e-07, -2.741636009193557e-09,
 -1.794799888051041e-11,  2.392385414997238e-12, -8.157098011721626e-14,  1.241080081059880e-15,  1.958373660411895e-17, -1.751599139942064e-18,  4.978663997494451e-20,
  1.680358297339602e+00,  2.688805384145106e-03, -2.350829346095895e-05,  2.225930891462569e-07, -1.947173081640574e-09, -1.219666106149215e-11,  1.625139415613924e-12,
 -5.444483890541667e-14,  7.874070442250787e-16,  1.487511844939964e-17, -1.201108928269534e-18,  3.269418532669358e-20,  1.772698458718747e+00,  1.909440178622648e-03,
 -1.662625780751547e-05,  1.559061861208038e-07, -1.347081059057419e-09, -8.047630603770434e-12,  1.082200452532575e-12, -3.582055251758120e-14,  4.988282182438198e-16,
  1.062406560458663e-17, -8.044913587867936e-19,  2.123201406533493e-20,  1.847308185220726e+00,  1.281399881943762e-03, -1.112478418375815e-05,  1.035926603229467e-07,
 -8.875821435145178e-10, -5.073987723125457e-12,  6.909929143133724e-13, -2.267851685561739e-14,  3.069697455713167e-16,  7.108674641297917e-18, -5.156571021122775e-19,
  1.330624452040034e-20,  1.905941726690784e+00,  7.887664624093272e-04, -6.833297517308327e-06,  6.331259565437299e-08, -5.393340030376533e-10, -2.969023463297923e-12,
  4.095564856011338e-13, -1.336160722372072e-14,  1.770804398052253e-16,  4.350785908350289e-18, -3.064437379964789e-19,  7.779282854704007e-21,  1.949801174774897e+00,
  4.207461287249785e-04, -3.639589844651962e-06,  3.360380289725240e-08, -2.851387289063955e-10, -1.523548017990817e-12,  2.125234768788396e-13, -6.905000421468210e-15,
  9.013574789946572e-17,  2.307380066828210e-18, -1.593050057869045e-19,  3.997607078207560e-21,  1.979699805150634e+00,  1.700901926991503e-04, -1.469900640975193e-06,
  1.354043644445427e-08, -1.146096111542493e-10, -5.996084080400424e-13,  8.434221811131263e-14, -2.733081729275326e-15,  3.532085488689788e-17,  9.285175371747661e-19,
 -6.329549748221126e-20,  1.576367186442304e-21,  1.996160164578938e+00,  3.216713455049835e-05, -2.778396166375474e-07,  2.556281325489888e-09, -2.160869025890410e-11,
 -1.117194870127727e-13,  1.579104838803281e-14, -5.109857350423875e-16,  6.567999400117441e-18,  1.751241587022208e-19, -1.185789904244635e-20,  2.941219412572888e-22,
  8.003945486149600e-01,  9.995798005319937e-03, -9.155710360320347e-05,  1.058799227543970e-06, -1.611080920187197e-08,  2.215702478686780e-10,  8.725357481374017e-13,
 -2.192474315087699e-13,  9.274840909509927e-15, -2.408078965981095e-16,  3.680520497953443e-18,  4.663802015713736e-21,  1.081252205036105e+00,  7.557606077004472e-03,
 -6.597765908978050e-05,  6.695724284105200e-07, -8.146023250448349e-09,  7.182555913391188e-11,  1.887174573202903e-12, -1.393537147018770e-13,  4.597991657800268e-15,
 -8.749322017732392e-17,  2.350994345292668e-19,  5.043400754161852e-20,  1.286607616791962e+00,  5.834428958166485e-03, -4.995510145154659e-05,  4.813312684227585e-07,
 -5.337575189709530e-09,  3.878964373007839e-11,  1.396604107871055e-12, -8.863804106936771e-14,  2.687992458026381e-15, -4.349159355151011e-17, -2.176910128416282e-19,
  3.846112329028695e-20,  1.449231390945907e+00,  4.489091990959098e-03, -3.802580362293540e-05,  3.561606422352299e-07, -3.753195693971943e-09,  2.475767770055121e-11,
  9.905755309870889e-13, -5.917001474052143e-14,  1.714916320580285e-15, -2.497370252592620e-17, -2.624086891018177e-19,  2.737053587828535e-20,  1.581767920157448e+00,
  3.401168076880075e-03, -2.861477257165198e-05,  2.632855471618743e-07, -2.686913499069235e-09,  1.681427930235421e-11,  6.963882997677422e-13, -4.031183616509218e-14,
  1.135627345118187e-15, -1.534775083234813e-17, -2.254905342852328e-19,  1.924122418539626e-20,  1.690753545568352e+00,  2.510886751164974e-03, -2.102657487460800e-05,
  1.911425463221641e-07, -1.908737085599530e-09,  1.158814716978865e-11,  4.827000410577438e-13, -2.743684645915685e-14,  7.581635009937264e-16, -9.694764771454666e-18,
 -1.741409481749314e-19,  1.333470067681363e-20,  1.780081524425417e+00,  1.783542591814107e-03, -1.488629110091293e-05,  1.341705817343259e-07, -1.319396802604141e-09,
  7.866670121299946e-12,  3.256410712075450e-13, -1.830191653843161e-14,  4.988768404791031e-16, -6.117586136668582e-18, -1.256580504806905e-19,  8.997206718022062e-21,
  1.852263316415821e+00,  1.197129791518001e-03, -9.967847870018252e-06,  8.928647724399898e-08, -8.683506814390307e-10,  5.120500351420820e-12,  2.097336526307919e-13,
 -1.170293181215179e-14,  3.158697326647307e-16, -3.752139939495638e-18, -8.465532158761879e-20,  5.797113028200675e-21,  1.908992062144672e+00,  7.369907643672595e-04,
 -6.125869246492825e-06,  5.462773496690918e-08, -5.270591876341662e-10,  3.086846541787758e-12,  1.250392604392428e-13, -6.944616238797476e-15,  1.861114602616546e-16,
 -2.158685647098154e-18, -5.205488047400119e-20,  3.457935695705117e-21,  1.951428369095974e+00,  3.931640192071018e-04, -3.263989471264184e-06,  2.901568995366374e-08,
 -2.783885750663046e-10,  1.623659380507948e-12,  6.513678691178674e-14, -3.606899414751398e-15,  9.618171008033025e-17, -1.096560768533234e-18, -2.769405768747909e-20,
  1.802272969648687e-21,  1.980357632127421e+00,  1.589494389242634e-04, -1.318522402440527e-06,  1.169725587535694e-08, -1.118204920918147e-10,  6.505895566953690e-13,
  2.591312042145719e-14, -1.432332377397825e-15,  3.807069945921284e-17, -4.291017654687260e-19, -1.116689893434298e-20,  7.172878523170791e-22,  1.996284573580376e+00,
  3.006118328348218e-05, -2.492578646661802e-07,  2.208868602897715e-09, -2.107468379192451e-11,  1.224676542092632e-13,  4.857757579717601e-15, -2.682629187122793e-16,
  7.117904647295709e-18, -7.973096385514809e-20, -2.108389267127285e-21,  1.344986258311245e-22, -2.008523492640697e+00,  5.548518971404853e-03, -1.691942657413872e-03,
  5.382932191485600e-04, -1.787805674951175e-04,  6.197922683970633e-05, -2.237026535024798e-05,  8.345609890011487e-06, -3.175846262525654e-06,  1.208895743484912e-06,
 -4.465941901187134e-07,  1.443435815818987e-07, -2.007242394440516e+00,  4.626516634110227e-03, -1.298029979320972e-03,  3.825481198457085e-04, -1.190144575930590e-04,
  3.920295612103200e-05, -1.364455430220394e-05,  4.967678524431992e-06, -1.856060862576335e-06,  6.927171779584124e-07, -2.489848194572234e-07,  7.785339153872376e-08,
 -2.006538480115037e+00,  4.133009245891766e-03, -1.104582304913981e-03,  3.122077545544257e-04, -9.402724662774951e-05,  3.030105745854895e-05, -1.041812120135565e-05,
  3.771788038848386e-06, -1.404558620831942e-06,  5.213768204924146e-07, -1.853836803373978e-07,  5.708010101443194e-08, -2.006075888872799e+00,  3.813783235514054e-03,
 -9.860650324230343e-04,  2.712435016064935e-04, -8.010473423998850e-05,  2.551436239401555e-05, -8.727618338467886e-06,  3.155875529401107e-06, -1.174673430170171e-06,
  4.350085258862501e-07, -1.537180568456342e-07,  4.688369839223101e-08, -2.005746790539765e+00,  3.589145810626037e-03, -9.058251544781387e-04,  2.444635635107532e-04,
 -7.126551883101606e-05,  2.254160500518259e-05, -7.692815567972061e-06,  2.781921361836789e-06, -1.035738668384692e-06,  3.830404457189931e-07, -1.347958025286621e-07,
  4.084549900820254e-08, -2.005502837045228e+00,  3.423953875641873e-03, -8.485013870844674e-04,  2.258156846067191e-04, -6.523644291375542e-05,  2.054360156999443e-05,
 -7.003413134830942e-06,  2.533831350540996e-06, -9.437466392770316e-07,  3.487099988882246e-07, -1.223520476903962e-07,  3.690002600794979e-08, -2.005318406780929e+00,
  3.299818866077061e-03, -8.063700661853209e-04,  2.123717732148990e-04, -6.095514535870962e-05,  1.913931828688786e-05, -6.521595165255583e-06,  2.360833547790439e-06,
 -8.796513703214948e-07,  3.248223212749190e-07, -1.137212776547125e-07,  3.417658128340929e-08, -2.005178502450965e+00,  3.206084864809933e-03, -7.750971890055600e-04,
  2.025380193321692e-04, -5.785852963016668e-05,  1.813104465130491e-05, -6.176937687247772e-06,  2.237235558407449e-06, -8.338723051454632e-07,  3.077753440999923e-07,
 -1.075766991596886e-07,  3.224469237672536e-08, -2.005073794052524e+00,  3.136175585067376e-03, -7.520770192060908e-04,  1.953791886445275e-04, -5.562296555265714e-05,
  1.740696083293899e-05, -5.930043413437022e-06,  2.148755749203175e-06, -8.011026383092141e-07,  2.955795959573106e-07, -1.031885108693291e-07,  3.086881786544018e-08,
 -2.004998289481380e+00,  3.085894096052592e-03, -7.356810785031459e-04,  1.903219496963183e-04, -5.405323833084787e-05,  1.690043144462620e-05, -5.757618767100085e-06,
  2.086985781456134e-06, -7.782245516609319e-07,  2.870683853405048e-07, -1.001300303047722e-07,  2.991181364740286e-08, -2.004948136407001e+00,  3.052555247561145e-03,
 -7.248843098766171e-04,  1.870107296828683e-04, -5.302975607106554e-05,  1.657100089848479e-05, -5.645600717472457e-06,  2.046863431547816e-06, -7.633633173886358e-07,
  2.815410218329535e-07, -9.814557520941921e-08,  2.929175930281789e-08, -2.004920966535048e+00,  3.034514326736534e-03, -7.190665627054327e-04,  1.852327773659753e-04,
 -5.248160381089048e-05,  1.639483425579055e-05, -5.585735690346757e-06,  2.025422985260956e-06, -7.554214133360415e-07,  2.785876146003749e-07, -9.708581856761443e-08,
  2.896092361962339e-08, -2.002376083354306e+00,  1.439472712254695e-03, -3.049276224082590e-04,  6.493763037784680e-05, -1.389999820490802e-05,  2.989957214342315e-06,
 -6.461936911575405e-07,  1.402900337461948e-07, -3.058991307826737e-08,  6.697308635584446e-09, -1.468991808551460e-09,  3.089926457764416e-10, -2.002243974929109e+00,
  1.352324080003472e-03, -2.778701628522399e-04,  5.739407249471615e-05, -1.191670097353168e-05,  2.487175014038617e-06, -5.218108201643484e-07,  1.100446940740307e-07,
 -2.332724561030805e-08,  4.969880267021648e-09, -1.062113584740162e-09,  2.183496719138158e-10, -2.002156228072695e+00,  1.294907166954953e-03, -2.606264949468829e-04,
  5.274600308322358e-05, -1.073531424369880e-05,  2.197620689818670e-06, -4.525393053934685e-07,  9.375003088997687e-08, -1.954045224063333e-08,  4.097687742275632e-09,
 -8.629931831433921e-10,  1.752075905706142e-10, -2.002091487849694e+00,  1.252783630514315e-03, -2.482717866996573e-04,  4.949404173185098e-05, -9.928072173680783e-06,
  2.004329087415931e-06, -4.073444498115632e-07,  8.335434234432804e-08, -1.717663081413605e-08,  3.564605297439375e-09, -7.437209598379271e-10,  1.498204003425497e-10,
 -2.002041564015268e+00,  1.220438982150243e-03, -2.389558733024928e-04,  4.708594324728369e-05, -9.340880933747365e-06,  1.866164177873120e-06, -3.755841358130457e-07,
  7.616816694780594e-08, -1.556828503074564e-08,  3.207344379332479e-09, -6.649197010049325e-10,  1.332543579514938e-10, -2.002002288242818e+00,  1.195077740637371e-03,
 -2.317553228353064e-04,  4.525093095673988e-05, -8.899622297712712e-06,  1.763734247474175e-06, -3.523444864639557e-07,  7.097552024035783e-08, -1.441993172086859e-08,
  2.955127498502108e-09, -6.098701980286340e-10,  1.217857233269016e-10, -2.001971224208870e+00,  1.175071833394906e-03, -2.261398981601535e-04,  4.383595129604244e-05,
 -8.563093626668536e-06,  1.686442792924888e-06, -3.349866253564733e-07,  6.713465423100529e-08, -1.357829440388200e-08,  2.771857673057267e-09, -5.701844710815053e-10,
  1.135733179553807e-10, -2.001946830360959e+00,  1.159394368939233e-03, -2.217793304949907e-04,  4.274696975300740e-05, -8.306340298457429e-06,  1.627964936064274e-06,
 -3.219583289949140e-07,  6.427351859875488e-08, -1.295576800418221e-08,  2.637187611260751e-09, -5.411967449332270e-10,  1.076048943135037e-10, -2.001928086128085e+00,
  1.147367344444786e-03, -2.184579109418691e-04,  4.192328371428678e-05, -8.113447142496700e-06,  1.584316005280137e-06, -3.122935534254940e-07,  6.216332701153368e-08,
 -1.249910794001765e-08,  2.538889610642619e-09, -5.201330915670331e-10,  1.032842696087773e-10, -2.001914303059071e+00,  1.138534425894658e-03, -2.160317634768433e-04,
  4.132479574578452e-05, -7.974005710842964e-06,  1.552916086325864e-06, -3.053730189653207e-07,  6.065883938058474e-08, -1.217483095207969e-08,  2.469343625292241e-09,
 -5.052796083489006e-10,  1.002458189750899e-10, -2.001905021543511e+00,  1.132591511706866e-03, -2.144057019548728e-04,  4.092518200603495e-05, -7.881236711086111e-06,
  1.532098080343844e-06, -3.007996765851321e-07,  5.966764381253364e-08, -1.196178911142216e-08,  2.423770630866659e-09, -4.955684865322213e-10,  9.826304859776713e-11,
 -2.001899950674459e+00,  1.129346414094303e-03, -2.135199346993678e-04,  4.070800988536626e-05, -7.830934525832476e-06,  1.520834130803021e-06, -2.983301898820692e-07,
  5.913343215709963e-08, -1.184716798092215e-08,  2.399290015044324e-09, -4.903592447853045e-10,  9.720067778991333e-11, -2.000966126791802e+00,  5.741989310718806e-04,
 -1.083489516509455e-04,  2.046827972788796e-05, -3.870997455067033e-06,  7.328918546572099e-07, -1.389066066705245e-07,  2.635496399684313e-08, -5.005510539678612e-09,
  9.515962158033989e-10, -1.808636386078433e-10,  3.324306506392213e-11, -2.000941995415929e+00,  5.586772833301212e-04, -1.040190997767507e-04,  1.938770361736955e-05,
 -3.617425673049377e-06,  6.756650535067945e-07, -1.263340461937907e-07,  2.364638962511197e-08, -4.430598988139576e-09,  8.309866939324335e-10, -1.558361129325621e-10,
  2.828744578103254e-11, -2.000925025479674e+00,  5.477986464438386e-04, -1.010293228169012e-04,  1.865275018064222e-05, -3.447561228187791e-06,  6.379099507968692e-07,
 -1.181651660793631e-07,  2.191323510963562e-08, -4.068309126679410e-09,  7.561346812154378e-10, -1.405373608230002e-10,  2.530037869105736e-11, -2.000911991311056e+00,
  5.394635961854699e-04, -9.876367802283639e-05,  1.810196146872607e-05, -3.321672080537247e-06,  6.102389646042713e-07, -1.122443012704355e-07,  2.067086910106759e-08,
 -3.811459636624899e-09,  7.036463979259182e-10, -1.299251480824532e-10,  2.324898876726402e-11, -2.000901628155794e+00,  5.328493323148697e-04, -9.698128733925716e-05,
  1.767241682982857e-05, -3.224346748124646e-06,  5.890314441854371e-07, -1.077454902233809e-07,  1.973495972975754e-08, -3.619609243386092e-09,  6.647706514303700e-10,
 -1.221302790037883e-10,  2.175370928969820e-11, -2.000893277417565e+00,  5.275276947003203e-04, -9.555720339094128e-05,  1.733161912832043e-05, -3.147667313641858e-06,
  5.724384175201670e-07, -1.042497471256546e-07,  1.901267444286157e-08, -3.472546948058417e-09,  6.351690440844624e-10, -1.162337799617668e-10,  2.062939878013905e-11,
 -2.000886545660360e+00,  5.232431071389034e-04, -9.441710587773880e-05,  1.706032531646584e-05, -3.086969778443190e-06,  5.593771235471319e-07, -1.015132662009737e-07,
  1.845035754649832e-08, -3.358673343739845e-09,  6.123698520419506e-10, -1.117159789545710e-10,  1.977209578731106e-11, -2.000881178955809e+00,  5.198307471634224e-04,
 -9.351323316666882e-05,  1.684622214027841e-05, -3.039284408801378e-06,  5.491618469728734e-07, -9.938253472038066e-08,  1.801442926684598e-08, -3.270774701472055e-09,
  5.948458239983008e-10, -1.082578788129416e-10,  1.911837630479350e-11, -2.000877006250390e+00,  5.171796668351868e-04, -9.281353980543992e-05,  1.668108039563307e-05,
 -3.002635212285140e-06,  5.413385098546220e-07, -9.775641241468231e-08,  1.768288292174317e-08, -3.204149254153250e-09,  5.816070779481602e-10, -1.056538865496607e-10,
  1.862757891836596e-11, -2.000873910457964e+00,  5.152139712001859e-04, -9.229616748190294e-05,  1.655930592840643e-05, -2.975683996995077e-06,  5.356008506318237e-07,
 -9.656697595123568e-08,  1.744100520873787e-08, -3.155667866807112e-09,  5.719978960377680e-10, -1.037684522855800e-10,  1.827301252791829e-11, -2.000871812484145e+00,
  5.138824192104875e-04, -9.194639377837837e-05,  1.647714141059341e-05, -2.957534742996498e-06,  5.317444830342599e-07, -9.576905349105852e-08,  1.727904630746938e-08,
 -3.123264631075755e-09,  5.655869788248695e-10, -1.025127521701175e-10,  1.803724798017187e-11, -2.000870661734044e+00,  5.131522517521350e-04, -9.175482969642145e-05,
  1.643219703468602e-05, -2.947619134256854e-06,  5.296401440589015e-07, -9.533416013883846e-08,  1.719087635104456e-08, -3.105644565567652e-09,  5.621047844962140e-10,
 -1.018314409746891e-10,  1.790945529574255e-11, -2.000440691393162e+00,  2.599075556585819e-04, -4.666687235884354e-05,  8.381358359398137e-06, -1.505687954366296e-06,
  2.705635653376086e-07, -4.863135114578731e-08,  8.743291155290290e-09, -1.572329639362761e-09,  2.828185078559303e-10, -5.083384760797916e-11,  8.861230134473702e-12,
 -2.000435444926578e+00,  2.565680427666144e-04, -4.577801782291122e-05,  8.169912935115557e-06, -1.458423689101650e-06,  2.604087879732001e-07, -4.650857221297588e-08,
  8.308365671610152e-09, -1.484577233548921e-09,  2.653270096633537e-10, -4.738575815582024e-11,  8.210518573236316e-12, -2.000431666279456e+00,  2.541665487859849e-04,
 -4.514333918147494e-05,  8.020010551755709e-06, -1.425156775702219e-06,  2.533128673576597e-07, -4.503593908022431e-08,  8.008828517043131e-09, -1.424579231758148e-09,
  2.534544517606188e-10, -4.506222661903557e-11,  7.774985950177224e-12, -2.000428712601129e+00,  2.522915228963541e-04, -4.465042360460894e-05,  7.904213848942067e-06,
 -1.399596815626183e-06,  2.478902030176153e-07, -4.391662069343844e-08,  7.782382300766026e-09, -1.379465617303625e-09,  2.445752468806456e-10, -4.333379962783419e-11,
  7.452617522438390e-12, -2.000426331665258e+00,  2.507814622420575e-04, -4.425512666985762e-05,  7.811745207240683e-06, -1.379273188173964e-06,  2.435968546399687e-07,
 -4.303418927963894e-08,  7.604620268898187e-09, -1.344201610145076e-09,  2.376640584205108e-10, -4.199413046485003e-11,  7.203736734001544e-12, -2.000424391762988e+00,
  2.495520303440133e-04, -4.393439564875936e-05,  7.736978578062836e-06, -1.362897172151497e-06,  2.401494030869090e-07, -4.232806534364141e-08,  7.462864492452248e-09,
 -1.316176991470274e-09,  2.321904663338284e-10, -4.093672590356067e-11,  7.007915389895509e-12, -2.000422813918258e+00,  2.485526597957789e-04, -4.367441300158428e-05,
  7.676544186775275e-06, -1.349697688240070e-06,  2.373784997364833e-07, -4.176211003829557e-08,  7.349565976182651e-09, -1.293840743356022e-09,  2.278400032015515e-10,
 -4.009860272794632e-11,  6.853100463732290e-12, -2.000421546952424e+00,  2.477505848702434e-04, -4.346623018409290e-05,  7.628261574059906e-06, -1.339176376564022e-06,
  2.351748471911544e-07, -4.131303776408745e-08,  7.259869602171169e-09, -1.276197351266336e-09,  2.244112695215850e-10, -3.943951661522462e-11,  6.731607792235041e-12,
 -2.000420556254151e+00,  2.471236492516637e-04, -4.330379974615920e-05,  7.590658486701998e-06, -1.330997126474119e-06,  2.334648317843974e-07, -4.096518957267004e-08,
  7.190516034538882e-09, -1.262579750827080e-09,  2.217695819105151e-10, -3.893261089900044e-11,  6.638319827010460e-12, -2.000419818047453e+00,  2.466566346589459e-04,
 -4.318297037384507e-05,  7.562725126652314e-06, -1.324929644180629e-06,  2.321980769724979e-07, -4.070786419774094e-08,  7.139281215659956e-09, -1.252533500196622e-09,
  2.198233448348708e-10, -3.855965384422021e-11,  6.569768571682645e-12, -2.000419316221603e+00,  2.463392302842909e-04, -4.310093098179537e-05,  7.543778210554860e-06,
 -1.320818241425145e-06,  2.313405615911269e-07, -4.053384306295311e-08,  7.104666794602250e-09, -1.245752854969759e-09,  2.185110216092846e-10, -3.830841501014225e-11,
  6.523630916118748e-12, -2.000419040432475e+00,  2.461648172446724e-04, -4.305587867557612e-05,  7.533379955241785e-06, -1.318563276293781e-06,  2.308705368473413e-07,
 -4.043851709501714e-08,  7.085717269352594e-09, -1.242043092908825e-09,  2.177934726873167e-10, -3.817112585927527e-11,  6.498433146000076e-12, -2.000210956170300e+00,
  1.239821537864023e-04, -2.175045628644027e-05,  3.815976592216859e-06, -6.695315363414981e-07,  1.174800848334159e-07, -2.061508894471948e-08,  3.617710263069470e-09,
 -6.349060595673375e-10,  1.114296025135233e-10, -1.954030319770230e-11,  3.327417552430729e-12, -2.000209728736561e+00,  1.232046018205827e-04, -2.154803354904466e-05,
  3.768893445854992e-06, -6.592430407931629e-07,  1.153194871707574e-07, -2.017368704189764e-08,  3.529337968395387e-09, -6.174847486911773e-10,  1.080370830026400e-10,
 -1.888694916981456e-11,  3.206785580803692e-12, -2.000208834903219e+00,  1.226387980372296e-04, -2.140124390283416e-05,  3.734869511651412e-06, -6.518342672830979e-07,
  1.137691027779069e-07, -1.985806466558036e-08,  3.466370590960122e-09, -6.051154683412200e-10,  1.056368744965287e-10, -1.842632791922711e-11,  3.122019063141160e-12,
 -2.000208130424710e+00,  1.221931066368070e-04, -2.128591710365196e-05,  3.708208653356895e-06, -6.460441677437520e-07,  1.125606576374479e-07, -1.961270568309549e-08,
  3.417550819186929e-09, -5.955507934782577e-10,  1.037858142844372e-10, -1.807203163483009e-11,  3.056980372610416e-12, -2.000207558815034e+00,  1.218316367191396e-04,
 -2.119257853925149e-05,  3.686676408822065e-06, -6.413777632791341e-07,  1.115887986771149e-07, -1.941580018284066e-08,  3.378454913079908e-09, -5.879074083358719e-10,
  1.023097108321914e-10, -1.779009707996705e-11,  3.005327089270131e-12, -2.000207090602996e+00,  1.215356603075516e-04, -2.111628185493433e-05,  3.669105800924853e-06,
 -6.375764764321998e-07,  1.107984810190143e-07, -1.925595242227088e-08,  3.346771591363191e-09, -5.817238771526335e-10,  1.011175908263161e-10, -1.756279255540543e-11,
  2.963749202803942e-12, -2.000206708120645e+00,  1.212939492161120e-04, -2.105406063158227e-05,  3.654796847293287e-06, -6.344851957601543e-07,  1.101566865694724e-07,
 -1.912632776018491e-08,  3.321114983976830e-09, -5.767236085997141e-10,  1.001549460224862e-10, -1.737949900117197e-11,  2.930265464488943e-12, -2.000206399916844e+00,
  1.210992258220840e-04, -2.100399185081512e-05,  3.643295751393719e-06, -6.320033681055698e-07,  1.096420140773702e-07, -1.902249727058734e-08,  3.300587324041921e-09,
 -5.727274995271740e-10,  9.938649728078861e-11, -1.723334725170275e-11,  2.903594987955904e-12, -2.000206158244592e+00,  1.209465665132447e-04, -2.096477441009770e-05,
  3.634295483735367e-06, -6.300629689947491e-07,  1.092399884368156e-07, -1.894146621200671e-08,  3.284581776716198e-09, -5.696145385770933e-10,  9.878841981542184e-11,
 -1.711970093280982e-11,  2.882873713689961e-12, -2.000205977779790e+00,  1.208325875259311e-04, -2.093551410313507e-05,  3.627585045762971e-06, -6.286172568322483e-07,
  1.089406655039166e-07, -1.888117782705765e-08,  3.272681717029553e-09, -5.673016781698317e-10,  9.834437058750011e-11, -1.703538123110757e-11,  2.867509520794999e-12,
 -2.000205854913035e+00,  1.207549948867861e-04, -2.091560473060667e-05,  3.623021410787961e-06, -6.276345524469297e-07,  1.087373070562666e-07, -1.884023881243839e-08,
  3.264605000621981e-09, -5.657326975073429e-10,  9.804329026707766e-11, -1.697823798343528e-11,  2.857102071502428e-12, -2.000205787323907e+00,  1.207123139443114e-04,
 -2.090465673216898e-05,  3.620512699263988e-06, -6.270945133413111e-07,  1.086255880336820e-07, -1.881775525025832e-08,  3.260170694291834e-09, -5.648715611779898e-10,
  9.787809387829626e-11, -1.694689445161275e-11,  2.851395161863658e-12, -2.000103261708328e+00,  6.058732239789939e-05, -1.051018268682346e-05,  1.823247823110224e-06,
 -3.162918928377490e-07,  5.487029801117578e-08, -9.519046837189637e-09,  1.651415927881705e-09, -2.865009021230766e-10,  4.970398545485431e-11, -8.615745798500872e-12,
  1.451118305459870e-12, -2.000102964623948e+00,  6.039955933739704e-05, -1.046182536462751e-05,  1.812121949653748e-06, -3.138872180415368e-07,  5.437084634286960e-08,
 -9.418132685764028e-09,  1.631434912939240e-09, -2.826055007183725e-10,  4.895382876781160e-11, -8.472874143231269e-12,  1.425013108774601e-12, -2.000102747131612e+00,
  6.026214993229182e-05, -1.042649668480844e-05,  1.804007663964851e-06, -3.121364840644947e-07,  5.400784933295907e-08, -9.344916647287368e-09,  1.616963350773602e-09,
 -2.797891084529919e-10,  4.841240714524438e-11, -8.369936256831222e-12,  1.406235119644692e-12, -2.000102575025922e+00,  6.015344526270075e-05, -1.039858428098785e-05,
  1.797605120684852e-06, -3.107568863314375e-07,  5.372217956644243e-08, -9.287373220857244e-09,  1.605604542723298e-09, -2.775814184630773e-10,  4.798856113185053e-11,
 -8.289458157115338e-12,  1.391572302535780e-12, -2.000102434932405e+00,  6.006497950315478e-05, -1.037589224389946e-05,  1.792405476920113e-06, -3.096376632592836e-07,
  5.349066901406727e-08, -9.240788427282700e-09,  1.596418615839400e-09, -2.757979311642758e-10,  4.764651722527371e-11, -8.224580471887420e-12,  1.379763449370712e-12,
 -2.000102319880023e+00,  5.999233972992290e-05, -1.035727548637332e-05,  1.788143295536846e-06, -3.087210176312145e-07,  5.330122471458350e-08, -9.202701087439384e-09,
  1.588914749072283e-09, -2.743422781519739e-10,  4.736758698464223e-11, -8.171719303645949e-12,  1.370149532888081e-12, -2.000102225692495e+00,  5.993288203875326e-05,
 -1.034204776176388e-05,  1.784659461181178e-06, -3.079722955570606e-07,  5.314659465638569e-08, -9.171635031807514e-09,  1.582798520487683e-09, -2.731566467876343e-10,
  4.714055823457727e-11, -8.128724401907271e-12,  1.362335147718238e-12, -2.000102149664293e+00,  5.988489354624411e-05, -1.032976438476923e-05,  1.781850849353169e-06,
 -3.073690341489342e-07,  5.302207748726925e-08, -9.146633201874985e-09,  1.577879033550751e-09, -2.722035514784778e-10,  4.695816098735069e-11, -8.094201569843583e-12,
  1.356063927914232e-12, -2.000102089965616e+00,  5.984721575640353e-05, -1.032012454965090e-05,  1.779647693121218e-06, -3.068960350864202e-07,  5.292449206438937e-08,
 -9.127047981317590e-09,  1.574027111256954e-09, -2.714576264119160e-10,  4.681547592289256e-11, -8.067207457456338e-12,  1.351162421239308e-12, -2.000102045339188e+00,
  5.981905263261757e-05, -1.031292154116888e-05,  1.778002044183549e-06, -3.065428524691808e-07,  5.285165188562605e-08, -9.112434235767809e-09,  1.571153965314618e-09,
 -2.709014371743122e-10,  4.670912205793003e-11, -8.047093755780582e-12,  1.347511433424461e-12, -2.000102014932726e+00,  5.979986455182727e-05, -1.030801522029920e-05,
  1.776881395285222e-06, -3.063024041506853e-07,  5.280207452613014e-08, -9.102490171792885e-09,  1.569199400409419e-09, -2.705231643656191e-10,  4.663680744161967e-11,
 -8.033421012174413e-12,  1.345030175903320e-12, -2.000101998198071e+00,  5.978930445403962e-05, -1.030531546720918e-05,  1.776264844619199e-06, -3.061701370412587e-07,
  5.277480708541108e-08, -9.097021828461792e-09,  1.568124735957898e-09, -2.703152143801166e-10,  4.659705984008153e-11, -8.025906998927860e-12,  1.343666773892876e-12,
 -2.000051092090727e+00,  2.995311221930612e-05, -5.167353427988573e-06,  8.914481766474200e-07, -1.537891705383061e-07,  2.653121417128689e-08, -4.577098002199120e-09,
  7.896324751647016e-10, -1.362263692196068e-10,  2.350110549180938e-11, -4.050930261116911e-12,  6.786701998814453e-13, -2.000051018998104e+00,  2.990696843743171e-05,
 -5.155532332615890e-06,  8.887429890685371e-07, -1.532076357622114e-07,  2.641108138200909e-08, -4.552956543253604e-09,  7.848783797741652e-10, -1.353045673236023e-10,
  2.332455481722766e-11, -4.017487467249469e-12,  6.725906881368892e-13, -2.000050965348144e+00,  2.987310501000985e-05, -5.146864568331641e-06,  8.867611215751879e-07,
 -1.527819597382482e-07,  2.632322152634309e-08, -4.535315781074893e-09,  7.814074463928485e-10, -1.346321478550592e-10,  2.319587920662586e-11, -3.993134323012040e-12,
  6.681671459527463e-13, -2.000050922810030e+00,  2.984625895824795e-05, -5.139997413222775e-06,  8.851919811136921e-07, -1.524451515100430e-07,  2.625374954155384e-08,
 -4.521376128443205e-09,  7.786665282758671e-10, -1.341015016001443e-10,  2.309440023167911e-11, -3.973940961389567e-12,  6.646829700049031e-13, -2.000050888129267e+00,
  2.982437412582216e-05, -5.134402221650242e-06,  8.839141513298140e-07, -1.521710155070815e-07,  2.619723439476848e-08, -4.510042247572116e-09,  7.764391490689863e-10,
 -1.336705043117549e-10,  2.301202116806272e-11, -3.958368253556366e-12,  6.618574413492540e-13, -2.000050859610651e+00,  2.980637944895128e-05, -5.129803556324038e-06,
  8.828643573601262e-07, -1.519458972758144e-07,  2.615084457887450e-08, -4.500742964573869e-09,  7.746124040567803e-10, -1.333171818733975e-10,  2.294451763931228e-11,
 -3.945613046408772e-12,  6.595440531934455e-13, -2.000050836239102e+00,  2.979163355547334e-05, -5.126036451286475e-06,  8.820046959565279e-07, -1.517616161342227e-07,
  2.611288341724768e-08, -4.493135975236745e-09,  7.731186203483149e-10, -1.330283617569027e-10,  2.288935701544214e-11, -3.935193774708686e-12,  6.576549526152692e-13,
 -2.000050817357269e+00,  2.977972108866996e-05, -5.122994058697122e-06,  8.813106140996962e-07, -1.516128721355736e-07,  2.608225157255888e-08, -4.486999464796377e-09,
  7.719139412700800e-10, -1.327955064893862e-10,  2.284489769498355e-11, -3.926798274034673e-12,  6.561331872296756e-13, -2.000050802520699e+00,  2.977036120900864e-05,
 -5.120604126557682e-06,  8.807655070108427e-07, -1.514960806816198e-07,  2.605820544813313e-08, -4.482183384943882e-09,  7.709686975227730e-10, -1.326128400507354e-10,
  2.281002899087180e-11, -3.920215327385182e-12,  6.549402202968220e-13, -2.000050791424069e+00,  2.976336098615626e-05, -5.118817015286456e-06,  8.803579657677374e-07,
 -1.514087786702753e-07,  2.604023406047918e-08, -4.478584619887742e-09,  7.702624988262014e-10, -1.324763926862902e-10,  2.278398751912779e-11, -3.915299759078973e-12,
  6.540495637302389e-13, -2.000050783860436e+00,  2.975858965377739e-05, -5.117599077764354e-06,  8.800802566852185e-07, -1.513492963800777e-07,  2.602799100321050e-08,
 -4.476133262849372e-09,  7.697815212951162e-10, -1.323834729778545e-10,  2.276625570990052e-11, -3.911953139435109e-12,  6.534432583331524e-13, -2.000050779696680e+00,
  2.975596309367372e-05, -5.116928670830494e-06,  8.799274054099921e-07, -1.513165598953174e-07,  2.602125349086733e-08, -4.474784357189716e-09,  7.695168754342189e-10,
 -1.323323503143324e-10,  2.275650078297383e-11, -3.910112185911377e-12,  6.531097585424011e-13, -2.000025413210065e+00,  1.489267385562707e-05, -2.562164688539717e-06,
  4.408002509405913e-07, -7.583628555746091e-08,  1.304706126346351e-08, -2.244650750498758e-09,  3.861759936319251e-10, -6.643881550961225e-11,  1.143005477335051e-11,
 -1.964792566916246e-12,  3.283120239729323e-13, -2.000025395081614e+00,  1.488123566392440e-05, -2.559242179948666e-06,  4.401332324120503e-07, -7.569327978692116e-08,
  1.301759847295617e-08, -2.238745908217683e-09,  3.850162989770536e-10, -6.621456000426647e-11,  1.138721927310464e-11, -1.956700302728417e-12,  3.268446475722553e-13,
 -2.000025381758147e+00,  1.487282994084437e-05, -2.557095388409206e-06,  4.396434688290681e-07, -7.558832170201420e-08,  1.299598375570319e-08, -2.234415816545323e-09,
  3.841662471690807e-10, -6.605025238802369e-11,  1.135584806641396e-11, -1.950776358376315e-12,  3.257708866930523e-13, -2.000025371183843e+00,  1.486615910780098e-05,
 -2.555392229010974e-06,  4.392550404606283e-07, -7.550510723980350e-08,  1.297885244286363e-08, -2.230985010342659e-09,  3.834929568102906e-10, -6.592015381545639e-11,
  1.133101651351435e-11, -1.946088850406783e-12,  3.249214992630936e-13, -2.000025362555963e+00,  1.486071648023754e-05, -2.554003006979068e-06,  4.389382923624451e-07,
 -7.543726687939869e-08,  1.296488985176310e-08, -2.228189523358799e-09,  3.829444910469552e-10, -6.581420271972104e-11,  1.131079923984657e-11, -1.942273389686626e-12,
  3.242302986160629e-13, -2.000025355456529e+00,  1.485623822501466e-05, -2.552860181305878e-06,  4.386777792798700e-07, -7.538148277010696e-08,  1.295341109019345e-08,
 -2.225891824795238e-09,  3.824937868430701e-10, -6.572715567836946e-11,  1.129419275820337e-11, -1.939140039793407e-12,  3.236627818311025e-13, -2.000025349635327e+00,
  1.485256640199029e-05, -2.551923315526400e-06,  4.384642533244307e-07, -7.533576815216764e-08,  1.294400600050997e-08, -2.224009544920587e-09,  3.821246342245203e-10,
 -6.565587176475593e-11,  1.128059590739323e-11, -1.936575005935812e-12,  3.231982759792978e-13, -2.000025344930362e+00,  1.484959875268993e-05, -2.551166226963491e-06,
  4.382917260123068e-07, -7.529883639987574e-08,  1.293640894524530e-08, -2.222489333433032e-09,  3.818265333843324e-10, -6.559831634813382e-11,  1.126961924198568e-11,
 -1.934504564794276e-12,  3.228233871047321e-13, -2.000025341232120e+00,  1.484726614911938e-05, -2.550571214694816e-06,  4.381561485532282e-07, -7.526981757909846e-08,
  1.293044030701382e-08, -2.221295114202605e-09,  3.815923838454844e-10, -6.555311344225923e-11,  1.126099937366249e-11, -1.932878853731210e-12,  3.225290558436720e-13,
 -2.000025338465384e+00,  1.484552110886935e-05, -2.550126119775943e-06,  4.380547396599071e-07, -7.524811406750400e-08,  1.292597668786668e-08, -2.220402101718545e-09,
  3.814173071445657e-10, -6.551931762350319e-11,  1.125455532477331e-11, -1.931663610254206e-12,  3.223090569706377e-13, -2.000025336579176e+00,  1.484433145204474e-05,
 -2.549822701536901e-06,  4.379856142654613e-07, -7.523332080318473e-08,  1.292293444750344e-08, -2.219793495645477e-09,  3.812979964281571e-10, -6.549628802245693e-11,
  1.125016441394827e-11, -1.930835607927892e-12,  3.221591703393437e-13, -2.000025335540699e+00,  1.484367647668757e-05, -2.549655658705494e-06,  4.379475597220196e-07,
 -7.522517721918065e-08,  1.292125978333437e-08, -2.219458489239237e-09,  3.812323246307662e-10, -6.548361242378918e-11,  1.124774773308721e-11, -1.930379908023153e-12,
  3.220766817163121e-13, -2.000012673624485e+00,  7.425520604980748e-06, -1.275756068054021e-06,  2.191838165690280e-07, -3.765732218175013e-08,  6.469794555521980e-09,
 -1.111556782182045e-09,  1.909734146022111e-10, -3.281058472810656e-11,  5.636955596229995e-12, -9.676511306594872e-13,  1.614829421799343e-13, -2.000012669110301e+00,
  7.422673161753849e-06, -1.275029489892303e-06,  2.190182061053752e-07, -3.762186335014535e-08,  6.462498897841236e-09, -1.110096563909949e-09,  1.906870156218731e-10,
 -3.275527661689211e-11,  5.626405237426764e-12, -9.656606713714025e-13,  1.611224626673896e-13, -2.000012665790478e+00,  7.420579187405968e-06, -1.274495286125590e-06,
  2.188964698943693e-07, -3.759580400773220e-08,  6.457138336005334e-09, -1.109023883479591e-09,  1.904766713496314e-10, -3.271466459187791e-11,  5.618659912787994e-12,
 -9.641997304828596e-13,  1.608579340526440e-13, -2.000012663154379e+00,  7.418916528170980e-06, -1.274071185291683e-06,  2.187998399891456e-07, -3.757512238865340e-08,
  6.452884697697494e-09, -1.108172844035066e-09,  1.903098164153820e-10, -3.268245449682530e-11,  5.612517967036631e-12, -9.630414112449183e-13,  1.606482323534649e-13,
 -2.000012661002667e+00,  7.417559421040998e-06, -1.273725067468994e-06,  2.187209885205472e-07, -3.755824808195730e-08,  6.449414573492746e-09, -1.107478655967687e-09,
  1.901737316643666e-10, -3.265618780707639e-11,  5.607509991039115e-12, -9.620970727627697e-13,  1.604772906392801e-13, -2.000012659231564e+00,  7.416442393934021e-06,
 -1.273440209996035e-06,  2.186561001214246e-07, -3.754436337726774e-08,  6.446559554029686e-09, -1.106907579201689e-09,  1.900617930122564e-10, -3.263458405432747e-11,
  5.603391488539756e-12, -9.613205428048162e-13,  1.603367393260753e-13, -2.000012657778961e+00,  7.415526259254269e-06, -1.273206603194191e-06,  2.186028909116859e-07,
 -3.753297876801305e-08,  6.444218819217341e-09, -1.106439413869999e-09,  1.899700344868292e-10, -3.261687655924634e-11,  5.600016060579810e-12, -9.606841731524657e-13,
  1.602215664355480e-13, -2.000012656604646e+00,  7.414785648291064e-06, -1.273017766870178e-06,  2.185598822627321e-07, -3.752377732508803e-08,  6.442327090842276e-09,
 -1.106061080596434e-09,  1.898958880273402e-10, -3.260256885957079e-11,  5.597288903066279e-12, -9.601700588786822e-13,  1.601285261086208e-13, -2.000012655681441e+00,
  7.414203413285975e-06, -1.272869320647322e-06,  2.185260746417731e-07, -3.751654480169544e-08,  6.440840238842439e-09, -1.105763737042095e-09,  1.898376174366287e-10,
 -3.259132530009251e-11,  5.595145917567040e-12, -9.597660938414083e-13,  1.600554236473006e-13, -2.000012654990680e+00,  7.413767776811759e-06, -1.272758255915260e-06,
  2.185007815135280e-07, -3.751113403731429e-08,  6.439727950666087e-09, -1.105541309331225e-09,  1.897940300774094e-10, -3.258291530532897e-11,  5.593543071177238e-12,
 -9.594639614437549e-13,  1.600007513207440e-13, -2.000012654519713e+00,  7.413470757501754e-06, -1.272682533750929e-06,  2.184835376072772e-07, -3.750744529822550e-08,
  6.438969682508468e-09, -1.105389680928827e-09,  1.897643176327868e-10, -3.257718259880569e-11,  5.592450519359057e-12, -9.592580247896867e-13,  1.599634871911076e-13,
 -2.000012654260400e+00,  7.413307220614464e-06, -1.272640842444081e-06,  2.184740436011716e-07, -3.750541442356069e-08,  6.438552218232744e-09, -1.105306203634790e-09,
  1.897479601116769e-10, -3.257402664882577e-11,  5.591849063521768e-12, -9.591446577811652e-13,  1.599429738741882e-13, -2.000006328595415e+00,  3.707575340267668e-06,
 -6.365528653671660e-07,  1.092896403062293e-07, -1.876391869888384e-08,  3.221574026679740e-09, -5.531115332579690e-10,  9.496363519658937e-11, -1.630428152156687e-11,
  2.799210438779484e-12, -4.801908148868473e-13,  8.008326182638305e-14, -2.000006327469100e+00,  3.706864985461066e-06, -6.363717240663364e-07,  1.092483797474170e-07,
 -1.875509028228811e-08,  3.219758789742267e-09, -5.527484579058361e-10,  9.489247119970779e-11, -1.629054782666027e-11,  2.796592403891903e-12, -4.796972181727271e-13,
  7.999392546985382e-14, -2.000006326640519e+00,  3.706342420190553e-06, -6.362384833689129e-07,  1.092180332719700e-07, -1.874859781873062e-08,  3.218423998105067e-09,
 -5.524815076610693e-10,  9.484015366726177e-11, -1.628045233076904e-11,  2.794668120531161e-12, -4.793344581881592e-13,  7.992827591974016e-14, -2.000006325982426e+00,
  3.705927384280078e-06, -6.361326683796708e-07,  1.091939351405607e-07, -1.874344257378247e-08,  3.217364212870316e-09, -5.522695743259732e-10,  9.479862186886732e-11,
 -1.627243876768569e-11,  2.793140795241742e-12, -4.790465549497353e-13,  7.987617735258782e-14, -2.000006325445153e+00,  3.705588549802777e-06, -6.360462868085457e-07,
  1.091742640252776e-07, -1.873923466306939e-08,  3.216499231779209e-09, -5.520966088096374e-10,  9.476472867637565e-11, -1.626589950364163e-11,  2.791894542214009e-12,
 -4.788116496482268e-13,  7.983367182651803e-14, -2.000006325002846e+00,  3.705309609179436e-06, -6.359751781780907e-07,  1.091580717822360e-07, -1.873577111460670e-08,
  3.215787300552122e-09, -5.519542554876240e-10,  9.473683555024550e-11, -1.626051816639879e-11,  2.790869022097791e-12, -4.786183604913967e-13,  7.979869839634872e-14,
 -2.000006324640031e+00,  3.705080802510006e-06, -6.359168524247066e-07,  1.091447909283026e-07, -1.873293044239537e-08,  3.215203427103153e-09, -5.518375129581278e-10,
  9.471396168918596e-11, -1.625610537614740e-11,  2.790028114948126e-12, -4.784598740125532e-13,  7.977002329205345e-14, -2.000006324346693e+00,  3.704895812001121e-06,
 -6.358696976421875e-07,  1.091340541037076e-07, -1.873063400088649e-08,  3.214731432134837e-09, -5.517431433610192e-10,  9.469547211839505e-11, -1.625253852505813e-11,
  2.789348435590793e-12, -4.783317788713093e-13,  7.974684770096329e-14, -2.000006324116061e+00,  3.704750367431387e-06, -6.358326243179572e-07,  1.091256129999456e-07,
 -1.872882863048787e-08,  3.214360379241799e-09, -5.516689580256181e-10,  9.468093761172617e-11, -1.624973473209556e-11,  2.788814175739151e-12, -4.782310929697234e-13,
  7.972863161168322e-14, -2.000006323943486e+00,  3.704641536053840e-06, -6.358048841750669e-07,  1.091192970764747e-07, -1.872747782021195e-08,  3.214082756998021e-09,
 -5.516134536921913e-10,  9.467006335692220e-11, -1.624763707000416e-11,  2.788414477250570e-12, -4.781557679857913e-13,  7.971500410062855e-14, -2.000006323825817e+00,
  3.704567330455727e-06, -6.357859701293553e-07,  1.091149907621228e-07, -1.872655682721385e-08,  3.213893474995576e-09, -5.515756116091036e-10,  9.466264955931584e-11,
 -1.624620695874820e-11,  2.788141981411445e-12, -4.781044157307917e-13,  7.970571378337079e-14, -2.000006323761027e+00,  3.704526472032696e-06, -6.357755559491531e-07,
  1.091126197047426e-07, -1.872604973338269e-08,  3.213789258377400e-09, -5.515547763771246e-10,  9.465856768452213e-11, -1.624541957866601e-11,  2.787991954171005e-12,
 -4.780761431516108e-13,  7.970059893942397e-14, -2.000003162247025e+00,  1.852493809380141e-06, -3.179459364938216e-07,  5.456947795228040e-08, -9.365831193244199e-09,
  1.607469937029696e-09, -2.758921854646710e-10,  4.735173941802991e-11, -8.127035806863491e-12,  1.394819336153059e-12, -2.391930804880264e-13,  3.987831884693191e-14,
 -2.000003161965725e+00,  1.852316408487732e-06, -3.179007138943630e-07,  5.455918050986077e-08, -9.363628607822766e-09,  1.607017207676134e-09, -2.758016628010530e-10,
  4.733400258801937e-11, -8.123613979409818e-12,  1.394167255740193e-12, -2.390701800097338e-13,  3.985608195481626e-14, -2.000003161758751e+00,  1.852185882977146e-06,
 -3.178674424059806e-07,  5.455160480657548e-08, -9.362008279105610e-09,  1.606684175834018e-09, -2.757350770749011e-10,  4.732095661391353e-11, -8.121097257117385e-12,
  1.393687682410506e-12, -2.389797975384042e-13,  3.983972950067897e-14, -2.000003161594344e+00,  1.852082202472985e-06, -3.178410148795995e-07,  5.454558767296737e-08,
 -9.360721357270623e-09,  1.606419681053388e-09, -2.756821966698801e-10,  4.731059631185583e-11, -8.119098714260109e-12,  1.393306866175499e-12, -2.389080301772744e-13,
  3.982674548192009e-14, -2.000003161460108e+00,  1.851997549053703e-06, -3.178194379365334e-07,  5.454067510114971e-08, -9.359670709296873e-09,  1.606203753563711e-09,
 -2.756390277325912e-10,  4.730213895321910e-11, -8.117467310217975e-12,  1.392996017329038e-12, -2.388494505536754e-13,  3.981614768950149e-14, -2.000003161349589e+00,
  1.851927853358880e-06, -3.178016739724672e-07,  5.453663076456928e-08, -9.358805773306287e-09,  1.606025998076377e-09, -2.756034912234233e-10,  4.729517707421469e-11,
 -8.116124416723796e-12,  1.392740148367348e-12, -2.388012332099668e-13,  3.980742478348556e-14, -2.000003161258928e+00,  1.851870680027099e-06, -3.177871020114280e-07,
  5.453331322677461e-08, -9.358096288677740e-09,  1.605880193064281e-09, -2.755743428311904e-10,  4.728946680334607e-11, -8.115022973281819e-12,  1.392530288868902e-12,
 -2.387616870119970e-13,  3.980027070546201e-14, -2.000003161185623e+00,  1.851824452651569e-06, -3.177753200919917e-07,  5.453063093411498e-08, -9.357522667104733e-09,
  1.605762311164369e-09, -2.755507770707943e-10,  4.728485027255914e-11, -8.114132515367511e-12,  1.392360631785430e-12, -2.387297171837158e-13,  3.979448732285401e-14,
 -2.000003161127986e+00,  1.851788105762870e-06, -3.177660565321482e-07,  5.452852200577783e-08, -9.357071668798141e-09,  1.605669630247106e-09, -2.755322495031017e-10,
  4.728122077559703e-11, -8.113432451203860e-12,  1.392227251945435e-12, -2.387045837242425e-13,  3.978994070921711e-14, -2.000003161084857e+00,  1.851760907623186e-06,
 -3.177591247461770e-07,  5.452694394297390e-08, -9.356734200811261e-09,  1.605600280769807e-09, -2.755183862078998e-10,  4.727850502621081e-11, -8.112908638185533e-12,
  1.392127453489714e-12, -2.386857783878261e-13,  3.978653888090633e-14, -2.000003161055449e+00,  1.851742362369072e-06, -3.177543982933061e-07,  5.452586794603743e-08,
 -9.356504101200955e-09,  1.605552995808450e-09, -2.755089337912245e-10,  4.727665336037197e-11, -8.112551492220143e-12,  1.392059409492573e-12, -2.386729567456158e-13,
  3.978421950200779e-14, -2.000003161039256e+00,  1.851732150983791e-06, -3.177517958272883e-07,  5.452527548661523e-08, -9.356377405671513e-09,  1.605526960287414e-09,
 -2.755037292324469e-10,  4.727563382687827e-11, -8.112354847425722e-12,  1.392021944612571e-12, -2.386658972119592e-13,  3.978294246928209e-14,     0.995199513953253,
     0.999091931954172,     0.988130290285569,     0.977762529778433,     0.963907003613778,     0.946284442080252,     0.924488155522476,     0.897916340590607,
     0.865639125270662,      0.82610245428031,     0.776320154896785,      0.70863996538712,     0.997605384853781,     0.999547027415872,     0.994079135853171,
     0.988907685446076,     0.981996847505032,     0.973207630017012,     0.962337643593873,     0.949087434307109,     0.932994362798706,     0.913285347826882,
     0.888475095285301,     0.854757901456398,     0.998803962401546,     0.999773753588798,      0.99704271640986,     0.994459764352609,     0.991008085470459,
     0.986618290856865,     0.981189342396821,     0.974571745762285,     0.966534542048942,     0.956691795119085,      0.94430201974354,     0.927465328995868,
     0.999402284985459,      0.99988693421743,     0.998522110329361,      0.99723129396826,     0.995506340087519,     0.993312575731573,     0.990599513142162,
     0.987292451443168,      0.98327598262071,     0.978357257754557,     0.972165762404422,     0.963752134568583,     0.999701216883821,     0.999943481175664,
     0.999261239223215,     0.998615992137667,     0.997753730962147,      0.99665712400149,     0.995300934335648,     0.993647821812891,     0.991640098296518,
     0.989181365797256,     0.986086417824859,     0.981880702901458,     0.999850626853993,     0.999971744070091,     0.999630665151721,      0.99930808142586,
     0.998877004106814,     0.998328768472441,     0.997650757700602,      0.99682430413712,     0.995820567451623,     0.994591354888517,     0.993044075171784,
     0.990941483170065,     0.999925318007316,     0.999985872901395,      0.99981534390287,     0.999654061938292,     0.999438536513688,     0.999164435540794,
     0.998825451005648,      0.99841224966848,      0.99791041227101,     0.997295843949934,      0.99652225197467,     0.995471021221442,     0.999962660145932,
     0.999992936666764,     0.999907674776013,     0.999827036261402,     0.999719276847658,     0.999582230557792,     0.999412743482579,     0.999206149146739,
     0.998955238144476,     0.998647963417228,     0.998261179316211,     0.997735580114459,     0.999981330358185,     0.999996468387334,     0.999953838093259,
     0.999913519452014,     0.999859640568516,     0.999791118470927,     0.999706376228883,      0.99960308064062,     0.999477627058657,     0.999323992046302,
     0.999130602957012,     0.998867807382881,     0.999990665250354,     0.999998234207147,     0.999976919222832,     0.999956760056117,     0.999929820820054,
     0.999895560032871,     0.999853189235424,     0.999801541835767,     0.999738815523961,     0.999661998604722,     0.999565304799083,     0.999433908016592,
     0.999995332642987,     0.999999117106942,     0.999988459655452,     0.999978380110559,     0.999964910543929,     0.999947780215712,     0.999926594897844,
     0.999900771296579,     0.999869408260393,     0.999830999947398,     0.999782653229168,     0.999716955088803  };
  constexpr double w[6324] = {  1.208315003771029e-01, -5.286273680068900e-02,  1.241365257595397e-02, -1.981589906171037e-03,  2.392336027769725e-04,
 -2.321078948168457e-05,  1.881974700775441e-06, -1.310545720938012e-07,  7.997316387437043e-09, -4.343052582147692e-10,  2.124756243861990e-11, -9.443263284625017e-13,
  1.210231797341685e-01, -5.151199151274930e-02,  1.175195199960199e-02, -1.825083242788676e-03,  2.147613524507657e-04, -2.034730801238170e-05,  1.613963914484455e-06,
 -1.101344491501664e-07,  6.595991399686935e-09, -3.520604709227569e-10,  1.695080847082133e-11, -7.423477141411771e-13,  1.213078794878861e-01, -4.878803941438747e-02,
  1.049696901661718e-02, -1.542309472526497e-03,  1.723785301870546e-04, -1.557248119064827e-05,  1.182101569485880e-06, -7.745739227768813e-08,  4.468381911351778e-09,
 -2.303881559714747e-10,  1.074354228459307e-11, -4.568372994760580e-13,  1.214539392260496e-01, -4.467303981993188e-02,  8.785215849133284e-03, -1.186638604179082e-03,
  1.227047314823639e-04, -1.031842731105873e-05,  7.332119361034181e-07, -4.520519856071654e-08,  2.465262033743637e-09, -1.206758450039717e-10,  5.363612636738528e-12,
 -2.181871049659042e-13,  1.210324971171630e-01, -3.920899723503226e-02,  6.814979516595358e-03, -8.213081361322835e-04,  7.649058706185808e-05, -5.843213996558510e-06,
  3.801185969121086e-07, -2.160486759464691e-08,  1.093019477966593e-09, -4.991827597545424e-11,  2.080761802611754e-12, -7.976908084820277e-14,  1.193404643065157e-01,
 -3.257647466566082e-02,  4.825166077864543e-03, -5.028081706853960e-04,  4.102369564133941e-05, -2.776958250092904e-06,  1.616859246455389e-07, -8.298117546139968e-09,
  3.820798503390489e-10, -1.599415503188459e-11,  6.150142167675630e-13, -2.188058995537853e-14,  1.153523741565156e-01, -2.517489934635874e-02,  3.053320223470826e-03,
 -2.661344440784097e-04,  1.848229104649860e-05, -1.080531981094181e-06,  5.501448497521590e-08, -2.495730253786287e-09,  1.025425689529183e-10, -3.862908951792342e-12,
  1.346932262521072e-13, -4.376152974634109e-15,  1.077718728508105e-01, -1.765692462839329e-02,  1.678391858448663e-03, -1.181080748194790e-04,  6.772524007426050e-06,
 -3.328514348509178e-07,  1.446058778530608e-08, -5.669302366128988e-10,  2.035502237736873e-11, -6.766647269083110e-13,  2.100428990418309e-14, -6.124530631872439e-16,
  9.525993920111668e-02, -1.085391516322142e-02,  7.705667783100028e-04, -4.212355415586858e-05,  1.929527349460710e-06, -7.740341108074485e-08,  2.793208333657307e-09,
 -9.230938334938563e-11,  2.829428677417451e-12, -8.120002325854135e-14,  2.197692411949538e-15, -5.638607862433530e-17,  7.686205188169981e-02, -5.555703594291713e-03,
  2.789583308906859e-04, -1.133858539259751e-05,  3.993558170166338e-07, -1.263316657449924e-08,  3.668324161475602e-10, -9.920238243332835e-12,  2.524293264586201e-13,
 -6.090230358099489e-15,  1.401356105104840e-16, -3.088193555068135e-18,  5.252964567158625e-02, -2.192021665324105e-03,  7.242061207331928e-05, -2.068900530183676e-06,
  5.331537129000102e-08, -1.270767188701864e-09,  2.845687038803776e-11, -6.050310347146092e-13,  1.230488680199544e-14, -2.407097747926696e-16,  4.548578290762276e-18,
 -8.328171634685694e-20,  2.352266931199364e-02, -5.685527131809009e-04,  1.113724703568661e-05, -2.016508248448499e-07,  3.474422708007573e-09, -5.758758429093331e-11,
  9.240161511749221e-13, -1.441876362260396e-14,  2.195961173220974e-16, -3.273392280774486e-18,  4.786642302001470e-20, -6.877516710913611e-22,  1.720726025211904e-02,
 -7.517906803811349e-03,  1.762861383122376e-03, -2.810100687790425e-04,  3.388046282157271e-05, -3.282973221542298e-06,  2.658714905341169e-07, -1.849350731988497e-08,
  1.127319768862806e-09, -6.115871819205890e-11,  2.989205235901725e-12, -1.327316144303655e-13,  1.846484783142855e-02, -7.810846852628611e-03,  1.770563433059599e-03,
 -2.733073444322071e-04,  3.198031742682650e-05, -3.014248101206859e-06,  2.379500701378036e-07, -1.616572057137627e-08,  9.642227344602592e-10, -5.127104729516742e-11,
  2.459932245750850e-12, -1.073818725114534e-13,  2.111882822600746e-02, -8.361145931135723e-03,  1.770602418685354e-03, -2.563278127280276e-04,  2.826100135228760e-05,
 -2.521325200844661e-06,  1.892070349998887e-07, -1.226758683826956e-08,  7.008473619143695e-10, -3.581278305858646e-11,  1.656253402234105e-12, -6.989070292702894e-14,
  2.540907787378475e-02, -9.074201573664275e-03,  1.733758387522565e-03, -2.280381251703661e-04,  2.301379696936814e-05, -1.892680530704781e-06,  1.317754561442443e-07,
 -7.973565309752505e-09,  4.273943358153238e-10, -2.059037599595530e-11,  9.017777675893239e-13, -3.618707995633859e-14,  3.156462187498543e-02, -9.759875890192300e-03,
  1.623527479353737e-03, -1.879998164399117e-04,  1.688443236489897e-05, -1.247762357845499e-06,  7.874113300157225e-08, -4.352036953777238e-09,  2.145670596062995e-10,
 -9.568067156861560e-12,  3.900919883318117e-13, -1.465062050472183e-14,  3.955655510528346e-02, -1.011334270221921e-02,  1.411805675073487e-03, -1.394989228968718e-04,
  1.084696481315883e-05, -7.027335879242818e-07,  3.930175680761334e-08, -1.943557906734171e-09,  8.646563596290904e-11, -3.505752997457052e-12,  1.308532601430883e-13,
 -4.528102277635034e-15,  4.868143578412578e-02, -9.767571626998541e-03,  1.101403482035562e-03, -8.999515284615336e-05,  5.896291594451241e-06, -3.268782836622478e-07,
  1.584884333956738e-08, -6.871724927283590e-10,  2.707012299652769e-11, -9.804566031584075e-13,  3.295102166060212e-14, -1.034246347498733e-15,  5.708289975941543e-02,
 -8.462544014367296e-03,  7.405665176435593e-04, -4.846045466269303e-05,  2.602680055779037e-06, -1.204770551005260e-07,  4.952165156147371e-09, -1.843973803983467e-10,
  6.308794137486578e-12, -2.004282829646103e-13,  5.961145248715788e-15, -1.669435172527108e-16,  6.158303598386777e-02, -6.284188797107119e-03,  4.090079234806875e-04,
 -2.071749614368436e-05,  8.857621739093856e-07, -3.334736272523740e-08,  1.134349232281190e-09, -3.546682900834117e-11,  1.031751109880506e-12, -2.817939241935660e-14,
  7.276330704086477e-16, -1.785154870203458e-17,  5.837228725186471e-02, -3.776169025978386e-03,  1.742215784179521e-04, -6.572128961344114e-06,  2.162131738758906e-07,
 -6.419201863916849e-09,  1.756010198959126e-10, -4.487829414894066e-12,  1.082127702254742e-13, -2.479840101770908e-15,  5.431350890259382e-17, -1.141516914231500e-18,
  4.478125116499443e-02, -1.699178359770055e-03,  5.197956448198992e-05, -1.387120453886010e-06,  3.355750300880116e-08, -7.535066933968896e-10,  1.594011602225067e-11,
 -3.208948419487823e-13,  6.191571151757248e-15, -1.151092266496020e-16,  2.070440636209447e-18, -3.613570680193665e-20,  2.141255681592996e-02, -4.882692663189162e-04,
  9.016533483918596e-06, -1.541934139700669e-07,  2.515418694288619e-09, -3.955884390325296e-11,  6.032823354146587e-13, -8.959529075355592e-15,  1.300119265518491e-16,
 -1.848299229217238e-18,  2.579801642191429e-20, -3.540836807523949e-22,  2.458836871914303e-03, -1.072619699001630e-03,  2.511022066717995e-04, -3.996331868623366e-05,
  4.810967507475574e-06, -4.655126113935465e-07,  3.764896644854797e-08, -2.615481281185008e-09,  1.592435687764568e-10, -8.629479471761455e-12,  4.213278432095646e-13,
 -1.868972525438893e-14,  2.860180397915484e-03, -1.201024381342958e-03,  2.701929991578715e-04, -4.141152047167640e-05,  4.813886489677086e-06, -4.509871368247191e-07,
  3.540419510924362e-08, -2.392987279774591e-09,  1.420606107227295e-10, -7.521031528770030e-12,  3.594017912174189e-13, -1.563053268567684e-14,  3.805933463799986e-03,
 -1.479087163681814e-03,  3.074576976277434e-04, -4.374993740140753e-05,  4.748000697826826e-06, -4.175202393522256e-07,  3.092008955303974e-08, -1.980584385211810e-09,
  1.118963352244611e-10, -5.659436099666564e-12,  2.592693337266782e-13, -1.084565279023673e-14,  5.618483821602573e-03, -1.939005517057182e-03,  3.584393257231659e-04,
 -4.573951442294243e-05,  4.490519315004091e-06, -3.601295289012567e-07,  2.450298552559879e-08, -1.451659600059506e-09,  7.631379428078100e-11, -3.611249867311421e-12,
  1.555615592850561e-13, -6.147717424253869e-15,  8.840199076333412e-03, -2.593081520277461e-03,  4.107613010958896e-04, -4.550733252326756e-05,  3.926483452760789e-06,
 -2.797638506319736e-07,  1.707434242008036e-08, -9.151417289917330e-10,  4.385762889753725e-11, -1.905073110814964e-12,  7.580252513909853e-14, -2.783330460602375e-15,
  1.417670860774683e-02, -3.372957382745051e-03,  4.416536281651970e-04, -4.121552279164043e-05,  3.043714352943204e-06, -1.881441398413182e-07,  1.007867121020302e-08,
 -4.789959667532377e-10,  2.053949982903696e-11, -8.047532263024030e-13,  2.909413638439758e-14, -9.772482489868825e-16,  2.213970704819361e-02, -4.061448462516022e-03,
  4.243166251978564e-04, -3.241208594052583e-05,  1.998621847576713e-06, -1.048373963616162e-07,  4.830760675952103e-09, -1.997982998847810e-10,  7.532320902853709e-12,
 -2.618285916027021e-13,  8.466665310057025e-15, -2.562959217862984e-16,  3.220069575386488e-02, -4.304657503410966e-03,  3.463345396424293e-04, -2.105296916913924e-05,
  1.058070758515378e-06, -4.608905807984256e-08,  1.790832302387601e-09, -6.327477801530221e-11,  2.060909455849606e-12, -6.251091211564744e-14,  1.779604343507907e-15,
 -4.781742126810244e-17,  4.169952608122621e-02, -3.808155797874273e-03,  2.274296662810015e-04, -1.068250674469533e-05,  4.265490404274959e-07, -1.507797659113073e-08,
  4.836177339766727e-10, -1.430822600688688e-11,  3.950587477345208e-13, -1.026821423354512e-14,  2.529187768519863e-16, -5.931967167821213e-18,  4.562748196673579e-02,
 -2.647504888786036e-03,  1.125157294952152e-04, -3.947417368884917e-06,  1.215149090767422e-07, -3.391005577990565e-09,  8.750362314426728e-11, -2.115787694864605e-12,
  4.838949874247813e-14, -1.054139345583737e-15,  2.199105990216675e-17, -4.410432266233003e-19,  3.872231904279141e-02, -1.341819955962702e-03,  3.811818174397058e-05,
 -9.526716640591123e-07,  2.168652546876128e-08, -4.597018364655236e-10,  9.204108990116205e-12, -1.757431141812212e-13,  3.222074111741135e-15, -5.701146777053077e-17,
  9.773687017490163e-19, -1.628006930734745e-20,  1.959291819160635e-02, -4.229094985164506e-04,  7.383917856400530e-06, -1.195670093708476e-07,  1.850901830335304e-09,
 -2.767539423672630e-11,  4.019192649554880e-13, -5.691473019466158e-15,  7.883111217190955e-17, -1.070648144338264e-18,  1.428757392331929e-20, -1.876230663009581e-22,
  3.527366837298700e-04, -1.536009872125150e-04,  3.589021566908444e-05, -5.701582856868829e-06,  6.852029590697455e-07, -6.619372528213920e-08,  5.345403609657025e-09,
 -3.708186829407525e-10,  2.254715502758783e-11, -1.220305555350154e-12,  5.950997473245926e-14, -2.636868145183794e-15,  4.509983539134441e-04, -1.877218079877201e-04,
  4.185358124723402e-05, -6.361066044725191e-06,  7.337498403529200e-07, -6.825598678327921e-08,  5.323698888844935e-09, -3.576963795399904e-10,  2.111900266501438e-11,
 -1.112479477023660e-12,  5.291519261133091e-14, -2.291492549125587e-15,  7.136768241175525e-04, -2.713265890777944e-04,  5.518806663925914e-05, -7.697145205024600e-06,
  8.201915990193815e-07, -7.093086830274121e-08,  5.173464683560974e-09, -3.267982605435142e-10,  1.822848953811945e-11, -9.111854870767940e-13,  4.129412429554450e-14,
 -1.710296688845828e-15,  1.320752749847589e-03, -4.381127431871193e-04,  7.799242330320485e-05, -9.616647354590698e-06,  9.151683513052784e-07, -7.134333262060704e-08,
  4.730131879558914e-09, -2.736658937427474e-10,  1.407652030028663e-11, -6.528753735775965e-13,  2.760721380169165e-14, -1.072504064426535e-15,  2.669194467451004e-03,
 -7.378912575190631e-04,  1.107266424505962e-04, -1.168476762684262e-05,  9.648540637142304e-07, -6.605397558853892e-08,  3.886718644124401e-09, -2.014400067237041e-10,
  9.359455626131319e-12, -3.950639176100384e-13,  1.530686417272839e-14, -5.483305892250629e-16,  5.495958943135935e-03, -1.208976381504987e-03,  1.478026543685061e-04,
 -1.297819536158961e-05,  9.072984517903350e-07, -5.335483570137816e-08,  2.730335983379200e-09, -1.243964710466063e-10,  5.129378468019411e-12, -1.937827981634790e-13,
  6.771553077702411e-15, -2.203379458111504e-16,  1.081906181800761e-02, -1.805277714999684e-03,  1.742300678575428e-04, -1.241314117315202e-05,  7.189519703989693e-07,
 -3.561785881382443e-08,  1.557052996290900e-09, -6.132898888180518e-11,  2.209095801871255e-12, -7.358142609556110e-14,  2.285845194260591e-15, -6.663305352422620e-17,
  1.925334941567231e-02, -2.314137685649746e-03,  1.710465362922301e-04, -9.653647435285370e-06,  4.537809243515568e-07, -1.859105120991200e-08,  6.824674658011834e-10,
 -2.286677645059694e-11,  7.085614928082527e-13, -2.050425139756561e-14,  5.583065924226738e-16, -1.438143930741826e-17,  2.943193080318655e-02, -2.404863993698883e-03,
  1.319609828570946e-04, -5.753851112078998e-06,  2.147589474164599e-07, -7.132780115121521e-09,  2.158372624134999e-10, -6.044925865293376e-12,  1.584557997103529e-13,
 -3.920003229117632e-15,  9.210891278388286e-17, -2.065166712813194e-18,  3.657840200276952e-02, -1.908304640467941e-03,  7.489537383464604e-05, -2.449025391009942e-06,
  7.067198803762865e-08, -1.856664534929127e-09,  4.525643375893250e-11, -1.036537049658385e-12,  2.250898163409574e-14, -4.665522555846897e-16,  9.278005456488225e-18,
 -1.776814262380368e-19,  3.390002248513713e-02, -1.077332308493475e-03,  2.849938820315373e-05, -6.687227398757675e-07,  1.435593767566321e-08, -2.878595462059423e-10,
  5.464898357799182e-12, -9.913610056328755e-14,  1.729729004231966e-15, -2.917028664490550e-17,  4.772570223189768e-19, -7.596298638037158e-21,  1.801099505969663e-02,
 -3.691128380037103e-04,  6.110095642603702e-06, -9.390601514307154e-08,  1.382281551346350e-09, -1.968864917516775e-11,  2.727820296677625e-13, -3.689579495457530e-15,
  4.885972620882710e-17, -6.349813002811471e-19,  8.114223103057362e-21, -1.021023515595966e-22,  5.083212542199308e-05, -2.208927372659805e-05,  5.150044042008481e-06,
 -8.164291823309426e-07,  9.792328444890894e-08, -9.442416656470748e-09,  7.612007963994512e-10, -5.272074003532206e-11,  3.200792192497556e-12, -1.729899920182202e-13,
  8.424926415825432e-15, -3.728415743025900e-16,  7.262633651279508e-05, -2.991168418131156e-05,  6.597864081416587e-06, -9.928274607098413e-07,  1.134831873074734e-07,
 -1.046912691747216e-08,  8.103723967312454e-10, -5.407176341162990e-11,  3.172255935480937e-12, -1.661320140072259e-13,  7.859820643678414e-15, -3.386967838051684e-16,
  1.400586926492373e-04, -5.187911804230591e-05,  1.028714331775745e-05, -1.401681505151050e-06,  1.462278132646707e-07, -1.240467714570324e-08,  8.890279428190349e-10,
 -5.526642136220939e-11,  3.037877541031948e-12, -1.498272905090623e-13,  6.706693790845923e-15, -2.746396391494049e-16,  3.319904627325566e-04, -1.052087757916193e-04,
  1.794387835538353e-05, -2.128455155005480e-06,  1.955841389842229e-07, -1.477008748715280e-08,  9.513085432318877e-10, -5.359892155979770e-11,  2.690669589935459e-12,
 -1.220287639507204e-13,  5.054403642676235e-15, -1.926426069883656e-16,  8.715969605335910e-04, -2.255075150020774e-04,  3.188495931276196e-05, -3.190770815426367e-06,
  2.511749232819055e-07, -1.646517838600387e-08,  9.311645614181817e-10, -4.653336837640430e-11,  2.090588567319521e-12, -8.553955040258534e-14,  3.219837011058143e-15,
 -1.122869417051227e-16,  2.303334314239216e-03, -4.654548572555033e-04,  5.290210422850751e-05, -4.355725801293159e-06,  2.874058250229267e-07, -1.603588601760201e-08,
  7.819768619661797e-10, -3.407591559591105e-11,  1.348206375363213e-12, -4.900990003362113e-14,  1.652060682633131e-15, -5.197593298377045e-17,  5.660601367527237e-03,
 -8.550683970971238e-04,  7.605389724670875e-05, -5.044620372751935e-06,  2.740017671923511e-07, -1.280166426077234e-08,  5.301851582176364e-10, -1.986002535202326e-11,
  6.825777112090152e-13, -2.175644166823050e-14,  6.484399012366592e-16, -1.817807990644327e-17,  1.214301896007696e-02, -1.309108457796796e-03,  8.887812856163432e-05,
 -4.656811716314399e-06,  2.047138763577610e-07, -7.886810608349714e-09,  2.734565380806544e-10, -8.685855249131903e-12,  2.559476943114024e-13, -7.062830492423883e-15,
  1.838370628689673e-16, -4.536986705463941e-18,  2.155673009341098e-02, -1.576208766776341e-03,  7.960006563986545e-05, -3.226191300821361e-06,  1.126824698249945e-07,
 -3.519575061904807e-09,  1.005508623822950e-10, -2.667389900277847e-12,  6.641145482699163e-14, -1.564275451329027e-15,  3.507181269949266e-17, -7.518040781136703e-19,
  2.998123037322168e-02, -1.409954470028267e-03,  5.123351912002148e-05, -1.564905310471832e-06,  4.241240661010079e-08, -1.050685872618034e-09,  2.422647772491934e-11,
 -5.262618849028624e-13,  1.086301476028277e-14, -2.144477799490643e-16,  4.068744845292522e-18, -7.446135580803275e-20,  3.000084944964778e-02, -8.779265953063811e-04,
  2.168364920049210e-05, -4.788015338099959e-07,  9.714121754538896e-09, -1.846101372095143e-10,  3.329055180245900e-12, -5.746864540113089e-14,  9.556977555416336e-16,
 -1.538249443706634e-17,  2.405022555086482e-19, -3.662235828393888e-21,  1.662566243371708e-02, -3.243913590966922e-04,  5.103991342124255e-06, -7.461618271763020e-08,
  1.046439256531917e-09, -1.422398423578835e-11,  1.883269491267995e-13, -2.436999494760922e-15,  3.090386145059716e-17, -3.848959321786634e-19,  4.716731852560847e-21,
 -5.695276896123719e-23,  7.364060630314736e-06, -3.192283008610223e-06,  7.423657968083729e-07, -1.173995461731262e-07,  1.404896919372075e-08, -1.351827959088080e-09,
  1.087631905009531e-10, -7.519135449577216e-12,  4.557236182720164e-13, -2.459074487096547e-14,  1.195826011075000e-15, -5.284690691331504e-17,  1.199074818755979e-05,
 -4.875676408749900e-06,  1.061742262607665e-06, -1.578838229196945e-07,  1.785269963400907e-08, -1.630875330020843e-09,  1.251180321333640e-10, -8.280876561620600e-12,
  4.822280158763591e-13, -2.508364643034254e-14,  1.179366118377768e-15, -5.053265430856896e-17,  2.895218183371893e-05, -1.039806143536237e-05,  2.001364704057341e-06,
 -2.654060699941563e-07,  2.701754084724879e-08, -2.241616208372147e-09,  1.574481627670915e-10, -9.609727462413615e-12,  5.194435778945863e-13, -2.522848661511500e-14,
  1.113496090930582e-15, -4.501190228338381e-17,  8.973817784441485e-05, -2.698427255298845e-05,  4.384818290720501e-06, -4.979904845143469e-07,  4.400394787708698e-08,
 -3.207385056045367e-09,  2.000245563128741e-10, -1.094244724356617e-11,  5.346514190787149e-13, -2.365151220643784e-14,  9.573846328436875e-16, -3.572364044943394e-17,
  3.084734955478828e-04, -7.415478679240953e-05,  9.826767546826487e-06, -9.284474298048331e-07,  6.941132634417360e-08, -4.342167342332777e-09,  2.352939196163497e-10,
 -1.130574818625139e-11,  4.898528479246509e-13, -1.938131594429913e-14,  7.071323330609391e-16, -2.395497368623743e-17,  1.041875396592438e-03, -1.922033619320617e-04,
  2.023054988428452e-05, -1.557114002048389e-06,  9.671830664517420e-08, -5.107938402363605e-09,  2.368352442748541e-10, -9.850484091828590e-12,  3.732132367778338e-13,
 -1.302970565580288e-14,  4.229106495795320e-16, -1.284188592363352e-17,  3.158057109557719e-03, -4.300031884173736e-04,  3.518614025085626e-05, -2.169933515008850e-06,
  1.104011209135841e-07, -4.859093732917749e-09,  1.904470759513690e-10, -6.777174765081417e-12,  2.220101478731913e-13, -6.764151031552192e-15,  1.932034648654003e-16,
 -5.202814667068571e-18,  8.040010034708563e-03, -7.759514623386674e-04,  4.840716399945483e-05, -2.355308000024944e-06,  9.685176735880514e-08, -3.509227563441950e-09,
  1.149253386980988e-10, -3.460248542801532e-12,  9.694795497023752e-14, -2.550458074011465e-15,  6.343894835174177e-17, -1.499416255070310e-18,  1.631746021368981e-02,
 -1.068224259455451e-03,  4.974482688572401e-05, -1.876941169618230e-06,  6.142454001061426e-08, -1.806198316717577e-09,  4.876148117389945e-11, -1.226128692793232e-12,
  2.901324833587256e-14, -6.509855582127479e-16,  1.393196150312892e-17, -2.856104548779268e-19,  2.505662808228478e-02, -1.065079682998267e-03,  3.592295922675160e-05,
 -1.027209989471931e-06,  2.619585180331670e-08, -6.129444838155146e-10,  1.338882760548023e-11, -2.762017334071168e-13,  5.425724748053371e-15, -1.021193795457349e-16,
  1.850275113378921e-18, -3.238542496489332e-20,  2.680308529494795e-02, -7.250525224745003e-04,  1.676144742363005e-05, -3.490630052663907e-07,  6.706460982040119e-09,
 -1.210188122639545e-10,  2.076450027119917e-12, -3.416451025848416e-14,  5.423050987860729e-16, -8.342317095612637e-18,  1.247998675865143e-19, -1.820283646455082e-21,
  1.540446523520588e-02, -2.868765061524485e-04,  4.300404096392545e-06, -5.992475558327721e-08,  8.021585046151974e-10, -1.042283384879001e-11,  1.320866328150195e-13,
 -1.637746372532058e-15,  1.991715261349532e-17, -2.380696876227931e-19,  2.801516019942492e-21, -3.251180843634838e-23,  1.073474883608207e-06, -4.639982113066197e-07,
  1.075770494761428e-07, -1.696393002881311e-08,  2.024656897691737e-09, -1.943398163357333e-10,  1.560039741014418e-11, -1.076236421584885e-12,  6.510181052441509e-14,
 -3.506503456817716e-15,  1.702296551340913e-16, -7.511069784726419e-18,  2.039281439855798e-06, -8.163931140322565e-07,  1.750525382960196e-07, -2.566422350136626e-08,
  2.864947633823093e-09, -2.586961232759280e-10,  1.963912778606101e-11, -1.287461574177165e-12,  7.432593358161295e-14, -3.835665784155469e-15,  1.790426593337131e-16,
 -7.620945537051416e-18,  6.348306118871298e-06, -2.197996540846474e-06,  4.086050393966143e-07, -5.251042410845611e-08,  5.196369905029033e-09, -4.202750777010471e-10,
  2.884521510501958e-11, -1.723955141870027e-12,  9.141908246145468e-14, -4.363002445783146e-15,  1.895013740777756e-16, -7.548511846760746e-18,  2.621965427377131e-05,
 -7.425183395676707e-06,  1.142734459286726e-06, -1.236445690360921e-07,  1.046105649080735e-08, -7.331436881237242e-10,  4.411928130811590e-11, -2.336184235089230e-12,
  1.107852144276342e-13, -4.767841374997240e-15,  1.881572250948349e-16, -6.858137355558899e-18,  1.184585759728988e-04, -2.626161685896570e-05,  3.244768792421989e-06,
 -2.882310843148188e-07,  2.039078590367716e-08, -1.213373851608534e-09,  6.281539490808361e-11, -2.894178660626388e-12,  1.206293039512274e-13, -4.604208763811404e-15,
  1.624597751668706e-16, -5.334759134339762e-18,  5.073717079278779e-04, -8.493390747485875e-05,  8.251356709666836e-06, -5.921439050462082e-07,  3.454557197804391e-08,
 -1.723384932943670e-09,  7.583206858966091e-11, -3.004907311826699e-12,  1.088327144605126e-13, -3.642908971502908e-15,  1.136617782539795e-16, -3.325792374692495e-18,
  1.870465663039203e-03, -2.286844022573294e-04,  1.719599615146516e-05, -9.851370981203054e-07,  4.691372341267397e-08, -1.943707085050326e-09,  7.204111546404731e-11,
 -2.433528101696754e-12,  7.592008187161342e-14, -2.209179300379918e-15,  6.041808715722574e-17, -1.561477947715317e-18,  5.562927669093772e-03, -4.799068721778417e-04,
  2.753370035501085e-05, -1.244864830130076e-06,  4.790802427459028e-08, -1.633166398335222e-09,  5.053201603396862e-11, -1.442416924930046e-12,  3.842694279307729e-14,
 -9.637134897142103e-16,  2.290409854902433e-17, -5.183470073119679e-19,  1.271825811752846e-02, -7.460348055767989e-04,  3.210427872532634e-05, -1.129584416361437e-06,
  3.468504922881171e-08, -9.613304992800437e-10,  2.454942519306845e-11, -5.856453164222755e-13,  1.318004821333925e-14, -2.818796318423980e-16,  5.761311613191341e-18,
 -1.129993180074229e-19,  2.130196811897996e-02, -8.207068204436026e-04,  2.575683156315750e-05, -6.910038956261465e-07,  1.661249647379306e-08, -3.677445398303006e-10,
  7.620946020320275e-12, -1.494988465297248e-13,  2.798138161675085e-15, -5.026505215533889e-17,  8.705754356762635e-19, -1.458621230491491e-20,  2.414688268295629e-02,
 -6.060596497152517e-04,  1.314459923851882e-05, -2.587081585272114e-07,  4.716018695204241e-09, -8.094887587119433e-11,  1.323706415985112e-12, -2.078967111583353e-14,
  3.154345057665625e-16, -4.643728969668085e-18,  6.655254893289899e-20, -9.309198325013453e-22,  1.432149985734429e-02, -2.551462706800217e-04,  3.651953420572798e-06,
 -4.860002191039629e-08,  6.220294261306987e-10, -7.738226842599465e-12,  9.400359183373668e-14, -1.118411047906669e-15,  1.306159596000842e-17, -1.500607970381182e-19,
  1.696838127026879e-21, -1.899357968268713e-23,  1.576414199526065e-07, -6.790142266643880e-08,  1.568612835471120e-08, -2.465201209333418e-09,  2.933059529683692e-10,
 -2.807268959456996e-11,  2.247556583948288e-12, -1.546768937298754e-13,  9.335431017882738e-15, -5.017779129044922e-16,  2.431271531428876e-17, -1.070832714404508e-18,
  3.592926691088730e-07, -1.411190572042830e-07,  2.969869511732034e-08, -4.280644052064803e-09,  4.705936119515770e-10, -4.191156150187059e-11,  3.142457277418708e-12,
 -2.037053564437479e-13,  1.164086626604148e-14, -5.952025969128040e-16,  2.754965702672571e-17, -1.163668635039419e-18,  1.487549113674368e-06, -4.931875445425496e-07,
  8.804714893235266e-08, -1.091194379836654e-08,  1.045308626773020e-09, -8.210817808760035e-11,  5.488591478605551e-12, -3.202671274712558e-13,  1.661707266184236e-14,
 -7.774202178736980e-16,  3.315615308652706e-17, -1.298854171916085e-18,  8.317801547707089e-06, -2.200348645154535e-06,  3.187405053868273e-07, -3.268928706253303e-08,
  2.636464026408767e-09, -1.769692636209130e-10,  1.024055942019001e-11, -5.231989241864569e-13,  2.400996005266501e-14, -1.002564515023954e-15,  3.847663708443645e-17,
 -1.366749058079322e-18,  4.935616341865950e-05, -1.001501700002431e-05,  1.148088234799245e-06, -9.550882375447079e-08,  6.372346797441755e-09, -3.596188626922558e-10,
  1.773737234674144e-11, -7.816473435969282e-13,  3.126498424196356e-14, -1.148575822424772e-15,  3.910992438811007e-17, -1.242327261001413e-18,  2.651316488901359e-04,
 -4.004451235168502e-05,  3.580909003739760e-06, -2.390896867329351e-07,  1.307706137219899e-08, -6.152138392518096e-10,  2.564939915270048e-11, -9.668428268010430e-13,
  3.342427507451249e-14, -1.071080032109532e-15,  3.207809320889035e-17, -9.031603915998273e-19,  1.170762390559907e-03, -1.280843744638670e-04,  8.846345050530826e-06,
 -4.705974654419027e-07,  2.096868327136880e-08, -8.174847985689838e-10,  2.863952857928909e-11, -9.178769150300015e-13,  2.725569758068638e-14, -7.570043470497626e-16,
  1.980979707228800e-17, -4.910035300577573e-19,  4.004820237914796e-03, -3.084733833699012e-04,  1.629776253263115e-05, -6.853374228214710e-07,  2.470298012503610e-08,
 -7.927858267199326e-10,  2.318620944432240e-11, -6.276802628184307e-13,  1.590379779475335e-14, -3.802819177726053e-16,  8.636136355775338e-18, -1.871336144274469e-19,
  1.017356343952455e-02, -5.352641056745459e-04,  2.133484558187895e-05, -7.012481386173625e-07,  2.023367950897106e-08, -5.292596957997511e-10,  1.279899910752339e-11,
 -2.899481705569499e-13,  6.211341316136152e-15, -1.267108436395321e-16,  2.474880707194242e-18, -4.646467921497106e-20,  1.838444960053741e-02, -6.438025573200618e-04,
  1.884557100721773e-05, -4.753658359214247e-07,  1.079355045091199e-08, -2.264148711151644e-10,  4.458030040071661e-12, -8.327044974284615e-14,  1.486771674771453e-15,
 -2.551892349014137e-17,  4.229132103882937e-19, -6.788895973315136e-21,  2.191495760175000e-02, -5.121508238020668e-04,  1.044450884651917e-05, -1.946567755254179e-07,
  3.372880132600424e-09, -5.516254266414455e-11,  8.610252303188004e-13, -1.292729508439229e-14,  1.877371013673454e-16, -2.648475702671920e-18,  3.640370814991270e-20,
 -4.889982482023531e-22,  1.335587672219783e-02, -2.281052676879018e-04,  3.123730646651739e-06, -3.977294386979121e-08,  4.875136922383335e-10, -5.815256776378652e-12,
  6.781226670855286e-14, -7.752507538063318e-16,  8.703552471648950e-18, -9.635177401891299e-20,  1.043458090294825e-21, -1.142385436327835e-23,  2.335611453737619e-08,
 -1.001753540898784e-08,  2.304131073734587e-09, -3.606482143525893e-10,  4.275041369772540e-11, -4.077849495510050e-12,  3.254706388184563e-13, -2.233538018062124e-14,
  1.344526225288625e-15, -7.209459094179522e-17,  3.485462659658410e-18, -1.531997286813849e-19,  6.602442133853972e-08, -2.533052633298796e-08,  5.211348239150607e-09,
 -7.359292672896785e-10,  7.943698618481418e-11, -6.959737714116317e-12,  5.142074936963091e-13, -3.289397035215934e-14,  1.857373676414870e-15, -9.394347390440798e-17,
  4.305622120730902e-18, -1.802425282695419e-19,  3.753570994033927e-07, -1.182370130256802e-07,  2.014175786746575e-08, -2.394334686239675e-09,  2.210014877122384e-10,
 -1.679095469927211e-11,  1.089216562920836e-12, -6.185284312387885e-14,  3.130879965359038e-15, -1.432097350996833e-16,  5.982978998141265e-18, -2.299896685465437e-19,
  2.874883175891897e-06, -7.042301899486870e-07,  9.541845540023684e-08, -9.228099865081524e-09,  7.063754998451591e-10, -4.523629210874271e-11,  2.508299128692254e-12,
 -1.232535686530868e-13,  5.457526207490716e-15, -2.205019269610594e-16,  8.208776434034325e-18, -2.834944362337908e-19,  2.228555095651535e-05, -4.107913908915363e-06,
  4.349782225629159e-07, -3.376909529538333e-08,  2.118516792293722e-09, -1.130799631771006e-10,  5.300634481982531e-12, -2.228945372469696e-13,  8.537041768709750e-15,
 -3.012261501716054e-16,  9.878217604971906e-18, -3.029445504238094e-19,  1.480929648266481e-04, -2.007262911242734e-05,  1.648772231432248e-06, -1.022564516989727e-07,
  5.236264165304260e-09, -2.320073033908923e-10,  9.153549775113783e-12, -3.278176098872867e-13,  1.080392786571700e-14, -3.310378818039634e-16,  9.504918176735671e-18,
 -2.571825616924361e-19,  7.708749129393672e-04, -7.523591065076153e-05,  4.773385857056957e-06, -2.357912396095452e-07,  9.830227953690144e-09, -3.605903293878952e-10,
  1.193894422739185e-11, -3.629455178042772e-13,  1.025483155683317e-14, -2.717488043667423e-16,  6.801406492656528e-18, -1.615906504222850e-19,  2.987718149719828e-03,
 -2.053028332853239e-04,  1.000575124103015e-05, -3.917829345248668e-07,  1.323945839235210e-08, -4.003210582987660e-10,  1.107394494643632e-11, -2.844596273477894e-13,
  6.857651486803044e-15, -1.563873664747300e-16,  3.394324937583437e-18, -7.043035055342006e-20,  8.327400420958727e-03, -3.934499643897946e-04,  1.456037772604166e-05,
 -4.479051229312905e-07,  1.216303750701538e-08, -3.006652676178579e-10,  6.893494537564830e-12, -1.484504833753243e-13,  3.029867850908404e-15, -5.900308660910361e-17,
  1.102057270677449e-18, -1.981710276610267e-20,  1.607837489620158e-02, -5.132296632498903e-04,  1.404480392169980e-05, -3.337879778465664e-07,  7.170888375449375e-09,
 -1.427699662269939e-10,  2.674708088162351e-12, -4.763344376920677e-14,  8.122912104380285e-16, -1.333584324106901e-17,  2.116974691268290e-19, -3.258738785369623e-21,
  2.001986567203363e-02, -4.370979723491188e-04,  8.399344583963480e-06, -1.485058149992732e-07,  2.450124317009687e-09, -3.824165238560450e-11,  5.706177491328443e-13,
 -8.201418313668734e-15,  1.141425529811817e-16, -1.545316592961659e-18,  2.038511814810440e-20, -2.634489869897818e-22,  1.249058883113714e-02, -2.049002192571773e-04,
  2.689686117217907e-06, -3.282159125121205e-08,  3.858752587479909e-10, -4.419714288973839e-12,  4.953516250400466e-14, -5.450741324902364e-16,  5.878388915707902e-18,
 -6.323808561456568e-20,  6.429601327223064e-22, -7.179465729817636e-24,  3.497994114931918e-09, -1.492427547602330e-09,  3.414508279480045e-10, -5.318300703671278e-11,
  6.276141710223252e-12, -5.962491988393433e-13,  4.741481880704344e-14, -3.242977499456643e-15,  1.946229060284084e-16, -1.040668746538081e-17,  5.018266976087202e-19,
 -2.200517938812244e-20,  1.275658697827769e-08, -4.754066406222755e-09,  9.514837892208929e-10, -1.310944716586162e-10,  1.384388575381859e-11, -1.189475269727234e-12,
  8.636290846847150e-14, -5.438877584334649e-15,  3.028115172599054e-16, -1.512203972752792e-17,  6.851234957115320e-19, -2.838230380304897e-20,  1.027666512691878e-07,
 -3.048041500557286e-08,  4.919605557995333e-09, -5.576574434001278e-10,  4.934707137834773e-11, -3.610522506543519e-12,  2.264015459071363e-13, -1.246811828678948e-14,
  6.137643515888397e-16, -2.736955719831713e-17,  1.117155529988520e-18, -4.203981204981238e-20,  1.084982783689209e-06, -2.438589368677367e-07,  3.071329579398750e-08,
 -2.787086211867796e-09,  2.016183982805238e-10, -1.227211572730530e-11,  6.498264031545445e-13, -3.061511654861797e-14,  1.304203335230549e-15, -5.084912005797570e-17,
  1.831597992198875e-18, -6.135303329090258e-20,  1.087996098722998e-05, -1.808397939717312e-06,  1.761885162287485e-07, -1.272605989024991e-08,  7.487513696040804e-10,
 -3.771253301251124e-11,  1.676399622132585e-12, -6.712790932166184e-14,  2.457047205141057e-15, -8.311028935716474e-17,  2.619976826172668e-18, -7.743518402225386e-20,
  8.803879495625573e-05, -1.065466023981376e-05,  8.028177973798773e-07, -4.619814383391568e-08,  2.212702089688271e-09, -9.225061451561086e-11,  3.441088306153986e-12,
 -1.169760142387675e-13,  3.671754034856266e-15, -1.074678513918758e-16,  2.955259211413187e-18, -7.676740775826696e-20,  5.315468024700563e-04, -4.615472903967330e-05,
  2.691978385652262e-06, -1.235214938794742e-07,  4.819763746024714e-09, -1.663810384694040e-10,  5.206686115872466e-12, -1.501379629334074e-13,  4.035992847865310e-15,
 -1.020256137414769e-16,  2.441631924860424e-18, -5.558654907174854e-20,  2.301208744958569e-03, -1.409877801067346e-04,  6.351454228615079e-06, -2.318829522204230e-07,
  7.354695370879440e-09, -2.097236066566591e-10,  5.491702384897117e-12, -1.339427795531583e-13,  3.073998543980539e-15, -6.688604964007789e-17,  1.387956470007697e-18,
 -2.758430206923568e-20,  6.956659763443600e-03, -2.955629466415831e-04,  1.018041049980441e-05, -2.936524375958769e-07,  7.516764494669451e-09, -1.758406983153516e-10,
  3.826976670735466e-12, -7.842594143023391e-14,  1.526532264869199e-15, -2.840082582918186e-17,  5.076922871688265e-19, -8.749386596501386e-21,  1.422729876339549e-02,
 -4.151389782421147e-04,  1.064370009456536e-05, -2.388149228620203e-07,  4.862876454122239e-09, -9.203599255500659e-11,  1.642913547401450e-12, -2.793132476707418e-14,
  4.554867536460106e-16, -7.159851515869730e-18,  1.089988603182939e-19, -1.610203770977290e-21,  1.839544671590207e-02, -3.764187136238332e-04,  6.829460744501581e-06,
 -1.147496638024343e-07,  1.805572499877741e-09, -2.693605417715374e-11,  3.847538984860268e-13, -5.301732526716456e-15,  7.077216076745504e-17, -9.214697310266326e-19,
  1.166203927144272e-20, -1.452849518885427e-22,  1.171166830901294e-02, -1.848595312307111e-04,  2.330149958779066e-06, -2.729497953878808e-08,  3.082347125580203e-10,
 -3.394699471834809e-12,  3.659642412859747e-14, -3.889938977395690e-16,  3.996296825787109e-18, -4.301125470150063e-20,  3.868352425548860e-22, -4.623214393622555e-24,
  5.309096041233794e-10, -2.250204102794815e-10,  5.114358964845245e-11, -7.918090710571076e-12,  9.293643256961045e-13, -8.786260809379450e-14,  6.956365914145675e-15,
 -4.739002298162233e-16,  2.833812417089586e-17, -1.510300847187577e-18,  7.261079985947970e-20, -3.175266863142551e-21,  2.615826099455253e-09, -9.403666166531534e-10,
  1.819996971738648e-10, -2.434237704770472e-11,  2.504134536942290e-12, -2.102196210898389e-13,  1.495102359495664e-14, -9.243342232053683e-16,  5.061611197497146e-17,
 -2.490213698587733e-18,  1.113085671470204e-19, -4.555136643925607e-21,  3.074260482949365e-08, -8.498642063096274e-09,  1.289758590648181e-09, -1.385434261852767e-10,
  1.169112430763986e-11, -8.199334903269628e-13,  4.949591902222408e-14, -2.633661689010508e-15,  1.256606088603379e-16, -5.446264598586733e-18,  2.165863039457684e-19,
 -7.958291657154057e-21,  4.474768757115145e-07, -9.140567667269035e-08,  1.063787089846352e-08, -9.015326397974196e-10,  6.138761058669677e-11, -3.538883873521468e-12,
  1.783724742050691e-13, -8.033222635234727e-15,  3.283248717502751e-16, -1.232048615842854e-17,  4.283343086468845e-19, -1.388394544903165e-20,  5.724821900914119e-06,
 -8.518288241599391e-07,  7.612036283656175e-08, -5.102651231540877e-09,  2.809617218783328e-10, -1.332741864970331e-11,  5.607795341613381e-13, -2.134553921669461e-14,
  7.453792569212793e-16, -2.412951873929137e-17,  7.300220324515077e-19, -2.076026377677104e-20,  5.544996260836914e-05, -5.963538114513634e-06,  4.119555727399788e-07,
 -2.198147000803786e-08,  9.842154260785998e-10, -3.858884033249452e-11,  1.360096128958494e-12, -4.385809429089772e-14,  1.310251347060189e-15, -3.660564506694041e-17,
  9.633241322823892e-19, -2.400405954755624e-20,  3.821772953930006e-04, -2.945190884232314e-05,  1.581242938028213e-06, -6.744114363189237e-08,  2.464378842248803e-09,
 -8.009469698922191e-11,  2.369767951898184e-12, -6.482970955185610e-14,  1.658265407990614e-15, -3.998842901490925e-17,  9.149871031158189e-19, -1.995778698997627e-20,
  1.823713456041138e-03, -9.958391212549879e-05,  4.156630834180537e-06, -1.417027258422743e-07,  4.223682253131178e-09, -1.137052744870205e-10,  2.821019929890157e-12,
 -6.537897832100544e-14,  1.429387782121628e-15, -2.968991676196660e-17,  5.893078658268262e-19, -1.122204221168611e-20,  5.917547769624374e-03, -2.264086170003231e-04,
  7.276476097532850e-06, -1.971865017350332e-07,  4.765530036475684e-09, -1.056456371827976e-10,  2.185350219274297e-12, -4.266197417645912e-14,  7.928226889056847e-16,
 -1.410243803008437e-17,  2.414907316762334e-19, -3.991799546663363e-21,  1.272059107755782e-02, -3.402569768923601e-04,  8.190291746880922e-06, -1.738313529195776e-07,
  3.360708564919070e-09, -6.055513606409614e-11,  1.031428608321080e-12, -1.675957170245264e-14,  2.617232194080314e-16, -3.941760404721439e-18,  5.762686787399459e-20,
 -8.179537857058287e-22,  1.699096544018272e-02, -3.268378121327902e-04,  5.609519521140682e-06, -8.971478495591414e-08,  1.348371341644372e-09, -1.925514769453419e-11,
  2.636005015345155e-13, -3.488911485826583e-15,  4.465729761385052e-17, -5.612482567717628e-19,  6.811096551190766e-21, -8.144214155089120e-23,  1.100755009346303e-02,
 -1.674495180249769e-04,  2.030105287694653e-06, -2.286211490303447e-08,  2.483105974172873e-10, -2.633969734365899e-12,  2.728133436855701e-14, -2.832600182149055e-16,
  2.683241208022714e-18, -3.096045900375990e-20,  2.322217465032537e-22, -2.334957371848161e-24,  8.193300729480088e-11, -3.443392671844357e-11,  7.761558569137325e-12,
 -1.192683954196736e-12,  1.390569644513886e-13, -1.306858345227268e-14,  1.029197189106867e-15, -6.978007821410222e-17,  4.154784759754597e-18, -2.205724359103177e-19,
  1.056705467015206e-20, -4.606137408130756e-22,  5.754041509319141e-10, -1.977979700911276e-10,  3.675374104627035e-11, -4.743528827988403e-12,  4.729512669229885e-13,
 -3.862434942121555e-14,  2.680682065531999e-15, -1.621602707490436e-16,  8.708354993727078e-18, -4.209912151249379e-19,  1.852254997935963e-20, -7.472703704516155e-22,
  1.010937308467448e-08, -2.575490953552003e-09,  3.645818255521023e-10, -3.687370727282689e-11,  2.951170239678606e-12, -1.974514585262091e-13,  1.142587622321374e-14,
 -5.851767419618120e-16,  2.696821935652592e-17, -1.132401208447340e-18,  4.374663468789660e-20, -1.565308694013138e-21,  2.015505802935314e-07, -3.705494310472854e-08,
  3.963441192975637e-09, -3.123565474719976e-10,  1.994795912759293e-11, -1.085620642968859e-12,  5.193236166346333e-14, -2.229592818667409e-15,  8.719988664582722e-17,
 -3.141636207482542e-18,  1.051719080925992e-19, -3.291394189682836e-21,  3.233765249211964e-06, -4.277207718241274e-07,  3.497598745482564e-08, -2.171713958055973e-09,
  1.117253506545838e-10, -4.983560262628669e-12,  1.982004147852638e-13, -7.161180591569303e-15,  2.382304147189725e-16, -7.370283462397196e-18,  2.136996375230039e-19,
 -5.839095307024612e-21,  3.682945849158241e-05, -3.504203687498630e-06,  2.219739458509578e-07, -1.098029890734742e-08,  4.595364273438516e-10, -1.694026766095901e-11,
  5.640087335710724e-13, -1.724581228467905e-14,  4.901507064605214e-16, -1.306451529677436e-17,  3.288374511327396e-19, -7.855213824229113e-21,  2.853518459671924e-04,
 -1.947317484428788e-05,  9.642175881499137e-07, -3.826020926162853e-08,  1.310339933952268e-09, -4.012123950984887e-11,  1.122925605172845e-12, -2.915497863325470e-14,
  7.098142411140314e-16, -1.633117217127766e-17,  3.573081453249395e-19, -7.467291447050549e-21,  1.482535263735789e-03, -7.213543898389492e-05,  2.797040638909479e-06,
 -8.917868264115340e-08,  2.501387213100190e-09, -6.364548405107704e-11,  1.497682821712735e-12, -3.300664064674022e-14,  6.880443984835913e-16, -1.365040310804332e-17,
  2.592913827507506e-19, -4.734174687019194e-21,  5.114990085240985e-03, -1.765094291509438e-04,  5.306236290986291e-06, -1.353516051557522e-07,  3.093387589075508e-09,
 -6.507486820128515e-11,  1.281215041736253e-12, -2.384660720068613e-14,  4.237098748162190e-16, -7.210128984099081e-18,  1.183472299643247e-19, -1.879839519772590e-21,
  1.147857593227379e-02, -2.822484690347742e-04,  6.390935562977724e-06, -1.285479149681477e-07,  2.363525463763388e-09, -4.060246998356689e-11,  6.608862123245234e-13,
 -1.027189874626832e-14,  1.539049377738004e-16, -2.221556000137539e-18,  3.120474082420817e-20, -4.274805468508952e-22,  1.576702999282781e-02, -2.859283971159669e-04,
  4.650706554655121e-06, -7.090846319442211e-08,  1.019381317717367e-09, -1.395647797809727e-11,  1.832179963039465e-13, -2.336832662879417e-15,  2.860527075198502e-17,
 -3.484189342425511e-19,  4.091457506232343e-21, -4.539786000271918e-23,  1.036858653364249e-02, -1.522423019858275e-04,  1.777967567021381e-06, -1.927754030968973e-08,
  2.015822834068904e-10, -2.065660330450796e-12,  2.039644506500123e-14, -2.135885490345723e-16,  1.718682043611732e-18, -2.287770376694275e-20,  1.950114682944296e-22,
  8.347024978349877e-25,  1.291495418743808e-11, -5.368242308844573e-12,  1.197237654235706e-12, -1.822436009122415e-13,  2.107194203784259e-14, -1.965855455011793e-15,
  1.538144121636309e-16, -1.036849166013631e-17,  6.141630015718451e-19, -3.245377758027486e-20,  1.548259320685644e-21, -6.723222701674783e-23,  1.373915664444334e-10,
 -4.467449465847524e-11,  7.901831354190253e-12, -9.772279930716127e-13,  9.388137984484770e-14, -7.421156825022980e-15,  5.004396061679641e-16, -2.950786014253453e-17,
  1.548827859141344e-18, -7.335610433933582e-20,  3.168458699509271e-21, -1.257190640082765e-22,  3.670956729472023e-09, -8.512887873138791e-10,  1.115010264161050e-10,
 -1.055007847390203e-11,  7.964991256661281e-13, -5.059794031157830e-14,  2.794831454439777e-15, -1.372418590811242e-16,  6.087589952999030e-18, -2.468478806294356e-19,
  9.235869268515102e-21, -3.209116445491240e-22,  9.893977553958164e-08, -1.621110352003157e-08,  1.586244006477487e-09, -1.158219252334670e-10,  6.915564556317373e-12,
 -3.543030835059293e-13,  1.604345609183394e-14, -6.549972204956923e-16,  2.445599206877995e-17, -8.440376170455746e-19,  2.714883381600268e-20, -8.185978679599520e-22,
  1.952129616489423e-06, -2.279465981136303e-07,  1.703428891419527e-08, -9.783464568070539e-10,  4.697300481312860e-11, -1.968088751214813e-12,  7.390208433938298e-14,
 -2.531744555872376e-15,  8.014697564460923e-17, -2.366967287480411e-18,  6.569568205995194e-20, -1.722695238153232e-21,  2.567739739124477e-05, -2.152146015917284e-06,
  1.251452462513828e-07, -5.739775124583576e-09,  2.245791926015176e-10, -7.784408968183695e-12,  2.448245301708322e-13, -7.097588617292535e-15,  1.918743466801210e-16,
 -4.877880256152319e-18,  1.173879435180003e-19, -2.687132950863856e-21,  2.204121213629826e-04, -1.329219453355501e-05,  6.084902708215952e-07, -2.248735247209935e-08,
  7.225674952239631e-10, -2.085889168708701e-11,  5.526812176848407e-13, -1.362442461084042e-14,  3.158753087244702e-16, -6.936317895925689e-18,  1.451286943453337e-19,
 -2.906812439644586e-21,  1.232815841403206e-03, -5.344476256852904e-05,  1.930587586906608e-06, -5.766143266598667e-08,  1.524225226956313e-09, -3.669478967745406e-11,
  8.200809712049894e-13, -1.719662942052082e-14,  3.421605953450055e-16, -6.488955412134439e-18,  1.179604040768517e-19, -2.067893379137683e-21,  4.484635298773123e-03,
 -1.398040986960271e-04,  3.940884624189696e-06, -9.480091288628187e-08,  2.052305517306102e-09, -4.101680462080169e-11,  7.699946951437832e-13, -1.366761464059554e-14,
  2.326140932705405e-16, -3.791577903393174e-18,  5.954906268781946e-20, -9.136850765666125e-22,  1.044290011588212e-02, -2.367049701236854e-04,  5.051007983745020e-06,
 -9.645475166373301e-08,  1.689383346237345e-09, -2.770215423288456e-11,  4.317250236418072e-13, -6.418190346152826e-15,  9.249830277625844e-17, -1.281884952210786e-18,
  1.720112156269162e-20, -2.307080746324834e-22,  1.469270396874253e-02, -2.518688441909911e-04,  3.889171631395217e-06, -5.661300607345195e-08,  7.794133599055761e-10,
 -1.025153419968296e-11,  1.289209459213178e-13, -1.594035043083714e-15,  1.859245306881746e-17, -2.176523469575879e-19,  2.600578216846670e-21, -2.421714981362063e-23,
  9.786673187586383e-03, -1.388920296815779e-04,  1.564706494410547e-06, -1.635806321124286e-08,  1.647088995522390e-10, -1.642400807709055e-12,  1.507360119640286e-14,
 -1.701235633785380e-16,  1.054618136904697e-18, -1.321227209667032e-20,  3.161768410217104e-22,  4.619753875218189e-24,  2.092183743703525e-12, -8.569712637342480e-13,
  1.884995073404697e-13, -2.834812818817829e-14,  3.243434914843031e-15, -2.998227086520221e-16,  2.327085748739970e-17, -1.557561740455434e-18,  9.168022592458128e-20,
 -4.817430655536461e-21,  2.286679239345811e-22, -9.884921859472185e-24,  3.605709898320566e-11, -1.094404011427662e-11,  1.824423380939356e-12, -2.144849445562344e-13,
  1.972240585779711e-14, -1.500492251547439e-15,  9.783019381742520e-17, -5.598525411242356e-18,  2.861273489924253e-19, -1.323181626901876e-20,  5.593757593168252e-22,
 -2.177004837159956e-23,  1.475947883340917e-09, -3.074471151743079e-10,  3.697055217001318e-11, -3.252453222821131e-12,  2.304305121952620e-13, -1.383519009603526e-14,
  7.264649361263901e-16, -3.407569080594240e-17,  1.449732170743391e-18, -5.658546526470543e-20,  2.044313848213007e-21, -6.878315025702941e-23,  5.275827368733920e-08,
 -7.627743701756845e-09,  6.803361673478268e-10, -4.588303519268652e-11,  2.554858280970109e-12, -1.229296072281531e-13,  5.257542403829723e-15, -2.036835966730696e-16,
  7.245451650286022e-18, -2.390622232397745e-19,  7.373921183828541e-21, -2.138104329984938e-22,  1.253295536124348e-06, -1.283231683914551e-07,  8.761570259859163e-09,
 -4.650479542504056e-10,  2.082530286035757e-11, -8.189953316979587e-13,  2.901586339706973e-14, -9.417542804265047e-16,  2.834648964506339e-17, -7.984463238585060e-19,
  2.119396138524554e-20, -5.328421894980700e-22,  1.870780944378922e-05, -1.375456980306437e-06,  7.356543353652563e-08, -3.129648627600114e-09,  1.145506703782202e-10,
 -3.734379779960829e-12,  1.109832185735403e-13, -3.050646614494657e-15,  7.844475678456237e-17, -1.902053991357878e-18,  4.375373542784273e-20, -9.595946104707654e-22,
  1.755110150999066e-04, -9.334719795798812e-06,  3.962655091329575e-07, -1.365475934299473e-08,  4.121851242037080e-10, -1.122624152749043e-11,  2.819113018694206e-13,
 -6.601108935075807e-15,  1.458201681212368e-16, -3.058548881640902e-18,  6.118762803614175e-20, -1.175269631214908e-21,  1.046063548039187e-03, -4.040278082328706e-05,
  1.363822296027179e-06, -3.821953839047463e-08,  9.537310625492932e-10, -2.174087071776060e-11,  4.623351316774991e-13, -9.226764153606526e-15,  1.753759569174410e-16,
 -3.186528480820447e-18,  5.532729066751429e-20, -9.336424961289735e-22,  3.981981573082851e-03, -1.123256502503426e-04,  2.976154046715016e-06, -6.763909101366037e-08,
  1.389636033093121e-09, -2.639956207866441e-11,  4.738647437536460e-13, -8.016796594447413e-15,  1.307980078029701e-16, -2.054834184080082e-18,  3.058020782436337e-20,
 -4.575497206902004e-22,  9.570163274606721e-03, -2.005059524375306e-04,  4.039118381156076e-06, -7.334958006314361e-08,  1.225961301738198e-09, -1.920113509883102e-11,
  2.873600078212196e-13, -4.081486049363835e-15,  5.661546536480874e-17, -7.619938504434087e-19,  9.534338760332239e-21, -1.282265070799495e-22,  1.374343278975063e-02,
 -2.232754558407729e-04,  3.278379049409981e-06, -4.562857658616722e-08,  6.020276261218685e-10, -7.632366001043787e-12,  9.157177288324937e-14, -1.106199097972969e-15,
  1.241033344775871e-17, -1.309185364018306e-19,  1.820020449793363e-21, -1.268124214504469e-23,  9.254957268186377e-03, -1.271171404641978e-04,  1.383197206103706e-06,
 -1.396740462584789e-08,  1.351109035467409e-10, -1.334323809484105e-12,  1.073106434797090e-14, -1.410972316677722e-16,  8.629764014079403e-19,  4.256257791354964e-21,
  5.686936201924742e-22,  6.113396715803386e-24,  3.513068525405094e-13, -1.410519242402272e-13,  3.046294510855156e-14, -4.509705977960064e-15,  5.090593234135671e-16,
 -4.651331756297271e-17,  3.573900971993416e-18, -2.371077420473256e-19,  1.384866377617113e-20, -7.227155311985937e-22,  3.409617133394714e-23, -1.465913658675592e-24,
  1.053015267167415e-11, -2.936158934948700e-12,  4.562289229345712e-13, -5.053966363317719e-14,  4.415728876104185e-15, -3.213285461124899e-16,  2.014624234203920e-17,
 -1.113627363153663e-18,  5.518367255216203e-20, -2.482333536713182e-21,  1.023643798479429e-22, -3.895730667433619e-24,  6.574249182509440e-10, -1.212952426800723e-10,
  1.329718375614446e-11, -1.081509718073222e-12,  7.156485735773306e-14, -4.043971861115735e-15,  2.010838530783321e-16, -8.977677211297833e-18,  3.651333694967206e-19,
 -1.367569155313139e-20,  4.756753039764809e-22, -1.545490837182454e-23,  3.042657735567625e-08, -3.842843483454049e-09,  3.117291141686404e-10, -1.937085926586346e-11,
  1.003951272850249e-12, -4.528229745678290e-14,  1.825966306403472e-15, -6.701008323902919e-17,  2.267064568504594e-18, -7.139036760723289e-20,  2.108086813524366e-21,
 -5.868130340185534e-23,  8.514630866431152e-07, -7.592552540640484e-08,  4.741550987374726e-09, -2.324576158083306e-10,  9.708487571832473e-12, -3.582176611369582e-13,
  1.197043341766740e-14, -3.679092987284890e-16,  1.052310694054115e-17, -2.825456056502993e-19,  7.167488095123691e-21, -1.726447567007003e-22,  1.418270927989927e-05,
 -9.108608225021529e-07,  4.494199208531024e-08, -1.774261464313915e-09,  6.081587092304297e-11, -1.865107503245251e-12,  5.241636216992630e-14, -1.366436359681761e-15,
  3.342142827388233e-17, -7.732654888478707e-19,  1.699832382831543e-20, -3.571731683043346e-22,  1.436130732846142e-04, -6.722862887102080e-06,  2.656082285961724e-07,
 -8.542894700391717e-09,  2.426953653980399e-10, -6.238112709548544e-12,  1.487156650503311e-13, -3.309593564820894e-15,  6.964320932957343e-17, -1.398486318293205e-18,
  2.672145452485143e-20, -4.924732387793522e-22,  9.036960130172295e-04, -3.109684872222554e-05,  9.841347177444988e-07, -2.591314710009124e-08,  6.118252362410463e-10,
 -1.320336379772122e-11,  2.679444389795814e-13, -5.092195011792844e-15,  9.226201558161001e-17, -1.618453069849852e-18,  2.667894406306608e-20, -4.337165603520978e-22,
  3.575642214355944e-03, -9.142157315035544e-05,  2.282278101879680e-06, -4.907953509981132e-08,  9.593724046063987e-10, -1.730828078923481e-11,  2.983505378553492e-13,
 -4.813267729878070e-15,  7.471711164034929e-17, -1.156795056262842e-18,  1.594863244020591e-20, -2.323122965626925e-22,  8.827625928999461e-03, -1.714072539713377e-04,
  3.265058803580245e-06, -5.646713676023500e-08,  9.026074305656975e-10, -1.349411886591511e-11,  1.947850111233031e-13, -2.644934008203743e-15,  3.486785433631197e-17,
 -4.742449344306368e-19,  5.272791447414540e-21, -7.022674787249576e-23,  1.289953405990234e-02, -1.990857181911338e-04,  2.783953277055792e-06, -3.710767822521214e-08,
  4.690638647640076e-10, -5.765328133802178e-12,  6.554387273793687e-14, -7.714148307975534e-16,  8.888281439495254e-18, -6.773591647784557e-20,  1.362835724923320e-21,
 -9.412543286885195e-24,  8.767607654152893e-03, -1.166871917597514e-04,  1.227720143818183e-06, -1.200641232152015e-08,  1.106972140118299e-10, -1.120755550059204e-12,
  7.224139418542241e-15, -1.061573641873307e-16,  1.483216525875414e-18,  3.147099300008394e-20,  7.546209507655040e-22,  9.347190326767178e-25,  6.187807618738872e-14,
 -2.416231942465743e-14,  5.091224352250793e-15, -7.382048373696974e-16,  8.188143904828453e-17, -7.370893004706488e-18,  5.591524921498662e-19, -3.668834336217607e-20,
  2.122278259430364e-21, -1.098214989890075e-22,  5.142588920424814e-24, -2.196402457985345e-25,  3.460550965810991e-12, -8.699231826925961e-13,  1.245071721853773e-13,
 -1.287561948976819e-14,  1.060706827735250e-15, -7.334035712052882e-17,  4.396264581769903e-18, -2.335357273568570e-19,  1.116929452510952e-20, -4.867247484251309e-22,
  1.950607607999724e-23, -7.235065028891116e-25,  3.239045326615790e-10, -5.215260607296772e-11,  5.182773504350300e-12, -3.877639468858703e-13,  2.386741614984116e-14,
 -1.264597937159346e-15,  5.934322246710288e-17, -2.513710509003399e-18,  9.743632632863964e-20, -3.491711635168750e-21,  1.166039032605419e-22, -3.648699828345229e-24,
  1.888168730912691e-08, -2.061755286462021e-09,  1.520401960256455e-10, -8.687748365444803e-12,  4.186245646309356e-13, -1.767427312514626e-14,  6.710917351442778e-16,
 -2.329840876158023e-17,  7.486079017735078e-19, -2.246816702857744e-20,  6.342469739221200e-22, -1.692503449557606e-23,  6.090786398337507e-07, -4.696842607431117e-08,
  2.690063452478733e-09, -1.217485965246590e-10,  4.745569701070491e-12, -1.642280254217134e-13,  5.176632410966655e-15, -1.506528949471640e-16,  4.092499937880669e-18,
 -1.047306383078486e-19,  2.537617245166022e-21, -5.853015849838093e-23,  1.114359956902949e-05, -6.223951822596098e-07,  2.844866804065722e-08, -1.042396718657175e-09,
  3.352492318342182e-11, -9.670783489231011e-13,  2.572745782926123e-14, -6.366986944343646e-16,  1.479935575084881e-17, -3.272419569262578e-19,  6.871737525922564e-21,
 -1.382967833471945e-22,  1.204042033155270e-04, -4.950404769333943e-06,  1.828269170794091e-07, -5.491449125177269e-09,  1.472466366237499e-10, -3.569202189947069e-12,
  8.093581695988798e-14, -1.716241632740770e-15,  3.426338171101502e-17, -6.627556591186405e-19,  1.207540150993907e-20, -2.129611886561043e-22,  7.932964482732690e-04,
 -2.431920315724019e-05,  7.242103717455001e-07, -1.793018132134581e-08,  4.020353880792184e-10, -8.197355957674401e-12,  1.592148559511076e-13, -2.898324475343690e-15,
  4.936363017439674e-17, -8.526541500155638e-19,  1.326723150735020e-20, -2.040618497099507e-22,  3.243078968174058e-03, -7.528220702951591e-05,  1.775145702348256e-06,
 -3.615126714380689e-08,  6.751420278133248e-10, -1.152947384770687e-11,  1.915663208667190e-13, -2.982975811109611e-15,  4.247008913354376e-17, -6.828561037665952e-19,
  8.617177176170313e-21, -1.121161383948837e-22,  8.190267847128778e-03, -1.477706741867414e-04,  2.665956375642446e-06, -4.395357747613655e-08,  6.740642726272117e-10,
 -9.596349837459983e-12,  1.340399679506113e-13, -1.766915219889144e-15,  2.095976136149706e-17, -3.129148158384910e-19,  3.073144676120124e-21, -3.165236495308939e-23,
  1.214508348055083e-02, -1.784759173704143e-04,  2.380144280226315e-06, -3.044643063829016e-08,  3.678961093586028e-10, -4.421228167024172e-12,  4.762978331722523e-14,
 -5.163292733778155e-16,  7.325330609551373e-18, -2.225964527881820e-20,  8.785377231785304e-22, -1.389378623132560e-23,  8.319630255320846e-03, -1.074132756766181e-04,
  1.093558448898910e-06, -1.040605618948160e-08,  8.980804692489543e-11, -9.764282052070277e-13,  5.127574395216642e-15, -3.486030949093822e-17,  3.138260139784270e-18,
  5.891386295100115e-20,  5.107283960295802e-22, -1.379112572119701e-23,  1.162599857845808e-14, -4.362744393570266e-15,  8.888013656308496e-16, -1.253458317872208e-16,
  1.358696901757499e-17, -1.199691349436040e-18,  8.952949441552298e-20, -5.792600154170973e-21,  3.310467979806632e-22, -1.695119408019951e-23,  7.864822715550370e-25,
 -3.331945102454366e-26,  1.291046331031488e-12, -2.862888620565750e-13,  3.730217967775444e-14, -3.567219940361192e-15,  2.749467000235024e-16, -1.794230617316601e-17,
  1.022215655734736e-18, -5.190809394557348e-20,  2.384703659583655e-21, -1.002349631224279e-22,  3.888582726784155e-24, -1.400671319550405e-25,  1.758932532328208e-10,
 -2.432799291881187e-11,  2.184073830159349e-12, -1.496527224030708e-13,  8.541033657527004e-15, -4.229809736716205e-16,  1.867756330157725e-17, -7.485374360981785e-19,
  2.757769682915353e-20, -9.431167977079699e-22,  3.016140573549400e-23, -9.067320761279518e-25,  1.253839404607901e-08, -1.170691225078311e-09,  7.863815338710336e-11,
 -4.123734764978927e-12,  1.847169456940158e-13, -7.292061736944659e-15,  2.604794082099274e-16, -8.548285283662199e-18,  2.605476101226319e-19, -7.446003128544519e-21,
  2.007033415251382e-22, -5.128215938806045e-24,  4.565339334746917e-07, -3.021300181791083e-08,  1.594767570666104e-09, -6.655221965871065e-11,  2.425617907998235e-12,
 -7.870035060870872e-14,  2.340067315457403e-15, -6.455127693419341e-17,  1.663444403205610e-18, -4.059601333361803e-20,  9.392832006072825e-22, -2.072816006545527e-23,
  9.041152941207830e-06, -4.370007131804972e-07,  1.861418637511134e-08, -6.324033340657350e-10,  1.915035798110757e-11, -5.192822397597597e-13,  1.307793511374628e-14,
 -3.085298487362737e-16,  6.786102888132099e-18, -1.439015953483290e-19,  2.889655535897515e-21, -5.547115911934348e-23,  1.031606293796801e-04, -3.716140357816243e-06,
  1.290115708670919e-07, -3.615397429891150e-09,  9.195234134394872e-11, -2.098619059026886e-12,  4.521614379662159e-14, -9.239731811211681e-16,  1.724039322650299e-17,
 -3.247669135683193e-19,  5.683839677226275e-21, -9.351207302299111e-23,  7.063838081773872e-04, -1.928805147816652e-05,  5.428374751634059e-07, -1.262628695785311e-08,
  2.705406549003080e-10, -5.196627224460760e-12,  9.620275281589308e-14, -1.722520914205310e-15,  2.642001229661417e-17, -4.627890778851181e-19,  7.045718393798174e-21,
 -9.041921828474571e-23,  2.967843009204592e-03, -6.264869616234987e-05,  1.399272321706402e-06, -2.696981228045655e-08,  4.844683442869858e-10, -7.801137341602311e-12,
  1.237997615817692e-13, -1.958892741719254e-15,  2.312698409447213e-17, -4.125892545057003e-19,  5.452237372978283e-21, -3.507692808360724e-23,  7.638740924826441e-03,
 -1.283829786958999e-04,  2.197413256508009e-06, -3.454475988080348e-08,  5.106499342301699e-10, -6.906900773384555e-12,  9.241908443528069e-14, -1.254852198945948e-15,
  1.166143034693786e-17, -2.079989941712512e-19,  2.419027679058765e-21,  2.466862730904630e-24,  1.146708108361103e-02, -1.608024632994004e-04,  2.047376016755517e-06,
 -2.520982641372978e-08,  2.898661911897192e-10, -3.425642461440167e-12,  3.637438159431241e-14, -2.893393990541771e-16,  6.979888907340977e-18, -2.752465901457195e-21,
 -1.313088523974655e-23, -2.923768964479804e-23,  7.906715810859197e-03, -9.914131245154643e-05,  9.766842051168940e-07, -9.118771101970480e-09,  7.149839871408068e-11,
 -8.516676326857897e-13,  5.895515043502354e-15,  1.018427246525348e-16,  5.416448618322817e-18,  5.987474040550322e-20, -6.825579932321357e-22, -4.436814569651017e-23,
  2.385257519791938e-15, -8.444599844369602e-16,  1.642190887308844e-16, -2.231037726564030e-17,  2.345824777174668e-18, -2.019730117052229e-19,  1.475736699377486e-20,
 -9.378517601758472e-22,  5.278277851449352e-23, -2.667230766591206e-24,  1.223375988502872e-25, -5.131160524549841e-27,  5.497652711240183e-13, -1.048694390797130e-13,
  1.231390733203693e-14, -1.079018658605371e-15,  7.724549233410701e-17, -4.726744383237383e-18,  2.544672983362427e-19, -1.228755307944706e-20,  5.396366748911272e-22,
 -2.178194440776983e-23,  8.146801450611571e-25, -2.839072480790429e-26,  1.047484355591648e-10, -1.222954087531045e-11,  9.920181773765537e-13, -6.198264285957979e-14,
  3.273677802329665e-15, -1.511500046388955e-16,  6.265186820025324e-18, -2.370464577813184e-19,  8.281002439334523e-21, -2.696653376938851e-22,  8.240483943377211e-24,
 -2.374745187225295e-25,  8.859111706685442e-09, -6.985041595698797e-10,  4.298614459599000e-11, -2.062461292884105e-12,  8.599277676813158e-14, -3.172188477314079e-15,
  1.064822040667846e-16, -3.304701344107746e-18,  9.540808885008821e-20, -2.595006575630401e-21,  6.674864157832108e-23, -1.630599203069450e-24,  3.569356744174878e-07,
 -2.009206379974237e-08,  9.854906725001159e-10, -3.780431086837129e-11,  1.293000273786937e-12, -3.934228264724148e-14,  1.101082593649777e-15, -2.892435629048637e-17,
  7.046738023999446e-19, -1.641246362615269e-20,  3.636134272522619e-22, -7.633553911575587e-24,  7.549351210306657e-06, -3.139251782645998e-07,  1.256921335074071e-08,
 -3.945791762493070e-10,  1.131274415390776e-11, -2.886322788842903e-13,  6.835654835578942e-15, -1.559718842373102e-16,  3.210072611003856e-18, -6.529251758040235e-20,
  1.277018293910617e-21, -2.259422484334927e-23,  9.011702115240608e-05, -2.835422213378649e-06,  9.323852291871721e-08, -2.428776173736863e-09,  5.901774778043496e-11,
 -1.270955963738262e-12,  2.558321317174221e-14, -5.223045748434874e-16,  8.829907429134770e-18, -1.605145152877684e-19,  2.929341040167454e-21, -3.795164562977803e-23,
  6.370518126082215e-04, -1.548498529920008e-05,  4.142294580648828e-07, -9.018507475550534e-09,  1.862250419862997e-10, -3.384609997908224e-12,  5.765323166636766e-14,
 -1.095665317002768e-15,  1.407992978252566e-17, -2.382494315154879e-19,  4.689428286101538e-21, -2.021773041122331e-23,  2.737758493246146e-03, -5.262818912688810e-05,
  1.117470027479807e-06, -2.032237139451162e-08,  3.540940363430970e-10, -5.416774921567659e-12,  7.736751098075533e-14, -1.416146239773130e-15,  1.202029191114950e-17,
 -2.040242024305094e-19,  5.526350149412489e-21,  4.060072760091623e-23,  7.157925385853465e-03, -1.123326963663184e-04,  1.827699360467371e-06, -2.737022004399085e-08,
  3.920375484755911e-10, -5.074538479812159e-12,  6.151966157003534e-14, -9.819013153983917e-16,  6.050041324952737e-18, -9.688437834396402e-20,  3.469029500284781e-21,
  4.800679022386068e-23,  1.085481811720500e-02, -1.455595938787806e-04,  1.770571538645291e-06, -2.107494014437337e-08,  2.295567829109354e-10, -2.624802776660393e-12,
  3.136718196586545e-14, -7.070426417789938e-17,  6.480035353957021e-18, -3.835091697913401e-20, -2.051424355899822e-21, -6.826990579037088e-23,  7.525110300957283e-03,
 -9.174733052177651e-05,  8.735891479029446e-07, -8.102031076127240e-09,  5.621958529744736e-11, -6.546778693436162e-13,  1.143362517670730e-14,  2.996547897411888e-16,
  6.467256767938871e-18, -2.277694406471270e-20, -3.933014020084751e-21, -1.105142828859871e-22,  5.517502323667547e-16, -1.790244312987955e-16,  3.265310078554978e-17,
 -4.218371354755099e-18,  4.260114885370565e-19, -3.548858205019951e-20,  2.522956162957127e-21, -1.566904986631541e-22,  8.648131781142949e-24, -4.297686244482486e-25,
  1.943016770073203e-26, -8.048424911542973e-28,  2.676405671629547e-13, -4.263387763297112e-14,  4.484799475418610e-15, -3.568857758985544e-16,  2.358364242589035e-17,
 -1.345186634993430e-18,  6.806219644590059e-20, -3.109886720285119e-21,  1.299540281876728e-22, -5.015636970989563e-24,  1.801266867382308e-25, -6.050139646559535e-27,
  6.800147631856514e-11, -6.564147389070584e-12,  4.841233065943426e-13, -2.743192787107025e-14,  1.340296033783142e-15, -5.760558123987395e-17,  2.235810801119959e-18,
 -7.978109746081468e-20,  2.636779820519946e-21, -8.161521701535217e-23,  2.379298650713023e-24, -6.557224035298077e-26,  6.623762488791564e-09, -4.342770576593755e-10,
  2.477493844099122e-11, -1.081476784230084e-12,  4.208376781917439e-14, -1.452859652892682e-15,  4.564440959971225e-17, -1.344694720732547e-18,  3.669220698657088e-20,
 -9.481783771570572e-22,  2.335558381248947e-23, -5.421593458057112e-25,  2.898900926973828e-07, -1.372272365071283e-08,  6.339965237557001e-10, -2.221089747106643e-11,
  7.159856209089254e-13, -2.054649465576648e-14,  5.348403546598151e-16, -1.356608003449545e-17,  3.112758395722418e-19, -6.839120142248289e-21,  1.491518810884040e-22,
 -2.877688063447999e-24,  6.468600437317088e-06, -2.296216255891102e-07,  8.755054390328623e-09, -2.521434538233453e-10,  6.878830993719639e-12, -1.672370916563041e-13,
  3.613787514458176e-15, -8.262947530684624e-17,  1.586121199041184e-18, -2.915045661235352e-20,  6.298214117366097e-22, -8.767988165260216e-24,  8.010292294510496e-05,
 -2.191780139057917e-06,  6.901580754287304e-08, -1.658943557909219e-09,  3.869908704532794e-11, -8.051242097752990e-13,  1.419118840487054e-14, -3.122337787690227e-16,
  4.850863755639969e-18, -6.685537808922263e-20,  1.958565375383317e-21, -9.932165182686134e-24,  5.811194200229289e-04, -1.255808933075229e-05,  3.218681653521252e-07,
 -6.514868340104944e-09,  1.301187748134696e-10, -2.324817802634162e-12,  3.224607264456159e-14, -7.468612754042283e-16,  8.817099553637225e-18, -5.220052955926386e-20,
  4.948724294811440e-21,  2.426940682169095e-23,  2.543706621383374e-03, -4.457523120689116e-05,  9.043112149831391e-07, -1.543543436537381e-08,  2.613166669406846e-10,
 -3.997463151485745e-12,  4.232764476164315e-14, -1.101464118087672e-15,  9.293519727466355e-18,  7.496783309156790e-20,  8.856238782245592e-21,  9.571357867908497e-23,
  6.735898628199177e-03, -9.892547485750630e-05,  1.533778325148151e-06, -2.183830884569301e-08,  3.031877982386739e-10, -3.908254816832860e-12,  3.643177185683158e-14,
 -8.123082131642785e-16,  5.700661416163913e-18,  9.798180275066716e-20,  6.517263294873728e-21,  7.776439997675155e-23,  1.029939041318038e-02, -1.323479049159693e-04,
  1.538108959618869e-06, -1.778137196083054e-08,  1.845415978951261e-10, -1.874319947436772e-12,  3.193142799597047e-14,  9.192531636001744e-17,  2.758925040929357e-18,
 -1.953848194149998e-19, -6.090831082003970e-21, -1.043523179511113e-22,  7.171503068459028e-03, -8.513310554808241e-05,  7.813868243119355e-07, -7.289105687242567e-09,
  4.666256703494243e-11, -2.583075985257446e-13,  2.231914177544278e-14,  4.521384312227214e-16,  1.423200524803707e-18, -3.006830268125799e-19, -1.038707557091163e-20,
 -1.623873944516825e-22,  1.499968945053476e-16, -4.260094682765979e-17,  7.128473988298024e-18, -8.609197451580441e-19,  8.246312955628444e-20, -6.580466289284880e-21,
  4.515469617529801e-22, -2.722754367355121e-23,  1.465787584105310e-24, -7.131600936418542e-26,  3.166260150890146e-27, -1.291201679915340e-28,  1.486796708619758e-13,
 -1.905812629183624e-14,  1.801487612922678e-15, -1.289101220092650e-16,  7.828979989605828e-18, -4.142666547310297e-19,  1.959821973220701e-20, -8.439409968599636e-22,
  3.340694787762332e-23, -1.227876523952252e-24,  4.218611594584828e-26, -1.360387954585704e-27,  4.782523576070751e-11, -3.715129447484265e-12,  2.533059636125641e-13,
 -1.290583859007433e-14,  5.835996520397245e-16, -2.339312319929391e-17,  8.457338562304201e-19, -2.850848713266428e-20,  8.899135245081465e-22, -2.608485575371580e-23,
  7.271909490672793e-25, -1.907054389297415e-26,  5.214529392590376e-09, -2.784183910205435e-10,  1.504117233351897e-11, -5.918368547500361e-13,  2.150356850252700e-14,
 -7.026166255214191e-16,  2.035798464242781e-17, -5.744400900080497e-19,  1.489490637016951e-20, -3.579866444188805e-22,  8.681759039329192e-24, -1.884576015134791e-25,
  2.436938909237802e-07, -9.549393902061865e-09,  4.245890953381652e-10, -1.345658610115021e-11,  4.076337923926315e-13, -1.133462268744850e-14,  2.644118098118723e-16,
 -6.599200608544336e-18,  1.480873293896838e-19, -2.760562285000762e-21,  6.706674244641325e-23, -1.170556954339578e-24,  5.673372489101005e-06, -1.700401431912890e-07,
  6.292664011032754e-09, -1.648220029873542e-10,  4.240101065062536e-12, -1.033464256453293e-13,  1.883894721935338e-15, -4.443435982238368e-17,  9.150408771886676e-19,
 -9.844878435419477e-21,  3.637820595376207e-22, -4.928004310525238e-24,  7.232735746229953e-05, -1.709873937672288e-06,  5.234474494673086e-08, -1.152752933566886e-09,
  2.537746858940187e-11, -5.536065991280057e-13,  7.363700116895409e-15, -1.810945031364824e-16,  3.768671059369747e-18,  4.233758124670034e-21,  1.539664398506284e-21,
 -1.853383841181457e-23,  5.355874338464882e-04, -1.026375892083202e-05,  2.547649080735936e-07, -4.769434858485708e-09,  8.983013405732946e-11, -1.770296749899309e-12,
  1.528491435903505e-14, -4.547759057356110e-16,  1.069844203143718e-17,  1.576131934891859e-19,  4.905017720100778e-21, -6.751190880088116e-23,  2.378794309053739e-03,
 -3.801633116254123e-05,  7.416857940455605e-07, -1.184859046255022e-08,  1.892216792900222e-10, -3.312965366030736e-12,  1.658483979557044e-14, -6.857052101338144e-16,
  1.912939992828514e-17,  4.786717402512338e-19,  9.528038730487386e-21, -1.613427832764486e-22,  6.363186406486797e-03, -8.762668858125474e-05,  1.298378979243031e-06,
 -1.757241955055167e-08,  2.320513987926752e-10, -3.281013257877839e-12,  1.716227892441584e-14, -5.178998857852584e-16,  1.449299208178460e-17,  3.939506915195398e-19,
  6.712235348688846e-21, -1.447530502875763e-22,  9.793324606973656e-03, -1.208489174925799e-04,  1.341348921814973e-06, -1.508600577330282e-08,  1.549444226314885e-10,
 -1.075485449179053e-12,  3.430239594818618e-14,  1.297346784432220e-17, -9.535866502880933e-18, -4.996480566166285e-19, -7.545042854886987e-21,  1.210294698858651e-22,
  6.842936528266933e-03, -7.921937814081537e-05,  6.983325983148244e-07, -6.550491471438043e-09,  4.785116279527352e-11,  4.212402015236457e-13,  3.334768947356149e-14,
  2.328003601803534e-16, -1.817096849422980e-17, -8.019578809352339e-19, -1.192123531229422e-20,  2.295972516424861e-22,  5.030936728346140e-17, -1.162795843866367e-17,
  1.747068702159013e-18, -1.929824838872831e-19,  1.727454287084310e-20, -1.304457213896014e-21,  8.554210094806405e-23, -4.967799096657174e-24,  2.590993495595736e-25,
 -1.227284772009135e-26,  5.325760065060110e-28, -2.129626992851797e-29,  9.381917521228554e-14, -9.200660497527717e-15,  7.978465456143347e-16, -5.066212061744907e-17,
  2.818793485635764e-18, -1.382387427107987e-19,  6.072298001516694e-21, -2.459472788953664e-22,  9.191911613962467e-24, -3.199696001817422e-25,  1.050408929525592e-26,
 -3.237649502917612e-28,  3.622161562917610e-11, -2.178961019981255e-12,  1.419713844515254e-13, -6.431233974322763e-15,  2.676235619740269e-16, -1.015767911128076e-17,
  3.371925701758225e-19, -1.075202816726650e-20,  3.209445704842257e-22, -8.700369041452579e-24,  2.354437090926238e-25, -5.933188889263430e-27,  4.303572605853221e-09,
 -1.815673956490440e-10,  9.612837419147071e-12, -3.382830707416847e-13,  1.126973664289547e-14, -3.630369278445826e-16,  9.407040176719413e-18, -2.504203823299208e-19,
  6.668467991089773e-21, -1.339981259413177e-22,  3.292125703991966e-24, -8.007351850471853e-26,  2.114033409597488e-07, -6.702985767369152e-09,  2.957282294091403e-10,
 -8.457395072368598e-12,  2.318709688897891e-13, -6.746190416749275e-15,  1.341984322631309e-16, -3.023112414658610e-18,  8.604884164140906e-20, -9.652976826966272e-22,
  2.397591470905657e-23, -9.819926002871550e-25,  5.082806978962896e-06, -1.265999761337616e-07,  4.660578752723077e-09, -1.114259987939130e-10,  2.540569949573043e-12,
 -6.999264140523312e-14,  1.013686539966401e-15, -1.849872663574693e-17,  7.603145932257972e-19, -8.844783186934144e-22,  3.397629163652093e-23, -1.165660673999881e-23,
  6.624647328289934e-05, -1.340332089770474e-06,  4.060956178042836e-08, -8.271615212791668e-10,  1.573429955137445e-11, -4.235890989328220e-13,  4.075107668805689e-15,
 -4.875993680451148e-17,  4.675468516279025e-18,  3.111659857475962e-20, -7.775361772960296e-22, -9.654152246609750e-23,  4.982772473298905e-04, -8.432718488540827e-06,
  2.050415662055547e-07, -3.599023449656758e-09,  5.728752403748774e-11, -1.511219159839510e-12,  8.407930696011089e-15,  5.102645734749207e-18,  1.835240766683147e-17,
  1.982031361613267e-19, -5.755149493385790e-21, -4.522663768309424e-22,  2.237761630572214e-03, -3.260503063430781e-05,  6.155371354735402e-07, -9.334549344198309e-09,
  1.258204181166769e-10, -3.058176183355148e-12,  8.927301888567005e-15,  2.488625640276010e-16,  3.948098105581047e-17,  4.856778111748938e-19, -1.592819974576850e-20,
 -1.060405948114642e-21,  6.032200903130753e-03, -7.802487666592811e-05,  1.107683097926909e-06, -1.436598486772828e-08,  1.697071581159703e-10, -2.976262405645357e-12,
  1.153343599296620e-14,  2.018160643823908e-16,  3.036055428022651e-17,  3.518257444553997e-19, -1.398691096489634e-20, -8.300949256687824e-22,  9.330301689598565e-03,
 -1.108014563401885e-04,  1.174624934529178e-06, -1.273496915745200e-08,  1.414418045381961e-10, -3.005939080121497e-13,  2.738906892529997e-14, -6.164593874679383e-16,
 -2.989350653161134e-17, -4.911960920243677e-19,  1.394223077394055e-20,  9.181356474399875e-22,  6.536754081045144e-03, -7.393319769031363e-05,  6.247417018019482e-07,
 -5.673322799128871e-09,  6.434518030669422e-11,  1.204956650702729e-12,  2.693403588569297e-14, -8.640952726269338e-16, -5.025437970382797e-17, -7.419715993952601e-19,
  2.453284832302356e-20,  1.507966684522265e-21,  2.179427340551856e-17, -3.654858263248216e-18,  4.923210261133722e-19, -4.827095968127109e-20,  3.976498656384921e-21,
 -2.805059929525363e-22,  1.735942040662086e-23, -9.622271684496707e-25,  4.823208220162313e-26, -2.208029005361643e-27,  9.315024322643850e-29, -3.634275028376169e-30,
  6.679019542677864e-14, -4.651231608471907e-15,  3.897101607743310e-16, -2.161725241566738e-17,  1.088872917965140e-18, -5.021537157585499e-20,  2.020893518455422e-21,
 -7.652970497274288e-23,  2.732387457210079e-24, -8.848278376924933e-26,  2.767128475281164e-27, -8.312864109340299e-29,  2.937401810719938e-11, -1.292113095941325e-12,
  8.497228381600508e-14, -3.419422827674038e-15,  1.259815320345145e-16, -4.752475271081077e-18,  1.433037691239607e-19, -4.092922079073163e-21,  1.280325063568490e-22,
 -3.079237459639170e-24,  7.152201649181988e-26, -2.270829317273546e-27,  3.709086814383585e-09, -1.183192834663489e-10,  6.429887669090288e-12, -2.057860225036305e-13,
  5.807235307340853e-15, -2.010032388006914e-16,  4.801974612895445e-18, -9.506846096486729e-20,  3.456043956333607e-21, -6.346167484012253e-23,  4.061510860311210e-25,
 -5.405981543662526e-26,  1.887570901290943e-07, -4.689284698275551e-09,  2.125475097387250e-10, -5.675400894842718e-12,  1.237872200927751e-13, -4.257737925504484e-15,
  8.367751690698260e-17, -7.309087399328921e-19,  5.727666122493009e-20, -9.584600741928142e-22, -2.438204261470292e-23, -1.017359043231049e-24,  4.643353261324222e-06,
 -9.407123494645197e-08,  3.525084987079438e-09, -8.078100199597018e-11,  1.356075859642816e-12, -4.917835429286985e-14,  8.268261917341605e-16,  4.425812087473632e-18,
  6.071188654612140e-19, -1.194666827797906e-20, -5.980869245393544e-22, -1.210533285830660e-23,  6.147726892528924e-05, -1.051489984779185e-06,  3.193124587301344e-08,
 -6.380237301635792e-10,  8.220202206791464e-12, -3.246744422977214e-13,  4.875265647355670e-15,  1.031783280553855e-16,  4.032209041306882e-18, -1.016212449542443e-19,
 -5.817381624901920e-21, -8.196384719076419e-23,  4.675725786330850e-04, -6.951777386275729e-06,  1.663941414079097e-07, -2.911951226553736e-09,  2.945435084930722e-11,
 -1.237419313371812e-12,  1.727555110972457e-14,  6.179332839542882e-16,  1.583450097957199e-17, -4.921993379802013e-19, -2.796396146075353e-20, -3.036247393331174e-22,
  2.116522985559271e-03, -2.809911883399465e-05,  5.136336002716830e-07, -7.794007719042321e-09,  6.814628699016515e-11, -2.608261334946547e-12,  3.475029864178382e-14,
  1.567320974793951e-15,  3.287885867353768e-17, -1.195200439385373e-18, -6.510528787334668e-20, -5.629760214313133e-22,  5.736791858989535e-03, -6.981122709299418e-05,
  9.496777773244328e-07, -1.210783933446140e-08,  1.140045115138890e-10, -2.515931227409623e-12,  3.147181851616071e-14,  1.190341354975222e-15,  2.338488690708748e-17,
 -9.892186610980195e-19, -4.964388671765541e-20, -3.014489926493931e-22,  8.904975963507715e-03, -1.019775256747201e-04,  1.035279951991795e-06, -1.049224792412239e-08,
  1.399981291583375e-10,  3.119151732588913e-14, -4.644683700127596e-15, -1.659375479533449e-15, -2.647288835539089e-17,  9.859973228378938e-19,  5.773428026957695e-20,
  5.422919255020880e-22,  6.250613329146375e-03, -6.918807689949493e-05,  5.637171555518110e-07, -4.427602459990614e-09,  9.194072900903101e-11,  1.364915548976945e-12,
 -2.161428272955359e-14, -2.566738304594821e-15, -4.154532508910228e-17,  1.701508143874189e-18,  9.264378467092400e-20,  7.064112602242891e-22,  1.249011038040830e-17,
 -1.266358865269040e-18,  1.638905040749686e-19, -1.365217574616664e-20,  1.013564436597926e-21, -6.661230473705188e-23,  3.820280781613754e-24, -1.995760357831753e-25,
  9.584109184687881e-27, -4.192407466777215e-28,  1.702627777712122e-29, -6.488360561539440e-31,  5.311310136322594e-14, -2.337217872059206e-15,  2.085968368483619e-16,
 -1.017670428916682e-17,  4.368810311780482e-19, -1.987490570690050e-20,  7.418489331794357e-22, -2.432746955496031e-23,  8.814566711109900e-25, -2.770056717423701e-26,
  6.964674890914206e-28, -2.288087726822792e-29,  2.534542804991141e-11, -7.483735167988772e-13,  5.341316687993590e-14, -2.009034044317520e-15,  5.805818106041909e-17,
 -2.312394122200050e-18,  7.235232905964795e-20, -1.382001921435668e-21,  4.926489943616423e-23, -1.704584844915538e-24,  1.018229257684003e-26, -4.446585888591696e-28,
  3.324922059496189e-09, -7.544685882356399e-11,  4.403581364790069e-12, -1.394759745709267e-13,  2.779734452998836e-15, -1.073019323891397e-16,  3.344167127792150e-18,
 -2.172322548447904e-20,  1.024794877215749e-21, -7.848619802053462e-23, -5.520363440446964e-25,  2.883394492520253e-26,  1.730092497658317e-07, -3.233437659001111e-09,
  1.538585248789169e-10, -4.270648573813187e-12,  5.796230965961753e-14, -2.328254788324056e-15,  8.196749579467741e-17,  3.023955016821163e-19, -9.333081618617603e-22,
 -2.264466310465053e-21, -2.022089141742979e-23,  1.761191075545843e-24,  4.317761747847407e-06, -6.944659021981786e-08,  2.657126591955453e-09, -6.579936718238892e-11,
  5.899869149735797e-13, -2.623091034738828e-14,  1.121733441714057e-15,  1.186666311015685e-17, -2.926364160950949e-19, -3.588208800000233e-20, -2.385937067146607e-22,
  3.571578206301950e-23,  5.773628403519557e-05, -8.248757228868017e-07,  2.487359602047412e-08, -5.509063200012529e-10,  3.185652007572217e-12, -1.634867208379919e-13,
  8.685256324926262e-15,  1.271061120049674e-16, -3.822759721045976e-18, -3.055045791062158e-19, -1.170740962408480e-21,  3.409628271578884e-22,  4.422155215668926e-04,
 -5.754088427420126e-06,  1.335525581836860e-07, -2.609516091889496e-09,  1.045115450274714e-11, -5.821927111526931e-13,  3.744472761023171e-14,  6.258475488742965e-16,
 -2.100469061701227e-17, -1.387147201834864e-18, -1.899420884558126e-21,  1.650755158442397e-21,  2.011773713275009e-03, -2.434921631869679e-05,  4.251173300479322e-07,
 -7.059302449550969e-09,  2.825548446287765e-11, -1.186539417971862e-12,  8.333978697261523e-14,  1.444123448723690e-15, -5.288492986815618e-17, -3.132515007902495e-18,
  2.251789605633380e-21,  3.887371532137387e-21,  5.471860744703694e-03, -6.276746895912212e-05,  8.138339959071377e-07, -1.063297864099078e-08,  7.418684017511216e-11,
 -1.322435148094475e-12,  6.728722304593461e-14,  1.010777099676465e-15, -4.316924070062465e-17, -2.329532072040209e-18,  8.130423792992563e-21,  3.020750366870383e-21,
  8.512886599738098e-03, -9.416090988066989e-05,  9.227676935178194e-07, -8.270284035056489e-09,  1.354471802929219e-10, -6.846456344110601e-13, -5.444859711345836e-14,
 -1.501807090454567e-15,  4.756147453136315e-17,  2.759436049472271e-18,  8.296864084006375e-22, -3.403007192338544e-21,  5.982581650970859e-03, -6.486409413488621e-05,
  5.201506014996128e-07, -2.792510208457082e-09,  1.077873196622991e-10, -8.443524864088779e-14, -9.787776675990700e-14, -2.232359574862937e-15,  7.940775756331050e-17,
  4.368144770507266e-18, -7.145218720604068e-21, -5.542657192482216e-21,  9.296766534383744e-18, -4.111398838273097e-19,  6.553505733290667e-20, -4.529377848731724e-21,
  2.789896383242112e-22, -1.766771387539323e-23,  9.456586796655665e-25, -4.395250583620730e-26,  2.026481997171026e-27, -8.771479835240918e-29,  3.260910017646151e-30,
 -1.164468390065069e-31,  4.646303267134540e-14, -1.062971290452963e-15,  1.179157765828626e-16, -5.583708643804683e-18,  1.753863636209771e-19, -7.825339021030997e-21,
  3.351784539058555e-22, -8.148196772854736e-24,  2.207160351785190e-25, -1.171383313612725e-26,  2.728743935328564e-28,  2.459562598683714e-31,  2.307222350010153e-11,
 -4.046666103117823e-13,  3.362801193850660e-14, -1.366391658641868e-15,  2.672984095941791e-17, -9.162568752091860e-19,  4.703445438412475e-20, -7.077902704624129e-22,
 -3.584354802499494e-24, -1.057247330218449e-24,  3.478273019246156e-26,  1.154676651970011e-27,  3.083878757584446e-09, -4.629260875469487e-11,  2.939551525541173e-12,
 -1.079820405858371e-13,  1.394864697440096e-15, -3.329556298763496e-17,  2.765139097906177e-18, -3.374299158276646e-20, -1.572279783579540e-21, -4.221961577875072e-23,
  2.838111811784250e-24,  8.505787003695997e-26,  1.622311458398178e-07, -2.194628734672410e-09,  1.069902804722271e-10, -3.607050642678132e-12,  3.141329470129686e-14,
 -3.388190958550695e-16,  7.782241401918781e-17, -9.781863793119852e-19, -7.001412492515644e-20, -7.084385868908792e-22,  1.037883500687917e-22,  2.328522234401103e-24,
  4.077675149674560e-06, -5.121740794419344e-08,  1.911828248923075e-09, -5.901507099829638e-11,  3.510161781632344e-13,  2.451900515033274e-15,  1.137360984687491e-15,
 -1.616671835079110e-17, -1.271080432113886e-18, -4.211103185277447e-21,  1.799564713189122e-21,  2.990225002981003e-23,  5.479388375601076e-05, -6.516343256719057e-07,
  1.849975755197545e-08, -5.139336162343746e-10,  2.175589201886980e-12,  6.419581073554727e-14,  9.011822869066483e-15, -1.455981034523262e-16, -1.134205621055068e-17,
  7.592618877764810e-21,  1.590099505944840e-20,  1.974277690151015e-22,  4.211409588485999e-04, -4.808627675898204e-06,  1.030273435363208e-07, -2.482594137125908e-09,
  8.635820880772936e-12,  4.080853811512928e-13,  3.887470860259764e-14, -6.985254527164158e-16, -5.233342473332260e-17,  1.766300604492685e-19,  7.343263259797220e-20,
  6.853016248889235e-22,  1.920651641406084e-03, -2.128048632986304e-05,  3.427136556487027e-07, -6.679335272659602e-09,  2.640243112559015e-11,  1.013112425955236e-12,
  8.538730082196028e-14, -1.665561392354384e-15, -1.186014144785637e-16,  6.445254330683986e-19,  1.672404282543064e-19,  1.156267537900452e-21,  5.233030703001022e-03,
 -5.674840805440479e-05,  6.927891160002995e-07, -9.563938124834461e-09,  6.507423633713750e-11,  4.076129266434402e-13,  6.569971833127839e-14, -1.372197033362771e-15,
 -8.734777251770050e-17,  7.009650151370927e-19,  1.249829761836913e-19,  4.805437181769948e-22,  8.150428693322493e-03, -8.714045677885000e-05,  8.358161919846410e-07,
 -6.293761688987198e-09,  1.065339686226111e-10, -2.240038530331426e-12, -6.209858863513925e-14,  1.288634927668809e-15,  1.071428169439302e-16, -4.984208930777209e-19,
 -1.481353925683887e-19, -1.181195777100639e-21,  5.731275533331604e-03, -6.080864762386968e-05,  4.964770975589774e-07, -1.223401038540201e-09,  7.959714062056875e-11,
 -2.765935948597518e-12, -1.045725217070207e-13,  2.249111937219973e-15,  1.677205362231671e-16, -1.068356104537397e-18, -2.348743313325423e-19, -1.375557806972576e-21,
  8.436331830398472e-18, -4.887685218597860e-20,  2.940660789412830e-20, -1.975954925590734e-21,  8.103899597611701e-23, -4.623330952928663e-24,  2.838088530447496e-25,
 -1.167295059153204e-26,  3.884382326105020e-28, -1.828612998371275e-29,  8.611696415130912e-31, -2.311119234704005e-32,  4.372826372882501e-14, -3.493547073223919e-16,
  6.381268542036204e-17, -3.659952266298661e-18,  8.359565797737665e-20, -2.032581813893532e-21,  1.581319076703931e-22, -5.621669361258792e-24,  7.704541288571091e-27,
 -2.524334909980473e-29,  2.656659320554332e-28, -5.375301289525504e-30,  2.189664616074955e-11, -1.949886599275205e-13,  1.937158860628187e-14, -1.031292644547115e-15,
  1.791332767364763e-17, -6.169556774702880e-20,  2.227012421996776e-20, -1.087774970782790e-21, -8.488553680987649e-24,  8.260848157119831e-25,  3.866359180077504e-26,
 -1.497130936553150e-27,  2.938030444131235e-09, -2.760916031528863e-11,  1.766233372650198e-12, -8.781846310007490e-14,  1.284004570019279e-15,  1.555310019909904e-17,
  1.071836210906432e-18, -8.215606120222690e-20, -6.286670181303672e-22,  8.976683604033470e-23,  2.032789276902055e-24, -1.361074382214875e-25,  1.549024752442914e-07,
 -1.503221042637464e-09,  6.679000009253440e-11, -3.071030576338428e-12,  3.980162076210213e-14,  9.550200651269836e-16,  2.153701490720201e-17, -2.743446434939215e-18,
 -1.461213569177141e-20,  3.393189246532006e-21,  4.472235804834747e-23, -4.902300500662330e-24,  3.899060145799472e-06, -3.864775679178171e-08,  1.243154271974849e-09,
 -5.175664526024090e-11,  6.139124593511009e-13,  2.010323072447941e-14,  1.963402514071667e-16, -4.487698877573666e-17, -1.304056397744513e-19,  5.842228393780913e-20,
  4.509476492593278e-22, -8.263936743288730e-23,  5.244533208143469e-05, -5.275491240062727e-07,  1.261637874735318e-08, -4.591779402085767e-10,  5.097611364146570e-12,
  1.952745367001661e-13,  7.792405774882834e-16, -3.827188704218557e-16, -3.265315154400830e-19,  5.097303756320492e-19,  2.080243043117788e-21, -7.122079048963386e-22,
  4.033707016244898e-04, -4.100320831009554e-06,  7.447299941783241e-08, -2.238213658315091e-09,  2.366417272045256e-11,  9.431988763309104e-13,  7.982638391423697e-16,
 -1.729555838646578e-15,  1.389534189846198e-18,  2.326458986570820e-18,  3.429792137591116e-21, -3.223441957302760e-21,  1.840518434600852e-03, -1.885004810263800e-05,
  2.660652065613001e-07, -6.006301161484651e-09,  6.142054378578201e-11,  2.140473218464087e-12, -2.046683510121964e-15, -3.888933955517771e-15,  8.515344501247940e-18,
  5.243777634333644e-18, -2.924227355590012e-21, -7.219419444451234e-21,  5.016421239698241e-03, -5.164637366382482e-05,  5.847674717751143e-07, -8.389977612233859e-09,
  8.447019214685213e-11,  1.263723390621067e-12, -1.635358959176980e-15, -2.897867715647928e-15,  1.182743454257116e-17,  3.860030407720421e-18, -1.215908457207346e-20,
 -5.275906975154618e-21,  7.814797462343178e-03, -8.073089427952903e-05,  7.688266078563718e-07, -5.009975937558009e-09,  5.153612035349758e-11, -2.966866153665031e-12,
  1.137358974305376e-14,  3.353876294061078e-15, -4.342960521199239e-18, -4.683824216083514e-18, -1.342202312475819e-21,  6.448363560466952e-21,  5.495915682552637e-03,
 -5.687884673069304e-05,  4.872528856416337e-07, -4.975185159515959e-10,  7.034344500764227e-12, -4.011872352243034e-12,  1.545629805624526e-14,  5.335175015391237e-15,
 -1.425339233659768e-17, -7.345620493698905e-18,  1.070259659263546e-20,  1.006734485468034e-20,  8.585465116648632e-18,  1.084797575096440e-19,  1.136652505688869e-20,
 -1.140648808732819e-21,  3.561062770643052e-23, -7.447521138011922e-25,  6.906603468785766e-26, -4.888601550452793e-27,  1.381031016547376e-28, -7.592625165547582e-31,
  8.651990146994095e-32, -1.184336551912458e-32,  4.310308709937365e-14,  6.195434158578384e-18,  2.710106745410700e-17, -2.493858445294286e-18,  6.850377793976387e-20,
 -4.161640955571853e-23,  1.489602997577101e-23, -4.012253572675697e-24,  1.113976924026070e-25,  3.045484986606021e-27, -1.235257807908701e-28, -6.700375902668437e-30,
  2.135518779272305e-11, -8.460287158865136e-14,  8.740404176619757e-15, -7.359918881293326e-16,  1.954159410487432e-17,  1.108518516817282e-19, -6.316950195221541e-21,
 -7.475752111277886e-22,  2.873007328264905e-23,  6.714512079895885e-25, -4.209886918184539e-26, -9.526985419806722e-28,  2.849710232949234e-09, -1.731651533253868e-11,
  8.483230216065017e-13, -6.417003133399482e-14,  1.667908458948018e-15,  1.462405059042781e-17, -9.882018975325109e-19, -4.797445281758565e-20,  2.460647972455890e-21,
  4.151223336550068e-23, -3.699127708050284e-24, -4.147396025465632e-26,  1.497421036030445e-07, -1.103978748375488e-09,  3.440945838012240e-11, -2.278905496630088e-12,
  5.806433774176324e-14,  6.115475068921335e-16, -4.355098940742085e-17, -1.348056075120584e-18,  8.701590967102185e-20,  1.035374366370260e-21, -1.287786515365147e-22,
 -6.004179941777251e-25,  3.760701680202577e-06, -3.098970629264444e-08,  6.939739371170633e-10, -3.887251746239844e-11,  9.670075383509610e-13,  1.115593900084499e-14,
 -8.187098441633383e-16, -1.889892034907845e-17,  1.464079098877938e-18,  1.217636749158791e-20, -2.119541413621757e-21, -6.231474539459069e-25,  5.050443595621148e-05,
 -4.469861020124495e-07,  7.718243156636788e-09, -3.488099300782855e-10,  8.385244324918961e-12,  1.002498817731826e-13, -7.552497015321148e-15, -1.413953134326889e-16,
  1.266994157403787e-17,  7.240494107183229e-20, -1.796706199094596e-20,  5.083779740672786e-23,  3.880017724374431e-04, -3.604172063754472e-06,  5.046938898076384e-08,
 -1.723061542403300e-09,  3.913357157515242e-11,  4.580231035529053e-13, -3.573924165728628e-14, -5.730678678545234e-16,  5.769341610120328e-17,  2.181144788497356e-19,
 -8.037001781298985e-20,  4.148000789351181e-22,  1.768946446992850e-03, -1.699006048028680e-05,  2.011948442048954e-07, -4.718124873300923e-09,  9.576805585797367e-11,
  9.746451126918036e-13, -8.222284579111579e-14, -1.175310405010138e-15,  1.301062302312337e-16,  2.921990674911564e-19, -1.783941590586984e-19,  1.254012259548051e-21,
  4.818589180905407e-03, -4.734619837697655e-05,  4.929538647542034e-07, -6.863681623058670e-09,  1.034998314519448e-10,  4.082942085734548e-13, -5.961792394787842e-14,
 -7.841738902943118e-16,  9.629435419160763e-17,  2.434574981664320e-20, -1.288667580054709e-19,  1.222789895161375e-21,  7.503808502564819e-03, -7.481100500029324e-05,
  7.118266726115122e-07, -4.615513287330041e-09,  1.833690199598987e-12, -1.725879003505700e-12,  8.090429638377987e-14,  1.009003875720143e-15, -1.150587399460060e-16,
 -3.446330752284566e-19,  1.600620458053905e-19, -9.963326634399288e-22,  5.276153647632254e-03, -5.300852023353285e-05,  4.795054948519317e-07, -9.597888068715545e-10,
 -5.862077803329023e-11, -2.121254558230449e-12,  1.238780276878756e-13,  1.498856599758925e-15, -1.814091203407460e-16, -2.940469940111628e-19,  2.479703542906314e-19,
 -1.946652561441431e-21,  9.127239002253593e-18,  1.536045871392054e-19,  7.914836187825199e-22, -6.377813961729907e-22,  2.870085207454842e-23, -2.509861514359888e-25,
 -9.600931029408784e-27, -9.337964466384585e-28,  9.657445308817205e-29, -2.404698523641722e-30, -5.351989777030516e-32,  3.181091592766142e-33,  4.339814132493341e-14,
  1.218377955608900e-16,  3.701667132571692e-18, -1.415096763049958e-18,  6.450381747204843e-20, -5.711241058470507e-22, -3.977084193070656e-23,  6.614061021019912e-26,
  1.048144870426796e-25, -3.078945179489420e-27, -8.491348242423382e-29,  5.907771600608754e-30,  2.110831277550290e-11, -4.460407977578791e-14,  1.816405468025179e-15,
 -4.189113068925694e-16,  1.913341935327825e-17, -1.781606260291605e-19, -1.321715700066830e-20,  2.156992430951588e-22,  2.204886639967872e-23, -8.419636063617691e-25,
 -1.498536740123064e-26,  1.469100021835918e-27,  2.789797699707721e-09, -1.314415207019526e-11,  2.430351233102081e-13, -3.672134422969602e-14,  1.662516159104696e-15,
 -1.595445284106555e-17, -1.205432282713128e-18,  2.720182245191244e-20,  1.537851854634092e-21, -7.170866771636188e-23, -7.834503834170904e-25,  1.136775150976235e-25,
  1.457265508458897e-07, -9.217766982800486e-10,  1.283526523440349e-11, -1.315891008442182e-12,  5.843248868565068e-14, -5.716062468725453e-16, -4.337684990526470e-17,
  1.130017788267666e-18,  4.612186339762761e-20, -2.499398028664592e-21, -1.582240571761277e-23,  3.673141409209638e-24,  3.645276449541978e-06, -2.703125396030752e-08,
  3.239790480609384e-10, -2.276799896805075e-11,  9.778407895488630e-13, -9.688667010918150e-15, -7.321653318862956e-16,  2.069873515619646e-17,  6.820843089060006e-19,
 -4.147875858716798e-20, -1.304717516493237e-22,  5.749133574346827e-23,  4.881680991561767e-05, -3.996172211138822e-07,  4.370051624855400e-09, -2.089910508763943e-10,
  8.487222814664336e-12, -8.481517626325170e-14, -6.320827459566373e-15,  1.884126680250562e-16,  5.334297593542789e-18, -3.548507733415098e-19, -3.049126465621808e-22,
  4.699945659528355e-22,  3.742771902602676e-04, -3.272098304922913e-06,  3.369472856641375e-08, -1.072055213661755e-09,  3.945209563539342e-11, -3.962835576107694e-13,
 -2.860843582933218e-14,  8.859184867695792e-16,  2.241764055735153e-17, -1.600761088350352e-18,  1.336700299374210e-21,  2.045824573232837e-21,  1.703884567824865e-03,
 -1.558016005271472e-05,  1.540562123636881e-07, -3.140153342704750e-09,  9.517272717586046e-11, -9.569888146271358e-13, -6.367796691310429e-14,  2.039465890881372e-15,
  4.729067011328665e-17, -3.580621059558453e-18,  7.800564376997344e-21,  4.442238262094832e-21,  4.636609919341978e-03, -4.370376926060474e-05,  4.205373821076367e-07,
 -5.221603971245018e-09,  9.726682714778202e-11, -9.679254273301945e-13, -4.425743417738572e-14,  1.524791788442996e-15,  3.202843449592793e-17, -2.616510428738497e-18,
  1.026160403118433e-20,  3.116366064812449e-21,  7.215601062005139e-03, -6.933935739415716e-05,  6.558279233136129e-07, -4.754443865781770e-09, -1.303137102086472e-11,
  1.666474433159195e-13,  6.334658385041917e-14, -1.860895827100748e-15, -4.278679401438095e-17,  3.194748939894680e-18, -5.070810196801843e-21, -4.022391088347171e-21,
  5.071693302344352e-03, -4.923664142864337e-05,  4.614952151705697e-07, -2.072631881347181e-09, -7.112365784973259e-11,  7.498800978964073e-13,  9.460116445958301e-14,
 -2.936053261001236e-15, -6.371120584174440e-17,  4.989607436328238e-18, -1.375727724509619e-20, -6.114446535306212e-21,  9.716237455130546e-18,  1.366442811186593e-19,
 -4.324400108752827e-21, -2.349632716184453e-22,  2.069431705188733e-23, -5.333575046385086e-25, -6.727106458317984e-27,  6.516336442720047e-28,  6.785187514822061e-30,
 -1.785508092840849e-30,  6.060817217004957e-32,  4.673234045266349e-34,  4.386040326402502e-14,  9.989230702256890e-17, -7.617067549440520e-18, -5.202722630110902e-19,
  4.516466939901181e-20, -1.238078671153479e-21, -9.489827486906355e-24,  1.465555596714604e-24, -1.103366184952777e-26, -2.192358350873100e-27,  8.567503750717501e-29,
  5.360584031181319e-31,  2.093398866743238e-11, -4.534435417791155e-14, -1.538893888561363e-15, -1.554056145740097e-16,  1.317481874746294e-17, -3.724337668041823e-19,
 -2.020460415227304e-21,  4.312968734470887e-22, -6.106617303886643e-24, -4.727957324500235e-25,  2.195246971084843e-26,  2.029284600453635e-29,  2.738914325523976e-09,
 -1.254317019131740e-11, -5.276034875817490e-14, -1.391759690327423e-14,  1.134350360578485e-15, -3.257061163541596e-17, -1.368640413471914e-19,  3.724733644806984e-20,
 -6.593622799702981e-22, -3.324325951465890e-23,  1.773928292822729e-24, -5.342574543390538e-27,  1.421657055639453e-07, -8.675381196716071e-10,  2.127920334836652e-12,
 -5.162857064208626e-13,  3.966821309646431e-14, -1.146924671131961e-15, -3.928842352951239e-18,  1.299693730826917e-18, -2.586811977793802e-20, -9.995696804586172e-22,
  5.954844849617867e-23, -3.466019282346576e-25,  3.540954328685394e-06, -2.528614409401826e-08,  1.357561711811674e-10, -9.403224634208261e-12,  6.623942340134844e-13,
 -1.915136867101743e-14, -5.509773786898041e-17,  2.152004553873470e-17, -4.603188270827887e-19, -1.478672293716661e-20,  9.617029312054589e-22, -7.567039071827222e-24,
  4.727541214585925e-05, -3.725525171443353e-07,  2.599673119078416e-09, -9.301269477812348e-11,  5.753280012597518e-12, -1.649721760706921e-13, -4.033594535897900e-16,
  1.835143868272871e-16, -4.119897001822093e-18, -1.155521846175601e-19,  8.063308421467341e-21, -7.575592483561986e-23,  3.616605420863857e-04, -3.044067358916872e-06,
  2.426020879235771e-08, -5.322888953280328e-10,  2.687581237705148e-11, -7.534447615437828e-13, -1.537045111187407e-15,  8.248269301543937e-16, -1.916965652146073e-17,
 -4.849545171634456e-19,  3.582262691241084e-20, -3.782662460238896e-22,  1.643824250794759e-03, -1.447444100436613e-05,  1.246676575836292e-07, -1.832492437064731e-09,
  6.578734717084119e-11, -1.738240571967294e-12, -2.593742895380222e-15,  1.835658417890790e-15, -4.385927626717801e-17, -1.020874277745078e-18,  7.914220410698183e-20,
 -9.104000291984697e-22,  4.468161630591634e-03, -4.056541994728694e-05,  3.664323621769256e-07, -3.862357686918596e-09,  7.100187382849469e-11, -1.480836796342633e-12,
  3.905122958517413e-16,  1.317699075298529e-15, -3.281812036732256e-17, -6.864476708651160e-19,  5.687142973116020e-20, -7.255038774653275e-22,  6.948371432015136e-03,
 -6.432379660293988e-05,  5.978488742620636e-07, -4.872888039909842e-09,  9.073925993055439e-13,  1.004844210709927e-12,  7.497907469574933e-15, -1.688895474625988e-15,
  3.923488287623069e-17,  9.331775825782363e-19, -7.107925229956609e-20,  7.886902038981813e-22,  4.881948159893726e-03, -4.566171896929688e-05,  4.306083244348762e-07,
 -2.997364444394160e-09, -4.061572434800642e-11,  1.955033627463088e-12,  7.711461364840007e-15, -2.596811313227265e-15,  6.214872459015732e-17,  1.381921832631834e-18,
 -1.097647353623414e-19,  1.308431527767332e-21,  1.018261012579282e-17,  9.556245382762622e-20, -5.521052343012534e-21,  8.084371079989594e-24,  9.825758474942509e-24,
 -4.942428324475056e-25,  8.139688211646052e-27,  2.848398903361722e-28, -1.803730687363722e-29,  1.361152615056802e-31,  2.390016569128609e-32, -1.189968971699422e-33,
  4.411339758030950e-14,  2.436902477829708e-17, -1.034692301851752e-17,  4.425000100008219e-21,  2.101849755601265e-20, -1.063148674159634e-21,  1.927787095772205e-23,
  4.705255871233036e-25, -3.504159760574994e-26,  4.616151847606881e-28,  3.133777239682275e-29, -1.712816231784546e-30,  2.072049165408977e-11, -6.209639249756232e-14,
 -2.383380261187190e-15, -3.268033380863578e-18,  6.059667913316677e-18, -3.080834793809891e-19,  5.884467006103643e-21,  1.161884038503206e-22, -9.760285531915532e-24,
  1.604309018681337e-25,  6.706925661560431e-27, -4.179216361876278e-28,  2.687210498146190e-09, -1.337387011360590e-11, -1.321046747890069e-13, -8.556823892529684e-16,
  5.192230758636239e-16, -2.637775017426606e-17,  5.191033455667752e-19,  8.946859191045718e-21, -8.182677185237294e-22,  1.511319058721234e-23,  4.626764302988547e-25,
 -3.244445005439436e-26,  1.387033198996400e-07, -8.662297485302398e-10, -1.003793243371765e-12, -5.981084323003299e-14,  1.816517980502887e-14, -9.163766816422746e-16,
  1.837186832980343e-17,  2.879243989739611e-19, -2.803014472269323e-20,  5.560078722856125e-22,  1.362094302084885e-23, -1.056878104563698e-24,  3.441483676472463e-06,
 -2.449997409928928e-08,  7.411350458624165e-11, -1.769957715606650e-12,  3.051424114894780e-13, -1.516126848860795e-14,  3.074945810215058e-16,  4.490074944867542e-18,
 -4.584056006208258e-19,  9.536773761177923e-21,  1.973954747034085e-22, -1.668703539429506e-23,  4.582161138500291e-05, -3.549015484460247e-07,  1.929311750559983e-09,
 -2.643196985948771e-11,  2.687262109343907e-12, -1.297561498601520e-13,  2.647720246236681e-15,  3.656334924877655e-17, -3.875589300570501e-18,  8.338441259066041e-20,
  1.513545781207763e-21, -1.375216891528739e-22,  3.498408170242857e-04, -2.869350117323542e-06,  1.996723565101051e-08, -2.183445463960492e-10,  1.291436269978409e-11,
 -5.899222836141207e-13,  1.203598037074003e-14,  1.582888276995891e-16, -1.731609710852196e-17,  3.818976641407887e-19,  6.244159597869196e-21, -6.028598668232151e-22,
  1.587803742025925e-03, -1.354975505994742e-05,  1.078754643282068e-07, -1.047014552517686e-09,  3.367059585142930e-11, -1.357116766648385e-12,  2.733953924680803e-14,
  3.397713033115742e-16, -3.840101543967772e-17,  8.638720240966862e-19,  1.293545110223580e-20, -1.317341692360114e-21,  4.311493695631080e-03, -3.780223625082536e-05,
  3.259533266830810e-07, -2.952496978378604e-09,  4.380787433378262e-11, -1.156574467430165e-12,  2.150893801850208e-14,  2.243218734531012e-16, -2.763249381862700e-17,
  6.390188161337653e-19,  8.479553544602042e-21, -9.326412715340101e-22,  6.700273846260729e-03, -5.977313515552535e-05,  5.401189216835466e-07, -4.701120125749268e-09,
  1.977436279789187e-11,  7.729997124646361e-13, -2.050444226604001e-14, -3.425993527235174e-16,  3.474612424480179e-17, -7.710419850366418e-19, -1.193418282854679e-20,
  1.189155467579449e-21,  4.705951492573742e-03, -4.236884146291649e-05,  3.920066610611923e-07, -3.344712887661217e-09, -4.295642462927615e-12,  1.511795681493334e-12,
 -3.480549749458937e-14, -4.969042750606789e-16,  5.363808901577306e-17, -1.213195866581872e-18, -1.739717639754356e-20,  1.818517091718024e-21,  1.048001816174780e-17,
  5.378144795175013e-20, -4.767778056951771e-21,  9.847470262241415e-23,  2.239315595048735e-24, -2.595114519143400e-25,  9.576295517732574e-27, -1.147154994103101e-28,
 -5.889555767048916e-30,  3.427476399041185e-31, -5.889908489895644e-33, -1.878516653322118e-34,  4.405182261156124e-14, -5.391574076376754e-17, -8.888993301752183e-18,
  1.982107262103854e-19,  4.880660856545981e-21, -5.483042056344317e-22,  2.024069034820310e-23, -2.660694403014385e-25, -1.024250460583847e-26,  6.327243219071062e-28,
 -1.166207055977248e-29, -2.611106454213407e-31,  2.043549989031861e-11, -8.008731590826915e-14, -2.017680070264820e-15,  5.261800891304384e-17,  1.418238596562329e-18,
 -1.566971580550495e-19,  5.825369209073255e-21, -8.150546380269753e-23, -2.597613885827316e-24,  1.711067108110853e-25, -3.398951190378351e-27, -5.353904078153141e-29,
  2.631688658906827e-09, -1.436601640131894e-11, -1.076238346502875e-13,  3.947506190819032e-15,  1.236562673174046e-16, -1.330101001422336e-17,  4.967122352249442e-19,
 -7.220756419839817e-21, -2.035004748997853e-22,  1.408184080195989e-23, -2.946340505394341e-25, -3.456792790742598e-27,  1.352231384862810e-07, -8.734202373014637e-10,
 -5.012106347223258e-13,  1.093443125840680e-13,  4.461966791766314e-15, -4.597305624919830e-16,  1.719736744372239e-17, -2.563630428684983e-19, -6.631235253474815e-21,
  4.763983252769087e-22, -1.033631236419431e-23, -9.438829097614730e-26,  3.344625284680504e-06, -2.392935916112824e-08,  7.351458660055963e-11,  1.104766356350015e-12,
  7.877851715085980e-14, -7.588688251152558e-15,  2.834749876710891e-16, -4.299276002086678e-18, -1.044261670543150e-19,  7.722543974721786e-21, -1.720077994952150e-22,
 -1.263836997978275e-24,  4.443166652418167e-05, -3.401788170624432e-07,  1.796076280568025e-09, -6.105704673627352e-13,  7.505737796413290e-13, -6.499466741096305e-14,
  2.413698952778163e-15, -3.704422439557303e-17, -8.574558510677498e-19,  6.487185698634414e-20, -1.473320639224149e-21, -8.945816094664770e-24,  3.386702078687807e-04,
 -2.717371278019414e-06,  1.825014917214974e-08, -8.985617960392730e-11,  4.096602724542136e-12, -2.971370172668903e-13,  1.087626300775133e-14, -1.681814238944305e-16,
 -3.742960232095484e-18,  2.884771278989022e-19, -6.649558621401107e-21, -3.410090890929951e-23,  1.535261666787588e-03, -1.272967359335398e-05,  9.776711359706924e-08,
 -6.886526222902671e-10,  1.326997195483506e-11, -6.956969231860790e-13,  2.450435409190556e-14, -3.797285741627809e-16, -8.131404939675186e-18,  6.375197879913362e-19,
 -1.487427459782696e-20, -6.517549556712595e-23,  4.165290353459058e-03, -3.532598524005573e-05,  2.940585557728973e-07, -2.407955659161989e-09,  2.592420699551263e-11,
 -6.429582084049396e-13,  1.896103811786781e-14, -2.883304025339590e-16, -5.642358529952679e-18,  4.575714602446487e-19, -1.085629575838618e-20, -3.713017685197859e-23,
  6.469474836667689e-03, -5.567146587958263e-05,  4.860231688184653e-07, -4.289132755215386e-09,  3.007172509976212e-11,  2.645959582924625e-13, -1.887922227158202e-14,
  3.127444480447103e-16,  7.576884883499821e-18, -5.746372747581821e-19,  1.331001369746919e-20,  6.238269411491249e-23,  4.542495029834890e-03, -3.939251093053895e-05,
  3.523027934860225e-07, -3.218720846943109e-09,  1.728421494267386e-11,  6.615266698469850e-13, -3.147887346428565e-14,  5.077676776709609e-16,  1.139942458903032e-17,
 -8.862195254583149e-19,  2.076208041957388e-20,  8.402302443700051e-23,  1.062677768405421e-17,  2.065525101839331e-20, -3.505558150533229e-21,  1.039223483636979e-22,
 -9.811053913699503e-25, -7.995542330961586e-26,  5.212458835176646e-27, -1.576465114637505e-28,  1.626157512734432e-30,  8.463487944777892e-32, -4.916100268484759e-33,
  1.135988064307058e-34,  4.370997357259107e-14, -1.148624249479956e-16, -6.326310607062775e-18,  2.120026760777754e-19, -1.945860135401771e-21, -1.714026019910321e-22,
  1.092969132953494e-23, -3.270589668281329e-25,  3.516530981904606e-27,  1.543801650403225e-28, -9.005253559635471e-30,  2.029604596833988e-31,  2.008715421324514e-11,
 -9.351047313536932e-14, -1.331314117213436e-15,  5.695288962850049e-17, -5.304411449170132e-19, -4.895847564621521e-20,  3.109728821597778e-21, -9.338329239493883e-23,
  1.058609482902494e-24,  3.984554725680940e-26, -2.404169711734073e-27,  5.522294430255594e-29,  2.572828293462283e-09, -1.502027838751522e-11, -5.527157416538772e-14,
  4.368754941032954e-15, -4.164935328436892e-17, -4.156987986475524e-18,  2.629925600494478e-19, -7.926795031063501e-21,  9.319613192382034e-23,  3.150490939096271e-24,
 -1.958996876990687e-25,  4.588977077910327e-27,  1.317307078246741e-07, -8.715340857204514e-10,  1.001167841041632e-12,  1.269067619362629e-13, -1.253930314521437e-15,
 -1.441509649610216e-16,  9.053926565430844e-18, -2.735950558173519e-19,  3.299197001908969e-21,  1.032546489691838e-22, -6.578500650395700e-24,  1.565965867920708e-25,
  3.250185843228653e-06, -2.327613993548995e-08,  9.040142840227869e-11,  1.475781243746333e-12, -1.574737518465910e-14, -2.398158597884231e-15,  1.486783148138270e-16,
 -4.498208306274205e-18,  5.523475255001027e-20,  1.632530532416936e-21, -1.060475604466782e-22,  2.556522908017604e-24,  4.309982349671056e-05, -3.257155948394626e-07,
  1.827057850339355e-09,  3.762118210947078e-12, -6.239555519476567e-14, -2.086021315604130e-14,  1.263280213883955e-15, -3.819738578948223e-17,  4.752718564316499e-19,
  1.344580145617821e-20, -8.870769132266028e-22,  2.159824208491328e-23,  3.280869793445167e-04, -2.574936975967178e-06,  1.741025073451534e-08, -5.940948413155791e-11,
  3.468522435970722e-13, -9.837178588518002e-14,  5.692053146243319e-15, -1.714652408128747e-16,  2.153988179430191e-18,  5.885077580368685e-20, -3.931969570601233e-21,
  9.648843531377534e-23,  1.485858848156299e-03, -1.197785171188231e-05,  9.041090662038834e-08, -5.596033955364043e-10,  4.299065835840738e-12, -2.474265703445716e-13,
  1.287888536226725e-14, -3.832306319825625e-16,  4.845534144069798e-18,  1.282748136129193e-19, -8.667376851077825e-21,  2.140958807133352e-22,  4.028517195818637e-03,
 -3.308287847038588e-05,  2.672995335946849e-07, -2.074262625415106e-09,  1.691014067827091e-11, -2.928935198307816e-13,  1.025569641756022e-14, -2.854136914140210e-16,
  3.612882867440455e-18,  9.005688359438205e-20, -6.204038113880352e-21,  1.546667820532166e-22,  6.254251265613387e-03, -5.198072110776892e-05,  4.375442089131750e-07,
 -3.787006948460446e-09,  3.161569939957988e-11, -7.151083147984076e-14, -9.120195927286446e-15,  3.233256299278308e-16, -4.160379709591274e-18, -1.172680596634659e-19,
  7.806810245116126e-21, -1.921094692652207e-22,  4.390324866430789e-03, -3.672312117449270e-05,  3.156553510652732e-07, -2.872123735282558e-09,  2.422002203126250e-11,
  9.402553395089182e-14, -1.583567894597363e-14,  5.159657539248921e-16, -6.623418009102045e-18, -1.781003735473665e-19,  1.202132741724484e-20, -2.976634556930890e-22,
  1.066071803999326e-17, -2.752106098066371e-21, -2.387219903604418e-21,  8.085845147513448e-23, -1.648608928475062e-24, -2.515911901174398e-28,  1.768976324126981e-27,
 -8.549970086813118e-29,  2.255154155809085e-30, -2.296388204136290e-32, -9.228141500841763e-34,  5.584818398826554e-35,  4.316442349610658e-14, -1.560083568398679e-16,
 -4.043895846884973e-18,  1.648567137243359e-19, -3.412735598038555e-21, -3.194946353093244e-24,  3.785121213304646e-24, -1.784434865768086e-25,  4.602705923170441e-27,
 -4.570286121644673e-29, -1.782682890814458e-30,  1.039282685165818e-31,  1.969586609933449e-11, -1.016236910497407e-13, -7.202165689721597e-16,  4.387879008231327e-17,
 -9.517096509867867e-19, -1.098261821945892e-21,  1.078956744380273e-21, -5.062111245154122e-23,  1.303588929861361e-24, -1.330522552059762e-26, -4.690682435937091e-28,
  2.770828524702423e-29,  2.512172919104131e-09, -1.526851669946042e-11, -8.667180625360146e-15,  3.311675743028831e-15, -7.762901483369432e-17, -1.114589523284820e-19,
  9.123829746815583e-20, -4.271739090532650e-21,  1.101305348458527e-22, -1.152231638753316e-24, -3.744243023370538e-26,  2.250285909346952e-27,  1.282695467109394e-07,
 -8.579286462638565e-10,  2.340240610332404e-12,  9.322476124885516e-14, -2.513870346025210e-15, -4.917236419265275e-18,  3.141863554571992e-18, -1.467732644237098e-19,
  3.789135008339270e-21, -4.040468278719733e-23, -1.234015213357842e-24,  7.532805929556466e-26,  3.158630359588915e-06, -2.248895625122005e-08,  1.055369472403140e-10,
  9.952143853942317e-13, -3.705682006983652e-14, -1.113332644941734e-16,  5.167197511471239e-17, -2.405033385205473e-18,  6.214979783584276e-20, -6.723348893068542e-22,
 -1.958170011343885e-23,  1.211073800307140e-24,  4.182642564594324e-05, -3.109581932461868e-07,  1.856870804692615e-09,  7.444265646362672e-13, -2.530145741238732e-13,
 -1.411174001963970e-15,  4.407223489425863e-16, -2.037513778315646e-17,  5.266781627419971e-19, -5.760246922137062e-21, -1.616905513000190e-22,  1.010850284223698e-23,
  3.180612679963987e-04, -2.438521059780022e-06,  1.668566594249815e-08, -6.365314147139678e-11, -5.981345940042755e-13, -1.051919263126633e-14,  2.003115087943014e-15,
 -9.134647754061306e-17,  2.358956248335757e-18, -2.601535861279442e-20, -7.090969665280079e-22,  4.472769966545865e-23,  1.439352757986760e-03, -1.128053975971128e-05,
  8.399034373800475e-08, -5.169110401571705e-10,  1.673644734585529e-12, -4.727204862305988e-14,  4.636071197249157e-15, -2.042708237834980e-16,  5.252664592069756e-18,
 -5.829820623402666e-20, -1.548562706514889e-21,  9.845340056736551e-23,  3.900310831291440e-03, -3.103981800777802e-05,  2.438749620829892e-07, -1.839647966745682e-09,
  1.294131947450565e-11, -1.279980319498033e-13,  4.100402114447011e-15, -1.536339388632122e-16,  3.848810173684572e-18, -4.296217513202753e-20, -1.092523934372768e-21,
  7.035307892999339e-23,  6.053053192973842e-03, -4.865371619746707e-05,  3.950571983969206e-07, -3.301714726288813e-09,  2.864222869358507e-11, -1.989348637181176e-13,
 -2.225417028033548e-15,  1.677095130858677e-16, -4.584680388402282e-18,  5.110877967879916e-20,  1.406204362150270e-21, -8.867050119061046e-23,  4.248273933307067e-03,
 -3.432912124087976e-05,  2.835224303745040e-07, -2.485776014436146e-09,  2.333140450951326e-11, -1.398211108540111e-13, -4.796599311048025e-15,  2.707246468010307e-16,
 -7.198102046815224e-18,  8.047456823683315e-20,  2.143887382634730e-21, -1.364000447062438e-22,  1.909305265866385e+00,  6.398613558036152e-02, -2.554905148159994e-02,
  9.389063487210712e-03, -3.367631295994953e-03,  1.212820435371784e-03, -4.445064189340729e-04,  1.659345884501473e-04, -6.235258264090869e-05,  2.303794506609052e-05,
 -8.074234963825705e-06,  2.436959357864649e-06,  1.941503727391081e+00,  4.090612326911720e-02, -1.584285161708562e-02,  5.644837766425837e-03, -1.972928793554608e-03,
  6.976945308589171e-04, -2.531516439938590e-04,  9.417025008608522e-05, -3.538082534535734e-05,  1.306872347911103e-05, -4.565459588180265e-06,  1.368814991843384e-06,
  1.960020998811585e+00,  2.787044534539820e-02, -1.066947976838648e-02,  3.749790238510421e-03, -1.296460050421205e-03,  4.555829570368437e-04, -1.649839727360260e-04,
  6.143646304622694e-05, -2.313094557549831e-05,  8.556972577934171e-06, -2.989096068164358e-06,  8.946555139151199e-07,  1.972502927317008e+00,  1.917983262027582e-02,
 -7.342982147566257e-03,  2.567351612349341e-03, -8.836822040085515e-04,  3.098851986437882e-04, -1.122508591136510e-04,  4.186908758313850e-05, -1.579367664905266e-05,
  5.850097542513541e-06, -2.043983251084695e-06,  6.113104583644854e-07,  1.981532580504473e+00,  1.294077294112484e-02, -5.014890092081901e-03,  1.756266454966347e-03,
 -6.044111619774824e-04,  2.120370067538997e-04, -7.690878874581197e-05,  2.873776481683536e-05, -1.085776788786655e-05,  4.025844355329898e-06, -1.406928021508842e-06,
  4.206011348288469e-07,  1.988305963890193e+00,  8.286894751890704e-03, -3.310826656825212e-03,  1.171028458505983e-03, -4.047472737755755e-04,  1.423821354048272e-04,
 -5.176340258787402e-05,  1.938021234004226e-05, -7.333085500098664e-06,  2.721290711414209e-06, -9.512395099131838e-07,  2.842995558760280e-07,  1.993471677550543e+00,
  4.752642271724773e-03, -2.035228891483609e-03,  7.375416955384742e-04, -2.578023746725558e-04,  9.125537874472300e-05, -3.330539587475064e-05,  1.250130387567934e-05,
 -4.737777306481553e-06,  1.759674980265995e-06, -6.152667196971654e-07,  1.838605854143043e-07,  1.997416044883860e+00,  2.062723664071624e-03, -1.075050537771056e-03,
  4.138099648172860e-04, -1.485654274279751e-04,  5.331316953477672e-05, -1.960330537516662e-05,  7.388590792834773e-06, -2.806387640542387e-06,  1.043477620818042e-06,
 -3.649970116274059e-07,  1.090705487796669e-07,  2.000382651705847e+00,  4.456331373591241e-05, -3.607083287544537e-04,  1.743789521951185e-04, -6.804072998760581e-05,
  2.537487622960207e-05, -9.510416126625297e-06,  3.618917607261768e-06, -1.380985081956036e-06,  5.145965098909238e-07, -1.801609308403852e-07,  5.384929268105591e-08,
  2.002529563555860e+00, -1.413314434335869e-03,  1.520961431882353e-04,  3.237120662448716e-06, -1.061774365185876e-05,  5.466193118211540e-06, -2.315959305635193e-06,
  9.298038861662361e-07, -3.634532745701421e-07,  1.368905103337478e-07, -4.814692168809630e-08,  1.441652237072909e-08,  2.003959194286765e+00, -2.382884259305661e-03,
  4.916448767972452e-04, -1.097453619042517e-04,  2.723085061329898e-05, -7.650006335465502e-06,  2.425089551670540e-06, -8.432234389861568e-07,  3.077681993131402e-07,
 -1.123384030778325e-07,  3.896741521326558e-08, -1.160130027931920e-08,  2.004734869840771e+00, -2.908532435566792e-03,  6.752309501143760e-04, -1.707208311603963e-04,
  4.763773524378590e-05, -1.472003352017304e-05,  4.981090651055552e-06, -1.799415504357507e-06,  6.698653939697075e-07, -2.468112445709213e-07,  8.597205805646810e-08,
 -2.563874855887471e-08,  1.990126807736591e+00,  6.570716246571806e-03, -2.094567893180903e-03,  5.804020287617749e-04, -1.498081739821510e-04,  3.706897656625600e-05,
 -8.924272210618038e-06,  2.108453657602076e-06, -4.915404719618952e-07,  1.134791914028959e-07, -2.595318429638191e-08,  5.630407238145741e-09,  1.993347357382619e+00,
  4.440809923355997e-03, -1.426914796170580e-03,  3.929466147914879e-04, -1.002977801750767e-04,  2.448929604132070e-05, -5.811858792233069e-06,  1.353048641785648e-06,
 -3.108185358699920e-07,  7.072397357233184e-08, -1.595051592907435e-08,  3.418040035397441e-09,  1.995502514212252e+00,  3.025427476438742e-03, -9.955729767524742e-04,
  2.751688367875663e-04, -7.002794633762607e-05,  1.700015063908512e-05, -4.006187639047747e-06,  9.256298595839120e-07, -2.110039902418904e-07,  4.765186359576643e-08,
 -1.067053320483873e-08,  2.272523967717720e-09,  1.997100742259625e+00,  1.980931513994256e-03, -6.835881067757573e-04,  1.916340053632527e-04, -4.896079270046028e-05,
  1.188148469070207e-05, -2.793207323965771e-06,  6.431798705065954e-07, -1.460574681846282e-07,  3.285582188336926e-08, -7.329626159719346e-09,  1.555935972463541e-09,
  1.998337891296218e+00,  1.175405914834516e-03, -4.466582088837581e-04,  1.291314694327558e-04, -3.341984821068159e-05,  8.155863198105412e-06, -1.921410183865647e-06,
  4.425532469866293e-07, -1.004256595922582e-07,  2.256345903049484e-08, -5.026502094941498e-09,  1.065633393320806e-09,  1.999314031102522e+00,  5.416679964953219e-04,
 -2.625087278650101e-04,  8.111479570820086e-05, -2.161137176171859e-05,  5.354038515113369e-06, -1.272023117621298e-06,  2.944191149343597e-07, -6.700197228363018e-08,
  1.507881394106231e-08, -3.362282486682467e-09,  7.131740809492575e-10,  2.000087856911700e+00,  4.043059295930889e-05, -1.182668164430219e-04,  4.384939216682314e-05,
 -1.252584072900065e-05,  3.215531120310429e-06, -7.800171599785779e-07,  1.829354739502747e-07, -4.199865557946768e-08,  9.509483812961496e-09, -2.129628087648717e-09,
  4.530723143533721e-10,  2.000696620967072e+00, -3.531741726619247e-04, -5.869589346696174e-06,  1.502245525150927e-05, -5.545309976420686e-06,  1.582750317977359e-06,
 -4.065005403566713e-07,  9.873343297374477e-08, -2.319971534987182e-08,  5.338719304009823e-09, -1.209629463268540e-09,  2.594571160837347e-10,  2.001165049726447e+00,
 -6.556145006759398e-04,  7.997396400220798e-05, -6.869095337472200e-06, -2.721162914119307e-07,  3.552694319632380e-07, -1.269244280708094e-07,  3.595338051953750e-08,
 -9.231270256131813e-09,  2.248770117555084e-09, -5.297227952234667e-10,  1.166424351054426e-10,  2.001509858605928e+00, -8.780017214469886e-04,  1.428066294701511e-04,
 -2.282365369056453e-05,  3.555749155218760e-06, -5.325535360499396e-07,  7.463342677102130e-08, -9.177222899980785e-09,  7.850707958074391e-10,  3.779633533297964e-11,
 -4.408671860399323e-11,  1.477225530221271e-11,  2.001742225673461e+00, -1.027754864244580e-03,  1.849794780759344e-04, -3.349955451640300e-05,  6.109949426823319e-06,
 -1.123456792921861e-06,  2.084772226364564e-07, -3.908584217011304e-08,  7.411487783246229e-09, -1.422743098272973e-09,  2.763294012206603e-10, -5.237885981153084e-11,
  2.001869235966304e+00, -1.109570202894145e-03,  2.079730494371716e-04, -3.930921811753638e-05,  7.497478766587146e-06, -1.443948281296992e-06,  2.809684620234231e-07,
 -5.526462388013957e-08,  1.099216263800145e-08, -2.211256342089307e-09,  4.491879955373025e-10, -8.858570129508735e-11,  1.998592553886168e+00,  9.468417110830554e-04,
 -3.090181057487355e-04,  8.197511727016409e-05, -1.977225146822224e-05,  4.515148898224170e-06, -9.951555237522435e-07,  2.139703157080872e-07, -4.517559548076419e-08,
  9.405604660714264e-09, -1.934005148059435e-09,  3.793440667471255e-10,  1.999164233412437e+00,  5.784846923606906e-04, -2.054852419534834e-04,  5.595674054862456e-05,
 -1.362791137990789e-05,  3.120533185726593e-06, -6.871935972185030e-07,  1.473237964514144e-07, -3.097342854623155e-08,  6.416001030061568e-09, -1.311856552327700e-09,
  2.558789431255364e-10,  1.999567267425758e+00,  3.195904912403103e-04, -1.336934814833850e-04,  3.815685453210184e-05, -9.480357898110258e-06,  2.191558535089996e-06,
 -4.847343829518756e-07,  1.040753232224929e-07, -2.187504728790467e-08,  4.524938460329210e-09, -9.231993419873048e-10,  1.796271532775759e-10,  1.999877391899566e+00,
  1.208266070718274e-04, -7.912284687638193e-05,  2.476040419180130e-05, -6.389334378420626e-06,  1.505892979367553e-06, -3.367181304358029e-07,  7.275155476651619e-08,
 -1.534571725759190e-08,  3.180056245997226e-09, -6.492231338338756e-10,  1.263058212938436e-10,  2.000124313332904e+00, -3.715053710961980e-05, -3.608943739431728e-05,
  1.427817876731291e-05, -3.989205644849270e-06,  9.774802736340326e-07, -2.234876223017476e-07,  4.896189855018065e-08, -1.042178896083726e-08,  2.172828983917410e-09,
 -4.454047908213864e-10,  8.687953811383592e-11,  2.000323509520970e+00, -1.644135942754921e-04, -1.641331457780372e-06,  5.939557584825546e-06, -2.091600165153553e-06,
  5.622088298725543e-07, -1.350228949129612e-07,  3.048175016064934e-08, -6.618108329235274e-09,  1.398970934980581e-09, -2.896299507097546e-10,  5.688950883328724e-11,
  2.000484232461843e+00, -2.669795580588251e-04,  2.597953659049016e-05, -7.126614913303039e-07, -5.852567640059046e-07,  2.341532488827292e-07, -6.546643352724770e-08,
  1.601798215655610e-08, -3.654321971553014e-09,  7.985844145494492e-10, -1.692752118833671e-10,  3.380525533979518e-11,  2.000612457211342e+00, -3.487316393609291e-04,
  4.790435236477476e-05, -5.971565843088118e-06,  6.008477431358101e-07, -2.315979506553169e-08, -1.111449132327224e-08,  4.757116372962274e-09, -1.354994604149842e-09,
  3.343891714861132e-10, -7.652637080865061e-11,  1.606826584011590e-11,  2.000712211051427e+00, -4.122855139836100e-04,  6.489291559924673e-05, -1.003335183080359e-05,
  1.514076978078883e-06, -2.206710322429160e-07,  3.048216953974281e-08, -3.836386731106543e-09,  3.948402143892602e-10, -1.793188874534070e-11, -6.310110298615171e-12,
  2.671059726077639e-12,  2.000786252042285e+00, -4.594315010560467e-04,  7.746398119247007e-05, -1.303157917636652e-05,  2.186568416808122e-06, -3.657781396769637e-07,
  6.097357589224078e-08, -1.012195642095178e-08,  1.672046480577385e-09, -2.745735821119148e-10,  4.473924319977448e-11, -7.052337137540364e-12,  2.000836444100394e+00,
 -4.913789342776856e-04,  8.596722481001485e-05, -1.505605660022073e-05,  2.639874235354483e-06, -4.634280750196852e-07,  8.145986488930271e-08, -1.433851067938375e-08,
  2.527559372809602e-09, -4.462343691520422e-10,  7.883822493141343e-11, -1.353926562484738e-11,  2.000863980050484e+00, -5.089013378878170e-04,  9.062581469644671e-05,
 -1.616396630218435e-05,  2.887683376405810e-06, -5.167550634260788e-07,  9.263628491922062e-08, -1.663665453294087e-08,  2.993405339238832e-09, -5.396242260972928e-10,
  9.737359570088613e-11, -1.706272729268866e-11,  1.999911116248899e+00,  7.659715895545352e-05, -4.218987817249875e-05,  1.258764976882850e-05, -3.143990587583768e-06,
  7.204263309394850e-07, -1.568698349229641e-07,  3.302426279122996e-08, -6.787606809053382e-09,  1.370275723122359e-09, -2.724615335193686e-10,  5.170030624829623e-11,
  2.000033582089303e+00, -1.430360889965077e-06, -2.133150540253825e-05,  7.604776475898159e-06, -2.025630936057617e-06,  4.792036341074499e-07, -1.062543630895364e-07,
  2.261653205230859e-08, -4.680456434830425e-09,  9.488781461179346e-10, -1.891316938769560e-10,  3.593065393744047e-11,  2.000121878088748e+00, -5.760569343229726e-05,
 -6.413378113698389e-06,  4.064519195728082e-06, -1.236296387370299e-06,  3.100691512807475e-07, -7.099747493547138e-08,  1.541413583009297e-08, -3.231714513462294e-09,
  6.610207170930251e-10, -1.325723253605564e-10,  2.529057903636710e-11,  2.000190950958778e+00, -1.015034770039059e-04,  5.186713021713947e-06,  1.325310008319174e-06,
 -6.285788890766386e-07,  1.804901270042462e-07, -4.411791691232369e-08,  9.949698464736749e-09, -2.137846160400415e-09,  4.447123929851952e-10, -9.027158929019439e-11,
  1.736764548907687e-11,  2.000246664467129e+00, -1.368806393434502e-04,  1.449843587935303e-05, -8.648668956971174e-07, -1.445745940096995e-07,  7.769144328898562e-08,
 -2.287599047086682e-08,  5.647894909545806e-09, -1.279982117359218e-09,  2.757108756152404e-10, -5.734456914457194e-11,  1.122157398783780e-11,  2.000292080558327e+00,
 -1.656990542077208e-04,  2.205954121719307e-05, -2.637594183865981e-06,  2.459314154938077e-07, -4.987174437361342e-09, -5.845017361026290e-09,  2.209549157703340e-09,
 -5.964092583639403e-10,  1.414532646208333e-10, -3.126482857418559e-11,  6.367027146970449e-12,  2.000329035341397e+00, -1.891351231203956e-04,  2.819240377969931e-05,
 -4.071708324180271e-06,  5.610262164618644e-07, -7.152810673513982e-08,  7.826882967823763e-09, -5.436962934590380e-10, -5.040153963078760e-11,  3.447769011815355e-11,
 -1.053485859521316e-11,  2.516911699753609e-12,  2.000358718756284e+00, -2.079511833028490e-04,  3.310584220505606e-05, -5.218238717326208e-06,  8.124056789890974e-07,
 -1.245033979241943e-07,  1.868912409208123e-08, -2.726688920372860e-09,  3.816484003273530e-10, -5.000332265048172e-11,  5.804229115720749e-12, -5.122500487916857e-13,
  2.000381935611972e+00, -2.226627859659431e-04,  3.694100567273798e-05, -6.111652071498898e-06,  1.007961756117003e-06, -1.656465294627567e-07,  2.711149734344703e-08,
 -4.416613741851071e-09,  7.155807106489646e-10, -1.151965751686093e-10,  1.839357238995406e-11, -2.842922176445241e-12,  2.000399238813999e+00, -2.336240798276864e-04,
  3.979480567278736e-05, -6.775595844539245e-06,  1.153104186684780e-06, -1.961444983704505e-07,  3.334691345469082e-08, -5.666190533447680e-09,  9.621994478205537e-10,
 -1.632860543311517e-10,  2.766913654468380e-11, -4.558253372549766e-12,  2.000411003044777e+00, -2.410750339137400e-04,  4.173287763603690e-05, -7.226075432914674e-06,
  1.251491568684377e-06, -2.167993366706945e-07,  3.756608611081695e-08, -6.510965696018611e-09,  1.128780693908004e-09, -1.957407610029510e-10,  3.392378486887645e-11,
 -5.714030351216714e-12,  2.000417468908104e+00, -2.451697171238981e-04,  4.279732687191434e-05, -7.473348944449053e-06,  1.305466453546193e-06, -2.281240432918036e-07,
  3.987809006602097e-08, -6.973625699636859e-09,  1.219962882124467e-09, -2.134960744704024e-10,  3.734377614759901e-11, -6.345693462398840e-12,  2.000085533973669e+00,
 -4.459648561225683e-05,  1.164164421591467e-06,  9.535376073027532e-07, -3.685811848166171e-07,  9.966410963038825e-08, -2.357139928760550e-08,  5.193843126431133e-09,
 -1.095303932240370e-09,  2.241714103020306e-10, -4.483826530473894e-11,  8.515483210170498e-12,  2.000113974100649e+00, -6.262163291648824e-05,  5.867526162327964e-06,
 -1.429561538070361e-07, -1.284382065609527e-07,  4.912204321468330e-08, -1.322337726790001e-08,  3.117658358413197e-09, -6.851565037835605e-10,  1.441376568981252e-10,
 -2.939390710116979e-11,  5.658660388677884e-12,  2.000134694581102e+00, -7.574490868876834e-05,  9.280677201581452e-06, -9.360530481213745e-07,  4.468726008979423e-08,
  1.280453683926250e-08, -5.812073967021362e-09,  1.635548692931823e-09, -3.933233241624129e-10,  8.737640479119495e-11, -1.847591483223958e-11,  3.645194122484976e-12,
  2.000151031451693e+00, -8.608635746173980e-05,  1.196369878776674e-05, -1.557948414830927e-06,  1.801044889842742e-07, -1.553238034301676e-08, -4.364607509152867e-11,
  4.848206546406266e-10, -1.672965177178934e-10,  4.352191775520833e-11, -1.006099194637954e-11,  2.096847941702751e-12,  2.000164290934403e+00, -9.447623070000075e-05,
  1.413610711469474e-05, -2.060490906028804e-06,  2.893158280707637e-07, -3.834035466380287e-08,  4.590125576707936e-09, -4.377423532240712e-10,  1.355944764384873e-11,
  8.499980253640304e-12, -3.353859519506637e-12,  8.649568924082453e-13,  2.000175154492109e+00, -1.013477238839639e-04,  1.591249466227886e-05, -2.470757174097431e-06,
  3.783297698741068e-07, -5.690028230302026e-08,  8.354788335084238e-09, -1.186070917670417e-09,  1.600255435387533e-10, -1.981757999426024e-11,  2.060789642655255e-12,
 -1.280904901991426e-13,  2.000184030643295e+00, -1.069605442799884e-04,  1.736158211704760e-05, -2.804988152313306e-06,  4.507506190793603e-07, -7.198052843685247e-08,
  1.140961947617001e-08, -1.792507112565611e-09,  2.785654002776866e-10, -4.270625717971525e-11,  6.431763666983730e-12, -9.287705127094257e-13,  2.000191184154665e+00,
 -1.114830190889940e-04,  1.852791805857678e-05, -3.073712908449484e-06,  5.089150154604161e-07, -8.407916347530508e-08,  1.385784611426124e-08, -2.278006113059720e-09,
  3.733655290486402e-10, -6.099185644107895e-11,  9.920075643892702e-12, -1.567145170898803e-12,  2.000196794145809e+00, -1.150290275316138e-04,  1.944164393510441e-05,
 -3.284055396467299e-06,  5.544037966512456e-07, -9.353309953226078e-08,  1.576927841310132e-08, -2.656735186673671e-09,  4.472553020786903e-10, -7.523224851328144e-11,
  1.263444657871450e-11, -2.063503513503105e-12,  2.000200983715468e+00, -1.176768332520148e-04,  2.012347528038279e-05, -3.440911555357970e-06,  5.883032730148039e-07,
 -1.005738128266172e-07,  1.719186819594449e-08, -2.938422813348314e-09,  5.021769420547044e-10, -8.581023343535785e-11,  1.464944633597266e-11, -2.431755332095756e-12,
  2.000203836317064e+00, -1.194794942428818e-04,  2.058745582208640e-05, -3.547600260492449e-06,  6.113497412345665e-07, -1.053581685711892e-07,  1.815810368840493e-08,
 -3.129658416925092e-09,  5.394455696649380e-10, -9.298492271386179e-11,  1.601553086787442e-11, -2.681308759063259e-12,  2.000205405603786e+00, -1.204711199118527e-04,
  2.084261113167686e-05, -3.606253762119941e-06,  6.240160725227093e-07, -1.079868712193828e-07,  1.868883317374966e-08, -3.234668734287036e-09,  5.599043815116007e-10,
 -9.692236990737243e-11,  1.676501981928298e-11, -2.818187431570404e-12,  2.000072723323727e+00, -4.129441944537377e-05,  5.551000630586397e-06, -6.844829107348494e-07,
  7.064838211622076e-08, -3.950115696019448e-09, -7.491786443388890e-10,  3.777025067520707e-10, -1.083094255500357e-10,  2.617734552427048e-11, -5.808050289879353e-12,
  1.179542748745728e-12,  2.000079581504574e+00, -4.563001714773981e-05,  6.668930761954272e-06, -9.419968410528152e-07,  1.263714001516428e-07, -1.553735140098866e-08,
  1.594739954270651e-09, -8.692813654311176e-11, -1.762388803924426e-11,  8.693828349731150e-12, -2.474497255053438e-12,  5.698117606777951e-13,  2.000084603470065e+00,
 -4.880370035496087e-05,  7.485936220381532e-06, -1.129885493076564e-06,  1.669616818067947e-07, -2.396399094162977e-08,  3.296523797335673e-09, -4.237168147131599e-10,
  4.800213372124025e-11, -3.937707973136203e-12, -6.997938648811371e-14,  1.306771119390010e-13,  2.000088578140707e+00, -5.131487679695096e-05,  8.131597205765062e-06,
 -1.278185655311214e-06,  1.989597241364126e-07, -3.059860864463757e-08,  4.634740276564669e-09, -6.882258668377251e-10,  9.948004745154192e-11, -1.383380086105282e-11,
  1.811508942939500e-12, -2.125421694324011e-13,  2.000091813965136e+00, -5.335882474516801e-05,  8.656608521887708e-06, -1.398654248782301e-06,  2.249267897417155e-07,
 -3.597737475462409e-08,  5.718569453629193e-09, -9.022404273545051e-10,  1.410895726124395e-10, -2.182488136898364e-11,  3.329313633433953e-12, -4.891639358483406e-13,
  2.000094471704250e+00, -5.503732988616693e-05,  9.087403852804823e-06, -1.497423766975790e-06,  2.461992707784454e-07, -4.038012677201614e-08,  6.605009014900773e-09,
 -1.077136046157825e-09,  1.750658948598613e-10, -2.834473617732925e-11,  4.566683143323210e-12, -7.145067028049104e-13,  2.000096647664607e+00, -5.641137234134107e-05,
  9.439824041619948e-06, -1.578170113849240e-06,  2.635783922557501e-07, -4.397467059994400e-08,  7.328243271351248e-09, -1.219736081652349e-09,  2.027498754331350e-10,
 -3.365360857450714e-11,  5.573563578267764e-12, -8.977612809132989e-13,  2.000098404234823e+00, -5.752045758984615e-05,  9.724133543458551e-06, -1.643275598841766e-06,
  2.775834951766374e-07, -4.686978832996102e-08,  7.910434653091144e-09, -1.334464561465874e-09,  2.250109184639430e-10, -3.792024131378721e-11,  6.382340016961168e-12,
 -1.044886854110747e-12,  2.000099783608632e+00, -5.839130428313258e-05,  9.947275543639058e-06, -1.694351889685997e-06,  2.885659564770192e-07, -4.913908549592045e-08,
  8.366579745018800e-09, -1.424315160623751e-09,  2.424373399416876e-10, -4.125881882728862e-11,  7.014925908777885e-12, -1.159915513725970e-12,  2.000100814777424e+00,
 -5.904227130348320e-05,  1.011402135612983e-05, -1.732506610821397e-06,  2.967672768444275e-07, -5.083315322082370e-08,  8.706986346332451e-09, -1.491345566162522e-09,
  2.554335091226810e-10, -4.374782116334372e-11,  7.486381795004018e-12, -1.245618237021557e-12,  2.000101517393605e+00, -5.948580378571461e-05,  1.022760558181099e-05,
 -1.758490687379292e-06,  3.023511892292216e-07, -5.198629182129951e-08,  8.938643032379558e-09, -1.536950841752616e-09,  2.642735696993310e-10, -4.544045161648849e-11,
  7.806916909371879e-12, -1.303873283868084e-12,  2.000101904097206e+00, -5.972990599719856e-05,  1.029010836457216e-05, -1.772786973023108e-06,  3.054229618270523e-07,
 -5.262055074353003e-08,  9.066041631568893e-09, -1.562027507752336e-09,  2.691336676975222e-10, -4.637088912767352e-11,  7.983088720681619e-12, -1.335886868419544e-12,
  2.000043556476894e+00, -2.519680824648099e-05,  3.950057622980015e-06, -6.131478955746526e-07,  9.402124682328202e-08, -1.419648930323408e-08,  2.100779947175652e-09,
 -3.024568255660381e-10,  4.185724598757634e-11, -5.444489016594436e-12,  6.339220268037276e-13, -5.806528956754103e-14,  2.000045240707627e+00, -2.626020786415803e-05,
  4.222642154740332e-06, -6.755648399238908e-07,  1.074471138749439e-07, -1.697165625363503e-08,  2.658801677630880e-09, -4.124117197166724e-10,  6.318977321170497e-11,
 -9.532678375161834e-12,  1.408774269922377e-12, -1.990015811680414e-13,  2.000046477072790e+00, -2.704069746964252e-05,  4.422545764308456e-06, -7.213018162351703e-07,
  1.172770708470716e-07, -1.900187223433079e-08,  3.066696248123182e-09, -4.927190247786366e-10,  7.875754832778821e-11, -1.251365936486289e-11,  1.973311726306414e-12,
 -3.016056935630495e-13,  2.000047457449501e+00, -2.765950666777795e-05,  4.580941518653975e-06, -7.575195419323304e-07,  1.250562777118040e-07, -2.060753973974601e-08,
  3.389093182186309e-09, -5.561538401909561e-10,  9.104689918602763e-11, -1.486541168235744e-11,  2.418410563938982e-12, -3.824550928208744e-13,  2.000048256792962e+00,
 -2.816399574071723e-05,  4.710011211844057e-06, -7.870170772556180e-07,  1.313888920842801e-07, -2.191397019391447e-08,  3.651276172350116e-09, -6.077151917797035e-10,
  1.010309937625174e-10, -1.677506556174158e-11,  2.779657343659755e-12, -4.480427966710588e-13,  2.000048914144668e+00, -2.857883412882151e-05,  4.816101591730520e-06,
 -8.112530500605666e-07,  1.365898131368351e-07, -2.298649132068536e-08,  3.866428681789901e-09, -6.500101519854473e-10,  1.092174428185450e-10, -1.834024551400909e-11,
  3.075620240570372e-12, -5.017571763577203e-13,  2.000049452881915e+00, -2.891879396025707e-05,  4.903013755499679e-06, -8.311011822858067e-07,  1.408476956873926e-07,
 -2.386424647892723e-08,  4.042451141497643e-09, -6.846012625908902e-10,  1.159105192197878e-10, -1.961947658663794e-11,  3.317431919848702e-12, -5.456299442064752e-13,
  2.000049888143253e+00, -2.919344156996852e-05,  4.973209598870162e-06, -8.471274383456527e-07,  1.442847578901637e-07, -2.457259714398849e-08,  4.184462874040199e-09,
 -7.125011176132823e-10,  1.213074224248452e-10, -2.065069201288029e-11,  3.512308598707268e-12, -5.809781445533225e-13,  2.000050230164080e+00, -2.940924504508101e-05,
  5.028353858270367e-06, -8.597145616478154e-07,  1.469836594895934e-07, -2.512869747923916e-08,  4.295926789243290e-09, -7.343947235927460e-10,  1.255415637957743e-10,
 -2.145955623424856e-11,  3.665132791411634e-12, -6.086929309890774e-13,  2.000050485975674e+00, -2.957064776101838e-05,  5.069590247827348e-06, -8.691255257604891e-07,
  1.490011978481540e-07, -2.554433522935457e-08,  4.379222612231283e-09, -7.507528433713263e-10,  1.287046328277631e-10, -2.206370830912845e-11,  3.779260339495893e-12,
 -6.293868258224786e-13,  2.000050660343675e+00, -2.968066137119633e-05,  5.097694002086126e-06, -8.755385888069735e-07,  1.503758751034920e-07, -2.582750145964562e-08,
  4.435963645904196e-09, -7.618946339433899e-10,  1.308587926403154e-10, -2.247510731406717e-11,  3.856966501525882e-12, -6.434751236018323e-13,  2.000050756333732e+00,
 -2.974122319890058e-05,  5.113163787596971e-06, -8.790684089938261e-07,  1.511324551059503e-07, -2.598333559364341e-08,  4.467187421001955e-09, -7.680253361187905e-10,
  1.320440161138282e-10, -2.270144282890883e-11,  3.899714152542098e-12, -6.512248206183418e-13,  2.000023541488356e+00, -1.371182637403673e-05,  2.260597788296227e-06,
 -3.720055253052276e-07,  6.109418582057030e-08, -1.001129879637573e-08,  1.636529598073715e-09, -2.668010374506144e-10,  4.336601228177120e-11, -7.025025846672328e-12,
  1.133022047362262e-12, -1.775552862483305e-13,  2.000023958826914e+00, -1.397516401118543e-05,  2.327902006168540e-06, -3.873713659969734e-07,  6.438955575600796e-08,
 -1.069043463913347e-08,  1.772681307832668e-09, -2.935489737759116e-10,  4.853995168093396e-11, -8.013609420519829e-12,  1.319836341692519e-12, -2.114399912097434e-13,
  2.000024265566269e+00, -1.416869779364728e-05,  2.377345684467470e-06, -3.986549680911657e-07,  6.680845570633448e-08, -1.118873634958135e-08,  1.872538804957514e-09,
 -3.131586146995354e-10,  5.233155119926765e-11, -8.737772392871991e-12,  1.456626740134756e-12, -2.362417746307560e-13,  2.000024509023441e+00, -1.432229440579595e-05,
  2.416574241261684e-06, -4.076045913799151e-07,  6.872641705001205e-08, -1.158371994698286e-08,  1.951667135332823e-09, -3.286926959384387e-10,  5.533418930679076e-11,
 -9.311071802964946e-12,  1.564886248237966e-12, -2.558648486126213e-13,  2.000024707673982e+00, -1.444761606503438e-05,  2.448573483594993e-06, -4.149030973883260e-07,
  7.029014261217238e-08, -1.190567189343878e-08,  2.016148650736892e-09, -3.413482167582436e-10,  5.777980755045668e-11, -9.777901457252514e-12,  1.653018477094866e-12,
 -2.718359288719540e-13,  2.000024871137791e+00, -1.455073523905965e-05,  2.474898291803293e-06, -4.209061326658021e-07,  7.157604665414363e-08, -1.217036952356554e-08,
  2.069152224659059e-09, -3.517488755648072e-10,  5.978927238524336e-11, -1.016139772439228e-11,  1.725403518910657e-12, -2.849508383163929e-13,  2.000025005173498e+00,
 -1.463528707800819e-05,  2.496479548350056e-06, -4.258266369261327e-07,  7.262988557955494e-08, -1.238726104929958e-08,  2.112575692399269e-09, -3.602682363208621e-10,
  6.143498270551596e-11, -1.047542038128055e-11,  1.784665460196778e-12, -2.956863835951241e-13,  2.000025113509430e+00, -1.470362513656688e-05,  2.513919992545059e-06,
 -4.298024972140370e-07,  7.348129064162792e-08, -1.256246543965432e-08,  2.147648237584772e-09, -3.671482636990238e-10,  6.276383569778133e-11, -1.072894780999080e-11,
  1.832504289557530e-12, -3.043514760292753e-13,  2.000025198665927e+00, -1.475734043267752e-05,  2.527627104521189e-06, -4.329269371439476e-07,  7.415029628470732e-08,
 -1.270012011411366e-08,  2.175201032941831e-09, -3.725525824090439e-10,  6.380754640619612e-11, -1.092805208955672e-11,  1.870069761903683e-12, -3.111550505741348e-13,
  2.000025262374122e+00, -1.479752579194550e-05,  2.537880784085896e-06, -4.352639953313052e-07,  7.465066548866450e-08, -1.280306745969470e-08,  2.195805113457324e-09,
 -3.765936108500279e-10,  6.458790548145229e-11, -1.107690535126079e-11,  1.898151902075321e-12, -3.162406760024982e-13,  2.000025305807231e+00, -1.482492184325398e-05,
  2.544870730922310e-06, -4.368570747713759e-07,  7.499172657403909e-08, -1.287323405551373e-08,  2.209847539257540e-09, -3.793475507146990e-10,  6.511968387119207e-11,
 -1.117833577152406e-11,  1.917286258877863e-12, -3.197056778927970e-13,  2.000025329720011e+00, -1.484000504915034e-05,  2.548718980475388e-06, -4.377340963993651e-07,
  7.517948027330379e-08, -1.291185920567459e-08,  2.217577287445696e-09, -3.808634177064609e-10,  6.541238255399211e-11, -1.123416244609471e-11,  1.927817290864523e-12,
 -3.216126533484312e-13,  2.000012207205037e+00, -7.131328904988113e-06,  1.200705581406558e-06, -2.020815473000300e-07,  3.399644833184356e-08, -5.716752974881713e-09,
  9.608730614186445e-10, -1.614263732711693e-10,  2.710598352662611e-11, -4.549033963138586e-12,  7.624508101183881e-13, -1.243288852357368e-13,  2.000012311079090e+00,
 -7.196852357011811e-06,  1.217427638626888e-06, -2.058936218920257e-07,  3.481277593941350e-08, -5.884738174202969e-09,  9.945002733608278e-10, -1.680228348472866e-10,
  2.838005808255448e-11, -4.792108588519480e-12,  8.083169018779203e-13, -1.326365870201612e-13,  2.000012387472323e+00, -7.245038930902942e-06,  1.229722718758888e-06,
 -2.086959215141423e-07,  3.541274498146560e-08, -6.008175467903575e-09,  1.019204835498259e-09, -1.728679958709037e-10,  2.931568535369597e-11, -4.970575829997595e-12,
  8.419852533512966e-13, -1.387337496016317e-13,  2.000012448133490e+00, -7.283300944307731e-06,  1.239483992826571e-06, -2.109203704140615e-07,  3.588892281385966e-08,
 -6.106128767233707e-09,  1.038806011132857e-09, -1.767116599245883e-10,  3.005780223390690e-11, -5.112109636683066e-12,  8.686818595318799e-13, -1.435676612572595e-13,
  2.000012497648960e+00, -7.314531998476470e-06,  1.247450569904045e-06, -2.127356085227058e-07,  3.627745414709795e-08, -6.186042525500214e-09,  1.054795337612106e-09,
 -1.798466705011064e-10,  3.066301966075311e-11, -5.227520007525965e-12,  8.904482527880965e-13, -1.475084057120679e-13,  2.000012538406342e+00, -7.340238485388992e-06,
  1.254007249360791e-06, -2.142294395295447e-07,  3.659715914933093e-08, -6.251793224706763e-09,  1.067949536028171e-09, -1.824255354963766e-10,  3.116082138003454e-11,
 -5.322437265237441e-12,  9.083478141202626e-13, -1.507487602462659e-13,  2.000012571834686e+00, -7.361322032874078e-06,  1.259384358271940e-06, -2.154544221452904e-07,
  3.685930399772274e-08, -6.305701526298420e-09,  1.078733613747334e-09, -1.845395626423017e-10,  3.156886037640583e-11, -5.400232643017193e-12,  9.230172864246467e-13,
 -1.534041630042900e-13,  2.000012598859097e+00, -7.378366320548024e-06,  1.263731007577647e-06, -2.164445835886739e-07,  3.707118285407835e-08, -6.349269975212843e-09,
  1.087448657881574e-09, -1.862478749190427e-10,  3.189856762050949e-11, -5.463089221285971e-12,  9.348690146982806e-13, -1.555493724673284e-13,  2.000012620104886e+00,
 -7.391765879680232e-06,  1.267147990272005e-06, -2.172229256238888e-07,  3.723772659099500e-08, -6.383514327372271e-09,  1.094298216676589e-09, -1.875904432897532e-10,
  3.215767141810350e-11, -5.512482990671327e-12,  9.441817952457630e-13, -1.572349359652758e-13,  2.000012636001524e+00, -7.401791681316121e-06,  1.269704534509074e-06,
 -2.178052470624879e-07,  3.736232207259285e-08, -6.409132291103594e-09,  1.099422107873309e-09, -1.885947245419946e-10,  3.235148060649716e-11, -5.549427882509508e-12,
  9.511471513428710e-13, -1.584955784471218e-13,  2.000012646840055e+00, -7.408627357546642e-06,  1.271447555770127e-06, -2.182022548476314e-07,  3.744726463546997e-08,
 -6.426596723496488e-09,  1.102915091574941e-09, -1.892793275484870e-10,  3.248359331450595e-11, -5.574611111807575e-12,  9.558948942221370e-13, -1.593548362248850e-13,
  2.000012652807719e+00, -7.412391046614499e-06,  1.272407236475136e-06, -2.184208370757304e-07,  3.749403092376732e-08, -6.436211821623782e-09,  1.104838127960106e-09,
 -1.896562234702660e-10,  3.255632420816923e-11, -5.588474757293036e-12,  9.585085292819884e-13, -1.598278496591757e-13,  2.000006212178698e+00, -3.634154416598118e-06,
  6.178326885992936e-07, -1.050260546409022e-07,  1.785176101515482e-08, -3.034045417997673e-09,  5.156074955073244e-10, -8.761361380341334e-11,  1.488599931724788e-11,
 -2.528878306483135e-12,  4.292293742962257e-13, -7.086077281916777e-14,  2.000006238089904e+00, -3.650496600308952e-06,  6.220002800014791e-07, -1.059754256223252e-07,
  1.805491108559521e-08, -3.075818915621414e-09,  5.239634808106623e-10, -8.925154109425298e-11,  1.520212156911389e-11, -2.589144875994032e-12,  4.405927278599136e-13,
 -7.291758027057133e-14,  2.000006257151910e+00, -3.662518740478108e-06,  6.250658627029878e-07, -1.066736895835828e-07,  1.820431303006595e-08, -3.106537105737496e-09,
  5.301074342517067e-10, -9.045574575342222e-11,  1.543451089136141e-11, -2.633443780936372e-12,  4.489445000364844e-13, -7.442913583039446e-14,  2.000006272291904e+00,
 -3.672067167781960e-06,  6.275004748604457e-07, -1.072281911022858e-07,  1.832294605193380e-08, -3.130927068303060e-09,  5.349852967846666e-10, -9.141172409820559e-11,
  1.561898270552665e-11, -2.668605729805848e-12,  4.555731460013941e-13, -7.562874184944840e-14,  2.000006284652438e+00, -3.679862555611317e-06,  6.294879828480395e-07,
 -1.076808330391081e-07,  1.841978063533975e-08, -3.150834206200288e-09,  5.389663686338987e-10, -9.219189772413593e-11,  1.576952064631140e-11, -2.697297783353257e-12,
  4.609817648078971e-13, -7.660749850572637e-14,  2.000006294828255e+00, -3.686280044795416e-06,  6.311240998238662e-07, -1.080534289550526e-07,  1.849948673139694e-08,
 -3.167219249022803e-09,  5.422429160349798e-10, -9.283397215406095e-11,  1.589340536653341e-11, -2.720908603331541e-12,  4.654323136122858e-13, -7.741284182791776e-14,
  2.000006303175298e+00, -3.691544152006211e-06,  6.324661102466931e-07, -1.083590346261142e-07,  1.856485945324140e-08, -3.180657238182370e-09,  5.449300221597777e-10,
 -9.336051702426781e-11,  1.599499500091742e-11, -2.740269450884110e-12,  4.690816053361676e-13, -7.807316863980864e-14,  2.000006309923977e+00, -3.695800211278602e-06,
  6.335510962261853e-07, -1.086061016579199e-07,  1.861770824348908e-08, -3.191520439696255e-09,  5.471021902025161e-10, -9.378614388767410e-11,  1.607711105661968e-11,
 -2.755918504848092e-12,  4.720311665041618e-13, -7.860686443938905e-14,  2.000006315230023e+00, -3.699146454218661e-06,  6.344041220597082e-07, -1.088003426992951e-07,
  1.865925616927251e-08, -3.200060485646063e-09,  5.488097811927155e-10, -9.412072970033590e-11,  1.614166081555278e-11, -2.768219569067759e-12,  4.743496291771233e-13,
 -7.902635802946835e-14,  2.000006319200392e+00, -3.701650345218235e-06,  6.350424018569785e-07, -1.089456812373947e-07,  1.869034325257763e-08, -3.206450203186665e-09,
  5.500873847782468e-10, -9.437105837399673e-11,  1.618995429624748e-11, -2.777422525711662e-12,  4.760841345282660e-13, -7.934018645631711e-14,  2.000006321907564e+00,
 -3.703357602305936e-06,  6.354776010674317e-07, -1.090447761181245e-07,  1.871153875985221e-08, -3.210806714966662e-09,  5.509584421126977e-10, -9.454172735773412e-11,
  1.622287930462810e-11, -2.783696722630397e-12,  4.772666309182457e-13, -7.955413546547299e-14,  2.000006323398167e+00, -3.704297638249185e-06,  6.357172246432490e-07,
 -1.090993378988513e-07,  1.872320892458736e-08, -3.213205370650904e-09,  5.514380337526116e-10, -9.463569434557740e-11,  1.624100699343338e-11, -2.787151105952552e-12,
  4.779176715054839e-13, -7.967192715074133e-14,  2.000003133166319e+00, -1.834154421273769e-06,  3.132711848609459e-07, -5.350507490111556e-08,  9.138173090130759e-09,
 -1.560678911144273e-09,  2.665369490180435e-10, -4.551880486098937e-11,  7.773443700637680e-12, -1.327441182471292e-12,  2.264947938276809e-13, -3.758089627736210e-14,
  2.000003139636974e+00, -1.838235144128596e-06,  3.143114721184866e-07, -5.374196327352418e-08,  9.188844595889340e-09, -1.571094561924395e-09,  2.686196254516497e-10,
 -4.592689604364019e-11,  7.852176564083372e-12, -1.342445485458923e-12,  2.293228296210208e-13, -3.809260290172762e-14,  2.000003144397946e+00, -1.841237622832674e-06,
  3.150768470263457e-07, -5.391624127620844e-08,  9.226121551872873e-09, -1.578756538115148e-09,  2.701516083695004e-10, -4.622706587986312e-11,  7.910085234128434e-12,
 -1.353480707480848e-12,  2.314026601452000e-13, -3.846891073535569e-14,  2.000003148179788e+00, -1.843622599286130e-06,  3.156847884367484e-07, -5.405466587141660e-08,
  9.255728540985171e-09, -1.584841777718279e-09,  2.713682813706552e-10, -4.646544600758197e-11,  7.956071657721450e-12, -1.362243654047107e-12,  2.330541661171704e-13,
 -3.876771006622909e-14,  2.000003151267634e+00, -1.845569902041462e-06,  3.161811495125266e-07, -5.416768077733891e-08,  9.279900014789611e-09, -1.589809679095640e-09,
  2.723615244182708e-10, -4.666004387762140e-11,  7.993610773213234e-12, -1.369396698575085e-12,  2.344022202557869e-13, -3.901160010886858e-14,  2.000003153809900e+00,
 -1.847173134685890e-06,  3.165897979192615e-07, -5.426072228434979e-08,  9.299799095402922e-09, -1.593899381395114e-09,  2.731791662486467e-10, -4.682023353813316e-11,
  8.024511540268568e-12, -1.375284660309460e-12,  2.355118299838447e-13, -3.921234594835194e-14,  2.000003155895408e+00, -1.848488315392787e-06,  3.169250177249403e-07,
 -5.433704388760149e-08,  9.316121893657384e-09, -1.597254007577287e-09,  2.738498323621655e-10, -4.695162542877697e-11,  8.049856648877233e-12, -1.380113921452181e-12,
  2.364219042202864e-13, -3.937698942876404e-14,  2.000003157581650e+00, -1.849551704609187e-06,  3.171960550728845e-07, -5.439875161154018e-08,  9.329319014723634e-09,
 -1.599966204697244e-09,  2.743920529506052e-10, -4.705785140228712e-11,  8.070346973040454e-12, -1.384018083877389e-12,  2.371576309787680e-13, -3.951008919033762e-14,
  2.000003158907488e+00, -1.850387810190454e-06,  3.174091593357717e-07, -5.444726890834802e-08,  9.339695023127406e-09, -1.602098593528968e-09,  2.748183528019133e-10,
 -4.714136629386582e-11,  8.086456250182727e-12, -1.387087453025214e-12,  2.377360357200440e-13, -3.961472660150428e-14,  2.000003159899607e+00, -1.851013463503744e-06,
  3.175686224511273e-07, -5.448357338152697e-08,  9.347459090162028e-09, -1.603694181561503e-09,  2.751373339058459e-10, -4.720385608869998e-11,  8.098509846154701e-12,
 -1.389384051648463e-12,  2.381688117907756e-13, -3.969301800606783e-14,  2.000003160576093e+00, -1.851440070347242e-06,  3.176773528698237e-07, -5.450832751165645e-08,
  9.352752963045839e-09, -1.604782113428822e-09,  2.753548255500492e-10, -4.724646332927522e-11,  8.106728252837313e-12, -1.390949911131217e-12,  2.384638835378878e-13,
 -3.974639761402749e-14,  2.000003160948580e+00, -1.851674968712374e-06,  3.177372217577870e-07, -5.452195750787383e-08,  9.355667835130456e-09, -1.605381139346225e-09,
  2.754745780012314e-10, -4.726992306754508e-11,  8.111253322825246e-12, -1.391812072138744e-12,  2.386263490356664e-13, -3.977578811255202e-14,   0.00148172004281787,
   0.00103861327429849,  0.000956992482906056,  0.000354415798601387,  7.87039264958972e-05,  1.04186585689533e-05,  7.93742155274331e-07,  3.26142958887844e-08,
  6.49103509173067e-10,  5.20763088244802e-12,  1.18317985996012e-14,  3.13090148219663e-18,  0.000739289152550903,  0.000518114578874347,  0.000477635192203942,
  0.000176973554461359,  3.93254999701898e-05,  5.21024304089487e-06,  3.97370530367657e-07,  1.63500884939609e-08,  3.25976352588767e-10,  2.62121280950154e-12,
  5.97396231134508e-15,  1.58829169542248e-18,  0.000369270200384165,  0.000258785254763578,    0.0002385919648047,  8.84120613667696e-05,  1.96488102837745e-05,
  2.60372883165392e-06,  1.98622548173599e-07,  8.17468711698979e-09,  1.63036164024061e-10,  1.31155084648166e-12,  2.99079571213447e-15,  7.95790836125923e-19,
  0.000184543373048219,   0.00012932721926536,  0.000119238604391361,  4.41857984817554e-05,  9.82021590254587e-06,  1.30136136452943e-06,  9.92778493639081e-08,
  4.08621852545435e-09,  8.15017837313549e-11,  6.55705636486576e-13,  1.49541782654532e-15,   3.9796700411735e-19,  9.22489682455796e-05,  6.46475526422677e-05,
  5.96048514351094e-05,  2.20876684679371e-05,  4.90898238884645e-06,  6.50537772973564e-07,  4.96286141798039e-08,  2.04271471037803e-09,  4.07437487280704e-11,
  3.27802555339753e-13,  7.47615144093116e-16,  1.98966176936885e-19,  4.61188301511829e-05,  3.23197973065635e-05,   2.9798800565481e-05,  1.10425061238843e-05,
  2.45420055829181e-06,  3.25231137057357e-07,  2.48114996071882e-08,  1.02124543816586e-09,  2.03697304758401e-11,  1.63884902953341e-13,  3.73772745674587e-16,
  9.94747360827102e-20,  2.30580047183209e-05,  1.61589082070174e-05,  1.48984924850817e-05,  5.52091855120079e-06,  1.22702649589449e-06,  1.62605885522448e-07,
   1.2405020047462e-08,   5.1059313168988e-10,  1.01842859922909e-11,  8.19378987601027e-14,  1.86876299021284e-16,  4.97347992926268e-20,  1.15286501579063e-05,
  8.07920702449751e-06,  7.44901910733535e-06,  2.76037534168831e-06,  6.13494663514999e-07,  8.13004917348066e-08,  6.20232415032305e-09,  2.55288971112292e-10,
   5.0919928656508e-12,  4.09677548534277e-14,  9.34354635162152e-17,  2.48666986979812e-20,   5.7642370769079e-06,  4.03954180870401e-06,  3.72445274682182e-06,
  1.38016664934487e-06,  3.06742668439476e-07,  4.06496293529901e-08,  3.10111518067069e-09,  1.27642562330205e-10,  2.54595824085786e-12,  2.04835718150582e-14,
  4.67170395233596e-17,   1.2433166847674e-20,  2.88209654396131e-06,  2.01975548671942e-06,  1.86221216883001e-06,  6.90078064560903e-07,  1.53370166246274e-07,
  2.03246600798125e-08,  1.55054581364116e-09,  6.38207973027252e-11,  1.27296949036268e-12,  1.02417086360469e-14,  2.33583441237611e-17,  6.21653689548609e-21,
   1.4410427741089e-06,  1.00987388998186e-06,  9.31102532911793e-07,  3.45037716661472e-07,  7.66847908622296e-08,  1.01622913323282e-08,  7.75269956025296e-10,
   3.1910277304526e-11,  6.36482327426873e-13,  5.12083489182655e-15,  1.16791278307925e-17,  3.10825670308903e-21  };
  int offset = -12;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 12;
    if (std::isnan(t)) {
      fill_n(rr+offset, 12, 0.5);
      fill_n(ww+offset, 12, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 12; ++r) {
        ww[offset+r] = aw[12-r-1] / t;
        rr[offset+r] = 1.0 - ax[12-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=12; ++j) {
        const int boxof = it*144+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 6192 + (it - 32) * 12 + 12 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
