TEMPLATE = app
CONFIG += qt warn_on

HEADERS += \
        boatproperties.h \
        boats.h \
        boatsengine.h \
        commontypes.h \
        enablestate.h \
        statemachine.h \
        trace.h \
        undocommands.h \
        xmlsituationreader.h \
        xmlsituationwriter.h

SOURCES += \
        boatproperties.cpp \
        boatsengine.cpp \
        enablestate.cpp \
        statemachine.cpp \
        trace.cpp \
        undocommands.cpp \
        xmlsituationreader.cpp \
        xmlsituationwriter.cpp

qml {
    TARGET = boats-qml
    QT += quick qml widgets
    DEFINES += QML

    SOURCES += \
        main_qml.cpp

    qml_files.files = boats.qml
    INSTALL += qml_files
}

else {
    TARGET = boats
    QT += widgets printsupport

    include(graphicsview/graphicsview.pri)
    include(itemviews/itemviews.pri)
    include(locale/locale.pri)

    HEADERS += \
        boatapplication.h \
        mainwindow.h \
        situationprint.h \
        situationwidget.h

    SOURCES += \
        boatapplication.cpp \
        main.cpp \
        mainwindow.cpp \
        situationprint.cpp \
        situationwidget.cpp

    gif_export {
        DEFINES += GIF_EXPORT
        HEADERS += gifwriter.h
        SOURCES += gifwriter.cpp
        LIBS += -lgif
    }

    PRE_TARGETDEPS += compiler_updateqm_make_all

    QMAKE_CFLAGS_RELEASE += -fvisibility=hidden
    QMAKE_CXXFLAGS_RELEASE += -fvisibility=hidden -fvisibility-inlines-hidden

}

include(animation/animation.pri)
include(model/model.pri)
INCLUDEPATH += $$PWD

RESOURCES += images.qrc

mac {
    QMAKE_LFLAGS += -static
    QMAKE_INFO_PLIST = resources/Info.plist
    ICON = resources/boats.icns
    mime.path = boats.app/Contents/Resources
    mime.files = resources/xbs.icns
    INSTALLS += mime
}

win32 {
    RC_ICONS = images/boats.ico
    QMAKE_LFLAGS += -static
    QTPLUGIN.imageformats = qjpeg
}

unix_deploy { 
    isEmpty(PREFIX):PREFIX = /usr/local

    target.path = $${PREFIX}/bin
    INSTALLS += target

    desktop.path = $${PREFIX}/share/applications
    desktop.files = resources/boats.desktop
    INSTALLS += desktop

    icons.path = $${PREFIX}/share/icons
    icons.files = images/icons/*
    INSTALLS += icons

    mimetype.path = $${PREFIX}/share/mime/packages
    mimetype.files = resources/boats.xml
    INSTALLS += mimetype

    TRANSLATEDIR = $${PREFIX}/share/boats
    translations.path = $${TRANSLATEDIR}
    translations.files = $$QM_FILES
    translations.CONFIG += no_check_exist
    INSTALLS += translations

    SHAPESDIR = $${PREFIX}/share/boats
    shapes.path = $${SHAPESDIR}
    shapes.files = shapes/*_*.json
    INSTALLS += shapes
}
else {
    !qml {
        RESOURCES += locales.qrc
        TRANSLATEDIR = ":locale"
        rcc.depends = $$QM_FILES
    }

    RESOURCES+= shapes.qrc
    SHAPESDIR= ":shapes"
}

DEFINES += TRANSLATEDIR=\\\"$${TRANSLATEDIR}\\\"
DEFINES += SHAPESDIR=\\\"$${SHAPESDIR}\\\"

MOC_DIR = .moc/
OBJECTS_DIR = .obj/
