//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Beam/BeamWavelengthItem.cpp
//! @brief     Implements class BeamWavelengthItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Beam/BeamWavelengthItem.h"
#include "GUI/Model/Descriptor/DistributionItems.h"

namespace {

const double default_wl = 0.1;

void initDistribution(DistributionItem* newDistribution,
                      const DistributionItem* currentDistribution)
{
    newDistribution->setUnit(Unit::nanometer);

    double meanVal = default_wl;
    if (auto* cd = dynamic_cast<const SymmetricResolutionItem*>(currentDistribution))
        meanVal = cd->mean();

    if (auto* nd = dynamic_cast<SymmetricResolutionItem*>(newDistribution)) {
        nd->setMean(meanVal);
        nd->setMeanDecimals(4);
        nd->mean().setLimits(RealLimits::positive());
    }

    newDistribution->initDistribution(meanVal);
};

} // namespace

BeamWavelengthItem::BeamWavelengthItem(bool onlySymmetricDistributions)
{
    m_distribution.initWithInitializer("Distribution", "",
                                       onlySymmetricDistributions
                                           ? DistributionItemCatalog::symmetricTypes()
                                           : DistributionItemCatalog::types(),
                                       initDistribution);
}

void BeamWavelengthItem::readFrom(QXmlStreamReader* r)
{
    // Here we only directly call parental method, so no versioning
    BeamDistributionItem::readFrom(r);

    m_distribution->setUnit(Unit::nanometer);
}

double BeamWavelengthItem::wavelength() const
{
    return BeamDistributionItem::meanValue();
}
