//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/CoreAndShellBuilder.h
//! @brief     Defines class CoreShellParticleBuilder.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_SAMPLE_STANDARDSAMPLES_COREANDSHELLBUILDER_H
#define BORNAGAIN_SAMPLE_STANDARDSAMPLES_COREANDSHELLBUILDER_H

class MultiLayer;


//! Builds sample: Core Shell Nanoparticles (IsGISAXS example #11).

namespace ExemplarySamples {

MultiLayer* createCoreShellParticle();

} // namespace ExemplarySamples

//! Rotation and translation of core shell box particle in 3 layers system.

namespace ExemplarySamples {

MultiLayer* createCoreShellBoxRotateZandY();

} // namespace ExemplarySamples

#endif // BORNAGAIN_SAMPLE_STANDARDSAMPLES_COREANDSHELLBUILDER_H
