//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Import/RealDataPropertiesWidget.h
//! @brief     Defines class RealDataPropertiesWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_IMPORT_REALDATAPROPERTIESWIDGET_H
#define BORNAGAIN_GUI_VIEW_IMPORT_REALDATAPROPERTIESWIDGET_H

#include <QWidget>

class RealItem;
class QComboBox;
class ProjectDocument;

//! The RealDataPropertiesWidget class holds instrument selector to link with RealItem.
//! Part of RealDataSelectorWidget, resides at lower left corner of ImportDataView.

class RealDataPropertiesWidget : public QWidget {
    Q_OBJECT
public:
    RealDataPropertiesWidget(QWidget* parent, ProjectDocument* document);

    QSize sizeHint() const override { return QSize(64, 135); }
    QSize minimumSizeHint() const override { return QSize(64, 128); }

    //! Set current RealItem to display in instrument selector.
    void setRealItem(RealItem* realItem);

signals:
    void instrumentUpdated(RealItem* realItem);

private:
    //! Processes user interaction with instrument selector combo. If there is realItem,
    //! it will be linked with selected instrument.
    void onInstrumentComboIndexChanged(int index);

    void updateInstrumentComboEntries();
    void updateInstrumentComboIndex();

    QComboBox* m_instrumentCombo;
    RealItem* m_currentRealItem;
    ProjectDocument* m_document;
};

#endif // BORNAGAIN_GUI_VIEW_IMPORT_REALDATAPROPERTIESWIDGET_H
