//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/MaterialInplaceForm.h
//! @brief     Defines class MaterialInplaceForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_MATERIALINPLACEFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_MATERIALINPLACEFORM_H

#include <QGridLayout>
#include <QWidget>

class ItemWithMaterial;
class SampleEditorController;

//! Form to select a material and to edit it in-place
class MaterialInplaceForm : public QWidget {
    Q_OBJECT
public:
    MaterialInplaceForm(QWidget* parent, ItemWithMaterial* item, SampleEditorController* ec);

    ItemWithMaterial* itemWithMaterial() const;
    void updateValues();

private:
    void selectMaterial();
    void createWidgets();
    void onMaterialChanged();

    ItemWithMaterial* m_item;
    SampleEditorController* m_ec;
    QGridLayout* m_layout;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_MATERIALINPLACEFORM_H
