# Copyright (C) 2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

from PyQt4 import QtCore

from bzrlib.plugins.qbzr.lib.util import (
    runs_in_loading_queue,
    url_for_display,
    )
from bzrlib.plugins.qbzr.lib.uifactory import ui_current_widget
from bzrlib.plugins.qbzr.lib.trace import (
   reports_exception,
   SUB_LOAD_METHOD)
from bzrlib.plugins.qbzr.lib.switch import QBzrSwitchWindow

from bzrlib.branch import Branch
from bzrlib.bzrdir import BzrDir
from bzrlib import (urlutils,
                   )


class QSwitchExplorerStyleDialog(QBzrSwitchWindow):

    def __init__(self, branch_location, checkout_location, parent):
        """A window to switch a checkout.

        :param: branch_location
           the location of the current branch
        :param: checkout_location
           the location of the checkout to be switched
        :param: parent
           the parent window
        """
        super(QSwitchExplorerStyleDialog, self).__init__(
            Branch.open(branch_location),
            BzrDir.open(checkout_location),
            location=None)
        self.parent = parent

    @runs_in_loading_queue
    @ui_current_widget
    @reports_exception(type=SUB_LOAD_METHOD)
    def initial_load(self):
        super(QSwitchExplorerStyleDialog, self).initial_load()
        if '.bzrbranches' not in self.branch.base and \
           '.bzr/branches' not in self.branch.base:
            return
        branch_combo = self.branch_combo
        branch_combo.clear()
        for br in self.branch.bzrdir.find_repository().find_branches():
            self.processEvents()
            branch_combo.addItem(self._display_url(br.base), 
                                 QtCore.QVariant(br.base))

    def _display_url(self, branch_url):
        """Make a shorter display url where appropriate."""
        if '.bzr/branches' in self.branch.base or \
           '.bzrbranches' in self.branch.base:
            return '-> %s' % urlutils.basename(branch_url)
        else:
            return url_for_display(branch_url)

    def do_start(self):
        branch_combo = self.branch_combo
        location = branch_combo.itemData(
            branch_combo.currentIndex()).toString()
        if location == '':
            location = branch_combo.currentText()
        if self.create_branch_box.isChecked():
            self.process_widget.do_start(None, 'switch', '--create-branch', location)
        else:
            self.process_widget.do_start(None, 'switch', location)
