.TH DICAR 1
.SH NAME
dicar \- Archive Binary Dictionary 
.SH SYNOPSYS
.B dicar
.B \-t
.I bindic1
.br
.B dicar
.B \-x
.I bindic1
[
.B bindic2
]
.br
.B dicar
.B \-r
.I bindic1
.I bindic2
.br
.B dicar
.B \-d 
.I bindic1
.I bindic2
.br
.SH DESCRIPTION
.I dicar
archives binary dictionary
.I bindic1.
The hyphen of each option may be omitted.
.OPTIONS
.TP
.B \-t
Displays the dictionaries contained in binary dictionary file
.I bindic1.
Each displayed name of the dictionaries consists of the text file name
followed by extension '.d'.  This text file name is that before the
dictionary file is converted into the binary file.
.TP
.B \-x
Fetches dictionary 
.I bindic2
from
.I bindic1.
.I Bindic2
consists of the text file name followed by extension '.d'.  This text file name
is that before the dictionary file is converted into the binary file.
The fetched file
.I bindic2
becomes a dictionary file in binary format. If
.I bindic2
is omitted, all dictionaries within
.I bindic1
will be fetched.
.TP
.B \-r
Adds to
.I bindic1,
all dictionaries that are contained in the dictionary file specified in
.I bindic2.
Any dictionary in 
.I bindic1
that is contained in 
.I bindic1 is overwritten.
.TP
.B \-d
Deletes
.I bindic2
from
.I bindic1.

.SH EXAMPLES
.nf
.B
% ls
.B
chimei.d shima.d
.B
% dicar \-t shima.d
.B 
(Text dictionary file name = Directory size + Word size, packed)
.B
% dicar r shima.d shima.mwd.d (Replaces shima.mwd.d.)
.B
% dicar r shima.d chimedi.d (Adds chimedi.d to shima.d.)
.B
% dicar \-t shma.d
.B
(Text dictionary file name = Directory size + Word size, packed)

.SH SEE ALSO
.PP
dpbindic(1), mkbindic(1)

.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: dicar.man,v 1.2 2003/01/13 05:29:15 aida_s Exp $
