from __future__ import absolute_import, division, print_function
import iotbx.pdb
from mmtbx.pair_interaction import pair_interaction
from six.moves import range
from libtbx.test_utils import approx_equal

pdb_str = """
REMARK iotbx.pdb.box_around_molecule --buffer-layer=5 "./data_files/2lvr.pdb"
REMARK Date 2016-12-17 Time 19:09:44 CST +0800 (1481972984.78 s)
HELIX    1   1 ASP A   15  GLY A   28  1                                  14
SHEET    1   A 2 TYR A   4  VAL A   5  0
SHEET    2   A 2 GLN A  12  PHE A  13 -1  O  PHE A  13   N  TYR A   4
CRYST1   51.084   33.664   29.435  90.00  90.00  90.00 P 1
SCALE1      0.019576  0.000000  0.000000        0.00000
SCALE2      0.000000  0.029705  0.000000        0.00000
SCALE3      0.000000  0.000000  0.033973        0.00000
ATOM      1  N   MET A   1      39.628  19.616  12.383  1.00  4.50           N
ATOM      2  CA  MET A   1      40.082  18.496  13.243  1.00  3.96           C
ATOM      3  C   MET A   1      38.919  17.903  14.026  1.00  2.83           C
ATOM      4  O   MET A   1      38.503  16.772  13.771  1.00  3.15           O
ATOM      5  CB  MET A   1      41.174  18.951  14.218  1.00  4.62           C
ATOM      6  CG  MET A   1      42.527  19.192  13.574  1.00  5.46           C
ATOM      7  SD  MET A   1      43.782  19.679  14.775  1.00  6.29           S
ATOM      8  CE  MET A   1      45.227  19.787  13.724  1.00  7.14           C
ATOM      9  H1  MET A   1      40.440  20.057  11.898  1.00  4.66           H
ATOM     10  H2  MET A   1      39.145  20.338  12.953  1.00  4.62           H
ATOM     11  H3  MET A   1      38.963  19.260  11.660  1.00  5.04           H
ATOM     12  HA  MET A   1      40.488  17.727  12.601  1.00  4.40           H
ATOM     13  HB2 MET A   1      40.858  19.871  14.687  1.00  4.77           H
ATOM     14  HB3 MET A   1      41.294  18.195  14.981  1.00  4.83           H
ATOM     15  HG2 MET A   1      42.845  18.281  13.089  1.00  5.77           H
ATOM     16  HG3 MET A   1      42.427  19.975  12.839  1.00  5.67           H
ATOM     17  HE1 MET A   1      45.405  18.828  13.260  1.00  7.30           H
ATOM     18  HE2 MET A   1      46.084  20.064  14.318  1.00  7.44           H
ATOM     19  HE3 MET A   1      45.061  20.532  12.961  1.00  7.52           H
ATOM     20  N   LYS A   2      38.392  18.662  14.982  1.00  2.07           N
ATOM     21  CA  LYS A   2      37.311  18.171  15.822  1.00  1.44           C
ATOM     22  C   LYS A   2      35.954  18.619  15.284  1.00  1.07           C
ATOM     23  O   LYS A   2      35.679  19.814  15.157  1.00  1.15           O
ATOM     24  CB  LYS A   2      37.494  18.631  17.276  1.00  2.11           C
ATOM     25  CG  LYS A   2      37.436  20.140  17.464  1.00  2.75           C
ATOM     26  CD  LYS A   2      37.625  20.532  18.918  1.00  3.31           C
ATOM     27  CE  LYS A   2      37.438  22.028  19.121  1.00  4.33           C
ATOM     28  NZ  LYS A   2      36.034  22.458  18.874  1.00  4.97           N
ATOM     29  H   LYS A   2      38.733  19.575  15.122  1.00  2.52           H
ATOM     30  HA  LYS A   2      37.345  17.092  15.794  1.00  1.78           H
ATOM     31  HB2 LYS A   2      36.716  18.189  17.881  1.00  2.38           H
ATOM     32  HB3 LYS A   2      38.453  18.285  17.630  1.00  2.79           H
ATOM     33  HG2 LYS A   2      38.216  20.596  16.876  1.00  3.31           H
ATOM     34  HG3 LYS A   2      36.473  20.497  17.127  1.00  2.97           H
ATOM     35  HD2 LYS A   2      36.900  20.004  19.520  1.00  3.33           H
ATOM     36  HD3 LYS A   2      38.622  20.257  19.228  1.00  3.54           H
ATOM     37  HE2 LYS A   2      37.706  22.275  20.138  1.00  4.70           H
ATOM     38  HE3 LYS A   2      38.091  22.552  18.440  1.00  4.68           H
ATOM     39  HZ1 LYS A   2      35.387  21.966  19.526  1.00  5.32           H
ATOM     40  HZ2 LYS A   2      35.752  22.240  17.892  1.00  5.02           H
ATOM     41  HZ3 LYS A   2      35.944  23.485  19.024  1.00  5.43           H
ATOM     42  N   PRO A   3      35.107  17.662  14.900  1.00  0.85           N
ATOM     43  CA  PRO A   3      33.736  17.933  14.509  1.00  0.57           C
ATOM     44  C   PRO A   3      32.772  17.826  15.685  1.00  0.42           C
ATOM     45  O   PRO A   3      33.168  17.505  16.809  1.00  0.58           O
ATOM     46  CB  PRO A   3      33.470  16.821  13.505  1.00  0.65           C
ATOM     47  CG  PRO A   3      34.236  15.659  14.039  1.00  1.14           C
ATOM     48  CD  PRO A   3      35.419  16.226  14.793  1.00  1.08           C
ATOM     49  HA  PRO A   3      33.631  18.895  14.029  1.00  0.64           H
ATOM     50  HB2 PRO A   3      32.408  16.613  13.463  1.00  0.67           H
ATOM     51  HB3 PRO A   3      33.830  17.114  12.528  1.00  0.88           H
ATOM     52  HG2 PRO A   3      33.609  15.085  14.707  1.00  1.43           H
ATOM     53  HG3 PRO A   3      34.571  15.044  13.222  1.00  1.54           H
ATOM     54  HD2 PRO A   3      35.492  15.773  15.771  1.00  1.26           H
ATOM     55  HD3 PRO A   3      36.332  16.070  14.235  1.00  1.20           H
ATOM     56  N   TYR A   4      31.513  18.093  15.411  1.00  0.26           N
ATOM     57  CA  TYR A   4      30.448  17.858  16.364  1.00  0.19           C
ATOM     58  C   TYR A   4      29.562  16.750  15.828  1.00  0.15           C
ATOM     59  O   TYR A   4      28.773  16.964  14.911  1.00  0.21           O
ATOM     60  CB  TYR A   4      29.640  19.135  16.624  1.00  0.27           C
ATOM     61  CG  TYR A   4      30.368  20.120  17.509  1.00  0.46           C
ATOM     62  CD1 TYR A   4      31.246  21.052  16.976  1.00  0.56           C
ATOM     63  CD2 TYR A   4      30.184  20.105  18.885  1.00  0.68           C
ATOM     64  CE1 TYR A   4      31.921  21.942  17.787  1.00  0.76           C
ATOM     65  CE2 TYR A   4      30.854  20.994  19.703  1.00  0.88           C
ATOM     66  CZ  TYR A   4      31.720  21.911  19.148  1.00  0.91           C
ATOM     67  OH  TYR A   4      32.395  22.797  19.956  1.00  1.11           O
ATOM     68  H   TYR A   4      31.284  18.446  14.524  1.00  0.36           H
ATOM     69  HA  TYR A   4      30.898  17.528  17.289  1.00  0.25           H
ATOM     70  HB2 TYR A   4      29.411  19.626  15.682  1.00  0.27           H
ATOM     71  HB3 TYR A   4      28.718  18.868  17.117  1.00  0.37           H
ATOM     72  HD1 TYR A   4      31.401  21.076  15.908  1.00  0.57           H
ATOM     73  HD2 TYR A   4      29.505  19.385  19.316  1.00  0.76           H
ATOM     74  HE1 TYR A   4      32.600  22.659  17.352  1.00  0.89           H
ATOM     75  HE2 TYR A   4      30.696  20.970  20.770  1.00  1.07           H
ATOM     76  HH  TYR A   4      32.824  22.312  20.675  1.00  1.47           H
ATOM     77  N   VAL A   5      29.732  15.559  16.372  1.00  0.22           N
ATOM     78  CA  VAL A   5      29.068  14.387  15.841  1.00  0.18           C
ATOM     79  C   VAL A   5      27.718  14.159  16.501  1.00  0.14           C
ATOM     80  O   VAL A   5      27.535  14.420  17.691  1.00  0.19           O
ATOM     81  CB  VAL A   5      29.939  13.124  16.000  1.00  0.25           C
ATOM     82  CG1 VAL A   5      31.305  13.341  15.370  1.00  0.35           C
ATOM     83  CG2 VAL A   5      30.078  12.725  17.464  1.00  0.30           C
ATOM     84  H   VAL A   5      30.318  15.464  17.156  1.00  0.34           H
ATOM     85  HA  VAL A   5      28.911  14.550  14.783  1.00  0.17           H
ATOM     86  HB  VAL A   5      29.453  12.321  15.472  1.00  0.25           H
ATOM     87 HG11 VAL A   5      31.820  14.132  15.893  1.00  1.09           H
ATOM     88 HG12 VAL A   5      31.180  13.619  14.335  1.00  1.02           H
ATOM     89 HG13 VAL A   5      31.881  12.430  15.433  1.00  1.04           H
ATOM     90 HG21 VAL A   5      30.692  11.839  17.542  1.00  1.09           H
ATOM     91 HG22 VAL A   5      29.099  12.523  17.876  1.00  1.04           H
ATOM     92 HG23 VAL A   5      30.541  13.531  18.014  1.00  1.00           H
ATOM     93  N   CYS A   6      26.770  13.704  15.702  1.00  0.12           N
ATOM     94  CA  CYS A   6      25.453  13.343  16.196  1.00  0.13           C
ATOM     95  C   CYS A   6      25.544  12.108  17.072  1.00  0.16           C
ATOM     96  O   CYS A   6      25.970  11.051  16.615  1.00  0.20           O
ATOM     97  CB  CYS A   6      24.516  13.057  15.032  1.00  0.13           C
ATOM     98  SG  CYS A   6      22.808  12.741  15.514  1.00  0.21           S
ATOM     99  H   CYS A   6      26.960  13.626  14.742  1.00  0.16           H
ATOM    100  HA  CYS A   6      25.067  14.168  16.777  1.00  0.17           H
ATOM    101  HB2 CYS A   6      24.512  13.898  14.365  1.00  0.19           H
ATOM    102  HB3 CYS A   6      24.871  12.183  14.502  1.00  0.14           H
ATOM    103  N   ILE A   7      25.112  12.240  18.312  1.00  0.21           N
ATOM    104  CA  ILE A   7      25.195  11.162  19.276  1.00  0.27           C
ATOM    105  C   ILE A   7      24.277  10.009  18.889  1.00  0.25           C
ATOM    106  O   ILE A   7      24.480   8.872  19.305  1.00  0.32           O
ATOM    107  CB  ILE A   7      24.813  11.669  20.683  1.00  0.36           C
ATOM    108  CG1 ILE A   7      25.467  13.027  20.954  1.00  0.49           C
ATOM    109  CG2 ILE A   7      25.231  10.665  21.737  1.00  0.46           C
ATOM    110  CD1 ILE A   7      26.941  13.066  20.613  1.00  0.67           C
ATOM    111  H   ILE A   7      24.742  13.094  18.602  1.00  0.26           H
ATOM    112  HA  ILE A   7      26.214  10.809  19.306  1.00  0.33           H
ATOM    113  HB  ILE A   7      23.740  11.779  20.726  1.00  0.37           H
ATOM    114 HG12 ILE A   7      24.970  13.783  20.363  1.00  0.84           H
ATOM    115 HG13 ILE A   7      25.360  13.268  22.002  1.00  0.81           H
ATOM    116 HG21 ILE A   7      26.300  10.530  21.691  1.00  1.22           H
ATOM    117 HG22 ILE A   7      24.739   9.724  21.545  1.00  1.03           H
ATOM    118 HG23 ILE A   7      24.950  11.030  22.711  1.00  1.09           H
ATOM    119 HD11 ILE A   7      27.065  12.811  19.567  1.00  1.33           H
ATOM    120 HD12 ILE A   7      27.473  12.355  21.226  1.00  1.27           H
ATOM    121 HD13 ILE A   7      27.326  14.058  20.792  1.00  1.21           H
ATOM    122  N   HIS A   8      23.278  10.301  18.070  1.00  0.21           N
ATOM    123  CA  HIS A   8      22.253   9.309  17.766  1.00  0.26           C
ATOM    124  C   HIS A   8      22.572   8.512  16.499  1.00  0.28           C
ATOM    125  O   HIS A   8      22.260   7.323  16.425  1.00  0.41           O
ATOM    126  CB  HIS A   8      20.879   9.975  17.639  1.00  0.31           C
ATOM    127  CG  HIS A   8      19.731   9.020  17.789  1.00  0.46           C
ATOM    128  ND1 HIS A   8      19.104   8.411  16.722  1.00  1.07           N
ATOM    129  CD2 HIS A   8      19.095   8.568  18.898  1.00  1.30           C
ATOM    130  CE1 HIS A   8      18.138   7.630  17.166  1.00  0.88           C
ATOM    131  NE2 HIS A   8      18.113   7.706  18.480  1.00  1.04           N
ATOM    132  H   HIS A   8      23.229  11.196  17.669  1.00  0.20           H
ATOM    133  HA  HIS A   8      22.220   8.621  18.596  1.00  0.32           H
ATOM    134  HB2 HIS A   8      20.783  10.732  18.405  1.00  0.34           H
ATOM    135  HB3 HIS A   8      20.800  10.441  16.663  1.00  0.33           H
ATOM    136  HD1 HIS A   8      19.340   8.520  15.769  1.00  1.90           H
ATOM    137  HD2 HIS A   8      19.314   8.840  19.920  1.00  2.22           H
ATOM    138  HE1 HIS A   8      17.482   7.028  16.556  1.00  1.40           H
ATOM    139  HE2 HIS A   8      17.587   7.112  19.069  1.00  1.56           H
ATOM    140  N   CYS A   9      23.186   9.146  15.499  1.00  0.20           N
ATOM    141  CA  CYS A   9      23.414   8.463  14.235  1.00  0.22           C
ATOM    142  C   CYS A   9      24.873   8.547  13.778  1.00  0.21           C
ATOM    143  O   CYS A   9      25.252   7.975  12.758  1.00  0.27           O
ATOM    144  CB  CYS A   9      22.482   9.037  13.175  1.00  0.22           C
ATOM    145  SG  CYS A   9      22.946  10.666  12.567  1.00  0.21           S
ATOM    146  H   CYS A   9      23.481  10.067  15.608  1.00  0.19           H
ATOM    147  HA  CYS A   9      23.166   7.424  14.380  1.00  0.27           H
ATOM    148  HB2 CYS A   9      22.456   8.377  12.340  1.00  0.26           H
ATOM    149  HB3 CYS A   9      21.487   9.119  13.597  1.00  0.25           H
ATOM    150  N   GLN A  10      25.679   9.272  14.555  1.00  0.19           N
ATOM    151  CA  GLN A  10      27.123   9.383  14.328  1.00  0.24           C
ATOM    152  C   GLN A  10      27.459  10.086  13.013  1.00  0.24           C
ATOM    153  O   GLN A  10      28.240   9.586  12.202  1.00  0.42           O
ATOM    154  CB  GLN A  10      27.789   8.009  14.394  1.00  0.31           C
ATOM    155  CG  GLN A  10      27.728   7.384  15.777  1.00  0.43           C
ATOM    156  CD  GLN A  10      28.411   6.037  15.843  1.00  0.84           C
ATOM    157  OE1 GLN A  10      27.786   5.000  15.621  1.00  1.52           O
ATOM    158  NE2 GLN A  10      29.698   6.041  16.148  1.00  1.58           N
ATOM    159  H   GLN A  10      25.292   9.746  15.318  1.00  0.19           H
ATOM    160  HA  GLN A  10      27.517   9.985  15.131  1.00  0.27           H
ATOM    161  HB2 GLN A  10      27.295   7.346  13.694  1.00  0.32           H
ATOM    162  HB3 GLN A  10      28.829   8.113  14.112  1.00  0.35           H
ATOM    163  HG2 GLN A  10      28.209   8.047  16.479  1.00  0.82           H
ATOM    164  HG3 GLN A  10      26.691   7.258  16.055  1.00  0.63           H
ATOM    165 HE21 GLN A  10      30.137   6.912  16.315  1.00  2.08           H
ATOM    166 HE22 GLN A  10      30.166   5.173  16.196  1.00  1.95           H
ATOM    167  N   ARG A  11      26.876  11.258  12.825  1.00  0.21           N
ATOM    168  CA  ARG A  11      27.183  12.103  11.685  1.00  0.26           C
ATOM    169  C   ARG A  11      28.029  13.281  12.147  1.00  0.24           C
ATOM    170  O   ARG A  11      27.664  13.968  13.099  1.00  0.32           O
ATOM    171  CB  ARG A  11      25.897  12.611  11.036  1.00  0.36           C
ATOM    172  CG  ARG A  11      25.189  11.581  10.175  1.00  0.76           C
ATOM    173  CD  ARG A  11      26.026  11.197   8.966  1.00  1.25           C
ATOM    174  NE  ARG A  11      25.291  10.335   8.036  1.00  1.88           N
ATOM    175  CZ  ARG A  11      25.627  10.168   6.755  1.00  2.81           C
ATOM    176  NH1 ARG A  11      26.705  10.764   6.271  1.00  3.28           N
ATOM    177  NH2 ARG A  11      24.892   9.392   5.966  1.00  3.67           N
ATOM    178  H   ARG A  11      26.228  11.573  13.479  1.00  0.31           H
ATOM    179  HA  ARG A  11      27.741  11.519  10.972  1.00  0.31           H
ATOM    180  HB2 ARG A  11      25.214  12.920  11.817  1.00  0.56           H
ATOM    181  HB3 ARG A  11      26.138  13.462  10.419  1.00  0.61           H
ATOM    182  HG2 ARG A  11      25.002  10.698  10.768  1.00  1.47           H
ATOM    183  HG3 ARG A  11      24.251  11.995   9.837  1.00  1.28           H
ATOM    184  HD2 ARG A  11      26.321  12.098   8.450  1.00  1.84           H
ATOM    185  HD3 ARG A  11      26.907  10.674   9.309  1.00  1.81           H
ATOM    186  HE  ARG A  11      24.498   9.871   8.384  1.00  2.11           H
ATOM    187 HH11 ARG A  11      27.266  11.343   6.864  1.00  3.12           H
ATOM    188 HH12 ARG A  11      26.968  10.634   5.305  1.00  4.08           H
ATOM    189 HH21 ARG A  11      24.073   8.930   6.334  1.00  3.83           H
ATOM    190 HH22 ARG A  11      25.139   9.270   5.000  1.00  4.37           H
ATOM    191  N   GLN A  12      29.153  13.508  11.484  1.00  0.26           N
ATOM    192  CA  GLN A  12      30.082  14.548  11.893  1.00  0.28           C
ATOM    193  C   GLN A  12      29.685  15.899  11.306  1.00  0.25           C
ATOM    194  O   GLN A  12      29.706  16.091  10.090  1.00  0.38           O
ATOM    195  CB  GLN A  12      31.495  14.182  11.447  1.00  0.42           C
ATOM    196  CG  GLN A  12      31.927  12.790  11.881  1.00  0.60           C
ATOM    197  CD  GLN A  12      33.315  12.421  11.402  1.00  0.86           C
ATOM    198  OE1 GLN A  12      34.184  13.280  11.241  1.00  1.64           O
ATOM    199  NE2 GLN A  12      33.533  11.135  11.178  1.00  1.38           N
ATOM    200  H   GLN A  12      29.371  12.963  10.696  1.00  0.34           H
ATOM    201  HA  GLN A  12      30.058  14.614  12.969  1.00  0.29           H
ATOM    202  HB2 GLN A  12      31.542  14.233  10.371  1.00  0.67           H
ATOM    203  HB3 GLN A  12      32.184  14.895  11.861  1.00  0.64           H
ATOM    204  HG2 GLN A  12      31.917  12.744  12.957  1.00  1.01           H
ATOM    205  HG3 GLN A  12      31.225  12.072  11.486  1.00  1.03           H
ATOM    206 HE21 GLN A  12      32.789  10.504  11.340  1.00  1.90           H
ATOM    207 HE22 GLN A  12      34.425  10.859  10.853  1.00  1.68           H
ATOM    208  N   PHE A  13      29.312  16.823  12.175  1.00  0.19           N
ATOM    209  CA  PHE A  13      28.953  18.174  11.758  1.00  0.19           C
ATOM    210  C   PHE A  13      30.013  19.178  12.185  1.00  0.20           C
ATOM    211  O   PHE A  13      30.964  18.827  12.884  1.00  0.36           O
ATOM    212  CB  PHE A  13      27.582  18.570  12.321  1.00  0.25           C
ATOM    213  CG  PHE A  13      26.439  18.027  11.513  1.00  0.35           C
ATOM    214  CD1 PHE A  13      26.062  16.697  11.617  1.00  0.42           C
ATOM    215  CD2 PHE A  13      25.748  18.848  10.638  1.00  0.49           C
ATOM    216  CE1 PHE A  13      25.017  16.202  10.864  1.00  0.55           C
ATOM    217  CE2 PHE A  13      24.702  18.357   9.882  1.00  0.63           C
ATOM    218  CZ  PHE A  13      24.337  17.032   9.994  1.00  0.64           C
ATOM    219  H   PHE A  13      29.271  16.589  13.130  1.00  0.23           H
ATOM    220  HA  PHE A  13      28.896  18.175  10.679  1.00  0.25           H
ATOM    221  HB2 PHE A  13      27.489  18.186  13.329  1.00  0.28           H
ATOM    222  HB3 PHE A  13      27.498  19.653  12.340  1.00  0.33           H
ATOM    223  HD1 PHE A  13      26.592  16.048  12.296  1.00  0.44           H
ATOM    224  HD2 PHE A  13      26.034  19.885  10.547  1.00  0.56           H
ATOM    225  HE1 PHE A  13      24.732  15.163  10.952  1.00  0.65           H
ATOM    226  HE2 PHE A  13      24.172  19.008   9.204  1.00  0.76           H
ATOM    227  HZ  PHE A  13      23.519  16.644   9.403  1.00  0.77           H
ATOM    228  N   ALA A  14      29.856  20.420  11.754  1.00  0.22           N
ATOM    229  CA  ALA A  14      30.828  21.460  12.063  1.00  0.23           C
ATOM    230  C   ALA A  14      30.493  22.175  13.359  1.00  0.21           C
ATOM    231  O   ALA A  14      31.321  22.277  14.259  1.00  0.41           O
ATOM    232  CB  ALA A  14      30.887  22.483  10.945  1.00  0.30           C
ATOM    233  H   ALA A  14      29.073  20.641  11.210  1.00  0.35           H
ATOM    234  HA  ALA A  14      31.800  20.999  12.153  1.00  0.26           H
ATOM    235  HB1 ALA A  14      30.971  21.981   9.994  1.00  1.05           H
ATOM    236  HB2 ALA A  14      31.744  23.124  11.091  1.00  0.99           H
ATOM    237  HB3 ALA A  14      29.985  23.082  10.963  1.00  1.03           H
ATOM    238  N   ASP A  15      29.271  22.667  13.440  1.00  0.19           N
ATOM    239  CA  ASP A  15      28.879  23.557  14.515  1.00  0.24           C
ATOM    240  C   ASP A  15      27.974  22.846  15.508  1.00  0.21           C
ATOM    241  O   ASP A  15      27.184  21.975  15.137  1.00  0.20           O
ATOM    242  CB  ASP A  15      28.149  24.776  13.946  1.00  0.35           C
ATOM    243  CG  ASP A  15      28.974  25.554  12.939  1.00  1.21           C
ATOM    244  OD1 ASP A  15      28.906  25.231  11.735  1.00  1.70           O
ATOM    245  OD2 ASP A  15      29.682  26.501  13.344  1.00  1.93           O
ATOM    246  H   ASP A  15      28.613  22.419  12.760  1.00  0.31           H
ATOM    247  HA  ASP A  15      29.772  23.885  15.023  1.00  0.30           H
ATOM    248  HB2 ASP A  15      27.239  24.454  13.464  1.00  0.71           H
ATOM    249  HB3 ASP A  15      27.904  25.436  14.756  1.00  0.65           H
ATOM    250  N   PRO A  16      28.082  23.214  16.794  1.00  0.26           N
ATOM    251  CA  PRO A  16      27.233  22.666  17.849  1.00  0.28           C
ATOM    252  C   PRO A  16      25.786  23.099  17.672  1.00  0.23           C
ATOM    253  O   PRO A  16      24.859  22.389  18.065  1.00  0.27           O
ATOM    254  CB  PRO A  16      27.821  23.248  19.139  1.00  0.39           C
ATOM    255  CG  PRO A  16      28.560  24.468  18.713  1.00  0.53           C
ATOM    256  CD  PRO A  16      29.047  24.198  17.316  1.00  0.34           C
ATOM    257  HA  PRO A  16      27.285  21.587  17.878  1.00  0.30           H
ATOM    258  HB2 PRO A  16      27.021  23.488  19.825  1.00  0.53           H
ATOM    259  HB3 PRO A  16      28.484  22.525  19.591  1.00  0.61           H
ATOM    260  HG2 PRO A  16      27.896  25.320  18.720  1.00  0.88           H
ATOM    261  HG3 PRO A  16      29.396  24.639  19.373  1.00  0.87           H
ATOM    262  HD2 PRO A  16      29.027  25.105  16.727  1.00  0.49           H
ATOM    263  HD3 PRO A  16      30.043  23.782  17.339  1.00  0.45           H
ATOM    264  N   GLY A  17      25.602  24.268  17.063  1.00  0.23           N
ATOM    265  CA  GLY A  17      24.274  24.740  16.741  1.00  0.28           C
ATOM    266  C   GLY A  17      23.595  23.840  15.735  1.00  0.22           C
ATOM    267  O   GLY A  17      22.377  23.663  15.765  1.00  0.26           O
ATOM    268  H   GLY A  17      26.384  24.820  16.836  1.00  0.25           H
ATOM    269  HA2 GLY A  17      23.681  24.767  17.642  1.00  0.34           H
ATOM    270  HA3 GLY A  17      24.343  25.734  16.329  1.00  0.38           H
ATOM    271  N   ALA A  18      24.386  23.249  14.851  1.00  0.20           N
ATOM    272  CA  ALA A  18      23.850  22.337  13.863  1.00  0.18           C
ATOM    273  C   ALA A  18      23.506  21.005  14.491  1.00  0.14           C
ATOM    274  O   ALA A  18      22.608  20.319  14.023  1.00  0.18           O
ATOM    275  CB  ALA A  18      24.817  22.118  12.723  1.00  0.22           C
ATOM    276  H   ALA A  18      25.348  23.432  14.866  1.00  0.23           H
ATOM    277  HA  ALA A  18      22.948  22.777  13.460  1.00  0.20           H
ATOM    278  HB1 ALA A  18      24.380  21.413  12.028  1.00  1.07           H
ATOM    279  HB2 ALA A  18      25.742  21.717  13.109  1.00  1.03           H
ATOM    280  HB3 ALA A  18      25.004  23.054  12.222  1.00  1.04           H
ATOM    281  N   LEU A  19      24.213  20.631  15.556  1.00  0.12           N
ATOM    282  CA  LEU A  19      23.915  19.396  16.237  1.00  0.14           C
ATOM    283  C   LEU A  19      22.587  19.510  16.918  1.00  0.14           C
ATOM    284  O   LEU A  19      21.841  18.543  16.996  1.00  0.18           O
ATOM    285  CB  LEU A  19      24.976  19.039  17.272  1.00  0.18           C
ATOM    286  CG  LEU A  19      26.146  18.209  16.760  1.00  0.24           C
ATOM    287  CD1 LEU A  19      26.953  17.684  17.932  1.00  1.10           C
ATOM    288  CD2 LEU A  19      25.652  17.059  15.892  1.00  0.82           C
ATOM    289  H   LEU A  19      24.924  21.200  15.899  1.00  0.13           H
ATOM    290  HA  LEU A  19      23.862  18.613  15.496  1.00  0.15           H
ATOM    291  HB2 LEU A  19      25.371  19.960  17.682  1.00  0.24           H
ATOM    292  HB3 LEU A  19      24.495  18.483  18.068  1.00  0.28           H
ATOM    293  HG  LEU A  19      26.793  18.834  16.161  1.00  0.81           H
ATOM    294 HD11 LEU A  19      27.342  18.514  18.501  1.00  1.60           H
ATOM    295 HD12 LEU A  19      27.771  17.081  17.566  1.00  1.85           H
ATOM    296 HD13 LEU A  19      26.317  17.082  18.563  1.00  1.56           H
ATOM    297 HD21 LEU A  19      26.491  16.443  15.602  1.00  1.49           H
ATOM    298 HD22 LEU A  19      25.174  17.455  15.009  1.00  1.32           H
ATOM    299 HD23 LEU A  19      24.945  16.465  16.450  1.00  1.51           H
ATOM    300  N   GLN A  20      22.273  20.698  17.400  1.00  0.15           N
ATOM    301  CA  GLN A  20      21.037  20.857  18.108  1.00  0.20           C
ATOM    302  C   GLN A  20      19.889  20.895  17.128  1.00  0.15           C
ATOM    303  O   GLN A  20      18.802  20.381  17.388  1.00  0.17           O
ATOM    304  CB  GLN A  20      21.069  22.070  19.052  1.00  0.31           C
ATOM    305  CG  GLN A  20      20.772  23.422  18.413  1.00  1.12           C
ATOM    306  CD  GLN A  20      19.288  23.746  18.339  1.00  1.61           C
ATOM    307  OE1 GLN A  20      18.844  24.455  17.437  1.00  2.23           O
ATOM    308  NE2 GLN A  20      18.512  23.233  19.283  1.00  2.20           N
ATOM    309  H   GLN A  20      22.885  21.458  17.286  1.00  0.16           H
ATOM    310  HA  GLN A  20      20.940  19.974  18.673  1.00  0.25           H
ATOM    311  HB2 GLN A  20      20.354  21.911  19.844  1.00  1.11           H
ATOM    312  HB3 GLN A  20      22.054  22.123  19.484  1.00  1.06           H
ATOM    313  HG2 GLN A  20      21.260  24.192  18.993  1.00  1.73           H
ATOM    314  HG3 GLN A  20      21.174  23.424  17.411  1.00  1.77           H
ATOM    315 HE21 GLN A  20      18.928  22.671  19.977  1.00  2.54           H
ATOM    316 HE22 GLN A  20      17.550  23.443  19.260  1.00  2.66           H
ATOM    317  N   ARG A  21      20.173  21.464  15.979  1.00  0.15           N
ATOM    318  CA  ARG A  21      19.245  21.440  14.860  1.00  0.19           C
ATOM    319  C   ARG A  21      19.097  20.005  14.371  1.00  0.15           C
ATOM    320  O   ARG A  21      18.019  19.568  13.974  1.00  0.18           O
ATOM    321  CB  ARG A  21      19.756  22.326  13.722  1.00  0.28           C
ATOM    322  CG  ARG A  21      18.796  23.434  13.322  1.00  0.61           C
ATOM    323  CD  ARG A  21      18.610  24.442  14.443  1.00  1.45           C
ATOM    324  NE  ARG A  21      17.778  25.571  14.033  1.00  1.99           N
ATOM    325  CZ  ARG A  21      17.809  26.770  14.611  1.00  2.94           C
ATOM    326  NH1 ARG A  21      18.581  26.984  15.671  1.00  3.60           N
ATOM    327  NH2 ARG A  21      17.051  27.749  14.133  1.00  3.59           N
ATOM    328  H   ARG A  21      21.043  21.907  15.885  1.00  0.16           H
ATOM    329  HA  ARG A  21      18.288  21.803  15.202  1.00  0.24           H
ATOM    330  HB2 ARG A  21      20.686  22.780  14.028  1.00  0.50           H
ATOM    331  HB3 ARG A  21      19.939  21.707  12.855  1.00  0.49           H
ATOM    332  HG2 ARG A  21      19.191  23.944  12.455  1.00  1.18           H
ATOM    333  HG3 ARG A  21      17.838  22.997  13.081  1.00  1.19           H
ATOM    334  HD2 ARG A  21      18.140  23.948  15.280  1.00  2.10           H
ATOM    335  HD3 ARG A  21      19.581  24.812  14.740  1.00  2.01           H
ATOM    336  HE  ARG A  21      17.170  25.428  13.268  1.00  2.08           H
ATOM    337 HH11 ARG A  21      19.136  26.239  16.048  1.00  3.49           H
ATOM    338 HH12 ARG A  21      18.624  27.900  16.093  1.00  4.43           H
ATOM    339 HH21 ARG A  21      16.459  27.584  13.342  1.00  3.58           H
ATOM    340 HH22 ARG A  21      17.066  28.664  14.564  1.00  4.31           H
ATOM    341  N   HIS A  22      20.197  19.274  14.439  1.00  0.12           N
ATOM    342  CA  HIS A  22      20.252  17.904  13.950  1.00  0.15           C
ATOM    343  C   HIS A  22      19.491  16.963  14.855  1.00  0.13           C
ATOM    344  O   HIS A  22      18.688  16.148  14.399  1.00  0.13           O
ATOM    345  CB  HIS A  22      21.698  17.442  13.891  1.00  0.21           C
ATOM    346  CG  HIS A  22      21.896  16.157  13.173  1.00  0.24           C
ATOM    347  ND1 HIS A  22      21.768  15.999  11.815  1.00  0.37           N
ATOM    348  CD2 HIS A  22      22.221  14.950  13.664  1.00  0.24           C
ATOM    349  CE1 HIS A  22      22.017  14.719  11.526  1.00  0.39           C
ATOM    350  NE2 HIS A  22      22.300  14.029  12.624  1.00  0.29           N
ATOM    351  H   HIS A  22      21.018  19.677  14.824  1.00  0.12           H
ATOM    352  HA  HIS A  22      19.828  17.875  12.958  1.00  0.19           H
ATOM    353  HB2 HIS A  22      22.281  18.187  13.407  1.00  0.26           H
ATOM    354  HB3 HIS A  22      22.059  17.309  14.905  1.00  0.23           H
ATOM    355  HD1 HIS A  22      21.523  16.705  11.167  1.00  0.46           H
ATOM    356  HD2 HIS A  22      22.395  14.718  14.704  1.00  0.29           H
ATOM    357  HE1 HIS A  22      21.991  14.301  10.532  1.00  0.51           H
ATOM    358  N   VAL A  23      19.769  17.056  16.139  1.00  0.17           N
ATOM    359  CA  VAL A  23      19.221  16.112  17.082  1.00  0.22           C
ATOM    360  C   VAL A  23      17.697  16.230  17.136  1.00  0.24           C
ATOM    361  O   VAL A  23      16.983  15.224  17.223  1.00  0.28           O
ATOM    362  CB  VAL A  23      19.830  16.283  18.495  1.00  0.30           C
ATOM    363  CG1 VAL A  23      19.119  15.399  19.511  1.00  0.34           C
ATOM    364  CG2 VAL A  23      21.321  15.966  18.471  1.00  0.33           C
ATOM    365  H   VAL A  23      20.365  17.772  16.456  1.00  0.19           H
ATOM    366  HA  VAL A  23      19.491  15.139  16.709  1.00  0.24           H
ATOM    367  HB  VAL A  23      19.710  17.312  18.798  1.00  0.32           H
ATOM    368 HG11 VAL A  23      18.072  15.666  19.551  1.00  0.99           H
ATOM    369 HG12 VAL A  23      19.564  15.540  20.484  1.00  1.04           H
ATOM    370 HG13 VAL A  23      19.216  14.361  19.219  1.00  1.08           H
ATOM    371 HG21 VAL A  23      21.739  16.124  19.455  1.00  1.08           H
ATOM    372 HG22 VAL A  23      21.814  16.614  17.761  1.00  1.09           H
ATOM    373 HG23 VAL A  23      21.467  14.937  18.179  1.00  1.04           H
ATOM    374  N   ARG A  24      17.202  17.462  17.038  1.00  0.24           N
ATOM    375  CA  ARG A  24      15.767  17.697  17.037  1.00  0.33           C
ATOM    376  C   ARG A  24      15.142  17.183  15.738  1.00  0.27           C
ATOM    377  O   ARG A  24      13.942  16.916  15.677  1.00  0.36           O
ATOM    378  CB  ARG A  24      15.455  19.181  17.247  1.00  0.50           C
ATOM    379  CG  ARG A  24      15.978  20.087  16.151  1.00  0.95           C
ATOM    380  CD  ARG A  24      15.552  21.525  16.379  1.00  1.42           C
ATOM    381  NE  ARG A  24      14.096  21.663  16.393  1.00  1.74           N
ATOM    382  CZ  ARG A  24      13.448  22.797  16.136  1.00  2.19           C
ATOM    383  NH1 ARG A  24      14.129  23.909  15.872  1.00  2.48           N
ATOM    384  NH2 ARG A  24      12.123  22.816  16.162  1.00  2.96           N
ATOM    385  H   ARG A  24      17.815  18.225  16.965  1.00  0.22           H
ATOM    386  HA  ARG A  24      15.348  17.136  17.860  1.00  0.42           H
ATOM    387  HB2 ARG A  24      14.384  19.307  17.300  1.00  1.09           H
ATOM    388  HB3 ARG A  24      15.891  19.498  18.182  1.00  1.02           H
ATOM    389  HG2 ARG A  24      17.059  20.039  16.143  1.00  1.35           H
ATOM    390  HG3 ARG A  24      15.593  19.750  15.202  1.00  1.56           H
ATOM    391  HD2 ARG A  24      15.945  21.858  17.329  1.00  1.98           H
ATOM    392  HD3 ARG A  24      15.955  22.139  15.588  1.00  2.03           H
ATOM    393  HE  ARG A  24      13.564  20.848  16.606  1.00  2.19           H
ATOM    394 HH11 ARG A  24      15.126  23.896  15.871  1.00  2.58           H
ATOM    395 HH12 ARG A  24      13.642  24.770  15.664  1.00  3.00           H
ATOM    396 HH21 ARG A  24      11.615  21.978  16.376  1.00  3.40           H
ATOM    397 HH22 ARG A  24      11.619  23.669  15.961  1.00  3.34           H
ATOM    398  N   ILE A  25      15.968  17.028  14.704  1.00  0.21           N
ATOM    399  CA  ILE A  25      15.534  16.401  13.465  1.00  0.22           C
ATOM    400  C   ILE A  25      15.181  14.934  13.712  1.00  0.19           C
ATOM    401  O   ILE A  25      14.250  14.397  13.106  1.00  0.27           O
ATOM    402  CB  ILE A  25      16.625  16.507  12.370  1.00  0.24           C
ATOM    403  CG1 ILE A  25      16.682  17.919  11.794  1.00  0.31           C
ATOM    404  CG2 ILE A  25      16.410  15.503  11.265  1.00  0.29           C
ATOM    405  CD1 ILE A  25      15.353  18.427  11.275  1.00  1.30           C
ATOM    406  H   ILE A  25      16.892  17.339  14.778  1.00  0.23           H
ATOM    407  HA  ILE A  25      14.650  16.921  13.120  1.00  0.29           H
ATOM    408  HB  ILE A  25      17.575  16.287  12.832  1.00  0.23           H
ATOM    409 HG12 ILE A  25      17.019  18.590  12.557  1.00  0.95           H
ATOM    410 HG13 ILE A  25      17.384  17.934  10.975  1.00  0.92           H
ATOM    411 HG21 ILE A  25      17.142  15.669  10.493  1.00  1.04           H
ATOM    412 HG22 ILE A  25      15.420  15.625  10.860  1.00  1.02           H
ATOM    413 HG23 ILE A  25      16.524  14.504  11.662  1.00  1.08           H
ATOM    414 HD11 ILE A  25      14.638  18.459  12.084  1.00  1.88           H
ATOM    415 HD12 ILE A  25      14.993  17.764  10.503  1.00  1.81           H
ATOM    416 HD13 ILE A  25      15.481  19.419  10.868  1.00  1.93           H
ATOM    417  N   HIS A  26      15.916  14.289  14.621  1.00  0.14           N
ATOM    418  CA  HIS A  26      15.622  12.904  14.977  1.00  0.16           C
ATOM    419  C   HIS A  26      14.301  12.805  15.720  1.00  0.24           C
ATOM    420  O   HIS A  26      13.558  11.838  15.545  1.00  0.29           O
ATOM    421  CB  HIS A  26      16.727  12.279  15.829  1.00  0.19           C
ATOM    422  CG  HIS A  26      17.908  11.805  15.043  1.00  0.21           C
ATOM    423  ND1 HIS A  26      17.821  11.085  13.869  1.00  0.26           N
ATOM    424  CD2 HIS A  26      19.228  11.961  15.288  1.00  0.21           C
ATOM    425  CE1 HIS A  26      19.074  10.833  13.450  1.00  0.29           C
ATOM    426  NE2 HIS A  26      19.958  11.346  14.279  1.00  0.25           N
ATOM    427  H   HIS A  26      16.651  14.759  15.068  1.00  0.17           H
ATOM    428  HA  HIS A  26      15.538  12.345  14.056  1.00  0.18           H
ATOM    429  HB2 HIS A  26      17.077  13.011  16.541  1.00  0.20           H
ATOM    430  HB3 HIS A  26      16.322  11.431  16.362  1.00  0.24           H
ATOM    431  HD1 HIS A  26      16.988  10.809  13.416  1.00  0.30           H
ATOM    432  HD2 HIS A  26      19.658  12.482  16.131  1.00  0.21           H
ATOM    433  HE1 HIS A  26      19.327  10.289  12.549  1.00  0.34           H
ATOM    434  N   THR A  27      14.009  13.793  16.561  1.00  0.41           N
ATOM    435  CA  THR A  27      12.720  13.826  17.230  1.00  0.60           C
ATOM    436  C   THR A  27      11.615  14.113  16.225  1.00  0.87           C
ATOM    437  O   THR A  27      10.533  13.526  16.291  1.00  1.47           O
ATOM    438  CB  THR A  27      12.660  14.875  18.357  1.00  0.98           C
ATOM    439  OG1 THR A  27      13.881  15.622  18.419  1.00  1.68           O
ATOM    440  CG2 THR A  27      12.389  14.211  19.698  1.00  1.30           C
ATOM    441  H   THR A  27      14.667  14.500  16.735  1.00  0.47           H
ATOM    442  HA  THR A  27      12.549  12.849  17.664  1.00  0.50           H
ATOM    443  HB  THR A  27      11.847  15.555  18.146  1.00  1.64           H
ATOM    444  HG1 THR A  27      13.674  16.569  18.329  1.00  2.24           H
ATOM    445 HG21 THR A  27      12.382  14.961  20.476  1.00  1.74           H
ATOM    446 HG22 THR A  27      13.161  13.487  19.904  1.00  1.85           H
ATOM    447 HG23 THR A  27      11.429  13.716  19.666  1.00  1.81           H
ATOM    448  N   GLY A  28      11.901  15.017  15.292  1.00  0.92           N
ATOM    449  CA  GLY A  28      10.947  15.361  14.255  1.00  1.31           C
ATOM    450  C   GLY A  28       9.854  16.271  14.768  1.00  1.76           C
ATOM    451  O   GLY A  28       9.647  17.369  14.251  1.00  2.36           O
ATOM    452  H   GLY A  28      12.775  15.468  15.316  1.00  1.10           H
ATOM    453  HA2 GLY A  28      11.467  15.857  13.449  1.00  1.63           H
ATOM    454  HA3 GLY A  28      10.498  14.455  13.877  1.00  1.47           H
ATOM    455  N   GLU A  29       9.168  15.804  15.800  1.00  1.83           N
ATOM    456  CA  GLU A  29       8.078  16.532  16.416  1.00  2.54           C
ATOM    457  C   GLU A  29       8.591  17.794  17.097  1.00  3.12           C
ATOM    458  O   GLU A  29       7.884  18.799  17.195  1.00  3.73           O
ATOM    459  CB  GLU A  29       7.392  15.620  17.424  1.00  2.69           C
ATOM    460  CG  GLU A  29       7.129  14.231  16.871  1.00  2.80           C
ATOM    461  CD  GLU A  29       6.221  13.410  17.750  1.00  3.32           C
ATOM    462  OE1 GLU A  29       6.720  12.766  18.697  1.00  3.55           O
ATOM    463  OE2 GLU A  29       5.000  13.399  17.493  1.00  3.92           O
ATOM    464  H   GLU A  29       9.397  14.919  16.155  1.00  1.60           H
ATOM    465  HA  GLU A  29       7.375  16.804  15.646  1.00  2.81           H
ATOM    466  HB2 GLU A  29       8.018  15.528  18.300  1.00  2.65           H
ATOM    467  HB3 GLU A  29       6.454  16.057  17.706  1.00  3.21           H
ATOM    468  HG2 GLU A  29       6.674  14.327  15.897  1.00  3.13           H
ATOM    469  HG3 GLU A  29       8.074  13.716  16.774  1.00  2.87           H
ATOM    470  N   LYS A  30       9.827  17.734  17.558  1.00  3.18           N
ATOM    471  CA  LYS A  30      10.469  18.872  18.187  1.00  3.99           C
ATOM    472  C   LYS A  30      11.951  18.903  17.831  1.00  4.09           C
ATOM    473  O   LYS A  30      12.323  19.699  16.941  1.00  4.21           O
ATOM    474  CB  LYS A  30      10.258  18.853  19.708  1.00  4.56           C
ATOM    475  CG  LYS A  30      10.538  17.511  20.366  1.00  5.19           C
ATOM    476  CD  LYS A  30      10.323  17.582  21.869  1.00  5.78           C
ATOM    477  CE  LYS A  30      10.584  16.245  22.534  1.00  6.49           C
ATOM    478  NZ  LYS A  30      10.368  16.315  24.001  1.00  6.91           N
ATOM    479  H   LYS A  30      10.330  16.899  17.467  1.00  2.84           H
ATOM    480  HA  LYS A  30      10.008  19.762  17.787  1.00  4.35           H
ATOM    481  HB2 LYS A  30      10.909  19.587  20.158  1.00  4.57           H
ATOM    482  HB3 LYS A  30       9.233  19.123  19.917  1.00  4.90           H
ATOM    483  HG2 LYS A  30       9.874  16.769  19.948  1.00  5.36           H
ATOM    484  HG3 LYS A  30      11.563  17.232  20.168  1.00  5.46           H
ATOM    485  HD2 LYS A  30      10.998  18.315  22.285  1.00  5.95           H
ATOM    486  HD3 LYS A  30       9.303  17.877  22.063  1.00  5.89           H
ATOM    487  HE2 LYS A  30       9.914  15.509  22.112  1.00  6.67           H
ATOM    488  HE3 LYS A  30      11.605  15.953  22.341  1.00  6.86           H
ATOM    489  HZ1 LYS A  30       9.388  16.608  24.204  1.00  7.07           H
ATOM    490  HZ2 LYS A  30      11.021  17.007  24.427  1.00  6.85           H
ATOM    491  HZ3 LYS A  30      10.536  15.383  24.435  1.00  7.40           H
TER
HETATM  492 ZN    ZN A 101      21.619  12.238  13.602  1.00  0.22          Zn
TER
END
"""
def normalize(x):
  r = []
  for x_ in x:
    x_ = list(x_)
    x_.sort()
    r.append(x_)
  r.sort()
  return r

def run():
  """
  Exercise buffer region of cluster.
  """
  bc_clusters = [[1, 2],
                 [3, 4, 5, 13, 14, 15, 16, 17, 18, 19, 20, 21],
                 [6, 7, 8, 9, 10, 11, 12, 22, 23, 26, 31],
                 [24, 25, 27, 28, 29, 30]]
  bc_qms = [
    [1, 2, 3, 4],
    [1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
    [3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 31],
    [20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]]

  qms_calculated = []
  for i in range(len(bc_clusters)):
    pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
    ph = pdb_inp.construct_hierarchy()
    core_atoms, qm_atoms, qm_molecules = pair_interaction.run(ph, bc_clusters[i])
    qms_calculated.append(list(qm_molecules))
  bc_qms = normalize(bc_qms)
  qms_calculated = normalize(qms_calculated)
  assert approx_equal(bc_qms, qms_calculated)

def check_buffer(clusters, qms):
  qms_calculated = []
  for i in range(len(clusters)):
    pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
    ph = pdb_inp.construct_hierarchy()
    core_atoms,qm_atoms, qm_molecules = pair_interaction.run(ph,clusters[i])
    qms_calculated.append(list(qm_molecules))
    assert(len(set(qms[i])-set(qm_molecules))==0), len(set(qms[i])-set(qm_molecules))

if(__name__ == "__main__"):
  run()
