*** Settings ***
Documentation       Check EMC DataDomain in SNMP

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Ctn Generic Suite Setup
Test Timeout        120s


*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=storage::emc::datadomain::snmp::plugin


*** Test Cases ***
filesystems ${tc}
    [Tags]    snmp  storage
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=filesystems
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=storage/emc/datadomain/snmp/slim-datadomain
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                             expected_result    --
            ...      1     --verbose                                                                                 OK: All filesystems are ok | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;;;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;;;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;;;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;;;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;;;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;;;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;;;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;;;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;;;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;;;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;;;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;;;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;;;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;;;0; checking filesystem '/ddvar' space usage total: 46.60 GB used: 10.50 GB (22.53%) free: 36.10 GB (77.47%) space cleanable: 0.00B checking filesystem '/ddvar/core' space usage total: 544.70 GB used: 102.40 MB (0.02%) free: 544.60 GB (99.98%) space cleanable: 0.00B checking filesystem 'Anonymized 056' space usage total: 82.09 TB used: 48.50 TB (59.08%) free: 33.59 TB (40.92%) space cleanable: 135.20GB checking filesystem 'Anonymized 157' space usage total: 703.50 GB used: 497.30 GB (70.69%) free: 206.20 GB (29.31%) space cleanable: 0.00B checking filesystem 'Anonymized 246' space usage total: 899.38 TB used: 899.38 TB (100.00%) free: 0.00 B (0.00%) space cleanable: 0.00B 
            ...      2     --filter-fs-name='Anonymized 056'                                                         OK: filesystem 'Anonymized 056' space usage total: 82.09 TB used: 48.50 TB (59.08%) free: 33.59 TB (40.92%) - space cleanable: 135.20GB | 'filesystems.detected.count'=1;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0;
            ...      3     --warning-fs-detected --critical-fs-detected                                              OK: All filesystems are ok | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;;;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;;;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;;;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;;;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;;;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;;;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;;;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;;;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;;;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;;;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;;;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;;;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;;;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;;;0;
            ...      4     --warning-space-usage=100 --critical-space-usage=50                                       CRITICAL: filesystem '/ddvar' space usage total: 46.60 GB used: 10.50 GB (22.53%) free: 36.10 GB (77.47%) - filesystem '/ddvar/core' space usage total: 544.70 GB used: 102.40 MB (0.02%) free: 544.60 GB (99.98%) - filesystem 'Anonymized 056' space usage total: 82.09 TB used: 48.50 TB (59.08%) free: 33.59 TB (40.92%) - filesystem 'Anonymized 157' space usage total: 703.50 GB used: 497.30 GB (70.69%) free: 206.20 GB (29.31%) - filesystem 'Anonymized 246' space usage total: 899.38 TB used: 899.38 TB (100.00%) free: 0.00 B (0.00%) | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;0:100;0:50;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;;;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;;;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;;;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;0:100;0:50;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;;;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;;;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;0:100;0:50;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;0:100;0:50;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;;;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;;;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;0:100;0:50;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;;;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;;;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;;;0;
            ...      5     --warning-space-usage-free=0 --critical-space-usage-free=0                                CRITICAL: filesystem '/ddvar' space usage total: 46.60 GB used: 10.50 GB (22.53%) free: 36.10 GB (77.47%) - filesystem '/ddvar/core' space usage total: 544.70 GB used: 102.40 MB (0.02%) free: 544.60 GB (99.98%) - filesystem 'Anonymized 056' space usage total: 82.09 TB used: 48.50 TB (59.08%) free: 33.59 TB (40.92%) - filesystem 'Anonymized 157' space usage total: 703.50 GB used: 497.30 GB (70.69%) free: 206.20 GB (29.31%) | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;;;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;0:0;0:0;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;;;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;;;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;;;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;0:0;0:0;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;;;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;0:0;0:0;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;;;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;0:0;0:0;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;;;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;;;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;0:0;0:0;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;;;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;;;0;
            ...      6     --warning-space-usage-prct=20 --critical-space-usage-prct=80                              CRITICAL: filesystem 'Anonymized 246' space usage total: 899.38 TB used: 899.38 TB (100.00%) free: 0.00 B (0.00%) WARNING: filesystem '/ddvar' space usage total: 46.60 GB used: 10.50 GB (22.53%) free: 36.10 GB (77.47%) - filesystem 'Anonymized 056' space usage total: 82.09 TB used: 48.50 TB (59.08%) free: 33.59 TB (40.92%) - filesystem 'Anonymized 157' space usage total: 703.50 GB used: 497.30 GB (70.69%) free: 206.20 GB (29.31%) | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;;;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;;;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;0:20;0:80;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;;;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;;;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;;;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;0:20;0:80;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;0:20;0:80;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;;;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;;;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;0:20;0:80;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;;;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;;;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;0:20;0:80;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;;;0;
            ...      7     --warning-space-precompression-usage=50 --critical-space-precompression-usage=100         OK: All filesystems are ok | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;;;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;;;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;;;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;;;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;;;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;;;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;;;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;;;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;;;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;;;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;;;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;;;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;;;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;;;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;;;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;;;0;
            ...      8     --warning-space-cleanable=80 --critical-space-cleanable=20                                CRITICAL: filesystem 'Anonymized 056' space cleanable: 135.20GB | 'filesystems.detected.count'=5;;;0; '/ddvar#filesystem.space.usage.bytes'=11274289152B;;;0;50036368998 '/ddvar#filesystem.space.free.bytes'=38762079846B;;;0;50036368998 '/ddvar#filesystem.space.usage.percentage'=22.53%;;;0;100 '/ddvar#filesystem.space.cleanable.bytes'=0B;0:80;0:20;0; '/ddvar/core#filesystem.space.usage.bytes'=107374182B;;;0;584867171532 '/ddvar/core#filesystem.space.free.bytes'=584759797350B;;;0;584867171532 '/ddvar/core#filesystem.space.usage.percentage'=0.02%;;;0;100 '/ddvar/core#filesystem.space.cleanable.bytes'=0B;0:80;0:20;0; 'Anonymized 056#filesystem.space.usage.bytes'=53328461430784B;;;0;90263462189465 'Anonymized 056#filesystem.space.free.bytes'=36935000758681B;;;0;90263462189465 'Anonymized 056#filesystem.space.usage.percentage'=59.08%;;;0;100 'Anonymized 056#filesystem.space.cleanable.bytes'=145169894604B;0:80;0:20;0; 'Anonymized 157#filesystem.space.usage.bytes'=533971809075B;;;0;755377373183 'Anonymized 157#filesystem.space.free.bytes'=221405564108B;;;0;755377373183 'Anonymized 157#filesystem.space.usage.percentage'=70.69%;;;0;100 'Anonymized 157#filesystem.space.cleanable.bytes'=0B;0:80;0:20;0; 'Anonymized 246#filesystem.space.usage.bytes'=988878746314342B;;;0;988878746314342 'Anonymized 246#filesystem.space.free.bytes'=0B;;;0;988878746314342 'Anonymized 246#filesystem.space.usage.percentage'=100.00%;;;0;100 'Anonymized 246#filesystem.space.cleanable.bytes'=0B;0:80;0:20;0;
