/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 67023be2-7621-43a0-b344-c6a28574576d
 * 
 */


#ifndef   _CM_CONFIGARCHSOURCE_H_
#define   _CM_CONFIGARCHSOURCE_H_

#include "ConfigSource.h"
#include <getopt++/StringOption.h>

class ConfigArchSource : public ConfigSource
{

public:
  static ConfigArchSource* Create(Path const &location) throw (std::exception *);
  ConfigArchSource();
  ConfigArchSource(std::string const &url);
  ~ConfigArchSource(){}
  virtual std::string url(bool const &) const;

  virtual void get (std::string const &) const throw (std::exception *);
  virtual void update (std::string const &) const throw (std::exception *);
  virtual int missing (std::string const &) const throw(std::exception *);
  virtual int changes (std::string const &) const throw(std::exception *);
  virtual void ignore (ConfigSource const *, std::string const &) const throw (std::exception *);

  virtual std::string treeVersion(std::string const &where) const ;

private:
  std::string archive() const;
  void maybeRegister() const;
  std::string theUrl;
  std::string location;
  static StringOption buildOptions;
  static char const * dummyTaggingText;
};

#endif /* _CM_CONFIGARCHSOURCE_H_ */
