struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 336,
		.content = "Processor\t: AArch64 Processor rev 3 (aarch64)\n"
			   "processor\t: 0\n"
			   "processor\t: 1\n"
			   "processor\t: 2\n"
			   "processor\t: 3\n"
			   "processor\t: 4\n"
			   "processor\t: 5\n"
			   "processor\t: 6\n"
			   "processor\t: 7\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: AArch64\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 3\n"
			   "\n"
			   "Hardware\t: hi6210sft\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 395,
		.content =
			"Processor\t: AArch64 Processor rev 3 (aarch64)\n"
			"processor\t: 0\n"
			"processor\t: 1\n"
			"processor\t: 2\n"
			"processor\t: 3\n"
			"processor\t: 4\n"
			"processor\t: 5\n"
			"processor\t: 6\n"
			"processor\t: 7\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32 wp half thumb fastmult vfp edsp neon vfpv3 tlsi vfpv4 idiva idivt \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 3\n"
			"\n"
			"Hardware\t: hi6210sft",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 8457,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=LRX21M\n"
			"ro.build.version.incremental=eng.jenkins.20160905.141529\n"
			"ro.build.version.sdk=21\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=5.0.1\n"
			"ro.build.version.security_patch=2016-08-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Mon Sep  5 14:18:10 CST 2016\n"
			"ro.build.date.utc=1473056290\n"
			"ro.build.type=user\n"
			"ro.product.model=hi6210sft\n"
			"ro.product.brand=hi6210sft\n"
			"ro.product.name=hi6210sft\n"
			"ro.product.device=hi6210sft\n"
			"ro.product.board=BalongV8R1SFT\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=HUAWEI\n"
			"#ro.product.locale.language=zh\n"
			"#ro.product.locale.region=CN\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=hi6210sft\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=hi6210sft\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=hi6210sft-user 5.0 LRX21M eng.jenkins.20160905.141529 test-keys\n"
			"ro.build.fingerprint=hi6210sft/hi6210sft/hi6210sft:5.0/LRX21M/jenkins09051417:user/test-keys\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"\n"
			"# begin huawei emui properties\n"
			"# autogenerated by build_emui_info.sh\n"
			"ro.build.hw_emui_api_level=8\n"
			"# end huawei emui properties\n"
			"\n"
			"#\n"
			"# from device/hisi/hi6210sft/system.prop\n"
			"#\n"
			"dalvik.vm.heapsize=512m\n"
			"ro.opengles.version=131072\n"
			"debug.hwui.render_dirty_regions=false\n"
			"ro.balong_debug.port_num=7\n"
			"ro.sf.lcd_density=320\n"
			"hw.lcd.density=320\n"
			"dalvik.vm.checkjni=false\n"
			"persist.sys.strictmode.disable=true\n"
			"ro.product.platform.pseudonym=1ARB9CV\n"
			"ro.hwui.texture_cache_size=72\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hwui.shape_cache_size=2\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.sys.umsdirtyratio=2\n"
			"ro.config.hw_music_lp=true\n"
			"keyguard.no_require_sim=true\n"
			"bastet.service.enable=true\n"
			"ro.config.keypasstouser=true\n"
			"ro.projectmenu.chargeminlevel=58\n"
			"ro.projectmenu.chargemaxlevel=73\n"
			"ro.config.hw_emerg=on\n"
			"ro.bt.bdaddr_path=/data/misc/bluedroid/macbt\n"
			"ro.projectmenuact.v8r2=true\n"
			"persist.sys.pgps.config=1\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.config.ringtone=Huawei_Tune.ogg\n"
			"ro.config.notification_sound=Bongo.ogg\n"
			"ro.carrier=unknown\n"
			"ro.config.alarm_alert=Creamy.ogg\n"
			"ro.setupwizard.mode=DISABLED\n"
			"ro.com.google.gmsversion=5.0_r4\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.features=div\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"\n"
			"ro.config.hw_dts=false\n"
			"ro.config.hw_dolby=false\n"
			"audioril.lib=libhuawei-audio-ril.so\n"
			"ro.config.fm_type=libbcmfm_if\n"
			"dalvik.vm.heapgrowthlimit=192m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"dalvik.vm.jit.codecachesize=1024\n"
			"persist.sys.strictmode.visual=false\n"
			"ro.config.message=Whisper.ogg\n"
			"ro.config.email=Letter.ogg\n"
			"ro.config.calendar=Step.ogg\n"
			"install.frobidden=false\n"
			"ro.camera.sound.forced=1\n"
			"ro.hwcamera.back.pixels=1300\n"
			"ro.camera.beauty.algo.doc=1\n"
			"ro.config.hw_nfc_on=true\n"
			"ro.config.widevine_level3=true\n"
			"ro.cellbroadcast.emergencyids=0-65534\n"
			"ro.config.hw_flashless=true\n"
			"ro.config.modem_hsic=true\n"
			"ro.cofig.onlinevideo.enabled=false\n"
			"ro.config.hw_addsettingsdbex=1\n"
			"ro.config.hw_toolbox = true\n"
			"ro.config.fast_dormancy=false\n"
			"ro.hwtheme.widgetpic.dismiss=false\n"
			"ro.config.hwtheme=2\n"
			"ro.config.hw_gcf=false\n"
			"ro.config.hw_allowformat=false\n"
			"ro.config.hw_proximity=true\n"
			"ro.config.hw_lockscreen=true\n"
			"ro.config.hw_menu_unlockscreen=false\n"
			"ro.config.helix_enable=true\n"
			"ro.config.hwft_PinPukUnlockscr=true\n"
			"ro.config.hw_use_browser_ua=http://wap1.huawei.com/uaprof/HUAWEI_Che2-UL00_UAProfile.xml\n"
			"ro.config.hw_always_allow_mms=false\n"
			"ro.config.hw_vcardBase64=true\n"
			"ro.config.hw_ecclist_withcard=1+110,6+119,8+118\n"
			"ro.config.hw_ecclist_nocard=1+110,6+119,8+118\n"
			"ro.config.hw_globalEcc = true\n"
			"ro.config.hw_allow_ums_and_mtp=true\n"
			"ro.config.incall_notify_mms=true\n"
			"ro.config.hw_useCtrlSocket=true\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"ro.config.AM_PM_STYLE=1\n"
			"ro.poweroff_alarm=true\n"
			"persist.sys.actualpoweron=true\n"
			"ro.config.hw_show_number=false\n"
			"ro.config.hw_support_ipcall=false\n"
			"ro.config.bg_call_twinking=true\n"
			"ro.config.hw_power_saving=true\n"
			"ro.config.hwft_emerCallDefNum=\"\"\n"
			"ro.config.hw_proximitySensor=true\n"
			"ro.config.always_animation=true\n"
			"ro.config.hw_RemindWifiToPdp=false\n"
			"ro.config.app_big_icon_size=114\n"
			"ro.config.do_sdcard_upgrade=true\n"
			"ro.ril.ecclist=112,911,#911,*911\n"
			"af.resampler.quality=3\n"
			"ro.config.hw_eapsim=false\n"
			"ro.config.disablesmbacklinght=true\n"
			"persist.alarm.enable.uhb=0\n"
			"ro.config.hw_rightsmgr=1\n"
			"persist.sys.phb.enable=1\n"
			"persist.sys.phb.debug.enable=1\n"
			"ro.config.hw_acceleratord_onoff=1\n"
			"ro.config.hw.logsystem.send=0\n"
			"ro.config.hw_enable_merge=true\n"
			"ro.config.themecolor=true\n"
			"modify_ram_show=true\n"
			"ro.config.hw_hightLight=true\n"
			"ro.config.hw_hightLightValue=200\n"
			"ro.com.google.clientidbase=android-huawei\n"
			"ro.com.google.clientidbase.am=android-huawei\n"
			"ro.com.google.clientidbase.gmm=android-huawei\n"
			"ro.com.google.clientidbase.ms=android-huawei\n"
			"ro.com.google.clientidbase.yt=android-huawei\n"
			"ro.com.google.clientidbase=android-huawei\n"
			"persist.sys.alarm.enable.uhb=1\n"
			"ro.config.hw.security_volume=8\n"
			"ro.config.hw_GSensorOptimize=true\n"
			"ro.config.hw_omacp=1\n"
			"af.resampler.quality=4\n"
			"ro.config.hw_multiscreen=true\n"
			"ro.thmodem.type=sprd\n"
			"ro.config.hw_singlehand=1\n"
			"ro.config.colorTemperature_K3=true\n"
			"ro.config.hw_smart_backlight=1\n"
			"ro.config.hw_singlehand_smart=false\n"
			"ro.config.smart_rotation=false\n"
			"ro.config.hw_acceleratord_onoff=0\n"
			"ril.gsm.deviceid=-1\n"
			"ril.cdma.deviceid=-1\n"
			"ril.gsm.rssi=-1\n"
			"ril.cdma.rssi=-1\n"
			"persist.sys.logsystem.neversend=0\n"
			"ro.config.hw_shownavisettings=true\n"
			"ro.config.dlvs=true\n"
			"ro.config.carkitmodenotif=true\n"
			"ro.config.hwscope=false\n"
			"ro.config.lockscreen_lensflare=true\n"
			"ro.config.hw.powerlogserve.send=1\n"
			"persist.service.tm2.tofile=true\n"
			"ro.config.hw.VIS=false\n"
			"ril.hw_modem0.rssi=-1\n"
			"ril.hw_modem1.rssi=-1\n"
			"ril.hw_modem0.deviceid=000000000000000\n"
			"ril.hw_modem1.deviceid=000000000000000\n"
			"ro.pwrtmg.aegis.state=20\n"
			"ro.cdma.poorstd=-108\n"
			"ro.cdma.modstd=-102\n"
			"ro.cdma.goodstd=-95\n"
			"ro.cdma.greatstd=-85\n"
			"ro.cdmaecio.poorstd=-15\n"
			"ro.cdmaecio.modstd=-13\n"
			"ro.cdmaecio.goodstd=-11\n"
			"ro.cdmaecio.greatstd=-9\n"
			"ro.cdmasnr.poorstd=1\n"
			"ro.cdmasnr.modstd=3\n"
			"ro.cdmasnr.goodstd=5\n"
			"ro.cdmasnr.greatstd=7\n"
			"ro.config.hw_showTestInfo=false\n"
			"ro.config.hw_activity_state=true\n"
			"ro.cmdaconfig.roamingByPlmn=true\n"
			"ro.config.hw_simpleui_enable=1\n"
			"ro.cust.cdrom= /cust/preinstalled/public/cdrom/autorun.iso\n"
			"ro.config.switchPrimaryVolume=true\n"
			"ro.config.conn_diagnose=false\n"
			"ro.config.protocol_errors=false\n"
			"ro.config.distinguish_hspa=true\n"
			"ro.config.dic_disable=true\n"
			"ro.config.hw_ChipPlatform=V9R1_Platform\n"
			"ro.config.enable.HwLogswitch=false\n"
			"ro.config.launcher_matchcard=1\n"
			"persist.hwpp.notifydelayed=6\n"
			"ro.dual.sim.phone=true\n"
			"ro.hwpp_dorecoverylevel=1\n"
			"mdc_initial_max_retry=3\n"
			"ro.config.ringtone2=Hello_Ya.ogg\n"
			"ro.config.hw_glovemode_enabled=1\n"
			"ro.config.glove_file_path=/sys/touchscreen/touch_glove\n"
			"persist.hw.power.shutdown=1\n"
			"sys.aps.support=43\n"
			"sys.nsd.launcherbottom=1150\n"
			"sys.nsd.launchertop=50\n"
			"ro.config.show6130=true\n"
			"ro.config.hw_testingsettings=true\n"
			"ro.product.hardwareversion=Ver.A\n"
			"ro.config.hwinternet_audio=0\n"
			"ro.anr.warning.enable=true\n"
			"ro.config.hw_navigationbar=true\n"
			"ro.config.hw_navi_launcher=false\n"
			"ro.config.hw_showSimName=true\n"
			"ro.config.hw_privacymode=true\n"
			"ro.config.pre_apn_unable=false\n"
			"ro.config.pre_apn_NotDel=true\n"
			"ro.config.hw_smartcardservice=true\n"
			"ro.config.hw_accesscontrol=true\n"
			"ro.config.readBtAddress=true\n"
			"ro.config.wifiManager_k3=true\n"
			"ro.config.apn_cancel_nopop=true\n"
			"ro.media.NxpSmartPARaise15=true\n"
			"drm.service.enabled=true\n"
			"fw.show_multiuserui=1\n"
			"fw.max_users=4\n"
			"ro.config.quicklly_brightness=true\n"
			"\n"
			"ro.build.tags=release-keys\n"
			"\n"
			"ro.build.user=android\n"
			"\n"
			"ro.build.host=localhost#1\n"
			"\n"
			"ro.build.version.emui=EmotionUI_3.1\n"
			"\n"
			"ro.build.hide=false\n"
			"\n"
			"ro.build.hide.matchers=Mali-400 MP;Mali-450 MP;ARM;CherryPlus;hwALE\n"
			"\n"
			"ro.build.hide.replacements=unknown;unknown;unknown;unknown;unknown\n"
			"\n"
			"ro.build.hide.settings=4;1.2 GHz;1.0GB;405 MB;4.00 GB;540 x 960;4.3;3.0.8;2.0\n"
			"\n"
			"ro.build.hw_real.version=C185B200\n"
			"\n"
			"ro.confg.hw_systemversion=C185B200_SYSTEM\n"
			"\n"
			"ro.confg.hw_fastbootversion=C185B200_FASTBOOT\n"
			"\n"
			"ro.confg.hw_bootversion=C185B200_BOOT\n"
			"\n"
			"ro.build.display.id=BalongC50B311\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 201,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\tcpu4\t\tcpu5\t\tcpu6\t\tcpu7\t\t\n"
			   "208000\t\t561\t\t561\t\t561\t\t561\t\t\n"
			   "432000\t\t148\t\t148\t\t148\t\t148\t\t\n"
			   "729000\t\t86\t\t86\t\t86\t\t86\t\t\n"
			   "960000\t\t179\t\t179\t\t179\t\t179\t\t\n"
			   "1200000\t\t6037\t\t6037\t\t6037\t\t6037\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 11,
		.content = "arm64_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 37,
		.content = "208000 432000 729000 960000 1200000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 23,
		.content = "optdemand performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 11,
		.content = "hi6xxx-smp\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 10,
		.content = "optdemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 56,
		.content = "208000 705\n"
			   "432000 152\n"
			   "729000 86\n"
			   "960000 179\n"
			   "1200000 6037\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "258\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 37,
		.content = "208000 432000 729000 960000 1200000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 23,
		.content = "optdemand performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 11,
		.content = "hi6xxx-smp\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 10,
		.content = "optdemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 56,
		.content = "208000 940\n"
			   "432000 164\n"
			   "729000 86\n"
			   "960000 189\n"
			   "1200000 6051\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "275\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 37,
		.content = "208000 432000 729000 960000 1200000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 23,
		.content = "optdemand performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 11,
		.content = "hi6xxx-smp\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 10,
		.content = "optdemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 57,
		.content = "208000 1197\n"
			   "432000 172\n"
			   "729000 86\n"
			   "960000 189\n"
			   "1200000 6051\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "279\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 37,
		.content = "208000 432000 729000 960000 1200000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 23,
		.content = "optdemand performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 11,
		.content = "hi6xxx-smp\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 10,
		.content = "optdemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "208000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 57,
		.content = "208000 1384\n"
			   "432000 181\n"
			   "729000 87\n"
			   "960000 202\n"
			   "1200000 6079\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "302\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings_list",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings",
		.size = 3,
		.content = "20\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings_list",
		.size = 2,
		.content = "5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/thread_siblings",
		.size = 3,
		.content = "40\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/thread_siblings_list",
		.size = 2,
		.content = "6\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/thread_siblings",
		.size = 3,
		.content = "80\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/thread_siblings_list",
		.size = 2,
		.content = "7\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.resampler.quality",
		.value = "4",
	},
	{
		.key = "audioril.lib",
		.value = "libhuawei-audio-ril.so",
	},
	{
		.key = "bastet.service.enable",
		.value = "true",
	},
	{
		.key = "dalvik.vm.checkjni",
		.value = "false",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "192m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "div",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.jit.codecachesize",
		.value = "1024",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.aps.enable",
		.value = "0",
	},
	{
		.key = "debug.aps.process.name",
		.value = "",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "fw.max_users",
		.value = "4",
	},
	{
		.key = "fw.show_multiuserui",
		.value = "1",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.dualcards.switch",
		.value = "false",
	},
	{
		.key = "gsm.hw.fdn.activated1",
		.value = "false",
	},
	{
		.key = "gsm.hw.fdn.activated2",
		.value = "false",
	},
	{
		.key = "gsm.network.type",
		.value = "UMTS,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.hw_atr1",
		.value = "null",
	},
	{
		.key = "gsm.sim.hw_atr",
		.value = "null",
	},
	{
		.key = "gsm.sim.num.simlock",
		.value = "-1,-1,-1",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.sim1.type",
		.value = "-1",
	},
	{
		.key = "gsm.sim2.type",
		.value = "-1",
	},
	{
		.key = "gsm.version.baseband",
		.value = "22.126.23.00.00,22.126.23.00.00",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android hisilicon balong-ril 1.0",
	},
	{
		.key = "hifi.watchdog.come",
		.value = "false",
	},
	{
		.key = "huawei.check_root.hotapermit",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.mount",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.oldstate",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.prop",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.setids",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.su",
		.value = "safe",
	},
	{
		.key = "hw.lcd.density",
		.value = "320",
	},
	{
		.key = "hw.npm.asyncntp",
		.value = "true",
	},
	{
		.key = "hw.wifipro.dns_fail_count",
		.value = "3",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.agnsscontrol",
		.value = "running",
	},
	{
		.key = "init.svc.agnsslog",
		.value = "running",
	},
	{
		.key = "init.svc.akmd09911",
		.value = "running",
	},
	{
		.key = "init.svc.bastetd",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccorecat",
		.value = "restarting",
	},
	{
		.key = "init.svc.check_hota",
		.value = "stopped",
	},
	{
		.key = "init.svc.check_root",
		.value = "stopped",
	},
	{
		.key = "init.svc.chr_logd",
		.value = "running",
	},
	{
		.key = "init.svc.data_cleanner",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.device-monitor",
		.value = "running",
	},
	{
		.key = "init.svc.diagserver",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.dumptool",
		.value = "running",
	},
	{
		.key = "init.svc.exch",
		.value = "stopped",
	},
	{
		.key = "init.svc.filebackup",
		.value = "running",
	},
	{
		.key = "init.svc.hdbd",
		.value = "stopped",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.hi110x_ecpt",
		.value = "running",
	},
	{
		.key = "init.svc.hi110x_logd",
		.value = "running",
	},
	{
		.key = "init.svc.hisi_bfg",
		.value = "stopped",
	},
	{
		.key = "init.svc.hsgnss",
		.value = "running",
	},
	{
		.key = "init.svc.hw_cdma_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.hw_ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.hwnffserver",
		.value = "running",
	},
	{
		.key = "init.svc.hwpged",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.ioinfoservice",
		.value = "restarting",
	},
	{
		.key = "init.svc.kerneldump",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logctl_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.macaddr",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.oam_app",
		.value = "running",
	},
	{
		.key = "init.svc.octty",
		.value = "running",
	},
	{
		.key = "init.svc.oeminfo_nvm",
		.value = "running",
	},
	{
		.key = "init.svc.powerlogd",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon1",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.supl20clientd",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.teecd",
		.value = "running",
	},
	{
		.key = "init.svc.telemntncat",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.watchlssd",
		.value = "running",
	},
	{
		.key = "init.svc.wpa_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "install.frobidden",
		.value = "false",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "mdc_initial_max_retry",
		.value = "3",
	},
	{
		.key = "modify_ram_show",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-3f9d481586b7c985",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "network_mode_CMCC_test",
		.value = "true",
	},
	{
		.key = "persist.alarm.enable.uhb",
		.value = "0",
	},
	{
		.key = "persist.dsds.enabled",
		.value = "true",
	},
	{
		.key = "persist.hw.power.shutdown",
		.value = "0",
	},
	{
		.key = "persist.hwpp.notifydelayed",
		.value = "6",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.service.hdb.enable",
		.value = "true",
	},
	{
		.key = "persist.service.tm2.tofile",
		.value = "true",
	},
	{
		.key = "persist.sys.actualpoweron",
		.value = "true",
	},
	{
		.key = "persist.sys.alarm.enable.uhb",
		.value = "1",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.dualcards",
		.value = "true",
	},
	{
		.key = "persist.sys.hw_abnreboot_times",
		.value = "0",
	},
	{
		.key = "persist.sys.logsystem.neversend",
		.value = "0",
	},
	{
		.key = "persist.sys.pgps.config",
		.value = "1",
	},
	{
		.key = "persist.sys.phb.debug.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.phb.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.powerup_reason",
		.value = "NORMAL",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.smart_power",
		.value = "2",
	},
	{
		.key = "persist.sys.strictmode.disable",
		.value = "true",
	},
	{
		.key = "persist.sys.strictmode.visual",
		.value = "false",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "hisuite,mtp,mass_storage,adb",
	},
	{
		.key = "ril.balong_cid",
		.value = "0",
	},
	{
		.key = "ril.cdma.deviceid",
		.value = "-1",
	},
	{
		.key = "ril.cdma.rssi",
		.value = "-1",
	},
	{
		.key = "ril.ecclist1",
		.value = "112,911,000,08,110,118,119,999",
	},
	{
		.key = "ril.ecclist",
		.value = "112,911,000,08,110,118,119,999,911,112",
	},
	{
		.key = "ril.force_to_set_ecc",
		.value = "invalid",
	},
	{
		.key = "ril.gsm.deviceid",
		.value = "-1",
	},
	{
		.key = "ril.gsm.rssi",
		.value = "-1",
	},
	{
		.key = "ril.hw_modem0.deviceid",
		.value = "000000000000000",
	},
	{
		.key = "ril.hw_modem0.rssi",
		.value = "-1",
	},
	{
		.key = "ril.hw_modem1.deviceid",
		.value = "000000000000000",
	},
	{
		.key = "ril.hw_modem1.rssi",
		.value = "-1",
	},
	{
		.key = "ril.modem.balong_nvm_server",
		.value = "true",
	},
	{
		.key = "ril.operator.numeric",
		.value = "310260",
	},
	{
		.key = "rild.libargs1",
		.value = "-m modem1",
	},
	{
		.key = "rild.libargs",
		.value = "-m modem0",
	},
	{
		.key = "rild.libpath1",
		.value = "/system/lib64/libbalong-ril.so",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib64/libbalong-ril.so",
	},
	{
		.key = "rild.rild1_ready_to_start",
		.value = "true",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.anr.warning.enable",
		.value = "true",
	},
	{
		.key = "ro.balong_debug.port_num",
		.value = "7",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.boardid",
		.value = "0719",
	},
	{
		.key = "ro.board.boardname",
		.value = "ALICE_TL21_VC",
	},
	{
		.key = "ro.board.modemid",
		.value = "3db54500",
	},
	{
		.key = "ro.board.platform",
		.value = "hi6210sft",
	},
	{
		.key = "ro.boardid.product",
		.value = "5801",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.selinux",
		.value = "enforcing",
	},
	{
		.key = "ro.boot.serialno",
		.value = "W3D7N17626001128",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/data/misc/bluedroid/macbt",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1473056290",
	},
	{
		.key = "ro.build.date",
		.value = "Mon Sep  5 14:18:10 CST 2016",
	},
	{
		.key = "ro.build.description",
		.value = "ALE-L21-user 5.0 HuaweiALE-L21 C185B200 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "ALE-L21C185B200",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Huawei/ALE-L21/hwALE-H:5.0.1/HuaweiALE-L21/C185B200:user/release-keys",
	},
	{
		.key = "ro.build.hide.matchers",
		.value = "Mali-400 MP;Mali-450 MP;ARM;CherryPlus;hwALE",
	},
	{
		.key = "ro.build.hide.replacements",
		.value = "unknown;unknown;unknown;unknown;unknown",
	},
	{
		.key = "ro.build.hide.settings",
		.value = "4;1.2 GHz;1.0GB;405 MB;4.00 GB;540 x 960;4.3;3.0.8;2.0",
	},
	{
		.key = "ro.build.hide",
		.value = "false",
	},
	{
		.key = "ro.build.host",
		.value = "localhost#1",
	},
	{
		.key = "ro.build.hw_emui_api_level",
		.value = "8",
	},
	{
		.key = "ro.build.hw_real.version",
		.value = "C185B200",
	},
	{
		.key = "ro.build.id",
		.value = "HuaweiALE-L21",
	},
	{
		.key = "ro.build.multicust",
		.value = "false",
	},
	{
		.key = "ro.build.product",
		.value = "hi6210sft",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.update_version",
		.value = "V1_0",
	},
	{
		.key = "ro.build.user",
		.value = "android",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.emui",
		.value = "EmotionUI_3.1",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "C185B200",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.0.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "21",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-08-01",
	},
	{
		.key = "ro.camera.beauty.algo.doc",
		.value = "1",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "1",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.cdma.goodstd",
		.value = "-95",
	},
	{
		.key = "ro.cdma.greatstd",
		.value = "-85",
	},
	{
		.key = "ro.cdma.modstd",
		.value = "-102",
	},
	{
		.key = "ro.cdma.poorstd",
		.value = "-108",
	},
	{
		.key = "ro.cdmaecio.goodstd",
		.value = "-11",
	},
	{
		.key = "ro.cdmaecio.greatstd",
		.value = "-9",
	},
	{
		.key = "ro.cdmaecio.modstd",
		.value = "-13",
	},
	{
		.key = "ro.cdmaecio.poorstd",
		.value = "-15",
	},
	{
		.key = "ro.cdmasnr.goodstd",
		.value = "5",
	},
	{
		.key = "ro.cdmasnr.greatstd",
		.value = "7",
	},
	{
		.key = "ro.cdmasnr.modstd",
		.value = "3",
	},
	{
		.key = "ro.cdmasnr.poorstd",
		.value = "1",
	},
	{
		.key = "ro.cellbroadcast.emergencyids",
		.value = "0-65534",
	},
	{
		.key = "ro.cmdaconfig.roamingByPlmn",
		.value = "true",
	},
	{
		.key = "ro.cofig.onlinemusic.enabled",
		.value = "true",
	},
	{
		.key = "ro.cofig.onlinevideo.enabled",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "5.0_r4",
	},
	{
		.key = "ro.confg.hw_bootversion",
		.value = "DailyBuild_201609051410_BOOT",
	},
	{
		.key = "ro.confg.hw_fastbootversion",
		.value = "DailyBuild_201609051410_FASTBOOT",
	},
	{
		.key = "ro.confg.hw_systemversion",
		.value = "ALE-L21C185B200_SYSTEM",
	},
	{
		.key = "ro.config.AM_PM_STYLE",
		.value = "1",
	},
	{
		.key = "ro.config.Is_Sup_2Gonly",
		.value = "true",
	},
	{
		.key = "ro.config.RoamingNetwork",
		.value = "false",
	},
	{
		.key = "ro.config.addAct",
		.value = "false",
	},
	{
		.key = "ro.config.agps_server_setting",
		.value = "true",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Creamy.ogg",
	},
	{
		.key = "ro.config.always_animation",
		.value = "true",
	},
	{
		.key = "ro.config.amrwb_disable",
		.value = "true",
	},
	{
		.key = "ro.config.apn_cancel_nopop",
		.value = "true",
	},
	{
		.key = "ro.config.app_big_icon_size",
		.value = "114",
	},
	{
		.key = "ro.config.attach_apn_enabled",
		.value = "true",
	},
	{
		.key = "ro.config.auth.timeout",
		.value = "true",
	},
	{
		.key = "ro.config.autoconnect.swich",
		.value = "true",
	},
	{
		.key = "ro.config.balongTD_mms_test",
		.value = "true",
	},
	{
		.key = "ro.config.bg_call_twinking",
		.value = "TRUE",
	},
	{
		.key = "ro.config.calendar",
		.value = "Step.ogg",
	},
	{
		.key = "ro.config.callrecord.enabled",
		.value = "1",
	},
	{
		.key = "ro.config.callwait_vibrator",
		.value = "true",
	},
	{
		.key = "ro.config.carkitmodenotif",
		.value = "true",
	},
	{
		.key = "ro.config.cmccCustmccmnc",
		.value = "true",
	},
	{
		.key = "ro.config.cmcc_forbidden_net",
		.value = "true",
	},
	{
		.key = "ro.config.cmdm_apn_not_display",
		.value = "true",
	},
	{
		.key = "ro.config.colorTemperature_K3",
		.value = "true",
	},
	{
		.key = "ro.config.compatibility_enable",
		.value = "1",
	},
	{
		.key = "ro.config.conn_diagnose",
		.value = "false",
	},
	{
		.key = "ro.config.delay_alarm_in_call",
		.value = "true",
	},
	{
		.key = "ro.config.dic_disable",
		.value = "true",
	},
	{
		.key = "ro.config.disablesmbacklinght",
		.value = "true",
	},
	{
		.key = "ro.config.distinguish_hspa",
		.value = "true",
	},
	{
		.key = "ro.config.dlvs",
		.value = "true",
	},
	{
		.key = "ro.config.do_sdcard_upgrade",
		.value = "true",
	},
	{
		.key = "ro.config.ds_verbose_log_on",
		.value = "true",
	},
	{
		.key = "ro.config.dsda_single_rild",
		.value = "true",
	},
	{
		.key = "ro.config.dsds_mode",
		.value = "umts_gsm",
	},
	{
		.key = "ro.config.ecc_from_cust_enable",
		.value = "true",
	},
	{
		.key = "ro.config.email",
		.value = "Letter.ogg",
	},
	{
		.key = "ro.config.enable.HwLogswitch",
		.value = "false",
	},
	{
		.key = "ro.config.fast_dormancy",
		.value = "false",
	},
	{
		.key = "ro.config.fm_type",
		.value = "libbcmfm_if",
	},
	{
		.key = "ro.config.forbid_internal_call",
		.value = "true",
	},
	{
		.key = "ro.config.glove_file_path",
		.value = "/sys/touchscreen/touch_glove",
	},
	{
		.key = "ro.config.helix_enable",
		.value = "true",
	},
	{
		.key = "ro.config.hide_sipcall",
		.value = "true",
	},
	{
		.key = "ro.config.hspap_hsdpa_open",
		.value = "1",
	},
	{
		.key = "ro.config.hw.VIS",
		.value = "false",
	},
	{
		.key = "ro.config.hw.imeisv",
		.value = "true",
	},
	{
		.key = "ro.config.hw.logsystem.send",
		.value = "0",
	},
	{
		.key = "ro.config.hw.powerlogserve.send",
		.value = "1",
	},
	{
		.key = "ro.config.hw.security_volume",
		.value = "8",
	},
	{
		.key = "ro.config.hw_ChipPlatform",
		.value = "V9R1_Platform",
	},
	{
		.key = "ro.config.hw_GSensorOptimize",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ReduceSAR",
		.value = "true",
	},
	{
		.key = "ro.config.hw_RemindWifiToPdp",
		.value = "false",
	},
	{
		.key = "ro.config.hw_acceleratord_onoff",
		.value = "1",
	},
	{
		.key = "ro.config.hw_accesscontrol",
		.value = "true",
	},
	{
		.key = "ro.config.hw_activity_state",
		.value = "true",
	},
	{
		.key = "ro.config.hw_addsettingsdbex",
		.value = "1",
	},
	{
		.key = "ro.config.hw_allow_rs_mms",
		.value = "true",
	},
	{
		.key = "ro.config.hw_allow_ums_and_mtp",
		.value = "true",
	},
	{
		.key = "ro.config.hw_allowformat",
		.value = "false",
	},
	{
		.key = "ro.config.hw_always_allow_mms",
		.value = "true",
	},
	{
		.key = "ro.config.hw_blacklist",
		.value = "true",
	},
	{
		.key = "ro.config.hw_cmcc_emerg_invisi",
		.value = "1",
	},
	{
		.key = "ro.config.hw_dolby",
		.value = "false",
	},
	{
		.key = "ro.config.hw_dsda",
		.value = "false",
	},
	{
		.key = "ro.config.hw_dsdspowerup",
		.value = "true",
	},
	{
		.key = "ro.config.hw_dts",
		.value = "false",
	},
	{
		.key = "ro.config.hw_eapsim",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ecclist_nocard",
		.value = "1+110,6+119,8+118",
	},
	{
		.key = "ro.config.hw_ecclist_withcard",
		.value = "1+110,6+119,8+118",
	},
	{
		.key = "ro.config.hw_emerg",
		.value = "on",
	},
	{
		.key = "ro.config.hw_enable_join",
		.value = "true",
	},
	{
		.key = "ro.config.hw_enable_merge",
		.value = "true",
	},
	{
		.key = "ro.config.hw_flashless",
		.value = "true",
	},
	{
		.key = "ro.config.hw_gcf",
		.value = "false",
	},
	{
		.key = "ro.config.hw_globalEcc",
		.value = "true",
	},
	{
		.key = "ro.config.hw_glovemode_enabled",
		.value = "1",
	},
	{
		.key = "ro.config.hw_hidecallforward",
		.value = "true",
	},
	{
		.key = "ro.config.hw_hightLightValue",
		.value = "200",
	},
	{
		.key = "ro.config.hw_hightLight",
		.value = "true",
	},
	{
		.key = "ro.config.hw_iconshare",
		.value = "false",
	},
	{
		.key = "ro.config.hw_imei_sv_enable",
		.value = "true",
	},
	{
		.key = "ro.config.hw_imei_sv_show_two",
		.value = "true",
	},
	{
		.key = "ro.config.hw_incall_report_on",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ipv6_support",
		.value = "true",
	},
	{
		.key = "ro.config.hw_lockscreen",
		.value = "true",
	},
	{
		.key = "ro.config.hw_menu_unlockscreen",
		.value = "false",
	},
	{
		.key = "ro.config.hw_mmi_match_list",
		.value = "*333#",
	},
	{
		.key = "ro.config.hw_mo_num_update",
		.value = "true",
	},
	{
		.key = "ro.config.hw_multiscreen",
		.value = "true",
	},
	{
		.key = "ro.config.hw_music_lp",
		.value = "true",
	},
	{
		.key = "ro.config.hw_navi_launcher",
		.value = "false",
	},
	{
		.key = "ro.config.hw_navigationbar",
		.value = "true",
	},
	{
		.key = "ro.config.hw_nfc_beam",
		.value = "true",
	},
	{
		.key = "ro.config.hw_nfc_on",
		.value = "true",
	},
	{
		.key = "ro.config.hw_nfc_url",
		.value = "true",
	},
	{
		.key = "ro.config.hw_nlp",
		.value = "com.amap.android.location",
	},
	{
		.key = "ro.config.hw_novoicesignal",
		.value = "false",
	},
	{
		.key = "ro.config.hw_omacp",
		.value = "1",
	},
	{
		.key = "ro.config.hw_opta",
		.value = "185",
	},
	{
		.key = "ro.config.hw_optb",
		.value = "999",
	},
	{
		.key = "ro.config.hw_power_saving",
		.value = "true",
	},
	{
		.key = "ro.config.hw_privacymode",
		.value = "true",
	},
	{
		.key = "ro.config.hw_proximitySensor",
		.value = "true",
	},
	{
		.key = "ro.config.hw_proximity",
		.value = "true",
	},
	{
		.key = "ro.config.hw_record_gps_info",
		.value = "true",
	},
	{
		.key = "ro.config.hw_rightsmgr",
		.value = "1",
	},
	{
		.key = "ro.config.hw_sglte.mcc",
		.value = "460,001",
	},
	{
		.key = "ro.config.hw_sglte",
		.value = "false",
	},
	{
		.key = "ro.config.hw_showSimName",
		.value = "true",
	},
	{
		.key = "ro.config.hw_showTestInfo",
		.value = "false",
	},
	{
		.key = "ro.config.hw_show_4G_Plus_icon",
		.value = "true",
	},
	{
		.key = "ro.config.hw_show_network_icon",
		.value = "true",
	},
	{
		.key = "ro.config.hw_show_number",
		.value = "false",
	},
	{
		.key = "ro.config.hw_shownavisettings",
		.value = "true",
	},
	{
		.key = "ro.config.hw_sim2airplane",
		.value = "true",
	},
	{
		.key = "ro.config.hw_simlock_retries",
		.value = "true",
	},
	{
		.key = "ro.config.hw_simpleui_enable",
		.value = "1",
	},
	{
		.key = "ro.config.hw_singlehand",
		.value = "1",
	},
	{
		.key = "ro.config.hw_singlehand_smart",
		.value = "false",
	},
	{
		.key = "ro.config.hw_smart_backlight",
		.value = "1",
	},
	{
		.key = "ro.config.hw_smartcardservice",
		.value = "true",
	},
	{
		.key = "ro.config.hw_support_callbar",
		.value = "true",
	},
	{
		.key = "ro.config.hw_support_ipcall",
		.value = "false",
	},
	{
		.key = "ro.config.hw_testingsettings",
		.value = "true",
	},
	{
		.key = "ro.config.hw_toolbox",
		.value = "true",
	},
	{
		.key = "ro.config.hw_useCtrlSocket",
		.value = "true",
	},
	{
		.key = "ro.config.hw_use_browser_ua",
		.value = "http://wap1.huawei.com/uaprof/HUAWEI_ALE-L21_UAProfile.xml",
	},
	{
		.key = "ro.config.hw_vcardBase64",
		.value = "true",
	},
	{
		.key = "ro.config.hw_virtual_key",
		.value = "true",
	},
	{
		.key = "ro.config.hw_voicerecord",
		.value = "false",
	},
	{
		.key = "ro.config.hw_wifi_frequency",
		.value = "0",
	},
	{
		.key = "ro.config.hwft_PinPukUnlockscr",
		.value = "true",
	},
	{
		.key = "ro.config.hwft_emerCallDefNum",
		.value = "\"\"",
	},
	{
		.key = "ro.config.hwinternet_audio",
		.value = "0",
	},
	{
		.key = "ro.config.hwscope",
		.value = "false",
	},
	{
		.key = "ro.config.hwtheme",
		.value = "2",
	},
	{
		.key = "ro.config.incall_notify_mms",
		.value = "true",
	},
	{
		.key = "ro.config.keypasstouser",
		.value = "true",
	},
	{
		.key = "ro.config.launcher_matchcard",
		.value = "1",
	},
	{
		.key = "ro.config.lockscreen_lensflare",
		.value = "true",
	},
	{
		.key = "ro.config.message",
		.value = "Whisper.ogg",
	},
	{
		.key = "ro.config.modem_hsic",
		.value = "true",
	},
	{
		.key = "ro.config.network_mode_CMCC",
		.value = "false",
	},
	{
		.key = "ro.config.network_mode_CTA",
		.value = "false",
	},
	{
		.key = "ro.config.networkmodeset",
		.value = "true",
	},
	{
		.key = "ro.config.nfc_cardreader",
		.value = "false",
	},
	{
		.key = "ro.config.nfc_ce_transevt",
		.value = "true",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Bongo.ogg",
	},
	{
		.key = "ro.config.old_reduce_sar",
		.value = "true",
	},
	{
		.key = "ro.config.plmn_to_settings",
		.value = "true",
	},
	{
		.key = "ro.config.pre_apn_NotDel",
		.value = "true",
	},
	{
		.key = "ro.config.pre_apn_unable",
		.value = "false",
	},
	{
		.key = "ro.config.protocol_errors",
		.value = "false",
	},
	{
		.key = "ro.config.qcom_bt_busytone",
		.value = "true",
	},
	{
		.key = "ro.config.quicklly_brightness",
		.value = "true",
	},
	{
		.key = "ro.config.readBtAddress",
		.value = "true",
	},
	{
		.key = "ro.config.reduce_sar_level",
		.value = "4095",
	},
	{
		.key = "ro.config.reduce_sar_type1",
		.value = "460,423",
	},
	{
		.key = "ro.config.reduce_sar_type2",
		.value = "001,234",
	},
	{
		.key = "ro.config.ringtone2",
		.value = "Hello_Ya.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Huawei_Tune.ogg",
	},
	{
		.key = "ro.config.show2846",
		.value = "true",
	},
	{
		.key = "ro.config.show6130",
		.value = "true",
	},
	{
		.key = "ro.config.show_mms_storage",
		.value = "true",
	},
	{
		.key = "ro.config.show_nw_mode",
		.value = "true",
	},
	{
		.key = "ro.config.show_sim_icon",
		.value = "true",
	},
	{
		.key = "ro.config.smart_rotation",
		.value = "false",
	},
	{
		.key = "ro.config.sms_set_cmms",
		.value = "true",
	},
	{
		.key = "ro.config.sprd_refresh_rsp",
		.value = "true",
	},
	{
		.key = "ro.config.switchPrimaryVolume",
		.value = "true",
	},
	{
		.key = "ro.config.themecolor",
		.value = "true",
	},
	{
		.key = "ro.config.updatelocation",
		.value = "true",
	},
	{
		.key = "ro.config.utkShowIcon",
		.value = "true",
	},
	{
		.key = "ro.config.widevine_level3",
		.value = "true",
	},
	{
		.key = "ro.config.wifiManager_k3",
		.value = "true",
	},
	{
		.key = "ro.connectivity.chiptype",
		.value = "hi110x",
	},
	{
		.key = "ro.connectivity.sta_p2p_coex",
		.value = "false",
	},
	{
		.key = "ro.crypto.fs_flags",
		.value = "0x00000406",
	},
	{
		.key = "ro.crypto.fs_mnt_point",
		.value = "/data",
	},
	{
		.key = "ro.crypto.fs_options",
		.value = "discard,noauto_da_alloc,mblk_io_submit,data=ordered",
	},
	{
		.key = "ro.crypto.fs_real_blkdev",
		.value = "/dev/block/mmcblk0p40",
	},
	{
		.key = "ro.crypto.fs_type",
		.value = "ext4",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.cust.cdrom",
		.value = "/cust/preinstalled/public/cdrom/autorun.iso",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.dual.sim.phone",
		.value = "true",
	},
	{
		.key = "ro.enable_boot_charger_mode",
		.value = "0",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.hardware",
		.value = "hi6210sft",
	},
	{
		.key = "ro.huawei.cust.toolbox_airwifi",
		.value = "true",
	},
	{
		.key = "ro.hw_sglte_shareantenna",
		.value = "true",
	},
	{
		.key = "ro.hwcamera.back.pixels",
		.value = "1300",
	},
	{
		.key = "ro.hwcamera.sound.muteable",
		.value = "true",
	},
	{
		.key = "ro.hwpp_dorecoverylevel",
		.value = "1",
	},
	{
		.key = "ro.hwtheme.widgetpic.dismiss",
		.value = "false",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "48",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "72",
	},
	{
		.key = "ro.image",
		.value = "bootimage",
	},
	{
		.key = "ro.media.NxpSmartPARaise15",
		.value = "true",
	},
	{
		.key = "ro.modem.type",
		.value = "sprd",
	},
	{
		.key = "ro.multi.rild",
		.value = "true",
	},
	{
		.key = "ro.networkstatus.delay",
		.value = "3",
	},
	{
		.key = "ro.opengles.version",
		.value = "131072",
	},
	{
		.key = "ro.poweroff_alarm",
		.value = "true",
	},
	{
		.key = "ro.product.CustCVersion",
		.value = "C185",
	},
	{
		.key = "ro.product.CustDVersion",
		.value = "D001",
	},
	{
		.key = "ro.product.alert_time",
		.value = "true",
	},
	{
		.key = "ro.product.board",
		.value = "BalongV8R1SFT",
	},
	{
		.key = "ro.product.brand",
		.value = "Huawei",
	},
	{
		.key = "ro.product.cmcc.rtspcon",
		.value = "true",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cucc.rtsplive",
		.value = "true",
	},
	{
		.key = "ro.product.device",
		.value = "hwALE-H",
	},
	{
		.key = "ro.product.hardwareversion",
		.value = "Ver.A",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "HUAWEI",
	},
	{
		.key = "ro.product.model",
		.value = "ALE-L21",
	},
	{
		.key = "ro.product.name",
		.value = "ALE-L21",
	},
	{
		.key = "ro.product.only_2Gnetwork",
		.value = "false",
	},
	{
		.key = "ro.product.platform.pseudonym",
		.value = "1ARB9CV",
	},
	{
		.key = "ro.product.streaming.custom",
		.value = "true",
	},
	{
		.key = "ro.projectmenu.chargemaxlevel",
		.value = "73",
	},
	{
		.key = "ro.projectmenu.chargeminlevel",
		.value = "58",
	},
	{
		.key = "ro.projectmenuact.v8r2",
		.value = "true",
	},
	{
		.key = "ro.pwrtmg.aegis.state",
		.value = "20",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.ecclist",
		.value = "112,911,#911,*911",
	},
	{
		.key = "ro.runmode",
		.value = "normal",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1339454",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "W3D7N17626001128",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "DISABLED",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sys.umsdirtyratio",
		.value = "2",
	},
	{
		.key = "ro.systemui.mobileinoutextra",
		.value = "true",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.thmodem.type",
		.value = "sprd",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "show_preferred_network_mode",
		.value = "true",
	},
	{
		.key = "sys.aps.support",
		.value = "43",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.emergency.mountdata",
		.value = "0",
	},
	{
		.key = "sys.hwsholder.count",
		.value = "0",
	},
	{
		.key = "sys.iswifihotspoton",
		.value = "false",
	},
	{
		.key = "sys.nsd.launcherbottom",
		.value = "1150",
	},
	{
		.key = "sys.nsd.launchertop",
		.value = "50",
	},
	{
		.key = "sys.open_wifi_pid",
		.value = "3088",
	},
	{
		.key = "sys.settings_global_version",
		.value = "3",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "2",
	},
	{
		.key = "sys.settings_system_version",
		.value = "2",
	},
	{
		.key = "sys.settings_systemex_version",
		.value = "5",
	},
	{
		.key = "sys.show_google_nlp",
		.value = "true",
	},
	{
		.key = "sys.super_power_save",
		.value = "false",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "10800",
	},
	{
		.key = "sys.usb.config",
		.value = "hisuite,mtp,mass_storage,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "hisuite,mtp,mass_storage,adb",
	},
	{
		.key = "trustedcore_sfs_property",
		.value = "1",
	},
	{
		.key = "viatel.device.at",
		.value = "spi.10.ttySPI",
	},
	{
		.key = "viatel.device.data",
		.value = "spi.0.ttySPI",
	},
	{
		.key = "viatel.device.fls",
		.value = "spi.2.ttySPI",
	},
	{
		.key = "viatel.device.gps",
		.value = "spi.5.ttySPI",
	},
	{
		.key = "viatel.device.pcv",
		.value = "spi.4.ttySPI",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{NULL},
};
#endif /* __ANDROID__ */
