#include "httpdispatcher"

void HttpDispatcher::senderrorpage(string const &reason) {
    PROFILE("HttpDispatcher::senderrorpage");
    
    msg("Sending error page to client: '" << reason << "'\n");
    try {
	string txt =
	    "<html>\n"
	    " <head>\n"
	    "  <title>Internal Server Error</title>\n"
	    " </head>\n"
	    " <body>\n"
	    "  <h1>Internal Server Error</h1>\n"
	    "  You request could not be completed. Please retry later.<p/>"
	    "  (" + reason + ")\n"
	    " </body>\n"
	    "</html>\n";
	ostringstream mess;
	mess <<
	    "HTTP/1.0 502 Internal Server Error\r\n"
	    "Content-Length: " << txt.size() << "\r\n"
	    "XR-Reason: " << reason << "\r\n"
	    "\r\n" <<
	    txt;
	Netbuffer buf(mess.str());
	buf.netwrite(clientfd(), config.client_write_timeout());
    } catch (Error const &e) {
	// Silently discard, we are not interested in errors
	// that ocur when an error page is being sent
	msg (e.what() << " (while sending error page)\n");
    }
}
