#include "mutextable"

/*
 * How to hash a pointer into an unsigned. Based on the famous hashpjw()
 * function.
 */

// #define DEBUG
unsigned MutexTable::hash(void *obj) {
    unsigned v = 0;
    unsigned char *cp = (unsigned char *)obj;
    for (size_t i = 0; i < sizeof(obj); i++) {
	v <<= 4;
	v |= *cp++;
	if (unsigned g = v & 0xf0000000) {
	    v = v ^ ( g >> 24 );
	    v = v ^ g;
	}
    }
    v %= _size;

#   ifdef DEBUG    
    debugmsg("Pointer " << obj << " hashed to bucket " << v <<
	     " (given size " << _size << ")\n");
#   endif
    
    return v;
}
