#ifndef __event_h__
#define __event_h__

// Classes representing different event types.

#include <string>
#include "DasherTypes.h"


namespace Dasher {
  class CEditEvent;
  class CGameNodeDrawEvent;
  class CDasherNode; //fwd decl, avoid include...we just store ptr
}
/// \ingroup Core
/// @{

/// \defgroup Events Events generated by Dasher modules.
/// @{

/**
 * An event that notifies listeners that a node previously flagged for
 * game mode has been drawn.
 */
class Dasher::CGameNodeDrawEvent {
public:
  CGameNodeDrawEvent(CDasherNode* pNode, myint y1, myint y2)
    : m_pNode(pNode), m_y1(y1), m_y2(y2) {
  };
  
  /**
   * The node itself.
   */
  CDasherNode* m_pNode;

  /**
   * the y range of the node (in dasher coords)
   */
  myint m_y1, m_y2;
};

class Dasher::CEditEvent {
  friend class CDasherInterfaceBase;
  CEditEvent(int iEditType, const std::string & sText, CDasherNode *pNode)
  : m_iEditType(iEditType), m_sText(sText), m_pNode(pNode) {
  };  
public:
  static const int EDIT_OUTPUT=1, EDIT_DELETE=2, EDIT_CONVERT=10, EDIT_PROTECT=11;
  const int m_iEditType;
  const std::string m_sText;
  /// Node causing the event - allows calling GetSymbolProb, offset(), etc.
  /// _if necessary_
  const CDasherNode *m_pNode;
};

/// @}
/// @}

#endif
