package memoplugin.ui;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import memoplugin.Db4oProvider;

import com.db4o.ObjectSet;

public class DataDialog extends Dialog {
	private static int ID_ADD = 100;
	private static int ID_DELETE = 101;
	private Shell _shell;
    /**
     * The title of the dialog.
     */
    private String title;

    /**
     * The message to display, or <code>null</code> if none.
     */
    private String message;

    /**
     * The input value; the empty string by default.
     */
    private String value = "";//$NON-NLS-1$

    
    /**
     * Add button widget.
     */
    private Button addButton;

    /**
     * Delete button widget.
     */
    private Button deleteButton;

    /**
     * Input text widget.
     */
    private Text text;

    /**
     * List widget.
     */
    private List list;
    

    public DataDialog(Shell parentShell, String dialogTitle,
            String dialogMessage, String initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        message = dialogMessage;
        if (initialValue == null) {
			value = "";//$NON-NLS-1$
		} else {
			value = initialValue;
		}
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
     */
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        _shell = shell;
        if (title != null) {
			shell.setText(title);
		}
    }

    /*
     * Clears the database before adding new data
     */
    private void clearDb(){
    	ObjectSet result = Db4oProvider.database().get(ArrayList.class);
		while (result.hasNext()){
			Db4oProvider.database().delete(result.next());
		}
    }
    
    /*
     * (non-Javadoc)
     * Makes sure that all the data is saved to the 
     * database before closing the dialog
     */
    protected void handleShellCloseEvent() {
    	clearDb();
    	ArrayList data = new ArrayList();
    	for (int i=0; i < list.getItemCount(); i++){
    		data.add(list.getItem(i));
    	}
    	Db4oProvider.database().set(data);
    	Db4oProvider.database().commit();
    	Db4oProvider.database().ext().purge(ArrayList.class);
    	super.handleShellCloseEvent();
    }
    
    /*
     * Button events handler
     */
    protected void buttonPressed(int buttonId) {
        if (buttonId == ID_ADD) {
            value = text.getText();
            list.add(value);
        } else if (buttonId == ID_DELETE){
        	int selectedId = list.getSelectionIndex();
        	if (selectedId == -1){
        		new MessageDialog(_shell, "Error",
        	            null, "No item selected", MessageDialog.ERROR,
        	            new String[]{"Ok"}, 0).open(); 
        	} else {
        		list.remove(selectedId);
        	}
            value = null;
        } else {
        	super.buttonPressed(buttonId);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
     */
    protected void createButtonsForButtonBar(Composite parent) {
        // create Add and Delete buttons by default
        addButton = createButton(parent, ID_ADD,
                "Add", true);
        createButton(parent, ID_DELETE,
                "Delete", false);
        //do this here because setting the text will set enablement on the ok
        // button
        text.setFocus();
        if (value != null) {
            text.setText(value);
            text.selectAll();
        }
    }

    /*
     * (non-Javadoc) Creates the visual dialog representation
     */
    protected Control createDialogArea(Composite parent) {
        // create composite
        Composite composite = (Composite) super.createDialogArea(parent);
        // create message
        if (message != null) {
            Label label = new Label(composite, SWT.WRAP);
            label.setText(message);
            GridData gridData = new GridData(GridData.GRAB_HORIZONTAL
                    | GridData.GRAB_VERTICAL | GridData.HORIZONTAL_ALIGN_FILL
                    | GridData.VERTICAL_ALIGN_CENTER);
            gridData.widthHint = convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH);
            label.setLayoutData(gridData);
            label.setFont(parent.getFont());
        }
        text = new Text(composite, SWT.SINGLE | SWT.BORDER);
        text.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
                | GridData.HORIZONTAL_ALIGN_FILL));
        
        list = new List(composite, SWT.SINGLE|SWT.H_SCROLL|SWT.V_SCROLL);
        GridData gridData = new GridData(SWT.FILL,SWT.FILL, true, true);
        gridData.heightHint = 50;
        list.setLayoutData(gridData);
        ObjectSet result = Db4oProvider.database().query(ArrayList.class);
        if (result.size() != 0){
        	ArrayList data = (ArrayList)result.next();
        	String[] items = new String[data.size()];
        	for (int i=0; i < data.size(); i++){
        		items[i] = (String)data.get(i);
        	}
        	list.setItems(items);
        }

      
        applyDialogFont(composite);
        return composite;
    }


    /**
     * Returns the string typed into this input dialog.
     * 
     * @return the input string
     */
    public String getValue() {
        return value;
    }

}
