/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "range.h"
#include "font.h"
#include "utils.h"
#include "random.h"
#include <map>
using namespace std;


void range::calc (int octave, float start, map<string, float>& _intervals) {

  float start_interval = _intervals [intervals[0]];
  float end_interval = _intervals [intervals[1]];
  clamp<float> (1, start_interval, 2);
  clamp<float> (1, end_interval, 2);

  float start_frequency = start_interval * start;
  float end_frequency = end_interval * start;

  notes[0].set_frequency (start_frequency);
  notes[0].octave_position = octave + start_interval - 1;

  notes[1].set_frequency (end_frequency);
  notes[1].octave_position = octave + end_interval - 1;

  delta_step = notes[1].step - notes[0].step;
  delta_octave_position = notes[1].octave_position - notes[0].octave_position;

}

void range::draw_labels (int label_what, int show_frequency) {

  static float kr = 0.3, kg = 1, kb = 0.3; // key color
  static float fr = 0.3, fg = fr, fb = fr; // frequency color
  static float nr = 1, ng = nr, nb = nr; // normal color

  float r0, g0, b0;
  float r1, g1, b1;

  if (key == range::LEFT) {
    r0 = kr; g0 = kg; b0 = kb;
    r1 = kr; g1 = kg; b1 = kb;
  } else {
    r0 = nr; g0 = ng; b0 = nb;
    r1 = fr; g1 = fg; b1 = fb;
  }

  glColor3f (r0, g0, b0);
  glBegin (GL_LINES);
    glVertex2i (extents.left, extents.bottom);
    glVertex2i (extents.left, extents.top);
  glEnd ();
  draw_string (notes[0].name, extents.left, ytop1);
  draw_string (notes[0].name, extents.left, ybot1);

  if (show_frequency) {
    glColor3f (r1, g1, b1);
    draw_string (notes[0].hz_name, extents.left, ybot2);
    draw_string (notes[0].hz_name, extents.left, ytop2);
  }

  if (label_what == BOTH) {

    if (key == range::RIGHT) {
      r0 = kr; g0 = kg; b0 = kb;
      r1 = kr; g1 = kg; b1 = kb;
    } else {
      r0 = nr; g0 = ng; b0 = nb;
      r1 = fr; g1 = fg; b1 = fb;
    }

    glColor3f (r0, g0, b0);
    glBegin (GL_LINES);
      glVertex2i (extents.right, extents.bottom);
      glVertex2i (extents.right, extents.top);
    glEnd ();

    draw_string (notes[1].name, extents.right, ybot1);
    draw_string (notes[1].name, extents.right, ytop1);

    if (show_frequency) {
      glColor3f (r1, g1, b1);
      draw_string (notes[1].hz_name, extents.right, ybot2);
      draw_string (notes[1].hz_name, extents.right, ytop2);
    }

  }

  glColor3f (fr, fr, fr);
  draw_string (octave, extents.midx, extents.midy);


}
