
************** File: testdoc.do.txt *****************
<%doc>
This is a test on Doconce.
The Mako preprocessor is used.
</%doc>

TITLE: A Test Document
AUTHOR: Hans Petter Langtangen Email: hpl@simula.no at Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo
AUTHOR: Kaare Dump at Segfault Inc, Cyberspace
AUTHOR: A. Dummy Author
AUTHOR: I. S. Overworked at Inst1 and Inst2, Somewhere and Third Inst, Elsewhere and Fourth Inst
AUTHOR: J. Doe mail: j_doe@cyberspace.com
# latex demands DATE
DATE: today

The format of this document is
% if FORMAT == 'html':
plain, homemade HTML (from Doconce).
  % elif FORMAT == 'latex':
plain, homemade LaTeX (from Doconce).
  % elif FORMAT == 'pdflatex':
plain, homemade pdfLaTeX (from Doconce).
  %else:
${FORMAT}
% endif


__Abstract.__
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

========= Chapter 1 =========

======= Section 0 =======

======= Section 1 =======
label{sec1}

Just a little bit of text
and then a list:

  * item1
  * item2
  * item3 which continues
    on the next line to test that feature
  * and a sublist
    * with indented subitem1
    * and a subitem2
  * and perhaps an ordered sublist
    o first item
    o second item,
      continuing on a new line

===== Subsection 1 =====

More text, with a reference back to Section ref{sec1} and further
to Section ref{subsubsec:ex}. idx{`somefunc` function}

Let's do some copying from files too. First from subroutine up to the very end,

@@@CODE ../doc/manual/__testcode.f fromto: subroutine@
and then just the subroutine,
@@@CODE ../doc/manual/__testcode.f from-to:a comment@^C\s+END1
and finally the complete file:
@@@CODE ../doc/manual/__testcode.f

===== Subsection 2 =====
label{subsec:ex}
idx{figures}

Test of figures.

FIGURE:[../doc/manual/figs/streamtubes, width=200] Visualization of flow by streamtubes. label{fig:impact}

idx{movies}
Test of movies.

MOVIE: [../doc/manual/figs/mjolnir.mpeg, width=700 height=400] Mjolnir tsunami (by Sylfest Glimsdal).

# Empty caption:

MOVIE: [../doc/manual/figs/wavepacket.mpeg, width=700 height=400]

MOVIE: [../doc/manual/figs/wavepacket_*.png, width=700 height=400] Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie).

# Check out the correct with and height of YouTube movies from the
# embed command that the YouTube page can generate

MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

===== Table Demo =====
label{subsec:table}

Let us take this table from the manual:
idx{some `class X` which is convenient}

% if FORMAT == "latex":
\begin{table}
\caption{
Table of velocity and acceleration.
label{mytab}
}
% endif

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

% if FORMAT == "latex":
\end{table}
% endif

The Doconce source code reads
!bc cod
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
!ec

Here is yet another table to test that we can handle more than
one table:

  |--l-------l----------l----------|
  |time  | velocity | acceleration |
  |--l-------l----------l----------|
  | 0.0  | 1.4186   | -5.01        |
  | 1.0  | 1.376512 | 11.919       |
  | 3.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

===== URLs ======
label{subsubsec:ex}

Here are some nice URLs, e.g., hpl's home page "hpl":"http://folk.uio.no/hpl",
or the URL if desired, "URL": "http://folk.uio.no/hpl".
Here is a plain file link "URL": "testdoc.do.txt", or "url":"testdoc.do.txt",
or URL: "testdoc.do.txt" or url : "testdoc.do.txt" or "a link
with newline": "testdoc.do.txt". Can test spaces
with the link with word too: "hpl": "http://folk.uio.no/hpl" or
"hpl" : "http://folk.uio.no/hpl". The old syntax must also be
tested: http://folk.uio.no/hpl<hpl's homepage>. Now also `file:///`
works: "link to a file":"file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html"
is fine to have.

# Comments should be inserted outside paragraphs (because of reST):
# note that when there is no http: or file:, it can be a file link
# if the link name is URL, url, "URL", or "url".

% if FORMAT == "latex":

===== Some LaTeX Constructs =====

Let's check abbr. of some common kind, e.g. the well-known i.e.
7-9 as an example. Moreover, Dr. Tang and Prof. Monsen,
or maybe also prof. Ting,
will go to the Dept. of Science to test how Mr. Hansen is doing together
with Ms. Larsen. A sentence containing "refines lines" could easily
fool a regex substitution with only i.e. since the dot matches anything.
Also, look at Fig. 4 to see how the data compares with Tab. ref{mytab}.
% endif

===== LaTeX Mathematics =====

Here is an equation without label using backslash-bracket environment:
!bt
\[ a = b + c \]
!et
or with number and label, as in (ref{my:eq1}), using the equation environment:
!bt
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
!et
We can refer to this equation by (ref{my:eq1}).

Here is a system without equation numbers, using the align-astrisk environment:
!bt
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\
b &= \nabla^2 u + \nabla^4 v
\end{align*}
!et


% if FORMAT in ('latex', 'pdflatex', 'sphinx', 'html', 'pandoc'):
And here is a system of equations with labels in an align environment:
!bt
\begin{align}
a &= q + 4 + 5+ 6 label{eq1} \\
b &= \nabla^2 u + \nabla^4 x label{eq2}
\end{align}
!et
We can refer to (ref{eq1})-(ref{eq2}).

Or with multline?
!bt
\begin{multline}
a = b = q + \\
  f + \nabla\cdot\nabla u
label{multiline:eq1}
\end{multline}
!et
Maybe split is better:
!bt
\begin{equation}
label{split:envir:eq}
\begin{split}
a = b = q &+ \\
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
!et
And we can refer to the last equation by (ref{split:envir:eq}).

What about gather?
!bt
\begin{gather}
a = b \\
c = d + 7 + 9
\end{gather}
!et

And what about alignat?
!bt
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 label{eq1a} \\
b &= \nabla^2 u + \nabla^4 x & x\in\Omega label{eq2a}
\end{alignat}
!et
Let us refer to (ref{eq1})-(ref{eq2}) again, and to the
alignat variant (ref{eq1a})-(ref{eq2a}), and to (ref{my:eq1}).

Here is eqnarray in action:
!bt
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g label{myeq2}
\end{eqnarray}
!et
% endif

More mathematical typesetting is demonstrated in the exercises below.

======= Exercises =======

===== Problem: Flip a Coin =====
label{demo:ex:1}
file = flip_coin.py
solution = mysol.txt

Make a program that simulates flipping a coin $N$ times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.


__Hint 1.__ Use `r = random.random()` and define head as `r <= 0.5`.

__Hint 2.__ Draw an integer among $\{1,2\}$ with
`r = random.randint(1,2)` and define head when `r` is 1.


===== Exercise: Compute a Probability =====

label{demo:ex:2}  solution =/my/home/hpl/sol/file1.txt

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard `random` module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$. Run the program with the four
values $N=10^i$ for $i=1,2,3,6$.

===== Project: Explore Distributions of Random Circles =====

label{proj:circle1}
file=circles.pdf

The formula for a circle is given by
!bt
\begin{align}
x &= x_0 + R\cos 2\pi t,\\
y &= y_0 + R\sin 2\pi t,
\end{align}
!et
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ is a point on the circle.
The formula can be used to generate `n` points on a circle:
!bc pycod
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
!ec

# Often in an exercise we have some comments about the solution
# which we normally want to migrate to the end.

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the `circle` function
above. The following cases should be explored:

 * $R$ normally distributed and $(x_0,y_0)$ uniformly distributed
 * $R$ uniformly distributed and $(x_0,y_0)$ normally distributed
 * $R$ and $(x_0,y_0)$ normally distributed

__Hint.__ Use the `numpy.random` module to draw the
$x_0$, $y_0$, and $R$ quantities.



************** File: testdoc.html *****************
<?xml version="1.0" encoding="utf-8" ?>
<!--
Automatically generated HTML file from Doconce source
(http://code.google.com/p/doconce/)
-->

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="generator" content="Doconce: http://code.google.com/p/doconce/" />

<script type="text/javascript"
 src="http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>

</head>

<body bgcolor="white">
    
<P>

<P>
<title>A Test Document</title>
<center><h1>A Test Document</h1></center>
<center>
<b>Hans Petter Langtangen</b> [1, 2] (<tt>hpl</tt> at <tt>simula.no</tt>)
</center>

<center>
<b>Kaare Dump</b> [3]
</center>

<center>
<b>A. Dummy Author</b> 
</center>

<center>
<b>I. S. Overworked</b> [4, 5, 6, 7]
</center>

<center>
<b>J. Doe</b>  (<tt>j_doe</tt> at <tt>cyberspace.com</tt>)
</center>

<p>
<center>[1] <b>Center for Biomedical Computing, Simula Research Laboratory</b></center>
<center>[2] <b>Department of Informatics, University of Oslo</b></center>
<center>[3] <b>Segfault Inc, Cyberspace</b></center>
<center>[4] <b>Inst1</b></center>
<center>[5] <b>Inst2, Somewhere</b></center>
<center>[6] <b>Third Inst, Elsewhere</b></center>
<center>[7] <b>Fourth Inst</b></center>


<!-- latex demands DATE -->
<center><h3>Jan 32, 2100</h3></center>
<P>
The format of this document is
plain, homemade HTML (from Doconce).

<P>

<P>
<b>Abstract.</b> This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

<P>
And exactly for test purposes we have an extra line here, which
is part of the abstract.

<P>
<h1>Chapter 1</h1>
<P>
<h2>Section 0</h2>
<P>
<h2>Section 1 <a name="sec1"></A></h2>
<P>

<P>
Just a little bit of text
and then a list:

<P>

<ul>
  <li> item1
  <li> item2
  <li> item3 which continues
    on the next line to test that feature
  <li> and a sublist

<ul>
    <li> with indented subitem1
    <li> and a subitem2
</ul>

  <li> and perhaps an ordered sublist

<ol>
   <li> first item
   <li> second item,
      continuing on a new line
</ol>

</ul>
<h3>Subsection 1</h3>
<P>
More text, with a reference back to the section <a href="#sec1">Section 1</a> and further
to the section <a href="#subsubsec:ex">URLs</a>. 
Let's do some copying from files too. First from subroutine up to the very end,

<P>
<blockquote>    <!-- begin verbatim block   fcod-->
<pre>
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</pre>
</blockquote>   <! -- end verbatim block -->
and then just the subroutine,
<blockquote>    <!-- begin verbatim block   fcod-->
<pre>

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
</pre>
</blockquote>   <! -- end verbatim block -->
and finally the complete file:
<blockquote>    <!-- begin verbatim block   fpro-->
<pre>
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h3>Subsection 2 <a name="subsec:ex"></A></h3>
<P>

<P>
Test of figures.

<P>
<center><hr>
<caption><i>Visualization of flow by streamtubes. <a name="fig:impact"></A></i></caption>
<p><img src="../doc/manual/figs/streamtubes.png" align="bottom" width=200></p>
</center>

<P>
Test of movies.

<P>

<embed src="../doc/manual/figs/mjolnir.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
<p>
<em> Mjolnir tsunami (by Sylfest Glimsdal).</em>
</p>


<P>
<!-- Empty caption: -->

<P>

<embed src="../doc/manual/figs/wavepacket.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
<p>
<em></em>
</p>


<P>

<p><a href="wavepacket_0001.html">Movie of files <tt>../doc/manual/figs/wavepacket_*.png</tt></a>
<em> Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie).</em></p>

<P>
<!-- Check out the correct with and height of YouTube movies from the -->
<!-- embed command that the YouTube page can generate -->

<P>
MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

<P>
<h3>Table Demo <a name="subsec:table"></A></h3>
<P>

<P>
Let us take this table from the manual:

<P>

<P>
<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="left">   0.0             </td> <td align="right">   1.4186          </td> <td align="right">   -5.01           </td> </tr>
<tr><td align="left">   2.0             </td> <td align="right">   1.376512        </td> <td align="right">   11.919          </td> </tr>
<tr><td align="left">   4.0             </td> <td align="right">   1.1E+1          </td> <td align="right">   14.717624       </td> </tr>
</table>
<P>

<P>
The Doconce source code reads
<blockquote>    <!-- begin verbatim block   cod-->
<pre>
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Here is yet another table to test that we can handle more than
one table:

<P>
<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="left">   0.0             </td> <td align="left">   1.4186          </td> <td align="left">   -5.01           </td> </tr>
<tr><td align="left">   1.0             </td> <td align="left">   1.376512        </td> <td align="left">   11.919          </td> </tr>
<tr><td align="left">   3.0             </td> <td align="left">   1.1E+1          </td> <td align="left">   14.717624       </td> </tr>
</table>
<P>
<h3>URLs <a name="subsubsec:ex"></A></h3>
<P>

<P>
Here are some nice URLs, e.g., hpl's home page <a href="http://folk.uio.no/hpl">hpl</a>,
or the URL if desired, <a href="http://folk.uio.no/hpl"><tt>http://folk.uio.no/hpl</tt></a>.
Here is a plain file link <a href="testdoc.do.txt"><tt>testdoc.do.txt</tt></a>, or <a href="testdoc.do.txt"><tt>testdoc.do.txt</tt></a>,
or <a href="testdoc.do.txt"><tt>testdoc.do.txt</tt></a> or <a href="testdoc.do.txt"><tt>testdoc.do.txt</tt></a> or <a href="testdoc.do.txt">a link
with newline</a>. Can test spaces
with the link with word too: <a href="http://folk.uio.no/hpl">hpl</a> or
<a href="http://folk.uio.no/hpl">hpl</a>. The old syntax must also be
tested: <a href="http://folk.uio.no/hpl">hpl's homepage</a>. Now also <tt>file:///</tt>
works: <a href="file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html">link to a file</a>
is fine to have.

<P>
<!-- Comments should be inserted outside paragraphs (because of reST): -->
<!-- note that when there is no http: or file:, it can be a file link -->
<!-- if the link name is URL, url, "URL", or "url". -->

<P>

<P>
<h3>LaTeX Mathematics</h3>
<P>
Here is an equation without label using backslash-bracket environment:
$$ a = b + c $$
or with number and label, as in (<a href="#my:eq1">my:eq1</a>), using the equation environment:
$$
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}
$$
We can refer to this equation by (<a href="#my:eq1">my:eq1</a>).

<P>
Here is a system without equation numbers, using the align-astrisk environment:
$$
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
$$

<P>

<P>
And here is a system of equations with labels in an align environment:
$$
\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}
$$
We can refer to (<a href="#eq1">eq1</a>)-(<a href="#eq2">eq2</a>).

<P>
Or with multline?
$$
\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}
$$
Maybe split is better:
$$
\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
$$
And we can refer to the last equation by (<a href="#split:envir:eq">split:envir:eq</a>).

<P>
What about gather?
$$
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}
$$

<P>
And what about alignat?
$$
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}
$$
Let us refer to (<a href="#eq1">eq1</a>)-(<a href="#eq2">eq2</a>) again, and to the
alignat variant (<a href="#eq1a">eq1a</a>)-(<a href="#eq2a">eq2a</a>), and to (<a href="#my:eq1">my:eq1</a>).

<P>
Here is eqnarray in action:
$$
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}
$$

<P>
More mathematical typesetting is demonstrated in the exercises below.

<P>
<h2>Exercises</h2>
<P>
<h3>Flip a Coin <a name="demo:ex:1"></A></h3>
<P>

<P>
Make a program that simulates flipping a coin \( N \) times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

<P>
<b>Hint 1.</b> Use <tt>r = random.random()</tt> and define head as <tt>r <= 0.5</tt>.

<P>
<b>Hint 2.</b> Draw an integer among \( \{1,2\} \) with
<tt>r = random.randint(1,2)</tt> and define head when <tt>r</tt> is 1.
<em>Filename</em>: <tt>flip_coin.py</tt>

<P>

<P>
<h3>Compute a Probability <a name="demo:ex:2"></A></h3>
<P>

<P>
What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval \( [0,1) \)?
To answer this question empirically, let a program
draw \( N \) such random numbers using Python's standard <tt>random</tt> module,
count how many of them, \( M \), that fall in the interval \( (0.5,0.6) \), and
compute the probability as \( M/N \). Run the program with the four
values \( N=10^i \) for \( i=1,2,3,6 \).

<P>

<P>
<h3>Explore Distributions of Random Circles <a name="proj:circle1"></A></h3>
<P>

<P>
The formula for a circle is given by
$$
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
$$
where \( R \) is the radius of the circle, \( (x_0,y_0) \) is the
center point, and \( t \) is a parameter in the unit interval \( [0,1] \).
For any \( t \), \( (x,y) \) is a point on the circle.
The formula can be used to generate <tt>n</tt> points on a circle:
<blockquote>    <!-- begin verbatim block   pycod-->
<pre>
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
</pre>
</blockquote>   <! -- end verbatim block -->

<P>

<P>
The goal of this project is to draw \( N \) circles with random
center and radius. Plot each circle using the <tt>circle</tt> function
above. The following cases should be explored:

<P>

<ul>
 <li> \( R \) normally distributed and \( (x_0,y_0) \) uniformly distributed
 <li> \( R \) uniformly distributed and \( (x_0,y_0) \) normally distributed
 <li> \( R \) and \( (x_0,y_0) \) normally distributed
</ul>

<b>Hint.</b> Use the <tt>numpy.random</tt> module to draw the
\( x_0 \), \( y_0 \), and \( R \) quantities.
<em>Filename</em>: <tt>circles.pdf</tt>

<P>
<!-- Often in an exercise we have some comments about the solution -->
<!-- which we normally want to migrate to the end. -->

</body>
</html>
    
************** File: testdoc.p.tex *****************
%%
%% Automatically generated ptex2tex (extended LaTeX) file
%% from Doconce source
%% http://code.google.com/p/doconce/
%%

% #ifdef BOOK
\documentclass{book}
% #else
\documentclass{article}
% #endif

\usepackage{relsize,epsfig,makeidx,amsmath,amsfonts}
\usepackage[latin1]{inputenc}
\usepackage{ptex2tex}
% #ifdef MOVIE15
\usepackage{movie15}
% #endif
% #ifdef MINTED
\usepackage{minted}  % requires latex -shell-escape (for Minted_* ptex2tex envirs)
% #endif

% #ifdef HELVETICA
% Set helvetica as the default font family:
\RequirePackage{helvet}
\renewcommand\familydefault{phv}
% #endif

\usepackage[%
colorlinks=true,
linkcolor=blue,
citecolor=black,
filecolor=blue,
urlcolor=blue]{hyperref}
%\hyperbaseurl{}   % hyperlinks are relative to this root

\newcommand{\inlinecomment}[2]{  ({\bf #1}: \emph{#2})  }
%\newcommand{\inlinecomment}[2]{}  % turn off inline comments

\makeindex

\begin{document}





% #ifndef LATEX_HEADING
% #define LATEX_HEADING
% #endif

% ----------------- Title -------------------------
% #if LATEX_HEADING == "traditional"

\title{A Test Document}

% #elif LATEX_HEADING == "titlepage"

\thispagestyle{empty}
\hbox{\ \ }
\vfill
\begin{center}
{\huge{\bfseries{A Test Document}}}

% #else

\begin{center}
{\LARGE\bf A Test Document}
\end{center}

% #endif



% ----------------- Author(s) -------------------------
% #if LATEX_HEADING == "traditional"
\author{Hans Petter Langtangen\footnote{Email: \texttt{hpl@simula.no}. Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo.}
\and Kaare Dump\footnote{Segfault Inc, Cyberspace.}
\and A. Dummy Author
\and I. S. Overworked\footnote{Inst1; Inst2, Somewhere; Third Inst, Elsewhere; and Fourth Inst.}
\and J. Doe\footnote{Email: \texttt{j\_doe@cyberspace.com}.}}

% #elif LATEX_HEADING == "titlepage"
\vspace{1.3cm}

{\Large\textsf{Hans Petter Langtangen${}^{1, 2}$ (\texttt{hpl@simula.no})}}\\ [3mm]

{\Large\textsf{Kaare Dump${}^{3}$}}\\ [3mm]

{\Large\textsf{A. Dummy Author${}^{}$}}\\ [3mm]

{\Large\textsf{I. S. Overworked${}^{4, 5, 6, 7}$}}\\ [3mm]

{\Large\textsf{J. Doe${}^{}$ (\texttt{j\_doe@cyberspace.com})}}\\ [3mm]

\ \\ [2mm]

{\large\textsf{${}^1$Center for Biomedical Computing, Simula Research Laboratory} \\ [1.5mm]}
{\large\textsf{${}^2$Department of Informatics, University of Oslo} \\ [1.5mm]}
{\large\textsf{${}^3$Segfault Inc, Cyberspace} \\ [1.5mm]}
{\large\textsf{${}^4$Inst1} \\ [1.5mm]}
{\large\textsf{${}^5$Inst2, Somewhere} \\ [1.5mm]}
{\large\textsf{${}^6$Third Inst, Elsewhere} \\ [1.5mm]}
{\large\textsf{${}^7$Fourth Inst} \\ [1.5mm]}

% #else

\begin{center}
{\bf Hans Petter Langtangen${}^{1, 2}$ (\texttt{hpl@simula.no})} \\ [0mm]
\end{center}


\begin{center}
{\bf Kaare Dump${}^{3}$} \\ [0mm]
\end{center}


\begin{center}
{\bf A. Dummy Author${}^{}$} \\ [0mm]
\end{center}


\begin{center}
{\bf I. S. Overworked${}^{4, 5, 6, 7}$} \\ [0mm]
\end{center}


\begin{center}
{\bf J. Doe${}^{}$ (\texttt{j\_doe@cyberspace.com})} \\ [0mm]
\end{center}

\begin{center}
% List of all institutions:
\centerline{{\small ${}^1$Center for Biomedical Computing, Simula Research Laboratory}}
\centerline{{\small ${}^2$Department of Informatics, University of Oslo}}
\centerline{{\small ${}^3$Segfault Inc, Cyberspace}}
\centerline{{\small ${}^4$Inst1}}
\centerline{{\small ${}^5$Inst2, Somewhere}}
\centerline{{\small ${}^6$Third Inst, Elsewhere}}
\centerline{{\small ${}^7$Fourth Inst}}
\end{center}
% #endif
% ----------------- End of author(s) -------------------------

% latex demands DATE


% ----------------- Date -------------------------

% #if LATEX_HEADING == "traditional"

\date{Jan 32, 2100}
\maketitle

% #elif LATEX_HEADING == "titlepage"

\ \\ [10mm]
{\large\textsf{Jan 32, 2100}}

\end{center}
\vfill
\clearpage

% #else

\begin{center}
Jan 32, 2100
\end{center}

% #endif

The format of this document is
plain, homemade {\LaTeX} (from Doconce).


\begin{abstract}
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.
\end{abstract}


\chapter{Chapter 1}


\section{Section 0}


\section{Section 1}

\label{sec1}

Just a little bit of text
and then a list:

\begin{itemize}
  \item item1

  \item item2

  \item item3 which continues
    on the next line to test that feature

  \item and a sublist
\begin{itemize}

    \item with indented subitem1

    \item and a subitem2

\end{itemize}

\noindent
  \item and perhaps an ordered sublist
\begin{enumerate}

   \item first item

   \item second item,
      continuing on a new line
\end{enumerate}

\noindent
\end{itemize}

\noindent

\subsection{Subsection 1}

More text, with a reference back to Section~\ref{sec1} and further
to Section~\ref{subsubsec:ex}. \index{somefunc@{\rm\texttt{somefunc}} function}

Let's do some copying from files too. First from subroutine up to the very end,

\bfcod
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\efcod
and then just the subroutine,
\bfcod

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\efcod
and finally the complete file:
\bfpro
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\efpro

\subsection{Subsection 2}

\label{subsec:ex}
\index{figures}

Test of figures.


\begin{figure}
  \centerline{\includegraphics[width=0.9\linewidth]{../doc/manual/figs/streamtubes.eps}}
  \caption{
  Visualization of flow by streamtubes. \label{fig:impact}
  }
\end{figure}


\index{movies}
Test of movies.


\begin{figure}[ht]
\begin{center}

% #ifdef MOVIE15
\includemovie[poster,
label=../doc/manual/figs/mjolnir.mpeg,
autoplay,
%controls,
%toolbar,
% #ifdef EXTERNAL_MOVIE_VIEWER
externalviewer,
% #endif
text={\small (Loading ../doc/manual/figs/mjolnir.mpeg)},
repeat,
]{0.9\linewidth}{0.9\linewidth}{../doc/manual/figs/mjolnir.mpeg}    % requires \usepackage{movie15}
% #ifndef EXTERNAL_MOVIE_VIEWER
\movieref[rate=0.5]{../doc/manual/figs/mjolnir.mpeg}{Slower}
\movieref[rate=2]{../doc/manual/figs/mjolnir.mpeg}{Faster}
\movieref[default]{../doc/manual/figs/mjolnir.mpeg}{Normal}
\movieref[pause]{../doc/manual/figs/mjolnir.mpeg}{Play/Pause}
\movieref[stop]{../doc/manual/figs/mjolnir.mpeg}{Stop}
% #else
\href{run:../doc/manual/figs/mjolnir.mpeg}{../doc/manual/figs/mjolnir.mpeg}
% #endif

% #else
\href{run:../doc/manual/figs/mjolnir.mpeg}{../doc/manual/figs/mjolnir.mpeg}

% alternative: \movie command that comes with beamer
% \movie[options]{../doc/manual/figs/mjolnir.mpeg}{../doc/manual/figs/mjolnir.mpeg}
% #endif
\end{center}
\caption{ Mjolnir tsunami (by Sylfest Glimsdal).}
\end{figure}


% Empty caption:


\begin{figure}[ht]
\begin{center}

% #ifdef MOVIE15
\includemovie[poster,
label=../doc/manual/figs/wavepacket.mpeg,
autoplay,
%controls,
%toolbar,
% #ifdef EXTERNAL_MOVIE_VIEWER
externalviewer,
% #endif
text={\small (Loading ../doc/manual/figs/wavepacket.mpeg)},
repeat,
]{0.9\linewidth}{0.9\linewidth}{../doc/manual/figs/wavepacket.mpeg}    % requires \usepackage{movie15}
% #ifndef EXTERNAL_MOVIE_VIEWER
\movieref[rate=0.5]{../doc/manual/figs/wavepacket.mpeg}{Slower}
\movieref[rate=2]{../doc/manual/figs/wavepacket.mpeg}{Faster}
\movieref[default]{../doc/manual/figs/wavepacket.mpeg}{Normal}
\movieref[pause]{../doc/manual/figs/wavepacket.mpeg}{Play/Pause}
\movieref[stop]{../doc/manual/figs/wavepacket.mpeg}{Stop}
% #else
\href{run:../doc/manual/figs/wavepacket.mpeg}{../doc/manual/figs/wavepacket.mpeg}
% #endif

% #else
\href{run:../doc/manual/figs/wavepacket.mpeg}{../doc/manual/figs/wavepacket.mpeg}

% alternative: \movie command that comes with beamer
% \movie[options]{../doc/manual/figs/wavepacket.mpeg}{../doc/manual/figs/wavepacket.mpeg}
% #endif
\end{center}
\caption{}
\end{figure}



 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files \code{../doc/manual/figs/wavepacket_*.png} in \href{{file:///home/hpl/vc/doconce/test/wavepacket_0001.html}}{\nolinkurl{file:///home/hpl/vc/doconce/test/wavepacket_0001.html}})


% Check out the correct with and height of YouTube movies from the
% embed command that the YouTube page can generate

MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

\subsection{Table Demo}

\label{subsec:table}

Let us take this table from the manual:
\index{some class X@some {\rm\texttt{class X}} which is convenient}

\begin{table}
\caption{
Table of velocity and acceleration.
\label{mytab}
}


\begin{quote}\begin{tabular}{lrr}
\hline
\multicolumn{1}{c}{time} & \multicolumn{1}{c}{velocity} & \multicolumn{1}{c}{acceleration} \\
\hline
0.0          & 1.4186       & -5.01        \\
2.0          & 1.376512     & 11.919       \\
4.0          & 1.1E+1       & 14.717624    \\
\hline
\end{tabular}\end{quote}

\noindent
\end{table}

The Doconce source code reads
\bcod
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
\ecod

Here is yet another table to test that we can handle more than
one table:


\begin{quote}\begin{tabular}{lll}
\hline
\multicolumn{1}{c}{time} & \multicolumn{1}{c}{velocity} & \multicolumn{1}{c}{acceleration} \\
\hline
0.0          & 1.4186       & -5.01        \\
1.0          & 1.376512     & 11.919       \\
3.0          & 1.1E+1       & 14.717624    \\
\hline
\end{tabular}\end{quote}

\noindent

\subsection{URLs}

\label{subsubsec:ex}

Here are some nice URLs, e.g., hpl's home page \href{{http://folk.uio.no/hpl}}{hpl},
or the URL if desired, \href{{http://folk.uio.no/hpl}}{\nolinkurl{http://folk.uio.no/hpl}}.
Here is a plain file link \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}},
or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{a link
with newline}. Can test spaces
with the link with word too: \href{{http://folk.uio.no/hpl}}{hpl} or
\href{{http://folk.uio.no/hpl}}{hpl}. The old syntax must also be
tested: \href{http://folk.uio.no/hpl}{hpl's homepage}. Now also \code{file:///}
works: \href{{file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html}}{link to a file}
is fine to have.

% Comments should be inserted outside paragraphs (because of reST):
% note that when there is no http: or file:, it can be a file link
% if the link name is URL, url, "URL", or "url".

\subsection{Some {\LaTeX} Constructs}

Let's check abbr.~of some common kind, e.g.~the well-known i.e.
7-9 as an example. Moreover, Dr.~Tang and Prof.~Monsen,
or maybe also prof.~Ting,
will go to the Dept.~of Science to test how Mr.~Hansen is doing together
with Ms.~Larsen. A sentence containing "refines lines" could easily
fool a regex substitution with only i.e.~since the dot matches anything.
Also, look at Fig.~4 to see how the data compares with Tab.~\ref{mytab}.

\subsection{{\LaTeX} Mathematics}

Here is an equation without label using backslash-bracket environment:
\[ a = b + c \]
or with number and label, as in (\ref{my:eq1}), using the equation environment:
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}
We can refer to this equation by (\ref{my:eq1}).

Here is a system without equation numbers, using the align-astrisk environment:
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}


And here is a system of equations with labels in an align environment:
\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}
We can refer to (\ref{eq1})-(\ref{eq2}).

Or with multline?
\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}
Maybe split is better:
\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
And we can refer to the last equation by (\ref{split:envir:eq}).

What about gather?
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}

And what about alignat?
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}
Let us refer to (\ref{eq1})-(\ref{eq2}) again, and to the
alignat variant (\ref{eq1a})-(\ref{eq2a}), and to (\ref{my:eq1}).

Here is eqnarray in action:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}

More mathematical typesetting is demonstrated in the exercises below.


\section{Exercises}

\subsection{Flip a Coin}

\label{demo:ex:1}

Make a program that simulates flipping a coin $N$ times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.
\paragraph{Hint 1.}
Use \code{r = random.random()} and define head as \code{r <= 0.5}.
\paragraph{Hint 2.}
Draw an integer among $\{1,2\}$ with
\code{r = random.randint(1,2)} and define head when \code{r} is 1.
Filename: \code{flip_coin.py}.

\subsection{Compute a Probability}

\label{demo:ex:2}

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard \code{random} module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$. Run the program with the four
values $N=10^i$ for $i=1,2,3,6$.

\subsection{Explore Distributions of Random Circles}

\label{proj:circle1}

The formula for a circle is given by
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ is a point on the circle.
The formula can be used to generate \code{n} points on a circle:
\bpycod
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
\epycod


The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the \code{circle} function
above. The following cases should be explored:

\begin{itemize}
 \item $R$ normally distributed and $(x_0,y_0)$ uniformly distributed

 \item $R$ uniformly distributed and $(x_0,y_0)$ normally distributed

 \item $R$ and $(x_0,y_0)$ normally distributed
\end{itemize}

\noindent
\paragraph{Hint.}
Use the \code{numpy.random} module to draw the
$x_0$, $y_0$, and $R$ quantities.
Filename: \code{circles.pdf}.

% Often in an exercise we have some comments about the solution
% which we normally want to migrate to the end.

\printindex

\end{document}

************** File: testdoc.tex *****************
%%
%% Automatically generated ptex2tex (extended LaTeX) file
%% from Doconce source
%% http://code.google.com/p/doconce/
%%

\documentclass{book}

\usepackage{relsize,epsfig,makeidx,amsmath,amsfonts}
\usepackage[latin1]{inputenc}



\usepackage[%
colorlinks=true,
linkcolor=blue,
citecolor=black,
filecolor=blue,
urlcolor=blue]{hyperref}
%\hyperbaseurl{}   % hyperlinks are relative to this root

\newcommand{\inlinecomment}[2]{  ({\bf #1}: \emph{#2})  }
%\newcommand{\inlinecomment}[2]{}  % turn off inline comments

\makeindex

\begin{document}






% ----------------- Title -------------------------

\begin{center}
{\LARGE\bf A Test Document}
\end{center}




% ----------------- Author(s) -------------------------

\begin{center}
{\bf Hans Petter Langtangen${}^{1, 2}$ (\texttt{hpl@simula.no})} \\ [0mm]
\end{center}


\begin{center}
{\bf Kaare Dump${}^{3}$} \\ [0mm]
\end{center}


\begin{center}
{\bf A. Dummy Author${}^{}$} \\ [0mm]
\end{center}


\begin{center}
{\bf I. S. Overworked${}^{4, 5, 6, 7}$} \\ [0mm]
\end{center}


\begin{center}
{\bf J. Doe${}^{}$ (\texttt{j\_doe@cyberspace.com})} \\ [0mm]
\end{center}

\begin{center}
% List of all institutions:
\centerline{{\small ${}^1$Center for Biomedical Computing, Simula Research Laboratory}}
\centerline{{\small ${}^2$Department of Informatics, University of Oslo}}
\centerline{{\small ${}^3$Segfault Inc, Cyberspace}}
\centerline{{\small ${}^4$Inst1}}
\centerline{{\small ${}^5$Inst2, Somewhere}}
\centerline{{\small ${}^6$Third Inst, Elsewhere}}
\centerline{{\small ${}^7$Fourth Inst}}
\end{center}
% ----------------- End of author(s) -------------------------

% latex demands DATE


% ----------------- Date -------------------------


\begin{center}
Jan 32, 2100
\end{center}


The format of this document is
plain, homemade {\LaTeX} (from Doconce).


\begin{abstract}
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.
\end{abstract}


\chapter{Chapter 1}


\section{Section 0}


\section{Section 1}

\label{sec1}

Just a little bit of text
and then a list:

\begin{itemize}
  \item item1

  \item item2

  \item item3 which continues
    on the next line to test that feature

  \item and a sublist
\begin{itemize}

    \item with indented subitem1

    \item and a subitem2

\end{itemize}

\noindent
  \item and perhaps an ordered sublist
\begin{enumerate}

   \item first item

   \item second item,
      continuing on a new line
\end{enumerate}

\noindent
\end{itemize}

\noindent

\subsection{Subsection 1}

More text, with a reference back to Section~\ref{sec1} and further
to Section~\ref{subsubsec:ex}. \index{somefunc@{\rm\texttt{somefunc}} function}

Let's do some copying from files too. First from subroutine up to the very end,

\
\begin{quote}
\begin{verbatim}
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\
\end{verbatim}
\end{quote}
and then just the subroutine,
\
\begin{quote}
\begin{verbatim}

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\
\end{verbatim}
\end{quote}
and finally the complete file:
\
\begin{quote}
\begin{verbatim}
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\
\end{verbatim}
\end{quote}

\subsection{Subsection 2}

\label{subsec:ex}
\index{figures}

Test of figures.


\begin{figure}
  \centerline{\includegraphics[width=0.9\linewidth]{../doc/manual/figs/streamtubes.eps}}
  \caption{
  Visualization of flow by streamtubes. \label{fig:impact}
  }
\end{figure}


\index{movies}
Test of movies.


\begin{figure}[ht]
\begin{center}

\href{run:../doc/manual/figs/mjolnir.mpeg}{../doc/manual/figs/mjolnir.mpeg}

% alternative: \movie command that comes with beamer
% \movie[options]{../doc/manual/figs/mjolnir.mpeg}{../doc/manual/figs/mjolnir.mpeg}
\end{center}
\caption{ Mjolnir tsunami (by Sylfest Glimsdal).}
\end{figure}


% Empty caption:


\begin{figure}[ht]
\begin{center}

\href{run:../doc/manual/figs/wavepacket.mpeg}{../doc/manual/figs/wavepacket.mpeg}

% alternative: \movie command that comes with beamer
% \movie[options]{../doc/manual/figs/wavepacket.mpeg}{../doc/manual/figs/wavepacket.mpeg}
\end{center}
\caption{}
\end{figure}



 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files {\fontsize{10pt}{10pt}\verb!../doc/manual/figs/wavepacket_*.png!} in \href{{file:///home/hpl/vc/doconce/test/wavepacket_0001.html}}{\nolinkurl{file:///home/hpl/vc/doconce/test/wavepacket_0001.html}})


% Check out the correct with and height of YouTube movies from the
% embed command that the YouTube page can generate

MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

\subsection{Table Demo}

\label{subsec:table}

Let us take this table from the manual:
\index{some class X@some {\rm\texttt{class X}} which is convenient}

\begin{table}
\caption{
Table of velocity and acceleration.
\label{mytab}
}


\begin{quote}\begin{tabular}{lrr}
\hline
\multicolumn{1}{c}{time} & \multicolumn{1}{c}{velocity} & \multicolumn{1}{c}{acceleration} \\
\hline
0.0          & 1.4186       & -5.01        \\
2.0          & 1.376512     & 11.919       \\
4.0          & 1.1E+1       & 14.717624    \\
\hline
\end{tabular}\end{quote}

\noindent
\end{table}

The Doconce source code reads
\
\begin{quote}
\begin{verbatim}
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
\
\end{verbatim}
\end{quote}

Here is yet another table to test that we can handle more than
one table:


\begin{quote}\begin{tabular}{lll}
\hline
\multicolumn{1}{c}{time} & \multicolumn{1}{c}{velocity} & \multicolumn{1}{c}{acceleration} \\
\hline
0.0          & 1.4186       & -5.01        \\
1.0          & 1.376512     & 11.919       \\
3.0          & 1.1E+1       & 14.717624    \\
\hline
\end{tabular}\end{quote}

\noindent

\subsection{URLs}

\label{subsubsec:ex}

Here are some nice URLs, e.g., hpl's home page \href{{http://folk.uio.no/hpl}}{hpl},
or the URL if desired, \href{{http://folk.uio.no/hpl}}{\nolinkurl{http://folk.uio.no/hpl}}.
Here is a plain file link \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}},
or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{a link
with newline}. Can test spaces
with the link with word too: \href{{http://folk.uio.no/hpl}}{hpl} or
\href{{http://folk.uio.no/hpl}}{hpl}. The old syntax must also be
tested: \href{http://folk.uio.no/hpl}{hpl's homepage}. Now also {\fontsize{10pt}{10pt}\verb!file:///!}
works: \href{{file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html}}{link to a file}
is fine to have.

% Comments should be inserted outside paragraphs (because of reST):
% note that when there is no http: or file:, it can be a file link
% if the link name is URL, url, "URL", or "url".

\subsection{Some {\LaTeX} Constructs}

Let's check abbr.~of some common kind, e.g.~the well-known i.e.
7-9 as an example. Moreover, Dr.~Tang and Prof.~Monsen,
or maybe also prof.~Ting,
will go to the Dept.~of Science to test how Mr.~Hansen is doing together
with Ms.~Larsen. A sentence containing "refines lines" could easily
fool a regex substitution with only i.e.~since the dot matches anything.
Also, look at Fig.~4 to see how the data compares with Tab.~\ref{mytab}.

\subsection{{\LaTeX} Mathematics}

Here is an equation without label using backslash-bracket environment:
\[ a = b + c \]
or with number and label, as in (\ref{my:eq1}), using the equation environment:
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}
We can refer to this equation by (\ref{my:eq1}).

Here is a system without equation numbers, using the align-astrisk environment:
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}


And here is a system of equations with labels in an align environment:
\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}
We can refer to (\ref{eq1})-(\ref{eq2}).

Or with multline?
\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}
Maybe split is better:
\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
And we can refer to the last equation by (\ref{split:envir:eq}).

What about gather?
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}

And what about alignat?
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}
Let us refer to (\ref{eq1})-(\ref{eq2}) again, and to the
alignat variant (\ref{eq1a})-(\ref{eq2a}), and to (\ref{my:eq1}).

Here is eqnarray in action:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}

More mathematical typesetting is demonstrated in the exercises below.


\section{Exercises}

\subsection{Flip a Coin}

\label{demo:ex:1}

Make a program that simulates flipping a coin $N$ times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.
\paragraph{Hint 1.}
Use {\fontsize{10pt}{10pt}\verb!r = random.random()!} and define head as {\fontsize{10pt}{10pt}\verb!r <= 0.5!}.
\paragraph{Hint 2.}
Draw an integer among $\{1,2\}$ with
{\fontsize{10pt}{10pt}\verb!r = random.randint(1,2)!} and define head when {\fontsize{10pt}{10pt}\verb!r!} is 1.
Filename: {\fontsize{10pt}{10pt}\verb!flip_coin.py!}.

\subsection{Compute a Probability}

\label{demo:ex:2}

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard {\fontsize{10pt}{10pt}\verb!random!} module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$. Run the program with the four
values $N=10^i$ for $i=1,2,3,6$.

\subsection{Explore Distributions of Random Circles}

\label{proj:circle1}

The formula for a circle is given by
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ is a point on the circle.
The formula can be used to generate {\fontsize{10pt}{10pt}\verb!n!} points on a circle:
\
\begin{quote}
\begin{verbatim}
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
\
\end{verbatim}
\end{quote}


The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the {\fontsize{10pt}{10pt}\verb!circle!} function
above. The following cases should be explored:

\begin{itemize}
 \item $R$ normally distributed and $(x_0,y_0)$ uniformly distributed

 \item $R$ uniformly distributed and $(x_0,y_0)$ normally distributed

 \item $R$ and $(x_0,y_0)$ normally distributed
\end{itemize}

\noindent
\paragraph{Hint.}
Use the {\fontsize{10pt}{10pt}\verb!numpy.random!} module to draw the
$x_0$, $y_0$, and $R$ quantities.
Filename: {\fontsize{10pt}{10pt}\verb!circles.pdf!}.

% Often in an exercise we have some comments about the solution
% which we normally want to migrate to the end.

\printindex

\end{document}

************** File: testdoc.rst *****************
.. Automatically generated reST file from Doconce source
   (http://code.google.com/p/doconce/)



A Test Document
===============

:Author: Hans Petter Langtangen (hpl at simula.no), Kaare Dump, A. Dummy Author, I. S. Overworked, J. Doe (j_doe at cyberspace.com)

.. latex demands DATE

:Date: Jan 32, 2100

The format of this document is
rst

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.


Chapter 1
%%%%%%%%%

Section 0
=========

.. _sec1:

Section 1
=========

Just a little bit of text
and then a list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2


  * and perhaps an ordered sublist

   1. first item

   2. second item,
      continuing on a new line


Subsection 1
------------

More text, with a reference back to the section `Section 1`_ and further
to the section `URLs`_. 
Let's do some copying from files too. First from subroutine up to the very end::


              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::


        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file::


        C     a comment
        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return


.. _subsec:ex:

Subsection 2
------------

Test of figures.


.. _fig:impact:

.. figure:: ../doc/manual/figs/streamtubes.png
   :width: 200

   *Visualization of flow by streamtubes*  (fig:impact)


Test of movies.

.. raw:: html
        
        <embed src="../doc/manual/figs/mjolnir.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
        <p>
        <em> Mjolnir tsunami (by Sylfest Glimsdal).</em>
        </p>



.. Empty caption:


.. raw:: html
        
        <embed src="../doc/manual/figs/wavepacket.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
        <p>
        <em></em>
        </p>



.. raw:: html
        
        <p><a href="wavepacket_0001.html">Movie of files <tt>../doc/manual/figs/wavepacket_*.png</tt></a>
        <em> Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie).</em></p>



.. Check out the correct with and height of YouTube movies from the

.. embed command that the YouTube page can generate


MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

.. _subsec:table:

Table Demo
----------

Let us take this table from the manual:


============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0                 1.4186         -5.01  
2.0               1.376512        11.919  
4.0                 1.1E+1     14.717624  
============  ============  ============  


The Doconce source code reads::


          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|


Here is yet another table to test that we can handle more than
one table:

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0           1.4186        -5.01         
1.0           1.376512      11.919        
3.0           1.1E+1        14.717624     
============  ============  ============  

.. _subsubsec:ex:

URLs
----

Here are some nice URLs, e.g., hpl's home page `hpl <http://folk.uio.no/hpl>`_,
or the URL if desired, `<http://folk.uio.no/hpl>`_.
Here is a plain file link `<testdoc.do.txt>`_, or `<testdoc.do.txt>`_,
or `<testdoc.do.txt>`_ or `<testdoc.do.txt>`_ or `a link
with newline <testdoc.do.txt>`_. Can test spaces
with the link with word too: `hpl <http://folk.uio.no/hpl>`_ or
`hpl <http://folk.uio.no/hpl>`_. The old syntax must also be
tested: `hpl's homepage <http://folk.uio.no/hpl>`_. Now also ``file:///``
works: `link to a file <file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html>`_
is fine to have.

.. Comments should be inserted outside paragraphs (because of reST):

.. note that when there is no http: or file:, it can be a file link

.. if the link name is URL, url, "URL", or "url".



LaTeX Mathematics
-----------------

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::

        \begin{equation}
        {\partial u\over\partial t} = \nabla^2 u label{my:eq1}
        \end{equation}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment::

        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}




More mathematical typesetting is demonstrated in the exercises below.

Exercises
=========

.. _demo:ex:1:

Flip a Coin
-----------

Make a program that simulates flipping a coin N times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

*Hint 1.* Use ``r = random.random()`` and define head as ``r <= 0.5``.

*Hint 2.* Draw an integer among \{1,2\} with
``r = random.randint(1,2)`` and define head when ``r`` is 1.
*Filename*: ``flip_coin.py``


.. _demo:ex:2:

Compute a Probability
---------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval [0,1)?
To answer this question empirically, let a program
draw N such random numbers using Python's standard ``random`` module,
count how many of them, M, that fall in the interval (0.5,0.6), and
compute the probability as M/N. Run the program with the four
values N=10^i for i=1,2,3,6.


.. _proj:circle1:

Explore Distributions of Random Circles
---------------------------------------

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,\\ 
        y &= y_0 + R\sin 2\pi t,
        \end{align}

where R is the radius of the circle, (x_0,y_0) is the
center point, and t is a parameter in the unit interval [0,1].
For any t, (x,y) is a point on the circle.
The formula can be used to generate ``n`` points on a circle::


        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y



The goal of this project is to draw N circles with random
center and radius. Plot each circle using the ``circle`` function
above. The following cases should be explored:

 * R normally distributed and (x_0,y_0) uniformly distributed

 * R uniformly distributed and (x_0,y_0) normally distributed

 * R and (x_0,y_0) normally distributed

*Hint.* Use the ``numpy.random`` module to draw the
x_0, y_0, and R quantities.
*Filename*: ``circles.pdf``

.. Often in an exercise we have some comments about the solution

.. which we normally want to migrate to the end.
************** File: testdoc.sphinx.rst *****************
.. Automatically generated reST file from Doconce source
   (http://code.google.com/p/doconce/)



A Test Document
===============

:Author: Hans Petter Langtangen (hpl at simula.no), Kaare Dump, A. Dummy Author, I. S. Overworked, J. Doe (j_doe at cyberspace.com)

.. latex demands DATE

:Date: Jan 32, 2100

The format of this document is
sphinx

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.


Chapter 1
%%%%%%%%%

Section 0
=========

.. _sec1:

Section 1
=========

Just a little bit of text
and then a list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2


  * and perhaps an ordered sublist

   1. first item

   2. second item,
      continuing on a new line


Subsection 1
------------

More text, with a reference back to the section :ref:`sec1` and further
to the section :ref:`subsubsec:ex`. 
.. index:: somefunc function


Let's do some copying from files too. First from subroutine up to the very end,


.. code-block:: fortran

              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine,

.. code-block:: fortran

              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file:

.. code-block:: fortran

        C     a comment
        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return


.. _subsec:ex:

Subsection 2
------------

.. index:: figures


Test of figures.


.. _fig:impact:

.. figure:: ../doc/manual/figs/streamtubes.png
   :width: 200

   *Visualization of flow by streamtubes*



.. index:: movies

Test of movies.

.. raw:: html
        
        <embed src="../doc/manual/figs/mjolnir.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
        <p>
        <em> Mjolnir tsunami (by Sylfest Glimsdal).</em>
        </p>



.. Empty caption:


.. raw:: html
        
        <embed src="../doc/manual/figs/wavepacket.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
        <p>
        <em></em>
        </p>



.. raw:: html
        
        <p><a href="wavepacket_0001.html">Movie of files <tt>../doc/manual/figs/wavepacket_*.png</tt></a>
        <em> Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie).</em></p>



.. Check out the correct with and height of YouTube movies from the

.. embed command that the YouTube page can generate


MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

.. _subsec:table:

Table Demo
----------

Let us take this table from the manual:

.. index:: some class X which is convenient



============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0                 1.4186         -5.01  
2.0               1.376512        11.919  
4.0                 1.1E+1     14.717624  
============  ============  ============  


The Doconce source code reads

.. code-block:: python

          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|


Here is yet another table to test that we can handle more than
one table:

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0           1.4186        -5.01         
1.0           1.376512      11.919        
3.0           1.1E+1        14.717624     
============  ============  ============  

.. _subsubsec:ex:

URLs
----

Here are some nice URLs, e.g., hpl's home page `hpl <http://folk.uio.no/hpl>`_,
or the URL if desired, `<http://folk.uio.no/hpl>`_.
Here is a plain file link `<testdoc.do.txt>`_, or `<testdoc.do.txt>`_,
or `<testdoc.do.txt>`_ or `<testdoc.do.txt>`_ or `a link
with newline <testdoc.do.txt>`_. Can test spaces
with the link with word too: `hpl <http://folk.uio.no/hpl>`_ or
`hpl <http://folk.uio.no/hpl>`_. The old syntax must also be
tested: `hpl's homepage <http://folk.uio.no/hpl>`_. Now also ``file:///``
works: `link to a file <file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html>`_
is fine to have.

.. Comments should be inserted outside paragraphs (because of reST):

.. note that when there is no http: or file:, it can be a file link

.. if the link name is URL, url, "URL", or "url".



LaTeX Mathematics
-----------------

Here is an equation without label using backslash-bracket environment:

.. math::
         a = b + c 

or with number and label, as in :eq:`my:eq1`, using the equation environment:

.. math::
   :label: my:eq1
        
        {\partial u\over\partial t} = \nabla^2 u 
        

We can refer to this equation by :eq:`my:eq1`.

Here is a system without equation numbers, using the align-astrisk environment:

.. math::
        
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        



And here is a system of equations with labels in an align environment:

.. math::
        
        a &= q + 4 + 5+ 6  \\ 
        b &= \nabla^2 u + \nabla^4 x 
        

We can refer to (:ref:`eq1`)-(:ref:`eq2`).

Or with multline?

.. math::
   :label: multiline:eq1
        
        a = b = q + \\ 
          f + \nabla\cdot\nabla u
        
        

Maybe split is better:

.. math::
   :label: split:envir:eq
        
        
        
        a = b = q &+ \\ 
          & f + \nabla\cdot\nabla u
        
        

And we can refer to the last equation by :eq:`split:envir:eq`.

What about gather?

.. math::
        
        a = b \\ 
        c = d + 7 + 9
        


And what about alignat?

.. math::
        \begin{alignat}{2}
        a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0  \\ 
        b &= \nabla^2 u + \nabla^4 x & x\in\Omega 
        \end{alignat}

Let us refer to (:ref:`eq1`)-(:ref:`eq2`) again, and to the
alignat variant (:ref:`eq1a`)-(:ref:`eq2a`), and to :eq:`my:eq1`.

Here is eqnarray in action:

.. math::
        
        {\partial u\over\partial t}  &=  \nabla^2 u + f, \\ 
        {\partial v\over\partial t}  &=  \nabla\cdot(q(u)\nabla v) + g 
        


More mathematical typesetting is demonstrated in the exercises below.

Exercises
=========

.. _demo:ex:1:

Flip a Coin
-----------

Make a program that simulates flipping a coin :math:`N` times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

*Hint 1.* Use ``r = random.random()`` and define head as ``r <= 0.5``.

*Hint 2.* Draw an integer among :math:`\{1,2\}` with
``r = random.randint(1,2)`` and define head when ``r`` is 1.
*Filename*: ``flip_coin.py``


.. _demo:ex:2:

Compute a Probability
---------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval :math:`[0,1)`?
To answer this question empirically, let a program
draw :math:`N` such random numbers using Python's standard ``random`` module,
count how many of them, :math:`M`, that fall in the interval :math:`(0.5,0.6)`, and
compute the probability as :math:`M/N`. Run the program with the four
values :math:`N=10^i` for :math:`i=1,2,3,6`.


.. _proj:circle1:

Explore Distributions of Random Circles
---------------------------------------

The formula for a circle is given by

.. math::
        
        x &= x_0 + R\cos 2\pi t,\\ 
        y &= y_0 + R\sin 2\pi t,
        

where :math:`R` is the radius of the circle, :math:`(x_0,y_0)` is the
center point, and :math:`t` is a parameter in the unit interval :math:`[0,1]`.
For any :math:`t`, :math:`(x,y)` is a point on the circle.
The formula can be used to generate ``n`` points on a circle:

.. code-block:: python

        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y



The goal of this project is to draw :math:`N` circles with random
center and radius. Plot each circle using the ``circle`` function
above. The following cases should be explored:

 * :math:`R` normally distributed and :math:`(x_0,y_0)` uniformly distributed

 * :math:`R` uniformly distributed and :math:`(x_0,y_0)` normally distributed

 * :math:`R` and :math:`(x_0,y_0)` normally distributed

*Hint.* Use the ``numpy.random`` module to draw the
:math:`x_0`, :math:`y_0`, and :math:`R` quantities.
*Filename*: ``circles.pdf``

.. Often in an exercise we have some comments about the solution

.. which we normally want to migrate to the end.
************** File: testdoc.gwiki *****************


#summary A Test Document
<wiki:toc max_depth="2" />
By *Hans Petter Langtangen* (hpl at simula.no), *Kaare Dump*, *A. Dummy Author*, *I. S. Overworked*, and *J. Doe* (j_doe at cyberspace.com)

<wiki:comment> latex demands DATE </wiki:comment>

==== Jan 32, 2100 ====

The format of this document is
gwiki

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.



= Chapter 1 =



== Section 0 ==



== Section 1 ==

Just a little bit of text
and then a list:


  * item1
  * item2
  * item3 which continues    on the next line to test that feature
  * and a sublist

    * with indented subitem1
    * and a subitem2


  * and perhaps an ordered sublist

   # first item
   # second item,      continuing on a new line

==== Subsection 1 ====

More text, with a reference back to the section [#Section_1] and further
to the section [#URLs]. 
Let's do some copying from files too. First from subroutine up to the very end,

{{{
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}
and then just the subroutine,
{{{

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
}}}
and finally the complete file:
{{{
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}

==== Subsection 2 ====

Test of figures.



---------------------------------------------------------------

Figure:  Visualization of flow by streamtubes. (fig:impact)

(the URL of the image file ../doc/manual/figs/streamtubes.png must be inserted here)

<wiki:comment>
Put the figure file ../doc/manual/figs/streamtubes.png on the web (e.g., as part of the
googlecode repository) and substitute the line above with the URL.
</wiki:comment>
---------------------------------------------------------------



Test of movies.

 Mjolnir tsunami (by Sylfest Glimsdal). (Movie ../doc/manual/figs/mjolnir.mpeg: play mjolnir.html)

<wiki:comment> Empty caption: </wiki:comment>

 (Movie ../doc/manual/figs/wavepacket.mpeg: play wavepacket.html)


 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files `../doc/manual/figs/wavepacket_*.png` in wavepacket_0001.html)


<wiki:comment> Check out the correct with and height of YouTube movies from the </wiki:comment>
<wiki:comment> embed command that the YouTube page can generate </wiki:comment>

MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

==== Table Demo ====

Let us take this table from the manual:



 ||      *time*       ||    *velocity*     ||  *acceleration*   ||
 ||  0.0              ||  1.4186           ||  -5.01            ||
 ||  2.0              ||  1.376512         ||  11.919           ||
 ||  4.0              ||  1.1E+1           ||  14.717624        ||



The Doconce source code reads
{{{
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
}}}

Here is yet another table to test that we can handle more than
one table:


 ||      *time*       ||    *velocity*     ||  *acceleration*   ||
 ||  0.0              ||  1.4186           ||  -5.01            ||
 ||  1.0              ||  1.376512         ||  11.919           ||
 ||  3.0              ||  1.1E+1           ||  14.717624        ||

==== URLs ====

Here are some nice URLs, e.g., hpl's home page [http://folk.uio.no/hpl hpl],
or the URL if desired, http://folk.uio.no/hpl.
Here is a plain file link testdoc.do.txt, or testdoc.do.txt,
or testdoc.do.txt or testdoc.do.txt or [testdoc.do.txt a link
with newline]. Can test spaces
with the link with word too: [http://folk.uio.no/hpl hpl] or
[http://folk.uio.no/hpl hpl]. The old syntax must also be
tested: [http://folk.uio.no/hpl hpl's homepage]. Now also `file:///`
works: [file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html link to a file]
is fine to have.

<wiki:comment> Comments should be inserted outside paragraphs (because of reST): </wiki:comment>
<wiki:comment> note that when there is no http: or file:, it can be a file link </wiki:comment>
<wiki:comment> if the link name is URL, url, "URL", or "url". </wiki:comment>

==== LaTeX Mathematics ====

Here is an equation without label using backslash-bracket environment:
{{{
\[ a = b + c \]
}}}
or with number and label, as in Equation (my:eq1), using the equation environment:
{{{
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
}}}
We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment:
{{{
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
}}}



More mathematical typesetting is demonstrated in the exercises below.



== Exercises ==

==== Flip a Coin ====

Make a program that simulates flipping a coin `N` times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

*Hint 1.* Use `r = random.random()` and define head as `r <= 0.5`.

*Hint 2.* Draw an integer among `\{1,2\}` with
`r = random.randint(1,2)` and define head when `r` is 1.
*Filename*: `flip_coin.py`

==== Compute a Probability ====

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval `[0,1)`?
To answer this question empirically, let a program
draw `N` such random numbers using Python's standard `random` module,
count how many of them, `M`, that fall in the interval `(0.5,0.6)`, and
compute the probability as `M/N`. Run the program with the four
values `N=10^i` for `i=1,2,3,6`.

==== Explore Distributions of Random Circles ====

The formula for a circle is given by
{{{
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
}}}
where `R` is the radius of the circle, `(x_0,y_0)` is the
center point, and `t` is a parameter in the unit interval `[0,1]`.
For any `t`, `(x,y)` is a point on the circle.
The formula can be used to generate `n` points on a circle:
{{{
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
}}}


The goal of this project is to draw `N` circles with random
center and radius. Plot each circle using the `circle` function
above. The following cases should be explored:


 * `R` normally distributed and `(x_0,y_0)` uniformly distributed
 * `R` uniformly distributed and `(x_0,y_0)` normally distributed
 * `R` and `(x_0,y_0)` normally distributed

*Hint.* Use the `numpy.random` module to draw the
`x_0`, `y_0`, and `R` quantities.
*Filename*: `circles.pdf`

<wiki:comment> Often in an exercise we have some comments about the solution </wiki:comment>
<wiki:comment> which we normally want to migrate to the end. </wiki:comment>

************** File: testdoc.mwiki *****************


#TITLE (actually governed by the filename): A Test Document

By '''Hans Petter Langtangen''' (hpl at simula.no), '''Kaare Dump''', '''A. Dummy Author''', '''I. S. Overworked''', and '''J. Doe''' (j_doe at cyberspace.com)

<!--> latex demands DATE -->

==== Jan 32, 2100 ====

The format of this document is
mwiki

''Abstract.'' This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.



== '''Chapter 1''' ==



== Section 0 ==



== Section 1 ==

Just a little bit of text
and then a list:


<ul>
  <li> item1  <li> item2  <li> item3 which continues    on the next line to test that feature  <li> and a sublist
<ul>
    <li><li> with indented subitem1    <li><li> and a subitem2</ul>

  <li> and perhaps an ordered sublist
<ol>
   <li><li> first item   <li><li> second item,      continuing on a new line</ol>

</ul>

==== Subsection 1 ====

More text, with a reference back to the section [#Section_1] and further
to the section [#URLs]. 
Let's do some copying from files too. First from subroutine up to the very end,

<syntaxhighlight lang="fortran">
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</code>
and then just the subroutine,
<syntaxhighlight lang="fortran">
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
</code>
and finally the complete file:
<syntaxhighlight lang="fortran">
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</code>

==== Subsection 2 ====

Test of figures.


[[File:../doc/manual/figs/streamtubes.png|frame|alt=../doc/manual/figs/streamtubes.png| Visualization of flow by streamtubes. (fig:impact)]]


Test of movies.

 Mjolnir tsunami (by Sylfest Glimsdal). (Movie ../doc/manual/figs/mjolnir.mpeg: play mjolnir.html)

<!--> Empty caption: -->

 (Movie ../doc/manual/figs/wavepacket.mpeg: play wavepacket.html)


 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files <code>../doc/manual/figs/wavepacket_*.png</code> in wavepacket_0001.html)


<!--> Check out the correct with and height of YouTube movies from the -->
<!--> embed command that the YouTube page can generate -->

MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

==== Table Demo ====

Let us take this table from the manual:


<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="left">   0.0             </td> <td align="right">   1.4186          </td> <td align="right">   -5.01           </td> </tr>
<tr><td align="left">   2.0             </td> <td align="right">   1.376512        </td> <td align="right">   11.919          </td> </tr>
<tr><td align="left">   4.0             </td> <td align="right">   1.1E+1          </td> <td align="right">   14.717624       </td> </tr>
</table>

The Doconce source code reads
<syntaxhighlight lang="python">
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
</code>

Here is yet another table to test that we can handle more than
one table:

<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="left">   0.0             </td> <td align="left">   1.4186          </td> <td align="left">   -5.01           </td> </tr>
<tr><td align="left">   1.0             </td> <td align="left">   1.376512        </td> <td align="left">   11.919          </td> </tr>
<tr><td align="left">   3.0             </td> <td align="left">   1.1E+1          </td> <td align="left">   14.717624       </td> </tr>
</table>

==== URLs ====

Here are some nice URLs, e.g., hpl's home page [http://folk.uio.no/hpl hpl],
or the URL if desired, http://folk.uio.no/hpl.
Here is a plain file link testdoc.do.txt, or testdoc.do.txt,
or testdoc.do.txt or testdoc.do.txt or [testdoc.do.txt a link
with newline]. Can test spaces
with the link with word too: [http://folk.uio.no/hpl hpl] or
[http://folk.uio.no/hpl hpl]. The old syntax must also be
tested: [http://folk.uio.no/hpl hpl's homepage]. Now also <code>file:///</code>
works: [file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html link to a file]
is fine to have.

<!--> Comments should be inserted outside paragraphs (because of reST): -->
<!--> note that when there is no http: or file:, it can be a file link -->
<!--> if the link name is URL, url, "URL", or "url". -->

==== LaTeX Mathematics ====

Here is an equation without label using backslash-bracket environment:
:<math>
\[ a = b + c \]
</math>
or with number and label, as in Equation (my:eq1), using the equation environment:
:<math>
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
</math>
We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment:
:<math>
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
</math>



More mathematical typesetting is demonstrated in the exercises below.



== Exercises ==

==== Flip a Coin ====

Make a program that simulates flipping a coin <math>N</math> times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

''Hint 1.'' Use <code>r = random.random()</code> and define head as <code>r <= 0.5</code>.

''Hint 2.'' Draw an integer among <math>\{1,2\}</math> with
<code>r = random.randint(1,2)</code> and define head when <code>r</code> is 1.
''Filename'': <code>flip_coin.py</code>

==== Compute a Probability ====

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval <math>[0,1)</math>?
To answer this question empirically, let a program
draw <math>N</math> such random numbers using Python's standard <code>random</code> module,
count how many of them, <math>M</math>, that fall in the interval <math>(0.5,0.6)</math>, and
compute the probability as <math>M/N</math>. Run the program with the four
values <math>N=10^i</math> for <math>i=1,2,3,6</math>.

==== Explore Distributions of Random Circles ====

The formula for a circle is given by
:<math>
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
</math>
where <math>R</math> is the radius of the circle, <math>(x_0,y_0)</math> is the
center point, and <math>t</math> is a parameter in the unit interval <math>[0,1]</math>.
For any <math>t</math>, <math>(x,y)</math> is a point on the circle.
The formula can be used to generate <code>n</code> points on a circle:
<syntaxhighlight lang="python">
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
</code>


The goal of this project is to draw <math>N</math> circles with random
center and radius. Plot each circle using the <code>circle</code> function
above. The following cases should be explored:


<ul>
 <li> <math>R</math> normally distributed and <math>(x_0,y_0)</math> uniformly distributed <li> <math>R</math> uniformly distributed and <math>(x_0,y_0)</math> normally distributed <li> <math>R</math> and <math>(x_0,y_0)</math> normally distributed</ul>

''Hint.'' Use the <code>numpy.random</code> module to draw the
<math>x_0</math>, <math>y_0</math>, and <math>R</math> quantities.
''Filename'': <code>circles.pdf</code>

<!--> Often in an exercise we have some comments about the solution -->
<!--> which we normally want to migrate to the end. -->

************** File: testdoc.cwiki *****************


#summary A Test Document
<wiki:toc max_depth="2" />
By **Hans Petter Langtangen** (hpl at simula.no), **Kaare Dump**, **A. Dummy Author**, **I. S. Overworked**, and **J. Doe** (j_doe at cyberspace.com)

<wiki:comment> latex demands DATE </wiki:comment>

=== Jan 32, 2100 ===

The format of this document is
cwiki

//Abstract.// This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.



= Chapter 1 =



= Section 0 =



= Section 1 =

Just a little bit of text
and then a list:


  * item1
  * item2
  * item3 which continues    on the next line to test that feature
  * and a sublist

    ** with indented subitem1
    //* and a subitem2


  // and perhaps an ordered sublist

   ## first item
   ## second item,      continuing on a new line


== Subsection 1 ==

More text, with a reference back to the section [#Section_1] and further
to the section [#URLs]. 
Let's do some copying from files too. First from subroutine up to the very end,

{{{
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}
and then just the subroutine,
{{{

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
}}}
and finally the complete file:
{{{
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}


== Subsection 2 ==

Test of figures.

{{../doc/manual/figs/streamtubes.png| Visualization of flow by streamtubes. (fig:impact)}}

Test of movies.

 Mjolnir tsunami (by Sylfest Glimsdal). (Movie ../doc/manual/figs/mjolnir.mpeg: play [[mjolnir.html]])

<wiki:comment> Empty caption: </wiki:comment>

 (Movie ../doc/manual/figs/wavepacket.mpeg: play [[wavepacket.html]])


 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files {{{../doc/manual/figs/wavepacket_*.png}}} in [[wavepacket_0001.html]])


<wiki:comment> Check out the correct with and height of YouTube movies from the </wiki:comment>
<wiki:comment> embed command that the YouTube page can generate </wiki:comment>

MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.


== Table Demo ==

Let us take this table from the manual:



 | =time             | =velocity         | =acceleration     |
 |  0.0              |  1.4186           |  -5.01            |
 |  2.0              |  1.376512         |  11.919           |
 |  4.0              |  1.1E+1           |  14.717624        |



The Doconce source code reads
{{{
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
}}}

Here is yet another table to test that we can handle more than
one table:


 | =time             | =velocity         | =acceleration     |
 |  0.0              |  1.4186           |  -5.01            |
 |  1.0              |  1.376512         |  11.919           |
 |  3.0              |  1.1E+1           |  14.717624        |


== URLs ==

Here are some nice URLs, e.g., hpl's home page [[http://folk.uio.no/hpl|hpl]],
or the URL if desired, [[http://folk.uio.no/hpl]].
Here is a plain file link [[testdoc.do.txt]], or [[testdoc.do.txt]],
or [[testdoc.do.txt]] or [[testdoc.do.txt]] or [[testdoc.do.txt|a link
with newline]]. Can test spaces
with the link with word too: [[http://folk.uio.no/hpl|hpl]] or
[[http://folk.uio.no/hpl|hpl]]. The old syntax must also be
tested: [[http://folk.uio.no/hpl|hpl's homepage]]. Now also {{{file:///}}}
works: [[file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html|link to a file]]
is fine to have.

<wiki:comment> Comments should be inserted outside paragraphs (because of reST): </wiki:comment>
<wiki:comment> note that when there is no http: or file:, it can be a file link </wiki:comment>
<wiki:comment> if the link name is URL, url, "URL", or "url". </wiki:comment>


== LaTeX Mathematics ==

Here is an equation without label using backslash-bracket environment:
{{{
\[ a = b + c \]
}}}
or with number and label, as in Equation (my:eq1), using the equation environment:
{{{
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
}}}
We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment:
{{{
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
}}}



More mathematical typesetting is demonstrated in the exercises below.



= Exercises =


== Flip a Coin ==

Make a program that simulates flipping a coin {{{N}}} times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

//Hint 1.// Use {{{r = random.random()}}} and define head as {{{r <= 0.5}}}.

//Hint 2.// Draw an integer among {{{\{1,2\}}}} with
{{{r = random.randint(1,2)}}} and define head when {{{r}}} is 1.
//Filename//: {{{flip_coin.py}}}


== Compute a Probability ==

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval {{{[0,1)}}}?
To answer this question empirically, let a program
draw {{{N}}} such random numbers using Python's standard {{{random}}} module,
count how many of them, {{{M}}}, that fall in the interval {{{(0.5,0.6)}}}, and
compute the probability as {{{M/N}}}. Run the program with the four
values {{{N=10^i}}} for {{{i=1,2,3,6}}}.


== Explore Distributions of Random Circles ==

The formula for a circle is given by
{{{
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
}}}
where {{{R}}} is the radius of the circle, {{{(x_0,y_0)}}} is the
center point, and {{{t}}} is a parameter in the unit interval {{{[0,1]}}}.
For any {{{t}}}, {{{(x,y)}}} is a point on the circle.
The formula can be used to generate {{{n}}} points on a circle:
{{{
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
}}}


The goal of this project is to draw {{{N}}} circles with random
center and radius. Plot each circle using the {{{circle}}} function
above. The following cases should be explored:


 * {{{R}}} normally distributed and {{{(x_0,y_0)}}} uniformly distributed
 * {{{R}}} uniformly distributed and {{{(x_0,y_0)}}} normally distributed
 * {{{R}}} and {{{(x_0,y_0)}}} normally distributed

//Hint.// Use the {{{numpy.random}}} module to draw the
{{{x_0}}}, {{{y_0}}}, and {{{R}}} quantities.
//Filename//: {{{circles.pdf}}}

<wiki:comment> Often in an exercise we have some comments about the solution </wiki:comment>
<wiki:comment> which we normally want to migrate to the end. </wiki:comment>

************** File: testdoc.st *****************


TITLE: A Test Document
BY: Hans Petter Langtangen (Center for Biomedical Computing, Simula Research Laboratory, and Department of Informatics, University of Oslo); Kaare Dump (Segfault Inc, Cyberspace); A. Dummy Author; I. S. Overworked (Inst1, and Inst2, Somewhere, and Third Inst, Elsewhere, and Fourth Inst); J. DoeDATE: today

The format of this document is
st
*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

Chapter 1

Section 0

Section 1

Just a little bit of text
and then a list:

  - item1
  - item2
  - item3 which continues
    on the next line to test that feature
  - and a sublist
    - with indented subitem1
    - and a subitem2

  - and perhaps an ordered sublist
   1. first item
   2. second item,
      continuing on a new line

Subsection 1

More text, with a reference back to the section "Section 1" and further
to the section "URLs". 
Let's do some copying from files too. First from subroutine up to the very end::


              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::


        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file::


        C     a comment
        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return


Subsection 2

Test of figures.

FIGURE:[../doc/manual/figs/streamtubes, width=200] Visualization of flow by streamtubes. {fig:impact}

Test of movies.

 Mjolnir tsunami (by Sylfest Glimsdal). (Movie ../doc/manual/figs/mjolnir.mpeg: play "mjolnir.html":mjolnir.html)


 (Movie ../doc/manual/figs/wavepacket.mpeg: play "wavepacket.html":wavepacket.html)


 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files '../doc/manual/figs/wavepacket_*.png' in "wavepacket_0001.html":wavepacket_0001.html)



MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

Table Demo

Let us take this table from the manual:


============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0                 1.4186         -5.01  
2.0               1.376512        11.919  
4.0                 1.1E+1     14.717624  
============  ============  ============  


The Doconce source code reads::


          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|


Here is yet another table to test that we can handle more than
one table:

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0           1.4186        -5.01         
1.0           1.376512      11.919        
3.0           1.1E+1        14.717624     
============  ============  ============  

URLs

Here are some nice URLs, e.g., hpl's home page "http://folk.uio.no/hpl":hpl,
or the URL if desired, "http://folk.uio.no/hpl":http://folk.uio.no/hpl.
Here is a plain file link "testdoc.do.txt":testdoc.do.txt, or "testdoc.do.txt":testdoc.do.txt,
or "testdoc.do.txt":testdoc.do.txt or "testdoc.do.txt":testdoc.do.txt or "testdoc.do.txt":a link
with newline. Can test spaces
with the link with word too: "http://folk.uio.no/hpl":hpl or
"http://folk.uio.no/hpl":hpl. The old syntax must also be
tested: "http://folk.uio.no/hpl":hpl's homepage. Now also 'file:///'
works: "file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html":link to a file
is fine to have.

LaTeX Mathematics

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::

        \begin{equation}
        {\partial u\over\partial t} = \nabla^2 u label{my:eq1}
        \end{equation}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment::

        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}




More mathematical typesetting is demonstrated in the exercises below.

Exercises

Flip a Coin

Make a program that simulates flipping a coin N times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

*Hint 1.* Use 'r = random.random()' and define head as 'r <= 0.5'.

*Hint 2.* Draw an integer among \{1,2\} with
'r = random.randint(1,2)' and define head when 'r' is 1.
*Filename*: 'flip_coin.py'

Compute a Probability

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval [0,1)?
To answer this question empirically, let a program
draw N such random numbers using Python's standard 'random' module,
count how many of them, M, that fall in the interval (0.5,0.6), and
compute the probability as M/N. Run the program with the four
values N=10^i for i=1,2,3,6.

Explore Distributions of Random Circles

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,\\ 
        y &= y_0 + R\sin 2\pi t,
        \end{align}

where R is the radius of the circle, (x_0,y_0) is the
center point, and t is a parameter in the unit interval [0,1].
For any t, (x,y) is a point on the circle.
The formula can be used to generate 'n' points on a circle::


        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y



The goal of this project is to draw N circles with random
center and radius. Plot each circle using the 'circle' function
above. The following cases should be explored:

 - R normally distributed and (x_0,y_0) uniformly distributed
 - R uniformly distributed and (x_0,y_0) normally distributed
 - R and (x_0,y_0) normally distributed

*Hint.* Use the 'numpy.random' module to draw the
x_0, y_0, and R quantities.
*Filename*: 'circles.pdf'
************** File: testdoc.epytext *****************


TITLE: A Test Document
BY: Hans Petter Langtangen (Center for Biomedical Computing, Simula Research Laboratory, and Department of Informatics, University of Oslo); Kaare Dump (Segfault Inc, Cyberspace); A. Dummy Author; I. S. Overworked (Inst1, and Inst2, Somewhere, and Third Inst, Elsewhere, and Fourth Inst); J. DoeDATE: today

The format of this document is
epytext

I{Abstract.} This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.


Chapter 1
%%%%%%%%%

Section 0
=========

Section 1
=========

Just a little bit of text
and then a list:

  - item1
  - item2
  - item3 which continues
    on the next line to test that feature
  - and a sublist
    - with indented subitem1
    - and a subitem2

  - and perhaps an ordered sublist
   1. first item
   2. second item,
      continuing on a new line


Subsection 1
------------

More text, with a reference back to the section "Section 1" and further
to the section "URLs". 
Let's do some copying from files too. First from subroutine up to the very end::


              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::


        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file::


        C     a comment
        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return


Subsection 2
------------


Test of figures.

FIGURE:[../doc/manual/figs/streamtubes, width=200] Visualization of flow by streamtubes. {fig:impact}

Test of movies.

 Mjolnir tsunami (by Sylfest Glimsdal). (Movie ../doc/manual/figs/mjolnir.mpeg: play U{mjolnir.html<mjolnir.html>})


 (Movie ../doc/manual/figs/wavepacket.mpeg: play U{wavepacket.html<wavepacket.html>})


 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files C{../doc/manual/figs/wavepacket_*.png} in U{wavepacket_0001.html<wavepacket_0001.html>})



MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

Table Demo
----------

Let us take this table from the manual:


============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0                 1.4186         -5.01  
2.0               1.376512        11.919  
4.0                 1.1E+1     14.717624  
============  ============  ============  


The Doconce source code reads::


          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|


Here is yet another table to test that we can handle more than
one table:

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0           1.4186        -5.01         
1.0           1.376512      11.919        
3.0           1.1E+1        14.717624     
============  ============  ============  

URLs
----

Here are some nice URLs, e.g., hpl's home page U{hpl<http://folk.uio.no/hpl>},
or the URL if desired, U{http://folk.uio.no/hpl<http://folk.uio.no/hpl>}.
Here is a plain file link U{testdoc.do.txt<testdoc.do.txt>}, or U{testdoc.do.txt<testdoc.do.txt>},
or U{testdoc.do.txt<testdoc.do.txt>} or U{testdoc.do.txt<testdoc.do.txt>} or U{a link
with newline<testdoc.do.txt>}. Can test spaces
with the link with word too: U{hpl<http://folk.uio.no/hpl>} or
U{hpl<http://folk.uio.no/hpl>}. The old syntax must also be
tested: U{hpl's homepage<http://folk.uio.no/hpl>}. Now also C{file:///}
works: U{link to a file<file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html>}
is fine to have.



LaTeX Mathematics
-----------------

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::


            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.


We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment::


            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.





More mathematical typesetting is demonstrated in the exercises below.

Exercises
=========

Flip a Coin
-----------

Make a program that simulates flipping a coin M{N} times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

I{Hint 1.} Use C{r = random.random()} and define head as C{r <= 0.5}.

I{Hint 2.} Draw an integer among M{\{1,2\}} with
C{r = random.randint(1,2)} and define head when C{r} is 1.
I{Filename}: C{flip_coin.py}


Compute a Probability
---------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval M{[0,1)}?
To answer this question empirically, let a program
draw M{N} such random numbers using Python's standard C{random} module,
count how many of them, M{M}, that fall in the interval M{(0.5,0.6)}, and
compute the probability as M{M/N}. Run the program with the four
values M{N=10^i} for M{i=1,2,3,6}.


Explore Distributions of Random Circles
---------------------------------------

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,\\ 
        y &= y_0 + R\sin 2\pi t,
        \end{align}

where M{R} is the radius of the circle, M{(x_0,y_0)} is the
center point, and M{t} is a parameter in the unit interval M{[0,1]}.
For any M{t}, M{(x,y)} is a point on the circle.
The formula can be used to generate C{n} points on a circle::


        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y



The goal of this project is to draw M{N} circles with random
center and radius. Plot each circle using the C{circle} function
above. The following cases should be explored:

 - M{R} normally distributed and M{(x_0,y_0)} uniformly distributed
 - M{R} uniformly distributed and M{(x_0,y_0)} normally distributed
 - M{R} and M{(x_0,y_0)} normally distributed

I{Hint.} Use the C{numpy.random} module to draw the
M{x_0}, M{y_0}, and M{R} quantities.
I{Filename}: C{circles.pdf}
************** File: testdoc.txt *****************


A Test Document
===============

Hans Petter Langtangen [1, 2] (hpl@simula.no)
Kaare Dump [3] 
A. Dummy Author  
I. S. Overworked [4, 5, 6, 7] 
J. Doe  (j_doe@cyberspace.com)

[1] Center for Biomedical Computing, Simula Research Laboratory
[2] Department of Informatics, University of Oslo
[3] Segfault Inc, Cyberspace
[4] Inst1
[5] Inst2, Somewhere
[6] Third Inst, Elsewhere
[7] Fourth Inst


Date: Jan 32, 2100

The format of this document is
plain

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

Chapter 1
%%%%%%%%%

Section 0
=========

Section 1
=========

Just a little bit of text
and then a list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2


  * and perhaps an ordered sublist

   1. first item

   2. second item,
      continuing on a new line


Subsection 1
------------

More text, with a reference back to the section "Section 1" and further
to the section "URLs". 
Let's do some copying from files too. First from subroutine up to the very end::


              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::


        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file::


        C     a comment
        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return


Subsection 2
------------


Test of figures.

FIGURE:[../doc/manual/figs/streamtubes, width=200] Visualization of flow by streamtubes. {fig:impact}

Test of movies.

 Mjolnir tsunami (by Sylfest Glimsdal). (Movie ../doc/manual/figs/mjolnir.mpeg: play mjolnir.html)


 (Movie ../doc/manual/figs/wavepacket.mpeg: play wavepacket.html)


 Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files ../doc/manual/figs/wavepacket_*.png in wavepacket_0001.html)



MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

Table Demo
----------

Let us take this table from the manual:


============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0                 1.4186         -5.01  
2.0               1.376512        11.919  
4.0                 1.1E+1     14.717624  
============  ============  ============  


The Doconce source code reads::


          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|


Here is yet another table to test that we can handle more than
one table:

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
0.0           1.4186        -5.01         
1.0           1.376512      11.919        
3.0           1.1E+1        14.717624     
============  ============  ============  

URLs
----

Here are some nice URLs, e.g., hpl's home page hpl (http://folk.uio.no/hpl),
or the URL if desired, http://folk.uio.no/hpl.
Here is a plain file link testdoc.do.txt, or testdoc.do.txt,
or testdoc.do.txt or testdoc.do.txt or a link
with newline (testdoc.do.txt). Can test spaces
with the link with word too: hpl (http://folk.uio.no/hpl) or
hpl (http://folk.uio.no/hpl). The old syntax must also be
tested: hpl's homepage (http://folk.uio.no/hpl). Now also file:///
works: link to a file (file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html)
is fine to have.



LaTeX Mathematics
-----------------

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::

        \begin{equation}
        {\partial u\over\partial t} = \nabla^2 u label{my:eq1}
        \end{equation}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment::

        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}




More mathematical typesetting is demonstrated in the exercises below.

Exercises
=========

Flip a Coin
-----------

Make a program that simulates flipping a coin N times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

*Hint 1.* Use r = random.random() and define head as r <= 0.5.

*Hint 2.* Draw an integer among \{1,2\} with
r = random.randint(1,2) and define head when r is 1.
*Filename*: flip_coin.py


Compute a Probability
---------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval [0,1)?
To answer this question empirically, let a program
draw N such random numbers using Python's standard random module,
count how many of them, M, that fall in the interval (0.5,0.6), and
compute the probability as M/N. Run the program with the four
values N=10^i for i=1,2,3,6.


Explore Distributions of Random Circles
---------------------------------------

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,\\ 
        y &= y_0 + R\sin 2\pi t,
        \end{align}

where R is the radius of the circle, (x_0,y_0) is the
center point, and t is a parameter in the unit interval [0,1].
For any t, (x,y) is a point on the circle.
The formula can be used to generate n points on a circle::


        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y



The goal of this project is to draw N circles with random
center and radius. Plot each circle using the circle function
above. The following cases should be explored:

 * R normally distributed and (x_0,y_0) uniformly distributed

 * R uniformly distributed and (x_0,y_0) normally distributed

 * R and (x_0,y_0) normally distributed

*Hint.* Use the numpy.random module to draw the
x_0, y_0, and R quantities.
*Filename*: circles.pdf
************** File: testdoc.mkd *****************


% A Test Document
% Hans Petter Langtangen at Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo;  Kaare Dump at Segfault Inc, Cyberspace;  A. Dummy Author;  I. S. Overworked at Inst1 and Inst2, Somewhere and Third Inst, Elsewhere and Fourth Inst;  J. Doe
% Jan 32, 2100

The format of this document is
pandoc
*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.



Chapter 1
%%%%%%%%%

Section 0
=========

Section 1
=========

Just a little bit of text
and then a list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2


  * and perhaps an ordered sublist

   1. first item

   2. second item,
      continuing on a new line


Subsection 1
------------

More text, with a reference back to the section [Section 1](#n-1) and further
to the section [URLs](#s). 
Let's do some copying from files too. First from subroutine up to the very end,


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Fortran}
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and then just the subroutine,

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Fortran}
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and finally the complete file:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Fortran}
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Subsection 2
------------


Test of figures.

FIGURE:[../doc/manual/figs/streamtubes, width=200] Visualization of flow by streamtubes. {fig:impact}

Test of movies.


<embed src="../doc/manual/figs/mjolnir.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
<p>
<em> Mjolnir tsunami (by Sylfest Glimsdal).</em>
</p>




<embed src="../doc/manual/figs/wavepacket.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
<p>
<em></em>
</p>



<p><a href="wavepacket_0001.html">Movie of files <tt>../doc/manual/figs/wavepacket_*.png</tt></a>
<em> Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie).</em></p>


MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.

Table Demo
----------

Let us take this table from the manual:



    time        velocity    acceleration  
------------  ------------  ------------  
0.0                 1.4186         -5.01  
2.0               1.376512        11.919  
4.0                 1.1E+1     14.717624  



The Doconce source code reads

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Python}
  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Here is yet another table to test that we can handle more than
one table:


    time        velocity    acceleration  
------------  ------------  ------------  
0.0           1.4186        -5.01         
1.0           1.376512      11.919        
3.0           1.1E+1        14.717624     


URLs
----

Here are some nice URLs, e.g., hpl's home page [hpl](http://folk.uio.no/hpl),
or the URL if desired, <http://folk.uio.no/hpl>.
Here is a plain file link <testdoc.do.txt>, or <testdoc.do.txt>,
or <testdoc.do.txt> or <testdoc.do.txt> or [a link
with newline](testdoc.do.txt). Can test spaces
with the link with word too: [hpl](http://folk.uio.no/hpl) or
[hpl](http://folk.uio.no/hpl). The old syntax must also be
tested: hpl's homepage (http://folk.uio.no/hpl). Now also `file:///`
works: [link to a file](file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html)
is fine to have.



LaTeX Mathematics
-----------------

Here is an equation without label using backslash-bracket environment:
$$ a = b + c $$
or with number and label, as in Equation (my:eq1), using the equation environment:
$$
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}
$$
We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-astrisk environment:
$$
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
$$


And here is a system of equations with labels in an align environment:
$$
\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}
$$
We can refer to Equations (eq1)-(eq2).

Or with multline?
$$
\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}
$$
Maybe split is better:
$$
\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
$$
And we can refer to the last equation by Equation (split:envir:eq).

What about gather?
$$
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}
$$

And what about alignat?
$$
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}
$$
Let us refer to Equations (eq1)-(eq2) again, and to the
alignat variant Equations (eq1a)-(eq2a), and to Equation (my:eq1).

Here is eqnarray in action:
$$
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}
$$

More mathematical typesetting is demonstrated in the exercises below.

Exercises
=========

Flip a Coin
-----------

Make a program that simulates flipping a coin $N$ times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

*Hint 1.* Use `r = random.random()` and define head as `r <= 0.5`.

*Hint 2.* Draw an integer among $\{1,2\}$ with
`r = random.randint(1,2)` and define head when `r` is 1.
*Filename*: `flip_coin.py`


Compute a Probability
---------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard `random` module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$. Run the program with the four
values $N=10^i$ for $i=1,2,3,6$.


Explore Distributions of Random Circles
---------------------------------------

The formula for a circle is given by
$$
\begin{align}
x &= x_0 + R\cos 2\pi t,\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
$$
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ is a point on the circle.
The formula can be used to generate `n` points on a circle:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Python}
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the `circle` function
above. The following cases should be explored:

 * $R$ normally distributed and $(x_0,y_0)$ uniformly distributed

 * $R$ uniformly distributed and $(x_0,y_0)$ normally distributed

 * $R$ and $(x_0,y_0)$ normally distributed

*Hint.* Use the `numpy.random` module to draw the
$x_0$, $y_0$, and $R$ quantities.
*Filename*: `circles.pdf`

************** File: testdoc.tmp *****************

======= Section 0 =======

======= Section 1 =======
label{sec1}

Just a little bit of text
and then a list:

  * item1
  * item2
  * item3 which continues
    on the next line to test that feature
  * and a sublist
    * with indented subitem1
    * and a subitem2
  * and perhaps an ordered sublist
    o first item
    o second item,
      continuing on a new line

===== Subsection 1 =====

More text, with a reference back to Section ref{sec1} and further
to Section ref{subsubsec:ex}. idx{`somefunc` function}

Let's do some copying from files too. First from subroutine up to the very end,

@@@CODE ../doc/manual/__testcode.f fromto: subroutine@
===== Exercise: Compute a Probability =====

label{demo:ex:2}  solution =/my/home/hpl/sol/file1.txt

What is the probability of getting a number between 0.5 and 0.6 when
 * $R$ uniformly distributed and $(x_0,y_0)$ normally distributed
 * $R$ and $(x_0,y_0)$ normally distributed

__Hint.__ Use the `numpy.random` module to draw the
$x_0$, $y_0$, and $R$ quantities.

************** File: tmp_encodings.txt *****************
iso-8859-1
iso-8859-1
iso-8859-1
iso-8859-1
iso-8859-1

************** File: testdoc_pnd_l2h.html *****************
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="Content-Style-Type" content="text/css" />
  <meta name="generator" content="pandoc" />
  <title></title>
  <script src="https://d3eoax9i5htok0.cloudfront.net/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML" type="text/javascript"></script>
</head>
<body>
<p><strong>A Test Document</strong></p>
<p><strong>Hans Petter Langtangen\({}^{1, 2}\) (<code>hpl@simula.no</code>)</strong></p>
<p><br />[0mm]</p>
<p><strong>Kaare Dump\({}^{3}\)</strong></p>
<p><br />[0mm]</p>
<p><strong>A. Dummy Author\({}^{}\)</strong></p>
<p><br />[0mm]</p>
<p><strong>I. S. Overworked\({}^{4, 5, 6, 7}\)</strong></p>
<p><br />[0mm]</p>
<p><strong>J. Doe\({}^{}\) (<code>j_doe@cyberspace.com</code>)</strong></p>
<p><br />[0mm]</p>
<p>\({}^1\)Center for Biomedical Computing, Simula Research Laboratory \({}^2\)Department of Informatics, University of Oslo \({}^3\)Segfault Inc, Cyberspace \({}^4\)Inst1 \({}^5\)Inst2, Somewhere \({}^6\)Third Inst, Elsewhere \({}^7\)Fourth Inst</p>
<p>Jan 32, 2100</p>
<p>The format of this document is plain, homemade LaTeX (from Doconce).</p>
<p>This is a document with many test constructions for doconce syntax. It was used heavily for the development and kept for testing numerous constructions, also special and less common cases.</p>
<p>And exactly for test purposes we have an extra line here, which is part of the abstract.</p>
<h1 id="chapter-1">Chapter 1</h1>
<h2 id="section-0">Section 0</h2>
<h2 id="section-1">Section 1</h2>
<p>[sec1]</p>
<p>Just a little bit of text and then a list:</p>
<ul>
<li><p>item1</p></li>
<li><p>item2</p></li>
<li><p>item3 which continues on the next line to test that feature</p></li>
<li><p>and a sublist</p>
<ul>
<li><p>with indented subitem1</p></li>
<li><p>and a subitem2</p></li>
</ul></li>
<li><p>and perhaps an ordered sublist</p>
<ol style="list-style-type: decimal">
<li><p>first item</p></li>
<li><p>second item, continuing on a new line</p></li>
</ol></li>
</ul>
<h3 id="subsection-1">Subsection 1</h3>
<p>More text, with a reference back to Section [sec1] and further to Section [subsubsec:ex].</p>
<p>Let’s do some copying from files too. First from subroutine up to the very end,</p>
<blockquote>
<pre><code>      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\</code></pre>
</blockquote>
<p>and then just the subroutine,</p>
<blockquote>
<pre><code>
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\</code></pre>
</blockquote>
<p>and finally the complete file:</p>
<blockquote>
<pre><code>C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\</code></pre>
</blockquote>
<h3 id="subsection-2">Subsection 2</h3>
<p>[subsec:ex]</p>
<p>Test of figures.</p>
<p><embed src="../doc/manual/figs/streamtubes.eps"> Visualization of flow by streamtubes. [fig:impact]</p>
<p>Test of movies.</p>
<p>[ht]</p>
<p><a href="run:../doc/manual/figs/mjolnir.mpeg">../doc/manual/figs/mjolnir.mpeg</a></p>
<p>Mjolnir tsunami (by Sylfest Glimsdal).</p>
<p>[ht]</p>
<p><a href="run:../doc/manual/figs/wavepacket.mpeg">../doc/manual/figs/wavepacket.mpeg</a></p>
<p>Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie). (Movie of files 10pt10pt<code>../doc/manual/figs/wavepacket_*.png</code> in <a href="{file:///home/hpl/vc/doconce/test/wavepacket_0001.html}">file:///home/hpl/vc/doconce/test/wavepacket<sub>0</sub>001.html</a>)</p>
<p>MOVIE: http://www.youtube.com/watch?v=<sub>O</sub>7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.</p>
<h3 id="table-demo">Table Demo</h3>
<p>[subsec:table]</p>
<p>Let us take this table from the manual:</p>
<p>Table of velocity and acceleration. [mytab]</p>
<blockquote>
<table>
<thead>
<tr class="header">
<th align="left">1ctime</th>
<th align="right">1cvelocity</th>
<th align="right">1cacceleration</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td align="left">0.0</td>
<td align="right">1.4186</td>
<td align="right">-5.01</td>
</tr>
<tr class="even">
<td align="left">2.0</td>
<td align="right">1.376512</td>
<td align="right">11.919</td>
</tr>
<tr class="odd">
<td align="left">4.0</td>
<td align="right">1.1E+1</td>
<td align="right">14.717624</td>
</tr>
</tbody>
</table>
<p>The Doconce source code reads</p>
</blockquote>
<blockquote>
<pre><code>  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
\</code></pre>
</blockquote>
<p>Here is yet another table to test that we can handle more than one table:</p>
<blockquote>
<table>
<thead>
<tr class="header">
<th align="left">1ctime</th>
<th align="left">1cvelocity</th>
<th align="left">1cacceleration</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td align="left">0.0</td>
<td align="left">1.4186</td>
<td align="left">-5.01</td>
</tr>
<tr class="even">
<td align="left">1.0</td>
<td align="left">1.376512</td>
<td align="left">11.919</td>
</tr>
<tr class="odd">
<td align="left">3.0</td>
<td align="left">1.1E+1</td>
<td align="left">14.717624</td>
</tr>
</tbody>
</table>
<h3>URLs</h3>
</blockquote>
<p>[subsubsec:ex]</p>
<p>Here are some nice URLs, e.g., hpl’s home page <a href="{http://folk.uio.no/hpl}">hpl</a>, or the URL if desired, <a href="{http://folk.uio.no/hpl}">http://folk.uio.no/hpl</a>. Here is a plain file link <a href="{testdoc.do.txt}">testdoc.do.txt</a>, or <a href="{testdoc.do.txt}">testdoc.do.txt</a>, or <a href="{testdoc.do.txt}">testdoc.do.txt</a> or <a href="{testdoc.do.txt}">testdoc.do.txt</a> or <a href="{testdoc.do.txt}">a link with newline</a>. Can test spaces with the link with word too: <a href="{http://folk.uio.no/hpl}">hpl</a> or <a href="{http://folk.uio.no/hpl}">hpl</a>. The old syntax must also be tested: <a href="http://folk.uio.no/hpl">hpl’s homepage</a>. Now also 10pt10pt<code>file:///</code> works: <a href="{file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html}">link to a file</a> is fine to have.</p>
<h3 id="some-latex-constructs">Some LaTeX Constructs</h3>
<p>Let’s check abbr. of some common kind, e.g. the well-known i.e. 7-9 as an example. Moreover, Dr. Tang and Prof. Monsen, or maybe also prof. Ting, will go to the Dept. of Science to test how Mr. Hansen is doing together with Ms. Larsen. A sentence containing &quot;refines lines&quot; could easily fool a regex substitution with only i.e. since the dot matches anything. Also, look at Fig. 4 to see how the data compares with Tab. [mytab].</p>
<h3 id="latex-mathematics">LaTeX Mathematics</h3>
<p>Here is an equation without label using backslash-bracket environment: \[a = b + c\] or with number and label, as in ([my:eq1]), using the equation environment:</p>
<p>\[{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}\]</p>
<p>We can refer to this equation by ([my:eq1]).</p>
<p>Here is a system without equation numbers, using the align-astrisk environment:</p>
<p>\[\begin{aligned*}
\pmb{a} &amp;= \pmb{q}\times\pmb{n} \\ 
b &amp;= \nabla^2 u + \nabla^4 v\end{aligned*}\]</p>
<p>And here is a system of equations with labels in an align environment:</p>
<p>\[\begin{aligned*}
a &amp;= q + 4 + 5+ 6 \label{eq1} \\ 
b &amp;= \nabla^2 u + \nabla^4 x \label{eq2}\end{aligned*}\]</p>
<p>We can refer to ([eq1])-([eq2]).</p>
<p>Or with multline?</p>
<p>a = b = q +<br />f + u [multiline:eq1]</p>
<p>Maybe split is better:</p>
<p>\[\label{split:envir:eq}
\begin{split}
a = b = q &amp;+ \\ 
  &amp; f + \nabla\cdot\nabla u
\end{split}\]</p>
<p>And we can refer to the last equation by ([split:envir:eq]).</p>
<p>What about gather?</p>
<p>\[\begin{gathered}
a = b \\ 
c = d + 7 + 9\end{gathered}\]</p>
<p>And what about alignat?</p>
<p>\[\begin{aligned*}
{2}
a &amp;= q + 4 + 5+ 6\qquad &amp; \mbox{for } q\geq 0 \label{eq1a} \\ 
b &amp;= \nabla^2 u + \nabla^4 x &amp; x\in\Omega \label{eq2a}\end{aligned*}\]</p>
<p>Let us refer to ([eq1])-([eq2]) again, and to the alignat variant ([eq1a])-([eq2a]), and to ([my:eq1]).</p>
<p>Here is eqnarray in action:</p>
<p>\[\begin{aligned*}
{\partial u\over\partial t} &amp;=&amp; \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &amp;=&amp; \nabla\cdot(q(u)\nabla v) + g \label{myeq2}\end{aligned*}\]</p>
<p>More mathematical typesetting is demonstrated in the exercises below.</p>
<h2 id="exercises">Exercises</h2>
<h3 id="flip-a-coin">Flip a Coin</h3>
<p>[demo:ex:1]</p>
<p>Make a program that simulates flipping a coin \(N\) times. Print out &quot;tail&quot; or &quot;head&quot; for each flip and let the program count the number of heads.</p>
<h5 id="hint-1.">Hint 1.</h5>
<p>Use 10pt10pt<code>r = random.random()</code> and define head as 10pt10pt<code>r &lt;= 0.5</code>.</p>
<h5 id="hint-2.">Hint 2.</h5>
<p>Draw an integer among \(\{1,2\}\) with 10pt10pt<code>r = random.randint(1,2)</code> and define head when 10pt10pt<code>r</code> is 1. Filename: 10pt10pt<code>flip_coin.py</code>.</p>
<h3 id="compute-a-probability">Compute a Probability</h3>
<p>[demo:ex:2]</p>
<p>What is the probability of getting a number between 0.5 and 0.6 when drawing uniformly distributed random numbers from the interval \([0,1)\)? To answer this question empirically, let a program draw \(N\) such random numbers using Python’s standard 10pt10pt<code>random</code> module, count how many of them, \(M\), that fall in the interval \((0.5,0.6)\), and compute the probability as \(M/N\). Run the program with the four values \(N=10^i\) for \(i=1,2,3,6\).</p>
<h3 id="explore-distributions-of-random-circles">Explore Distributions of Random Circles</h3>
<p>[proj:circle1]</p>
<p>The formula for a circle is given by</p>
<p>\[\begin{aligned*}
x &amp;= x_0 + R\cos 2\pi t,\\ 
y &amp;= y_0 + R\sin 2\pi t,\end{aligned*}\]</p>
<p>where \(R\) is the radius of the circle, \((x_0,y_0)\) is the center point, and \(t\) is a parameter in the unit interval \([0,1]\). For any \(t\), \((x,y)\) is a point on the circle. The formula can be used to generate 10pt10pt<code>n</code> points on a circle:</p>
<blockquote>
<pre><code>import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y
\</code></pre>
</blockquote>
<p>The goal of this project is to draw \(N\) circles with random center and radius. Plot each circle using the 10pt10pt<code>circle</code> function above. The following cases should be explored:</p>
<ul>
<li><p>\(R\) normally distributed and \((x_0,y_0)\) uniformly distributed</p></li>
<li><p>\(R\) uniformly distributed and \((x_0,y_0)\) normally distributed</p></li>
<li><p>\(R\) and \((x_0,y_0)\) normally distributed</p></li>
</ul>
<h5 id="hint.">Hint.</h5>
<p>Use the 10pt10pt<code>numpy.random</code> module to draw the \(x_0\), \(y_0\), and \(R\) quantities. Filename: 10pt10pt<code>circles.pdf</code>.</p>
</body>
</html>

************** File: testdoc_pnd_d2h.html *****************
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="Content-Style-Type" content="text/css" />
  <meta name="generator" content="pandoc" />
  <title></title>
  <style type="text/css">
table.sourceCode, tr.sourceCode, td.lineNumbers, td.sourceCode {
  margin: 0; padding: 0; vertical-align: baseline; border: none; }
table.sourceCode { width: 100%; }
td.lineNumbers { text-align: right; padding-right: 4px; padding-left: 4px; color: #aaaaaa; border-right: 1px solid #aaaaaa; }
td.sourceCode { padding-left: 5px; }
code > span.kw { color: #007020; font-weight: bold; }
code > span.dt { color: #902000; }
code > span.dv { color: #40a070; }
code > span.bn { color: #40a070; }
code > span.fl { color: #40a070; }
code > span.ch { color: #4070a0; }
code > span.st { color: #4070a0; }
code > span.co { color: #60a0b0; font-style: italic; }
code > span.ot { color: #007020; }
code > span.al { color: #ff0000; font-weight: bold; }
code > span.fu { color: #06287e; }
code > span.er { color: #ff0000; font-weight: bold; }
  </style>
  <script src="https://d3eoax9i5htok0.cloudfront.net/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML" type="text/javascript"></script>
</head>
<body>
<p>% A Test Document % Hans Petter Langtangen at Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo; Kaare Dump at Segfault Inc, Cyberspace; A. Dummy Author; I. S. Overworked at Inst1 and Inst2, Somewhere and Third Inst, Elsewhere and Fourth Inst; J. Doe % Jan 32, 2100</p>
<p>The format of this document is pandoc <em>Abstract.</em> This is a document with many test constructions for doconce syntax. It was used heavily for the development and kept for testing numerous constructions, also special and less common cases.</p>
<p>And exactly for test purposes we have an extra line here, which is part of the abstract.</p>
<p>Chapter 1 %%%%%%%%%</p>
<h1 id="section-0">Section 0</h1>
<h1 id="section-1">Section 1</h1>
<p>Just a little bit of text and then a list:</p>
<ul>
<li><p>item1</p></li>
<li><p>item2</p></li>
<li><p>item3 which continues on the next line to test that feature</p></li>
<li><p>and a sublist</p>
<ul>
<li><p>with indented subitem1</p></li>
<li><p>and a subitem2</p></li>
</ul></li>
<li><p>and perhaps an ordered sublist</p></li>
</ul>
<ol style="list-style-type: decimal">
<li><p>first item</p></li>
<li><p>second item, continuing on a new line</p></li>
</ol>
<h2 id="subsection-1">Subsection 1</h2>
<p>More text, with a reference back to the section <a href="#n-1">Section 1</a> and further to the section <a href="#s">URLs</a>. Let's do some copying from files too. First from subroutine up to the very end,</p>
<pre class="sourceCode Fortran"><code class="sourceCode fortran">      <span class="kw">subroutine</span>    test()
      <span class="dt">integer</span> i
      <span class="dt">real*8</span> r
      r <span class="kw">=</span> <span class="dv">0</span>
      <span class="kw">do</span> i <span class="kw">=</span> <span class="dv">1</span>, i
         r <span class="kw">=</span> r <span class="kw">+</span> i
      <span class="kw">end do</span>
      <span class="kw">return</span>
<span class="co">C     END1</span>

      <span class="kw">program</span> testme
      <span class="kw">call</span> test()
      <span class="kw">return</span></code></pre>
<p>and then just the subroutine,</p>
<pre class="sourceCode Fortran"><code class="sourceCode fortran">      <span class="kw">subroutine</span>    test()
      <span class="dt">integer</span> i
      <span class="dt">real*8</span> r
      r <span class="kw">=</span> <span class="dv">0</span>
      <span class="kw">do</span> i <span class="kw">=</span> <span class="dv">1</span>, i
         r <span class="kw">=</span> r <span class="kw">+</span> i
      <span class="kw">end do</span>
      <span class="kw">return</span></code></pre>
<p>and finally the complete file:</p>
<pre class="sourceCode Fortran"><code class="sourceCode fortran"><span class="co">C     a comment</span>

      <span class="kw">subroutine</span>    test()
      <span class="dt">integer</span> i
      <span class="dt">real*8</span> r
      r <span class="kw">=</span> <span class="dv">0</span>
      <span class="kw">do</span> i <span class="kw">=</span> <span class="dv">1</span>, i
         r <span class="kw">=</span> r <span class="kw">+</span> i
      <span class="kw">end do</span>
      <span class="kw">return</span>
<span class="co">C     END1</span>

      <span class="kw">program</span> testme
      <span class="kw">call</span> test()
      <span class="kw">return</span></code></pre>
<h2 id="subsection-2">Subsection 2</h2>
<p>Test of figures.</p>
<p>FIGURE:[../doc/manual/figs/streamtubes, width=200] Visualization of flow by streamtubes. {fig:impact}</p>
<p>Test of movies.</p>
<embed src="../doc/manual/figs/mjolnir.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
<p>
<em> Mjolnir tsunami (by Sylfest Glimsdal).</em>
</p>




<embed src="../doc/manual/figs/wavepacket.mpeg" width=700 height=400 autoplay="false" loop="true"></embed>
<p>
<em></em>
</p>



<p>
<a href="wavepacket_0001.html">Movie of files <tt>../doc/manual/figs/wavepacket_*.png</tt></a> <em> Movie based on collection of frames (here just a few frames compared with the full wavepacket.mpeg movie).</em>
</p>


<p>MOVIE: http://www.youtube.com/watch?v=_O7iUiftbKU, width=420 height=315] Movies can be uploaded to YouTube and embedded as HTML or as a link.</p>
<h2 id="table-demo">Table Demo</h2>
<p>Let us take this table from the manual:</p>
<table>
<thead>
<tr class="header">
<th align="center">time</th>
<th align="center">velocity</th>
<th align="left">acceleration</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td align="center">0.0</td>
<td align="center">1.4186</td>
<td align="left">-5.01</td>
</tr>
<tr class="even">
<td align="center">2.0</td>
<td align="center">1.376512</td>
<td align="left">11.919</td>
</tr>
<tr class="odd">
<td align="center">4.0</td>
<td align="center">1.1E+1</td>
<td align="left">14.717624</td>
</tr>
</tbody>
</table>
<p>The Doconce source code reads</p>
<pre class="sourceCode Python"><code class="sourceCode python">  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | <span class="fl">0.0</span>  | <span class="fl">1.4186</span>   | -<span class="fl">5.01</span>        |
  | <span class="fl">2.0</span>  | <span class="fl">1.376512</span> | <span class="fl">11.919</span>       |
  | <span class="fl">4.0</span>  | <span class="fl">1.1E+1</span>   | <span class="fl">14.717624</span>    |
  |--------------------------------|</code></pre>
<p>Here is yet another table to test that we can handle more than one table:</p>
<table>
<thead>
<tr class="header">
<th align="center">time</th>
<th align="center">velocity</th>
<th align="left">acceleration</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td align="center">0.0</td>
<td align="center">1.4186</td>
<td align="left">-5.01</td>
</tr>
<tr class="even">
<td align="center">1.0</td>
<td align="center">1.376512</td>
<td align="left">11.919</td>
</tr>
<tr class="odd">
<td align="center">3.0</td>
<td align="center">1.1E+1</td>
<td align="left">14.717624</td>
</tr>
</tbody>
</table>
<h2 id="urls">URLs</h2>
<p>Here are some nice URLs, e.g., hpl's home page <a href="http://folk.uio.no/hpl">hpl</a>, or the URL if desired, <a href="http://folk.uio.no/hpl"><code class="url">http://folk.uio.no/hpl</code></a>. Here is a plain file link <testdoc.do.txt>, or <testdoc.do.txt>, or <testdoc.do.txt> or <testdoc.do.txt> or <a href="testdoc.do.txt">a link with newline</a>. Can test spaces with the link with word too: <a href="http://folk.uio.no/hpl">hpl</a> or <a href="http://folk.uio.no/hpl">hpl</a>. The old syntax must also be tested: hpl's homepage (http://folk.uio.no/hpl). Now also <code>file:///</code> works: <a href="file:///home/hpl/vc/doconce/trunk/test/tmp_HTML.html">link to a file</a> is fine to have.</p>
<h2 id="latex-mathematics">LaTeX Mathematics</h2>
<p>Here is an equation without label using backslash-bracket environment: \[ a = b + c \] or with number and label, as in Equation (my:eq1), using the equation environment: \[
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}
\] We can refer to this equation by Equation (my:eq1).</p>
<p>Here is a system without equation numbers, using the align-astrisk environment: \[
\begin{align*}
\pmb{a} &amp;= \pmb{q}\times\pmb{n} \\ 
b &amp;= \nabla^2 u + \nabla^4 v
\end{align*}
\]</p>
<p>And here is a system of equations with labels in an align environment: \[
\begin{align}
a &amp;= q + 4 + 5+ 6 \label{eq1} \\ 
b &amp;= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}
\] We can refer to Equations (eq1)-(eq2).</p>
<p>Or with multline? \[
\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}
\] Maybe split is better: \[
\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &amp;+ \\ 
  &amp; f + \nabla\cdot\nabla u
\end{split}
\end{equation}
\] And we can refer to the last equation by Equation (split:envir:eq).</p>
<p>What about gather? \[
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}
\]</p>
<p>And what about alignat? \[
\begin{alignat}{2}
a &amp;= q + 4 + 5+ 6\qquad &amp; \mbox{for } q\geq 0 \label{eq1a} \\ 
b &amp;= \nabla^2 u + \nabla^4 x &amp; x\in\Omega \label{eq2a}
\end{alignat}
\] Let us refer to Equations (eq1)-(eq2) again, and to the alignat variant Equations (eq1a)-(eq2a), and to Equation (my:eq1).</p>
<p>Here is eqnarray in action: \[
\begin{eqnarray}
{\partial u\over\partial t} &amp;=&amp; \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &amp;=&amp; \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}
\]</p>
<p>More mathematical typesetting is demonstrated in the exercises below.</p>
<h1 id="exercises">Exercises</h1>
<h2 id="flip-a-coin">Flip a Coin</h2>
<p>Make a program that simulates flipping a coin \(N\) times. Print out &quot;tail&quot; or &quot;head&quot; for each flip and let the program count the number of heads.</p>
<p><em>Hint 1.</em> Use <code>r = random.random()</code> and define head as <code>r &lt;= 0.5</code>.</p>
<p><em>Hint 2.</em> Draw an integer among \(\{1,2\}\) with <code>r = random.randint(1,2)</code> and define head when <code>r</code> is 1. <em>Filename</em>: <code>flip_coin.py</code></p>
<h2 id="compute-a-probability">Compute a Probability</h2>
<p>What is the probability of getting a number between 0.5 and 0.6 when drawing uniformly distributed random numbers from the interval \([0,1)\)? To answer this question empirically, let a program draw \(N\) such random numbers using Python's standard <code>random</code> module, count how many of them, \(M\), that fall in the interval \((0.5,0.6)\), and compute the probability as \(M/N\). Run the program with the four values \(N=10^i\) for \(i=1,2,3,6\).</p>
<h2 id="explore-distributions-of-random-circles">Explore Distributions of Random Circles</h2>
<p>The formula for a circle is given by \[
\begin{align}
x &amp;= x_0 + R\cos 2\pi t,\\ 
y &amp;= y_0 + R\sin 2\pi t,
\end{align}
\] where \(R\) is the radius of the circle, \((x_0,y_0)\) is the center point, and \(t\) is a parameter in the unit interval \([0,1]\). For any \(t\), \((x,y)\) is a point on the circle. The formula can be used to generate <code>n</code> points on a circle:</p>
<pre class="sourceCode Python"><code class="sourceCode python"><span class="ch">import</span> numpy <span class="ch">as</span> np

<span class="kw">def</span> circle(R, x0, y0, n=<span class="dv">501</span>):
    t = np.linspace(<span class="dv">0</span>, <span class="dv">1</span>, n)
    x = x0 + R*np.cos(<span class="dv">2</span>*np.pi*t)
    y = y0 + R*np.sin(<span class="dv">2</span>*np.pi*t)
    <span class="kw">return</span> x, y</code></pre>
<p>The goal of this project is to draw \(N\) circles with random center and radius. Plot each circle using the <code>circle</code> function above. The following cases should be explored:</p>
<ul>
<li><p>\(R\) normally distributed and \((x_0,y_0)\) uniformly distributed</p></li>
<li><p>\(R\) uniformly distributed and \((x_0,y_0)\) normally distributed</p></li>
<li><p>\(R\) and \((x_0,y_0)\) normally distributed</p></li>
</ul>
<p><em>Hint.</em> Use the <code>numpy.random</code> module to draw the \(x_0\), \(y_0\), and \(R\) quantities. <em>Filename</em>: <code>circles.pdf</code></p>
</body>
</html>

************** File: make.sh *****************
#!/bin/sh -x
# Test multiple authors
doconce format html testdoc.do.txt
doconce format latex testdoc.do.txt
doconce format pdflatex testdoc.do.txt
ptex2tex -DMINTED testdoc
doconce format plain testdoc.do.txt
doconce format st testdoc.do.txt
doconce format sphinx testdoc.do.txt
mv -f testdoc.rst testdoc.sphinx.rst
doconce format rst testdoc.do.txt
doconce format epytext testdoc.do.txt
doconce format pandoc testdoc.do.txt
doconce format mwiki testdoc.do.txt
doconce format cwiki testdoc.do.txt
# Test mako variables too
doconce format gwiki testdoc.do.txt --skip_inline_comments MYVAR1=3 MYVAR2='a string'

# Test pandoc
doconce format latex testdoc.do.txt
doconce ptex2tex testdoc -DBOOK -DLATEXHEADING=traditional
#doconce subst -s 'And here is a system of equations with labels.+?\\section' '\\section' testdoc.tex
pandoc -f latex -t markdown -o testdoc.mkd testdoc.tex
pandoc -f markdown -t html -o testdoc_pnd_l2h.html --mathjax -s testdoc.mkd

doconce format pandoc testdoc.do.txt
pandoc -t html -o testdoc_pnd_d2h.html --mathjax -s testdoc.mkd

# Test grab
doconce grab --from- '={9}' --to 'subroutine@' testdoc.do.txt > testdoc.tmp
doconce grab --from 'Compute a Probability' --to- 'drawing uniformly' testdoc.do.txt >> testdoc.tmp
doconce grab --from- '\*\s+\$.+normally' testdoc.do.txt >> testdoc.tmp

# Test encoding
doconce guess_encoding encoding1.do.txt > tmp_encodings.txt
cp encoding1.do.txt tmp1.do.txt
doconce change_encoding utf-8 latin1 tmp1.do.txt
doconce guess_encoding tmp1.do.txt >> tmp_encodings.txt
doconce change_encoding latin1 utf-8 tmp1.do.txt
doconce guess_encoding tmp1.do.txt >> tmp_encodings.txt

doconce guess_encoding encoding2.do.txt >> tmp_encodings.txt
cp encoding1.do.txt tmp2.do.txt
doconce change_encoding utf-8 latin1 tmp2.do.txt
doconce guess_encoding tmp2.do.txt >> tmp_encodings.txt

# Test error detection
doconce format plain failures
cp failures.do.txt tmp2.do.txt
doconce subst 'failure\}\n\n!bc' 'failure}\n\nHello\n!bc' tmp2.do.txt
doconce format rst tmp2
doconce replace '\label' 'label' tmp2.do.txt
doconce replace '\idx' 'idx' tmp2.do.txt
doconce replace '\cite' 'cite' tmp2.do.txt
doconce format rst tmp2
doconce subst -s '__Paragraph before.+!bc' '!bc' tmp2.do.txt
doconce format rst tmp2
doconce replace 'streamtubes width' 'streamtubes,  width' tmp2.do.txt
doconce format rst tmp2
doconce replace '# Comment before math' '' tmp2.do.txt
doconce format rst tmp2
doconce replace '# Comment before list' '' tmp2.do.txt
doconce format rst tmp2



************** File: make.sh *****************
#!/bin/sh -x
./clean.sh

# html
doconce format html tutorial

# latex
doconce format latex tutorial
ptex2tex -DHELVETICA tutorial
latex tutorial.tex  # no -shell-escape since no -DMINTED to ptex2tex
latex tutorial.tex
dvipdf tutorial.dvi

# Sphinx
doconce format sphinx tutorial
rm -rf sphinx-rootdir
doconce sphinx_dir tutorial
cp tutorial.rst tutorial.sphinx.rst
mv tutorial.rst sphinx-rootdir
cd sphinx-rootdir
make clean
make html
make latex
cd _build/latex
make clean
make all-pdf
cp DoconceDocumentOnceIncludeAnywhere.pdf ../../../tutorial.sphinx.pdf
cd ../../..
#firefox sphinx-rootdir/_build/html/index.html

# reStructuredText:
doconce format rst tutorial
rst2xml.py tutorial.rst > tutorial.xml
rst2odt.py tutorial.rst > tutorial.odt
rst2html.py tutorial.rst > tutorial.rst.html
rst2latex.py tutorial.rst > tutorial.rst.tex
latex tutorial.rst.tex
dvipdf tutorial.rst.dvi

# Other formats:
doconce format plain tutorial.do.txt
doconce format gwiki tutorial.do.txt
doconce format cwiki tutorial.do.txt
doconce format mwiki tutorial.do.txt
doconce format st tutorial.do.txt
doconce format epytext tutorial.do.txt
doconce format pandoc tutorial.do.txt

# Make PDF of most of the above:
a2ps_plain='a2ps --left-title='\'''\'' --right-title='\'''\'' --left-footer='\'''\'' --right-footer='\'''\'' --footer='\'''\'''
$a2ps_plain -1 -o tutorial.do.ps tutorial.do.txt
ps2pdf tutorial.do.ps tutorial.do.pdf
$a2ps_plain -1 -o tutorial.epytext.ps tutorial.epytext
ps2pdf tutorial.epytext.ps
$a2ps_plain -1 -o tutorial.txt.ps tutorial.txt
ps2pdf tutorial.txt.ps
$a2ps_plain -1 -o tutorial.gwiki.ps tutorial.gwiki
ps2pdf tutorial.gwiki.ps
$a2ps_plain -1 -o tutorial.cwiki.ps tutorial.cwiki
ps2pdf tutorial.cwiki.ps
$a2ps_plain -1 -o tutorial.mwiki.ps tutorial.mwiki
ps2pdf tutorial.mwiki.ps
$a2ps_plain -1 -o tutorial.mkd.ps tutorial.mkd
ps2pdf tutorial.mkd.ps
$a2ps_plain -1 -o tutorial.xml.ps tutorial.xml
ps2pdf tutorial.xml.ps

rm -f *.ps

#wkhtmltopdf tutorial.rst.html tutorial.rst.html.pdf
#wkhtmltopdf tutorial.html tutorial.html.pdf

pdftk tutorial.do.pdf tutorial.pdf tutorial.rst.pdf tutorial.sphinx.pdf tutorial.txt.pdf tutorial.epytext.pdf tutorial.gwiki.pdf tutorial.mkd.pdf tutorial.sphinx.pdf tutorial.xml.pdf  cat output collection_of_results.pdf

rm -rf demo
mkdir demo
cp -r tutorial.do.txt tutorial.html tutorial.p.tex tutorial.tex tutorial.pdf tutorial.rst tutorial.sphinx.rst tutorial.sphinx.pdf tutorial.xml tutorial.rst.html tutorial.rst.tex tutorial.rst.pdf tutorial.gwiki tutorial.mwiki tutorial. cwiki tutorial.txt tutorial.epytext tutorial.st tutorial.mkd collection_of_results.pdf sphinx-rootdir/_build/html demo

cd demo
cat > index.html <<EOF
<HTML><BODY>
<TITLE>Demo of Doconce formats</TITLE>
<H3>Doconce demo</H3>

Doconce is a minimum tagged markup language. The file
<a href="tutorial.do.txt">tutorial.do.txt</a> is the source of the
Doconce tutorial, written in the Doconce format.
Running
<pre>
doconce format html tutorial.do.txt
</pre>
produces the HTML file <a href="tutorial.html">tutorial.html</a>.
Going from Doconce to LaTeX is done by
<pre>
doconce format latex tutorial.do.txt
</pre>
resulting in the file <a href="tutorial.tex">tutorial.tex</a>, which can
be compiled to a PDF file <a href="tutorial.pdf">tutorial.pdf</a>
by running <tt>latex</tt> and <tt>dvipdf</tt> the standard way.
<p>
The reStructuredText (reST) format is of particular interest:
<pre>
doconce format rst    tutorial.do.txt  # standard reST
doconce format sphinx tutorial.do.txt  # Sphinx extension of reST
</pre>
The reST file <a href="tutorial.rst">tutorial.rst</a> is a starting point
for conversion to many other formats: OpenOffice,
<a href="tutorial.xml">XML</a>, <a href="tutorial.rst.html">HTML</a>,
<a href="tutorial.rst.tex">LaTeX</a>,
and from LaTeX to <a href="tutorial.rst.pdf">PDF</a>.
The <a href="tutorial.sphinx.rst">Sphinx</a> dialect of reST
can be translated to <a href="tutorial.sphinx.pdf">PDF</a>
and <a href="html/index.html">HTML</a>.
<p>
Doconce can also be converted to
<a href="tutorial.gwiki">Googlecode wiki</a>,
<a href="tutorial.cwiki">Creole wiki</a>,
<a href="tutorial.mwiki">MediaWiki wiki</a>,
<a href="tutorial.mkd">Pandoc</a>,
<a href="tutorial.st">Structured Text</a>,
<a href="tutorial.epytext">Epytext</a>,
and maybe the most important format of all:
<a href="tutorial.txt">plain untagged ASCII text</a>.
</BODY>
</HTML>
EOF

echo
echo "Go to the demo directory and load index.html into a web browser."

# update demo (recall that there is no .hg dir except in the top dir
# so we can just take an rm and cp)
cd ..
rm -rf ../demos/tutorial
cp -r demo ../demos/tutorial
# update wiki too
cp tutorial.gwiki ../../../doconce.wiki/Tutorial.wiki
************** File: tutorial.do.txt *****************
TITLE: Doconce: Document Once, Include Anywhere
AUTHOR: Hans Petter Langtangen at Simula Research Laboratory and University of Oslo
DATE: today


 * When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?

 * Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like "LaTeX":"http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf", "HTML":"http://www.htmlcodetutorial.com/", "reStructuredText":"http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html", "Sphinx":"http://sphinx.pocoo.org/contents.html", and "wiki":"http://code.google.com/p/support/wiki/WikiSyntax"? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?

 * Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.


======= The Doconce Concept  =======

# #include "_what_is.do.txt"

======= What Does Doconce Look Like? =======

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  * Bullet lists arise from lines starting with an asterisk.

  * *Emphasized words* are surrounded by asterisks.

  * _Words in boldface_ are surrounded by underscores.

  * Words from computer code are enclosed in back quotes and
    then typeset `verbatim (in a monospace font)`.

  * Section headings are recognied by equality (`=`) signs before
    and after the title, and the number of `=` signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.

  * Paragraph headings are recognized by a double underscore
    before and after the heading.

  * The abstract of a document starts with *Abstract* as paragraph
    heading, and all text up to the next heading makes up the abstract,

  * Blocks of computer code can easily be included by placing
    `!bc` (begin code) and `!ec` (end code) commands at separate lines
    before and after the code block.

  * Blocks of computer code can also be imported from source files.

  * Blocks of LaTeX mathematics can easily be included by placing
    `!bt` (begin TeX) and `!et` (end TeX) commands at separate lines
    before and after the math block.

  * There is support for both LaTeX and text-like inline mathematics.

  * Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.

  * Invisible comments in the output format can be inserted throughout
    the text.

  * Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).

  * There is special support for advanced exercises features.

  * With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.

  * With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format:
!bc
===== A Subsection with Sample Text =====
label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have automatically numbered items instead of bullets,

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

# lines beginning with # are comment lines
!ec
The Doconce text above results in the following little document:

===== A Subsection with Sample Text =====
label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have numbered items instead of bullets, just use an `o`
(for ordered) instead of the asterisk:

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

===== Mathematics and Computer Code =====

Inline mathematics, such as $\nu = \sin(x)$|$v = sin(x)$,
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like $\nu = \sin(x)$|$v = sin(x)$ is
typeset as
!bc
$\nu = \sin(x)$|$v = sin(x)$
!ec
The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
`!bt` and `!et` (begin tex / end tex) instructions.
The result looks like this:
!bt
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
\end{eqnarray}
!et
Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
`!bc` and `!ec` instructions, respectively. Such blocks look like
!bc cod
from math import sin, pi
def myfunc(x):
    return sin(pi*x)

import integrate
I = integrate.trapezoidal(myfunc, 0, pi, 100)
!ec
A code block must come after some plain sentence (at least for successful
output to `sphinx`, `rst`, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., `!bc xxx`
where `xxx` is an identifier like `pycod` for code snippet in Python,
`sys` for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in `ptex2tex` and defined in a
configuration file `.ptext2tex.cfg`, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):
!bc
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
!ec
By default, `pro` and `cod` are `python`, `sys` is `console`,
while `xpro` and `xcod` are computer language specific for `x`
in `f` (Fortran), `c` (C), `cpp` (C++), `pl` (Perl), `m` (Matlab),
`sh` (Unix shells), `cy` (Cython), and `py` (Python).

# (Any sphinx code-block comment, whether inside verbatim code
# blocks or outside, yields a mapping between bc arguments
# and computer languages. In case of muliple definitions, the
# first one is used.)

One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with `!bc pro`, while a part of a file is copied into a `!bc cod`
environment. What `pro` and `cod` mean is then defined through
a `.ptex2tex.cfg` file for LaTeX and a `sphinx code-blocks`
comment for Sphinx.

Another document can be included by writing `#include "mynote.do.txt"`
on a line starting with (another) hash sign.  Doconce documents have
extension `do.txt`. The `do` part stands for doconce, while the
trailing `.txt` denotes a text document so that editors gives you the
right writing enviroment for plain text.


===== Macros (Newcommands), Cross-References, Index, and Bibliography =====
label{newcommands}

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
`newcommand_replace.tex` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names `newcommands.tex` and
`newcommands_keep.tex` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
`!bt` and `!et` in `newcommands_keep.tex` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
`newcommands_replace.tex` and expanded by Doconce.  The definitions of
newcommands in the `newcommands*.tex` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the `doc/manual/manual.do.txt` file (see the
"demo page": "https://doconce.googlecode.com/hg/doc/demos/manual/index.html"
for various formats of this document).


# Example on including another Doconce file (using preprocess):

# #include "_doconce2anything.do.txt"


===== Demos =====

The current text is generated from a Doconce format stored in the file
!bc
docs/tutorial/tutorial.do.txt
!ec
The file `make.sh` in the `tutorial` directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, `tutorial.do.txt` is the
starting point.  Running `make.sh` and studying the various generated
files and comparing them with the original `tutorial.do.txt` file,
gives a quick introduction to how Doconce is used in a real case.
"Here": "https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html"
is a sample of how this tutorial looks in different formats.

There is another demo in the `docs/manual` directory which
translates the more comprehensive documentation, `manual.do.txt`, to
various formats. The `make.sh` script runs a set of translations.

# #include "../manual/_install.do.txt"



************** File: tutorial.html *****************
<?xml version="1.0" encoding="utf-8" ?>
<!--
Automatically generated HTML file from Doconce source
(http://code.google.com/p/doconce/)
-->

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="generator" content="Doconce: http://code.google.com/p/doconce/" />

<script type="text/javascript"
 src="http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>

</head>

<body bgcolor="white">
    <title>Doconce: Document Once, Include Anywhere</title>
<center><h1>Doconce: Document Once, Include Anywhere</h1></center>
<center>
<b>Hans Petter Langtangen</b> [1, 2]
</center>

<p>
<center>[1] <b>Simula Research Laboratory</b></center>
<center>[2] <b>University of Oslo</b></center>


<center><h3>Jan 32, 2100</h3></center>
<P>

<P>

<ul>
 <li> When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?
 <li> Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like <a href="http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf">LaTeX</a>, <a href="http://www.htmlcodetutorial.com/">HTML</a>, <a href="http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html">reStructuredText</a>, <a href="http://sphinx.pocoo.org/contents.html">Sphinx</a>, and <a href="http://code.google.com/p/support/wiki/WikiSyntax">wiki</a>? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?
 <li> Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?
</ul>

If any of these questions are of interest, you should keep on reading.

<P>

<P>
<h2>The Doconce Concept</h2>
<P>
Doconce is two things:

<P>

<ol>
 <li> Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via <tt>rst2*</tt> programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via <tt>unoconv</tt>) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.
 <li> Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".
</ol>

Here are some Doconce features:

<P>

<ul>
  <li> Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.
  <li> Doconce can be converted to plain <em>untagged</em> text,
    often desirable for computer programs and email.
  <li> Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.
  <li> Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).
  <li> Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.
  <li> Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.
</ul>

Doconce was particularly written for the following sample applications:

<P>

<ul>
  <li> Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.
  <li> Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.
  <li> Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.
</ul>

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

<P>
Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.

<P>

<P>

<P>
<h2>What Does Doconce Look Like?</h2>
<P>
Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

<P>

<ul>
  <li> Bullet lists arise from lines starting with an asterisk.
  <li> <em>Emphasized words</em> are surrounded by asterisks.
  <li> <b>Words in boldface</b> are surrounded by underscores.
  <li> Words from computer code are enclosed in back quotes and
    then typeset <tt>verbatim (in a monospace font)</tt>.
  <li> Section headings are recognied by equality (<tt>=</tt>) signs before
    and after the title, and the number of <tt>=</tt> signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.
  <li> Paragraph headings are recognized by a double underscore
    before and after the heading.
  <li> The abstract of a document starts with <em>Abstract</em> as paragraph
    heading, and all text up to the next heading makes up the abstract,
  <li> Blocks of computer code can easily be included by placing
    <tt>!bc</tt> (begin code) and <tt>!ec</tt> (end code) commands at separate lines
    before and after the code block.
  <li> Blocks of computer code can also be imported from source files.
  <li> Blocks of LaTeX mathematics can easily be included by placing
    <tt>!bt</tt> (begin TeX) and <tt>!et</tt> (end TeX) commands at separate lines
    before and after the math block.
  <li> There is support for both LaTeX and text-like inline mathematics.
  <li> Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.
  <li> Invisible comments in the output format can be inserted throughout
    the text.
  <li> Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).
  <li> There is special support for advanced exercises features.
  <li> With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.
  <li> With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.
</ul>

Here is an example of some simple text written in the Doconce format:
<blockquote>    <!-- begin verbatim block  -->
<pre>
===== A Subsection with Sample Text =====
\label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have automatically numbered items instead of bullets,

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

# lines beginning with # are comment lines
</pre>
</blockquote>   <! -- end verbatim block -->
The Doconce text above results in the following little document:

<P>
<h3>A Subsection with Sample Text <a name="my:first:sec"></A></h3>
<P>

<P>
Ordinary text looks like ordinary text, and the tags used for
<b>boldface</b> words, <em>emphasized</em> words, and <tt>computer</tt> words look
natural in plain text.  Lists are typeset as you would do in an email,

<P>

<ul>
  <li> item 1
  <li> item 2
  <li> item 3
</ul>

Lists can also have numbered items instead of bullets, just use an <tt>o</tt>
(for ordered) instead of the asterisk:

<P>

<ol>
 <li> item 1
 <li> item 2
 <li> item 3
</ol>

URLs with a link word are possible, as in <a href="http://folk.uio.no/hpl">hpl</a>.
If the word is URL, the URL itself becomes the link name,
as in <a href="tutorial.do.txt"><tt>tutorial.do.txt</tt></a>.

<P>
References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section <a href="#my:first:sec">A Subsection with Sample Text</a>.

<P>
Doconce also allows inline comments such as [<b>hpl</b>: <em>here I will make
some remarks to the text</em>] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section <a href="#doconce2formats">From Doconce to Other Formats</a> for an example).

<P>
Tables are also supperted, e.g.,

<P>
<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="right">   0.0             </td> <td align="right">   1.4186          </td> <td align="right">   -5.01           </td> </tr>
<tr><td align="right">   2.0             </td> <td align="right">   1.376512        </td> <td align="right">   11.919          </td> </tr>
<tr><td align="right">   4.0             </td> <td align="right">   1.1E+1          </td> <td align="right">   14.717624       </td> </tr>
</table>
<P>
<h3>Mathematics and Computer Code</h3>
<P>
Inline mathematics, such as \( \nu = \sin(x) \)o,
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like \( \nu = \sin(x) \)o is
typeset as
<blockquote>    <!-- begin verbatim block  -->
<pre>
$\nu = \sin(x)$|$v = sin(x)$
</pre>
</blockquote>   <! -- end verbatim block -->
The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

<P>
Blocks of mathematics are better typeset with raw LaTeX, inside
<tt>!bt</tt> and <tt>!et</tt> (begin tex / end tex) instructions.
The result looks like this:
$$
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
\end{eqnarray}
$$
Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

<P>
You can have blocks of computer code, starting and ending with
<tt>!bc</tt> and <tt>!ec</tt> instructions, respectively. Such blocks look like
<blockquote>    <!-- begin verbatim block   cod-->
<pre>
from math import sin, pi
def myfunc(x):
    return sin(pi*x)

import integrate
I = integrate.trapezoidal(myfunc, 0, pi, 100)
</pre>
</blockquote>   <! -- end verbatim block -->
A code block must come after some plain sentence (at least for successful
output to <tt>sphinx</tt>, <tt>rst</tt>, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

<P>
It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., <tt>!bc xxx</tt>
where <tt>xxx</tt> is an identifier like <tt>pycod</tt> for code snippet in Python,
<tt>sys</tt> for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in <tt>ptex2tex</tt> and defined in a
configuration file <tt>.ptext2tex.cfg</tt>, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):
<blockquote>    <!-- begin verbatim block  -->
<pre>
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
</pre>
</blockquote>   <! -- end verbatim block -->
By default, <tt>pro</tt> and <tt>cod</tt> are <tt>python</tt>, <tt>sys</tt> is <tt>console</tt>,
while <tt>xpro</tt> and <tt>xcod</tt> are computer language specific for <tt>x</tt>
in <tt>f</tt> (Fortran), <tt>c</tt> (C), <tt>cpp</tt> (C++), <tt>pl</tt> (Perl), <tt>m</tt> (Matlab),
<tt>sh</tt> (Unix shells), <tt>cy</tt> (Cython), and <tt>py</tt> (Python).

<P>
<!-- (Any sphinx code-block comment, whether inside verbatim code -->
<!-- blocks or outside, yields a mapping between bc arguments -->
<!-- and computer languages. In case of muliple definitions, the -->
<!-- first one is used.) -->

<P>
One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with <tt>!bc pro</tt>, while a part of a file is copied into a <tt>!bc cod</tt>
environment. What <tt>pro</tt> and <tt>cod</tt> mean is then defined through
a <tt>.ptex2tex.cfg</tt> file for LaTeX and a <tt>sphinx code-blocks</tt>
comment for Sphinx.

<P>
Another document can be included by writing <tt>#include "mynote.do.txt"</tt>
on a line starting with (another) hash sign.  Doconce documents have
extension <tt>do.txt</tt>. The <tt>do</tt> part stands for doconce, while the
trailing <tt>.txt</tt> denotes a text document so that editors gives you the
right writing enviroment for plain text.

<P>

<P>
<h3>Macros (Newcommands), Cross-References, Index, and Bibliography <a name="newcommands"></A></h3>
<P>

<P>
Doconce supports a type of macros via a LaTeX-style <em>newcommand</em>
construction.  The newcommands defined in a file with name
<tt>newcommand_replace.tex</tt> are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names <tt>newcommands.tex</tt> and
<tt>newcommands_keep.tex</tt> are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
<tt>!bt</tt> and <tt>!et</tt> in <tt>newcommands_keep.tex</tt> to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
<tt>newcommands_replace.tex</tt> and expanded by Doconce.  The definitions of
newcommands in the <tt>newcommands*.tex</tt> files <em>must</em> appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

<P>
Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the <tt>doc/manual/manual.do.txt</tt> file (see the
<a href="https://doconce.googlecode.com/hg/doc/demos/manual/index.html">demo page</a>
for various formats of this document).

<P>

<P>
<!-- Example on including another Doconce file (using preprocess): -->

<P>

<P>
<h2>From Doconce to Other Formats <a name="doconce2formats"></A></h2>
<P>

<P>
Transformation of a Doconce document <tt>mydoc.do.txt</tt> to various other
formats applies the script <tt>doconce format</tt>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format format mydoc.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
or just
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format format mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The <tt>mako</tt> or <tt>preprocess</tt> programs are always used to preprocess the
file first, and options to <tt>mako</tt> or <tt>preprocess</tt> can be added after the
filename. For example,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal&gt; doconce format latex yourdoc extra_sections=True VAR1=5  # mako
</pre>
</blockquote>   <! -- end verbatim block -->
The variable <tt>FORMAT</tt> is always defined as the current format when
running <tt>preprocess</tt>. That is, in the last example, <tt>FORMAT</tt> is
defined as <tt>latex</tt>. Inside the Doconce document one can then perform
format specific actions through tests like <tt>#if FORMAT == "latex"</tt>.

<P>
Inline comments in the text are removed from the output by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc --skip_inline_comments
</pre>
</blockquote>   <! -- end verbatim block -->
One can also remove all such comments from the original Doconce
file by running:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Terminal&gt; doconce remove_inline_comments mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

<P>

<P>
<h3>HTML</h3>
<P>
Making an HTML version of a Doconce file <tt>mydoc.do.txt</tt>
is performed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format html mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The resulting file <tt>mydoc.html</tt> can be loaded into any web browser for viewing.

<P>
<h3>Pandoc</h3>
<P>
Output in Pandoc's extended Markdown format results from
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format pandoc mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The name of the output file is <tt>mydoc.mkd</tt>.
From this format one can go to numerous other formats:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
</pre>
</blockquote>   <! -- end verbatim block -->
Pandoc supports <tt>latex</tt>, <tt>html</tt>, <tt>odt</tt> (OpenOffice), <tt>docx</tt> (Microsoft
Word), <tt>rtf</tt>, <tt>texinfo</tt>, to mention some. The <tt>-R</tt> option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the <a href="http://johnmacfarlane.net/pandoc/README.html">Pandoc documentation</a>
for the many features of the <tt>pandoc</tt> program.

<P>
Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
<tt>doconce format pandoc</tt> and then translating using <tt>pandoc</tt>, or
<tt>doconce format latex</tt>, and then going from LaTeX to the desired format
using <tt>pandoc</tt>.
Here is an example on the latter strategy:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc
Terminal&gt; doconce ptex2tex mydoc
Terminal&gt; pandoc -f latex -t docx -o mydoc.docx mydoc.tex
</pre>
</blockquote>   <! -- end verbatim block -->
When we go through <tt>pandoc</tt>, only single equations or <tt>align*</tt>
environments are well understood.

<P>
Quite some <tt>doconce replace</tt> and <tt>doconce subst</tt> edits might be needed
on the <tt>.mkd</tt> or <tt>.tex</tt> files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

<P>
Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format pandoc mydoc
Terminal&gt; pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
</pre>
</blockquote>   <! -- end verbatim block -->
The <tt>-s</tt> option adds a proper header and footer to the <tt>mydoc.html</tt> file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

<P>

<P>
<h3>LaTeX</h3>
<P>
Making a LaTeX file <tt>mydoc.tex</tt> from <tt>mydoc.do.txt</tt> is done in two steps:
<!-- Note: putting code blocks inside a list is not successful in many -->
<!-- formats - the text may be messed up. A better choice is a paragraph -->
<!-- environment, as used here. -->

<P>
<b>Step 1.</b> Filter the doconce text to a pre-LaTeX form <tt>mydoc.p.tex</tt> for
     <tt>ptex2tex</tt>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files <tt>newcommands.tex</tt>, <tt>newcommands_keep.tex</tt>, or
<tt>newcommands_replace.tex</tt> (see the section <a href="#newcommands">Macros (Newcommands), Cross-References, Index, and Bibliography</a>).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

<P>
<b>Step 2.</b> Run <tt>ptex2tex</tt> (if you have it) to make a standard LaTeX file,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
In case you do not have <tt>ptex2tex</tt>, you may run a (very) simplified version:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce ptex2tex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Note that Doconce generates a <tt>.p.tex</tt> file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DHELVETICA mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DLATEX_HEADING=traditional mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
A separate titlepage can be generate by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DLATEX_HEADING=titlepage mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The <tt>ptex2tex</tt> tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any <tt>!bc</tt> command in the Doconce source you can
insert verbatim block styles as defined in your <tt>.ptex2tex.cfg</tt>
file, e.g., <tt>!bc cod</tt> for a code snippet, where <tt>cod</tt> is set to
a certain environment in <tt>.ptex2tex.cfg</tt> (e.g., <tt>CodeIntended</tt>).
There are about 40 styles to choose from.

<P>
Also the <tt>doconce ptex2tex</tt> command supports preprocessor directives
for processing the <tt>.p.tex</tt> file. The command allows specifications
of code environments as well. Here is an example:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
</pre>
</blockquote>   <! -- end verbatim block -->
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
<tt>verbatim</tt> above, which implies <tt>\begin{verbatim}</tt> and <tt>\end{verbatim}</tt>).
The value <tt>minted</tt> can be used for code environments where the
language is specified, as in <tt>fpro</tt>, where <tt>minted</tt> implies
<tt>\begin{python}{fortran}</tt>. There is a similar support for <tt>ans</tt>:
<tt>cppcod=ans</tt> imples <tt>\begin{c++}</tt> and <tt>\end{c++}</tt> using the
<tt>anslistings</tt> package.

<P>
<b>Step 2b (optional).</b> Edit the <tt>mydoc.tex</tt> file to your needs.
For example, you may want to substitute <tt>section</tt> by <tt>section*</tt> to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the <tt>doconce replace</tt> and <tt>doconce subst</tt>
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce replace 'section{' 'section*{' mydoc.tex
Terminal&gt; doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g&lt;1&gt; \\\\ [1.5mm] Using \g&lt;2&gt;' mydoc.tex
</pre>
</blockquote>   <! -- end verbatim block -->
A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

<P>
<b>Step 3.</b> Compile <tt>mydoc.tex</tt>
and create the PDF file:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; latex mydoc
Terminal&gt; latex mydoc
Terminal&gt; makeindex mydoc   # if index
Terminal&gt; bibitem mydoc     # if bibliography
Terminal&gt; latex mydoc
Terminal&gt; dvipdf mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
If one wishes to use the <tt>Minted_Python</tt>, <tt>Minted_Cpp</tt>, etc.,
environments in <tt>ptex2tex</tt> for typesetting code (specified, e.g., in
the <tt>*pro</tt> and <tt>*cod</tt> environments in <tt>.ptex2tex.cfg</tt> or
<tt>$HOME/.ptex2tex.cfg</tt>), the <tt>minted</tt> LaTeX package is needed.  This
package is included by running <tt>doconce format</tt> with the <tt>-DMINTED</tt>
option:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DMINTED mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
In this case, <tt>latex</tt> must be run with the
<tt>-shell-escape</tt> option:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; latex -shell-escape mydoc
Terminal&gt; latex -shell-escape mydoc
Terminal&gt; makeindex mydoc   # if index
Terminal&gt; bibitem mydoc     # if bibliography
Terminal&gt; latex -shell-escape mydoc
Terminal&gt; dvipdf mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>

<P>
<h3>PDFLaTeX</h3>
<P>
Running <tt>pdflatex</tt> instead of <tt>latex</tt> follows almost the same steps,
but the start is
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
Then <tt>ptex2tex</tt> is run as explained above, and finally
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; pdflatex -shell-escape mydoc
Terminal&gt; makeindex mydoc   # if index
Terminal&gt; bibitem mydoc     # if bibliography
Terminal&gt; pdflatex -shell-escape mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h3>Plain ASCII Text</h3>
<P>
We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format plain mydoc.do.txt  # results in mydoc.txt
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h3>reStructuredText</h3>
<P>
Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file <tt>mydoc.rst</tt>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format rst mydoc.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
We may now produce various other formats:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; rst2html.py  mydoc.rst &gt; mydoc.html # html
Terminal&gt; rst2latex.py mydoc.rst &gt; mydoc.tex  # latex
Terminal&gt; rst2xml.py   mydoc.rst &gt; mydoc.xml  # XML
Terminal&gt; rst2odt.py   mydoc.rst &gt; mydoc.odt  # OpenOffice
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The OpenOffice file <tt>mydoc.odt</tt> can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program <tt>unovonv</tt>
to convert between the many formats OpenOffice supports <em>on the command line</em>.
Run
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; unoconv --show
</pre>
</blockquote>   <! -- end verbatim block -->
to see all the formats that are supported.
For example, the following commands take
<tt>mydoc.odt</tt> to Microsoft Office Open XML format,
classic MS Word format, and PDF:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; unoconv -f ooxml mydoc.odt
Terminal&gt; unoconv -f doc mydoc.odt
Terminal&gt; unoconv -f pdf mydoc.odt
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Remark about Mathematical Typesetting.</b> At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by <tt>latex</tt> as
output and to a wide extent also supported by the <tt>sphinx</tt> output format.
Some links for going from LaTeX to Word are listed below.

<P>

<ul>
 <li> <a href="http://ubuntuforums.org/showthread.php?t=1033441"><tt>http://ubuntuforums.org/showthread.php?t=1033441</tt></a>
 <li> <a href="http://tug.org/utilities/texconv/textopc.html"><tt>http://tug.org/utilities/texconv/textopc.html</tt></a>
 <li> <a href="http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html"><tt>http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html</tt></a>
</ul>
<h3>Sphinx</h3>
<P>
Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the <tt>doconce sphinx_dir</tt> command:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
</pre>
</blockquote>   <! -- end verbatim block -->
The keywords <tt>author</tt>, <tt>title</tt>, and <tt>version</tt> are used in the headings
of the Sphinx document. By default, <tt>version</tt> is 1.0 and the script
will try to deduce authors and title from the doconce files <tt>file1</tt>,
<tt>file2</tt>, etc. that together represent the whole document. Note that
none of the individual Doconce files <tt>file1</tt>, <tt>file2</tt>, etc. should
include the rest as their union makes up the whole document.
The default value of <tt>dirname</tt> is <tt>sphinx-rootdir</tt>. The <tt>theme</tt>
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is <tt>'default'</tt>).

<P>
With a single-file document in <tt>mydoc.do.txt</tt> one often just runs
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce sphinx_dir mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
and then an appropriate Sphinx directory <tt>sphinx-rootdir</tt> is made with
relevant files.

<P>
The <tt>doconce sphinx_dir</tt> command generates a script
<tt>automake-sphinx.py</tt> for compiling the Sphinx document into an HTML
document.  One can either run <tt>automake-sphinx.py</tt> or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

<P>
Te <tt>doconce sphinx_dir</tt> script copies directories named <tt>figs</tt> or <tt>figures</tt>
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, <tt>automake-sphinx.py</tt> must be edited accordingly.
Links to local files (not <tt>http:</tt> or <tt>file:</tt> URLs) must be placed
in the <tt>_static</tt> subdirectory of the Sphinx directory. The
utility <tt>doconce sphinxfix_localURLs</tt> is run to check for local
links: for each such link, say <tt>dir1/dir2/myfile.txt</tt> it replaces
the link by <tt>_static/myfile.txt</tt> and copies <tt>dir1/dir2/myfile.txt</tt>
to a local <tt>_static</tt> directory (in the same directory as the
script is run). The user must copy all <tt>_static/*</tt> files to the
<tt>_static</tt> subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the <tt>_static</tt> subdirectory of the Sphinx directory.
It may be wise to place relevant files in a <tt>_static</tt> directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

<P>
Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the <tt>conf.py</tt>
configuration file for Sphinx is edited accordingly, and a script
<tt>make-themes.sh</tt> can make HTML documents with one or more themes.
For example,
to realize the themes <tt>fenics</tt> and <tt>pyramid</tt>, one writes
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ./make-themes.sh fenics pyramid
</pre>
</blockquote>   <! -- end verbatim block -->
The resulting directories with HTML documents are <tt>_build/html_fenics</tt>
and <tt>_build/html_pyramid</tt>, respectively. Without arguments,
<tt>make-themes.sh</tt> makes all available themes (!).

<P>
If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file <tt>mydoc.do.txt</tt>.

<P>
<b>Step 1.</b> Translate Doconce into the Sphinx format:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format sphinx mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Step 2.</b> Create a Sphinx root directory
either manually or by using the interactive <tt>sphinx-quickstart</tt>
program. Here is a scripted version of the steps with the latter:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
mkdir sphinx-rootdir
sphinx-quickstart &lt;&lt;EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
</pre>
</blockquote>   <! -- end verbatim block -->
The autogenerated <tt>conf.py</tt> file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The <tt>doconce sphinx_dir</tt> generator makes an extended <tt>conv.py</tt>
file where, among other things, several useful Sphinx extensions
are included.

<P>

<P>
<b>Step 3.</b> Copy the <tt>mydoc.rst</tt> file to the Sphinx root directory:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; cp mydoc.rst sphinx-rootdir
</pre>
</blockquote>   <! -- end verbatim block -->
If you have figures in your document, the relative paths to those will
be invalid when you work with <tt>mydoc.rst</tt> in the <tt>sphinx-rootdir</tt>
directory. Either edit <tt>mydoc.rst</tt> so that figure file paths are correct,
or simply copy your figure directories to <tt>sphinx-rootdir</tt>.
Links to local files in <tt>mydoc.rst</tt> must be modified to links to
files in the <tt>_static</tt> directory, see comment above.

<P>
<b>Step 4.</b> Edit the generated <tt>index.rst</tt> file so that <tt>mydoc.rst</tt>
is included, i.e., add <tt>mydoc</tt> to the <tt>toctree</tt> section so that it becomes
<blockquote>    <!-- begin verbatim block  -->
<pre>
.. toctree::
   :maxdepth: 2

   mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
(The spaces before <tt>mydoc</tt> are important!)

<P>
<b>Step 5.</b> Generate, for instance, an HTML version of the Sphinx source:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
make clean   # remove old versions
make html
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with <tt>index.html</tt> files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

<P>
<b>Step 6.</b> View the result:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; firefox _build/html/index.html
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows <tt>!bc</tt>: <tt>cod</tt> gives Python
(<tt>code-block:: python</tt> in Sphinx syntax) and <tt>cppcod</tt> gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.

<P>

<P>
<h3>Wiki Formats</h3>
<P>
There are many different wiki formats, but Doconce only supports three:
<a href="http://code.google.com/p/support/wiki/WikiSyntax<Google Code>">Googlecode wiki</a>, , MediaWiki, and Creole Wiki. These formats are called
<tt>gwiki</tt>, <tt>mwiki</tt>, and <tt>cwiki</tt>, respectively.
Transformation from Doconce to these formats is done by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format gwiki mydoc.do.txt
Terminal&gt; doconce format mwiki mydoc.do.txt
Terminal&gt; doconce format cwiki mydoc.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The Googlecode wiki document, <tt>mydoc.gwiki</tt>, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

<P>
When the Doconce file contains figures, each figure filename must in
the <tt>.gwiki</tt> file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

<P>
From the MediaWiki format one can go to other formats with aid
of <a href="http://pediapress.com/code/">mwlib</a>. This means that one can
easily use Doconce to write <a href="http://en.wikibooks.org">Wikibooks</a>
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.

<P>

<P>
<h3>Tweaking the Doconce Output</h3>
<P>
Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
<tt>.rst</tt> file is going to be filtered to LaTeX or HTML, it cannot know
if <tt>.eps</tt> or <tt>.png</tt> is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The <tt>make.sh</tt> files in <tt>docs/manual</tt> and <tt>docs/tutorial</tt>
constitute comprehensive examples on how such scripts can be made.

<P>

<P>
<h3>Demos</h3>
<P>
The current text is generated from a Doconce format stored in the file
<blockquote>    <!-- begin verbatim block  -->
<pre>
docs/tutorial/tutorial.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
The file <tt>make.sh</tt> in the <tt>tutorial</tt> directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, <tt>tutorial.do.txt</tt> is the
starting point.  Running <tt>make.sh</tt> and studying the various generated
files and comparing them with the original <tt>tutorial.do.txt</tt> file,
gives a quick introduction to how Doconce is used in a real case.
<a href="https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html">Here</a>
is a sample of how this tutorial looks in different formats.

<P>
There is another demo in the <tt>docs/manual</tt> directory which
translates the more comprehensive documentation, <tt>manual.do.txt</tt>, to
various formats. The <tt>make.sh</tt> script runs a set of translations.

<P>
<h3>Dependencies and Installation</h3>
<P>
Doconce itself is pure Python code hosted at <a href="http://code.google.com/p/doconce"><tt>http://code.google.com/p/doconce</tt></a>.  Its installation from the
Mercurial (<tt>hg</tt>) source follows the standard procedure:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
If you make use of the <a href="http://code.google.com/p/preprocess">Preprocess</a>
preprocessor, this program must be installed:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->
A much more advanced alternative to Preprocess is
<a href="http://www.makotemplates.org">Mako</a>. Its installation is most
conveniently done by <tt>pip</tt>,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
pip install Mako
</pre>
</blockquote>   <! -- end verbatim block -->
This command requires <tt>pip</tt> to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install python-pip
</pre>
</blockquote>   <! -- end verbatim block -->
Alternatively, one can install from the <tt>pip</tt> <a href="http://pypi.python.org/pypi/pip">source code</a>.

<P>
To make LaTeX
documents (without going through the reStructuredText format) you
need <a href="http://code.google.com/p/ptex2tex">ptex2tex</a>, which is
installed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
</pre>
</blockquote>   <! -- end verbatim block -->
As seen, <tt>cp2texmf.sh</tt> copies some special stylefiles that
that <tt>ptex2tex</tt> potentially makes use of. Some more standard stylefiles
are also needed. These are installed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install texlive-latex-extra
</pre>
</blockquote>   <! -- end verbatim block -->
on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the <tt>~/texmf/tex/latex/misc</tt> directory).

<P>
The <em>minted</em> LaTeX style is offered by <tt>ptex2tex</tt> and popular among
users. This style requires the package <a href="http://pygments.org">Pygments</a>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
</pre>
</blockquote>   <! -- end verbatim block -->
If you use the minted style, you have to enable it by running
<tt>ptex2tex -DMINTED</tt> and then <tt>latex -shell-escape</tt>, see
the the section <a href="#doconce2formats">From Doconce to Other Formats</a>.

<P>
For <tt>rst</tt> output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs <a href="http://docutils.sourceforge.net">docutils</a>.
The installation can be done by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->
To use the OpenOffice suite you will typically on Debian systems install
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install unovonv libreoffice libreoffice-dmaths
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
<a href="http://code.google.com/p/rst2pdf">rst2pdf</a>. Either download the tarball
or clone the svn repository, go to the <tt>rst2pdf</tt> directory and
run <tt>sudo python setup.py install</tt>.

<P>

<P>
Output to <tt>sphinx</tt> requires of course <a href="http://sphinx.pocoo.org">Sphinx</a>,
installed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
When the output format is <tt>epydoc</tt> one needs that program too, installed
by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Finally, translation to <tt>pandoc</tt> requires the
<a href="http://johnmacfarlane.net/pandoc/">Pandoc</a> program
(written in Haskell) to be installed.
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install pandoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Remark.</b> Several of the packages above installed from source code
are also available in Debian-based system through the
<tt>apt-get install</tt> command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For <tt>svn</tt> directories, go to the directory,
run <tt>svn update</tt>, and then <tt>sudo python setup.py install</tt>. For
Mercurial (<tt>hg</tt>) directories, go to the directory, run
<tt>hg pull; hg update</tt>, and then <tt>sudo python setup.py install</tt>.
Doconce itself is frequently updated so these commands should be
run regularly.

<P>

</body>
</html>
    
************** File: tutorial.p.tex *****************
%%
%% Automatically generated ptex2tex (extended LaTeX) file
%% from Doconce source
%% http://code.google.com/p/doconce/
%%

% #ifdef BOOK
\documentclass{book}
% #else
\documentclass{article}
% #endif

\usepackage{relsize,epsfig,makeidx,amsmath,amsfonts}
\usepackage[latin1]{inputenc}
\usepackage{ptex2tex}
% #ifdef MOVIE15
\usepackage{movie15}
% #endif
% #ifdef MINTED
\usepackage{minted}  % requires latex -shell-escape (for Minted_* ptex2tex envirs)
% #endif

% #ifdef HELVETICA
% Set helvetica as the default font family:
\RequirePackage{helvet}
\renewcommand\familydefault{phv}
% #endif

\usepackage[%
colorlinks=true,
linkcolor=blue,
citecolor=black,
filecolor=blue,
urlcolor=blue]{hyperref}
%\hyperbaseurl{}   % hyperlinks are relative to this root

\newcommand{\inlinecomment}[2]{  ({\bf #1}: \emph{#2})  }
%\newcommand{\inlinecomment}[2]{}  % turn off inline comments

\makeindex

\begin{document}



% #ifndef LATEX_HEADING
% #define LATEX_HEADING
% #endif

% ----------------- Title -------------------------
% #if LATEX_HEADING == "traditional"

\title{Doconce: Document Once, Include Anywhere}

% #elif LATEX_HEADING == "titlepage"

\thispagestyle{empty}
\hbox{\ \ }
\vfill
\begin{center}
{\huge{\bfseries{Doconce: Document Once, Include Anywhere}}}

% #else

\begin{center}
{\LARGE\bf Doconce: Document Once, Include \\ [1.5mm] Anywhere}
\end{center}

% #endif



% ----------------- Author(s) -------------------------
% #if LATEX_HEADING == "traditional"
\author{Hans Petter Langtangen\footnote{Simula Research Laboratory and University of Oslo.}}

% #elif LATEX_HEADING == "titlepage"
\vspace{1.3cm}

{\Large\textsf{Hans Petter Langtangen${}^{1, 2}$}}\\ [3mm]

\ \\ [2mm]

{\large\textsf{${}^1$Simula Research Laboratory} \\ [1.5mm]}
{\large\textsf{${}^2$University of Oslo} \\ [1.5mm]}

% #else

\begin{center}
{\bf Hans Petter Langtangen${}^{1, 2}$} \\ [0mm]
\end{center}

\begin{center}
% List of all institutions:
\centerline{{\small ${}^1$Simula Research Laboratory}}
\centerline{{\small ${}^2$University of Oslo}}
\end{center}
% #endif
% ----------------- End of author(s) -------------------------



% ----------------- Date -------------------------

% #if LATEX_HEADING == "traditional"

\date{Jan 32, 2100}
\maketitle

% #elif LATEX_HEADING == "titlepage"

\ \\ [10mm]
{\large\textsf{Jan 32, 2100}}

\end{center}
\vfill
\clearpage

% #else

\begin{center}
Jan 32, 2100
\end{center}

% #endif

\begin{itemize}
 \item When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, {\LaTeX}, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?

 \item Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like \href{{http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf}}{LaTeX}, \href{{http://www.htmlcodetutorial.com/}}{HTML}, \href{{http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html}}{reStructuredText}, \href{{http://sphinx.pocoo.org/contents.html}}{Sphinx}, and \href{{http://code.google.com/p/support/wiki/WikiSyntax}}{wiki}? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?

 \item Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?
\end{itemize}

\noindent
If any of these questions are of interest, you should keep on reading.


\section{The Doconce Concept}

Doconce is two things:

\begin{enumerate}
 \item Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, {\LaTeX}, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via \code{rst2*} programs) go to XML, HTML,
    {\LaTeX}, PDF, OpenOffice, and from the latter (via \code{unoconv}) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, {\LaTeX}, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 \item Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".
\end{enumerate}

\noindent
Here are some Doconce features:

\begin{itemize}
  \item Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    {\LaTeX} and HTML.

  \item Doconce can be converted to plain \emph{untagged} text,
    often desirable for computer programs and email.

  \item Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  \item Doconce has full support for {\LaTeX} math and integrates well
    with big {\LaTeX} projects (books).

  \item Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, {\LaTeX}, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  \item Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in {\LaTeX}, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.
\end{itemize}

\noindent
Doconce was particularly written for the following sample applications:

\begin{itemize}
  \item Large books written in {\LaTeX}, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  \item Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as {\LaTeX} integrated in, e.g., a thesis.

  \item Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.
\end{itemize}

\noindent
History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, {\LaTeX}, Sphinx, and similar
formats.


\section{What Does Doconce Look Like?}

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

\begin{itemize}
  \item Bullet lists arise from lines starting with an asterisk.

  \item \emph{Emphasized words} are surrounded by asterisks.

  \item \textbf{Words in boldface} are surrounded by underscores.

  \item Words from computer code are enclosed in back quotes and
    then typeset \code{verbatim (in a monospace font)}.

  \item Section headings are recognied by equality (\code{=}) signs before
    and after the title, and the number of \code{=} signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.

  \item Paragraph headings are recognized by a double underscore
    before and after the heading.

  \item The abstract of a document starts with \emph{Abstract} as paragraph
    heading, and all text up to the next heading makes up the abstract,

  \item Blocks of computer code can easily be included by placing
    \code{!bc} (begin code) and \code{!ec} (end code) commands at separate lines
    before and after the code block.

  \item Blocks of computer code can also be imported from source files.

  \item Blocks of {\LaTeX} mathematics can easily be included by placing
    \code{!bt} (begin TeX) and \code{!et} (end TeX) commands at separate lines
    before and after the math block.

  \item There is support for both {\LaTeX} and text-like inline mathematics.

  \item Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.

  \item Invisible comments in the output format can be inserted throughout
    the text.

  \item Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).

  \item There is special support for advanced exercises features.

  \item With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.

  \item With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.
\end{itemize}

\noindent
Here is an example of some simple text written in the Doconce format:
\bccq
===== A Subsection with Sample Text =====
label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have automatically numbered items instead of bullets,

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

# lines beginning with # are comment lines
\eccq
The Doconce text above results in the following little document:

\subsection{A Subsection with Sample Text}

\label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
\textbf{boldface} words, \emph{emphasized} words, and \code{computer} words look
natural in plain text.  Lists are typeset as you would do in an email,

\begin{itemize}
  \item item 1

  \item item 2

  \item item 3
\end{itemize}

\noindent
Lists can also have numbered items instead of bullets, just use an \code{o}
(for ordered) instead of the asterisk:

\begin{enumerate}
 \item item 1

 \item item 2

 \item item 3
\end{enumerate}

\noindent
URLs with a link word are possible, as in \href{{http://folk.uio.no/hpl}}{hpl}.
If the word is URL, the URL itself becomes the link name,
as in \href{{tutorial.do.txt}}{\nolinkurl{tutorial.do.txt}}.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section~\ref{my:first:sec}.

Doconce also allows inline comments such as \inlinecomment{hpl}{here I will make
some remarks to the text} for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section~\ref{doconce2formats} for an example).

Tables are also supperted, e.g.,


\begin{quote}\begin{tabular}{rrr}
\hline
\multicolumn{1}{c}{time} & \multicolumn{1}{c}{velocity} & \multicolumn{1}{c}{acceleration} \\
\hline
0.0          & 1.4186       & -5.01        \\
2.0          & 1.376512     & 11.919       \\
4.0          & 1.1E+1       & 14.717624    \\
\hline
\end{tabular}\end{quote}

\noindent

\subsection{Mathematics and Computer Code}

Inline mathematics, such as $\nu = \sin(x)$,
allows the formula to be specified both as {\LaTeX} and as plain text.
This results in a professional {\LaTeX} typesetting, but in other formats
the text version normally looks better than raw {\LaTeX} mathematics with
backslashes. An inline formula like $\nu = \sin(x)$ is
typeset as
\bccq
$\nu = \sin(x)$|$v = sin(x)$
\eccq
The pipe symbol acts as a delimiter between {\LaTeX} code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw {\LaTeX}, inside
\code{!bt} and \code{!et} (begin tex / end tex) instructions.
The result looks like this:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
\end{eqnarray}
Of course, such blocks only looks nice in {\LaTeX}. The raw
{\LaTeX} syntax appears in all other formats (but can still be useful
for those who can read {\LaTeX} syntax).

You can have blocks of computer code, starting and ending with
\code{!bc} and \code{!ec} instructions, respectively. Such blocks look like
\bcod
from math import sin, pi
def myfunc(x):
    return sin(pi*x)

import integrate
I = integrate.trapezoidal(myfunc, 0, pi, 100)
\ecod
A code block must come after some plain sentence (at least for successful
output to \code{sphinx}, \code{rst}, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., \code{!bc xxx}
where \code{xxx} is an identifier like \code{pycod} for code snippet in Python,
\code{sys} for terminal session, etc. When Doconce is filtered to {\LaTeX},
these identifiers are used as in \code{ptex2tex} and defined in a
configuration file \code{.ptext2tex.cfg}, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):
\bccq
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
\eccq
By default, \code{pro} and \code{cod} are \code{python}, \code{sys} is \code{console},
while \code{xpro} and \code{xcod} are computer language specific for \code{x}
in \code{f} (Fortran), \code{c} (C), \code{cpp} (C++), \code{pl} (Perl), \code{m} (Matlab),
\code{sh} (Unix shells), \code{cy} (Cython), and \code{py} (Python).

% (Any sphinx code-block comment, whether inside verbatim code
% blocks or outside, yields a mapping between bc arguments
% and computer languages. In case of muliple definitions, the
% first one is used.)

One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with \code{!bc pro}, while a part of a file is copied into a \code{!bc cod}
environment. What \code{pro} and \code{cod} mean is then defined through
a \code{.ptex2tex.cfg} file for {\LaTeX} and a \code{sphinx code-blocks}
comment for Sphinx.

Another document can be included by writing \code{#include "mynote.do.txt"}
on a line starting with (another) hash sign.  Doconce documents have
extension \code{do.txt}. The \code{do} part stands for doconce, while the
trailing \code{.txt} denotes a text document so that editors gives you the
right writing enviroment for plain text.

\subsection{Macros (Newcommands), Cross-References, Index, and Bibliography}

\label{newcommands}

Doconce supports a type of macros via a LaTeX-style \emph{newcommand}
construction.  The newcommands defined in a file with name
\code{newcommand_replace.tex} are expanded when Doconce is filtered to
other formats, except for {\LaTeX} (since {\LaTeX} performs the expansion
itself).  Newcommands in files with names \code{newcommands.tex} and
\code{newcommands_keep.tex} are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands {\LaTeX} math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
\code{!bt} and \code{!et} in \code{newcommands_keep.tex} to keep them unchanged, at
least if they contribute to make the raw {\LaTeX} math text easier to
read in the formats that cannot render {\LaTeX}.  Newcommands used
elsewhere throughout the text will usually be placed in
\code{newcommands_replace.tex} and expanded by Doconce.  The definitions of
newcommands in the \code{newcommands*.tex} files \emph{must} appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the {\LaTeX} and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of {\LaTeX},
making it easy for Doconce documents to be integrated in {\LaTeX}
projects (manuals, books). For further details on functionality and
syntax we refer to the \code{doc/manual/manual.do.txt} file (see the
\href{{https://doconce.googlecode.com/hg/doc/demos/manual/index.html}}{demo page}
for various formats of this document).


% Example on including another Doconce file (using preprocess):


\section{From Doconce to Other Formats}

\label{doconce2formats}

Transformation of a Doconce document \code{mydoc.do.txt} to various other
formats applies the script \code{doconce format}:
\bsys
Terminal> doconce format format mydoc.do.txt
\esys
or just
\bsys
Terminal> doconce format format mydoc
\esys
The \code{mako} or \code{preprocess} programs are always used to preprocess the
file first, and options to \code{mako} or \code{preprocess} can be added after the
filename. For example,
\bsys
Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako
\esys
The variable \code{FORMAT} is always defined as the current format when
running \code{preprocess}. That is, in the last example, \code{FORMAT} is
defined as \code{latex}. Inside the Doconce document one can then perform
format specific actions through tests like \code{#if FORMAT == "latex"}.

Inline comments in the text are removed from the output by
\bsys
Terminal> doconce format latex mydoc --skip_inline_comments
\esys
One can also remove all such comments from the original Doconce
file by running:
\bccq
Terminal> doconce remove_inline_comments mydoc
\eccq
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

\subsection{HTML}

Making an HTML version of a Doconce file \code{mydoc.do.txt}
is performed by
\bsys
Terminal> doconce format html mydoc
\esys
The resulting file \code{mydoc.html} can be loaded into any web browser for viewing.

\subsection{Pandoc}

Output in Pandoc's extended Markdown format results from
\bsys
Terminal> doconce format pandoc mydoc
\esys
The name of the output file is \code{mydoc.mkd}.
From this format one can go to numerous other formats:
\bsys
Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
\esys
Pandoc supports \code{latex}, \code{html}, \code{odt} (OpenOffice), \code{docx} (Microsoft
Word), \code{rtf}, \code{texinfo}, to mention some. The \code{-R} option makes
Pandoc pass raw HTML or {\LaTeX} to the output format instead of ignoring it.
See the \href{{http://johnmacfarlane.net/pandoc/README.html}}{Pandoc documentation}
for the many features of the \code{pandoc} program.

Pandoc is useful to go from {\LaTeX} mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
\code{doconce format pandoc} and then translating using \code{pandoc}, or
\code{doconce format latex}, and then going from {\LaTeX} to the desired format
using \code{pandoc}.
Here is an example on the latter strategy:
\bsys
Terminal> doconce format latex mydoc
Terminal> doconce ptex2tex mydoc
Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex
\esys
When we go through \code{pandoc}, only single equations or \code{align*}
environments are well understood.

Quite some \code{doconce replace} and \code{doconce subst} edits might be needed
on the \code{.mkd} or \code{.tex} files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via {\LaTeX}.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
\bsys
Terminal> doconce format pandoc mydoc
Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
\esys
The \code{-s} option adds a proper header and footer to the \code{mydoc.html} file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

\subsection{{\LaTeX}}

Making a {\LaTeX} file \code{mydoc.tex} from \code{mydoc.do.txt} is done in two steps:
% Note: putting code blocks inside a list is not successful in many
% formats - the text may be messed up. A better choice is a paragraph
% environment, as used here.

\paragraph{Step 1.}
Filter the doconce text to a pre-LaTeX form \code{mydoc.p.tex} for
     \code{ptex2tex}:
\bsys
Terminal> doconce format latex mydoc
\esys
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files \code{newcommands.tex}, \code{newcommands_keep.tex}, or
\code{newcommands_replace.tex} (see Section~\ref{newcommands}).
If these files are present, they are included in the {\LaTeX} document
so that your commands are defined.

\paragraph{Step 2.}
Run \code{ptex2tex} (if you have it) to make a standard {\LaTeX} file,
\bsys
Terminal> ptex2tex mydoc
\esys
In case you do not have \code{ptex2tex}, you may run a (very) simplified version:
\bsys
Terminal> doconce ptex2tex mydoc
\esys

Note that Doconce generates a \code{.p.tex} file with some preprocessor macros
that can be used to steer certain properties of the {\LaTeX} document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
\bsys
Terminal> ptex2tex -DHELVETICA mydoc
\esys
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard {\LaTeX} "maketitle" heading
is also available through
\bsys
Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc
\esys
A separate titlepage can be generate by
\bsys
Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc
\esys

The \code{ptex2tex} tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in {\LaTeX}
documents. After any \code{!bc} command in the Doconce source you can
insert verbatim block styles as defined in your \code{.ptex2tex.cfg}
file, e.g., \code{!bc cod} for a code snippet, where \code{cod} is set to
a certain environment in \code{.ptex2tex.cfg} (e.g., \code{CodeIntended}).
There are about 40 styles to choose from.

Also the \code{doconce ptex2tex} command supports preprocessor directives
for processing the \code{.p.tex} file. The command allows specifications
of code environments as well. Here is an example:
\bsys
Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
\esys
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
\code{verbatim} above, which implies \code{\begin{verbatim}} and \code{\end{verbatim}}).
The value \code{minted} can be used for code environments where the
language is specified, as in \code{fpro}, where \code{minted} implies
\code{\begin{python}{fortran}}. There is a similar support for \code{ans}:
\code{cppcod=ans} imples \code{\begin{c++}} and \code{\end{c++}} using the
\code{anslistings} package.

\paragraph{Step 2b (optional).}
Edit the \code{mydoc.tex} file to your needs.
For example, you may want to substitute \code{section} by \code{section*} to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the \code{doconce replace} and \code{doconce subst}
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
\bsys
Terminal> doconce replace 'section{' 'section*{' mydoc.tex
Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex
\esys
A lot of tailored fixes to the {\LaTeX} document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the {\LaTeX} file.

\paragraph{Step 3.}
Compile \code{mydoc.tex}
and create the PDF file:
\bsys
Terminal> latex mydoc
Terminal> latex mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex mydoc
Terminal> dvipdf mydoc
\esys
If one wishes to use the \code{Minted_Python}, \code{Minted_Cpp}, etc.,
environments in \code{ptex2tex} for typesetting code (specified, e.g., in
the \code{*pro} and \code{*cod} environments in \code{.ptex2tex.cfg} or
\code{$HOME/.ptex2tex.cfg}), the \code{minted} {\LaTeX} package is needed.  This
package is included by running \code{doconce format} with the \code{-DMINTED}
option:
\bsys
Terminal> ptex2tex -DMINTED mydoc
\esys
In this case, \code{latex} must be run with the
\code{-shell-escape} option:
\bsys
Terminal> latex -shell-escape mydoc
Terminal> latex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex -shell-escape mydoc
Terminal> dvipdf mydoc
\esys

\subsection{PDFLaTeX}

Running \code{pdflatex} instead of \code{latex} follows almost the same steps,
but the start is
\bsys
Terminal> doconce format latex mydoc
\esys
Then \code{ptex2tex} is run as explained above, and finally
\bsys
Terminal> pdflatex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> pdflatex -shell-escape mydoc
\esys

\subsection{Plain ASCII Text}

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
\bsys
Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt
\esys

\subsection{reStructuredText}

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file \code{mydoc.rst}:
\bsys
Terminal> doconce format rst mydoc.do.txt
\esys
We may now produce various other formats:
\bsys
Terminal> rst2html.py  mydoc.rst > mydoc.html # html
Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice
\esys

The OpenOffice file \code{mydoc.odt} can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program \code{unovonv}
to convert between the many formats OpenOffice supports \emph{on the command line}.
Run
\bsys
Terminal> unoconv --show
\esys
to see all the formats that are supported.
For example, the following commands take
\code{mydoc.odt} to Microsoft Office Open XML format,
classic MS Word format, and PDF:
\bsys
Terminal> unoconv -f ooxml mydoc.odt
Terminal> unoconv -f doc mydoc.odt
Terminal> unoconv -f pdf mydoc.odt
\esys

\paragraph{Remark about Mathematical Typesetting.}
At the time of this writing, there is no easy way to go from Doconce
and {\LaTeX} mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by \code{latex} as
output and to a wide extent also supported by the \code{sphinx} output format.
Some links for going from {\LaTeX} to Word are listed below.

\begin{itemize}
 \item \href{{http://ubuntuforums.org/showthread.php?t=1033441}}{\nolinkurl{http://ubuntuforums.org/showthread.php?t=1033441}}

 \item \href{{http://tug.org/utilities/texconv/textopc.html}}{\nolinkurl{http://tug.org/utilities/texconv/textopc.html}}

 \item \href{{http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html}}{\nolinkurl{http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html}}
\end{itemize}

\noindent

\subsection{Sphinx}

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the \code{doconce sphinx_dir} command:
\bsys
Terminal> doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
\esys
The keywords \code{author}, \code{title}, and \code{version} are used in the headings
of the Sphinx document. By default, \code{version} is 1.0 and the script
will try to deduce authors and title from the doconce files \code{file1},
\code{file2}, etc. that together represent the whole document. Note that
none of the individual Doconce files \code{file1}, \code{file2}, etc. should
include the rest as their union makes up the whole document.
The default value of \code{dirname} is \code{sphinx-rootdir}. The \code{theme}
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is \code{'default'}).

With a single-file document in \code{mydoc.do.txt} one often just runs
\bsys
Terminal> doconce sphinx_dir mydoc
\esys
and then an appropriate Sphinx directory \code{sphinx-rootdir} is made with
relevant files.

The \code{doconce sphinx_dir} command generates a script
\code{automake-sphinx.py} for compiling the Sphinx document into an HTML
document.  One can either run \code{automake-sphinx.py} or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te \code{doconce sphinx_dir} script copies directories named \code{figs} or \code{figures}
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, \code{automake-sphinx.py} must be edited accordingly.
Links to local files (not \code{http:} or \code{file:} URLs) must be placed
in the \code{_static} subdirectory of the Sphinx directory. The
utility \code{doconce sphinxfix_localURLs} is run to check for local
links: for each such link, say \code{dir1/dir2/myfile.txt} it replaces
the link by \code{_static/myfile.txt} and copies \code{dir1/dir2/myfile.txt}
to a local \code{_static} directory (in the same directory as the
script is run). The user must copy all \code{_static/*} files to the
\code{_static} subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the \code{_static} subdirectory of the Sphinx directory.
It may be wise to place relevant files in a \code{_static} directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the \code{conf.py}
configuration file for Sphinx is edited accordingly, and a script
\code{make-themes.sh} can make HTML documents with one or more themes.
For example,
to realize the themes \code{fenics} and \code{pyramid}, one writes
\bsys
Terminal> ./make-themes.sh fenics pyramid
\esys
The resulting directories with HTML documents are \code{_build/html_fenics}
and \code{_build/html_pyramid}, respectively. Without arguments,
\code{make-themes.sh} makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file \code{mydoc.do.txt}.

\paragraph{Step 1.}
Translate Doconce into the Sphinx format:
\bsys
Terminal> doconce format sphinx mydoc
\esys

\paragraph{Step 2.}
Create a Sphinx root directory
either manually or by using the interactive \code{sphinx-quickstart}
program. Here is a scripted version of the steps with the latter:
\bsys
mkdir sphinx-rootdir
sphinx-quickstart <<EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
\esys
The autogenerated \code{conf.py} file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The \code{doconce sphinx_dir} generator makes an extended \code{conv.py}
file where, among other things, several useful Sphinx extensions
are included.


\paragraph{Step 3.}
Copy the \code{mydoc.rst} file to the Sphinx root directory:
\bsys
Terminal> cp mydoc.rst sphinx-rootdir
\esys
If you have figures in your document, the relative paths to those will
be invalid when you work with \code{mydoc.rst} in the \code{sphinx-rootdir}
directory. Either edit \code{mydoc.rst} so that figure file paths are correct,
or simply copy your figure directories to \code{sphinx-rootdir}.
Links to local files in \code{mydoc.rst} must be modified to links to
files in the \code{_static} directory, see comment above.

\paragraph{Step 4.}
Edit the generated \code{index.rst} file so that \code{mydoc.rst}
is included, i.e., add \code{mydoc} to the \code{toctree} section so that it becomes
\bccq
.. toctree::
   :maxdepth: 2

   mydoc
\eccq
(The spaces before \code{mydoc} are important!)

\paragraph{Step 5.}
Generate, for instance, an HTML version of the Sphinx source:
\bsys
make clean   # remove old versions
make html
\esys

Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with \code{index.html} files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, {\LaTeX}, PDF (via {\LaTeX}), pure text, man pages,
and Texinfo files.

\paragraph{Step 6.}
View the result:
\bsys
Terminal> firefox _build/html/index.html
\esys

Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows \code{!bc}: \code{cod} gives Python
(\code{code-block:: python} in Sphinx syntax) and \code{cppcod} gives C++, but
all such arguments can be customized both for Sphinx and {\LaTeX} output.

\subsection{Wiki Formats}

There are many different wiki formats, but Doconce only supports three:
\href{{http://code.google.com/p/support/wiki/WikiSyntax<Google Code>}}{Googlecode wiki}, , MediaWiki, and Creole Wiki. These formats are called
\code{gwiki}, \code{mwiki}, and \code{cwiki}, respectively.
Transformation from Doconce to these formats is done by
\bsys
Terminal> doconce format gwiki mydoc.do.txt
Terminal> doconce format mwiki mydoc.do.txt
Terminal> doconce format cwiki mydoc.do.txt
\esys

The Googlecode wiki document, \code{mydoc.gwiki}, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the \code{.gwiki} file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of \href{{http://pediapress.com/code/}}{mwlib}. This means that one can
easily use Doconce to write \href{{http://en.wikibooks.org}}{Wikibooks}
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard {\LaTeX} book or a Sphinx web document.

\subsection{Tweaking the Doconce Output}

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
\code{.rst} file is going to be filtered to {\LaTeX} or HTML, it cannot know
if \code{.eps} or \code{.png} is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The \code{make.sh} files in \code{docs/manual} and \code{docs/tutorial}
constitute comprehensive examples on how such scripts can be made.

\subsection{Demos}

The current text is generated from a Doconce format stored in the file
\bccq
docs/tutorial/tutorial.do.txt
\eccq
The file \code{make.sh} in the \code{tutorial} directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, \code{tutorial.do.txt} is the
starting point.  Running \code{make.sh} and studying the various generated
files and comparing them with the original \code{tutorial.do.txt} file,
gives a quick introduction to how Doconce is used in a real case.
\href{{https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html}}{Here}
is a sample of how this tutorial looks in different formats.

There is another demo in the \code{docs/manual} directory which
translates the more comprehensive documentation, \code{manual.do.txt}, to
various formats. The \code{make.sh} script runs a set of translations.

\subsection{Dependencies and Installation}

Doconce itself is pure Python code hosted at \href{{http://code.google.com/p/doconce}}{\nolinkurl{http://code.google.com/p/doconce}}.  Its installation from the
Mercurial (\code{hg}) source follows the standard procedure:
\bsys
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
\esys

If you make use of the \href{{http://code.google.com/p/preprocess}}{Preprocess}
preprocessor, this program must be installed:
\bsys
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
\esys
A much more advanced alternative to Preprocess is
\href{{http://www.makotemplates.org}}{Mako}. Its installation is most
conveniently done by \code{pip},
\bsys
pip install Mako
\esys
This command requires \code{pip} to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by
\bsys
sudo apt-get install python-pip
\esys
Alternatively, one can install from the \code{pip} \href{{http://pypi.python.org/pypi/pip}}{source code}.

To make {\LaTeX}
documents (without going through the reStructuredText format) you
need \href{{http://code.google.com/p/ptex2tex}}{ptex2tex}, which is
installed by
\bsys
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
\esys
As seen, \code{cp2texmf.sh} copies some special stylefiles that
that \code{ptex2tex} potentially makes use of. Some more standard stylefiles
are also needed. These are installed by
\bsys
sudo apt-get install texlive-latex-extra
\esys
on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the \code{~/texmf/tex/latex/misc} directory).

The \emph{minted} {\LaTeX} style is offered by \code{ptex2tex} and popular among
users. This style requires the package \href{{http://pygments.org}}{Pygments}:
\bsys
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
\esys
If you use the minted style, you have to enable it by running
\code{ptex2tex -DMINTED} and then \code{latex -shell-escape}, see
the Section~\ref{doconce2formats}.

For \code{rst} output and further transformation to {\LaTeX}, HTML, XML,
OpenOffice, and so on, one needs \href{{http://docutils.sourceforge.net}}{docutils}.
The installation can be done by
\bsys
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
\esys
To use the OpenOffice suite you will typically on Debian systems install
\bsys
sudo apt-get install unovonv libreoffice libreoffice-dmaths
\esys

There is a possibility to create PDF files from reST documents
using ReportLab instead of {\LaTeX}. The enabling software is
\href{{http://code.google.com/p/rst2pdf}}{rst2pdf}. Either download the tarball
or clone the svn repository, go to the \code{rst2pdf} directory and
run \code{sudo python setup.py install}.


Output to \code{sphinx} requires of course \href{{http://sphinx.pocoo.org}}{Sphinx},
installed by
\bsys
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
\esys

When the output format is \code{epydoc} one needs that program too, installed
by
\bsys
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
\esys

Finally, translation to \code{pandoc} requires the
\href{{http://johnmacfarlane.net/pandoc/}}{Pandoc} program
(written in Haskell) to be installed.
\bsys
sudo apt-get install pandoc
\esys

\paragraph{Remark.}
Several of the packages above installed from source code
are also available in Debian-based system through the
\code{apt-get install} command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For \code{svn} directories, go to the directory,
run \code{svn update}, and then \code{sudo python setup.py install}. For
Mercurial (\code{hg}) directories, go to the directory, run
\code{hg pull; hg update}, and then \code{sudo python setup.py install}.
Doconce itself is frequently updated so these commands should be
run regularly.

\printindex

\end{document}

************** File: tutorial.rst *****************
.. Automatically generated reST file from Doconce source
   (http://code.google.com/p/doconce/)

Doconce: Document Once, Include Anywhere
========================================

:Author: Hans Petter Langtangen

:Date: Jan 32, 2100

 * When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?

 * Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like `LaTeX <http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf>`_, `HTML <http://www.htmlcodetutorial.com/>`_, `reStructuredText <http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html>`_, `Sphinx <http://sphinx.pocoo.org/contents.html>`_, and `wiki <http://code.google.com/p/support/wiki/WikiSyntax>`_? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?

 * Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.


The Doconce Concept
===================

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via ``rst2*`` programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via ``unoconv``) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  * Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.

  * Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.

  * Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  * Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).

  * Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  * Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  * Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  * Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.

  * Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



What Does Doconce Look Like?
============================

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  * Bullet lists arise from lines starting with an asterisk.

  * *Emphasized words* are surrounded by asterisks.

  * **Words in boldface** are surrounded by underscores.

  * Words from computer code are enclosed in back quotes and
    then typeset ``verbatim (in a monospace font)``.

  * Section headings are recognied by equality (``=``) signs before
    and after the title, and the number of ``=`` signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.

  * Paragraph headings are recognized by a double underscore
    before and after the heading.

  * The abstract of a document starts with *Abstract* as paragraph
    heading, and all text up to the next heading makes up the abstract,

  * Blocks of computer code can easily be included by placing
    ``!bc`` (begin code) and ``!ec`` (end code) commands at separate lines
    before and after the code block.

  * Blocks of computer code can also be imported from source files.

  * Blocks of LaTeX mathematics can easily be included by placing
    ``!bt`` (begin TeX) and ``!et`` (end TeX) commands at separate lines
    before and after the math block.

  * There is support for both LaTeX and text-like inline mathematics.

  * Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.

  * Invisible comments in the output format can be inserted throughout
    the text.

  * Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).

  * There is special support for advanced exercises features.

  * With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.

  * With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format::


        ===== A Subsection with Sample Text =====
        label{my:first:sec}
        
        Ordinary text looks like ordinary text, and the tags used for
        _boldface_ words, *emphasized* words, and `computer` words look
        natural in plain text.  Lists are typeset as you would do in an email,
        
          * item 1
          * item 2
          * item 3
        
        Lists can also have automatically numbered items instead of bullets,
        
          o item 1
          o item 2
          o item 3
        
        URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
        If the word is URL, the URL itself becomes the link name,
        as in "URL":"tutorial.do.txt".
        
        References to sections may use logical names as labels (e.g., a
        "label" command right after the section title), as in the reference to
        Section ref{my:first:sec}.
        
        Doconce also allows inline comments such as [hpl: here I will make
        some remarks to the text] for allowing authors to make notes. Inline
        comments can be removed from the output by a command-line argument
        (see Section ref{doconce2formats} for an example).
        
        Tables are also supperted, e.g.,
        
          |--------------------------------|
          |time  | velocity | acceleration |
          |---r-------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        
        # lines beginning with # are comment lines

The Doconce text above results in the following little document:

.. _my:first:sec:

A Subsection with Sample Text
-----------------------------

Ordinary text looks like ordinary text, and the tags used for
**boldface** words, *emphasized* words, and ``computer`` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1

  * item 2

  * item 3

Lists can also have numbered items instead of bullets, just use an ``o``
(for ordered) instead of the asterisk:

 1. item 1

 2. item 2

 3. item 3

URLs with a link word are possible, as in `hpl <http://folk.uio.no/hpl>`_.
If the word is URL, the URL itself becomes the link name,
as in `<tutorial.do.txt>`_.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section `A Subsection with Sample Text`_.

Doconce also allows inline comments such as (**hpl**: here I will make
some remarks to the text) for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section `From Doconce to Other Formats`_ for an example).

Tables are also supperted, e.g.,

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  
============  ============  ============  

Mathematics and Computer Code
-----------------------------

Inline mathematics, such as v = sin(x),
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like v = sin(x) is
typeset as::


        $\nu = \sin(x)$|$v = sin(x)$

The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
``!bt`` and ``!et`` (begin tex / end tex) instructions.
The result looks like this::

        \begin{eqnarray}
        {\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
        {\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
        \end{eqnarray}

Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
``!bc`` and ``!ec`` instructions, respectively. Such blocks look like::


        from math import sin, pi
        def myfunc(x):
            return sin(pi*x)
        
        import integrate
        I = integrate.trapezoidal(myfunc, 0, pi, 100)

A code block must come after some plain sentence (at least for successful
output to ``sphinx``, ``rst``, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., ``!bc xxx``
where ``xxx`` is an identifier like ``pycod`` for code snippet in Python,
``sys`` for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in ``ptex2tex`` and defined in a
configuration file ``.ptext2tex.cfg``, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments)::


        # sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

By default, ``pro`` and ``cod`` are ``python``, ``sys`` is ``console``,
while ``xpro`` and ``xcod`` are computer language specific for ``x``
in ``f`` (Fortran), ``c`` (C), ``cpp`` (C++), ``pl`` (Perl), ``m`` (Matlab),
``sh`` (Unix shells), ``cy`` (Cython), and ``py`` (Python).

.. (Any sphinx code-block comment, whether inside verbatim code

.. blocks or outside, yields a mapping between bc arguments

.. and computer languages. In case of muliple definitions, the

.. first one is used.)


One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with ``!bc pro``, while a part of a file is copied into a ``!bc cod``
environment. What ``pro`` and ``cod`` mean is then defined through
a ``.ptex2tex.cfg`` file for LaTeX and a ``sphinx code-blocks``
comment for Sphinx.

Another document can be included by writing ``#include "mynote.do.txt"``
on a line starting with (another) hash sign.  Doconce documents have
extension ``do.txt``. The ``do`` part stands for doconce, while the
trailing ``.txt`` denotes a text document so that editors gives you the
right writing enviroment for plain text.


.. _newcommands:

Macros (Newcommands), Cross-References, Index, and Bibliography
---------------------------------------------------------------

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
``newcommand_replace.tex`` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names ``newcommands.tex`` and
``newcommands_keep.tex`` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
``!bt`` and ``!et`` in ``newcommands_keep.tex`` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
``newcommands_replace.tex`` and expanded by Doconce.  The definitions of
newcommands in the ``newcommands*.tex`` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the ``doc/manual/manual.do.txt`` file (see the
`demo page <https://doconce.googlecode.com/hg/doc/demos/manual/index.html>`_
for various formats of this document).


.. Example on including another Doconce file (using preprocess):



.. _doconce2formats:

From Doconce to Other Formats
=============================

Transformation of a Doconce document ``mydoc.do.txt`` to various other
formats applies the script ``doconce format``::


        Terminal> doconce format format mydoc.do.txt

or just::


        Terminal> doconce format format mydoc

The ``mako`` or ``preprocess`` programs are always used to preprocess the
file first, and options to ``mako`` or ``preprocess`` can be added after the
filename. For example::


        Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
        Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako

The variable ``FORMAT`` is always defined as the current format when
running ``preprocess``. That is, in the last example, ``FORMAT`` is
defined as ``latex``. Inside the Doconce document one can then perform
format specific actions through tests like ``#if FORMAT == "latex"``.

Inline comments in the text are removed from the output by::


        Terminal> doconce format latex mydoc --skip_inline_comments

One can also remove all such comments from the original Doconce
file by running::


        Terminal> doconce remove_inline_comments mydoc

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


HTML
----

Making an HTML version of a Doconce file ``mydoc.do.txt``
is performed by::


        Terminal> doconce format html mydoc

The resulting file ``mydoc.html`` can be loaded into any web browser for viewing.

Pandoc
------

Output in Pandoc's extended Markdown format results from::


        Terminal> doconce format pandoc mydoc

The name of the output file is ``mydoc.mkd``.
From this format one can go to numerous other formats::


        Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd

Pandoc supports ``latex``, ``html``, ``odt`` (OpenOffice), ``docx`` (Microsoft
Word), ``rtf``, ``texinfo``, to mention some. The ``-R`` option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the `Pandoc documentation <http://johnmacfarlane.net/pandoc/README.html>`_
for the many features of the ``pandoc`` program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
``doconce format pandoc`` and then translating using ``pandoc``, or
``doconce format latex``, and then going from LaTeX to the desired format
using ``pandoc``.
Here is an example on the latter strategy::


        Terminal> doconce format latex mydoc
        Terminal> doconce ptex2tex mydoc
        Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex

When we go through ``pandoc``, only single equations or ``align*``
environments are well understood.

Quite some ``doconce replace`` and ``doconce subst`` edits might be needed
on the ``.mkd`` or ``.tex`` files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax::


        Terminal> doconce format pandoc mydoc
        Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd

The ``-s`` option adds a proper header and footer to the ``mydoc.html`` file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


LaTeX
-----

Making a LaTeX file ``mydoc.tex`` from ``mydoc.do.txt`` is done in two steps:
.. Note: putting code blocks inside a list is not successful in many

.. formats - the text may be messed up. A better choice is a paragraph

.. environment, as used here.


*Step 1.* Filter the doconce text to a pre-LaTeX form ``mydoc.p.tex`` for
     ``ptex2tex``::


        Terminal> doconce format latex mydoc

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files ``newcommands.tex``, ``newcommands_keep.tex``, or
``newcommands_replace.tex`` (see the section `Macros (Newcommands), Cross-References, Index, and Bibliography`_).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run ``ptex2tex`` (if you have it) to make a standard LaTeX file::


        Terminal> ptex2tex mydoc

In case you do not have ``ptex2tex``, you may run a (very) simplified version::


        Terminal> doconce ptex2tex mydoc


Note that Doconce generates a ``.p.tex`` file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run::


        Terminal> ptex2tex -DHELVETICA mydoc

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through::


        Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc

A separate titlepage can be generate by::


        Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc


The ``ptex2tex`` tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any ``!bc`` command in the Doconce source you can
insert verbatim block styles as defined in your ``.ptex2tex.cfg``
file, e.g., ``!bc cod`` for a code snippet, where ``cod`` is set to
a certain environment in ``.ptex2tex.cfg`` (e.g., ``CodeIntended``).
There are about 40 styles to choose from.

Also the ``doconce ptex2tex`` command supports preprocessor directives
for processing the ``.p.tex`` file. The command allows specifications
of code environments as well. Here is an example::


        Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
                  cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
                  fpro=minted fcod=minted sys=verbatim

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
``verbatim`` above, which implies ``\begin{verbatim}`` and ``\end{verbatim}``).
The value ``minted`` can be used for code environments where the
language is specified, as in ``fpro``, where ``minted`` implies
``\begin{python}{fortran}``. There is a similar support for ``ans``:
``cppcod=ans`` imples ``\begin{c++}`` and ``\end{c++}`` using the
``anslistings`` package.

*Step 2b (optional).* Edit the ``mydoc.tex`` file to your needs.
For example, you may want to substitute ``section`` by ``section*`` to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the ``doconce replace`` and ``doconce subst``
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples::


        Terminal> doconce replace 'section{' 'section*{' mydoc.tex
        Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
                  'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile ``mydoc.tex``
and create the PDF file::


        Terminal> latex mydoc
        Terminal> latex mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex mydoc
        Terminal> dvipdf mydoc

If one wishes to use the ``Minted_Python``, ``Minted_Cpp``, etc.,
environments in ``ptex2tex`` for typesetting code (specified, e.g., in
the ``*pro`` and ``*cod`` environments in ``.ptex2tex.cfg`` or
``$HOME/.ptex2tex.cfg``), the ``minted`` LaTeX package is needed.  This
package is included by running ``doconce format`` with the ``-DMINTED``
option::


        Terminal> ptex2tex -DMINTED mydoc

In this case, ``latex`` must be run with the
``-shell-escape`` option::


        Terminal> latex -shell-escape mydoc
        Terminal> latex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex -shell-escape mydoc
        Terminal> dvipdf mydoc



PDFLaTeX
--------

Running ``pdflatex`` instead of ``latex`` follows almost the same steps,
but the start is::


        Terminal> doconce format latex mydoc

Then ``ptex2tex`` is run as explained above, and finally::


        Terminal> pdflatex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> pdflatex -shell-escape mydoc


Plain ASCII Text
----------------

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code::


        Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt


reStructuredText
----------------

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file ``mydoc.rst``::


        Terminal> doconce format rst mydoc.do.txt

We may now produce various other formats::


        Terminal> rst2html.py  mydoc.rst > mydoc.html # html
        Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
        Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
        Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice


The OpenOffice file ``mydoc.odt`` can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program ``unovonv``
to convert between the many formats OpenOffice supports *on the command line*.
Run::


        Terminal> unoconv --show

to see all the formats that are supported.
For example, the following commands take
``mydoc.odt`` to Microsoft Office Open XML format,
classic MS Word format, and PDF::


        Terminal> unoconv -f ooxml mydoc.odt
        Terminal> unoconv -f doc mydoc.odt
        Terminal> unoconv -f pdf mydoc.odt


*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by ``latex`` as
output and to a wide extent also supported by the ``sphinx`` output format.
Some links for going from LaTeX to Word are listed below.

 * `<http://ubuntuforums.org/showthread.php?t=1033441>`_

 * `<http://tug.org/utilities/texconv/textopc.html>`_

 * `<http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html>`_

Sphinx
------

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the ``doconce sphinx_dir`` command::


        Terminal> doconce sphinx_dir author="authors' names" \
                  title="some title" version=1.0 dirname=sphinxdir \
                  theme=mytheme file1 file2 file3 ...

The keywords ``author``, ``title``, and ``version`` are used in the headings
of the Sphinx document. By default, ``version`` is 1.0 and the script
will try to deduce authors and title from the doconce files ``file1``,
``file2``, etc. that together represent the whole document. Note that
none of the individual Doconce files ``file1``, ``file2``, etc. should
include the rest as their union makes up the whole document.
The default value of ``dirname`` is ``sphinx-rootdir``. The ``theme``
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is ``'default'``).

With a single-file document in ``mydoc.do.txt`` one often just runs::


        Terminal> doconce sphinx_dir mydoc

and then an appropriate Sphinx directory ``sphinx-rootdir`` is made with
relevant files.

The ``doconce sphinx_dir`` command generates a script
``automake-sphinx.py`` for compiling the Sphinx document into an HTML
document.  One can either run ``automake-sphinx.py`` or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te ``doconce sphinx_dir`` script copies directories named ``figs`` or ``figures``
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, ``automake-sphinx.py`` must be edited accordingly.
Links to local files (not ``http:`` or ``file:`` URLs) must be placed
in the ``_static`` subdirectory of the Sphinx directory. The
utility ``doconce sphinxfix_localURLs`` is run to check for local
links: for each such link, say ``dir1/dir2/myfile.txt`` it replaces
the link by ``_static/myfile.txt`` and copies ``dir1/dir2/myfile.txt``
to a local ``_static`` directory (in the same directory as the
script is run). The user must copy all ``_static/*`` files to the
``_static`` subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the ``_static`` subdirectory of the Sphinx directory.
It may be wise to place relevant files in a ``_static`` directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the ``conf.py``
configuration file for Sphinx is edited accordingly, and a script
``make-themes.sh`` can make HTML documents with one or more themes.
For example,
to realize the themes ``fenics`` and ``pyramid``, one writes::


        Terminal> ./make-themes.sh fenics pyramid

The resulting directories with HTML documents are ``_build/html_fenics``
and ``_build/html_pyramid``, respectively. Without arguments,
``make-themes.sh`` makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file ``mydoc.do.txt``.

*Step 1.* Translate Doconce into the Sphinx format::


        Terminal> doconce format sphinx mydoc


*Step 2.* Create a Sphinx root directory
either manually or by using the interactive ``sphinx-quickstart``
program. Here is a scripted version of the steps with the latter::


        mkdir sphinx-rootdir
        sphinx-quickstart <<EOF
        sphinx-rootdir
        n
        _
        Name of My Sphinx Document
        Author
        version
        version
        .rst
        index
        n
        y
        n
        n
        n
        n
        y
        n
        n
        y
        y
        y
        EOF

The autogenerated ``conf.py`` file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The ``doconce sphinx_dir`` generator makes an extended ``conv.py``
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the ``mydoc.rst`` file to the Sphinx root directory::


        Terminal> cp mydoc.rst sphinx-rootdir

If you have figures in your document, the relative paths to those will
be invalid when you work with ``mydoc.rst`` in the ``sphinx-rootdir``
directory. Either edit ``mydoc.rst`` so that figure file paths are correct,
or simply copy your figure directories to ``sphinx-rootdir``.
Links to local files in ``mydoc.rst`` must be modified to links to
files in the ``_static`` directory, see comment above.

*Step 4.* Edit the generated ``index.rst`` file so that ``mydoc.rst``
is included, i.e., add ``mydoc`` to the ``toctree`` section so that it becomes::


        .. toctree::
           :maxdepth: 2
        
           mydoc

(The spaces before ``mydoc`` are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source::


        make clean   # remove old versions
        make html


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with ``index.html`` files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result::


        Terminal> firefox _build/html/index.html


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows ``!bc``: ``cod`` gives Python
(``code-block:: python`` in Sphinx syntax) and ``cppcod`` gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


Wiki Formats
------------

There are many different wiki formats, but Doconce only supports three:
`Googlecode wiki <http://code.google.com/p/support/wiki/WikiSyntax<Google Code>>`_, , MediaWiki, and Creole Wiki. These formats are called
``gwiki``, ``mwiki``, and ``cwiki``, respectively.
Transformation from Doconce to these formats is done by::


        Terminal> doconce format gwiki mydoc.do.txt
        Terminal> doconce format mwiki mydoc.do.txt
        Terminal> doconce format cwiki mydoc.do.txt


The Googlecode wiki document, ``mydoc.gwiki``, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the ``.gwiki`` file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of `mwlib <http://pediapress.com/code/>`_. This means that one can
easily use Doconce to write `Wikibooks <http://en.wikibooks.org>`_
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


Tweaking the Doconce Output
---------------------------

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
``.rst`` file is going to be filtered to LaTeX or HTML, it cannot know
if ``.eps`` or ``.png`` is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The ``make.sh`` files in ``docs/manual`` and ``docs/tutorial``
constitute comprehensive examples on how such scripts can be made.


Demos
-----

The current text is generated from a Doconce format stored in the file::


        docs/tutorial/tutorial.do.txt

The file ``make.sh`` in the ``tutorial`` directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, ``tutorial.do.txt`` is the
starting point.  Running ``make.sh`` and studying the various generated
files and comparing them with the original ``tutorial.do.txt`` file,
gives a quick introduction to how Doconce is used in a real case.
`Here <https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html>`_
is a sample of how this tutorial looks in different formats.

There is another demo in the ``docs/manual`` directory which
translates the more comprehensive documentation, ``manual.do.txt``, to
various formats. The ``make.sh`` script runs a set of translations.

Dependencies and Installation
-----------------------------

Doconce itself is pure Python code hosted at `<http://code.google.com/p/doconce>`_.  Its installation from the
Mercurial (``hg``) source follows the standard procedure::


        # Doconce
        hg clone https://doconce.googlecode.com/hg/ doconce
        cd doconce
        sudo python setup.py install
        cd ..


If you make use of the `Preprocess <http://code.google.com/p/preprocess>`_
preprocessor, this program must be installed::


        svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
        cd preprocess
        cd doconce
        sudo python setup.py install
        cd ..

A much more advanced alternative to Preprocess is
`Mako <http://www.makotemplates.org>`_. Its installation is most
conveniently done by ``pip``::


        pip install Mako

This command requires ``pip`` to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by::


        sudo apt-get install python-pip

Alternatively, one can install from the ``pip`` `source code <http://pypi.python.org/pypi/pip>`_.

To make LaTeX
documents (without going through the reStructuredText format) you
need `ptex2tex <http://code.google.com/p/ptex2tex>`_, which is
installed by::


        svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
        cd ptex2tex
        sudo python setup.py install
        cd latex
        sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
        cd ../..

As seen, ``cp2texmf.sh`` copies some special stylefiles that
that ``ptex2tex`` potentially makes use of. Some more standard stylefiles
are also needed. These are installed by::


        sudo apt-get install texlive-latex-extra

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the ``~/texmf/tex/latex/misc`` directory).

The *minted* LaTeX style is offered by ``ptex2tex`` and popular among
users. This style requires the package `Pygments <http://pygments.org>`_::


        hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
        cd pygments
        sudo python setup.py install

If you use the minted style, you have to enable it by running
``ptex2tex -DMINTED`` and then ``latex -shell-escape``, see
the the section `From Doconce to Other Formats`_.

For ``rst`` output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs `docutils <http://docutils.sourceforge.net>`_.
The installation can be done by::


        svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
        cd docutils
        sudo python setup.py install
        cd ..

To use the OpenOffice suite you will typically on Debian systems install::


        sudo apt-get install unovonv libreoffice libreoffice-dmaths


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
`rst2pdf <http://code.google.com/p/rst2pdf>`_. Either download the tarball
or clone the svn repository, go to the ``rst2pdf`` directory and
run ``sudo python setup.py install``.


Output to ``sphinx`` requires of course `Sphinx <http://sphinx.pocoo.org>`_,
installed by::


        hg clone https://bitbucket.org/birkenfeld/sphinx
        cd sphinx
        sudo python setup.py install
        cd ..


When the output format is ``epydoc`` one needs that program too, installed
by::


        svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
        cd epydoc
        sudo make install
        cd ..


Finally, translation to ``pandoc`` requires the
`Pandoc <http://johnmacfarlane.net/pandoc/>`_ program
(written in Haskell) to be installed::


        sudo apt-get install pandoc


*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
``apt-get install`` command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For ``svn`` directories, go to the directory,
run ``svn update``, and then ``sudo python setup.py install``. For
Mercurial (``hg``) directories, go to the directory, run
``hg pull; hg update``, and then ``sudo python setup.py install``.
Doconce itself is frequently updated so these commands should be
run regularly.
************** File: tutorial.sphinx.rst *****************
.. Automatically generated reST file from Doconce source
   (http://code.google.com/p/doconce/)

Doconce: Document Once, Include Anywhere
========================================

:Author: Hans Petter Langtangen

:Date: Jan 32, 2100

 * When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?

 * Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like `LaTeX <http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf>`_, `HTML <http://www.htmlcodetutorial.com/>`_, `reStructuredText <http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html>`_, `Sphinx <http://sphinx.pocoo.org/contents.html>`_, and `wiki <http://code.google.com/p/support/wiki/WikiSyntax>`_? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?

 * Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.


The Doconce Concept
===================

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via ``rst2*`` programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via ``unoconv``) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  * Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.

  * Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.

  * Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  * Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).

  * Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  * Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  * Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  * Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.

  * Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



What Does Doconce Look Like?
============================

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  * Bullet lists arise from lines starting with an asterisk.

  * *Emphasized words* are surrounded by asterisks.

  * **Words in boldface** are surrounded by underscores.

  * Words from computer code are enclosed in back quotes and
    then typeset ``verbatim (in a monospace font)``.

  * Section headings are recognied by equality (``=``) signs before
    and after the title, and the number of ``=`` signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.

  * Paragraph headings are recognized by a double underscore
    before and after the heading.

  * The abstract of a document starts with *Abstract* as paragraph
    heading, and all text up to the next heading makes up the abstract,

  * Blocks of computer code can easily be included by placing
    ``!bc`` (begin code) and ``!ec`` (end code) commands at separate lines
    before and after the code block.

  * Blocks of computer code can also be imported from source files.

  * Blocks of LaTeX mathematics can easily be included by placing
    ``!bt`` (begin TeX) and ``!et`` (end TeX) commands at separate lines
    before and after the math block.

  * There is support for both LaTeX and text-like inline mathematics.

  * Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.

  * Invisible comments in the output format can be inserted throughout
    the text.

  * Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).

  * There is special support for advanced exercises features.

  * With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.

  * With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format:

.. code-block:: py


        ===== A Subsection with Sample Text =====
        label{my:first:sec}
        
        Ordinary text looks like ordinary text, and the tags used for
        _boldface_ words, *emphasized* words, and `computer` words look
        natural in plain text.  Lists are typeset as you would do in an email,
        
          * item 1
          * item 2
          * item 3
        
        Lists can also have automatically numbered items instead of bullets,
        
          o item 1
          o item 2
          o item 3
        
        URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
        If the word is URL, the URL itself becomes the link name,
        as in "URL":"tutorial.do.txt".
        
        References to sections may use logical names as labels (e.g., a
        "label" command right after the section title), as in the reference to
        Section ref{my:first:sec}.
        
        Doconce also allows inline comments such as [hpl: here I will make
        some remarks to the text] for allowing authors to make notes. Inline
        comments can be removed from the output by a command-line argument
        (see Section ref{doconce2formats} for an example).
        
        Tables are also supperted, e.g.,
        
          |--------------------------------|
          |time  | velocity | acceleration |
          |---r-------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        
        # lines beginning with # are comment lines

The Doconce text above results in the following little document:

.. _my:first:sec:

A Subsection with Sample Text
-----------------------------

Ordinary text looks like ordinary text, and the tags used for
**boldface** words, *emphasized* words, and ``computer`` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1

  * item 2

  * item 3

Lists can also have numbered items instead of bullets, just use an ``o``
(for ordered) instead of the asterisk:

 1. item 1

 2. item 2

 3. item 3

URLs with a link word are possible, as in `hpl <http://folk.uio.no/hpl>`_.
If the word is URL, the URL itself becomes the link name,
as in `<tutorial.do.txt>`_.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section :ref:`my:first:sec`.

Doconce also allows inline comments such as (**hpl**: here I will make
some remarks to the text) for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section :ref:`doconce2formats` for an example).

Tables are also supperted, e.g.,

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  
============  ============  ============  

Mathematics and Computer Code
-----------------------------

Inline mathematics, such as :math:`\nu = \sin(x)`,
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like :math:`\nu = \sin(x)` is
typeset as

.. code-block:: py


        $\nu = \sin(x)$|$v = sin(x)$

The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
``!bt`` and ``!et`` (begin tex / end tex) instructions.
The result looks like this:

.. math::
   :label: myeq1
        
        {\partial u\over\partial t}  &=  \nabla^2 u + f, \\
        {\partial v\over\partial t}  &=  \nabla\cdot(q(u)\nabla v) + g
        

Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
``!bc`` and ``!ec`` instructions, respectively. Such blocks look like

.. code-block:: fortran

        from math import sin, pi
        def myfunc(x):
            return sin(pi*x)
        
        import integrate
        I = integrate.trapezoidal(myfunc, 0, pi, 100)

A code block must come after some plain sentence (at least for successful
output to ``sphinx``, ``rst``, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., ``!bc xxx``
where ``xxx`` is an identifier like ``pycod`` for code snippet in Python,
``sys`` for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in ``ptex2tex`` and defined in a
configuration file ``.ptext2tex.cfg``, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):

.. code-block:: py


        # sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

By default, ``pro`` and ``cod`` are ``python``, ``sys`` is ``console``,
while ``xpro`` and ``xcod`` are computer language specific for ``x``
in ``f`` (Fortran), ``c`` (C), ``cpp`` (C++), ``pl`` (Perl), ``m`` (Matlab),
``sh`` (Unix shells), ``cy`` (Cython), and ``py`` (Python).

.. (Any sphinx code-block comment, whether inside verbatim code

.. blocks or outside, yields a mapping between bc arguments

.. and computer languages. In case of muliple definitions, the

.. first one is used.)


One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with ``!bc pro``, while a part of a file is copied into a ``!bc cod``
environment. What ``pro`` and ``cod`` mean is then defined through
a ``.ptex2tex.cfg`` file for LaTeX and a ``sphinx code-blocks``
comment for Sphinx.

Another document can be included by writing ``#include "mynote.do.txt"``
on a line starting with (another) hash sign.  Doconce documents have
extension ``do.txt``. The ``do`` part stands for doconce, while the
trailing ``.txt`` denotes a text document so that editors gives you the
right writing enviroment for plain text.


.. _newcommands:

Macros (Newcommands), Cross-References, Index, and Bibliography
---------------------------------------------------------------

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
``newcommand_replace.tex`` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names ``newcommands.tex`` and
``newcommands_keep.tex`` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
``!bt`` and ``!et`` in ``newcommands_keep.tex`` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
``newcommands_replace.tex`` and expanded by Doconce.  The definitions of
newcommands in the ``newcommands*.tex`` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the ``doc/manual/manual.do.txt`` file (see the
`demo page <https://doconce.googlecode.com/hg/doc/demos/manual/index.html>`_
for various formats of this document).


.. Example on including another Doconce file (using preprocess):



.. _doconce2formats:

From Doconce to Other Formats
=============================

Transformation of a Doconce document ``mydoc.do.txt`` to various other
formats applies the script ``doconce format``:

.. code-block:: console

        Terminal> doconce format format mydoc.do.txt

or just

.. code-block:: console

        Terminal> doconce format format mydoc

The ``mako`` or ``preprocess`` programs are always used to preprocess the
file first, and options to ``mako`` or ``preprocess`` can be added after the
filename. For example,

.. code-block:: console

        Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
        Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako

The variable ``FORMAT`` is always defined as the current format when
running ``preprocess``. That is, in the last example, ``FORMAT`` is
defined as ``latex``. Inside the Doconce document one can then perform
format specific actions through tests like ``#if FORMAT == "latex"``.

Inline comments in the text are removed from the output by

.. code-block:: console

        Terminal> doconce format latex mydoc --skip_inline_comments

One can also remove all such comments from the original Doconce
file by running:

.. code-block:: py


        Terminal> doconce remove_inline_comments mydoc

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


HTML
----

Making an HTML version of a Doconce file ``mydoc.do.txt``
is performed by

.. code-block:: console

        Terminal> doconce format html mydoc

The resulting file ``mydoc.html`` can be loaded into any web browser for viewing.

Pandoc
------

Output in Pandoc's extended Markdown format results from

.. code-block:: console

        Terminal> doconce format pandoc mydoc

The name of the output file is ``mydoc.mkd``.
From this format one can go to numerous other formats:

.. code-block:: console

        Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd

Pandoc supports ``latex``, ``html``, ``odt`` (OpenOffice), ``docx`` (Microsoft
Word), ``rtf``, ``texinfo``, to mention some. The ``-R`` option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the `Pandoc documentation <http://johnmacfarlane.net/pandoc/README.html>`_
for the many features of the ``pandoc`` program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
``doconce format pandoc`` and then translating using ``pandoc``, or
``doconce format latex``, and then going from LaTeX to the desired format
using ``pandoc``.
Here is an example on the latter strategy:

.. code-block:: console

        Terminal> doconce format latex mydoc
        Terminal> doconce ptex2tex mydoc
        Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex

When we go through ``pandoc``, only single equations or ``align*``
environments are well understood.

Quite some ``doconce replace`` and ``doconce subst`` edits might be needed
on the ``.mkd`` or ``.tex`` files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:

.. code-block:: console

        Terminal> doconce format pandoc mydoc
        Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd

The ``-s`` option adds a proper header and footer to the ``mydoc.html`` file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


LaTeX
-----

Making a LaTeX file ``mydoc.tex`` from ``mydoc.do.txt`` is done in two steps:
.. Note: putting code blocks inside a list is not successful in many

.. formats - the text may be messed up. A better choice is a paragraph

.. environment, as used here.


*Step 1.* Filter the doconce text to a pre-LaTeX form ``mydoc.p.tex`` for
     ``ptex2tex``:

.. code-block:: console

        Terminal> doconce format latex mydoc

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files ``newcommands.tex``, ``newcommands_keep.tex``, or
``newcommands_replace.tex`` (see the section :ref:`newcommands`).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run ``ptex2tex`` (if you have it) to make a standard LaTeX file,

.. code-block:: console

        Terminal> ptex2tex mydoc

In case you do not have ``ptex2tex``, you may run a (very) simplified version:

.. code-block:: console

        Terminal> doconce ptex2tex mydoc


Note that Doconce generates a ``.p.tex`` file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run

.. code-block:: console

        Terminal> ptex2tex -DHELVETICA mydoc

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through

.. code-block:: console

        Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc

A separate titlepage can be generate by

.. code-block:: console

        Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc


The ``ptex2tex`` tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any ``!bc`` command in the Doconce source you can
insert verbatim block styles as defined in your ``.ptex2tex.cfg``
file, e.g., ``!bc cod`` for a code snippet, where ``cod`` is set to
a certain environment in ``.ptex2tex.cfg`` (e.g., ``CodeIntended``).
There are about 40 styles to choose from.

Also the ``doconce ptex2tex`` command supports preprocessor directives
for processing the ``.p.tex`` file. The command allows specifications
of code environments as well. Here is an example:

.. code-block:: console

        Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
                  cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
                  fpro=minted fcod=minted sys=verbatim

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
``verbatim`` above, which implies ``\begin{verbatim}`` and ``\end{verbatim}``).
The value ``minted`` can be used for code environments where the
language is specified, as in ``fpro``, where ``minted`` implies
``\begin{python}{fortran}``. There is a similar support for ``ans``:
``cppcod=ans`` imples ``\begin{c++}`` and ``\end{c++}`` using the
``anslistings`` package.

*Step 2b (optional).* Edit the ``mydoc.tex`` file to your needs.
For example, you may want to substitute ``section`` by ``section*`` to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the ``doconce replace`` and ``doconce subst``
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:

.. code-block:: console

        Terminal> doconce replace 'section{' 'section*{' mydoc.tex
        Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
                  'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile ``mydoc.tex``
and create the PDF file:

.. code-block:: console

        Terminal> latex mydoc
        Terminal> latex mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex mydoc
        Terminal> dvipdf mydoc

If one wishes to use the ``Minted_Python``, ``Minted_Cpp``, etc.,
environments in ``ptex2tex`` for typesetting code (specified, e.g., in
the ``*pro`` and ``*cod`` environments in ``.ptex2tex.cfg`` or
``$HOME/.ptex2tex.cfg``), the ``minted`` LaTeX package is needed.  This
package is included by running ``doconce format`` with the ``-DMINTED``
option:

.. code-block:: console

        Terminal> ptex2tex -DMINTED mydoc

In this case, ``latex`` must be run with the
``-shell-escape`` option:

.. code-block:: console

        Terminal> latex -shell-escape mydoc
        Terminal> latex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex -shell-escape mydoc
        Terminal> dvipdf mydoc



PDFLaTeX
--------

Running ``pdflatex`` instead of ``latex`` follows almost the same steps,
but the start is

.. code-block:: console

        Terminal> doconce format latex mydoc

Then ``ptex2tex`` is run as explained above, and finally

.. code-block:: console

        Terminal> pdflatex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> pdflatex -shell-escape mydoc


Plain ASCII Text
----------------

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:

.. code-block:: console

        Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt


reStructuredText
----------------

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file ``mydoc.rst``:

.. code-block:: console

        Terminal> doconce format rst mydoc.do.txt

We may now produce various other formats:

.. code-block:: console

        Terminal> rst2html.py  mydoc.rst > mydoc.html # html
        Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
        Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
        Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice


The OpenOffice file ``mydoc.odt`` can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program ``unovonv``
to convert between the many formats OpenOffice supports *on the command line*.
Run

.. code-block:: console

        Terminal> unoconv --show

to see all the formats that are supported.
For example, the following commands take
``mydoc.odt`` to Microsoft Office Open XML format,
classic MS Word format, and PDF:

.. code-block:: console

        Terminal> unoconv -f ooxml mydoc.odt
        Terminal> unoconv -f doc mydoc.odt
        Terminal> unoconv -f pdf mydoc.odt


*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by ``latex`` as
output and to a wide extent also supported by the ``sphinx`` output format.
Some links for going from LaTeX to Word are listed below.

 * `<http://ubuntuforums.org/showthread.php?t=1033441>`_

 * `<http://tug.org/utilities/texconv/textopc.html>`_

 * `<http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html>`_

Sphinx
------

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the ``doconce sphinx_dir`` command:

.. code-block:: console

        Terminal> doconce sphinx_dir author="authors' names" \
                  title="some title" version=1.0 dirname=sphinxdir \
                  theme=mytheme file1 file2 file3 ...

The keywords ``author``, ``title``, and ``version`` are used in the headings
of the Sphinx document. By default, ``version`` is 1.0 and the script
will try to deduce authors and title from the doconce files ``file1``,
``file2``, etc. that together represent the whole document. Note that
none of the individual Doconce files ``file1``, ``file2``, etc. should
include the rest as their union makes up the whole document.
The default value of ``dirname`` is ``sphinx-rootdir``. The ``theme``
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is ``'default'``).

With a single-file document in ``mydoc.do.txt`` one often just runs

.. code-block:: console

        Terminal> doconce sphinx_dir mydoc

and then an appropriate Sphinx directory ``sphinx-rootdir`` is made with
relevant files.

The ``doconce sphinx_dir`` command generates a script
``automake-sphinx.py`` for compiling the Sphinx document into an HTML
document.  One can either run ``automake-sphinx.py`` or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te ``doconce sphinx_dir`` script copies directories named ``figs`` or ``figures``
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, ``automake-sphinx.py`` must be edited accordingly.
Links to local files (not ``http:`` or ``file:`` URLs) must be placed
in the ``_static`` subdirectory of the Sphinx directory. The
utility ``doconce sphinxfix_localURLs`` is run to check for local
links: for each such link, say ``dir1/dir2/myfile.txt`` it replaces
the link by ``_static/myfile.txt`` and copies ``dir1/dir2/myfile.txt``
to a local ``_static`` directory (in the same directory as the
script is run). The user must copy all ``_static/*`` files to the
``_static`` subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the ``_static`` subdirectory of the Sphinx directory.
It may be wise to place relevant files in a ``_static`` directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the ``conf.py``
configuration file for Sphinx is edited accordingly, and a script
``make-themes.sh`` can make HTML documents with one or more themes.
For example,
to realize the themes ``fenics`` and ``pyramid``, one writes

.. code-block:: console

        Terminal> ./make-themes.sh fenics pyramid

The resulting directories with HTML documents are ``_build/html_fenics``
and ``_build/html_pyramid``, respectively. Without arguments,
``make-themes.sh`` makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file ``mydoc.do.txt``.

*Step 1.* Translate Doconce into the Sphinx format:

.. code-block:: console

        Terminal> doconce format sphinx mydoc


*Step 2.* Create a Sphinx root directory
either manually or by using the interactive ``sphinx-quickstart``
program. Here is a scripted version of the steps with the latter:

.. code-block:: console

        mkdir sphinx-rootdir
        sphinx-quickstart <<EOF
        sphinx-rootdir
        n
        _
        Name of My Sphinx Document
        Author
        version
        version
        .rst
        index
        n
        y
        n
        n
        n
        n
        y
        n
        n
        y
        y
        y
        EOF

The autogenerated ``conf.py`` file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The ``doconce sphinx_dir`` generator makes an extended ``conv.py``
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the ``mydoc.rst`` file to the Sphinx root directory:

.. code-block:: console

        Terminal> cp mydoc.rst sphinx-rootdir

If you have figures in your document, the relative paths to those will
be invalid when you work with ``mydoc.rst`` in the ``sphinx-rootdir``
directory. Either edit ``mydoc.rst`` so that figure file paths are correct,
or simply copy your figure directories to ``sphinx-rootdir``.
Links to local files in ``mydoc.rst`` must be modified to links to
files in the ``_static`` directory, see comment above.

*Step 4.* Edit the generated ``index.rst`` file so that ``mydoc.rst``
is included, i.e., add ``mydoc`` to the ``toctree`` section so that it becomes

.. code-block:: py


        .. toctree::
           :maxdepth: 2
        
           mydoc

(The spaces before ``mydoc`` are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source:

.. code-block:: console

        make clean   # remove old versions
        make html


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with ``index.html`` files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result:

.. code-block:: console

        Terminal> firefox _build/html/index.html


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows ``!bc``: ``cod`` gives Python
(``code-block:: python`` in Sphinx syntax) and ``cppcod`` gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


Wiki Formats
------------

There are many different wiki formats, but Doconce only supports three:
`Googlecode wiki <http://code.google.com/p/support/wiki/WikiSyntax<Google Code>>`_, , MediaWiki, and Creole Wiki. These formats are called
``gwiki``, ``mwiki``, and ``cwiki``, respectively.
Transformation from Doconce to these formats is done by

.. code-block:: console

        Terminal> doconce format gwiki mydoc.do.txt
        Terminal> doconce format mwiki mydoc.do.txt
        Terminal> doconce format cwiki mydoc.do.txt


The Googlecode wiki document, ``mydoc.gwiki``, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the ``.gwiki`` file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of `mwlib <http://pediapress.com/code/>`_. This means that one can
easily use Doconce to write `Wikibooks <http://en.wikibooks.org>`_
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


Tweaking the Doconce Output
---------------------------

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
``.rst`` file is going to be filtered to LaTeX or HTML, it cannot know
if ``.eps`` or ``.png`` is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The ``make.sh`` files in ``docs/manual`` and ``docs/tutorial``
constitute comprehensive examples on how such scripts can be made.


Demos
-----

The current text is generated from a Doconce format stored in the file

.. code-block:: py


        docs/tutorial/tutorial.do.txt

The file ``make.sh`` in the ``tutorial`` directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, ``tutorial.do.txt`` is the
starting point.  Running ``make.sh`` and studying the various generated
files and comparing them with the original ``tutorial.do.txt`` file,
gives a quick introduction to how Doconce is used in a real case.
`Here <https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html>`_
is a sample of how this tutorial looks in different formats.

There is another demo in the ``docs/manual`` directory which
translates the more comprehensive documentation, ``manual.do.txt``, to
various formats. The ``make.sh`` script runs a set of translations.

Dependencies and Installation
-----------------------------

Doconce itself is pure Python code hosted at `<http://code.google.com/p/doconce>`_.  Its installation from the
Mercurial (``hg``) source follows the standard procedure:

.. code-block:: console

        # Doconce
        hg clone https://doconce.googlecode.com/hg/ doconce
        cd doconce
        sudo python setup.py install
        cd ..


If you make use of the `Preprocess <http://code.google.com/p/preprocess>`_
preprocessor, this program must be installed:

.. code-block:: console

        svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
        cd preprocess
        cd doconce
        sudo python setup.py install
        cd ..

A much more advanced alternative to Preprocess is
`Mako <http://www.makotemplates.org>`_. Its installation is most
conveniently done by ``pip``,

.. code-block:: console

        pip install Mako

This command requires ``pip`` to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by

.. code-block:: console

        sudo apt-get install python-pip

Alternatively, one can install from the ``pip`` `source code <http://pypi.python.org/pypi/pip>`_.

To make LaTeX
documents (without going through the reStructuredText format) you
need `ptex2tex <http://code.google.com/p/ptex2tex>`_, which is
installed by

.. code-block:: console

        svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
        cd ptex2tex
        sudo python setup.py install
        cd latex
        sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
        cd ../..

As seen, ``cp2texmf.sh`` copies some special stylefiles that
that ``ptex2tex`` potentially makes use of. Some more standard stylefiles
are also needed. These are installed by

.. code-block:: console

        sudo apt-get install texlive-latex-extra

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the ``~/texmf/tex/latex/misc`` directory).

The *minted* LaTeX style is offered by ``ptex2tex`` and popular among
users. This style requires the package `Pygments <http://pygments.org>`_:

.. code-block:: console

        hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
        cd pygments
        sudo python setup.py install

If you use the minted style, you have to enable it by running
``ptex2tex -DMINTED`` and then ``latex -shell-escape``, see
the the section :ref:`doconce2formats`.

For ``rst`` output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs `docutils <http://docutils.sourceforge.net>`_.
The installation can be done by

.. code-block:: console

        svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
        cd docutils
        sudo python setup.py install
        cd ..

To use the OpenOffice suite you will typically on Debian systems install

.. code-block:: console

        sudo apt-get install unovonv libreoffice libreoffice-dmaths


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
`rst2pdf <http://code.google.com/p/rst2pdf>`_. Either download the tarball
or clone the svn repository, go to the ``rst2pdf`` directory and
run ``sudo python setup.py install``.


Output to ``sphinx`` requires of course `Sphinx <http://sphinx.pocoo.org>`_,
installed by

.. code-block:: console

        hg clone https://bitbucket.org/birkenfeld/sphinx
        cd sphinx
        sudo python setup.py install
        cd ..


When the output format is ``epydoc`` one needs that program too, installed
by

.. code-block:: console

        svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
        cd epydoc
        sudo make install
        cd ..


Finally, translation to ``pandoc`` requires the
`Pandoc <http://johnmacfarlane.net/pandoc/>`_ program
(written in Haskell) to be installed.

.. code-block:: console

        sudo apt-get install pandoc


*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
``apt-get install`` command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For ``svn`` directories, go to the directory,
run ``svn update``, and then ``sudo python setup.py install``. For
Mercurial (``hg``) directories, go to the directory, run
``hg pull; hg update``, and then ``sudo python setup.py install``.
Doconce itself is frequently updated so these commands should be
run regularly.
************** File: tutorial.gwiki *****************
#summary Doconce: Document Once, Include Anywhere
<wiki:toc max_depth="2" />
By *Hans Petter Langtangen*

==== Jan 32, 2100 ====

 * When writing a note, report, manual, etc., do you find it difficult   to choose the typesetting format? That is, to choose between plain   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,   reStructuredText, Sphinx, XML, etc.  Would it be convenient to   start with some very simple text-like format that easily converts   to the formats listed above, and then at some later stage   eventually go with a particular format?
 * Do you need to write documents in varying formats but find it   difficult to remember all the typesetting details of various   formats like [http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf LaTeX], [http://www.htmlcodetutorial.com/ HTML], [http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html reStructuredText], [http://sphinx.pocoo.org/contents.html Sphinx], and [http://code.google.com/p/support/wiki/WikiSyntax wiki]? Would it be convenient   to generate the typesetting details of a particular format from a   very simple text-like format with minimal tagging?
 * Do you have the same information scattered around in different   documents in different typesetting formats? Would it be a good idea   to write things once, in one format, stored in one place, and   include it anywhere?

If any of these questions are of interest, you should keep on reading.



== The Doconce Concept ==

Doconce is two things:


 # Doconce is a very simple and minimally tagged markup language that    looks like ordinary ASCII text (much like what you would use in an    email), but the text can be transformed to numerous other formats,    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText    (reST), Sphinx, Epytext, and also plain text (where non-obvious    formatting/tags are removed for clear reading in, e.g.,    emails). From reST you can (via `rst2*` programs) go to XML, HTML,    LaTeX, PDF, OpenOffice, and from the latter (via `unoconv`) to    RTF, numerous MS Word formats (including MS Office Open XML),    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU    Texinfo, MediaWiki, RTF, Groff, and other formats.
 # Doconce is a working strategy for never duplicating information.    Text is written in a single place and then transformed to    a number of different destinations of diverse type (software    source code, manuals, tutorials, books, wikis, memos, emails, etc.).    The Doconce markup language support this working strategy.    The slogan is: "Write once, include anywhere".

Here are some Doconce features:


  * Doconce markup does include tags, so the format is more tagged than    Markdown and Pandoc, but less than reST, and very much less than    LaTeX and HTML.
  * Doconce can be converted to plain *untagged* text,    often desirable for computer programs and email.
  * Doconce has good support for copying in parts of computer code    directly from the source code files via regular expressions    for the start and end lines.
  * Doconce has full support for LaTeX math and integrates well    with big LaTeX projects (books).
  * Doconce is almost self-explanatory and is a handy starting point    for generating documents in more complicated markup languages, such    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce    is just to make the initial versions of a Sphinx or wiki document.
  * Contrary to the similar (and superior) Pandoc translator, Doconce    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),    lots of computer code environments in LaTeX, and a special exercise    syntax. Doconce also also runs preprocessors (including Mako)    such that the author can mix ordinary text with programming    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:


  * Large books written in LaTeX, but where many pieces (computer demos,    projects, examples) can be written in Doconce to appear in other    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.
  * Software documentation, primarily Python doc strings, which one wants    to appear as plain untagged text for viewing in Pydoc, as reStructuredText    for use with Sphinx, as wiki text when publishing the software at    web sites, and as LaTeX integrated in, e.g., a thesis.
  * Quick memos, which start as plain text in email, then some small    amount of Doconce tagging is added, before the memos can appear as    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



== What Does Doconce Look Like? ==

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.


  * Bullet lists arise from lines starting with an asterisk.
  * *Emphasized words* are surrounded by asterisks.
  * *Words in boldface* are surrounded by underscores.
  * Words from computer code are enclosed in back quotes and    then typeset `verbatim (in a monospace font)`.
  * Section headings are recognied by equality (`=`) signs before    and after the title, and the number of `=` signs indicates the    level of the section: 7 for main section, 5 for subsection, and    3 for subsubsection.
  * Paragraph headings are recognized by a double underscore    before and after the heading.
  * The abstract of a document starts with *Abstract* as paragraph    heading, and all text up to the next heading makes up the abstract,
  * Blocks of computer code can easily be included by placing    `!bc` (begin code) and `!ec` (end code) commands at separate lines    before and after the code block.
  * Blocks of computer code can also be imported from source files.
  * Blocks of LaTeX mathematics can easily be included by placing    `!bt` (begin TeX) and `!et` (end TeX) commands at separate lines    before and after the math block.
  * There is support for both LaTeX and text-like inline mathematics.
  * Figures and movies with captions, simple tables,    URLs with links, index list, labels and references are supported.
  * Invisible comments in the output format can be inserted throughout    the text.
  * Visible comments can be inserted so that authors and readers can    comment upon the text (and at any time turn on/off output of such    comments).
  * There is special support for advanced exercises features.
  * With a simple preprocessor, Preprocess or Mako, one can include    other documents (files) and large portions of text can be defined    in or out of the text.
  * With the Mako preprocessor one can even embed Python    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format:
{{{
===== A Subsection with Sample Text =====
label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have automatically numbered items instead of bullets,

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

# lines beginning with # are comment lines
}}}
The Doconce text above results in the following little document:

==== A Subsection with Sample Text ====

Ordinary text looks like ordinary text, and the tags used for
*boldface* words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,


  * item 1
  * item 2
  * item 3

Lists can also have numbered items instead of bullets, just use an `o`
(for ordered) instead of the asterisk:


 # item 1
 # item 2
 # item 3

URLs with a link word are possible, as in [http://folk.uio.no/hpl hpl].
If the word is URL, the URL itself becomes the link name,
as in tutorial.do.txt.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section [#A_Subsection_with_Sample_Text].

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section [#From_Doconce_to_Other_Formats] for an example).

Tables are also supperted, e.g.,


 ||      *time*       ||    *velocity*     ||  *acceleration*   ||
 ||  0.0              ||  1.4186           ||  -5.01            ||
 ||  2.0              ||  1.376512         ||  11.919           ||
 ||  4.0              ||  1.1E+1           ||  14.717624        ||

==== Mathematics and Computer Code ====

Inline mathematics, such as `v = sin(x)`,
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like `v = sin(x)` is
typeset as
{{{
$\nu = \sin(x)$|$v = sin(x)$
}}}
The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
`!bt` and `!et` (begin tex / end tex) instructions.
The result looks like this:
{{{
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
\end{eqnarray}
}}}
Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
`!bc` and `!ec` instructions, respectively. Such blocks look like
{{{
from math import sin, pi
def myfunc(x):
    return sin(pi*x)

import integrate
I = integrate.trapezoidal(myfunc, 0, pi, 100)
}}}
A code block must come after some plain sentence (at least for successful
output to `sphinx`, `rst`, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., `!bc xxx`
where `xxx` is an identifier like `pycod` for code snippet in Python,
`sys` for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in `ptex2tex` and defined in a
configuration file `.ptext2tex.cfg`, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):
{{{
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
}}}
By default, `pro` and `cod` are `python`, `sys` is `console`,
while `xpro` and `xcod` are computer language specific for `x`
in `f` (Fortran), `c` (C), `cpp` (C++), `pl` (Perl), `m` (Matlab),
`sh` (Unix shells), `cy` (Cython), and `py` (Python).

<wiki:comment> (Any sphinx code-block comment, whether inside verbatim code </wiki:comment>
<wiki:comment> blocks or outside, yields a mapping between bc arguments </wiki:comment>
<wiki:comment> and computer languages. In case of muliple definitions, the </wiki:comment>
<wiki:comment> first one is used.) </wiki:comment>

One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with `!bc pro`, while a part of a file is copied into a `!bc cod`
environment. What `pro` and `cod` mean is then defined through
a `.ptex2tex.cfg` file for LaTeX and a `sphinx code-blocks`
comment for Sphinx.

Another document can be included by writing `#include "mynote.do.txt"`
on a line starting with (another) hash sign.  Doconce documents have
extension `do.txt`. The `do` part stands for doconce, while the
trailing `.txt` denotes a text document so that editors gives you the
right writing enviroment for plain text.

==== Macros (Newcommands), Cross-References, Index, and Bibliography ====

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
`newcommand_replace.tex` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names `newcommands.tex` and
`newcommands_keep.tex` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
`!bt` and `!et` in `newcommands_keep.tex` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
`newcommands_replace.tex` and expanded by Doconce.  The definitions of
newcommands in the `newcommands*.tex` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the `doc/manual/manual.do.txt` file (see the
[https://doconce.googlecode.com/hg/doc/demos/manual/index.html demo page]
for various formats of this document).


<wiki:comment> Example on including another Doconce file (using preprocess): </wiki:comment>



== From Doconce to Other Formats ==

Transformation of a Doconce document `mydoc.do.txt` to various other
formats applies the script `doconce format`:
{{{
Terminal> doconce format format mydoc.do.txt
}}}
or just
{{{
Terminal> doconce format format mydoc
}}}
The `mako` or `preprocess` programs are always used to preprocess the
file first, and options to `mako` or `preprocess` can be added after the
filename. For example,
{{{
Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako
}}}
The variable `FORMAT` is always defined as the current format when
running `preprocess`. That is, in the last example, `FORMAT` is
defined as `latex`. Inside the Doconce document one can then perform
format specific actions through tests like `#if FORMAT == "latex"`.

Inline comments in the text are removed from the output by
{{{
Terminal> doconce format latex mydoc --skip_inline_comments
}}}
One can also remove all such comments from the original Doconce
file by running:
{{{
Terminal> doconce remove_inline_comments mydoc
}}}
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

==== HTML ====

Making an HTML version of a Doconce file `mydoc.do.txt`
is performed by
{{{
Terminal> doconce format html mydoc
}}}
The resulting file `mydoc.html` can be loaded into any web browser for viewing.

==== Pandoc ====

Output in Pandoc's extended Markdown format results from
{{{
Terminal> doconce format pandoc mydoc
}}}
The name of the output file is `mydoc.mkd`.
From this format one can go to numerous other formats:
{{{
Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
}}}
Pandoc supports `latex`, `html`, `odt` (OpenOffice), `docx` (Microsoft
Word), `rtf`, `texinfo`, to mention some. The `-R` option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the [http://johnmacfarlane.net/pandoc/README.html Pandoc documentation]
for the many features of the `pandoc` program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
`doconce format pandoc` and then translating using `pandoc`, or
`doconce format latex`, and then going from LaTeX to the desired format
using `pandoc`.
Here is an example on the latter strategy:
{{{
Terminal> doconce format latex mydoc
Terminal> doconce ptex2tex mydoc
Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex
}}}
When we go through `pandoc`, only single equations or `align*`
environments are well understood.

Quite some `doconce replace` and `doconce subst` edits might be needed
on the `.mkd` or `.tex` files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
{{{
Terminal> doconce format pandoc mydoc
Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
}}}
The `-s` option adds a proper header and footer to the `mydoc.html` file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

==== LaTeX ====

Making a LaTeX file `mydoc.tex` from `mydoc.do.txt` is done in two steps:
<wiki:comment> Note: putting code blocks inside a list is not successful in many </wiki:comment>
<wiki:comment> formats - the text may be messed up. A better choice is a paragraph </wiki:comment>
<wiki:comment> environment, as used here. </wiki:comment>

*Step 1.* Filter the doconce text to a pre-LaTeX form `mydoc.p.tex` for
     `ptex2tex`:
{{{
Terminal> doconce format latex mydoc
}}}
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files `newcommands.tex`, `newcommands_keep.tex`, or
`newcommands_replace.tex` (see the section [#Macros_(Newcommands),_Cross-References,_Index,_and_Bibliography]).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run `ptex2tex` (if you have it) to make a standard LaTeX file,
{{{
Terminal> ptex2tex mydoc
}}}
In case you do not have `ptex2tex`, you may run a (very) simplified version:
{{{
Terminal> doconce ptex2tex mydoc
}}}

Note that Doconce generates a `.p.tex` file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
{{{
Terminal> ptex2tex -DHELVETICA mydoc
}}}
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through
{{{
Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc
}}}
A separate titlepage can be generate by
{{{
Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc
}}}

The `ptex2tex` tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any `!bc` command in the Doconce source you can
insert verbatim block styles as defined in your `.ptex2tex.cfg`
file, e.g., `!bc cod` for a code snippet, where `cod` is set to
a certain environment in `.ptex2tex.cfg` (e.g., `CodeIntended`).
There are about 40 styles to choose from.

Also the `doconce ptex2tex` command supports preprocessor directives
for processing the `.p.tex` file. The command allows specifications
of code environments as well. Here is an example:
{{{
Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
}}}
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
`verbatim` above, which implies `\begin{verbatim}` and `\end{verbatim}`).
The value `minted` can be used for code environments where the
language is specified, as in `fpro`, where `minted` implies
`\begin{python}{fortran}`. There is a similar support for `ans`:
`cppcod=ans` imples `\begin{c++}` and `\end{c++}` using the
`anslistings` package.

*Step 2b (optional).* Edit the `mydoc.tex` file to your needs.
For example, you may want to substitute `section` by `section*` to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the `doconce replace` and `doconce subst`
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
{{{
Terminal> doconce replace 'section{' 'section*{' mydoc.tex
Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex
}}}
A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile `mydoc.tex`
and create the PDF file:
{{{
Terminal> latex mydoc
Terminal> latex mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex mydoc
Terminal> dvipdf mydoc
}}}
If one wishes to use the `Minted_Python`, `Minted_Cpp`, etc.,
environments in `ptex2tex` for typesetting code (specified, e.g., in
the `*pro` and `*cod` environments in `.ptex2tex.cfg` or
`$HOME/.ptex2tex.cfg`), the `minted` LaTeX package is needed.  This
package is included by running `doconce format` with the `-DMINTED`
option:
{{{
Terminal> ptex2tex -DMINTED mydoc
}}}
In this case, `latex` must be run with the
`-shell-escape` option:
{{{
Terminal> latex -shell-escape mydoc
Terminal> latex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex -shell-escape mydoc
Terminal> dvipdf mydoc
}}}

==== PDFLaTeX ====

Running `pdflatex` instead of `latex` follows almost the same steps,
but the start is
{{{
Terminal> doconce format latex mydoc
}}}
Then `ptex2tex` is run as explained above, and finally
{{{
Terminal> pdflatex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> pdflatex -shell-escape mydoc
}}}

==== Plain ASCII Text ====

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
{{{
Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt
}}}

==== reStructuredText ====

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file `mydoc.rst`:
{{{
Terminal> doconce format rst mydoc.do.txt
}}}
We may now produce various other formats:
{{{
Terminal> rst2html.py  mydoc.rst > mydoc.html # html
Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice
}}}

The OpenOffice file `mydoc.odt` can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program `unovonv`
to convert between the many formats OpenOffice supports *on the command line*.
Run
{{{
Terminal> unoconv --show
}}}
to see all the formats that are supported.
For example, the following commands take
`mydoc.odt` to Microsoft Office Open XML format,
classic MS Word format, and PDF:
{{{
Terminal> unoconv -f ooxml mydoc.odt
Terminal> unoconv -f doc mydoc.odt
Terminal> unoconv -f pdf mydoc.odt
}}}

*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by `latex` as
output and to a wide extent also supported by the `sphinx` output format.
Some links for going from LaTeX to Word are listed below.


 * http://ubuntuforums.org/showthread.php?t=1033441
 * http://tug.org/utilities/texconv/textopc.html
 * http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html

==== Sphinx ====

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the `doconce sphinx_dir` command:
{{{
Terminal> doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
}}}
The keywords `author`, `title`, and `version` are used in the headings
of the Sphinx document. By default, `version` is 1.0 and the script
will try to deduce authors and title from the doconce files `file1`,
`file2`, etc. that together represent the whole document. Note that
none of the individual Doconce files `file1`, `file2`, etc. should
include the rest as their union makes up the whole document.
The default value of `dirname` is `sphinx-rootdir`. The `theme`
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is `'default'`).

With a single-file document in `mydoc.do.txt` one often just runs
{{{
Terminal> doconce sphinx_dir mydoc
}}}
and then an appropriate Sphinx directory `sphinx-rootdir` is made with
relevant files.

The `doconce sphinx_dir` command generates a script
`automake-sphinx.py` for compiling the Sphinx document into an HTML
document.  One can either run `automake-sphinx.py` or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te `doconce sphinx_dir` script copies directories named `figs` or `figures`
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, `automake-sphinx.py` must be edited accordingly.
Links to local files (not `http:` or `file:` URLs) must be placed
in the `_static` subdirectory of the Sphinx directory. The
utility `doconce sphinxfix_localURLs` is run to check for local
links: for each such link, say `dir1/dir2/myfile.txt` it replaces
the link by `_static/myfile.txt` and copies `dir1/dir2/myfile.txt`
to a local `_static` directory (in the same directory as the
script is run). The user must copy all `_static/*` files to the
`_static` subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the `_static` subdirectory of the Sphinx directory.
It may be wise to place relevant files in a `_static` directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the `conf.py`
configuration file for Sphinx is edited accordingly, and a script
`make-themes.sh` can make HTML documents with one or more themes.
For example,
to realize the themes `fenics` and `pyramid`, one writes
{{{
Terminal> ./make-themes.sh fenics pyramid
}}}
The resulting directories with HTML documents are `_build/html_fenics`
and `_build/html_pyramid`, respectively. Without arguments,
`make-themes.sh` makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file `mydoc.do.txt`.

*Step 1.* Translate Doconce into the Sphinx format:
{{{
Terminal> doconce format sphinx mydoc
}}}

*Step 2.* Create a Sphinx root directory
either manually or by using the interactive `sphinx-quickstart`
program. Here is a scripted version of the steps with the latter:
{{{
mkdir sphinx-rootdir
sphinx-quickstart <<EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
}}}
The autogenerated `conf.py` file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The `doconce sphinx_dir` generator makes an extended `conv.py`
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the `mydoc.rst` file to the Sphinx root directory:
{{{
Terminal> cp mydoc.rst sphinx-rootdir
}}}
If you have figures in your document, the relative paths to those will
be invalid when you work with `mydoc.rst` in the `sphinx-rootdir`
directory. Either edit `mydoc.rst` so that figure file paths are correct,
or simply copy your figure directories to `sphinx-rootdir`.
Links to local files in `mydoc.rst` must be modified to links to
files in the `_static` directory, see comment above.

*Step 4.* Edit the generated `index.rst` file so that `mydoc.rst`
is included, i.e., add `mydoc` to the `toctree` section so that it becomes
{{{
.. toctree::
   :maxdepth: 2

   mydoc
}}}
(The spaces before `mydoc` are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source:
{{{
make clean   # remove old versions
make html
}}}

Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with `index.html` files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result:
{{{
Terminal> firefox _build/html/index.html
}}}

Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows `!bc`: `cod` gives Python
(`code-block:: python` in Sphinx syntax) and `cppcod` gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.

==== Wiki Formats ====

There are many different wiki formats, but Doconce only supports three:
[http://code.google.com/p/support/wiki/WikiSyntax<Google Code> Googlecode wiki], , MediaWiki, and Creole Wiki. These formats are called
`gwiki`, `mwiki`, and `cwiki`, respectively.
Transformation from Doconce to these formats is done by
{{{
Terminal> doconce format gwiki mydoc.do.txt
Terminal> doconce format mwiki mydoc.do.txt
Terminal> doconce format cwiki mydoc.do.txt
}}}

The Googlecode wiki document, `mydoc.gwiki`, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the `.gwiki` file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of [http://pediapress.com/code/ mwlib]. This means that one can
easily use Doconce to write [http://en.wikibooks.org Wikibooks]
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.

==== Tweaking the Doconce Output ====

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
`.rst` file is going to be filtered to LaTeX or HTML, it cannot know
if `.eps` or `.png` is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The `make.sh` files in `docs/manual` and `docs/tutorial`
constitute comprehensive examples on how such scripts can be made.

==== Demos ====

The current text is generated from a Doconce format stored in the file
{{{
docs/tutorial/tutorial.do.txt
}}}
The file `make.sh` in the `tutorial` directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, `tutorial.do.txt` is the
starting point.  Running `make.sh` and studying the various generated
files and comparing them with the original `tutorial.do.txt` file,
gives a quick introduction to how Doconce is used in a real case.
[https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html Here]
is a sample of how this tutorial looks in different formats.

There is another demo in the `docs/manual` directory which
translates the more comprehensive documentation, `manual.do.txt`, to
various formats. The `make.sh` script runs a set of translations.

==== Dependencies and Installation ====

Doconce itself is pure Python code hosted at http://code.google.com/p/doconce.  Its installation from the
Mercurial (`hg`) source follows the standard procedure:
{{{
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
}}}

If you make use of the [http://code.google.com/p/preprocess Preprocess]
preprocessor, this program must be installed:
{{{
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
}}}
A much more advanced alternative to Preprocess is
[http://www.makotemplates.org Mako]. Its installation is most
conveniently done by `pip`,
{{{
pip install Mako
}}}
This command requires `pip` to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by
{{{
sudo apt-get install python-pip
}}}
Alternatively, one can install from the `pip` [http://pypi.python.org/pypi/pip source code].

To make LaTeX
documents (without going through the reStructuredText format) you
need [http://code.google.com/p/ptex2tex ptex2tex], which is
installed by
{{{
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
}}}
As seen, `cp2texmf.sh` copies some special stylefiles that
that `ptex2tex` potentially makes use of. Some more standard stylefiles
are also needed. These are installed by
{{{
sudo apt-get install texlive-latex-extra
}}}
on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the `~/texmf/tex/latex/misc` directory).

The *minted* LaTeX style is offered by `ptex2tex` and popular among
users. This style requires the package [http://pygments.org Pygments]:
{{{
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
}}}
If you use the minted style, you have to enable it by running
`ptex2tex -DMINTED` and then `latex -shell-escape`, see
the the section [#From_Doconce_to_Other_Formats].

For `rst` output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs [http://docutils.sourceforge.net docutils].
The installation can be done by
{{{
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
}}}
To use the OpenOffice suite you will typically on Debian systems install
{{{
sudo apt-get install unovonv libreoffice libreoffice-dmaths
}}}

There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
[http://code.google.com/p/rst2pdf rst2pdf]. Either download the tarball
or clone the svn repository, go to the `rst2pdf` directory and
run `sudo python setup.py install`.


Output to `sphinx` requires of course [http://sphinx.pocoo.org Sphinx],
installed by
{{{
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
}}}

When the output format is `epydoc` one needs that program too, installed
by
{{{
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
}}}

Finally, translation to `pandoc` requires the
[http://johnmacfarlane.net/pandoc/ Pandoc] program
(written in Haskell) to be installed.
{{{
sudo apt-get install pandoc
}}}

*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
`apt-get install` command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For `svn` directories, go to the directory,
run `svn update`, and then `sudo python setup.py install`. For
Mercurial (`hg`) directories, go to the directory, run
`hg pull; hg update`, and then `sudo python setup.py install`.
Doconce itself is frequently updated so these commands should be
run regularly.

************** File: tutorial.mwiki *****************
#TITLE (actually governed by the filename): Doconce: Document Once, Include Anywhere

By '''Hans Petter Langtangen'''

==== Jan 32, 2100 ====

<ul>
 <li> When writing a note, report, manual, etc., do you find it difficult   to choose the typesetting format? That is, to choose between plain   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,   reStructuredText, Sphinx, XML, etc.  Would it be convenient to   start with some very simple text-like format that easily converts   to the formats listed above, and then at some later stage   eventually go with a particular format? <li> Do you need to write documents in varying formats but find it   difficult to remember all the typesetting details of various   formats like [http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf LaTeX], [http://www.htmlcodetutorial.com/ HTML], [http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html reStructuredText], [http://sphinx.pocoo.org/contents.html Sphinx], and [http://code.google.com/p/support/wiki/WikiSyntax wiki]? Would it be convenient   to generate the typesetting details of a particular format from a   very simple text-like format with minimal tagging? <li> Do you have the same information scattered around in different   documents in different typesetting formats? Would it be a good idea   to write things once, in one format, stored in one place, and   include it anywhere?</ul>

If any of these questions are of interest, you should keep on reading.



== The Doconce Concept ==

Doconce is two things:


<ol>
 <li> Doconce is a very simple and minimally tagged markup language that    looks like ordinary ASCII text (much like what you would use in an    email), but the text can be transformed to numerous other formats,    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText    (reST), Sphinx, Epytext, and also plain text (where non-obvious    formatting/tags are removed for clear reading in, e.g.,    emails). From reST you can (via <code>rst2*</code> programs) go to XML, HTML,    LaTeX, PDF, OpenOffice, and from the latter (via <code>unoconv</code>) to    RTF, numerous MS Word formats (including MS Office Open XML),    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU    Texinfo, MediaWiki, RTF, Groff, and other formats. <li> Doconce is a working strategy for never duplicating information.    Text is written in a single place and then transformed to    a number of different destinations of diverse type (software    source code, manuals, tutorials, books, wikis, memos, emails, etc.).    The Doconce markup language support this working strategy.    The slogan is: "Write once, include anywhere".</ol>

Here are some Doconce features:


<ul>
  <li> Doconce markup does include tags, so the format is more tagged than    Markdown and Pandoc, but less than reST, and very much less than    LaTeX and HTML.  <li> Doconce can be converted to plain ''untagged'' text,    often desirable for computer programs and email.  <li> Doconce has good support for copying in parts of computer code    directly from the source code files via regular expressions    for the start and end lines.  <li> Doconce has full support for LaTeX math and integrates well    with big LaTeX projects (books).  <li> Doconce is almost self-explanatory and is a handy starting point    for generating documents in more complicated markup languages, such    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce    is just to make the initial versions of a Sphinx or wiki document.  <li> Contrary to the similar (and superior) Pandoc translator, Doconce    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),    lots of computer code environments in LaTeX, and a special exercise    syntax. Doconce also also runs preprocessors (including Mako)    such that the author can mix ordinary text with programming    construction for generating parts of the text.</ul>

Doconce was particularly written for the following sample applications:


<ul>
  <li> Large books written in LaTeX, but where many pieces (computer demos,    projects, examples) can be written in Doconce to appear in other    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.  <li> Software documentation, primarily Python doc strings, which one wants    to appear as plain untagged text for viewing in Pydoc, as reStructuredText    for use with Sphinx, as wiki text when publishing the software at    web sites, and as LaTeX integrated in, e.g., a thesis.  <li> Quick memos, which start as plain text in email, then some small    amount of Doconce tagging is added, before the memos can appear as    Sphinx web pages, MS Word documents, or in wikis.</ul>

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



== What Does Doconce Look Like? ==

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.


<ul>
  <li> Bullet lists arise from lines starting with an asterisk.  <li> ''Emphasized words'' are surrounded by asterisks.  <li> '''Words in boldface''' are surrounded by underscores.  <li> Words from computer code are enclosed in back quotes and    then typeset <code>verbatim (in a monospace font)</code>.  <li> Section headings are recognied by equality (<code>=</code>) signs before    and after the title, and the number of <code>=</code> signs indicates the    level of the section: 7 for main section, 5 for subsection, and    3 for subsubsection.  <li> Paragraph headings are recognized by a double underscore    before and after the heading.  <li> The abstract of a document starts with ''Abstract'' as paragraph    heading, and all text up to the next heading makes up the abstract,  <li> Blocks of computer code can easily be included by placing    <code>!bc</code> (begin code) and <code>!ec</code> (end code) commands at separate lines    before and after the code block.  <li> Blocks of computer code can also be imported from source files.  <li> Blocks of LaTeX mathematics can easily be included by placing    <code>!bt</code> (begin TeX) and <code>!et</code> (end TeX) commands at separate lines    before and after the math block.  <li> There is support for both LaTeX and text-like inline mathematics.  <li> Figures and movies with captions, simple tables,    URLs with links, index list, labels and references are supported.  <li> Invisible comments in the output format can be inserted throughout    the text.  <li> Visible comments can be inserted so that authors and readers can    comment upon the text (and at any time turn on/off output of such    comments).  <li> There is special support for advanced exercises features.  <li> With a simple preprocessor, Preprocess or Mako, one can include    other documents (files) and large portions of text can be defined    in or out of the text.  <li> With the Mako preprocessor one can even embed Python    code and use this to steer generation of Doconce text.</ul>

Here is an example of some simple text written in the Doconce format:
<code>
===== A Subsection with Sample Text =====
label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have automatically numbered items instead of bullets,

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

# lines beginning with # are comment lines
</code>
The Doconce text above results in the following little document:

==== A Subsection with Sample Text ====

Ordinary text looks like ordinary text, and the tags used for
'''boldface''' words, ''emphasized'' words, and <code>computer</code> words look
natural in plain text.  Lists are typeset as you would do in an email,


<ul>
  <li> item 1  <li> item 2  <li> item 3</ul>

Lists can also have numbered items instead of bullets, just use an <code>o</code>
(for ordered) instead of the asterisk:


<ol>
 <li> item 1 <li> item 2 <li> item 3</ol>

URLs with a link word are possible, as in [http://folk.uio.no/hpl hpl].
If the word is URL, the URL itself becomes the link name,
as in tutorial.do.txt.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section [#A_Subsection_with_Sample_Text].

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section [#From_Doconce_to_Other_Formats] for an example).

Tables are also supperted, e.g.,

<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="right">   0.0             </td> <td align="right">   1.4186          </td> <td align="right">   -5.01           </td> </tr>
<tr><td align="right">   2.0             </td> <td align="right">   1.376512        </td> <td align="right">   11.919          </td> </tr>
<tr><td align="right">   4.0             </td> <td align="right">   1.1E+1          </td> <td align="right">   14.717624       </td> </tr>
</table>

==== Mathematics and Computer Code ====

Inline mathematics, such as <math>\nu = \sin(x)</math>,
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like <math>\nu = \sin(x)</math> is
typeset as
<code>
$\nu = \sin(x)$|$v = sin(x)$
</code>
The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
<code>!bt</code> and <code>!et</code> (begin tex / end tex) instructions.
The result looks like this:
:<math>
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
\end{eqnarray}
</math>
Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
<code>!bc</code> and <code>!ec</code> instructions, respectively. Such blocks look like
<syntaxhighlight lang="python">
from math import sin, pi
def myfunc(x):
    return sin(pi*x)

import integrate
I = integrate.trapezoidal(myfunc, 0, pi, 100)
</code>
A code block must come after some plain sentence (at least for successful
output to <code>sphinx</code>, <code>rst</code>, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., <code>!bc xxx</code>
where <code>xxx</code> is an identifier like <code>pycod</code> for code snippet in Python,
<code>sys</code> for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in <code>ptex2tex</code> and defined in a
configuration file <code>.ptext2tex.cfg</code>, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):
<code>
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
</code>
By default, <code>pro</code> and <code>cod</code> are <code>python</code>, <code>sys</code> is <code>console</code>,
while <code>xpro</code> and <code>xcod</code> are computer language specific for <code>x</code>
in <code>f</code> (Fortran), <code>c</code> (C), <code>cpp</code> (C++), <code>pl</code> (Perl), <code>m</code> (Matlab),
<code>sh</code> (Unix shells), <code>cy</code> (Cython), and <code>py</code> (Python).

<!--> (Any sphinx code-block comment, whether inside verbatim code -->
<!--> blocks or outside, yields a mapping between bc arguments -->
<!--> and computer languages. In case of muliple definitions, the -->
<!--> first one is used.) -->

One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with <code>!bc pro</code>, while a part of a file is copied into a <code>!bc cod</code>
environment. What <code>pro</code> and <code>cod</code> mean is then defined through
a <code>.ptex2tex.cfg</code> file for LaTeX and a <code>sphinx code-blocks</code>
comment for Sphinx.

Another document can be included by writing <code>#include "mynote.do.txt"</code>
on a line starting with (another) hash sign.  Doconce documents have
extension <code>do.txt</code>. The <code>do</code> part stands for doconce, while the
trailing <code>.txt</code> denotes a text document so that editors gives you the
right writing enviroment for plain text.

==== Macros (Newcommands), Cross-References, Index, and Bibliography ====

Doconce supports a type of macros via a LaTeX-style ''newcommand''
construction.  The newcommands defined in a file with name
<code>newcommand_replace.tex</code> are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names <code>newcommands.tex</code> and
<code>newcommands_keep.tex</code> are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
<code>!bt</code> and <code>!et</code> in <code>newcommands_keep.tex</code> to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
<code>newcommands_replace.tex</code> and expanded by Doconce.  The definitions of
newcommands in the <code>newcommands*.tex</code> files ''must'' appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the <code>doc/manual/manual.do.txt</code> file (see the
[https://doconce.googlecode.com/hg/doc/demos/manual/index.html demo page]
for various formats of this document).


<!--> Example on including another Doconce file (using preprocess): -->



== From Doconce to Other Formats ==

Transformation of a Doconce document <code>mydoc.do.txt</code> to various other
formats applies the script <code>doconce format</code>:
<syntaxhighlight lang="bash">
Terminal> doconce format format mydoc.do.txt
</code>
or just
<syntaxhighlight lang="bash">
Terminal> doconce format format mydoc
</code>
The <code>mako</code> or <code>preprocess</code> programs are always used to preprocess the
file first, and options to <code>mako</code> or <code>preprocess</code> can be added after the
filename. For example,
<syntaxhighlight lang="bash">
Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako
</code>
The variable <code>FORMAT</code> is always defined as the current format when
running <code>preprocess</code>. That is, in the last example, <code>FORMAT</code> is
defined as <code>latex</code>. Inside the Doconce document one can then perform
format specific actions through tests like <code>#if FORMAT == "latex"</code>.

Inline comments in the text are removed from the output by
<syntaxhighlight lang="bash">
Terminal> doconce format latex mydoc --skip_inline_comments
</code>
One can also remove all such comments from the original Doconce
file by running:
<code>
Terminal> doconce remove_inline_comments mydoc
</code>
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

==== HTML ====

Making an HTML version of a Doconce file <code>mydoc.do.txt</code>
is performed by
<syntaxhighlight lang="bash">
Terminal> doconce format html mydoc
</code>
The resulting file <code>mydoc.html</code> can be loaded into any web browser for viewing.

==== Pandoc ====

Output in Pandoc's extended Markdown format results from
<syntaxhighlight lang="bash">
Terminal> doconce format pandoc mydoc
</code>
The name of the output file is <code>mydoc.mkd</code>.
From this format one can go to numerous other formats:
<syntaxhighlight lang="bash">
Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
</code>
Pandoc supports <code>latex</code>, <code>html</code>, <code>odt</code> (OpenOffice), <code>docx</code> (Microsoft
Word), <code>rtf</code>, <code>texinfo</code>, to mention some. The <code>-R</code> option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the [http://johnmacfarlane.net/pandoc/README.html Pandoc documentation]
for the many features of the <code>pandoc</code> program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
<code>doconce format pandoc</code> and then translating using <code>pandoc</code>, or
<code>doconce format latex</code>, and then going from LaTeX to the desired format
using <code>pandoc</code>.
Here is an example on the latter strategy:
<syntaxhighlight lang="bash">
Terminal> doconce format latex mydoc
Terminal> doconce ptex2tex mydoc
Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex
</code>
When we go through <code>pandoc</code>, only single equations or <code>align*</code>
environments are well understood.

Quite some <code>doconce replace</code> and <code>doconce subst</code> edits might be needed
on the <code>.mkd</code> or <code>.tex</code> files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
<syntaxhighlight lang="bash">
Terminal> doconce format pandoc mydoc
Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
</code>
The <code>-s</code> option adds a proper header and footer to the <code>mydoc.html</code> file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

==== LaTeX ====

Making a LaTeX file <code>mydoc.tex</code> from <code>mydoc.do.txt</code> is done in two steps:
<!--> Note: putting code blocks inside a list is not successful in many -->
<!--> formats - the text may be messed up. A better choice is a paragraph -->
<!--> environment, as used here. -->

''Step 1.'' Filter the doconce text to a pre-LaTeX form <code>mydoc.p.tex</code> for
     <code>ptex2tex</code>:
<syntaxhighlight lang="bash">
Terminal> doconce format latex mydoc
</code>
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files <code>newcommands.tex</code>, <code>newcommands_keep.tex</code>, or
<code>newcommands_replace.tex</code> (see the section [#Macros_(Newcommands),_Cross-References,_Index,_and_Bibliography]).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

''Step 2.'' Run <code>ptex2tex</code> (if you have it) to make a standard LaTeX file,
<syntaxhighlight lang="bash">
Terminal> ptex2tex mydoc
</code>
In case you do not have <code>ptex2tex</code>, you may run a (very) simplified version:
<syntaxhighlight lang="bash">
Terminal> doconce ptex2tex mydoc
</code>

Note that Doconce generates a <code>.p.tex</code> file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
<syntaxhighlight lang="bash">
Terminal> ptex2tex -DHELVETICA mydoc
</code>
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through
<syntaxhighlight lang="bash">
Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc
</code>
A separate titlepage can be generate by
<syntaxhighlight lang="bash">
Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc
</code>

The <code>ptex2tex</code> tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any <code>!bc</code> command in the Doconce source you can
insert verbatim block styles as defined in your <code>.ptex2tex.cfg</code>
file, e.g., <code>!bc cod</code> for a code snippet, where <code>cod</code> is set to
a certain environment in <code>.ptex2tex.cfg</code> (e.g., <code>CodeIntended</code>).
There are about 40 styles to choose from.

Also the <code>doconce ptex2tex</code> command supports preprocessor directives
for processing the <code>.p.tex</code> file. The command allows specifications
of code environments as well. Here is an example:
<syntaxhighlight lang="bash">
Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
</code>
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
<code>verbatim</code> above, which implies <code>\begin{verbatim}</code> and <code>\end{verbatim}</code>).
The value <code>minted</code> can be used for code environments where the
language is specified, as in <code>fpro</code>, where <code>minted</code> implies
<code>\begin{python}{fortran}</code>. There is a similar support for <code>ans</code>:
<code>cppcod=ans</code> imples <code>\begin{c++}</code> and <code>\end{c++}</code> using the
<code>anslistings</code> package.

''Step 2b (optional).'' Edit the <code>mydoc.tex</code> file to your needs.
For example, you may want to substitute <code>section</code> by <code>section*</code> to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the <code>doconce replace</code> and <code>doconce subst</code>
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
<syntaxhighlight lang="bash">
Terminal> doconce replace 'section{' 'section*{' mydoc.tex
Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex
</code>
A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

''Step 3.'' Compile <code>mydoc.tex</code>
and create the PDF file:
<syntaxhighlight lang="bash">
Terminal> latex mydoc
Terminal> latex mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex mydoc
Terminal> dvipdf mydoc
</code>
If one wishes to use the <code>Minted_Python</code>, <code>Minted_Cpp</code>, etc.,
environments in <code>ptex2tex</code> for typesetting code (specified, e.g., in
the <code>*pro</code> and <code>*cod</code> environments in <code>.ptex2tex.cfg</code> or
<code>$HOME/.ptex2tex.cfg</code>), the <code>minted</code> LaTeX package is needed.  This
package is included by running <code>doconce format</code> with the <code>-DMINTED</code>
option:
<syntaxhighlight lang="bash">
Terminal> ptex2tex -DMINTED mydoc
</code>
In this case, <code>latex</code> must be run with the
<code>-shell-escape</code> option:
<syntaxhighlight lang="bash">
Terminal> latex -shell-escape mydoc
Terminal> latex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex -shell-escape mydoc
Terminal> dvipdf mydoc
</code>

==== PDFLaTeX ====

Running <code>pdflatex</code> instead of <code>latex</code> follows almost the same steps,
but the start is
<syntaxhighlight lang="bash">
Terminal> doconce format latex mydoc
</code>
Then <code>ptex2tex</code> is run as explained above, and finally
<syntaxhighlight lang="bash">
Terminal> pdflatex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> pdflatex -shell-escape mydoc
</code>

==== Plain ASCII Text ====

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
<syntaxhighlight lang="bash">
Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt
</code>

==== reStructuredText ====

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file <code>mydoc.rst</code>:
<syntaxhighlight lang="bash">
Terminal> doconce format rst mydoc.do.txt
</code>
We may now produce various other formats:
<syntaxhighlight lang="bash">
Terminal> rst2html.py  mydoc.rst > mydoc.html # html
Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice
</code>

The OpenOffice file <code>mydoc.odt</code> can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program <code>unovonv</code>
to convert between the many formats OpenOffice supports ''on the command line''.
Run
<syntaxhighlight lang="bash">
Terminal> unoconv --show
</code>
to see all the formats that are supported.
For example, the following commands take
<code>mydoc.odt</code> to Microsoft Office Open XML format,
classic MS Word format, and PDF:
<syntaxhighlight lang="bash">
Terminal> unoconv -f ooxml mydoc.odt
Terminal> unoconv -f doc mydoc.odt
Terminal> unoconv -f pdf mydoc.odt
</code>

''Remark about Mathematical Typesetting.'' At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by <code>latex</code> as
output and to a wide extent also supported by the <code>sphinx</code> output format.
Some links for going from LaTeX to Word are listed below.


<ul>
 <li> [http://ubuntuforums.org/showthread.php?t=1033441  li] http://tug.org/utilities/texconv/textopc.html <li> [http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html /ul]

==== Sphinx ====

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the <code>doconce sphinx_dir</code> command:
<syntaxhighlight lang="bash">
Terminal> doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
</code>
The keywords <code>author</code>, <code>title</code>, and <code>version</code> are used in the headings
of the Sphinx document. By default, <code>version</code> is 1.0 and the script
will try to deduce authors and title from the doconce files <code>file1</code>,
<code>file2</code>, etc. that together represent the whole document. Note that
none of the individual Doconce files <code>file1</code>, <code>file2</code>, etc. should
include the rest as their union makes up the whole document.
The default value of <code>dirname</code> is <code>sphinx-rootdir</code>. The <code>theme</code>
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is <code>'default'</code>).

With a single-file document in <code>mydoc.do.txt</code> one often just runs
<syntaxhighlight lang="bash">
Terminal> doconce sphinx_dir mydoc
</code>
and then an appropriate Sphinx directory <code>sphinx-rootdir</code> is made with
relevant files.

The <code>doconce sphinx_dir</code> command generates a script
<code>automake-sphinx.py</code> for compiling the Sphinx document into an HTML
document.  One can either run <code>automake-sphinx.py</code> or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te <code>doconce sphinx_dir</code> script copies directories named <code>figs</code> or <code>figures</code>
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, <code>automake-sphinx.py</code> must be edited accordingly.
Links to local files (not <code>http:</code> or <code>file:</code> URLs) must be placed
in the <code>_static</code> subdirectory of the Sphinx directory. The
utility <code>doconce sphinxfix_localURLs</code> is run to check for local
links: for each such link, say <code>dir1/dir2/myfile.txt</code> it replaces
the link by <code>_static/myfile.txt</code> and copies <code>dir1/dir2/myfile.txt</code>
to a local <code>_static</code> directory (in the same directory as the
script is run). The user must copy all <code>_static/*</code> files to the
<code>_static</code> subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the <code>_static</code> subdirectory of the Sphinx directory.
It may be wise to place relevant files in a <code>_static</code> directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the <code>conf.py</code>
configuration file for Sphinx is edited accordingly, and a script
<code>make-themes.sh</code> can make HTML documents with one or more themes.
For example,
to realize the themes <code>fenics</code> and <code>pyramid</code>, one writes
<syntaxhighlight lang="bash">
Terminal> ./make-themes.sh fenics pyramid
</code>
The resulting directories with HTML documents are <code>_build/html_fenics</code>
and <code>_build/html_pyramid</code>, respectively. Without arguments,
<code>make-themes.sh</code> makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file <code>mydoc.do.txt</code>.

''Step 1.'' Translate Doconce into the Sphinx format:
<syntaxhighlight lang="bash">
Terminal> doconce format sphinx mydoc
</code>

''Step 2.'' Create a Sphinx root directory
either manually or by using the interactive <code>sphinx-quickstart</code>
program. Here is a scripted version of the steps with the latter:
<syntaxhighlight lang="bash">
mkdir sphinx-rootdir
sphinx-quickstart <<EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
</code>
The autogenerated <code>conf.py</code> file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The <code>doconce sphinx_dir</code> generator makes an extended <code>conv.py</code>
file where, among other things, several useful Sphinx extensions
are included.


''Step 3.'' Copy the <code>mydoc.rst</code> file to the Sphinx root directory:
<syntaxhighlight lang="bash">
Terminal> cp mydoc.rst sphinx-rootdir
</code>
If you have figures in your document, the relative paths to those will
be invalid when you work with <code>mydoc.rst</code> in the <code>sphinx-rootdir</code>
directory. Either edit <code>mydoc.rst</code> so that figure file paths are correct,
or simply copy your figure directories to <code>sphinx-rootdir</code>.
Links to local files in <code>mydoc.rst</code> must be modified to links to
files in the <code>_static</code> directory, see comment above.

''Step 4.'' Edit the generated <code>index.rst</code> file so that <code>mydoc.rst</code>
is included, i.e., add <code>mydoc</code> to the <code>toctree</code> section so that it becomes
<code>
.. toctree::
   :maxdepth: 2

   mydoc
</code>
(The spaces before <code>mydoc</code> are important!)

''Step 5.'' Generate, for instance, an HTML version of the Sphinx source:
<syntaxhighlight lang="bash">
make clean   # remove old versions
make html
</code>

Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with <code>index.html</code> files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

''Step 6.'' View the result:
<syntaxhighlight lang="bash">
Terminal> firefox _build/html/index.html
</code>

Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows <code>!bc</code>: <code>cod</code> gives Python
(<code>code-block:: python</code> in Sphinx syntax) and <code>cppcod</code> gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.

==== Wiki Formats ====

There are many different wiki formats, but Doconce only supports three:
[http://code.google.com/p/support/wiki/WikiSyntax<Google Code> Googlecode wiki], , MediaWiki, and Creole Wiki. These formats are called
<code>gwiki</code>, <code>mwiki</code>, and <code>cwiki</code>, respectively.
Transformation from Doconce to these formats is done by
<syntaxhighlight lang="bash">
Terminal> doconce format gwiki mydoc.do.txt
Terminal> doconce format mwiki mydoc.do.txt
Terminal> doconce format cwiki mydoc.do.txt
</code>

The Googlecode wiki document, <code>mydoc.gwiki</code>, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the <code>.gwiki</code> file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of [http://pediapress.com/code/ mwlib]. This means that one can
easily use Doconce to write [http://en.wikibooks.org Wikibooks]
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.

==== Tweaking the Doconce Output ====

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
<code>.rst</code> file is going to be filtered to LaTeX or HTML, it cannot know
if <code>.eps</code> or <code>.png</code> is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The <code>make.sh</code> files in <code>docs/manual</code> and <code>docs/tutorial</code>
constitute comprehensive examples on how such scripts can be made.

==== Demos ====

The current text is generated from a Doconce format stored in the file
<code>
docs/tutorial/tutorial.do.txt
</code>
The file <code>make.sh</code> in the <code>tutorial</code> directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, <code>tutorial.do.txt</code> is the
starting point.  Running <code>make.sh</code> and studying the various generated
files and comparing them with the original <code>tutorial.do.txt</code> file,
gives a quick introduction to how Doconce is used in a real case.
[https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html Here]
is a sample of how this tutorial looks in different formats.

There is another demo in the <code>docs/manual</code> directory which
translates the more comprehensive documentation, <code>manual.do.txt</code>, to
various formats. The <code>make.sh</code> script runs a set of translations.

==== Dependencies and Installation ====

Doconce itself is pure Python code hosted at http://code.google.com/p/doconce.  Its installation from the
Mercurial (<code>hg</code>) source follows the standard procedure:
<syntaxhighlight lang="bash">
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
</code>

If you make use of the [http://code.google.com/p/preprocess Preprocess]
preprocessor, this program must be installed:
<syntaxhighlight lang="bash">
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
</code>
A much more advanced alternative to Preprocess is
[http://www.makotemplates.org Mako]. Its installation is most
conveniently done by <code>pip</code>,
<syntaxhighlight lang="bash">
pip install Mako
</code>
This command requires <code>pip</code> to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by
<syntaxhighlight lang="bash">
sudo apt-get install python-pip
</code>
Alternatively, one can install from the <code>pip</code> [http://pypi.python.org/pypi/pip source code].

To make LaTeX
documents (without going through the reStructuredText format) you
need [http://code.google.com/p/ptex2tex ptex2tex], which is
installed by
<syntaxhighlight lang="bash">
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
</code>
As seen, <code>cp2texmf.sh</code> copies some special stylefiles that
that <code>ptex2tex</code> potentially makes use of. Some more standard stylefiles
are also needed. These are installed by
<syntaxhighlight lang="bash">
sudo apt-get install texlive-latex-extra
</code>
on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the <code>~/texmf/tex/latex/misc</code> directory).

The ''minted'' LaTeX style is offered by <code>ptex2tex</code> and popular among
users. This style requires the package [http://pygments.org Pygments]:
<syntaxhighlight lang="bash">
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
</code>
If you use the minted style, you have to enable it by running
<code>ptex2tex -DMINTED</code> and then <code>latex -shell-escape</code>, see
the the section [#From_Doconce_to_Other_Formats].

For <code>rst</code> output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs [http://docutils.sourceforge.net docutils].
The installation can be done by
<syntaxhighlight lang="bash">
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
</code>
To use the OpenOffice suite you will typically on Debian systems install
<syntaxhighlight lang="bash">
sudo apt-get install unovonv libreoffice libreoffice-dmaths
</code>

There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
[http://code.google.com/p/rst2pdf rst2pdf]. Either download the tarball
or clone the svn repository, go to the <code>rst2pdf</code> directory and
run <code>sudo python setup.py install</code>.


Output to <code>sphinx</code> requires of course [http://sphinx.pocoo.org Sphinx],
installed by
<syntaxhighlight lang="bash">
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
</code>

When the output format is <code>epydoc</code> one needs that program too, installed
by
<syntaxhighlight lang="bash">
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
</code>

Finally, translation to <code>pandoc</code> requires the
[http://johnmacfarlane.net/pandoc/ Pandoc] program
(written in Haskell) to be installed.
<syntaxhighlight lang="bash">
sudo apt-get install pandoc
</code>

''Remark.'' Several of the packages above installed from source code
are also available in Debian-based system through the
<code>apt-get install</code> command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For <code>svn</code> directories, go to the directory,
run <code>svn update</code>, and then <code>sudo python setup.py install</code>. For
Mercurial (<code>hg</code>) directories, go to the directory, run
<code>hg pull; hg update</code>, and then <code>sudo python setup.py install</code>.
Doconce itself is frequently updated so these commands should be
run regularly.

************** File: tutorial.cwiki *****************
NOT FOUND!
************** File: tutorial.st *****************
TITLE: Doconce: Document Once, Include Anywhere
BY: Hans Petter Langtangen (Simula Research Laboratory, and University of Oslo)DATE: today


 - When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?
 - Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like "http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf":LaTeX, "http://www.htmlcodetutorial.com/":HTML, "http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html":reStructuredText, "http://sphinx.pocoo.org/contents.html":Sphinx, and "http://code.google.com/p/support/wiki/WikiSyntax":wiki? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?
 - Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.

The Doconce Concept

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via 'rst2*' programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via 'unoconv') to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.
 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  - Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.
  - Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.
  - Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.
  - Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).
  - Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.
  - Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  - Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.
  - Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.
  - Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.

What Does Doconce Look Like?

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  - Bullet lists arise from lines starting with an asterisk.
  - *Emphasized words* are surrounded by asterisks.
  - **Words in boldface** are surrounded by underscores.
  - Words from computer code are enclosed in back quotes and
    then typeset 'verbatim (in a monospace font)'.
  - Section headings are recognied by equality ('=') signs before
    and after the title, and the number of '=' signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.
  - Paragraph headings are recognized by a double underscore
    before and after the heading.
  - The abstract of a document starts with *Abstract* as paragraph
    heading, and all text up to the next heading makes up the abstract,
  - Blocks of computer code can easily be included by placing
    '!bc' (begin code) and '!ec' (end code) commands at separate lines
    before and after the code block.
  - Blocks of computer code can also be imported from source files.
  - Blocks of LaTeX mathematics can easily be included by placing
    '!bt' (begin TeX) and '!et' (end TeX) commands at separate lines
    before and after the math block.
  - There is support for both LaTeX and text-like inline mathematics.
  - Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.
  - Invisible comments in the output format can be inserted throughout
    the text.
  - Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).
  - There is special support for advanced exercises features.
  - With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.
  - With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format::


        ===== A Subsection with Sample Text =====
        label{my:first:sec}
        
        Ordinary text looks like ordinary text, and the tags used for
        _boldface_ words, *emphasized* words, and `computer` words look
        natural in plain text.  Lists are typeset as you would do in an email,
        
          * item 1
          * item 2
          * item 3
        
        Lists can also have automatically numbered items instead of bullets,
        
          o item 1
          o item 2
          o item 3
        
        URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
        If the word is URL, the URL itself becomes the link name,
        as in "URL":"tutorial.do.txt".
        
        References to sections may use logical names as labels (e.g., a
        "label" command right after the section title), as in the reference to
        Section ref{my:first:sec}.
        
        Doconce also allows inline comments such as [hpl: here I will make
        some remarks to the text] for allowing authors to make notes. Inline
        comments can be removed from the output by a command-line argument
        (see Section ref{doconce2formats} for an example).
        
        Tables are also supperted, e.g.,
        
          |--------------------------------|
          |time  | velocity | acceleration |
          |---r-------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        
        # lines beginning with # are comment lines

The Doconce text above results in the following little document:

A Subsection with Sample Text

Ordinary text looks like ordinary text, and the tags used for
**boldface** words, *emphasized* words, and 'computer' words look
natural in plain text.  Lists are typeset as you would do in an email,

  - item 1
  - item 2
  - item 3

Lists can also have numbered items instead of bullets, just use an 'o'
(for ordered) instead of the asterisk:

 1. item 1
 2. item 2
 3. item 3

URLs with a link word are possible, as in "http://folk.uio.no/hpl":hpl.
If the word is URL, the URL itself becomes the link name,
as in "tutorial.do.txt":tutorial.do.txt.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section "A Subsection with Sample Text".

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section "From Doconce to Other Formats" for an example).

Tables are also supperted, e.g.,

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  
============  ============  ============  

Mathematics and Computer Code

Inline mathematics, such as v = sin(x),
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like v = sin(x) is
typeset as::


        $\nu = \sin(x)$|$v = sin(x)$

The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
'!bt' and '!et' (begin tex / end tex) instructions.
The result looks like this::

        \begin{eqnarray}
        {\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
        {\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
        \end{eqnarray}

Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
'!bc' and '!ec' instructions, respectively. Such blocks look like::


        from math import sin, pi
        def myfunc(x):
            return sin(pi*x)
        
        import integrate
        I = integrate.trapezoidal(myfunc, 0, pi, 100)

A code block must come after some plain sentence (at least for successful
output to 'sphinx', 'rst', and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., '!bc xxx'
where 'xxx' is an identifier like 'pycod' for code snippet in Python,
'sys' for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in 'ptex2tex' and defined in a
configuration file '.ptext2tex.cfg', while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments)::


        # sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

By default, 'pro' and 'cod' are 'python', 'sys' is 'console',
while 'xpro' and 'xcod' are computer language specific for 'x'
in 'f' (Fortran), 'c' (C), 'cpp' (C++), 'pl' (Perl), 'm' (Matlab),
'sh' (Unix shells), 'cy' (Cython), and 'py' (Python).


One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with '!bc pro', while a part of a file is copied into a '!bc cod'
environment. What 'pro' and 'cod' mean is then defined through
a '.ptex2tex.cfg' file for LaTeX and a 'sphinx code-blocks'
comment for Sphinx.

Another document can be included by writing '#include "mynote.do.txt"'
on a line starting with (another) hash sign.  Doconce documents have
extension 'do.txt'. The 'do' part stands for doconce, while the
trailing '.txt' denotes a text document so that editors gives you the
right writing enviroment for plain text.

Macros (Newcommands), Cross-References, Index, and Bibliography

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
'newcommand_replace.tex' are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names 'newcommands.tex' and
'newcommands_keep.tex' are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
'!bt' and '!et' in 'newcommands_keep.tex' to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
'newcommands_replace.tex' and expanded by Doconce.  The definitions of
newcommands in the 'newcommands*.tex' files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the 'doc/manual/manual.do.txt' file (see the
"https://doconce.googlecode.com/hg/doc/demos/manual/index.html":demo page
for various formats of this document).

From Doconce to Other Formats

Transformation of a Doconce document 'mydoc.do.txt' to various other
formats applies the script 'doconce format':
!bc   sys
        Terminal> doconce format format mydoc.do.txt

or just::


        Terminal> doconce format format mydoc

The 'mako' or 'preprocess' programs are always used to preprocess the
file first, and options to 'mako' or 'preprocess' can be added after the
filename. For example::


        Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
        Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako

The variable 'FORMAT' is always defined as the current format when
running 'preprocess'. That is, in the last example, 'FORMAT' is
defined as 'latex'. Inside the Doconce document one can then perform
format specific actions through tests like '#if FORMAT == "latex"'.

Inline comments in the text are removed from the output by::


        Terminal> doconce format latex mydoc --skip_inline_comments

One can also remove all such comments from the original Doconce
file by running::


        Terminal> doconce remove_inline_comments mydoc

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

HTML

Making an HTML version of a Doconce file 'mydoc.do.txt'
is performed by::


        Terminal> doconce format html mydoc

The resulting file 'mydoc.html' can be loaded into any web browser for viewing.

Pandoc

Output in Pandoc's extended Markdown format results from::


        Terminal> doconce format pandoc mydoc

The name of the output file is 'mydoc.mkd'.
From this format one can go to numerous other formats::


        Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd

Pandoc supports 'latex', 'html', 'odt' (OpenOffice), 'docx' (Microsoft
Word), 'rtf', 'texinfo', to mention some. The '-R' option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the "http://johnmacfarlane.net/pandoc/README.html":Pandoc documentation
for the many features of the 'pandoc' program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
'doconce format pandoc' and then translating using 'pandoc', or
'doconce format latex', and then going from LaTeX to the desired format
using 'pandoc'.
Here is an example on the latter strategy::


        Terminal> doconce format latex mydoc
        Terminal> doconce ptex2tex mydoc
        Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex

When we go through 'pandoc', only single equations or 'align*'
environments are well understood.

Quite some 'doconce replace' and 'doconce subst' edits might be needed
on the '.mkd' or '.tex' files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax::


        Terminal> doconce format pandoc mydoc
        Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd

The '-s' option adds a proper header and footer to the 'mydoc.html' file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

LaTeX

Making a LaTeX file 'mydoc.tex' from 'mydoc.do.txt' is done in two steps:

*Step 1.* Filter the doconce text to a pre-LaTeX form 'mydoc.p.tex' for
     'ptex2tex':
!bc   sys
        Terminal> doconce format latex mydoc

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files 'newcommands.tex', 'newcommands_keep.tex', or
'newcommands_replace.tex' (see the section "Macros (Newcommands), Cross-References, Index, and Bibliography").
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run 'ptex2tex' (if you have it) to make a standard LaTeX file::


        Terminal> ptex2tex mydoc

In case you do not have 'ptex2tex', you may run a (very) simplified version::


        Terminal> doconce ptex2tex mydoc


Note that Doconce generates a '.p.tex' file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run::


        Terminal> ptex2tex -DHELVETICA mydoc

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through::


        Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc

A separate titlepage can be generate by::


        Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc


The 'ptex2tex' tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any '!bc' command in the Doconce source you can
insert verbatim block styles as defined in your '.ptex2tex.cfg'
file, e.g., '!bc cod' for a code snippet, where 'cod' is set to
a certain environment in '.ptex2tex.cfg' (e.g., 'CodeIntended').
There are about 40 styles to choose from.

Also the 'doconce ptex2tex' command supports preprocessor directives
for processing the '.p.tex' file. The command allows specifications
of code environments as well. Here is an example::


        Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
                  cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
                  fpro=minted fcod=minted sys=verbatim

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
'verbatim' above, which implies '\begin{verbatim}' and '\end{verbatim}').
The value 'minted' can be used for code environments where the
language is specified, as in 'fpro', where 'minted' implies
'\begin{python}{fortran}'. There is a similar support for 'ans':
'cppcod=ans' imples '\begin{c++}' and '\end{c++}' using the
'anslistings' package.

*Step 2b (optional).* Edit the 'mydoc.tex' file to your needs.
For example, you may want to substitute 'section' by 'section*' to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the 'doconce replace' and 'doconce subst'
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples::


        Terminal> doconce replace 'section{' 'section*{' mydoc.tex
        Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
                  'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile 'mydoc.tex'
and create the PDF file::


        Terminal> latex mydoc
        Terminal> latex mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex mydoc
        Terminal> dvipdf mydoc

If one wishes to use the 'Minted_Python', 'Minted_Cpp', etc.,
environments in 'ptex2tex' for typesetting code (specified, e.g., in
the '*pro' and '*cod' environments in '.ptex2tex.cfg' or
'$HOME/.ptex2tex.cfg'), the 'minted' LaTeX package is needed.  This
package is included by running 'doconce format' with the '-DMINTED'
option::


        Terminal> ptex2tex -DMINTED mydoc

In this case, 'latex' must be run with the
'-shell-escape' option::


        Terminal> latex -shell-escape mydoc
        Terminal> latex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex -shell-escape mydoc
        Terminal> dvipdf mydoc


PDFLaTeX

Running 'pdflatex' instead of 'latex' follows almost the same steps,
but the start is::


        Terminal> doconce format latex mydoc

Then 'ptex2tex' is run as explained above, and finally::


        Terminal> pdflatex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> pdflatex -shell-escape mydoc


Plain ASCII Text

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code::


        Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt


reStructuredText

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file 'mydoc.rst':
!bc   sys
        Terminal> doconce format rst mydoc.do.txt

We may now produce various other formats::


        Terminal> rst2html.py  mydoc.rst > mydoc.html # html
        Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
        Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
        Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice


The OpenOffice file 'mydoc.odt' can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program 'unovonv'
to convert between the many formats OpenOffice supports *on the command line*.
Run::


        Terminal> unoconv --show

to see all the formats that are supported.
For example, the following commands take
'mydoc.odt' to Microsoft Office Open XML format,
classic MS Word format, and PDF::


        Terminal> unoconv -f ooxml mydoc.odt
        Terminal> unoconv -f doc mydoc.odt
        Terminal> unoconv -f pdf mydoc.odt


*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by 'latex' as
output and to a wide extent also supported by the 'sphinx' output format.
Some links for going from LaTeX to Word are listed below.

 - "http://ubuntuforums.org/showthread.php?t=1033441":http://ubuntuforums.org/showthread.php?t=1033441
 - "http://tug.org/utilities/texconv/textopc.html":http://tug.org/utilities/texconv/textopc.html
 - "http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html":http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html

Sphinx

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the 'doconce sphinx_dir' command::


        Terminal> doconce sphinx_dir author="authors' names" \
                  title="some title" version=1.0 dirname=sphinxdir \
                  theme=mytheme file1 file2 file3 ...

The keywords 'author', 'title', and 'version' are used in the headings
of the Sphinx document. By default, 'version' is 1.0 and the script
will try to deduce authors and title from the doconce files 'file1',
'file2', etc. that together represent the whole document. Note that
none of the individual Doconce files 'file1', 'file2', etc. should
include the rest as their union makes up the whole document.
The default value of 'dirname' is 'sphinx-rootdir'. The 'theme'
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is ''default'').

With a single-file document in 'mydoc.do.txt' one often just runs::


        Terminal> doconce sphinx_dir mydoc

and then an appropriate Sphinx directory 'sphinx-rootdir' is made with
relevant files.

The 'doconce sphinx_dir' command generates a script
'automake-sphinx.py' for compiling the Sphinx document into an HTML
document.  One can either run 'automake-sphinx.py' or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te 'doconce sphinx_dir' script copies directories named 'figs' or 'figures'
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, 'automake-sphinx.py' must be edited accordingly.
Links to local files (not 'http:' or 'file:' URLs) must be placed
in the '_static' subdirectory of the Sphinx directory. The
utility 'doconce sphinxfix_localURLs' is run to check for local
links: for each such link, say 'dir1/dir2/myfile.txt' it replaces
the link by '_static/myfile.txt' and copies 'dir1/dir2/myfile.txt'
to a local '_static' directory (in the same directory as the
script is run). The user must copy all '_static/*' files to the
'_static' subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the '_static' subdirectory of the Sphinx directory.
It may be wise to place relevant files in a '_static' directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the 'conf.py'
configuration file for Sphinx is edited accordingly, and a script
'make-themes.sh' can make HTML documents with one or more themes.
For example,
to realize the themes 'fenics' and 'pyramid', one writes::


        Terminal> ./make-themes.sh fenics pyramid

The resulting directories with HTML documents are '_build/html_fenics'
and '_build/html_pyramid', respectively. Without arguments,
'make-themes.sh' makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file 'mydoc.do.txt'.

*Step 1.* Translate Doconce into the Sphinx format::


        Terminal> doconce format sphinx mydoc


*Step 2.* Create a Sphinx root directory
either manually or by using the interactive 'sphinx-quickstart'
program. Here is a scripted version of the steps with the latter::


        mkdir sphinx-rootdir
        sphinx-quickstart <<EOF
        sphinx-rootdir
        n
        _
        Name of My Sphinx Document
        Author
        version
        version
        .rst
        index
        n
        y
        n
        n
        n
        n
        y
        n
        n
        y
        y
        y
        EOF

The autogenerated 'conf.py' file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The 'doconce sphinx_dir' generator makes an extended 'conv.py'
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the 'mydoc.rst' file to the Sphinx root directory::


        Terminal> cp mydoc.rst sphinx-rootdir

If you have figures in your document, the relative paths to those will
be invalid when you work with 'mydoc.rst' in the 'sphinx-rootdir'
directory. Either edit 'mydoc.rst' so that figure file paths are correct,
or simply copy your figure directories to 'sphinx-rootdir'.
Links to local files in 'mydoc.rst' must be modified to links to
files in the '_static' directory, see comment above.

*Step 4.* Edit the generated 'index.rst' file so that 'mydoc.rst'
is included, i.e., add 'mydoc' to the 'toctree' section so that it becomes::


        .. toctree::
           :maxdepth: 2
        
           mydoc

(The spaces before 'mydoc' are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source::


        make clean   # remove old versions
        make html


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with 'index.html' files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result::


        Terminal> firefox _build/html/index.html


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows '!bc': 'cod' gives Python
('code-block:: python' in Sphinx syntax) and 'cppcod' gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.

Wiki Formats

There are many different wiki formats, but Doconce only supports three:
"http://code.google.com/p/support/wiki/WikiSyntax<Google Code>":Googlecode wiki, , MediaWiki, and Creole Wiki. These formats are called
'gwiki', 'mwiki', and 'cwiki', respectively.
Transformation from Doconce to these formats is done by::


        Terminal> doconce format gwiki mydoc.do.txt
        Terminal> doconce format mwiki mydoc.do.txt
        Terminal> doconce format cwiki mydoc.do.txt


The Googlecode wiki document, 'mydoc.gwiki', is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the '.gwiki' file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of "http://pediapress.com/code/":mwlib. This means that one can
easily use Doconce to write "http://en.wikibooks.org":Wikibooks
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.

Tweaking the Doconce Output

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
'.rst' file is going to be filtered to LaTeX or HTML, it cannot know
if '.eps' or '.png' is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The 'make.sh' files in 'docs/manual' and 'docs/tutorial'
constitute comprehensive examples on how such scripts can be made.

Demos

The current text is generated from a Doconce format stored in the file::


        docs/tutorial/tutorial.do.txt

The file 'make.sh' in the 'tutorial' directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, 'tutorial.do.txt' is the
starting point.  Running 'make.sh' and studying the various generated
files and comparing them with the original 'tutorial.do.txt' file,
gives a quick introduction to how Doconce is used in a real case.
"https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html":Here
is a sample of how this tutorial looks in different formats.

There is another demo in the 'docs/manual' directory which
translates the more comprehensive documentation, 'manual.do.txt', to
various formats. The 'make.sh' script runs a set of translations.

Dependencies and Installation

Doconce itself is pure Python code hosted at "http://code.google.com/p/doconce":http://code.google.com/p/doconce.  Its installation from the
Mercurial ('hg') source follows the standard procedure::


        # Doconce
        hg clone https://doconce.googlecode.com/hg/ doconce
        cd doconce
        sudo python setup.py install
        cd ..


If you make use of the "http://code.google.com/p/preprocess":Preprocess
preprocessor, this program must be installed::


        svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
        cd preprocess
        cd doconce
        sudo python setup.py install
        cd ..

A much more advanced alternative to Preprocess is
"http://www.makotemplates.org":Mako. Its installation is most
conveniently done by 'pip',
!bc   sys
        pip install Mako

This command requires 'pip' to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by::


        sudo apt-get install python-pip

Alternatively, one can install from the 'pip' "http://pypi.python.org/pypi/pip":source code.

To make LaTeX
documents (without going through the reStructuredText format) you
need "http://code.google.com/p/ptex2tex":ptex2tex, which is
installed by::


        svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
        cd ptex2tex
        sudo python setup.py install
        cd latex
        sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
        cd ../..

As seen, 'cp2texmf.sh' copies some special stylefiles that
that 'ptex2tex' potentially makes use of. Some more standard stylefiles
are also needed. These are installed by::


        sudo apt-get install texlive-latex-extra

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the '~/texmf/tex/latex/misc' directory).

The *minted* LaTeX style is offered by 'ptex2tex' and popular among
users. This style requires the package "http://pygments.org":Pygments::


        hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
        cd pygments
        sudo python setup.py install

If you use the minted style, you have to enable it by running
'ptex2tex -DMINTED' and then 'latex -shell-escape', see
the the section "From Doconce to Other Formats".

For 'rst' output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs "http://docutils.sourceforge.net":docutils.
The installation can be done by::


        svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
        cd docutils
        sudo python setup.py install
        cd ..

To use the OpenOffice suite you will typically on Debian systems install::


        sudo apt-get install unovonv libreoffice libreoffice-dmaths


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
"http://code.google.com/p/rst2pdf":rst2pdf. Either download the tarball
or clone the svn repository, go to the 'rst2pdf' directory and
run 'sudo python setup.py install'.


Output to 'sphinx' requires of course "http://sphinx.pocoo.org":Sphinx,
installed by::


        hg clone https://bitbucket.org/birkenfeld/sphinx
        cd sphinx
        sudo python setup.py install
        cd ..


When the output format is 'epydoc' one needs that program too, installed
by::


        svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
        cd epydoc
        sudo make install
        cd ..


Finally, translation to 'pandoc' requires the
"http://johnmacfarlane.net/pandoc/":Pandoc program
(written in Haskell) to be installed::


        sudo apt-get install pandoc


*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
'apt-get install' command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For 'svn' directories, go to the directory,
run 'svn update', and then 'sudo python setup.py install'. For
Mercurial ('hg') directories, go to the directory, run
'hg pull; hg update', and then 'sudo python setup.py install'.
Doconce itself is frequently updated so these commands should be
run regularly.
************** File: tutorial.epytext *****************
TITLE: Doconce: Document Once, Include Anywhere
BY: Hans Petter Langtangen (Simula Research Laboratory, and University of Oslo)DATE: today


 - When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?
 - Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like U{LaTeX<http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf>}, U{HTML<http://www.htmlcodetutorial.com/>}, U{reStructuredText<http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html>}, U{Sphinx<http://sphinx.pocoo.org/contents.html>}, and U{wiki<http://code.google.com/p/support/wiki/WikiSyntax>}? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?
 - Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.


The Doconce Concept
===================

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via C{rst2*} programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via C{unoconv}) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.
 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  - Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.
  - Doconce can be converted to plain I{untagged} text,
    often desirable for computer programs and email.
  - Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.
  - Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).
  - Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.
  - Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  - Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.
  - Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.
  - Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



What Does Doconce Look Like?
============================

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  - Bullet lists arise from lines starting with an asterisk.
  - I{Emphasized words} are surrounded by asterisks.
  - B{Words in boldface} are surrounded by underscores.
  - Words from computer code are enclosed in back quotes and
    then typeset C{verbatim (in a monospace font)}.
  - Section headings are recognied by equality (C{=}) signs before
    and after the title, and the number of C{=} signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.
  - Paragraph headings are recognized by a double underscore
    before and after the heading.
  - The abstract of a document starts with I{Abstract} as paragraph
    heading, and all text up to the next heading makes up the abstract,
  - Blocks of computer code can easily be included by placing
    C{!bc} (begin code) and C{!ec} (end code) commands at separate lines
    before and after the code block.
  - Blocks of computer code can also be imported from source files.
  - Blocks of LaTeX mathematics can easily be included by placing
    C{!bt} (begin TeX) and C{!et} (end TeX) commands at separate lines
    before and after the math block.
  - There is support for both LaTeX and text-like inline mathematics.
  - Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.
  - Invisible comments in the output format can be inserted throughout
    the text.
  - Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).
  - There is special support for advanced exercises features.
  - With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.
  - With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format::


        ===== A Subsection with Sample Text =====
        label{my:first:sec}
        
        Ordinary text looks like ordinary text, and the tags used for
        _boldface_ words, *emphasized* words, and `computer` words look
        natural in plain text.  Lists are typeset as you would do in an email,
        
          * item 1
          * item 2
          * item 3
        
        Lists can also have automatically numbered items instead of bullets,
        
          o item 1
          o item 2
          o item 3
        
        URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
        If the word is URL, the URL itself becomes the link name,
        as in "URL":"tutorial.do.txt".
        
        References to sections may use logical names as labels (e.g., a
        "label" command right after the section title), as in the reference to
        Section ref{my:first:sec}.
        
        Doconce also allows inline comments such as [hpl: here I will make
        some remarks to the text] for allowing authors to make notes. Inline
        comments can be removed from the output by a command-line argument
        (see Section ref{doconce2formats} for an example).
        
        Tables are also supperted, e.g.,
        
          |--------------------------------|
          |time  | velocity | acceleration |
          |---r-------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        
        # lines beginning with # are comment lines

The Doconce text above results in the following little document:

A Subsection with Sample Text
-----------------------------

Ordinary text looks like ordinary text, and the tags used for
B{boldface} words, I{emphasized} words, and C{computer} words look
natural in plain text.  Lists are typeset as you would do in an email,

  - item 1
  - item 2
  - item 3

Lists can also have numbered items instead of bullets, just use an C{o}
(for ordered) instead of the asterisk:

 1. item 1
 2. item 2
 3. item 3

URLs with a link word are possible, as in U{hpl<http://folk.uio.no/hpl>}.
If the word is URL, the URL itself becomes the link name,
as in U{tutorial.do.txt<tutorial.do.txt>}.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section "A Subsection with Sample Text".

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section "From Doconce to Other Formats" for an example).

Tables are also supperted, e.g.,

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  
============  ============  ============  

Mathematics and Computer Code
-----------------------------

Inline mathematics, such as M{v = sin(x)},
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like M{v = sin(x)} is
typeset as::



            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.


The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
C{!bt} and C{!et} (begin tex / end tex) instructions.
The result looks like this::


            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.


Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
C{!bc} and C{!ec} instructions, respectively. Such blocks look like::


        from math import sin, pi
        def myfunc(x):
            return sin(pi*x)
        
        import integrate
        I = integrate.trapezoidal(myfunc, 0, pi, 100)

A code block must come after some plain sentence (at least for successful
output to C{sphinx}, C{rst}, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., C{!bc xxx}
where C{xxx} is an identifier like C{pycod} for code snippet in Python,
C{sys} for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in C{ptex2tex} and defined in a
configuration file C{.ptext2tex.cfg}, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments)::


        # sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

By default, C{pro} and C{cod} are C{python}, C{sys} is C{console},
while C{xpro} and C{xcod} are computer language specific for C{x}
in C{f} (Fortran), C{c} (C), C{cpp} (C++), C{pl} (Perl), C{m} (Matlab),
C{sh} (Unix shells), C{cy} (Cython), and C{py} (Python).


One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with C{!bc pro}, while a part of a file is copied into a C{!bc cod}
environment. What C{pro} and C{cod} mean is then defined through
a C{.ptex2tex.cfg} file for LaTeX and a C{sphinx code-blocks}
comment for Sphinx.

Another document can be included by writing C{#include "mynote.do.txt"}
on a line starting with (another) hash sign.  Doconce documents have
extension C{do.txt}. The C{do} part stands for doconce, while the
trailing C{.txt} denotes a text document so that editors gives you the
right writing enviroment for plain text.


Macros (Newcommands), Cross-References, Index, and Bibliography
---------------------------------------------------------------

Doconce supports a type of macros via a LaTeX-style I{newcommand}
construction.  The newcommands defined in a file with name
C{newcommand_replace.tex} are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names C{newcommands.tex} and
C{newcommands_keep.tex} are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
C{!bt} and C{!et} in C{newcommands_keep.tex} to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
C{newcommands_replace.tex} and expanded by Doconce.  The definitions of
newcommands in the C{newcommands*.tex} files I{must} appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the C{doc/manual/manual.do.txt} file (see the
U{demo page<https://doconce.googlecode.com/hg/doc/demos/manual/index.html>}
for various formats of this document).




From Doconce to Other Formats
=============================

Transformation of a Doconce document C{mydoc.do.txt} to various other
formats applies the script C{doconce format}::


        Terminal> doconce format format mydoc.do.txt

or just::


        Terminal> doconce format format mydoc

The C{mako} or C{preprocess} programs are always used to preprocess the
file first, and options to C{mako} or C{preprocess} can be added after the
filename. For example::


        Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
        Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako

The variable C{FORMAT} is always defined as the current format when
running C{preprocess}. That is, in the last example, C{FORMAT} is
defined as C{latex}. Inside the Doconce document one can then perform
format specific actions through tests like C{#if FORMAT == "latex"}.

Inline comments in the text are removed from the output by::


        Terminal> doconce format latex mydoc --skip_inline_comments

One can also remove all such comments from the original Doconce
file by running::


        Terminal> doconce remove_inline_comments mydoc

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


HTML
----

Making an HTML version of a Doconce file C{mydoc.do.txt}
is performed by::


        Terminal> doconce format html mydoc

The resulting file C{mydoc.html} can be loaded into any web browser for viewing.

Pandoc
------

Output in Pandoc's extended Markdown format results from::


        Terminal> doconce format pandoc mydoc

The name of the output file is C{mydoc.mkd}.
From this format one can go to numerous other formats::


        Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd

Pandoc supports C{latex}, C{html}, C{odt} (OpenOffice), C{docx} (Microsoft
Word), C{rtf}, C{texinfo}, to mention some. The C{-R} option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the U{Pandoc documentation<http://johnmacfarlane.net/pandoc/README.html>}
for the many features of the C{pandoc} program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
C{doconce format pandoc} and then translating using C{pandoc}, or
C{doconce format latex}, and then going from LaTeX to the desired format
using C{pandoc}.
Here is an example on the latter strategy::


        Terminal> doconce format latex mydoc
        Terminal> doconce ptex2tex mydoc
        Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex

When we go through C{pandoc}, only single equations or C{align*}
environments are well understood.

Quite some C{doconce replace} and C{doconce subst} edits might be needed
on the C{.mkd} or C{.tex} files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax::


        Terminal> doconce format pandoc mydoc
        Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd

The C{-s} option adds a proper header and footer to the C{mydoc.html} file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


LaTeX
-----

Making a LaTeX file C{mydoc.tex} from C{mydoc.do.txt} is done in two steps:

I{Step 1.} Filter the doconce text to a pre-LaTeX form C{mydoc.p.tex} for
     C{ptex2tex}::


        Terminal> doconce format latex mydoc

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files C{newcommands.tex}, C{newcommands_keep.tex}, or
C{newcommands_replace.tex} (see the section "Macros (Newcommands), Cross-References, Index, and Bibliography").
If these files are present, they are included in the LaTeX document
so that your commands are defined.

I{Step 2.} Run C{ptex2tex} (if you have it) to make a standard LaTeX file::


        Terminal> ptex2tex mydoc

In case you do not have C{ptex2tex}, you may run a (very) simplified version::


        Terminal> doconce ptex2tex mydoc


Note that Doconce generates a C{.p.tex} file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run::


        Terminal> ptex2tex -DHELVETICA mydoc

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through::


        Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc

A separate titlepage can be generate by::


        Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc


The C{ptex2tex} tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any C{!bc} command in the Doconce source you can
insert verbatim block styles as defined in your C{.ptex2tex.cfg}
file, e.g., C{!bc cod} for a code snippet, where C{cod} is set to
a certain environment in C{.ptex2tex.cfg} (e.g., C{CodeIntended}).
There are about 40 styles to choose from.

Also the C{doconce ptex2tex} command supports preprocessor directives
for processing the C{.p.tex} file. The command allows specifications
of code environments as well. Here is an example::


        Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
                  cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
                  fpro=minted fcod=minted sys=verbatim

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
C{verbatim} above, which implies C{\begin{verbatim}} and C{\end{verbatim}}).
The value C{minted} can be used for code environments where the
language is specified, as in C{fpro}, where C{minted} implies
C{\begin{python}{fortran}}. There is a similar support for C{ans}:
C{cppcod=ans} imples C{\begin{c++}} and C{\end{c++}} using the
C{anslistings} package.

I{Step 2b (optional).} Edit the C{mydoc.tex} file to your needs.
For example, you may want to substitute C{section} by C{section*} to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the C{doconce replace} and C{doconce subst}
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples::


        Terminal> doconce replace 'section{' 'section*{' mydoc.tex
        Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
                  'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

I{Step 3.} Compile C{mydoc.tex}
and create the PDF file::


        Terminal> latex mydoc
        Terminal> latex mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex mydoc
        Terminal> dvipdf mydoc

If one wishes to use the C{Minted_Python}, C{Minted_Cpp}, etc.,
environments in C{ptex2tex} for typesetting code (specified, e.g., in
the C{*pro} and C{*cod} environments in C{.ptex2tex.cfg} or
C{$HOME/.ptex2tex.cfg}), the C{minted} LaTeX package is needed.  This
package is included by running C{doconce format} with the C{-DMINTED}
option::


        Terminal> ptex2tex -DMINTED mydoc

In this case, C{latex} must be run with the
C{-shell-escape} option::


        Terminal> latex -shell-escape mydoc
        Terminal> latex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex -shell-escape mydoc
        Terminal> dvipdf mydoc



PDFLaTeX
--------

Running C{pdflatex} instead of C{latex} follows almost the same steps,
but the start is::


        Terminal> doconce format latex mydoc

Then C{ptex2tex} is run as explained above, and finally::


        Terminal> pdflatex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> pdflatex -shell-escape mydoc


Plain ASCII Text
----------------

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code::


        Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt


reStructuredText
----------------

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file C{mydoc.rst}::


        Terminal> doconce format rst mydoc.do.txt

We may now produce various other formats::


        Terminal> rst2html.py  mydoc.rst > mydoc.html # html
        Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
        Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
        Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice


The OpenOffice file C{mydoc.odt} can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program C{unovonv}
to convert between the many formats OpenOffice supports I{on the command line}.
Run::


        Terminal> unoconv --show

to see all the formats that are supported.
For example, the following commands take
C{mydoc.odt} to Microsoft Office Open XML format,
classic MS Word format, and PDF::


        Terminal> unoconv -f ooxml mydoc.odt
        Terminal> unoconv -f doc mydoc.odt
        Terminal> unoconv -f pdf mydoc.odt


I{Remark about Mathematical Typesetting.} At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by C{latex} as
output and to a wide extent also supported by the C{sphinx} output format.
Some links for going from LaTeX to Word are listed below.

 - U{http://ubuntuforums.org/showthread.php?t=1033441<http://ubuntuforums.org/showthread.php?t=1033441>}
 - U{http://tug.org/utilities/texconv/textopc.html<http://tug.org/utilities/texconv/textopc.html>}
 - U{http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html<http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html>}

Sphinx
------

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the C{doconce sphinx_dir} command::


        Terminal> doconce sphinx_dir author="authors' names" \
                  title="some title" version=1.0 dirname=sphinxdir \
                  theme=mytheme file1 file2 file3 ...

The keywords C{author}, C{title}, and C{version} are used in the headings
of the Sphinx document. By default, C{version} is 1.0 and the script
will try to deduce authors and title from the doconce files C{file1},
C{file2}, etc. that together represent the whole document. Note that
none of the individual Doconce files C{file1}, C{file2}, etc. should
include the rest as their union makes up the whole document.
The default value of C{dirname} is C{sphinx-rootdir}. The C{theme}
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is C{'default'}).

With a single-file document in C{mydoc.do.txt} one often just runs::


        Terminal> doconce sphinx_dir mydoc

and then an appropriate Sphinx directory C{sphinx-rootdir} is made with
relevant files.

The C{doconce sphinx_dir} command generates a script
C{automake-sphinx.py} for compiling the Sphinx document into an HTML
document.  One can either run C{automake-sphinx.py} or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te C{doconce sphinx_dir} script copies directories named C{figs} or C{figures}
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, C{automake-sphinx.py} must be edited accordingly.
Links to local files (not C{http:} or C{file:} URLs) must be placed
in the C{_static} subdirectory of the Sphinx directory. The
utility C{doconce sphinxfix_localURLs} is run to check for local
links: for each such link, say C{dir1/dir2/myfile.txt} it replaces
the link by C{_static/myfile.txt} and copies C{dir1/dir2/myfile.txt}
to a local C{_static} directory (in the same directory as the
script is run). The user must copy all C{_static/*} files to the
C{_static} subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the C{_static} subdirectory of the Sphinx directory.
It may be wise to place relevant files in a C{_static} directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the C{conf.py}
configuration file for Sphinx is edited accordingly, and a script
C{make-themes.sh} can make HTML documents with one or more themes.
For example,
to realize the themes C{fenics} and C{pyramid}, one writes::


        Terminal> ./make-themes.sh fenics pyramid

The resulting directories with HTML documents are C{_build/html_fenics}
and C{_build/html_pyramid}, respectively. Without arguments,
C{make-themes.sh} makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file C{mydoc.do.txt}.

I{Step 1.} Translate Doconce into the Sphinx format::


        Terminal> doconce format sphinx mydoc


I{Step 2.} Create a Sphinx root directory
either manually or by using the interactive C{sphinx-quickstart}
program. Here is a scripted version of the steps with the latter::


        mkdir sphinx-rootdir
        sphinx-quickstart <<EOF
        sphinx-rootdir
        n
        _
        Name of My Sphinx Document
        Author
        version
        version
        .rst
        index
        n
        y
        n
        n
        n
        n
        y
        n
        n
        y
        y
        y
        EOF

The autogenerated C{conf.py} file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The C{doconce sphinx_dir} generator makes an extended C{conv.py}
file where, among other things, several useful Sphinx extensions
are included.


I{Step 3.} Copy the C{mydoc.rst} file to the Sphinx root directory::


        Terminal> cp mydoc.rst sphinx-rootdir

If you have figures in your document, the relative paths to those will
be invalid when you work with C{mydoc.rst} in the C{sphinx-rootdir}
directory. Either edit C{mydoc.rst} so that figure file paths are correct,
or simply copy your figure directories to C{sphinx-rootdir}.
Links to local files in C{mydoc.rst} must be modified to links to
files in the C{_static} directory, see comment above.

I{Step 4.} Edit the generated C{index.rst} file so that C{mydoc.rst}
is included, i.e., add C{mydoc} to the C{toctree} section so that it becomes::


        .. toctree::
           :maxdepth: 2
        
           mydoc

(The spaces before C{mydoc} are important!)

I{Step 5.} Generate, for instance, an HTML version of the Sphinx source::


        make clean   # remove old versions
        make html


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with C{index.html} files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

I{Step 6.} View the result::


        Terminal> firefox _build/html/index.html


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows C{!bc}: C{cod} gives Python
(C{code-block:: python} in Sphinx syntax) and C{cppcod} gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


Wiki Formats
------------

There are many different wiki formats, but Doconce only supports three:
U{Googlecode wiki<http://code.google.com/p/support/wiki/WikiSyntax<Google Code>>}, , MediaWiki, and Creole Wiki. These formats are called
C{gwiki}, C{mwiki}, and C{cwiki}, respectively.
Transformation from Doconce to these formats is done by::


        Terminal> doconce format gwiki mydoc.do.txt
        Terminal> doconce format mwiki mydoc.do.txt
        Terminal> doconce format cwiki mydoc.do.txt


The Googlecode wiki document, C{mydoc.gwiki}, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the C{.gwiki} file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of U{mwlib<http://pediapress.com/code/>}. This means that one can
easily use Doconce to write U{Wikibooks<http://en.wikibooks.org>}
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


Tweaking the Doconce Output
---------------------------

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
C{.rst} file is going to be filtered to LaTeX or HTML, it cannot know
if C{.eps} or C{.png} is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The C{make.sh} files in C{docs/manual} and C{docs/tutorial}
constitute comprehensive examples on how such scripts can be made.


Demos
-----

The current text is generated from a Doconce format stored in the file::


        docs/tutorial/tutorial.do.txt

The file C{make.sh} in the C{tutorial} directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, C{tutorial.do.txt} is the
starting point.  Running C{make.sh} and studying the various generated
files and comparing them with the original C{tutorial.do.txt} file,
gives a quick introduction to how Doconce is used in a real case.
U{Here<https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html>}
is a sample of how this tutorial looks in different formats.

There is another demo in the C{docs/manual} directory which
translates the more comprehensive documentation, C{manual.do.txt}, to
various formats. The C{make.sh} script runs a set of translations.

Dependencies and Installation
-----------------------------

Doconce itself is pure Python code hosted at U{http://code.google.com/p/doconce<http://code.google.com/p/doconce>}.  Its installation from the
Mercurial (C{hg}) source follows the standard procedure::


        # Doconce
        hg clone https://doconce.googlecode.com/hg/ doconce
        cd doconce
        sudo python setup.py install
        cd ..


If you make use of the U{Preprocess<http://code.google.com/p/preprocess>}
preprocessor, this program must be installed::


        svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
        cd preprocess
        cd doconce
        sudo python setup.py install
        cd ..

A much more advanced alternative to Preprocess is
U{Mako<http://www.makotemplates.org>}. Its installation is most
conveniently done by C{pip}::


        pip install Mako

This command requires C{pip} to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by::


        sudo apt-get install python-pip

Alternatively, one can install from the C{pip} U{source code<http://pypi.python.org/pypi/pip>}.

To make LaTeX
documents (without going through the reStructuredText format) you
need U{ptex2tex<http://code.google.com/p/ptex2tex>}, which is
installed by::


        svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
        cd ptex2tex
        sudo python setup.py install
        cd latex
        sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
        cd ../..

As seen, C{cp2texmf.sh} copies some special stylefiles that
that C{ptex2tex} potentially makes use of. Some more standard stylefiles
are also needed. These are installed by::


        sudo apt-get install texlive-latex-extra

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the C{~/texmf/tex/latex/misc} directory).

The I{minted} LaTeX style is offered by C{ptex2tex} and popular among
users. This style requires the package U{Pygments<http://pygments.org>}::


        hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
        cd pygments
        sudo python setup.py install

If you use the minted style, you have to enable it by running
C{ptex2tex -DMINTED} and then C{latex -shell-escape}, see
the the section "From Doconce to Other Formats".

For C{rst} output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs U{docutils<http://docutils.sourceforge.net>}.
The installation can be done by::


        svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
        cd docutils
        sudo python setup.py install
        cd ..

To use the OpenOffice suite you will typically on Debian systems install::


        sudo apt-get install unovonv libreoffice libreoffice-dmaths


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
U{rst2pdf<http://code.google.com/p/rst2pdf>}. Either download the tarball
or clone the svn repository, go to the C{rst2pdf} directory and
run C{sudo python setup.py install}.


Output to C{sphinx} requires of course U{Sphinx<http://sphinx.pocoo.org>},
installed by::


        hg clone https://bitbucket.org/birkenfeld/sphinx
        cd sphinx
        sudo python setup.py install
        cd ..


When the output format is C{epydoc} one needs that program too, installed
by::


        svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
        cd epydoc
        sudo make install
        cd ..


Finally, translation to C{pandoc} requires the
U{Pandoc<http://johnmacfarlane.net/pandoc/>} program
(written in Haskell) to be installed::


        sudo apt-get install pandoc


I{Remark.} Several of the packages above installed from source code
are also available in Debian-based system through the
C{apt-get install} command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For C{svn} directories, go to the directory,
run C{svn update}, and then C{sudo python setup.py install}. For
Mercurial (C{hg}) directories, go to the directory, run
C{hg pull; hg update}, and then C{sudo python setup.py install}.
Doconce itself is frequently updated so these commands should be
run regularly.
************** File: tutorial.txt *****************
Doconce: Document Once, Include Anywhere
========================================

Hans Petter Langtangen [1, 2] 

[1] Simula Research Laboratory
[2] University of Oslo


Date: Jan 32, 2100

 * When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?

 * Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like LaTeX (http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf), HTML (http://www.htmlcodetutorial.com/), reStructuredText (http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html), Sphinx (http://sphinx.pocoo.org/contents.html), and wiki (http://code.google.com/p/support/wiki/WikiSyntax)? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?

 * Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.


The Doconce Concept
===================

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via rst2* programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via unoconv) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  * Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.

  * Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.

  * Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  * Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).

  * Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  * Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  * Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  * Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.

  * Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



What Does Doconce Look Like?
============================

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  * Bullet lists arise from lines starting with an asterisk.

  * *Emphasized words* are surrounded by asterisks.

  * _Words in boldface_ are surrounded by underscores.

  * Words from computer code are enclosed in back quotes and
    then typeset verbatim (in a monospace font).

  * Section headings are recognied by equality (=) signs before
    and after the title, and the number of = signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.

  * Paragraph headings are recognized by a double underscore
    before and after the heading.

  * The abstract of a document starts with *Abstract* as paragraph
    heading, and all text up to the next heading makes up the abstract,

  * Blocks of computer code can easily be included by placing
    !bc (begin code) and !ec (end code) commands at separate lines
    before and after the code block.

  * Blocks of computer code can also be imported from source files.

  * Blocks of LaTeX mathematics can easily be included by placing
    !bt (begin TeX) and !et (end TeX) commands at separate lines
    before and after the math block.

  * There is support for both LaTeX and text-like inline mathematics.

  * Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.

  * Invisible comments in the output format can be inserted throughout
    the text.

  * Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).

  * There is special support for advanced exercises features.

  * With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.

  * With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format::


        ===== A Subsection with Sample Text =====
        label{my:first:sec}
        
        Ordinary text looks like ordinary text, and the tags used for
        _boldface_ words, *emphasized* words, and `computer` words look
        natural in plain text.  Lists are typeset as you would do in an email,
        
          * item 1
          * item 2
          * item 3
        
        Lists can also have automatically numbered items instead of bullets,
        
          o item 1
          o item 2
          o item 3
        
        URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
        If the word is URL, the URL itself becomes the link name,
        as in "URL":"tutorial.do.txt".
        
        References to sections may use logical names as labels (e.g., a
        "label" command right after the section title), as in the reference to
        Section ref{my:first:sec}.
        
        Doconce also allows inline comments such as [hpl: here I will make
        some remarks to the text] for allowing authors to make notes. Inline
        comments can be removed from the output by a command-line argument
        (see Section ref{doconce2formats} for an example).
        
        Tables are also supperted, e.g.,
        
          |--------------------------------|
          |time  | velocity | acceleration |
          |---r-------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        
        # lines beginning with # are comment lines

The Doconce text above results in the following little document:

A Subsection with Sample Text
-----------------------------

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and computer words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1

  * item 2

  * item 3

Lists can also have numbered items instead of bullets, just use an o
(for ordered) instead of the asterisk:

 1. item 1

 2. item 2

 3. item 3

URLs with a link word are possible, as in hpl (http://folk.uio.no/hpl).
If the word is URL, the URL itself becomes the link name,
as in tutorial.do.txt.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section "A Subsection with Sample Text".

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section "From Doconce to Other Formats" for an example).

Tables are also supperted, e.g.,

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  
============  ============  ============  

Mathematics and Computer Code
-----------------------------

Inline mathematics, such as v = sin(x),
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like v = sin(x) is
typeset as::


        $\nu = \sin(x)$|$v = sin(x)$

The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
  !bt and !et (begin tex / end tex) instructions.
The result looks like this::

        \begin{eqnarray}
        {\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
        {\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
        \end{eqnarray}

Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
  !bc and !ec instructions, respectively. Such blocks look like::


        from math import sin, pi
        def myfunc(x):
            return sin(pi*x)
        
        import integrate
        I = integrate.trapezoidal(myfunc, 0, pi, 100)

A code block must come after some plain sentence (at least for successful
output to sphinx, rst, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., !bc xxx
where xxx is an identifier like pycod for code snippet in Python,
sys for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in ptex2tex and defined in a
configuration file .ptext2tex.cfg, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments)::


        # sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

By default, pro and cod are python, sys is console,
while xpro and xcod are computer language specific for x
in f (Fortran), c (C), cpp (C++), pl (Perl), m (Matlab),
sh (Unix shells), cy (Cython), and py (Python).


One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with !bc pro, while a part of a file is copied into a !bc cod
environment. What pro and cod mean is then defined through
a .ptex2tex.cfg file for LaTeX and a sphinx code-blocks
comment for Sphinx.

Another document can be included by writing #include "mynote.do.txt"
on a line starting with (another) hash sign.  Doconce documents have
extension do.txt. The do part stands for doconce, while the
trailing .txt denotes a text document so that editors gives you the
right writing enviroment for plain text.


Macros (Newcommands), Cross-References, Index, and Bibliography
---------------------------------------------------------------

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
newcommand_replace.tex are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names newcommands.tex and
newcommands_keep.tex are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
  !bt and !et in newcommands_keep.tex to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
newcommands_replace.tex and expanded by Doconce.  The definitions of
newcommands in the newcommands*.tex files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the doc/manual/manual.do.txt file (see the
demo page (https://doconce.googlecode.com/hg/doc/demos/manual/index.html)
for various formats of this document).




From Doconce to Other Formats
=============================

Transformation of a Doconce document mydoc.do.txt to various other
formats applies the script doconce format::


        Terminal> doconce format format mydoc.do.txt

or just::


        Terminal> doconce format format mydoc

The mako or preprocess programs are always used to preprocess the
file first, and options to mako or preprocess can be added after the
filename. For example::


        Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
        Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako

The variable FORMAT is always defined as the current format when
running preprocess. That is, in the last example, FORMAT is
defined as latex. Inside the Doconce document one can then perform
format specific actions through tests like #if FORMAT == "latex".

Inline comments in the text are removed from the output by::


        Terminal> doconce format latex mydoc --skip_inline_comments

One can also remove all such comments from the original Doconce
file by running::


        Terminal> doconce remove_inline_comments mydoc

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


HTML
----

Making an HTML version of a Doconce file mydoc.do.txt
is performed by::


        Terminal> doconce format html mydoc

The resulting file mydoc.html can be loaded into any web browser for viewing.

Pandoc
------

Output in Pandoc's extended Markdown format results from::


        Terminal> doconce format pandoc mydoc

The name of the output file is mydoc.mkd.
From this format one can go to numerous other formats::


        Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd

Pandoc supports latex, html, odt (OpenOffice), docx (Microsoft
Word), rtf, texinfo, to mention some. The -R option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the Pandoc documentation (http://johnmacfarlane.net/pandoc/README.html)
for the many features of the pandoc program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
doconce format pandoc and then translating using pandoc, or
doconce format latex, and then going from LaTeX to the desired format
using pandoc.
Here is an example on the latter strategy::


        Terminal> doconce format latex mydoc
        Terminal> doconce ptex2tex mydoc
        Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex

When we go through pandoc, only single equations or align*
environments are well understood.

Quite some doconce replace and doconce subst edits might be needed
on the .mkd or .tex files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax::


        Terminal> doconce format pandoc mydoc
        Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd

The -s option adds a proper header and footer to the mydoc.html file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


LaTeX
-----

Making a LaTeX file mydoc.tex from mydoc.do.txt is done in two steps:

*Step 1.* Filter the doconce text to a pre-LaTeX form mydoc.p.tex for
     ptex2tex::


        Terminal> doconce format latex mydoc

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files newcommands.tex, newcommands_keep.tex, or
newcommands_replace.tex (see the section "Macros (Newcommands), Cross-References, Index, and Bibliography").
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run ptex2tex (if you have it) to make a standard LaTeX file::


        Terminal> ptex2tex mydoc

In case you do not have ptex2tex, you may run a (very) simplified version::


        Terminal> doconce ptex2tex mydoc


Note that Doconce generates a .p.tex file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run::


        Terminal> ptex2tex -DHELVETICA mydoc

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through::


        Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc

A separate titlepage can be generate by::


        Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc


The ptex2tex tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any !bc command in the Doconce source you can
insert verbatim block styles as defined in your .ptex2tex.cfg
file, e.g., !bc cod for a code snippet, where cod is set to
a certain environment in .ptex2tex.cfg (e.g., CodeIntended).
There are about 40 styles to choose from.

Also the doconce ptex2tex command supports preprocessor directives
for processing the .p.tex file. The command allows specifications
of code environments as well. Here is an example::


        Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
                  cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
                  fpro=minted fcod=minted sys=verbatim

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
verbatim above, which implies \begin{verbatim} and \end{verbatim}).
The value minted can be used for code environments where the
language is specified, as in fpro, where minted implies
\begin{python}{fortran}. There is a similar support for ans:
cppcod=ans imples \begin{c++} and \end{c++} using the
anslistings package.

*Step 2b (optional).* Edit the mydoc.tex file to your needs.
For example, you may want to substitute section by section* to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the doconce replace and doconce subst
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples::


        Terminal> doconce replace 'section{' 'section*{' mydoc.tex
        Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
                  'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile mydoc.tex
and create the PDF file::


        Terminal> latex mydoc
        Terminal> latex mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex mydoc
        Terminal> dvipdf mydoc

If one wishes to use the Minted_Python, Minted_Cpp, etc.,
environments in ptex2tex for typesetting code (specified, e.g., in
the *pro and *cod environments in .ptex2tex.cfg or
$HOME/.ptex2tex.cfg), the minted LaTeX package is needed.  This
package is included by running doconce format with the -DMINTED
option::


        Terminal> ptex2tex -DMINTED mydoc

In this case, latex must be run with the
-shell-escape option::


        Terminal> latex -shell-escape mydoc
        Terminal> latex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex -shell-escape mydoc
        Terminal> dvipdf mydoc



PDFLaTeX
--------

Running pdflatex instead of latex follows almost the same steps,
but the start is::


        Terminal> doconce format latex mydoc

Then ptex2tex is run as explained above, and finally::


        Terminal> pdflatex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> pdflatex -shell-escape mydoc


Plain ASCII Text
----------------

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code::


        Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt


reStructuredText
----------------

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file mydoc.rst::


        Terminal> doconce format rst mydoc.do.txt

We may now produce various other formats::


        Terminal> rst2html.py  mydoc.rst > mydoc.html # html
        Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
        Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
        Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice


The OpenOffice file mydoc.odt can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program unovonv
to convert between the many formats OpenOffice supports *on the command line*.
Run::


        Terminal> unoconv --show

to see all the formats that are supported.
For example, the following commands take
mydoc.odt to Microsoft Office Open XML format,
classic MS Word format, and PDF::


        Terminal> unoconv -f ooxml mydoc.odt
        Terminal> unoconv -f doc mydoc.odt
        Terminal> unoconv -f pdf mydoc.odt


*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by latex as
output and to a wide extent also supported by the sphinx output format.
Some links for going from LaTeX to Word are listed below.

 * http://ubuntuforums.org/showthread.php?t=1033441

 * http://tug.org/utilities/texconv/textopc.html

 * http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html

Sphinx
------

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the doconce sphinx_dir command::


        Terminal> doconce sphinx_dir author="authors' names" \
                  title="some title" version=1.0 dirname=sphinxdir \
                  theme=mytheme file1 file2 file3 ...

The keywords author, title, and version are used in the headings
of the Sphinx document. By default, version is 1.0 and the script
will try to deduce authors and title from the doconce files file1,
file2, etc. that together represent the whole document. Note that
none of the individual Doconce files file1, file2, etc. should
include the rest as their union makes up the whole document.
The default value of dirname is sphinx-rootdir. The theme
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is 'default').

With a single-file document in mydoc.do.txt one often just runs::


        Terminal> doconce sphinx_dir mydoc

and then an appropriate Sphinx directory sphinx-rootdir is made with
relevant files.

The doconce sphinx_dir command generates a script
automake-sphinx.py for compiling the Sphinx document into an HTML
document.  One can either run automake-sphinx.py or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te doconce sphinx_dir script copies directories named figs or figures
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, automake-sphinx.py must be edited accordingly.
Links to local files (not http: or file: URLs) must be placed
in the _static subdirectory of the Sphinx directory. The
utility doconce sphinxfix_localURLs is run to check for local
links: for each such link, say dir1/dir2/myfile.txt it replaces
the link by _static/myfile.txt and copies dir1/dir2/myfile.txt
to a local _static directory (in the same directory as the
script is run). The user must copy all _static/* files to the
_static subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the _static subdirectory of the Sphinx directory.
It may be wise to place relevant files in a _static directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the conf.py
configuration file for Sphinx is edited accordingly, and a script
make-themes.sh can make HTML documents with one or more themes.
For example,
to realize the themes fenics and pyramid, one writes::


        Terminal> ./make-themes.sh fenics pyramid

The resulting directories with HTML documents are _build/html_fenics
and _build/html_pyramid, respectively. Without arguments,
make-themes.sh makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file mydoc.do.txt.

*Step 1.* Translate Doconce into the Sphinx format::


        Terminal> doconce format sphinx mydoc


*Step 2.* Create a Sphinx root directory
either manually or by using the interactive sphinx-quickstart
program. Here is a scripted version of the steps with the latter::


        mkdir sphinx-rootdir
        sphinx-quickstart <<EOF
        sphinx-rootdir
        n
        _
        Name of My Sphinx Document
        Author
        version
        version
        .rst
        index
        n
        y
        n
        n
        n
        n
        y
        n
        n
        y
        y
        y
        EOF

The autogenerated conf.py file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The doconce sphinx_dir generator makes an extended conv.py
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the mydoc.rst file to the Sphinx root directory::


        Terminal> cp mydoc.rst sphinx-rootdir

If you have figures in your document, the relative paths to those will
be invalid when you work with mydoc.rst in the sphinx-rootdir
directory. Either edit mydoc.rst so that figure file paths are correct,
or simply copy your figure directories to sphinx-rootdir.
Links to local files in mydoc.rst must be modified to links to
files in the _static directory, see comment above.

*Step 4.* Edit the generated index.rst file so that mydoc.rst
is included, i.e., add mydoc to the toctree section so that it becomes::


        .. toctree::
           :maxdepth: 2
        
           mydoc

(The spaces before mydoc are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source::


        make clean   # remove old versions
        make html


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with index.html files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result::


        Terminal> firefox _build/html/index.html


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows !bc: cod gives Python
(code-block:: python in Sphinx syntax) and cppcod gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


Wiki Formats
------------

There are many different wiki formats, but Doconce only supports three:
Googlecode wiki (Google Code (http://code.google.com/p/support/wiki/WikiSyntax)), , MediaWiki, and Creole Wiki. These formats are called
gwiki, mwiki, and cwiki, respectively.
Transformation from Doconce to these formats is done by::


        Terminal> doconce format gwiki mydoc.do.txt
        Terminal> doconce format mwiki mydoc.do.txt
        Terminal> doconce format cwiki mydoc.do.txt


The Googlecode wiki document, mydoc.gwiki, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the .gwiki file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of mwlib (http://pediapress.com/code/). This means that one can
easily use Doconce to write Wikibooks (http://en.wikibooks.org)
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


Tweaking the Doconce Output
---------------------------

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
.rst file is going to be filtered to LaTeX or HTML, it cannot know
if .eps or .png is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The make.sh files in docs/manual and docs/tutorial
constitute comprehensive examples on how such scripts can be made.


Demos
-----

The current text is generated from a Doconce format stored in the file::


        docs/tutorial/tutorial.do.txt

The file make.sh in the tutorial directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, tutorial.do.txt is the
starting point.  Running make.sh and studying the various generated
files and comparing them with the original tutorial.do.txt file,
gives a quick introduction to how Doconce is used in a real case.
Here (https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html)
is a sample of how this tutorial looks in different formats.

There is another demo in the docs/manual directory which
translates the more comprehensive documentation, manual.do.txt, to
various formats. The make.sh script runs a set of translations.

Dependencies and Installation
-----------------------------

Doconce itself is pure Python code hosted at http://code.google.com/p/doconce.  Its installation from the
Mercurial (hg) source follows the standard procedure::


        # Doconce
        hg clone https://doconce.googlecode.com/hg/ doconce
        cd doconce
        sudo python setup.py install
        cd ..


If you make use of the Preprocess (http://code.google.com/p/preprocess)
preprocessor, this program must be installed::


        svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
        cd preprocess
        cd doconce
        sudo python setup.py install
        cd ..

A much more advanced alternative to Preprocess is
Mako (http://www.makotemplates.org). Its installation is most
conveniently done by pip::


        pip install Mako

This command requires pip to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by::


        sudo apt-get install python-pip

Alternatively, one can install from the pip source code (http://pypi.python.org/pypi/pip).

To make LaTeX
documents (without going through the reStructuredText format) you
need ptex2tex (http://code.google.com/p/ptex2tex), which is
installed by::


        svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
        cd ptex2tex
        sudo python setup.py install
        cd latex
        sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
        cd ../..

As seen, cp2texmf.sh copies some special stylefiles that
that ptex2tex potentially makes use of. Some more standard stylefiles
are also needed. These are installed by::


        sudo apt-get install texlive-latex-extra

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the ~/texmf/tex/latex/misc directory).

The *minted* LaTeX style is offered by ptex2tex and popular among
users. This style requires the package Pygments (http://pygments.org)::


        hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
        cd pygments
        sudo python setup.py install

If you use the minted style, you have to enable it by running
ptex2tex -DMINTED and then latex -shell-escape, see
the the section "From Doconce to Other Formats".

For rst output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs docutils (http://docutils.sourceforge.net).
The installation can be done by::


        svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
        cd docutils
        sudo python setup.py install
        cd ..

To use the OpenOffice suite you will typically on Debian systems install::


        sudo apt-get install unovonv libreoffice libreoffice-dmaths


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
rst2pdf (http://code.google.com/p/rst2pdf). Either download the tarball
or clone the svn repository, go to the rst2pdf directory and
run sudo python setup.py install.


Output to sphinx requires of course Sphinx (http://sphinx.pocoo.org),
installed by::


        hg clone https://bitbucket.org/birkenfeld/sphinx
        cd sphinx
        sudo python setup.py install
        cd ..


When the output format is epydoc one needs that program too, installed
by::


        svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
        cd epydoc
        sudo make install
        cd ..


Finally, translation to pandoc requires the
Pandoc (http://johnmacfarlane.net/pandoc/) program
(written in Haskell) to be installed::


        sudo apt-get install pandoc


*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
apt-get install command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For svn directories, go to the directory,
run svn update, and then sudo python setup.py install. For
Mercurial (hg) directories, go to the directory, run
hg pull; hg update, and then sudo python setup.py install.
Doconce itself is frequently updated so these commands should be
run regularly.
************** File: tutorial.mkd *****************
% Doconce: Document Once, Include Anywhere
% Hans Petter Langtangen at Simula Research Laboratory and University of Oslo
% Jan 32, 2100

 * When writing a note, report, manual, etc., do you find it difficult
   to choose the typesetting format? That is, to choose between plain
   (email-like) text, wiki, Word/OpenOffice, LaTeX, HTML,
   reStructuredText, Sphinx, XML, etc.  Would it be convenient to
   start with some very simple text-like format that easily converts
   to the formats listed above, and then at some later stage
   eventually go with a particular format?

 * Do you need to write documents in varying formats but find it
   difficult to remember all the typesetting details of various
   formats like [LaTeX](http://refcards.com/docs/silvermanj/amslatex/LaTeXRefCard.v2.0.pdf), [HTML](http://www.htmlcodetutorial.com/), [reStructuredText](http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html), [Sphinx](http://sphinx.pocoo.org/contents.html), and [wiki](http://code.google.com/p/support/wiki/WikiSyntax)? Would it be convenient
   to generate the typesetting details of a particular format from a
   very simple text-like format with minimal tagging?

 * Do you have the same information scattered around in different
   documents in different typesetting formats? Would it be a good idea
   to write things once, in one format, stored in one place, and
   include it anywhere?

If any of these questions are of interest, you should keep on reading.


The Doconce Concept
===================

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via `rst2*` programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via `unoconv`) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  * Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.

  * Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.

  * Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  * Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).

  * Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  * Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  * Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  * Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.

  * Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



What Does Doconce Look Like?
============================

Doconce text looks like ordinary text, but there are some almost invisible
text constructions that allow you to control the formating. Here are
som examples.

  * Bullet lists arise from lines starting with an asterisk.

  * *Emphasized words* are surrounded by asterisks.

  * _Words in boldface_ are surrounded by underscores.

  * Words from computer code are enclosed in back quotes and
    then typeset `verbatim (in a monospace font)`.

  * Section headings are recognied by equality (`=`) signs before
    and after the title, and the number of `=` signs indicates the
    level of the section: 7 for main section, 5 for subsection, and
    3 for subsubsection.

  * Paragraph headings are recognized by a double underscore
    before and after the heading.

  * The abstract of a document starts with *Abstract* as paragraph
    heading, and all text up to the next heading makes up the abstract,

  * Blocks of computer code can easily be included by placing
    `!bc` (begin code) and `!ec` (end code) commands at separate lines
    before and after the code block.

  * Blocks of computer code can also be imported from source files.

  * Blocks of LaTeX mathematics can easily be included by placing
    `!bt` (begin TeX) and `!et` (end TeX) commands at separate lines
    before and after the math block.

  * There is support for both LaTeX and text-like inline mathematics.

  * Figures and movies with captions, simple tables,
    URLs with links, index list, labels and references are supported.

  * Invisible comments in the output format can be inserted throughout
    the text.

  * Visible comments can be inserted so that authors and readers can
    comment upon the text (and at any time turn on/off output of such
    comments).

  * There is special support for advanced exercises features.

  * With a simple preprocessor, Preprocess or Mako, one can include
    other documents (files) and large portions of text can be defined
    in or out of the text.

  * With the Mako preprocessor one can even embed Python
    code and use this to steer generation of Doconce text.

Here is an example of some simple text written in the Doconce format:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
===== A Subsection with Sample Text =====
\label{my:first:sec}

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1
  * item 2
  * item 3

Lists can also have automatically numbered items instead of bullets,

  o item 1
  o item 2
  o item 3

URLs with a link word are possible, as in "hpl":"http://folk.uio.no/hpl".
If the word is URL, the URL itself becomes the link name,
as in "URL":"tutorial.do.txt".

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
Section ref{my:first:sec}.

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see Section ref{doconce2formats} for an example).

Tables are also supperted, e.g.,

  |--------------------------------|
  |time  | velocity | acceleration |
  |---r-------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

# lines beginning with # are comment lines
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The Doconce text above results in the following little document:

A Subsection with Sample Text
-----------------------------

Ordinary text looks like ordinary text, and the tags used for
_boldface_ words, *emphasized* words, and `computer` words look
natural in plain text.  Lists are typeset as you would do in an email,

  * item 1

  * item 2

  * item 3

Lists can also have numbered items instead of bullets, just use an `o`
(for ordered) instead of the asterisk:

 1. item 1

 2. item 2

 3. item 3

URLs with a link word are possible, as in [hpl](http://folk.uio.no/hpl).
If the word is URL, the URL itself becomes the link name,
as in <tutorial.do.txt>.

References to sections may use logical names as labels (e.g., a
"label" command right after the section title), as in the reference to
the section [A Subsection with Sample Text](#t).

Doconce also allows inline comments such as [hpl: here I will make
some remarks to the text] for allowing authors to make notes. Inline
comments can be removed from the output by a command-line argument
(see the section [From Doconce to Other Formats](#s) for an example).

Tables are also supperted, e.g.,


    time        velocity    acceleration  
------------  ------------  ------------  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  


Mathematics and Computer Code
-----------------------------

Inline mathematics, such as $\nu = \sin(x)$,
allows the formula to be specified both as LaTeX and as plain text.
This results in a professional LaTeX typesetting, but in other formats
the text version normally looks better than raw LaTeX mathematics with
backslashes. An inline formula like $\nu = \sin(x)$ is
typeset as

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$\nu = \sin(x)$|$v = sin(x)$
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The pipe symbol acts as a delimiter between LaTeX code and the plain text
version of the formula.

Blocks of mathematics are better typeset with raw LaTeX, inside
`!bt` and `!et` (begin tex / end tex) instructions.
The result looks like this:
$$
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g
\end{eqnarray}
$$
Of course, such blocks only looks nice in LaTeX. The raw
LaTeX syntax appears in all other formats (but can still be useful
for those who can read LaTeX syntax).

You can have blocks of computer code, starting and ending with
`!bc` and `!ec` instructions, respectively. Such blocks look like

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Python}
from math import sin, pi
def myfunc(x):
    return sin(pi*x)

import integrate
I = integrate.trapezoidal(myfunc, 0, pi, 100)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

A code block must come after some plain sentence (at least for successful
output to `sphinx`, `rst`, and ASCII-close formats),
not directly after a section/paragraph heading or a table.

It is possible to add a specification of an
environment for typesetting the verbatim code block, e.g., `!bc xxx`
where `xxx` is an identifier like `pycod` for code snippet in Python,
`sys` for terminal session, etc. When Doconce is filtered to LaTeX,
these identifiers are used as in `ptex2tex` and defined in a
configuration file `.ptext2tex.cfg`, while when filtering
to Sphinx, one can have a comment line in the Doconce file for
mapping the identifiers to legal language names for Sphinx (which equals
the legal language names for Pygments):

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

By default, `pro` and `cod` are `python`, `sys` is `console`,
while `xpro` and `xcod` are computer language specific for `x`
in `f` (Fortran), `c` (C), `cpp` (C++), `pl` (Perl), `m` (Matlab),
`sh` (Unix shells), `cy` (Cython), and `py` (Python).


One can also copy computer code directly from files, either the
complete file or specified parts.  Computer code is then never
duplicated in the documentation (important for the principle of
avoiding copying information!). A complete file is typeset
with `!bc pro`, while a part of a file is copied into a `!bc cod`
environment. What `pro` and `cod` mean is then defined through
a `.ptex2tex.cfg` file for LaTeX and a `sphinx code-blocks`
comment for Sphinx.

Another document can be included by writing `#include "mynote.do.txt"`
on a line starting with (another) hash sign.  Doconce documents have
extension `do.txt`. The `do` part stands for doconce, while the
trailing `.txt` denotes a text document so that editors gives you the
right writing enviroment for plain text.


Macros (Newcommands), Cross-References, Index, and Bibliography
---------------------------------------------------------------

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
`newcommand_replace.tex` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names `newcommands.tex` and
`newcommands_keep.tex` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
`!bt` and `!et` in `newcommands_keep.tex` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
`newcommands_replace.tex` and expanded by Doconce.  The definitions of
newcommands in the `newcommands*.tex` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

Recent versions of Doconce also offer cross referencing, typically one
can define labels below (sub)sections, in figure captions, or in
equations, and then refer to these later. Entries in an index can be
defined and result in an index at the end for the LaTeX and Sphinx
formats. Citations to literature, with an accompanying bibliography in
a file, are also supported. The syntax of labels, references,
citations, and the bibliography closely resembles that of LaTeX,
making it easy for Doconce documents to be integrated in LaTeX
projects (manuals, books). For further details on functionality and
syntax we refer to the `doc/manual/manual.do.txt` file (see the
[demo page](https://doconce.googlecode.com/hg/doc/demos/manual/index.html)
for various formats of this document).




From Doconce to Other Formats
=============================

Transformation of a Doconce document `mydoc.do.txt` to various other
formats applies the script `doconce format`:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format format mydoc.do.txt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

or just

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format format mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The `mako` or `preprocess` programs are always used to preprocess the
file first, and options to `mako` or `preprocess` can be added after the
filename. For example,

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The variable `FORMAT` is always defined as the current format when
running `preprocess`. That is, in the last example, `FORMAT` is
defined as `latex`. Inside the Doconce document one can then perform
format specific actions through tests like `#if FORMAT == "latex"`.

Inline comments in the text are removed from the output by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format latex mydoc --skip_inline_comments
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

One can also remove all such comments from the original Doconce
file by running:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Terminal> doconce remove_inline_comments mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


HTML
----

Making an HTML version of a Doconce file `mydoc.do.txt`
is performed by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format html mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The resulting file `mydoc.html` can be loaded into any web browser for viewing.

Pandoc
------

Output in Pandoc's extended Markdown format results from

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format pandoc mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The name of the output file is `mydoc.mkd`.
From this format one can go to numerous other formats:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Pandoc supports `latex`, `html`, `odt` (OpenOffice), `docx` (Microsoft
Word), `rtf`, `texinfo`, to mention some. The `-R` option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the [Pandoc documentation](http://johnmacfarlane.net/pandoc/README.html)
for the many features of the `pandoc` program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
`doconce format pandoc` and then translating using `pandoc`, or
`doconce format latex`, and then going from LaTeX to the desired format
using `pandoc`.
Here is an example on the latter strategy:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format latex mydoc
Terminal> doconce ptex2tex mydoc
Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

When we go through `pandoc`, only single equations or `align*`
environments are well understood.

Quite some `doconce replace` and `doconce subst` edits might be needed
on the `.mkd` or `.tex` files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format pandoc mydoc
Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The `-s` option adds a proper header and footer to the `mydoc.html` file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


LaTeX
-----

Making a LaTeX file `mydoc.tex` from `mydoc.do.txt` is done in two steps:

*Step 1.* Filter the doconce text to a pre-LaTeX form `mydoc.p.tex` for
     `ptex2tex`:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format latex mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files `newcommands.tex`, `newcommands_keep.tex`, or
`newcommands_replace.tex` (see the section [Macros (Newcommands), Cross-References, Index, and Bibliography](#y)).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run `ptex2tex` (if you have it) to make a standard LaTeX file,

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> ptex2tex mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

In case you do not have `ptex2tex`, you may run a (very) simplified version:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce ptex2tex mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Note that Doconce generates a `.p.tex` file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> ptex2tex -DHELVETICA mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

A separate titlepage can be generate by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


The `ptex2tex` tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any `!bc` command in the Doconce source you can
insert verbatim block styles as defined in your `.ptex2tex.cfg`
file, e.g., `!bc cod` for a code snippet, where `cod` is set to
a certain environment in `.ptex2tex.cfg` (e.g., `CodeIntended`).
There are about 40 styles to choose from.

Also the `doconce ptex2tex` command supports preprocessor directives
for processing the `.p.tex` file. The command allows specifications
of code environments as well. Here is an example:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
`verbatim` above, which implies `\begin{verbatim}` and `\end{verbatim}`).
The value `minted` can be used for code environments where the
language is specified, as in `fpro`, where `minted` implies
`\begin{python}{fortran}`. There is a similar support for `ans`:
`cppcod=ans` imples `\begin{c++}` and `\end{c++}` using the
`anslistings` package.

*Step 2b (optional).* Edit the `mydoc.tex` file to your needs.
For example, you may want to substitute `section` by `section*` to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the `doconce replace` and `doconce subst`
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce replace 'section{' 'section*{' mydoc.tex
Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile `mydoc.tex`
and create the PDF file:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> latex mydoc
Terminal> latex mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex mydoc
Terminal> dvipdf mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If one wishes to use the `Minted_Python`, `Minted_Cpp`, etc.,
environments in `ptex2tex` for typesetting code (specified, e.g., in
the `*pro` and `*cod` environments in `.ptex2tex.cfg` or
`$HOME/.ptex2tex.cfg`), the `minted` LaTeX package is needed.  This
package is included by running `doconce format` with the `-DMINTED`
option:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> ptex2tex -DMINTED mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

In this case, `latex` must be run with the
`-shell-escape` option:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> latex -shell-escape mydoc
Terminal> latex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex -shell-escape mydoc
Terminal> dvipdf mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



PDFLaTeX
--------

Running `pdflatex` instead of `latex` follows almost the same steps,
but the start is

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format latex mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Then `ptex2tex` is run as explained above, and finally

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> pdflatex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> pdflatex -shell-escape mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Plain ASCII Text
----------------

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


reStructuredText
----------------

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file `mydoc.rst`:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format rst mydoc.do.txt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

We may now produce various other formats:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> rst2html.py  mydoc.rst > mydoc.html # html
Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


The OpenOffice file `mydoc.odt` can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program `unovonv`
to convert between the many formats OpenOffice supports *on the command line*.
Run

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> unoconv --show
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

to see all the formats that are supported.
For example, the following commands take
`mydoc.odt` to Microsoft Office Open XML format,
classic MS Word format, and PDF:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> unoconv -f ooxml mydoc.odt
Terminal> unoconv -f doc mydoc.odt
Terminal> unoconv -f pdf mydoc.odt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by `latex` as
output and to a wide extent also supported by the `sphinx` output format.
Some links for going from LaTeX to Word are listed below.

 * <http://ubuntuforums.org/showthread.php?t=1033441>

 * <http://tug.org/utilities/texconv/textopc.html>

 * <http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html>

Sphinx
------

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the `doconce sphinx_dir` command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The keywords `author`, `title`, and `version` are used in the headings
of the Sphinx document. By default, `version` is 1.0 and the script
will try to deduce authors and title from the doconce files `file1`,
`file2`, etc. that together represent the whole document. Note that
none of the individual Doconce files `file1`, `file2`, etc. should
include the rest as their union makes up the whole document.
The default value of `dirname` is `sphinx-rootdir`. The `theme`
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is `'default'`).

With a single-file document in `mydoc.do.txt` one often just runs

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce sphinx_dir mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and then an appropriate Sphinx directory `sphinx-rootdir` is made with
relevant files.

The `doconce sphinx_dir` command generates a script
`automake-sphinx.py` for compiling the Sphinx document into an HTML
document.  One can either run `automake-sphinx.py` or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te `doconce sphinx_dir` script copies directories named `figs` or `figures`
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, `automake-sphinx.py` must be edited accordingly.
Links to local files (not `http:` or `file:` URLs) must be placed
in the `_static` subdirectory of the Sphinx directory. The
utility `doconce sphinxfix_localURLs` is run to check for local
links: for each such link, say `dir1/dir2/myfile.txt` it replaces
the link by `_static/myfile.txt` and copies `dir1/dir2/myfile.txt`
to a local `_static` directory (in the same directory as the
script is run). The user must copy all `_static/*` files to the
`_static` subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the `_static` subdirectory of the Sphinx directory.
It may be wise to place relevant files in a `_static` directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the `conf.py`
configuration file for Sphinx is edited accordingly, and a script
`make-themes.sh` can make HTML documents with one or more themes.
For example,
to realize the themes `fenics` and `pyramid`, one writes

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> ./make-themes.sh fenics pyramid
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The resulting directories with HTML documents are `_build/html_fenics`
and `_build/html_pyramid`, respectively. Without arguments,
`make-themes.sh` makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file `mydoc.do.txt`.

*Step 1.* Translate Doconce into the Sphinx format:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format sphinx mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


*Step 2.* Create a Sphinx root directory
either manually or by using the interactive `sphinx-quickstart`
program. Here is a scripted version of the steps with the latter:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
mkdir sphinx-rootdir
sphinx-quickstart <<EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The autogenerated `conf.py` file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The `doconce sphinx_dir` generator makes an extended `conv.py`
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the `mydoc.rst` file to the Sphinx root directory:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> cp mydoc.rst sphinx-rootdir
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If you have figures in your document, the relative paths to those will
be invalid when you work with `mydoc.rst` in the `sphinx-rootdir`
directory. Either edit `mydoc.rst` so that figure file paths are correct,
or simply copy your figure directories to `sphinx-rootdir`.
Links to local files in `mydoc.rst` must be modified to links to
files in the `_static` directory, see comment above.

*Step 4.* Edit the generated `index.rst` file so that `mydoc.rst`
is included, i.e., add `mydoc` to the `toctree` section so that it becomes

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.. toctree::
   :maxdepth: 2

   mydoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(The spaces before `mydoc` are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
make clean   # remove old versions
make html
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with `index.html` files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> firefox _build/html/index.html
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows `!bc`: `cod` gives Python
(`code-block:: python` in Sphinx syntax) and `cppcod` gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


Wiki Formats
------------

There are many different wiki formats, but Doconce only supports three:
[Googlecode wiki](Google Code (http://code.google.com/p/support/wiki/WikiSyntax)), , MediaWiki, and Creole Wiki. These formats are called
`gwiki`, `mwiki`, and `cwiki`, respectively.
Transformation from Doconce to these formats is done by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
Terminal> doconce format gwiki mydoc.do.txt
Terminal> doconce format mwiki mydoc.do.txt
Terminal> doconce format cwiki mydoc.do.txt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


The Googlecode wiki document, `mydoc.gwiki`, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the `.gwiki` file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of [mwlib](http://pediapress.com/code/). This means that one can
easily use Doconce to write [Wikibooks](http://en.wikibooks.org)
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


Tweaking the Doconce Output
---------------------------

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
`.rst` file is going to be filtered to LaTeX or HTML, it cannot know
if `.eps` or `.png` is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The `make.sh` files in `docs/manual` and `docs/tutorial`
constitute comprehensive examples on how such scripts can be made.


Demos
-----

The current text is generated from a Doconce format stored in the file

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
docs/tutorial/tutorial.do.txt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The file `make.sh` in the `tutorial` directory of the
Doconce source code contains a demo of how to produce a variety of
formats.  The source of this tutorial, `tutorial.do.txt` is the
starting point.  Running `make.sh` and studying the various generated
files and comparing them with the original `tutorial.do.txt` file,
gives a quick introduction to how Doconce is used in a real case.
[Here](https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html)
is a sample of how this tutorial looks in different formats.

There is another demo in the `docs/manual` directory which
translates the more comprehensive documentation, `manual.do.txt`, to
various formats. The `make.sh` script runs a set of translations.

Dependencies and Installation
-----------------------------

Doconce itself is pure Python code hosted at <http://code.google.com/p/doconce>.  Its installation from the
Mercurial (`hg`) source follows the standard procedure:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


If you make use of the [Preprocess](http://code.google.com/p/preprocess)
preprocessor, this program must be installed:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

A much more advanced alternative to Preprocess is
[Mako](http://www.makotemplates.org). Its installation is most
conveniently done by `pip`,

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
pip install Mako
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This command requires `pip` to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
sudo apt-get install python-pip
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Alternatively, one can install from the `pip` [source code](http://pypi.python.org/pypi/pip).

To make LaTeX
documents (without going through the reStructuredText format) you
need [ptex2tex](http://code.google.com/p/ptex2tex), which is
installed by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

As seen, `cp2texmf.sh` copies some special stylefiles that
that `ptex2tex` potentially makes use of. Some more standard stylefiles
are also needed. These are installed by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
sudo apt-get install texlive-latex-extra
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the `~/texmf/tex/latex/misc` directory).

The *minted* LaTeX style is offered by `ptex2tex` and popular among
users. This style requires the package [Pygments](http://pygments.org):

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If you use the minted style, you have to enable it by running
`ptex2tex -DMINTED` and then `latex -shell-escape`, see
the the section [From Doconce to Other Formats](#s).

For `rst` output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs [docutils](http://docutils.sourceforge.net).
The installation can be done by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

To use the OpenOffice suite you will typically on Debian systems install

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
sudo apt-get install unovonv libreoffice libreoffice-dmaths
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
[rst2pdf](http://code.google.com/p/rst2pdf). Either download the tarball
or clone the svn repository, go to the `rst2pdf` directory and
run `sudo python setup.py install`.


Output to `sphinx` requires of course [Sphinx](http://sphinx.pocoo.org),
installed by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


When the output format is `epydoc` one needs that program too, installed
by

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Finally, translation to `pandoc` requires the
[Pandoc](http://johnmacfarlane.net/pandoc/) program
(written in Haskell) to be installed.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.Bash}
sudo apt-get install pandoc
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
`apt-get install` command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For `svn` directories, go to the directory,
run `svn update`, and then `sudo python setup.py install`. For
Mercurial (`hg`) directories, go to the directory, run
`hg pull; hg update`, and then `sudo python setup.py install`.
Doconce itself is frequently updated so these commands should be
run regularly.

************** File: ../_what_is.do.txt *****************
Doconce is two things:

  o Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via `rst2*` programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via `unoconv`) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

  o Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".



Here are some Doconce features:

  * Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.
  * Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.
  * Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.
  * Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).
  * Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.
  * Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  * Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  * Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.

  * Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



************** File: ../_doconce2anything.do.txt *****************

======= From Doconce to Other Formats =======
label{doconce2formats}

Transformation of a Doconce document `mydoc.do.txt` to various other
formats applies the script `doconce format`:
!bc sys
Terminal> doconce format format mydoc.do.txt
!ec
or just
!bc sys
Terminal> doconce format format mydoc
!ec
The `mako` or `preprocess` programs are always used to preprocess the
file first, and options to `mako` or `preprocess` can be added after the
filename. For example,
!bc sys
Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako
!ec
The variable `FORMAT` is always defined as the current format when
running `preprocess`. That is, in the last example, `FORMAT` is
defined as `latex`. Inside the Doconce document one can then perform
format specific actions through tests like `#if FORMAT == "latex"`.

Inline comments in the text are removed from the output by
!bc sys
Terminal> doconce format latex mydoc --skip_inline_comments
!ec
One can also remove all such comments from the original Doconce
file by running:
!bc
Terminal> doconce remove_inline_comments mydoc
!ec
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


===== HTML =====

Making an HTML version of a Doconce file `mydoc.do.txt`
is performed by
!bc sys
Terminal> doconce format html mydoc
!ec
The resulting file `mydoc.html` can be loaded into any web browser for viewing.

===== Pandoc =====

Output in Pandoc's extended Markdown format results from
!bc sys
Terminal> doconce format pandoc mydoc
!ec
The name of the output file is `mydoc.mkd`.
From this format one can go to numerous other formats:
!bc sys
Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
!ec
Pandoc supports `latex`, `html`, `odt` (OpenOffice), `docx` (Microsoft
Word), `rtf`, `texinfo`, to mention some. The `-R` option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the "Pandoc documentation": "http://johnmacfarlane.net/pandoc/README.html"
for the many features of the `pandoc` program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
`doconce format pandoc` and then translating using `pandoc`, or
`doconce format latex`, and then going from LaTeX to the desired format
using `pandoc`.
Here is an example on the latter strategy:
!bc sys
Terminal> doconce format latex mydoc
Terminal> doconce ptex2tex mydoc
Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex
!ec
When we go through `pandoc`, only single equations or `align*`
environments are well understood.

Quite some `doconce replace` and `doconce subst` edits might be needed
on the `.mkd` or `.tex` files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
!bc sys
Terminal> doconce format pandoc mydoc
Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
!ec
The `-s` option adds a proper header and footer to the `mydoc.html` file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


===== LaTeX =====

Making a LaTeX file `mydoc.tex` from `mydoc.do.txt` is done in two steps:
# Note: putting code blocks inside a list is not successful in many
# formats - the text may be messed up. A better choice is a paragraph
# environment, as used here.

__Step 1.__ Filter the doconce text to a pre-LaTeX form `mydoc.p.tex` for
     `ptex2tex`:
!bc sys
Terminal> doconce format latex mydoc
!ec
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files `newcommands.tex`, `newcommands_keep.tex`, or
`newcommands_replace.tex` (see Section ref{newcommands}).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

__Step 2.__ Run `ptex2tex` (if you have it) to make a standard LaTeX file,
!bc sys
Terminal> ptex2tex mydoc
!ec
In case you do not have `ptex2tex`, you may run a (very) simplified version:
!bc sys
Terminal> doconce ptex2tex mydoc
!ec

Note that Doconce generates a `.p.tex` file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
!bc sys
Terminal> ptex2tex -DHELVETICA mydoc
!ec
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through
!bc sys
Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc
!ec
A separate titlepage can be generate by
!bc sys
Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc
!ec

The `ptex2tex` tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any `!bc` command in the Doconce source you can
insert verbatim block styles as defined in your `.ptex2tex.cfg`
file, e.g., `!bc cod` for a code snippet, where `cod` is set to
a certain environment in `.ptex2tex.cfg` (e.g., `CodeIntended`).
There are about 40 styles to choose from.

Also the `doconce ptex2tex` command supports preprocessor directives
for processing the `.p.tex` file. The command allows specifications
of code environments as well. Here is an example:
!bc sys
Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
!ec
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
`verbatim` above, which implies `\begin{verbatim}` and `\end{verbatim}`).
The value `minted` can be used for code environments where the
language is specified, as in `fpro`, where `minted` implies
`\begin{python}{fortran}`. There is a similar support for `ans`:
`cppcod=ans` imples `\begin{c++}` and `\end{c++}` using the
`anslistings` package.

__Step 2b (optional).__ Edit the `mydoc.tex` file to your needs.
For example, you may want to substitute `section` by `section*` to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the `doconce replace` and `doconce subst`
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
!bc sys
Terminal> doconce replace 'section{' 'section*{' mydoc.tex
Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex
!ec
A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

__Step 3.__ Compile `mydoc.tex`
and create the PDF file:
!bc sys
Terminal> latex mydoc
Terminal> latex mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex mydoc
Terminal> dvipdf mydoc
!ec
If one wishes to use the `Minted_Python`, `Minted_Cpp`, etc.,
environments in `ptex2tex` for typesetting code (specified, e.g., in
the `*pro` and `*cod` environments in `.ptex2tex.cfg` or
`$HOME/.ptex2tex.cfg`), the `minted` LaTeX package is needed.  This
package is included by running `doconce format` with the `-DMINTED`
option:
!bc sys
Terminal> ptex2tex -DMINTED mydoc
!ec
In this case, `latex` must be run with the
`-shell-escape` option:
!bc sys
Terminal> latex -shell-escape mydoc
Terminal> latex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex -shell-escape mydoc
Terminal> dvipdf mydoc
!ec


===== PDFLaTeX =====

Running `pdflatex` instead of `latex` follows almost the same steps,
but the start is
!bc sys
Terminal> doconce format latex mydoc
!ec
Then `ptex2tex` is run as explained above, and finally
!bc sys
Terminal> pdflatex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> pdflatex -shell-escape mydoc
!ec

===== Plain ASCII Text =====

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
!bc sys
Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt
!ec

===== reStructuredText =====

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file `mydoc.rst`:
!bc sys
Terminal> doconce format rst mydoc.do.txt
!ec
We may now produce various other formats:
!bc sys
Terminal> rst2html.py  mydoc.rst > mydoc.html # html
Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice
!ec

The OpenOffice file `mydoc.odt` can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program `unovonv`
to convert between the many formats OpenOffice supports *on the command line*.
Run
!bc sys
Terminal> unoconv --show
!ec
to see all the formats that are supported.
For example, the following commands take
`mydoc.odt` to Microsoft Office Open XML format,
classic MS Word format, and PDF:
!bc sys
Terminal> unoconv -f ooxml mydoc.odt
Terminal> unoconv -f doc mydoc.odt
Terminal> unoconv -f pdf mydoc.odt
!ec

__Remark about Mathematical Typesetting.__
At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by `latex` as
output and to a wide extent also supported by the `sphinx` output format.
Some links for going from LaTeX to Word are listed below.

 * URL:"http://ubuntuforums.org/showthread.php?t=1033441"
 * URL:"http://tug.org/utilities/texconv/textopc.html"
 * URL:"http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html"



===== Sphinx =====

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the `doconce sphinx_dir` command:
!bc sys
Terminal> doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
!ec
The keywords `author`, `title`, and `version` are used in the headings
of the Sphinx document. By default, `version` is 1.0 and the script
will try to deduce authors and title from the doconce files `file1`,
`file2`, etc. that together represent the whole document. Note that
none of the individual Doconce files `file1`, `file2`, etc. should
include the rest as their union makes up the whole document.
The default value of `dirname` is `sphinx-rootdir`. The `theme`
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is `'default'`).

With a single-file document in `mydoc.do.txt` one often just runs
!bc sys
Terminal> doconce sphinx_dir mydoc
!ec
and then an appropriate Sphinx directory `sphinx-rootdir` is made with
relevant files.

The `doconce sphinx_dir` command generates a script
`automake-sphinx.py` for compiling the Sphinx document into an HTML
document.  One can either run `automake-sphinx.py` or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te `doconce sphinx_dir` script copies directories named `figs` or `figures`
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, `automake-sphinx.py` must be edited accordingly.
Links to local files (not `http:` or `file:` URLs) must be placed
in the `_static` subdirectory of the Sphinx directory. The
utility `doconce sphinxfix_localURLs` is run to check for local
links: for each such link, say `dir1/dir2/myfile.txt` it replaces
the link by `_static/myfile.txt` and copies `dir1/dir2/myfile.txt`
to a local `_static` directory (in the same directory as the
script is run). The user must copy all `_static/*` files to the
`_static` subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the `_static` subdirectory of the Sphinx directory.
It may be wise to place relevant files in a `_static` directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the `conf.py`
configuration file for Sphinx is edited accordingly, and a script
`make-themes.sh` can make HTML documents with one or more themes.
For example,
to realize the themes `fenics` and `pyramid`, one writes
!bc sys
Terminal> ./make-themes.sh fenics pyramid
!ec
The resulting directories with HTML documents are `_build/html_fenics`
and `_build/html_pyramid`, respectively. Without arguments,
`make-themes.sh` makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file `mydoc.do.txt`.

__Step 1.__ Translate Doconce into the Sphinx format:
!bc sys
Terminal> doconce format sphinx mydoc
!ec

__Step 2.__ Create a Sphinx root directory
either manually or by using the interactive `sphinx-quickstart`
program. Here is a scripted version of the steps with the latter:
!bc sys
mkdir sphinx-rootdir
sphinx-quickstart <<EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
!ec
The autogenerated `conf.py` file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The `doconce sphinx_dir` generator makes an extended `conv.py`
file where, among other things, several useful Sphinx extensions
are included.


__Step 3.__ Copy the `mydoc.rst` file to the Sphinx root directory:
!bc sys
Terminal> cp mydoc.rst sphinx-rootdir
!ec
If you have figures in your document, the relative paths to those will
be invalid when you work with `mydoc.rst` in the `sphinx-rootdir`
directory. Either edit `mydoc.rst` so that figure file paths are correct,
or simply copy your figure directories to `sphinx-rootdir`.
Links to local files in `mydoc.rst` must be modified to links to
files in the `_static` directory, see comment above.

__Step 4.__ Edit the generated `index.rst` file so that `mydoc.rst`
is included, i.e., add `mydoc` to the `toctree` section so that it becomes
!bc
.. toctree::
   :maxdepth: 2

   mydoc
!ec
(The spaces before `mydoc` are important!)

__Step 5.__ Generate, for instance, an HTML version of the Sphinx source:
!bc sys
make clean   # remove old versions
make html
!ec

Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with `index.html` files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

__Step 6.__ View the result:
!bc sys
Terminal> firefox _build/html/index.html
!ec

Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows `!bc`: `cod` gives Python
(`code-block:: python` in Sphinx syntax) and `cppcod` gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


===== Wiki Formats =====

There are many different wiki formats, but Doconce only supports three:
"Googlecode wiki": "http://code.google.com/p/support/wiki/WikiSyntax<Google Code>", , MediaWiki, and Creole Wiki. These formats are called
`gwiki`, `mwiki`, and `cwiki`, respectively.
Transformation from Doconce to these formats is done by
!bc sys
Terminal> doconce format gwiki mydoc.do.txt
Terminal> doconce format mwiki mydoc.do.txt
Terminal> doconce format cwiki mydoc.do.txt
!ec

The Googlecode wiki document, `mydoc.gwiki`, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the `.gwiki` file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of "mwlib": "http://pediapress.com/code/". This means that one can
easily use Doconce to write "Wikibooks": "http://en.wikibooks.org"
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


===== Tweaking the Doconce Output =====

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
`.rst` file is going to be filtered to LaTeX or HTML, it cannot know
if `.eps` or `.png` is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The `make.sh` files in `docs/manual` and `docs/tutorial`
constitute comprehensive examples on how such scripts can be made.

************** File: tmp_Doconce.do.txt *****************

TITLE: My Test of Class Doconce
AUTHOR: Hans Petter Langtangen; Simula Research Laboratory; Dept. of Informatics, Univ. of Oslo
DATE: Sun, 24 Jun 2012 (13:47)



_______First Section_______


Here is some
text for section 1.

This is a *first* example of using the _DocWriter
module_ for writing documents from *Python* scripts.
It could be a nice tool since we do not need to bother
with special typesetting, such as `fixed width fonts`
in plain text.

_____First Subsection_____

Some text for the subsection.

__Test of a Paragraph.__ 
Some paragraph text taken from "Documenting Python": The Python language
has a substantial body of documentation, much of it contributed by various
authors. The markup used for the Python documentation is based on
LaTeX and requires a significant set of macros written specifically
for documenting Python. This document describes the macros introduced
to support Python documentation and how they should be used to support
a wide range of output formats.

This document describes the document classes and special markup used
in the Python documentation. Authors may use this guide, in
conjunction with the template files provided with the distribution, to
create or maintain whole documents or sections.

If you're interested in contributing to Python's documentation,
there's no need to learn LaTeX if you're not so inclined; plain text
contributions are more than welcome as well.
Here is an enumerate list:
o item1
o item2

    o subitem1
    o subitem2

o item3

    o subitem3
    o subitem4
...with some trailing text.
___First Subsubsection with an Itemize List___


* item1
* item2

    * subitem1
    * subitem2

* item3

    * subitem3
    * subitem4
Here is some Python code:
!bc

class A:
    pass

class B(A):
    pass

b = B()
b.item = 0  # create a new attribute

!ec

_______Second Section_______

Here is a description list:
- keyword1:  item1
- keyword2:  item2 goes here, with a colon : and some text after

    - key3:  subitem1
    - key4:  subitem2

- key5:  item3

    - key6:  subitem3
    - key7:  subitem4


And here is a table:

   |---------------------------------------|
   | a                 | b                 |
   | c                 | d                 |
   | e                 | and a longer text |
   |---------------------------------------|


************** File: tmp_DocWriter.do.txt *****************

TITLE: My Test of Class DocWriter
AUTHOR: Hans Petter Langtangen; Simula Research Laboratory; Dept. of Informatics, Univ. of Oslo
DATE: Sun, 24 Jun 2012 (13:47)



_______First Section_______


Here is some
text for section 1.

This is a *first* example of using the _DocWriter
module_ for writing documents from *Python* scripts.
It could be a nice tool since we do not need to bother
with special typesetting, such as `fixed width fonts`
in plain text.

_____First Subsection_____

Some text for the subsection.

__Test of a Paragraph.__ 
Some paragraph text taken from "Documenting Python": The Python language
has a substantial body of documentation, much of it contributed by various
authors. The markup used for the Python documentation is based on
LaTeX and requires a significant set of macros written specifically
for documenting Python. This document describes the macros introduced
to support Python documentation and how they should be used to support
a wide range of output formats.

This document describes the document classes and special markup used
in the Python documentation. Authors may use this guide, in
conjunction with the template files provided with the distribution, to
create or maintain whole documents or sections.

If you're interested in contributing to Python's documentation,
there's no need to learn LaTeX if you're not so inclined; plain text
contributions are more than welcome as well.
Here is an enumerate list:
o item1
o item2

    o subitem1
    o subitem2

o item3

    o subitem3
    o subitem4
...with some trailing text.
___First Subsubsection with an Itemize List___


* item1
* item2

    * subitem1
    * subitem2

* item3

    * subitem3
    * subitem4
Here is some Python code:
!bc

class A:
    pass

class B(A):
    pass

b = B()
b.item = 0  # create a new attribute

!ec

_______Second Section_______

Here is a description list:
- keyword1:  item1
- keyword2:  item2 goes here, with a colon : and some text after

    - key3:  subitem1
    - key4:  subitem2

- key5:  item3

    - key6:  subitem3
    - key7:  subitem4


And here is a table:

   |---------------------------------------|
   | a                 | b                 |
   | c                 | d                 |
   | e                 | and a longer text |
   |---------------------------------------|


************** File: tmp_DocWriter.html *****************
<!-- HTML document generated by __main__.HTML -->
<html>
<body bgcolor="white">

<title>My Test of Class DocWriter</title>
<center><h1>My Test of Class DocWriter</h1></center>

<center>
<h4>Hans Petter Langtangen</h4>
<h6>Simula Research Laboratory</h6>
<h6>Dept. of Informatics, Univ. of Oslo</h6>
</center>

<center>Sun, 24 Jun 2012 (13:47)</center>



<p>

<h1>First Section</h1>

Here is some
text for section 1.

This is a <em>first</em> example of using the <b>DocWriter
module</b> for writing documents from <em>Python</em> scripts.
It could be a nice tool since we do not need to bother
with special typesetting, such as <tt>fixed width fonts</tt>
in plain text.

<h3>First Subsection</h3>
Some text for the subsection.

<p><!-- paragraph with heading -->
<b>Test of a Paragraph.</b>

Some paragraph text taken from "Documenting Python": The Python language
has a substantial body of documentation, much of it contributed by various
authors. The markup used for the Python documentation is based on
LaTeX and requires a significant set of macros written specifically
for documenting Python. This document describes the macros introduced
to support Python documentation and how they should be used to support
a wide range of output formats.

This document describes the document classes and special markup used
in the Python documentation. Authors may use this guide, in
conjunction with the template files provided with the distribution, to
create or maintain whole documents or sections.

If you're interested in contributing to Python's documentation,
there's no need to learn LaTeX if you're not so inclined; plain text
contributions are more than welcome as well.
Here is an enumerate list:
<ol> <!-- start of "enumerate" list -->
<p><li> item1
<p><li> item2

  <ol> <!-- start of "enumerate" list -->
    <p><li> subitem1
    <p><li> subitem2
  </ol> <!-- end of "enumerate" list -->
<p><li> item3

  <ol> <!-- start of "enumerate" list -->
    <p><li> subitem3
    <p><li> subitem4
  </ol> <!-- end of "enumerate" list -->
</ol> <!-- end of "enumerate" list -->
...with some trailing text.
<h4>First Subsubsection with an Itemize List</h4>

<ul> <!-- start of "itemize" list -->
<p><li> item1
<p><li> item2

  <ul> <!-- start of "itemize" list -->
    <p><li> subitem1
    <p><li> subitem2
  </ul> <!-- end of "itemize" list -->
<p><li> item3

  <ul> <!-- start of "itemize" list -->
    <p><li> subitem3
    <p><li> subitem4
  </ul> <!-- end of "itemize" list -->
</ul> <!-- end of "itemize" list -->
Here is some Python code:
<pre>
class A:
    pass

class B(A):
    pass

b = B()
b.item = 0  # create a new attribute

</pre>

<h1>Second Section</h1>
Here is a description list:
<dl> <!-- start of "description" list -->
<p><dt>keyword1</dt><dd> item1</dd>
<p><dt>keyword2</dt><dd> item2 goes here, with a colon : and some text after</dd>

  <dl> <!-- start of "description" list -->
    <p><dt>key3</dt><dd> subitem1</dd>
    <p><dt>key4</dt><dd> subitem2</dd>
  </dl> <!-- end of "description" list -->
<p><dt>key5</dt><dd> item3</dd>

  <dl> <!-- start of "description" list -->
    <p><dt>key6</dt><dd> subitem3</dd>
    <p><dt>key7</dt><dd> subitem4</dd>
  </dl> <!-- end of "description" list -->
</dl> <!-- end of "description" list -->

<p>
And here is a table:
<p>
<table border="2" cellpadding="5" cellspacing="2">
<tr><td>a</td><td>b</td></tr>
<tr><td>c</td><td>d</td></tr>
<tr><td>e</td><td>and a longer text</td></tr>
</table>


</body>
</html>

************** File: tmp_HTML.html *****************
<!-- HTML document generated by __main__.HTML -->
<html>
<body bgcolor="white">

<title>My Test of Class HTML</title>
<center><h1>My Test of Class HTML</h1></center>

<center>
<h4>Hans Petter Langtangen</h4>
<h6>Simula Research Laboratory</h6>
<h6>Dept. of Informatics, Univ. of Oslo</h6>
</center>

<center>Sun, 24 Jun 2012 (13:47)</center>



<p>

<h1>First Section</h1>

Here is some
text for section 1.

This is a <em>first</em> example of using the <b>DocWriter
module</b> for writing documents from <em>Python</em> scripts.
It could be a nice tool since we do not need to bother
with special typesetting, such as <tt>fixed width fonts</tt>
in plain text.

<h3>First Subsection</h3>
Some text for the subsection.

<p><!-- paragraph with heading -->
<b>Test of a Paragraph.</b>

Some paragraph text taken from "Documenting Python": The Python language
has a substantial body of documentation, much of it contributed by various
authors. The markup used for the Python documentation is based on
LaTeX and requires a significant set of macros written specifically
for documenting Python. This document describes the macros introduced
to support Python documentation and how they should be used to support
a wide range of output formats.

This document describes the document classes and special markup used
in the Python documentation. Authors may use this guide, in
conjunction with the template files provided with the distribution, to
create or maintain whole documents or sections.

If you're interested in contributing to Python's documentation,
there's no need to learn LaTeX if you're not so inclined; plain text
contributions are more than welcome as well.
Here is an enumerate list:
<ol> <!-- start of "enumerate" list -->
<p><li> item1
<p><li> item2

  <ol> <!-- start of "enumerate" list -->
    <p><li> subitem1
    <p><li> subitem2
  </ol> <!-- end of "enumerate" list -->
<p><li> item3

  <ol> <!-- start of "enumerate" list -->
    <p><li> subitem3
    <p><li> subitem4
  </ol> <!-- end of "enumerate" list -->
</ol> <!-- end of "enumerate" list -->
...with some trailing text.
<h4>First Subsubsection with an Itemize List</h4>

<ul> <!-- start of "itemize" list -->
<p><li> item1
<p><li> item2

  <ul> <!-- start of "itemize" list -->
    <p><li> subitem1
    <p><li> subitem2
  </ul> <!-- end of "itemize" list -->
<p><li> item3

  <ul> <!-- start of "itemize" list -->
    <p><li> subitem3
    <p><li> subitem4
  </ul> <!-- end of "itemize" list -->
</ul> <!-- end of "itemize" list -->
Here is some Python code:
<pre>
class A:
    pass

class B(A):
    pass

b = B()
b.item = 0  # create a new attribute

</pre>

<h1>Second Section</h1>
Here is a description list:
<dl> <!-- start of "description" list -->
<p><dt>keyword1</dt><dd> item1</dd>
<p><dt>keyword2</dt><dd> item2 goes here, with a colon : and some text after</dd>

  <dl> <!-- start of "description" list -->
    <p><dt>key3</dt><dd> subitem1</dd>
    <p><dt>key4</dt><dd> subitem2</dd>
  </dl> <!-- end of "description" list -->
<p><dt>key5</dt><dd> item3</dd>

  <dl> <!-- start of "description" list -->
    <p><dt>key6</dt><dd> subitem3</dd>
    <p><dt>key7</dt><dd> subitem4</dd>
  </dl> <!-- end of "description" list -->
</dl> <!-- end of "description" list -->

<p>
And here is a table:
<p>
<table border="2" cellpadding="5" cellspacing="2">
<tr><td>a</td><td>b</td></tr>
<tr><td>c</td><td>d</td></tr>
<tr><td>e</td><td>and a longer text</td></tr>
</table>


</body>
</html>

************** File: make.sh *****************
#!/bin/sh -x
# Compile the Doconce manual, manual.do.txt, in a variety of
# formats to exemplify how different formats may look like.
# This is both a test of Doconce and an example.

./clean.sh

# The following packages must be installed for this script to run:
# doconce, ptex2tex, docutils, preprocess, sphinx

d2f="doconce format"
# doconce html format:
$d2f html manual.do.txt

# Sphinx
$d2f sphinx manual.do.txt
rm -rf sphinx-rootdir
# We have several examples on AUTHOR: so to avoid multiple
# authors we have to specify
doconce sphinx_dir author=HPL title='Doconce Manual' version=0.6 manual.do.txt
cp manual.rst manual.sphinx.rst
cp manual.rst sphinx-rootdir
cp -r figs sphinx-rootdir
# run sphinx:
cd sphinx-rootdir
make clean
make html
make latex
doconce subst '\.\*' '.pdf' _build/latex/DoconceManual.tex  # .* doesn't work
ln -s `pwd`/../figs _build/latex/figs
cd _build/latex
make clean
# encounter some strange error with labels...
make all-pdf <<EOF
r
EOF
cp DoconceManual.pdf ../../../manual.sphinx.pdf
cd ../../..


# rst:
$d2f rst manual.do.txt

rst2html.py manual.rst > manual.rst.html
rst2xml.py manual.rst > manual.xml

rst2latex.py manual.rst > manual.rst.tex

# fix figure extension:
# lookahead don't work: doconce subst '(?=includegraphics.+)\.png' '.eps' manual.rst.tex
doconce subst '\.png' '' manual.rst.tex   # no extension in graphics file
latex manual.rst.tex   # pdflatex works too
latex manual.rst.tex
dvipdf manual.rst.dvi

# plain text:
$d2f plain manual.do.txt --skip_inline_comments

$d2f epytext manual.do.txt
$d2f st manual.do.txt
$d2f pandoc manual.do.txt

# doconce pdflatex:
$d2f pdflatex manual.do.txt
doconce replace 'usepackage{ptex2tex' 'usepackage{ptex2tex,subfigure' manual.p.tex  # need subfigure latex package
ptex2tex -DMINTED manual    # turn ptex2tex format into plain latex
pdflatex -shell-escape manual
bibtex manual
makeindex manual
pdflatex -shell-escape manual
pdflatex -shell-escape manual
cp manual.pdf manual_pdflatex.pdf

# doconce latex:
$d2f latex manual.do.txt    # produces ptex2tex: manual.p.tex
doconce replace 'usepackage{ptex2tex' 'usepackage{ptex2tex,subfigure' manual.p.tex  # need subfigure latex package
ptex2tex -DMINTED manual    # turn ptex2tex format into plain latex
latex -shell-escape manual
latex -shell-escape manual
bibtex manual
makeindex manual
latex -shell-escape manual
latex -shell-escape manual
dvipdf manual.dvi

# Google Code wiki:
$d2f gwiki manual.do.txt

# fix figure in wiki: (can also by done by doconce gwiki_figsubst)
doconce subst "\(the URL of the image file figs/streamtubes.png must be inserted here\)" "https://doconce.googlecode.com/hg/doc/manual/figs/streamtubes.png" manual.gwiki

$d2f cwiki manual.do.txt
$d2f mwiki manual.do.txt

rm -f *.ps

rm -rf demo
mkdir demo
cp -r manual.do.txt manual.html figs manual.p.tex manual.tex manual.pdf manual_pdflatex.pdf manual.rst manual.sphinx.rst manual.sphinx.pdf manual.xml manual.rst.html manual.rst.tex manual.rst.pdf manual.gwiki manual.cwiki manual.mwiki manual.txt manual.epytext manual.st manual.mkd sphinx-rootdir/_build/html demo

cd demo
cat > index.html <<EOF
<HTML><BODY>
<TITLE>Demo of Doconce formats</TITLE>
<H3>Doconce demo</H3>

Doconce is a minimum tagged markup language. The file
<a href="manual.do.txt">manual.do.txt</a> is the source of
a Doconce Description, written in the Doconce format.
Running
<pre>
doconce format html manual.do.txt
</pre>
produces the HTML file <a href="manual.html">manual.html</a>.
Going from Doconce to LaTeX is done by
<pre>
doconce format latex manual.do.txt
</pre>
resulting in the file <a href="manual.tex">manual.tex</a>, which can
be compiled to a PDF file <a href="manual.pdf">manual.pdf</a>
by running <tt>latex</tt> and <tt>dvipdf</tt> the standard way.
<p>
The reStructuredText (reST) format is of particular interest:
<pre>
doconce format rst    manual.do.txt  # standard reST
doconce format sphinx manual.do.txt  # Sphinx extension of reST
</pre>
The reST file <a href="manual.rst">manual.rst</a> is a starting point
for conversion to many other formats: OpenOffice,
<a href="manual.xml">XML</a>, <a href="manual.rst.html">HTML</a>,
<a href="manual.rst.tex">LaTeX</a>,
and from LaTeX to <a href="manual.rst.pdf">PDF</a>.
The <a href="manual.sphinx.rst">Sphinx</a> dialect of reST
can be translated to <a href="manual.sphinx.pdf">PDF</a>
and <a href="html/index.html">HTML</a>.
<p>
Doconce can also be converted to
<a href="manual.gwiki">Googlecode wiki</a>,
<a href="manual.cwiki">Creole wiki</a>,
<a href="manual.mwiki">MediaWiki</a>,
<a href="manual.mkd">Pandoc</a>,
<a href="manual.st">Structured Text</a>,
<a href="manual.epytext">Epytext</a>,
and maybe the most important format of all:
<a href="manual.txt">plain untagged ASCII text</a>.
</BODY>
</HTML>
EOF

cd ..
rm -rf ../demos/manual
cp -r demo ../demos/manual
# update wiki too
cp manual.gwiki ../../../doconce.wiki/Description.wiki
echo
echo "Go to the demo directory and load index.html into a web browser."
************** File: manual.do.txt *****************
TITLE: Doconce Description
AUTHOR: Hans Petter Langtangen at Simula Research Laboratory and University of Oslo
DATE: today


# lines beginning with # are comment lines


======= What Is Doconce? =======
label{what:is:doconce}
idx{doconce!short explanation}

# #include "../tutorial/_what_is.do.txt"

# #include "_install.do.txt"

#
# Here are some comment lines that do not affect any formatting
# these lines are converted to comments in the output format.
# This may have some side effects, especially in rst and sphinx
# where lines following the comment may be taken as part of
# the comment if there are no blank lines after the comment.
#
# One can use ## and the mako preprocessor to remove comments
# *before* doconce sees the text. That can be useful when
# doconce comments interferes with formatting.
# The mako tool also supports <%doc> .. </%doc>
#


===== Demos =====

idx{demos}

The current text is generated from a Doconce format stored in the
!bc sys
docs/manual/manual.do.txt
!ec
file in the Doconce source code tree. We have made a
"demo web page": "https://doconce.googlecode.com/hg/doc/demos/manual/index.html"
where you can compare the Doconce source with the output in many
different formats: HTML, LaTeX, plain text, etc.

The file `make.sh` in the same directory as the `manual.do.txt` file
(the current text) shows how to run `doconce format` on the
Doconce file to obtain documents in various formats.

Another demo is found in
!bc sys
docs/tutorial/tutorial.do.txt
!ec
In the `tutorial` directory there is also a `make.sh` file producing a
lot of formats, with a corresponding
"web demo": "https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html"
of the results.

# Example on including another Doconce file:

# #include "../tutorial/_doconce2anything.do.txt"



======= The Doconce Markup Language =======

The Doconce format introduces four constructs to markup text:
lists, special lines, inline tags, and environments.

===== Lists =====

An unordered bullet list makes use of the `*` as bullet sign
and is indented as follows

!bc
   * item 1

   * item 2

     * subitem 1, if there are more
       lines, each line must
       be intended as shown here

     * subitem 2,
       also spans two lines

   * item 3
!ec

This list gets typeset as

   * item 1

   * item 2

     * subitem 1, if there are more
       lines, each line must
       be intended as shown here

     * subitem 2,
       also spans two lines

   * item 3

# #if FORMAT == "gwiki"
(As seen, nested lists in (g)wiki format are not treated well by
Doconce. Plain unnested lists work fine. And the (g)wiki format
automatically puts multiple lines of an item on a single line as
required :-)
# #endif

In an ordered list, each item starts with an `o` (as the first letter
in "ordered"):

!bc
   o item 1

   o item 2

     * subitem 1

     * subitem 2

   o item 3
!ec

resulting in

   o item 1

   o item 2

     * subitem 1

     * subitem 2

   o item 3

# #if FORMAT == "gwiki"
(Again, there are problems with mixing nested lists and liststypes
for the (g)wiki format.)
# #endif

Ordered lists cannot have an ordered sublist, i.e., the ordering
applies to the outer list only.

In a description list, each item is recognized by a dash followed
by a keyword followed by a colon:

!bc
   - keyword1: explanation of keyword1

   - keyword2: explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)
!ec

The result becomes

   - keyword1: explanation of keyword1

   - keyword2: explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)


===== Special Lines =====

The Doconce markup language has a concept called *special lines*.
Such lines starts with a markup at the very beginning of the
line and are used to mark document title, authors, date,
sections, subsections, paragraphs., figures, movies, etc.

idx{`TITLE` keyword} idx{`AUTHOR` keyword} idx{`DATE` keyword}

__Heading with Title and Author(s).__
Lines starting with `TITLE:`, `AUTHOR:`, and `DATE:` are optional and used
to identify a title of the document, the authors, and the date. The
title is treated as the rest of the line, so is the date, but the
author text consists of the name and associated institution(s) with
the syntax
!bc
name at institution1 and institution2 and institution3
!ec
The `at` with surrounding spaces
is essential for adding information about institution(s)
to the author name, and the `and` with surrounding spaces is
essential as delimiter between different institutions.
An email address can optionally be included, using the syntax
!bc
name Email: somename@site.net at institution1 and institution2
!ec
Multiple authors require multiple `AUTHOR:` lines. All information
associated with `TITLE:` and `AUTHOR:` keywords must appear on a single
line.  Here is an example:
!bc
TITLE: On an Ultimate Markup Language
AUTHOR: H. P. Langtangen at Center for Biomedical Computing, Simula Research Laboratory and Dept. of Informatics, Univ. of Oslo
AUTHOR: Kaare Dump Email: dump@cyb.space.com at Segfault, Cyberspace Inc.
AUTHOR: A. Dummy Author
DATE: November 9, 2016
!ec
Note how one can specify a single institution, multiple institutions,
and no institution. In some formats (including `rst` and `sphinx`)
only the author names appear. Some formats have
"intelligence" in listing authors and institutions, e.g., the plain text
format:
!bc
Hans Petter Langtangen [1, 2]
Kaare Dump  (dump@cyb.space.com) [3]
A. Dummy Author

[1] Center for Biomedical Computing, Simula Research Laboratory
[2] Department of Informatics, University of Oslo
[3] Segfault, Cyberspace Inc.
!ec
Similar typesetting is done for LaTeX and HTML formats.

The current date can be specified as `today`.

idx{headlines} idx{section headings}

__Section Headings.__
Section headings are recognized by being surrounded by equal signs (=) or
underscores before and after the text of the headline. Different
section levels are recognized by the associated number of underscores
or equal signs (=):

   * 9 `=` characters for chapters
   * 7 for sections
   * 5 for subsections
   * 3 for subsubsections
   * 2 *underscrores* (only! - it looks best) for paragraphs
     (paragraph heading will be inlined)

Headings can be surrounded by as many blanks as desired.

Doconce also supports abstracts. This is typeset as a paragraph, but
*must* be followed by a section heading (everything up to the first
section heading is taken as part of the text of the abstract).


Here are some examples:
!bc
__Abstract.__ The following text just attempts to exemplify
various section headings.

========= Example on a Chapter Heading =========

Some text.


======= Example on a Section Heading =======

The running text goes here.


===== Example on a Subsection Heading =====

The running text goes here.

===Example on a Subsubsection Heading===

The running text goes here.

__A Paragraph.__ The running text goes here.
!ec

======= Special Lines =======

===== Figures =====

Figures are recognized by the special line syntax
!bc
FIGURE:[filename, height=xxx width=yyy scale=zzz] possible caption
!ec
The filename can be without extension, and Doconce will search for an
appropriate file with the right extension. If the extension is wrong,
say `.eps` when requesting an HTML format, Doconce tries to find another
file, and if not, the given file is converted to a proper format
(using ImageMagick's `convert` utility).

The height, width, and scale keywords (and others) can be included
if desired and may have effect for some formats. Note the comma
between the sespecifications and that there should be no space
around the = sign.

Note also that, like for `TITLE:` and `AUTHOR:` lines, all information
related to a figure line *must be written on the same line*. Introducing
newlines in a long caption will destroy the formatting (only the
part of the caption appearing on the same line as `FIGURE:` will be
included in the formatted caption).

FIGURE:[figs/streamtubes, width=400] Streamtube visualization of a fluid flow. label{fig:viz}

Combining several image files into one can be done by the
`convert` and `montage` programs from the ImageMagick suite:
!bc sys
montage file1.png file2.png ... file4.png -geometry +2+2  result.png
montage file1.png file2.png -tile x1 result.png
montage file1.png file2.png -tile 1x result.png

convert -background white file1.png file2.png +append tmp.png
!ec
Use `+append` for stacking left to right, `-append` for top to bottom.
The positioning of the figures can be controlled by `-gravity`.

===== Movies =====

Here is an example on the `MOVIE:` keyword for embedding movies. This
feature works well for the `latex`, `html`, `rst`, and `sphinx` formats.
Other formats try to generate some HTML file and link to that file
for showing the movie.
!bc
MOVIE: [filename, height=xxx width=yyy] possible caption
!ec

# latex/PDF format can make use of the movie15 package for displaying movies,
# or just plain \href{run: ...}{...}

MOVIE: [figs/mjolnir.mpeg, width=600 height=470]

#MOVIE: [figs/wavepacket.gif, width=600 height=470]

#MOVIE: [figs/wavepacket2.mpeg, width=600 height=470]

The LaTeX format results in a file that can either make use of
the movie15 package (requires the PDF to be shown in Acrobat Reader)
or just a plain address to the movie. The HTML, reST, and
Sphinx formats will play
the movie right away by embedding the file in a standard HTML code,
provided the output format is HTML.
For all other formats a URL to an HTML file, which can play the code,
is inserted in the output document.

When movies are embedded in the PDF file via LaTeX and
the `movie15` package wanted, one has to turn on the preprocessor
variable `MOVIE15`. There is an associated variable
`EXTERNAL_MOVIE_VIEWER` which can be defined to launch an external
viewer when displaying the PDF file (in Acrobat Reader):
!bc sys
Terminal> ptex2tex -DMOVIE15 -DEXTERNAL_MOVIE_VIEWER mydoc
!ec

The HTML, reST, and Sphinx formats can also treat filenames of the form
`myframes*.png`. In that case, an HTML file for showing the sequence of frames
is generated, and a link to this file is inserted in the output document.
That is, a simple "movie viewer" for the frames is made.

Many publish their scientific movies on YouTube, and Doconce recognizes
YouTube URLs as movies. When the output is an HTML file, the movie will
be embedded, otherwise a URL to the YouTube page is inserted.
You should equip the `MOVIE:` command with the right width and height
of embedded YouTube movies (the parameters appear when you request
the embedded HTML code for the movie on the YouTube page).



===== Copying Computer Code from Source Files =====

Another type of special lines starts with `@@@CODE` and enables copying
of computer code from a file directly into a verbatim environment, see
Section ref{sec:verbatim:blocks} below.


===== Inline Tagging =====
label{inline:tagging}
idx{inline tagging} idx{emphasized words} idx{boldface words} idx{verbatim text}
idx{inline comments}

Doconce supports tags for *emphasized phrases*, _boldface phrases_,
and `verbatim text` (also called type writer text, for inline code)
plus LaTeX/TeX inline mathematics, such as $\nu = \sin(x)$|$v = sin(x)$.

Emphasized text is typeset inside a pair of asterisk, and there should
be no spaces between an asterisk and the emphasized text, as in
!bc
*emphasized words*
!ec

Boldface font is recognized by an underscore instead of an asterisk:
!bc
_several words in boldface_ followed by *ephasized text*.
!ec
The line above gets typeset as
_several words in boldface_ followed by *ephasized text*.

Verbatim text, typically used for short inline code,
is typeset between back-ticks:
!bc
`call myroutine(a, b)` looks like a Fortran call
while `void myfunc(double *a, double *b)` must be C.
!ec
The typesetting result looks like this:
`call myroutine(a, b)` looks like a Fortran call
while `void myfunc(double *a, double *b)` must be C.

It is recommended to have inline verbatim text on the same line in
the Doconce file, because some formats (LaTeX and `ptex2tex`) will have
problems with inline verbatim text that is split over two lines.

Watch out for mixing back-ticks and asterisk (i.e., verbatim and
emphasized code): the Doconce interpreter is not very smart so inline
computer code can soon lead to problems in the final format. Go back to the
Doconce source and modify it so the format to which you want to go
becomes correct (sometimes a trial and error process - sticking to
very simple formatting usually avoids such problems).

Web addresses with links are typeset as
!bc
some URL like "Doconce": "http://code.google.com/p/doconce"
!ec
which appears as some URL like "Search Google": "http://google.com".
The space after colon is optional.
Links to files ending in `.txt`, `.html`, `.pdf`, `.py`, `.f`,
`.f77`, `.f90`, `.f95`, `.sh`, `.csh`, `.ksh`, `.zsh`,
`.c`, `.cpp`, `.cxx`, `.pl`, and `.java` follows the same
setup:
!bc
see the "Doconce Manual": "manual.do.txt".
!ec
which appears as see the "Doconce Manual": "manual.do.txt".
If you want to view such source code files *in the browser*,
rather than dowloading the file, we recommend to transform
the source code file to HTML format by running
`pygmentize`, e.g.,
!bc sys
Terminal> pygmentize -l bash -f html -O full,style=emacs \
          -o _static/make.sh.html subdir/make.sh
!ec
Then you can link to `_static/make.sh.html` instead of
`subdir/make.sh`. Or you can do both versions:
!bc
See the code URL:"src/myprog.py" ("view: "_static/myprog.py.html").
!ec

Links to files with other extensions must be realized
*with the filename as link text*, written as
the keyword URL, followed by a colon, and then the filename enclosed
in double quotes:
!bc
URL: "manual.html"
!ec
resulting in the link URL: "manual.html".

# This is now automatically carried out by the autogenerated
# script for sphinx:
#For such local links to
#work with the `sphinx` format, the `.rst` file needs a fix, carried
#out by
#!bc sys
#doconce sphinxfix_localURLs mydoc.rst
#!ec
#(The files, such as `manual.html`, are then copied to a subdirectory
#`_static`, which must be manually copied to the Sphinx directory's
#`_static` directory - links in the `.rst` files are automatically
#adjusted.)

To have the URL address itself as link text, put an "URL" or URL
before the address enclosed in double quotes:
!bc
Click on this link: URL:"http://code.google.com/p/doconce".
!ec
resulting in Click on this link: URL: "http://code.google.com/p/doconce".

Doconce also supports inline comments in the text:
!bc
[name: comment]
!ec
where `name` is the name of the author of the command, and `comment` is a
plain text text. [hpl: Note that there must be a space after the colon,
otherwise the comment is not recognized. Inline comments
can span
several lines,
if desired.]
The name and comment are visible in the output unless `doconce format`
is run with a command-line argument `--skip_inline_comments`
(see Chapter ref{doconce2formats} for an example). Inline comments
are helpful during development of a document since different authors
and readers can comment on formulations, missing points, etc.
All such comments can easily be removed from the `.do.txt` file
(see Chapter ref{doconce2formats}).

Inline mathematics is written as in LaTeX, i.e., inside dollar signs.
Most formats leave this syntax as it is (including to dollar signs),
hence nice math formatting is only obtained in LaTeX (Epytext has some
inline math support that is utilized).  However, mathematical
expressions in LaTeX syntax often contains special formatting
commands, which may appear annoying in plain text. Doconce therefore
supports an extended inline math syntax where the writer can provide
an alternative syntax suited for formats close to plain ASCII:
!bc
Here is an example on a linear system
${\bf A}{\bf x} = {\bf b}$|$Ax=b$,
where $\bf A$|$A$ is an $n\times n$|$nxn$ matrix, and
$\bf x$|$x$ and $\bf b$|$b$ are vectors of length $n$|$n$.
!ec
That is, we provide two alternative expressions, both enclosed in
dollar signs and separated by a pipe symbol, the expression to the
left is used in LaTeX, while the expression to the right is used for
all other formats.  The above text is typeset as "Here is an example
on a linear system ${\bf A}{\bf x} = {\bf b}$|$Ax=b$, where $\bf A$|$A$
is an $n\times n$|$nxn$ matrix, and $\bf x$|$x$ and $\bf b$|$b$
are vectors of length $n$|$n$."

===== Comments ======

Comments intended to be visible in the output document and read by
readers are known as *inline comments* in Doconce and described
in Section ref{inline:tagging}.

Here we address comments in the Doconce source file that are not
intended to be visible in the output document. Basic comment
lines start with the hash `#`:
!bc
#
# Here are some comment lines that do not affect any formatting.
# These lines are converted to comments in the output format.
#
!ec
Such comment lines may have some side effects in the `rst` and `sphinx`
formats because following lines are taken as part of the comment if
there is not a blank line after the comment.

The Mako preprocessor supports comments that are filtered out *before*
Doconce starts translating the document. Such comments are very valuable
as they will never interfere with the output format and they are only
present in the Doconce source. Mako has two types of comments:
lines starting with a double hash `##` and lines enclosed by
the `<%doc>` (beginning) and `<%doc/>` (closing) tags.

If you need a lot of comments in the Doconce file, consider using
Mako comments instead of the single hash, unless you want to
comments to be in the source code of the output document.


===== Cross-Referencing =====
idx{cross referencing} idx{labels} idx{references}

References and labels are supported. The syntax is simple:
!bc
label{section:verbatim}   # defines a label
For more information we refer to Section ref{section:verbatim}.
!ec
This syntax is close that that of labels and cross-references in
LaTeX. When the label is placed after a section or subsection heading,
the plain text, Epytext, and StructuredText formats will simply
replace the reference by the title of the (sub)section.  All labels
will become invisible, except those in math environments.  In the
`rst` and `sphinx` formats, the end effect is the same, but
the "label" and "ref" commands are first translated to the proper
reST commands by `doconce format`. In the HTML and (Google
Code) wiki formats, labels become anchors and references become links,
and with LaTeX "label" and "ref" are just equipped with backslashes so
these commands work as usual in LaTeX.

It is, in general, recommended to use labels and references for
(sub)sections, equations, and figures only.
By the way, here is an example on referencing Figure ref{fig:viz}
(the label appears in the figure caption in the source code of this document).
Additional references to Sections ref{mathtext} and ref{newcommands} are
nice to demonstrate, as well as a reference to equations,
say (ref{my:eq1})--(ref{my:eq2}). A comparison of the output and
the source of this document illustrates how labels and references
are handled by the format in question.

Hyperlinks to files or web addresses are handled as explained
in Section ref{inline:tagging}.

===== Index and Bibliography =====
idx{index} idx{citations} idx{bibliography}

An index can be created for the `latex`, `rst`, and `sphinx` formats
by the `idx` keyword, following a LaTeX-inspired syntax:
!bc
idx{some index entry}
idx{main entry!subentry}
idx{`verbatim_text` and more}
!ec
The exclamation mark divides a main entry and a subentry. Backquotes
surround verbatim text, which is correctly transformed in a LaTeX setting to
!bc
\index{verbatim\_text@\texttt{\rm\smaller verbatim\_text and more}}
!ec
Everything related to the index simply becomes invisible in plain
text, Epytext, StructuredText, HTML, and wiki formats.  Note: `idx`
commands should be inserted outside paragraphs, not in between the
text as this may cause some strange behaviour of reST and
Sphinx formatting.  As a recommended rule, index items are naturally
placed right after section headings, before the text begins, while
index items related to a paragraph should be placed above the
paragraph one a separate line (and not in between the text or between
the paragraph heading and the text body, although this works fine if
LaTeX is the output format).

Literature citations also follow a LaTeX-inspired style:
!bc
as found in cite{Larsen_1986,Nielsen_Kjeldstrup_1999}.
!ec
Citation labels can be separated by comma. In LaTeX, this is directly
translated to the corresponding `cite` command; in reST
and Sphinx the labels can be clicked, while in all the other text
formats the labels are consecutively numbered so the above citation
will typically look like
!bc
as found in [3][14]
!ec
if `Larsen_1986` has already appeared in the 3rd citation in the document
and `Nielsen_Kjeldstrup_1999` is a new (the 14th) citation. The citation labels
can be any sequence of characters, except for curly braces and comma.

The bibliography itself is specified by the special keyword `BIBFILE:`,
which is optionally followed by a BibTeX file, having extension `.bib`,
a corresponding reST bibliography, having extension `.rst`,
or simply a Python dictionary written in a file with extension `.py`.
The dictionary in the latter file should have the citation labels as
keys, with corresponding values as the full reference text for an item
in the bibliography. Doconce markup can be used in this text, e.g.,
!bc
{
'Nielsen_Kjeldstrup_1999': """
K. Nielsen and A. Kjeldstrup. *Some Comments on Markup Languages*.
URL:"http://some.where.net/nielsen/comments", 1999.
""",
'Larsen_1986':
"""
O. B. Larsen. On Markup and Generality.
*Personal Press*. 1986.
"""
}
!ec
In the LaTeX format, the `.bib` file will be used in the standard way,
in the `rst` and `sphinx` formats, the `.rst` file will be
copied into the document at the place where the `BIBFILE:` keyword
appears, while all other formats will make use of the Python dictionary
typeset as an ordered Doconce list, replacing the `BIBFILE:` line
in the document.

At present, only one file with bibliographic references can be used.

# see ketch/tex2rst for nice bibtex to rst converter which could
# be used here

Conversion of BibTeX databases to reST format can be
done by the "bibliograph.parsing":"http://pypi.python.org/pypi/bibliograph.parsing/" tool.

Finally, we here test the citation command and bibliography by
citing a book cite{Python:Primer:09}, a paper cite{Osnes:98},
and both of them simultaneously cite{Python:Primer:09,Osnes:98}.

[somereader: comments, citations, and references in the latex style
is a special feature of doconce :-) ]


===== Tables =====

A table like

  |--------------------------------|
  |time  | velocity | acceleration |
  |--r--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

is built up of pipe symbols and dashes:
!bc
  |--------------------------------|
  |time  | velocity | acceleration |
  |--------------------------------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
!ec
The pipes and column values do not need to be aligned (but why write
the Doconce source in an ugly way?). In the line below the heading,
one can insert the characters `c`, `r`, or `l` to specify the
alignment of the columns (centered, right, or left, respectively).
Similar character can be inserted in the line above the header to
algn the headings. Pipes `|` can also be inserted to indicate
vertical rules in LaTeX tables (they are ignored for other formats).
Note that not all formats offer alignment of heading or entries
in tables (`rst` and `sphinx` are examples). Also note that
Doconce tables are very simple: neither entries nor
headings can span several columns or rows. When that functionality
is needed, one can make use of the preprocessor and if-tests on
the format and insert format-specific code for tables.



===== Exercises, Problems, or Projects =====

Doconce has special support for three types of "exercises", named
*exercise*, *problem*, or *project*.
These are all typeset as special kind of
sections. Such sections start with a subsection or subsubsection
headline, indicated by 3 or 5 `=` characters, and last up to the
next headline or the end of the file. The headline itself must
consists of the word "Exercise", "Problem", or "Project", followed
by a colon and a title of the exercise, problem, or project.
The next line(s) may contain a label and specification of the
name of result file (if the answer to the exercise is to be handed
it) and a solution file:
!bc
===== Project: Determine the Distance to the Moon =====
label{proj:moondist} file=earth2moon.pdf
solution=eart2moon_sol.do.txt

Here goes the running text of the project....

__Hint 1.__ Do not plan a travel to the moon.

__Hint 2.__ Wikipedia is always helpful.
!ec
Doconce will recognize the exercise, problem, or project *title*,
the *label*, the *result file*, the *solution file* (if any of
these three entities is present), the *text*, and a sequence of
*hints*. Tailored formatting of exercises in special output formats
can make use of this. For example, one can image web formats where
the hints are displayed one by one when needed and where the result
file can be uploaded. One can also think of mechanisms for downloading
the solution file if the result file meets certain criteria.
Doconce does not yet generate such functionality in any output format,
but this is an intended future feature to be impelemented.

Because exercises, problems, and projects are typeset as ordinary
sections (this is the most general approach that will work for many
formats), one must refer to an exercise, problem, or project
by its label, which normally will translate to the section number
(in LaTeX, for instance) or a link to the title of the section.
The *title* is typeset without any leading "Exercise:", "Problem:",
or "Project:" word, so that references like "see Problem ..."
works well in all formats ("..." will be a number in LaTeX and
the problem title in most other formats).

It is recommended to collect all exercises as subsetions (or subsubsections)
under a section (or subsection) named "Exercises", "Problems", or
"Projects".


===== Blocks of Verbatim Computer Code =====
label{sec:verbatim:blocks}

Blocks of computer code, to be typeset verbatim, must appear inside a
"begin code" `!bc` keyword and an "end code" `!ec` keyword. Both
keywords must be on a single line and *start at the beginning of the
line*.  Before such a code block there must be a plain sentence
(at least if successful transformation to reST and
ASCII-type formats is desired). For example, a code block cannot come
directly after a section/paragraph heading or a table.

There may be an argument after the `!bc` tag to specify a
certain environment (for `ptex2tex` or Sphinx) for typesetting
the verbatim code. For instance, `!bc dat` corresponds to
the data file environment and `!bc cod` is typically
used for a code snippet. There are some predefined environments
explained below. If there is
no argument specifying the environment, one assumes some plain
verbatim typesetting (for `ptex2tex` this means the `ccq` environment,
which is defined in the config file `.ptex2tex.cfg`,
while for Sphinx it defaults to the `python` environment).

Since the config file for `ptex2tex` can define what some environment
maps onto with respect to typesetting, a similar possibility is
supported for Sphinx as well.  The argument after `!bc` is in case of
Sphinx output mapped onto a valid Pygments language for typesetting of
the verbatim block by Pygments. This mapping takes place in an
optional comment to be inserted in the Doconce source file, e.g.,
!bc
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
!ec
Here, three arguments are defined: `pycod` for Python code,
`cod` also for Python code, `cppcod` for C++ code, and `sys`
for terminal sessions. The same arguments would be defined
in `.ptex2tex.cfg` for how to typeset the blocks in LaTeX using
various verbatim styles (Pygments can also be used in a LaTeX
context).

By default, `pro` is used for complete programs in Python, `cod` is
for a code snippet in Python, while `xcod` and `xpro` implies computer
language specific typesetting where `x` can be `f` for Fortran, `c`
for C, `cpp` for C++, `sh` for Unix shells, `pl` for Perl, `m` for
Matlab, `cy` for Cython, and `py` for Python.  The argument `sys`
means by default `console` for Sphinx and `CodeTerminal` (ptex2tex
environent) for LaTeX. Other specifications are `dat` for a data file
or print out, and `ipy` for interactive Python sessions (the latter
does not introduce any environment  in `sphinx` output, as interactive
sessions are automatically recognized and handled).  All these
definitions of the arguments after `!bc` can be redefined in the
`.ptex2tex.cfg` configuration file for ptex2tex/LaTeX and in the
`sphinx code-blocks` comments for Sphinx. Support for other languages
is easily added.

# (Any sphinx code-block comment, whether inside verbatim code
# blocks or outside, yields a mapping between bc arguments
# and computer languages. In case of muliple definitions, the
# first one is used.)

The enclosing `!ec` tag of verbatim computer code blocks must
be followed by a newline.  A common error in list environments is to
forget to indent the plain text surrounding the code blocks. In
general, we recommend to use paragraph headings instead of list items
in combination with code blocks (it usually looks better, and some
common errors are naturally avoided).

Here is a verbatim code block with Python code (`pycod` style):
!bc pycod
# regular expressions for inline tags:
inline_tag_begin = r'(?P<begin>(^|\s+))'
inline_tag_end = r'(?P<end>[.,?!;:)\s])'
INLINE_TAGS = {
    'emphasize':
    r'%s\*(?P<subst>[^ `][^*`]*)\*%s' % \
    (inline_tag_begin, inline_tag_end),
    'verbatim':
    r'%s`(?P<subst>[^ ][^`]*)`%s' % \
    (inline_tag_begin, inline_tag_end),
    'bold':
    r'%s_(?P<subst>[^ `][^_`]*)_%s' % \
    (inline_tag_begin, inline_tag_end),
}
!ec
And here is a C++ code snippet (`cppcod` style):
!bc cppcod
void myfunc(double* x, const double& myarr) {
    for (int i = 1; i < myarr.size(); i++) {
        myarr[i] = myarr[i] - x[i]*myarr[i-1]
    }
}
!ec

# When showing copy from file in !bc envir, intent a character - otherwise
# ptex2tex is confused and starts copying...
Computer code can be copied directly from a file, if desired. The syntax
is then
!bc
 @@@CODE myfile.f
 @@@CODE myfile.f fromto: subroutine\s+test@^C\s{5}END1
!ec
The first line implies that all lines in the file `myfile.f` are
copied into a verbatim block, typset in a `!bc Xpro` environment, where
`X` is the extension of the filename, here `f` (i.e., the environment
becomes `!bc fpro` and will typically lead to some Fortran-style
formatting in Linux and Sphinx).  The
second line has a `fromto:` directive, which implies copying code
between two lines in the code, typset within a !`bc Xcod`
environment (again, `X` is the filename extension, implying the
type of file). Note that the `pro` and `cod` arguments are only used for LaTeX
and Sphinx output, all other formats will have the code typeset within
a plain `!bc` environment.) Two regular expressions, separated by the
`@` sign, define the "from" and "to" lines.  The "from" line is
included in the verbatim block, while the "to" line is not. In the
example above, we copy code from the line matching `subroutine test`
(with as many blanks as desired between the two words) and the line
matching `C END1` (C followed by 5 blanks and then the text END1). The
final line with the "to" text is not included in the verbatim block.

Let us copy a whole file (the first line above):

@@@CODE __testcode.f

Let us then copy just a piece in the middle as indicated by the `fromto:`
directive above:

@@@CODE __testcode.f fromto:subroutine\s+test@^C\s{5}END1

Note that the "to" line is not copied into the Doconce file, but the
"from" line is. Sometimes it is convenient to also neglect the
"from" line, a feature that is allowed by replacing `fromto:` by
`from-to` ("from with minus"). This allows for copying very similar
code segments throughout a file, while still distinguishing between them.
Copying the second set of parameters from the text
!bc cod
# --- Start Example 1 ---
c = -1
A = 2
p0 = 4
simulate_and_plot(c, A, p0)
# --- End Example 1 ---

# --- Start Example 2 ---
c = -1
A = 1
p0 = 0
simulate_and_plot(c, A, p0)
# --- End Example 2 ---
!ec
is easy with
!bc
from-to: Start Example 2@End Example 2
!ec
With only `fromto:` this would be impossible.

(Remark for those familiar with `ptex2tex`: The from-to
syntax is slightly different from that used in `ptex2tex`. When
transforming Doconce to LaTeX, one first transforms the document to a
`.p.tex` file to be treated by `ptex2tex`. However, the `@@@CODE` line
is interpreted by Doconce and replaced by the mentioned
pro or cod environment which are defined in the `ptex2tex` configuration
file.)


===== LaTeX Blocks of Mathematical Text =====
label{mathtext}

Blocks of mathematical text are like computer code blocks, but
the opening tag is `!bt` (begin TeX) and the closing tag is
`!et`. It is important that `!bt` and `!et` appear on the beginning of the
line and followed by a newline.
!bc
!bt
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
!et
!ec
Here is the result of the above `!bt` - `!et` block:
!bt
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
!et

This text looks ugly in all Doconce supported formats, except from
LaTeX and Sphinx.  If HTML is desired, and Sphinx is not an option,
one can filter the Doconce text first to LaTeX and then use the tex4ht
tool to convert the dvi file to HTML, or one could just link a PDF
file (made from LaTeX) directly from HTML.

If the document targets both LaTeX, Sphinx, and other formats like
plain text and wiki, one can use the preprocessor to typeset the
mathematics in two versions. After `#if FORMAT in ("latex", "pdflatex",
"sphinx", "mwiki")` one places LaTeX mathematics, and after `#else` one can
write inline mathematics in a way that looks nice in plain text and
wiki formats without support for mathematical typesetting.


=== Mathematics for PowerPoint/OpenOffice ===

If you have LaTeX mathematics written in Doconce, it is fairly easy
to generate PNG images of all mathematical formulas and equations for
use with PowerPoint or OpenOffice documents.

  o Make a Sphinx version of the Doconce file.
  o Go to the Sphinx directory and load the `conf.py` file into
    a browser.
  o Search for "math" and comment out the
    `'sphinx.ext.mathjax'` (enabled by default) and
    `'matplotlib.sphinxext.mathmpl'` (disabled by default)
    lines, and uncomment the `'sphinx.ext.pngmath'` package.
    This is the package that generates small PNG pictures
    of the mathematics.
  o Uncomment the line with `pngmath_dvipng_args =` and
    set the PNG resolution to `-D 200` when the purpose is to
    generate mathematics pictures for slides.
  o Run `make html`.
  o Look at the HTML source file in the `_build/html`
    directory: all mathematics are in `img` tags with `src=`
    pointing to a PNG file and `alt=` pointing to the LaTeX
    source for the formula in question. This makes it very
    easy to find the PNG file that corresponding to a particular
    mathematical expression.


===== Macros (Newcommands) =====
label{newcommands}

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
`newcommand_replace.tex` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names `newcommands.tex` and
`newcommands_keep.tex` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
`!bt` and `!et` in `newcommands_keep.tex` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
`newcommands_replace.tex` and expanded by Doconce.  The definitions of
newcommands in the `newcommands*.tex` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

__Example.__ Suppose we have the following commands in
`newcommand_replace.tex`:

@@@CODE newcommands_replace.tex

and these in `newcommands_keep.tex`:

@@@CODE newcommands_keep.tex

The LaTeX block
!bc
\beqa
\x\cdot\normalvec &=& 0, label{my:eq1}\\
\Ddt{\uvec} &=& \Q \ep   label{my:eq2}
\eeqa
!ec
will then be rendered to
!bt
\beqa
\x\cdot\normalvec &=& 0, label{my:eq1}\\
\Ddt{\uvec} &=& \Q \ep   label{my:eq2}
\eeqa
!et
in the current format.

===== Preprocessing Steps =====

Doconce allows preprocessor commands for, e.g., including files,
leaving out text, or inserting special text depending on the format.
Two preprocessors are supported: preprocess
(URL:"http://code.google.com/p/preprocess") and mako
(URL:"http://www.makotemplates.org/"). The former allows include and if-else
statements much like the well-known preprocessor in C and C++ (but it
does not allow sophisticated macro substitutions). The latter
preprocessor is a very powerful template system.  With Mako you can
automatically generate various type of text and steer the generation
through Python code embedded in the Doconce document. An arbitrary set
of `name=value` command-line arguments (at the end of the command line)
automatically define Mako variables that are substituted in the document.

Doconce will detect if preprocess or Mako commands are used and run
the relevant preprocessor prior to translating the Doconce source to a
specific format.

The preprocess and mako programs always have the variable `FORMAT`
defined as the desired output format of Doconce (`html`, `latex`,
`plain`, `rst`, `sphinx`, `epydoc`, `st`).  It is then easy to test on
the value of `FORMAT` and take different actions for different
formats. For example, one may create special LaTeX output for figures,
say with multiple plots within a figure, while other formats may apply
a separate figure for each plot. Below is an example (see the Doconce
source code of this document to understand how preprocess is used to
create the example).

# If PNGFIGS is defined, PNG files are used, otherwise Encapsulated
# PostScript files are used.

# #if FORMAT == "latex"
# Use latex with subfigures (a) and (b)
\begin{figure}
label{fig:wavepackets}
  \begin{center}
#  #ifdef PNGFIGS
\subfigure[]{\includegraphics[width=0.49\linewidth]{figs/wavepacket_0001.png}}
#  #else
\subfigure[]{\includegraphics[width=0.49\linewidth]{figs/wavepacket_0001.eps}}
#  #endif

#  #ifdef PNGFIGS
\subfigure[]{\includegraphics[width=0.49\linewidth]{figs/wavepacket_0010.png}}
#  #else
\subfigure[]{\includegraphics[width=0.49\linewidth]{figs/wavepacket_0010.eps}}
#  #endif
  \end{center}
  \caption{
  Wavepackets at time (a) 0.1 s and (b) 0.2 s.
  }
\end{figure}

# #else

# Use default Doconce figure handling for all other formats

FIGURE:[figs/wavepacket_0001.png, width=400] Wavepacket at time 0.1 s.

FIGURE:[figs/wavepacket_0010.png, width=400] Wavepacket at time 0.2 s.

# #endif

Other user-defined variables for the preprocessor can be set at
the command line as explained in Section ref{doconce2formats}.

More advanced use of mako can include Python code that may automate
the writing of parts of the document.



===== Splitting Documents into Smaller Pieces =====

Long documents are conveniently split into smaller Doconce files.
However, there must be a master document including all the pieces,
otherwise references to sections and the index will not work properly.
The master document is preferably a file just containing a set of
preprocessor include statements of the form `#include "file.do.txt"`.
The preprocessor will put together all the pieces so that Doconce
sees a long file with the complete text.

For reST and Sphinx documents it is a point to have
separate `.rst` files and an index file listing the various `.rst`
that build up the document. To generate the various `.rst` files one
should not run Doconce on the individual `.do.txt` files, because then
references and index entries are not treated correctly. Instead,
run Doconce on the master file and invoke the script `doconce split_rst`
to split the long, complete `.rst` into pieces. This process requires
that each `#include "file.do.txt` line in the master file is preceded by a
"marker line" having the syntax `#>>>>>> part: file >>>>>>`, where
`file` is the filename without extension. The number of greater than
signs is not important, but it has to be a comment line and it has
to contain the keyword `part:`.

Here is an example. Say the name of the master file is `master.do.txt`.
The following Bash script does the job:
We run
!bc cod
doconce format sphinx master
# Split master.rst into parts
# as defined by #>>>>> part: name >>>>> lines
files=`doconce split_rst master.rst`

dir=sphinxm-rootdir

if [ ! -d $dir ]; then
  doconce sphinx_dir dirname=$dir author='me and you' \
          version=1.0 theme=default $files
  sh automake-sphinx.sh
else
  for file in $files; do
    cp $file.rst $dir
  done
  cd $dir
  make html
  cd ..
fi
!ec
The autogenerated `automake-sphinx.sh` file (by `doconce sphinx_dir`)
is compatible with a master `.rst` file split into pieces as long as
the complete set of pieces in correct order is given to `doconce sphinx_dir`.
This set is the output of `doconce split_rst`, which we catch in a
variable `files` above.


===== Missing Features =====

Doconce does not aim to support sophisticated typesetting, simply because
sophisticated typesetting usually depend quite strongly on the particular
output format chosen. When a particular feature needed is not supported
by Doconce, it is recommended to hardcode that feature for a particular
format and use the if-else construction of the preprocessor. For example,
if a sophisticated table is desired in LaTeX output, test on the
`FORMAT` variable (`#if FORMAT == "latex"`) in the Doconce code and
insert the table in LaTeX format. The `else` or `elif` branches may
have the table in other formats or a simplified version in the Doconce
table format. Similarly, if certain adjustments are needed, like
pagebreaks in LaTeX, hardcode that in the Doconce format (and recall
that this is really LaTeX dependent - pagebreaks are not
relevant HTML formats).

Instead of inserting special code in the Doconce document, one can
alternatively script editing of the output from Doconce. That is,
we develop a Python or Bash script that runs the translation of
a Doconce document to a ready docoment in another format. Inside this
script, we may edit and fine-tune the output from Doconce.

As an example, say you want a table of contents in the LaTeX output
(Doconce does not support table of contents). By inserting a
recognizable comment in the Doconce source, say
!bc
# table of contents
!ec
we can use this comment to edit the LaTeX file. First, we run
Doconce `doconce format latex mydoc` to produce `mydoc.p.tex`. Then
we use the `doconce replace` and `doconce subst` commands to
replace the comment by the comment plus the table of contents command,
or just the latter:
!bc
Terminal> doconce replace '% table of contents'
          '\tableofcontents' mydoc.p.tex
!ec
The `doconce replace from_text to_text filename` command performs a
character-by-character replacement (using the `replace` method in
string objects in Python). If we want to preserve the comment and add
a new line with `\tableofcontents`, we should use `doconce subst`,
which applies regular expressions for substitutions and thereby
understands the newline character:
!bc
Terminal> doconce subst '% table of contents' \
          '% table of contents\n\\tableofcontents' mydoc.p.tex
!ec
Note the double backshlash in front of the `t` character: without it we
would get a tab and no backslash.
The `doconce subst` is a powerful way to automatically edit the output
from Doconce and fine-tune a LaTeX document. Use of comment lines to
identify portions of the file to be edited is a smart idea.
Alternatively, the relevant LaTeX constructions can be inserted directly
in the Doconce file using if-else preprocessor directives.

===== Header and Footer =====

Some formats use a header and footer in the document. LaTeX and
HTML are two examples of such formats. When the document is to be
included in another document (which is often the case with
Doconce-based documents), the header and footer are not wanted, while
these are needed (at least in a LaTeX context) if the document is
stand-alone. We have introduce the convention that if `TITLE:` or
`#TITLE:` is found at the beginning of the line (i.e., the document
has, or has an intention have, a title), the header and footer
are included, otherwise not.


===== Emacs Doconce Formatter =====

The file `misc/.doconce-mode.el` in the Doconce source distribution
gives a "Doconce Editing Mode" in Emacs. The file is a rough edit of
the reST Editing Mode for Emacs. Some Doconce features are recognized,
but far from all, and sometimes portions of Doconce text just appear
as ordinary text.

Here is how to get the Doconce Editing Mode in Emacs.

__Step 1.__ Download the Doconce tarball from `code.google.com/p/doconce`,
pack it out and go to the root directory.

__Step 2.__ Copy the `doconce-mode.el` file to the home directory:
!bc
cp misc/.doconce-mode.el $HOME
!ec

__Step 3.__ Add these lines to `$HOME/.emacs`:
!bc
(load-file "~/hg/.doconce-mode.el")
(setq auto-mode-alist(cons '("\\.do\\.txt$" . doconce-mode) auto-mode-alist))
!ec
Emacs will now recognize files with extension `.do.txt` and enter
the Doconce Editing Mode.


======= Troubleshooting =======

===== Disclaimer =====

Doconce has some support for syntax checking.  If you encounter Python
errors while running `doconce format`, the reason for the error is
most likely a syntax problem in your Doconce source file. You have to
track down this syntax problem yourself.

However, the problem may well be a bug in Doconce. The Doconce
software is incomplete, and many special cases of syntax are not yet
discovered to give problems. Such special cases are also seldom easy to
fix, so one important way of "debugging" Doconce is simply to change
the formatting so that Doconce treats it properly. Doconce is very much
based on regular expressions, which are known to be non-trivial to
debug years after they are created. The main developer of Doconce has
hardly any time to work on debugging the code, but the software works
well for his diverse applications of it.


===== General Problems ======

=== Something goes wrong in the preprocessing step ===

Doconce automatically removes the file `__tmp.do.txt`, which is the
resulting of the preprocessing stge and the file to examine if
something goes wrong in this stage (i.e., when `mako` and/or
`preprocess` is run). Add the `--debug` flag at the end of the
`doconce` command to (both make a debug file and) avoid that
`__tmp.do.txt` is deleted.

=== Figure captions are incomplete ===

If only the first part of a figure caption in the Doconce file is seen
in the target output format, the reason is usually that the caption
occupies multiple lines in the Doconce file. The figure caption must
be written as *one line*, at the same line as the FIGURE keyword.

=== Preprocessor directives do not work ===

Make sure the preprocessor instructions, in Preprocess or Mako, have
correct syntax. Also make sure that you do not mix Preprocess and Mako
instructions. Doconce will then only run Preprocess.

=== Problems with boldface and emphasize ===

Two boldface or emphasize expressions after each other are not rendered
correctly. Merge them into one common expression.

=== Links to local directories do not work ===

Links of the type
!bc
see the "examples directory": "src/examples"
!ec
do not work well. You need to link to a specific HTML file:
!bc
see the "examples directory": "src/examples/index.html"
!ec

=== Links are not typeset correctly ===

Not all formats will allow formatting of the links. Verbatim words
in links are allowed if the whole link is typeset in verbatim:
!bc
see the directory "`examples`": "src/examples/index.html".
!ec
However, the following will not be typeset correctly:
!bc
see the "`examples` directory": "src/examples/index.html"
!ec
The back-ticks must be removed, or the text can be reformulated as
in the line above it.


=== Inline verbatim code is not detected ===

Make sure there is a space before the first back-tick.

=== Strange non-English characters ===

Check the encoding of the `.do.txt` file with the Unix `file` command
or with
!bc
Unix> doconce guess_encoding myfile.do.txt
!ec
If the encoding is utf-8, convert to latin-1 using either of
the Unix commands
!bc
Unix> doconce change_encoding utf-8 LATIN1 myfile.do.txt

Unix> iconv -f utf-8 -t LATIN1 myfile.do.txt --output newfile
!ec

=== Wrong Norwegian charcters ===

When Doconce documents have characters not in the standard ASCII set,
the format of the file must be LATIN1 and not UTF-8. See
the section "Strange non-English characters" above for how to
run `doconce change_encoding` to change the encoding of the Doconce file.

=== Inline verbatim text is not formatted correctly ===

Make sure there is whitespace surrounding the text in back-ticks.

=== Too short underlining of reST headlines ===

This may happen if there is a paragraph heading without
proceeding text before some section heading.


=== Found !bt but no tex blocks extracted (BUG) ===

This message points to a bug, but has been resolved by removing blank lines
between the text and the first `!bt` (inserting the blanks again did not
trigger the error message again...).

===== Problems with code or Tex Blocks =====

=== Code or math block errors in reST ===

First note that a code or math block must come after some plain
sentence (at least for successful output in reST), not directly
after a section/paragraph heading, table, comment, figure, or
movie, because the code or math block is indented and then become
parts of such constructions. Either the block becomes invisible or
error messages are issued.

Sometimes reST reports an "Unexpected indentation" at the beginning of
a code block. If you see a `!bc`, which should have been removed when
running `doconce format sphinx`, it is usually an error in the Doconce
source, or a problem with the rst/sphinx translator.  Check if the
line before the code block ends in one colon (not two!), a question
mark, an exclamation mark, a comma, a period, or just a newline/space
after text. If not, make sure that the ending is among the
mentioned. Then `!bc` will most likely be replaced and a double colon
at the preceding line will appear (which is the right way in reST to
indicate a verbatim block of text).

=== Strange errors around code or TeX blocks in reST ===

If `idx` commands for defining indices are placed inside paragraphs,
and especially right before a code block, the reST translator
(rst and sphinx formats) may get confused and produce strange
code blocks that cause errors when the reST text is transformed to
other formats. The remedy is to define items for the index outside
paragraphs.

=== Something is wrong with a verbatim code block ===

Check first that there is a "normal" sentence right before
the block (this is important for reST and similar
"ASCII-close" formats).

=== Code/TeX block is not shown in reST format ===

A comment right before a code or tex block will treat the whole
block also as a comment. It is important that there is normal
running text right before `!bt` and `!bc` environments.

=== Verbatim code blocks inside lists look ugly ===

Read the Section ref{sec:verbatim:blocks} above.  Start the
`!bc` and `!ec` tags in column 1 of the file, and be careful with
indenting the surrounding plain text of the list item correctly. If
you cannot resolve the problem this way, get rid of the list and use
paragraph headings instead. In fact, that is what is recommended:
avoid verbatim code blocks inside lists (it makes life easier).

=== LaTeX code blocks inside lists look ugly ===

Same solution as for computer code blocks as described in the
previous paragraph. Make sure the `!bt` and `!et` tags are in column 1
and that the rest of the non-LaTeX surrounding text is correctly indented.
Using paragraphs instead of list items is a good idea also here.


===== Problems with reST/Sphinx Output ======

=== Lists do not appear in .rst files ===

Check if you have a comment right above the list. That comment
will include the list if the list is indentend. Remove the comment.

=== Error message "Undefined substitution..." from reST ===

This may happen if there is much inline math in the text. reST cannot
understand inline LaTeX commands and interprets them as illegal code.
Just ignore these error messages.

=== Warning about duplicate link names ===

Link names should be unique, but if (e.g.) "file" is used as link text
several places in a reST file, the links still work. The warning can
therefore be ignorned.

=== Inconsistent headings in reST ===

The `rst2*.py` and Sphinx converters abort if the headers of sections
are not consistent, i.e., a subsection must come under a section,
and a subsubsection must come under a subsection (you cannot have
a subsubsection directly under a section). Search for `===`,
count the number of equality signs (or underscores if you use that)
and make sure they decrease by two every time a lower level is encountered.

=== No code environment appears before "bc ipy" blocks ===

The `!bc ipy` directive behaves this way for `sphinx` output because
interactive sessions are automatically handled. If this is not
appropriate, shift to `!bc cod` or another specification of the
verbatim environment.

===== Problems with LaTeX Output ======

=== Error when running latex: You must 'pygmentize' installed ===

This points to the used of the Minted style for typesetting verbatim
code. You need to run
!bc sys
Terminal> latex -shell-escape file
!ec
if you have run `ptex2tex` with the `-DMINTED` option and turned on
the use of the Minted style (and therefore `pygmentize` program).

=== The LaTeX file does not compile ===

If the problem is undefined control sequence involving
!bc
\code{...}
!ec
the cause is usually a verbatim inline text (in back-ticks in the
Doconce file) spans more than one line. Make sure, in the Doconce source,
that all inline verbatim text appears on the same line.

=== Inline verbatim gives error  ===

Check if the inline verbatim contains typical LaTeX commands, e.g.,
!bc
some text with `\usepackage{mypack}` is difficult because
ptex2tex will replace this by \code{\usepackage{mypack}} and
then replace this by
{\fontsize{10pt}{10pt}\verb!\usepackage{mypack!}}
which is wrong because ptex2tex applies regex that don't
capture the second }
!ec
The remedy is to place verbatim LaTeX commands in verbatim
blocks - that is safe.

# Could have doconce configure file where inline verbatim is
# configured to be \fontsize... directly, not via ptex2tex \code{}.


=== Errors in figure captions ===

Such errors typically arise from unbalanced curly braces, or dollar signs
around math, and similar LaTeX syntax errors.

(Note that verbatim font is likely to cause trouble inside figure captions,
but Doconce will automatically replace verbatim text in back-ticks by
a proper `texttt` command (since verbatim font constructions does not work
inside figure captions) and precede underscores by backslash.)

=== Chapters are ignored ===

The default LaTeX style is "article". If you chapters in the Doconce file,
you need to run `ptex2tex` with the option `-DBOOK` to set the LaTeX
documentstyle to "book".

=== I want to tune the top of the LaTeX file ===

The top of the LaTeX file, as generated by Doconce, is very simple.
If this LaTeX code is not sufficient for your needs, there are
two ways out of it:

 o Make a little Bash script that performs a series of
   `doconce subst` (regular expressions) or `doconce replace` (regular text)
   substitutions to change the text automatically (you probably have to
   repeat these edits so automating them is a good idea).
 o Place the title, author(s), and date of the Doconce file in a separate
   file and use the preprocessor to include the rest. The rest is then
   one or more Doconce files without title, author(s), and date. This
   means that the `doconce format latex` command does not generate
   the LaTeX intro (preamble) and outro, just the core text, for these
   files.
   Make a new file by hand with the appropriate LaTeX intro and outro
   text and include the various text pieces in this file.
   To make the LaTeX document, you compile all Doconce files
   into LaTeX code, except the "top" Doconce file that includes the
   others. That file is not used for LaTeX output, but
   replaced by the hand-written LaTeX "top" file.

===== Problems with gwiki Output ======

=== Strange nested lists in gwiki ===

Doconce cannot handle nested lists correctly in the gwiki format.
Use nonnested lists or edit the `.gwiki` file directly.

=== Lists in gwiki look ugly in the gwiki source ===

Because the Google Code wiki format requires all text of a list item to
be on one line, Doconce simply concatenates lines in that format,
and because of the indentation in the original Doconce text, the gwiki
output looks somewhat ugly. The good thing is that this gwiki source
is seldom to be looked at - it is the Doconce source that one edits
further.

===== Debugging =====

Given a problem, extract a small portion of text surrounding the
problematic area and debug that small piece of text. Doconce does a
series of transformations of the text. The effect of each of these
transformation steps are dumped to a logfile, named
`_doconce_debugging.log`, if the to `doconce format` after the filename
is `debug`. The logfile is inteded for the developers of Doconce, but
may still give some idea of what is wrong.  The section "Basic Parsing
Ideas" explains how the Doconce text is transformed into a specific
format, and you need to know these steps to make use of the logfile.



======= Basic Parsing Ideas =======

# avoid list here since we have code in between (never a good idea)

The (parts of) files with computer code to be directly included in
the document are first copied into verbatim blocks.

All verbatim and TeX blocks are removed and stored elsewhere
to ensure that no formatting rules are not applied to these blocks.

The text is examined line by line for typesetting of lists, as well as
handling of blank lines and comment lines.
List parsing needs some awareness of the context.
Each line is interpreted by a regular expression

!bc
(?P<indent> *(?P<listtype>[*o-] )? *)(?P<keyword>[^:]+?:)?(?P<text>.*)\s?
!ec

That is, a possible indent (which we measure), an optional list
item identifier, optional space, optional words ended by colon,
and optional text. All lines are of this form. However, some
ordinary (non-list) lines may contain a colon, and then the keyword
and text group must be added to get the line contents. Otherwise,
the text group will be the line.

When lists are typeset, the text is examined for sections, paragraphs,
title, author, date, plus all the inline tags for emphasized, boldface,
and verbatim text. Plain subsitutions based on regular expressions
are used for this purpose.

The final step is to insert the code and TeX blocks again (these should
be untouched and are therefore left out of the previous parsing).

It is important to keep the Doconce format and parsing simple.  When a
new format is needed and this format is not obtained by a simple edit
of the definition of existing formats, it might be better to convert
the document to reST and then to XML, parse the XML and
write out in the new format.  When the Doconce format is not
sufficient to getting the layout you want, it is suggested to filter
the document to another, more complex format, say reST or
LaTeX, and work further on the document in this format.


===== A Glimpse of How to Write a New Translator =====

This is the HTML-specific part of the
source code of the HTML translator:
# #if FORMAT == "html"
(note that in HTML one of the the less-than and greater-than signs
in a link come up wrong because of the simple regex that is used
to substitute these pair of signs by special HTML expressions)
# #endif

# #if FORMAT != "epytext"

!bc
FILENAME_EXTENSION['html'] = '.html'  # output file extension
BLANKLINE['html'] = '<p>\n'           # blank input line => new paragraph
INLINE_TAGS_SUBST['html'] = {         # from inline tags to HTML tags
    # keep math as is:
    'math': None,  # indicates no substitution
    'emphasize':     r'\g<begin><em>\g<subst></em>\g<end>',
    'bold':          r'\g<begin><b>\g<subst></b>\g<end>',
    'verbatim':      r'\g<begin><tt>\g<subst></tt>\g<end>',
    'URL':           r'\g<begin><a href="\g<url>">\g<link></a>',
    'section':       r'<h1>\g<subst></h1>',
    'subsection':    r'<h3>\g<subst></h3>',
    'subsubsection': r'<h5>\g<subst></h5>',
    'paragraph':     r'<b>\g<subst></b>. ',
    'title':         r'<title>\g<subst></title>\n<center><h1>\g<subst></h1></center>',
    'date':          r'<center><h3>\g<subst></h3></center>',
    'author':        r'<center><h3>\g<subst></h3></center>',
    }

# how to replace code and latex blocks by html (<pre>) environment:
def html_code(filestr):
    c = re.compile(r'^!bc(.*?)\n', re.MULTILINE)
    filestr = c.sub(r'<!-- BEGIN VERBATIM BLOCK \g<1>-->\n<pre>\n', filestr)
    filestr = re.sub(r'!ec\n',
                     r'</pre>\n<! -- END VERBATIM BLOCK -->\n', filestr)
    c = re.compile(r'^!bt\n', re.MULTILINE)
    filestr = c.sub(r'<pre>\n', filestr)
    filestr = re.sub(r'!et\n', r'</pre>\n', filestr)
    return filestr
CODE['html'] = html_code

# how to typeset lists and their items in html:
LIST['html'] = {
    'itemize':
    {'begin': '\n<ul>\n', 'item': '<li>', 'end': '</ul>\n\n'},
    'enumerate':
    {'begin': '\n<ol>\n', 'item': '<li>', 'end': '</ol>\n\n'},
    'description':
    {'begin': '\n<dl>\n', 'item': '<dt>%s<dd>', 'end': '</dl>\n\n'},
    }

# how to type set description lists for function arguments, return
# values, and module/class variables:
ARGLIST['html'] = {
    'parameter': '<b>argument</b>',
    'keyword': '<b>keyword argument</b>',
    'return': '<b>return value(s)</b>',
    'instance variable': '<b>instance variable</b>',
    'class variable': '<b>class variable</b>',
    'module variable': '<b>module variable</b>',
    }

# document start:
INTRO['html'] = """
<html>
<body bgcolor="white">
"""
# document ending:
OUTRO['html'] = """
</body>
</html>
"""
!ec

# #else
Note that for Epytext, code or LaTeX blocks that contain a newline
character (for example as in `\nabla` in LaTeX), will lead to an
effect of the newline and generate error messages. Our remedy is
to remove such code blocks and provide a notice about the removal.
Eight here we only displacy a smaller snippet that Epytext can
treat properly:

!bc
INLINE_TAGS_SUBST['html'] = {         # from inline tags to html tags
    # keep math as is:
    'math': None,  # indicates no substitution
    'emphasize':     r'\g<begin><em>\g<subst></em>\g<end>',
    'bold':          r'\g<begin><b>\g<subst></b>\g<end>',
    'verbatim':      r'\g<begin><tt>\g<subst></tt>\g<end>',
    'URL':           r'\g<begin><a href="\g<url>">\g<link></a>',
    }
!ec

# #endif

===== Typesetting of Function Arguments, Return Values, and Variables =====

As part of comments (or doc strings) in computer code one often wishes
to explain what a function takes of arguments and what the return
values are. Similarly, it is desired to document class, instance, and
module variables.  Such arguments/variables can be typeset as
description lists of the form listed below and *placed at the end of
the doc string*. Note that `argument`, `keyword argument`, `return`,
`instance variable`, `class variable`, and `module variable` are the
only legal keywords (descriptions) for the description list in this
context.  If the output format is Epytext (Epydoc) or Sphinx, such lists of
arguments and variables are nicely formatted.

!bc
    - argument x: x value (float),
      which must be a positive number.
    - keyword argument tolerance: tolerance (float) for stopping
      the iterations.
    - return: the root of the equation (float), if found, otherwise None.
    - instance variable eta: surface elevation (array).
    - class variable items: the total number of MyClass objects (int).
    - module variable debug: True: debug mode is on; False: no debugging
      (bool variable).
!ec

The result depends on the output format: all formats except Epytext
and Sphinx just typeset the list as a list with keywords.

    - module variable x: x value (float),
      which must be a positive number.
    - module variable tolerance: tolerance (float) for stopping
      the iterations.

BIBFILE: manual_bib.bib, manual_bib.rst, manual_bib.py



************** File: manual.html *****************
<?xml version="1.0" encoding="utf-8" ?>
<!--
Automatically generated HTML file from Doconce source
(http://code.google.com/p/doconce/)
-->

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="generator" content="Doconce: http://code.google.com/p/doconce/" />

<script type="text/javascript"
 src="http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>

</head>

<body bgcolor="white">
    <title>Doconce Description</title>
<center><h1>Doconce Description</h1></center>
<center>
<b>Hans Petter Langtangen</b> [1, 2]
</center>

<p>
<center>[1] <b>Simula Research Laboratory</b></center>
<center>[2] <b>University of Oslo</b></center>


<center><h3>Jan 32, 2100</h3></center>
<P>

<P>
<!-- lines beginning with # are comment lines -->

<P>

<P>
<h2>What Is Doconce? <a name="what:is:doconce"></A></h2>
<P>

<P>
Doconce is two things:

<P>

<ol>
 <li> Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via <tt>rst2*</tt> programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via <tt>unoconv</tt>) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.
 <li> Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".
</ol>

Here are some Doconce features:

<P>

<ul>
  <li> Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.
  <li> Doconce can be converted to plain <em>untagged</em> text,
    often desirable for computer programs and email.
  <li> Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.
  <li> Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).
  <li> Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.
  <li> Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.
</ul>

Doconce was particularly written for the following sample applications:

<P>

<ul>
  <li> Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.
  <li> Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.
  <li> Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.
</ul>

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

<P>
Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.

<P>

<P>

<P>
<h3>Dependencies and Installation</h3>
<P>
Doconce itself is pure Python code hosted at <a href="http://code.google.com/p/doconce"><tt>http://code.google.com/p/doconce</tt></a>.  Its installation from the
Mercurial (<tt>hg</tt>) source follows the standard procedure:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
If you make use of the <a href="http://code.google.com/p/preprocess">Preprocess</a>
preprocessor, this program must be installed:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->
A much more advanced alternative to Preprocess is
<a href="http://www.makotemplates.org">Mako</a>. Its installation is most
conveniently done by <tt>pip</tt>,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
pip install Mako
</pre>
</blockquote>   <! -- end verbatim block -->
This command requires <tt>pip</tt> to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install python-pip
</pre>
</blockquote>   <! -- end verbatim block -->
Alternatively, one can install from the <tt>pip</tt> <a href="http://pypi.python.org/pypi/pip">source code</a>.

<P>
To make LaTeX
documents (without going through the reStructuredText format) you
need <a href="http://code.google.com/p/ptex2tex">ptex2tex</a>, which is
installed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
</pre>
</blockquote>   <! -- end verbatim block -->
As seen, <tt>cp2texmf.sh</tt> copies some special stylefiles that
that <tt>ptex2tex</tt> potentially makes use of. Some more standard stylefiles
are also needed. These are installed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install texlive-latex-extra
</pre>
</blockquote>   <! -- end verbatim block -->
on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the <tt>~/texmf/tex/latex/misc</tt> directory).

<P>
The <em>minted</em> LaTeX style is offered by <tt>ptex2tex</tt> and popular among
users. This style requires the package <a href="http://pygments.org">Pygments</a>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
</pre>
</blockquote>   <! -- end verbatim block -->
If you use the minted style, you have to enable it by running
<tt>ptex2tex -DMINTED</tt> and then <tt>latex -shell-escape</tt>, see
the the section <a href="#doconce2formats">From Doconce to Other Formats</a>.

<P>
For <tt>rst</tt> output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs <a href="http://docutils.sourceforge.net">docutils</a>.
The installation can be done by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->
To use the OpenOffice suite you will typically on Debian systems install
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install unovonv libreoffice libreoffice-dmaths
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
<a href="http://code.google.com/p/rst2pdf">rst2pdf</a>. Either download the tarball
or clone the svn repository, go to the <tt>rst2pdf</tt> directory and
run <tt>sudo python setup.py install</tt>.

<P>

<P>
Output to <tt>sphinx</tt> requires of course <a href="http://sphinx.pocoo.org">Sphinx</a>,
installed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
When the output format is <tt>epydoc</tt> one needs that program too, installed
by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Finally, translation to <tt>pandoc</tt> requires the
<a href="http://johnmacfarlane.net/pandoc/">Pandoc</a> program
(written in Haskell) to be installed.
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
sudo apt-get install pandoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Remark.</b> Several of the packages above installed from source code
are also available in Debian-based system through the
<tt>apt-get install</tt> command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For <tt>svn</tt> directories, go to the directory,
run <tt>svn update</tt>, and then <tt>sudo python setup.py install</tt>. For
Mercurial (<tt>hg</tt>) directories, go to the directory, run
<tt>hg pull; hg update</tt>, and then <tt>sudo python setup.py install</tt>.
Doconce itself is frequently updated so these commands should be
run regularly.

<P>

<P>
<!--  -->
<!-- Here are some comment lines that do not affect any formatting -->
<!-- these lines are converted to comments in the output format. -->
<!-- This may have some side effects, especially in rst and sphinx -->
<!-- where lines following the comment may be taken as part of -->
<!-- the comment if there are no blank lines after the comment. -->
<!--  -->
<!-- One can use ## and the mako preprocessor to remove comments -->
<!-- <em>before</em> doconce sees the text. That can be useful when -->
<!-- doconce comments interferes with formatting. -->
<!-- The mako tool also supports <%doc> .. </%doc> -->
<!--  -->

<P>

<P>
<h3>Demos</h3>
<P>

<P>
The current text is generated from a Doconce format stored in the
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
docs/manual/manual.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
file in the Doconce source code tree. We have made a
<a href="https://doconce.googlecode.com/hg/doc/demos/manual/index.html">demo web page</a>
where you can compare the Doconce source with the output in many
different formats: HTML, LaTeX, plain text, etc.

<P>
The file <tt>make.sh</tt> in the same directory as the <tt>manual.do.txt</tt> file
(the current text) shows how to run <tt>doconce format</tt> on the
Doconce file to obtain documents in various formats.

<P>
Another demo is found in
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
docs/tutorial/tutorial.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
In the <tt>tutorial</tt> directory there is also a <tt>make.sh</tt> file producing a
lot of formats, with a corresponding
<a href="https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html">web demo</a>
of the results.

<P>
<!-- Example on including another Doconce file: -->

<P>

<P>
<h2>From Doconce to Other Formats <a name="doconce2formats"></A></h2>
<P>

<P>
Transformation of a Doconce document <tt>mydoc.do.txt</tt> to various other
formats applies the script <tt>doconce format</tt>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format format mydoc.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
or just
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format format mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The <tt>mako</tt> or <tt>preprocess</tt> programs are always used to preprocess the
file first, and options to <tt>mako</tt> or <tt>preprocess</tt> can be added after the
filename. For example,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal&gt; doconce format latex yourdoc extra_sections=True VAR1=5  # mako
</pre>
</blockquote>   <! -- end verbatim block -->
The variable <tt>FORMAT</tt> is always defined as the current format when
running <tt>preprocess</tt>. That is, in the last example, <tt>FORMAT</tt> is
defined as <tt>latex</tt>. Inside the Doconce document one can then perform
format specific actions through tests like <tt>#if FORMAT == "latex"</tt>.

<P>
Inline comments in the text are removed from the output by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc --skip_inline_comments
</pre>
</blockquote>   <! -- end verbatim block -->
One can also remove all such comments from the original Doconce
file by running:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Terminal&gt; doconce remove_inline_comments mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

<P>

<P>
<h3>HTML</h3>
<P>
Making an HTML version of a Doconce file <tt>mydoc.do.txt</tt>
is performed by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format html mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The resulting file <tt>mydoc.html</tt> can be loaded into any web browser for viewing.

<P>
<h3>Pandoc</h3>
<P>
Output in Pandoc's extended Markdown format results from
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format pandoc mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The name of the output file is <tt>mydoc.mkd</tt>.
From this format one can go to numerous other formats:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
</pre>
</blockquote>   <! -- end verbatim block -->
Pandoc supports <tt>latex</tt>, <tt>html</tt>, <tt>odt</tt> (OpenOffice), <tt>docx</tt> (Microsoft
Word), <tt>rtf</tt>, <tt>texinfo</tt>, to mention some. The <tt>-R</tt> option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the <a href="http://johnmacfarlane.net/pandoc/README.html">Pandoc documentation</a>
for the many features of the <tt>pandoc</tt> program.

<P>
Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
<tt>doconce format pandoc</tt> and then translating using <tt>pandoc</tt>, or
<tt>doconce format latex</tt>, and then going from LaTeX to the desired format
using <tt>pandoc</tt>.
Here is an example on the latter strategy:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc
Terminal&gt; doconce ptex2tex mydoc
Terminal&gt; pandoc -f latex -t docx -o mydoc.docx mydoc.tex
</pre>
</blockquote>   <! -- end verbatim block -->
When we go through <tt>pandoc</tt>, only single equations or <tt>align*</tt>
environments are well understood.

<P>
Quite some <tt>doconce replace</tt> and <tt>doconce subst</tt> edits might be needed
on the <tt>.mkd</tt> or <tt>.tex</tt> files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

<P>
Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format pandoc mydoc
Terminal&gt; pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
</pre>
</blockquote>   <! -- end verbatim block -->
The <tt>-s</tt> option adds a proper header and footer to the <tt>mydoc.html</tt> file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

<P>

<P>
<h3>LaTeX</h3>
<P>
Making a LaTeX file <tt>mydoc.tex</tt> from <tt>mydoc.do.txt</tt> is done in two steps:
<!-- Note: putting code blocks inside a list is not successful in many -->
<!-- formats - the text may be messed up. A better choice is a paragraph -->
<!-- environment, as used here. -->

<P>
<b>Step 1.</b> Filter the doconce text to a pre-LaTeX form <tt>mydoc.p.tex</tt> for
     <tt>ptex2tex</tt>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files <tt>newcommands.tex</tt>, <tt>newcommands_keep.tex</tt>, or
<tt>newcommands_replace.tex</tt> (see the section <a href="#newcommands">Macros (Newcommands)</a>).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

<P>
<b>Step 2.</b> Run <tt>ptex2tex</tt> (if you have it) to make a standard LaTeX file,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
In case you do not have <tt>ptex2tex</tt>, you may run a (very) simplified version:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce ptex2tex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Note that Doconce generates a <tt>.p.tex</tt> file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DHELVETICA mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DLATEX_HEADING=traditional mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
A separate titlepage can be generate by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DLATEX_HEADING=titlepage mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The <tt>ptex2tex</tt> tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any <tt>!bc</tt> command in the Doconce source you can
insert verbatim block styles as defined in your <tt>.ptex2tex.cfg</tt>
file, e.g., <tt>!bc cod</tt> for a code snippet, where <tt>cod</tt> is set to
a certain environment in <tt>.ptex2tex.cfg</tt> (e.g., <tt>CodeIntended</tt>).
There are about 40 styles to choose from.

<P>
Also the <tt>doconce ptex2tex</tt> command supports preprocessor directives
for processing the <tt>.p.tex</tt> file. The command allows specifications
of code environments as well. Here is an example:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
</pre>
</blockquote>   <! -- end verbatim block -->
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
<tt>verbatim</tt> above, which implies <tt>\begin{verbatim}</tt> and <tt>\end{verbatim}</tt>).
The value <tt>minted</tt> can be used for code environments where the
language is specified, as in <tt>fpro</tt>, where <tt>minted</tt> implies
<tt>\begin{python}{fortran}</tt>. There is a similar support for <tt>ans</tt>:
<tt>cppcod=ans</tt> imples <tt>\begin{c++}</tt> and <tt>\end{c++}</tt> using the
<tt>anslistings</tt> package.

<P>
<b>Step 2b (optional).</b> Edit the <tt>mydoc.tex</tt> file to your needs.
For example, you may want to substitute <tt>section</tt> by <tt>section*</tt> to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the <tt>doconce replace</tt> and <tt>doconce subst</tt>
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce replace 'section{' 'section*{' mydoc.tex
Terminal&gt; doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g&lt;1&gt; \\\\ [1.5mm] Using \g&lt;2&gt;' mydoc.tex
</pre>
</blockquote>   <! -- end verbatim block -->
A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

<P>
<b>Step 3.</b> Compile <tt>mydoc.tex</tt>
and create the PDF file:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; latex mydoc
Terminal&gt; latex mydoc
Terminal&gt; makeindex mydoc   # if index
Terminal&gt; bibitem mydoc     # if bibliography
Terminal&gt; latex mydoc
Terminal&gt; dvipdf mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
If one wishes to use the <tt>Minted_Python</tt>, <tt>Minted_Cpp</tt>, etc.,
environments in <tt>ptex2tex</tt> for typesetting code (specified, e.g., in
the <tt>*pro</tt> and <tt>*cod</tt> environments in <tt>.ptex2tex.cfg</tt> or
<tt>$HOME/.ptex2tex.cfg</tt>), the <tt>minted</tt> LaTeX package is needed.  This
package is included by running <tt>doconce format</tt> with the <tt>-DMINTED</tt>
option:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DMINTED mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
In this case, <tt>latex</tt> must be run with the
<tt>-shell-escape</tt> option:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; latex -shell-escape mydoc
Terminal&gt; latex -shell-escape mydoc
Terminal&gt; makeindex mydoc   # if index
Terminal&gt; bibitem mydoc     # if bibliography
Terminal&gt; latex -shell-escape mydoc
Terminal&gt; dvipdf mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>

<P>
<h3>PDFLaTeX</h3>
<P>
Running <tt>pdflatex</tt> instead of <tt>latex</tt> follows almost the same steps,
but the start is
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format latex mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
Then <tt>ptex2tex</tt> is run as explained above, and finally
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; pdflatex -shell-escape mydoc
Terminal&gt; makeindex mydoc   # if index
Terminal&gt; bibitem mydoc     # if bibliography
Terminal&gt; pdflatex -shell-escape mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h3>Plain ASCII Text</h3>
<P>
We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format plain mydoc.do.txt  # results in mydoc.txt
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h3>reStructuredText</h3>
<P>
Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file <tt>mydoc.rst</tt>:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format rst mydoc.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
We may now produce various other formats:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; rst2html.py  mydoc.rst &gt; mydoc.html # html
Terminal&gt; rst2latex.py mydoc.rst &gt; mydoc.tex  # latex
Terminal&gt; rst2xml.py   mydoc.rst &gt; mydoc.xml  # XML
Terminal&gt; rst2odt.py   mydoc.rst &gt; mydoc.odt  # OpenOffice
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The OpenOffice file <tt>mydoc.odt</tt> can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program <tt>unovonv</tt>
to convert between the many formats OpenOffice supports <em>on the command line</em>.
Run
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; unoconv --show
</pre>
</blockquote>   <! -- end verbatim block -->
to see all the formats that are supported.
For example, the following commands take
<tt>mydoc.odt</tt> to Microsoft Office Open XML format,
classic MS Word format, and PDF:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; unoconv -f ooxml mydoc.odt
Terminal&gt; unoconv -f doc mydoc.odt
Terminal&gt; unoconv -f pdf mydoc.odt
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Remark about Mathematical Typesetting.</b> At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by <tt>latex</tt> as
output and to a wide extent also supported by the <tt>sphinx</tt> output format.
Some links for going from LaTeX to Word are listed below.

<P>

<ul>
 <li> <a href="http://ubuntuforums.org/showthread.php?t=1033441"><tt>http://ubuntuforums.org/showthread.php?t=1033441</tt></a>
 <li> <a href="http://tug.org/utilities/texconv/textopc.html"><tt>http://tug.org/utilities/texconv/textopc.html</tt></a>
 <li> <a href="http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html"><tt>http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html</tt></a>
</ul>
<h3>Sphinx</h3>
<P>
Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the <tt>doconce sphinx_dir</tt> command:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
</pre>
</blockquote>   <! -- end verbatim block -->
The keywords <tt>author</tt>, <tt>title</tt>, and <tt>version</tt> are used in the headings
of the Sphinx document. By default, <tt>version</tt> is 1.0 and the script
will try to deduce authors and title from the doconce files <tt>file1</tt>,
<tt>file2</tt>, etc. that together represent the whole document. Note that
none of the individual Doconce files <tt>file1</tt>, <tt>file2</tt>, etc. should
include the rest as their union makes up the whole document.
The default value of <tt>dirname</tt> is <tt>sphinx-rootdir</tt>. The <tt>theme</tt>
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is <tt>'default'</tt>).

<P>
With a single-file document in <tt>mydoc.do.txt</tt> one often just runs
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce sphinx_dir mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
and then an appropriate Sphinx directory <tt>sphinx-rootdir</tt> is made with
relevant files.

<P>
The <tt>doconce sphinx_dir</tt> command generates a script
<tt>automake-sphinx.py</tt> for compiling the Sphinx document into an HTML
document.  One can either run <tt>automake-sphinx.py</tt> or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

<P>
Te <tt>doconce sphinx_dir</tt> script copies directories named <tt>figs</tt> or <tt>figures</tt>
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, <tt>automake-sphinx.py</tt> must be edited accordingly.
Links to local files (not <tt>http:</tt> or <tt>file:</tt> URLs) must be placed
in the <tt>_static</tt> subdirectory of the Sphinx directory. The
utility <tt>doconce sphinxfix_localURLs</tt> is run to check for local
links: for each such link, say <tt>dir1/dir2/myfile.txt</tt> it replaces
the link by <tt>_static/myfile.txt</tt> and copies <tt>dir1/dir2/myfile.txt</tt>
to a local <tt>_static</tt> directory (in the same directory as the
script is run). The user must copy all <tt>_static/*</tt> files to the
<tt>_static</tt> subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the <tt>_static</tt> subdirectory of the Sphinx directory.
It may be wise to place relevant files in a <tt>_static</tt> directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

<P>
Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the <tt>conf.py</tt>
configuration file for Sphinx is edited accordingly, and a script
<tt>make-themes.sh</tt> can make HTML documents with one or more themes.
For example,
to realize the themes <tt>fenics</tt> and <tt>pyramid</tt>, one writes
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ./make-themes.sh fenics pyramid
</pre>
</blockquote>   <! -- end verbatim block -->
The resulting directories with HTML documents are <tt>_build/html_fenics</tt>
and <tt>_build/html_pyramid</tt>, respectively. Without arguments,
<tt>make-themes.sh</tt> makes all available themes (!).

<P>
If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file <tt>mydoc.do.txt</tt>.

<P>
<b>Step 1.</b> Translate Doconce into the Sphinx format:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format sphinx mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Step 2.</b> Create a Sphinx root directory
either manually or by using the interactive <tt>sphinx-quickstart</tt>
program. Here is a scripted version of the steps with the latter:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
mkdir sphinx-rootdir
sphinx-quickstart &lt;&lt;EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
</pre>
</blockquote>   <! -- end verbatim block -->
The autogenerated <tt>conf.py</tt> file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The <tt>doconce sphinx_dir</tt> generator makes an extended <tt>conv.py</tt>
file where, among other things, several useful Sphinx extensions
are included.

<P>

<P>
<b>Step 3.</b> Copy the <tt>mydoc.rst</tt> file to the Sphinx root directory:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; cp mydoc.rst sphinx-rootdir
</pre>
</blockquote>   <! -- end verbatim block -->
If you have figures in your document, the relative paths to those will
be invalid when you work with <tt>mydoc.rst</tt> in the <tt>sphinx-rootdir</tt>
directory. Either edit <tt>mydoc.rst</tt> so that figure file paths are correct,
or simply copy your figure directories to <tt>sphinx-rootdir</tt>.
Links to local files in <tt>mydoc.rst</tt> must be modified to links to
files in the <tt>_static</tt> directory, see comment above.

<P>
<b>Step 4.</b> Edit the generated <tt>index.rst</tt> file so that <tt>mydoc.rst</tt>
is included, i.e., add <tt>mydoc</tt> to the <tt>toctree</tt> section so that it becomes
<blockquote>    <!-- begin verbatim block  -->
<pre>
.. toctree::
   :maxdepth: 2

   mydoc
</pre>
</blockquote>   <! -- end verbatim block -->
(The spaces before <tt>mydoc</tt> are important!)

<P>
<b>Step 5.</b> Generate, for instance, an HTML version of the Sphinx source:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
make clean   # remove old versions
make html
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with <tt>index.html</tt> files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

<P>
<b>Step 6.</b> View the result:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; firefox _build/html/index.html
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows <tt>!bc</tt>: <tt>cod</tt> gives Python
(<tt>code-block:: python</tt> in Sphinx syntax) and <tt>cppcod</tt> gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.

<P>

<P>
<h3>Wiki Formats</h3>
<P>
There are many different wiki formats, but Doconce only supports three:
<a href="http://code.google.com/p/support/wiki/WikiSyntax<Google Code>">Googlecode wiki</a>, , MediaWiki, and Creole Wiki. These formats are called
<tt>gwiki</tt>, <tt>mwiki</tt>, and <tt>cwiki</tt>, respectively.
Transformation from Doconce to these formats is done by
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; doconce format gwiki mydoc.do.txt
Terminal&gt; doconce format mwiki mydoc.do.txt
Terminal&gt; doconce format cwiki mydoc.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The Googlecode wiki document, <tt>mydoc.gwiki</tt>, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

<P>
When the Doconce file contains figures, each figure filename must in
the <tt>.gwiki</tt> file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

<P>
From the MediaWiki format one can go to other formats with aid
of <a href="http://pediapress.com/code/">mwlib</a>. This means that one can
easily use Doconce to write <a href="http://en.wikibooks.org">Wikibooks</a>
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.

<P>

<P>
<h3>Tweaking the Doconce Output</h3>
<P>
Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
<tt>.rst</tt> file is going to be filtered to LaTeX or HTML, it cannot know
if <tt>.eps</tt> or <tt>.png</tt> is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The <tt>make.sh</tt> files in <tt>docs/manual</tt> and <tt>docs/tutorial</tt>
constitute comprehensive examples on how such scripts can be made.

<P>

<P>

<P>
<h2>The Doconce Markup Language</h2>
<P>
The Doconce format introduces four constructs to markup text:
lists, special lines, inline tags, and environments.

<P>
<h3>Lists</h3>
<P>
An unordered bullet list makes use of the <tt>*</tt> as bullet sign
and is indented as follows

<P>
<blockquote>    <!-- begin verbatim block  -->
<pre>
   * item 1

   * item 2

     * subitem 1, if there are more
       lines, each line must
       be intended as shown here

     * subitem 2,
       also spans two lines

   * item 3
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
This list gets typeset as

<P>

<ul>
   <li> item 1
   <li> item 2

<ul>
     <li> subitem 1, if there are more
       lines, each line must
       be intended as shown here
     <li> subitem 2,
       also spans two lines
</ul>

   <li> item 3
</ul>

In an ordered list, each item starts with an <tt>o</tt> (as the first letter
in "ordered"):

<P>
<blockquote>    <!-- begin verbatim block  -->
<pre>
   o item 1

   o item 2

     * subitem 1

     * subitem 2

   o item 3
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
resulting in

<P>

<ol>
  <li> item 1
  <li> item 2

<ul>
     <li> subitem 1
     <li> subitem 2
</ul>

  <li> item 3
</ol>

Ordered lists cannot have an ordered sublist, i.e., the ordering
applies to the outer list only.

<P>
In a description list, each item is recognized by a dash followed
by a keyword followed by a colon:

<P>
<blockquote>    <!-- begin verbatim block  -->
<pre>
   - keyword1: explanation of keyword1

   - keyword2: explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The result becomes

<P>

<dl>
   <dt>keyword1:<dd> 
     explanation of keyword1
   <dt>keyword2:<dd> 
     explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)
</dl>
<h3>Special Lines</h3>
<P>
The Doconce markup language has a concept called <em>special lines</em>.
Such lines starts with a markup at the very beginning of the
line and are used to mark document title, authors, date,
sections, subsections, paragraphs., figures, movies, etc.

<P>

<P>
<b>Heading with Title and Author(s).</b> Lines starting with <tt>TITLE:</tt>, <tt>AUTHOR:</tt>, and <tt>DATE:</tt> are optional and used
to identify a title of the document, the authors, and the date. The
title is treated as the rest of the line, so is the date, but the
author text consists of the name and associated institution(s) with
the syntax
<blockquote>    <!-- begin verbatim block  -->
<pre>
name at institution1 and institution2 and institution3
</pre>
</blockquote>   <! -- end verbatim block -->
The <tt>at</tt> with surrounding spaces
is essential for adding information about institution(s)
to the author name, and the <tt>and</tt> with surrounding spaces is
essential as delimiter between different institutions.
An email address can optionally be included, using the syntax
<blockquote>    <!-- begin verbatim block  -->
<pre>
name Email: somename@site.net at institution1 and institution2
</pre>
</blockquote>   <! -- end verbatim block -->
Multiple authors require multiple <tt>AUTHOR:</tt> lines. All information
associated with <tt>TITLE:</tt> and <tt>AUTHOR:</tt> keywords must appear on a single
line.  Here is an example:
<blockquote>    <!-- begin verbatim block  -->
<pre>
TITLE: On an Ultimate Markup Language
AUTHOR: H. P. Langtangen at Center for Biomedical Computing, Simula Research Laboratory and Dept. of Informatics, Univ. of Oslo
AUTHOR: Kaare Dump Email: dump@cyb.space.com at Segfault, Cyberspace Inc.
AUTHOR: A. Dummy Author
DATE: November 9, 2016
</pre>
</blockquote>   <! -- end verbatim block -->
Note how one can specify a single institution, multiple institutions,
and no institution. In some formats (including <tt>rst</tt> and <tt>sphinx</tt>)
only the author names appear. Some formats have
"intelligence" in listing authors and institutions, e.g., the plain text
format:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Hans Petter Langtangen [1, 2]
Kaare Dump  (dump@cyb.space.com) [3]
A. Dummy Author

[1] Center for Biomedical Computing, Simula Research Laboratory
[2] Department of Informatics, University of Oslo
[3] Segfault, Cyberspace Inc.
</pre>
</blockquote>   <! -- end verbatim block -->
Similar typesetting is done for LaTeX and HTML formats.

<P>
The current date can be specified as <tt>today</tt>.

<P>

<P>
<b>Section Headings.</b> Section headings are recognized by being surrounded by equal signs (=) or
underscores before and after the text of the headline. Different
section levels are recognized by the associated number of underscores
or equal signs (=):

<P>

<ul>
   <li> 9 <tt>=</tt> characters for chapters
   <li> 7 for sections
   <li> 5 for subsections
   <li> 3 for subsubsections
   <li> 2 <em>underscrores</em> (only! - it looks best) for paragraphs
     (paragraph heading will be inlined)
</ul>

Headings can be surrounded by as many blanks as desired.

<P>
Doconce also supports abstracts. This is typeset as a paragraph, but
<em>must</em> be followed by a section heading (everything up to the first
section heading is taken as part of the text of the abstract).

<P>

<P>
Here are some examples:
<blockquote>    <!-- begin verbatim block  -->
<pre>
__Abstract.__ The following text just attempts to exemplify
various section headings.

========= Example on a Chapter Heading =========

Some text.


======= Example on a Section Heading =======

The running text goes here.


===== Example on a Subsection Heading =====

The running text goes here.

===Example on a Subsubsection Heading===

The running text goes here.

__A Paragraph.__ The running text goes here.
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h2>Special Lines</h2>
<P>
<h3>Figures</h3>
<P>
Figures are recognized by the special line syntax
<blockquote>    <!-- begin verbatim block  -->
<pre>
FIGURE:[filename, height=xxx width=yyy scale=zzz] possible caption
</pre>
</blockquote>   <! -- end verbatim block -->
The filename can be without extension, and Doconce will search for an
appropriate file with the right extension. If the extension is wrong,
say <tt>.eps</tt> when requesting an HTML format, Doconce tries to find another
file, and if not, the given file is converted to a proper format
(using ImageMagick's <tt>convert</tt> utility).

<P>
The height, width, and scale keywords (and others) can be included
if desired and may have effect for some formats. Note the comma
between the sespecifications and that there should be no space
around the = sign.

<P>
Note also that, like for <tt>TITLE:</tt> and <tt>AUTHOR:</tt> lines, all information
related to a figure line <em>must be written on the same line</em>. Introducing
newlines in a long caption will destroy the formatting (only the
part of the caption appearing on the same line as <tt>FIGURE:</tt> will be
included in the formatted caption).

<P>
<center><hr>
<caption><i>Streamtube visualization of a fluid flow. <a name="fig:viz"></A></i></caption>
<p><img src="figs/streamtubes.png" align="bottom" width=400></p>
</center>

<P>
Combining several image files into one can be done by the
<tt>convert</tt> and <tt>montage</tt> programs from the ImageMagick suite:
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
montage file1.png file2.png ... file4.png -geometry +2+2  result.png
montage file1.png file2.png -tile x1 result.png
montage file1.png file2.png -tile 1x result.png

convert -background white file1.png file2.png +append tmp.png
</pre>
</blockquote>   <! -- end verbatim block -->
Use <tt>+append</tt> for stacking left to right, <tt>-append</tt> for top to bottom.
The positioning of the figures can be controlled by <tt>-gravity</tt>.

<P>
<h3>Movies</h3>
<P>
Here is an example on the <tt>MOVIE:</tt> keyword for embedding movies. This
feature works well for the <tt>latex</tt>, <tt>html</tt>, <tt>rst</tt>, and <tt>sphinx</tt> formats.
Other formats try to generate some HTML file and link to that file
for showing the movie.
<blockquote>    <!-- begin verbatim block  -->
<pre>
MOVIE: [filename, height=xxx width=yyy] possible caption
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<!-- latex/PDF format can make use of the movie15 package for displaying movies, -->
<!-- or just plain \h<a href="#run: ...">run: ...</a>{...} -->

<P>

<embed src="figs/mjolnir.mpeg" width=600 height=470 autoplay="false" loop="true"></embed>
<p>
<em></em>
</p>


<P>
<!-- MOVIE: [figs/wavepacket.gif, width=600 height=470] -->

<P>
<!-- MOVIE: [figs/wavepacket2.mpeg, width=600 height=470] -->

<P>
The LaTeX format results in a file that can either make use of
the movie15 package (requires the PDF to be shown in Acrobat Reader)
or just a plain address to the movie. The HTML, reST, and
Sphinx formats will play
the movie right away by embedding the file in a standard HTML code,
provided the output format is HTML.
For all other formats a URL to an HTML file, which can play the code,
is inserted in the output document.

<P>
When movies are embedded in the PDF file via LaTeX and
the <tt>movie15</tt> package wanted, one has to turn on the preprocessor
variable <tt>MOVIE15</tt>. There is an associated variable
<tt>EXTERNAL_MOVIE_VIEWER</tt> which can be defined to launch an external
viewer when displaying the PDF file (in Acrobat Reader):
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; ptex2tex -DMOVIE15 -DEXTERNAL_MOVIE_VIEWER mydoc
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The HTML, reST, and Sphinx formats can also treat filenames of the form
<tt>myframes*.png</tt>. In that case, an HTML file for showing the sequence of frames
is generated, and a link to this file is inserted in the output document.
That is, a simple "movie viewer" for the frames is made.

<P>
Many publish their scientific movies on YouTube, and Doconce recognizes
YouTube URLs as movies. When the output is an HTML file, the movie will
be embedded, otherwise a URL to the YouTube page is inserted.
You should equip the <tt>MOVIE:</tt> command with the right width and height
of embedded YouTube movies (the parameters appear when you request
the embedded HTML code for the movie on the YouTube page).

<P>

<P>

<P>
<h3>Copying Computer Code from Source Files</h3>
<P>
Another type of special lines starts with <tt>@@@CODE</tt> and enables copying
of computer code from a file directly into a verbatim environment, see
the section <a href="#sec:verbatim:blocks">Blocks of Verbatim Computer Code</a> below.

<P>

<P>
<h3>Inline Tagging <a name="inline:tagging"></A></h3>
<P>

<P>
Doconce supports tags for <em>emphasized phrases</em>, <b>boldface phrases</b>,
and <tt>verbatim text</tt> (also called type writer text, for inline code)
plus LaTeX/TeX inline mathematics, such as \( \nu = \sin(x) \)o.

<P>
Emphasized text is typeset inside a pair of asterisk, and there should
be no spaces between an asterisk and the emphasized text, as in
<blockquote>    <!-- begin verbatim block  -->
<pre>
*emphasized words*
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Boldface font is recognized by an underscore instead of an asterisk:
<blockquote>    <!-- begin verbatim block  -->
<pre>
_several words in boldface_ followed by *ephasized text*.
</pre>
</blockquote>   <! -- end verbatim block -->
The line above gets typeset as
<b>several words in boldface</b> followed by <em>ephasized text</em>.

<P>
Verbatim text, typically used for short inline code,
is typeset between back-ticks:
<blockquote>    <!-- begin verbatim block  -->
<pre>
`call myroutine(a, b)` looks like a Fortran call
while `void myfunc(double *a, double *b)` must be C.
</pre>
</blockquote>   <! -- end verbatim block -->
The typesetting result looks like this:
<tt>call myroutine(a, b)</tt> looks like a Fortran call
while <tt>void myfunc(double *a, double *b)</tt> must be C.

<P>
It is recommended to have inline verbatim text on the same line in
the Doconce file, because some formats (LaTeX and <tt>ptex2tex</tt>) will have
problems with inline verbatim text that is split over two lines.

<P>
Watch out for mixing back-ticks and asterisk (i.e., verbatim and
emphasized code): the Doconce interpreter is not very smart so inline
computer code can soon lead to problems in the final format. Go back to the
Doconce source and modify it so the format to which you want to go
becomes correct (sometimes a trial and error process - sticking to
very simple formatting usually avoids such problems).

<P>
Web addresses with links are typeset as
<blockquote>    <!-- begin verbatim block  -->
<pre>
some URL like "Doconce": "http://code.google.com/p/doconce"
</pre>
</blockquote>   <! -- end verbatim block -->
which appears as some URL like <a href="http://google.com">Search Google</a>.
The space after colon is optional.
Links to files ending in <tt>.txt</tt>, <tt>.html</tt>, <tt>.pdf</tt>, <tt>.py</tt>, <tt>.f</tt>,
<tt>.f77</tt>, <tt>.f90</tt>, <tt>.f95</tt>, <tt>.sh</tt>, <tt>.csh</tt>, <tt>.ksh</tt>, <tt>.zsh</tt>,
<tt>.c</tt>, <tt>.cpp</tt>, <tt>.cxx</tt>, <tt>.pl</tt>, and <tt>.java</tt> follows the same
setup:
<blockquote>    <!-- begin verbatim block  -->
<pre>
see the "Doconce Manual": "manual.do.txt".
</pre>
</blockquote>   <! -- end verbatim block -->
which appears as see the <a href="manual.do.txt">Doconce Manual</a>.
If you want to view such source code files <em>in the browser</em>,
rather than dowloading the file, we recommend to transform
the source code file to HTML format by running
<tt>pygmentize</tt>, e.g.,
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; pygmentize -l bash -f html -O full,style=emacs \
          -o _static/make.sh.html subdir/make.sh
</pre>
</blockquote>   <! -- end verbatim block -->
Then you can link to <tt>_static/make.sh.html</tt> instead of
<tt>subdir/make.sh</tt>. Or you can do both versions:
<blockquote>    <!-- begin verbatim block  -->
<pre>
See the code URL:"src/myprog.py" ("view: "_static/myprog.py.html").
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Links to files with other extensions must be realized
<em>with the filename as link text</em>, written as
the keyword URL, followed by a colon, and then the filename enclosed
in double quotes:
<blockquote>    <!-- begin verbatim block  -->
<pre>
URL: "manual.html"
</pre>
</blockquote>   <! -- end verbatim block -->
resulting in the link <a href="manual.html"><tt>manual.html</tt></a>.

<P>
<!-- This is now automatically carried out by the autogenerated -->
<!-- script for sphinx: -->
<!-- For such local links to -->
<!-- work with the <tt>sphinx</tt> format, the <tt>.rst</tt> file needs a fix, carried -->
<!-- out by -->
<!-- !bc sys -->
<!-- doconce sphinxfix_localURLs mydoc.rst -->
<!-- !ec -->
<!-- (The files, such as <tt>manual.html</tt>, are then copied to a subdirectory -->
<!-- <tt>_static</tt>, which must be manually copied to the Sphinx directory's -->
<!-- <tt>_static</tt> directory - links in the <tt>.rst</tt> files are automatically -->
<!-- adjusted.) -->

<P>
To have the URL address itself as link text, put an "URL" or URL
before the address enclosed in double quotes:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Click on this link: URL:"http://code.google.com/p/doconce".
</pre>
</blockquote>   <! -- end verbatim block -->
resulting in Click on this link: <a href="http://code.google.com/p/doconce"><tt>http://code.google.com/p/doconce</tt></a>.

<P>
Doconce also supports inline comments in the text:
<blockquote>    <!-- begin verbatim block  -->
<pre>
[name: comment]
</pre>
</blockquote>   <! -- end verbatim block -->
where <tt>name</tt> is the name of the author of the command, and <tt>comment</tt> is a
plain text text. [<b>hpl</b>: <em>Note that there must be a space after the colon,
otherwise the comment is not recognized. Inline comments
can span
several lines,
if desired.</em>]
The name and comment are visible in the output unless <tt>doconce format</tt>
is run with a command-line argument <tt>--skip_inline_comments</tt>
(see the chapter <a href="#doconce2formats">From Doconce to Other Formats</a> for an example). Inline comments
are helpful during development of a document since different authors
and readers can comment on formulations, missing points, etc.
All such comments can easily be removed from the <tt>.do.txt</tt> file
(see the chapter <a href="#doconce2formats">From Doconce to Other Formats</a>).

<P>
Inline mathematics is written as in LaTeX, i.e., inside dollar signs.
Most formats leave this syntax as it is (including to dollar signs),
hence nice math formatting is only obtained in LaTeX (Epytext has some
inline math support that is utilized).  However, mathematical
expressions in LaTeX syntax often contains special formatting
commands, which may appear annoying in plain text. Doconce therefore
supports an extended inline math syntax where the writer can provide
an alternative syntax suited for formats close to plain ASCII:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Here is an example on a linear system
${\bf A}{\bf x} = {\bf b}$|$Ax=b$,
where $\bf A$|$A$ is an $n\times n$|$nxn$ matrix, and
$\bf x$|$x$ and $\bf b$|$b$ are vectors of length $n$|$n$.
</pre>
</blockquote>   <! -- end verbatim block -->
That is, we provide two alternative expressions, both enclosed in
dollar signs and separated by a pipe symbol, the expression to the
left is used in LaTeX, while the expression to the right is used for
all other formats.  The above text is typeset as "Here is an example
on a linear system \( {\bf A}{\bf x} = {\bf b} \)o, where \( \bf A \)o
is an \( n\times n \)o matrix, and \( \bf x \)o and \( \bf b \)o
are vectors of length \( n \)o."

<P>
<h3>Comments</h3>
<P>
Comments intended to be visible in the output document and read by
readers are known as <em>inline comments</em> in Doconce and described
in the section <a href="#inline:tagging">Inline Tagging</a>.

<P>
Here we address comments in the Doconce source file that are not
intended to be visible in the output document. Basic comment
lines start with the hash <tt>#</tt>:
<blockquote>    <!-- begin verbatim block  -->
<pre>
#
# Here are some comment lines that do not affect any formatting.
# These lines are converted to comments in the output format.
#
</pre>
</blockquote>   <! -- end verbatim block -->
Such comment lines may have some side effects in the <tt>rst</tt> and <tt>sphinx</tt>
formats because following lines are taken as part of the comment if
there is not a blank line after the comment.

<P>
The Mako preprocessor supports comments that are filtered out <em>before</em>
Doconce starts translating the document. Such comments are very valuable
as they will never interfere with the output format and they are only
present in the Doconce source. Mako has two types of comments:
lines starting with a double hash <tt>##</tt> and lines enclosed by
the <tt><%doc></tt> (beginning) and <tt><%doc/></tt> (closing) tags.

<P>
If you need a lot of comments in the Doconce file, consider using
Mako comments instead of the single hash, unless you want to
comments to be in the source code of the output document.

<P>

<P>
<h3>Cross-Referencing</h3>
<P>
References and labels are supported. The syntax is simple:
<blockquote>    <!-- begin verbatim block  -->
<pre>
\label{section:verbatim}   # defines a label
For more information we refer to Section ref{section:verbatim}.
</pre>
</blockquote>   <! -- end verbatim block -->
This syntax is close that that of labels and cross-references in
LaTeX. When the label is placed after a section or subsection heading,
the plain text, Epytext, and StructuredText formats will simply
replace the reference by the title of the (sub)section.  All labels
will become invisible, except those in math environments.  In the
<tt>rst</tt> and <tt>sphinx</tt> formats, the end effect is the same, but
the "label" and "ref" commands are first translated to the proper
reST commands by <tt>doconce format</tt>. In the HTML and (Google
Code) wiki formats, labels become anchors and references become links,
and with LaTeX "label" and "ref" are just equipped with backslashes so
these commands work as usual in LaTeX.

<P>
It is, in general, recommended to use labels and references for
(sub)sections, equations, and figures only.
By the way, here is an example on referencing Figure <a href="#fig:viz">fig:viz</a>
(the label appears in the figure caption in the source code of this document).
Additional references to the sections <a href="#mathtext">LaTeX Blocks of Mathematical Text</a> and <a href="#newcommands">Macros (Newcommands)</a> are
nice to demonstrate, as well as a reference to equations,
say (<a href="#my:eq1">my:eq1</a>)--(<a href="#my:eq2">my:eq2</a>). A comparison of the output and
the source of this document illustrates how labels and references
are handled by the format in question.

<P>
Hyperlinks to files or web addresses are handled as explained
in the section <a href="#inline:tagging">Inline Tagging</a>.

<P>
<h3>Index and Bibliography</h3>
<P>
An index can be created for the <tt>latex</tt>, <tt>rst</tt>, and <tt>sphinx</tt> formats
by the <tt>idx</tt> keyword, following a LaTeX-inspired syntax:
<blockquote>    <!-- begin verbatim block  -->
<pre>
idx{some index entry}
idx{main entry!subentry}
idx{`verbatim_text` and more}
</pre>
</blockquote>   <! -- end verbatim block -->
The exclamation mark divides a main entry and a subentry. Backquotes
surround verbatim text, which is correctly transformed in a LaTeX setting to
<blockquote>    <!-- begin verbatim block  -->
<pre>
\index{verbatim\_text@\texttt{\rm\smaller verbatim\_text and more}}
</pre>
</blockquote>   <! -- end verbatim block -->
Everything related to the index simply becomes invisible in plain
text, Epytext, StructuredText, HTML, and wiki formats.  Note: <tt>idx</tt>
commands should be inserted outside paragraphs, not in between the
text as this may cause some strange behaviour of reST and
Sphinx formatting.  As a recommended rule, index items are naturally
placed right after section headings, before the text begins, while
index items related to a paragraph should be placed above the
paragraph one a separate line (and not in between the text or between
the paragraph heading and the text body, although this works fine if
LaTeX is the output format).

<P>
Literature citations also follow a LaTeX-inspired style:
<blockquote>    <!-- begin verbatim block  -->
<pre>
as found in cite{Larsen_1986,Nielsen_Kjeldstrup_1999}.
</pre>
</blockquote>   <! -- end verbatim block -->
Citation labels can be separated by comma. In LaTeX, this is directly
translated to the corresponding <tt>cite</tt> command; in reST
and Sphinx the labels can be clicked, while in all the other text
formats the labels are consecutively numbered so the above citation
will typically look like
<blockquote>    <!-- begin verbatim block  -->
<pre>
as found in [3][14]
</pre>
</blockquote>   <! -- end verbatim block -->
if <tt>Larsen_1986</tt> has already appeared in the 3rd citation in the document
and <tt>Nielsen_Kjeldstrup_1999</tt> is a new (the 14th) citation. The citation labels
can be any sequence of characters, except for curly braces and comma.

<P>
The bibliography itself is specified by the special keyword <tt>BIBFILE:</tt>,
which is optionally followed by a BibTeX file, having extension <tt>.bib</tt>,
a corresponding reST bibliography, having extension <tt>.rst</tt>,
or simply a Python dictionary written in a file with extension <tt>.py</tt>.
The dictionary in the latter file should have the citation labels as
keys, with corresponding values as the full reference text for an item
in the bibliography. Doconce markup can be used in this text, e.g.,
<blockquote>    <!-- begin verbatim block  -->
<pre>
{
'Nielsen_Kjeldstrup_1999': """
K. Nielsen and A. Kjeldstrup. *Some Comments on Markup Languages*.
URL:"http://some.where.net/nielsen/comments", 1999.
""",
'Larsen_1986':
"""
O. B. Larsen. On Markup and Generality.
*Personal Press*. 1986.
"""
}
</pre>
</blockquote>   <! -- end verbatim block -->
In the LaTeX format, the <tt>.bib</tt> file will be used in the standard way,
in the <tt>rst</tt> and <tt>sphinx</tt> formats, the <tt>.rst</tt> file will be
copied into the document at the place where the <tt>BIBFILE:</tt> keyword
appears, while all other formats will make use of the Python dictionary
typeset as an ordered Doconce list, replacing the <tt>BIBFILE:</tt> line
in the document.

<P>
At present, only one file with bibliographic references can be used.

<P>
<!-- see ketch/tex2rst for nice bibtex to rst converter which could -->
<!-- be used here -->

<P>
Conversion of BibTeX databases to reST format can be
done by the <a href="http://pypi.python.org/pypi/bibliograph.parsing/">bibliograph.parsing</a> tool.

<P>
Finally, we here test the citation command and bibliography by
citing a book <a href="#Python:Primer:09">[1]</a>, a paper <a href="#Osnes:98">[2]</a>,
and both of them simultaneously <a href="#Python:Primer:09">[1]</a> <a href="#Osnes:98">[2]</a>.

<P>
[<b>somereader</b>: <em>comments, citations, and references in the latex style
is a special feature of doconce :-) </em>]

<P>

<P>
<h3>Tables</h3>
<P>
A table like

<P>
<table border="1">
<tr><td align="center"><b>    time    </b></td> <td align="center"><b>  velocity  </b></td> <td align="center"><b>acceleration</b></td> </tr>
<tr><td align="right">   0.0             </td> <td align="right">   1.4186          </td> <td align="right">   -5.01           </td> </tr>
<tr><td align="right">   2.0             </td> <td align="right">   1.376512        </td> <td align="right">   11.919          </td> </tr>
<tr><td align="right">   4.0             </td> <td align="right">   1.1E+1          </td> <td align="right">   14.717624       </td> </tr>
</table>
<P>
is built up of pipe symbols and dashes:
<blockquote>    <!-- begin verbatim block  -->
<pre>
  |--------------------------------|
  |time  | velocity | acceleration |
  |--------------------------------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
</pre>
</blockquote>   <! -- end verbatim block -->
The pipes and column values do not need to be aligned (but why write
the Doconce source in an ugly way?). In the line below the heading,
one can insert the characters <tt>c</tt>, <tt>r</tt>, or <tt>l</tt> to specify the
alignment of the columns (centered, right, or left, respectively).
Similar character can be inserted in the line above the header to
algn the headings. Pipes <tt>|</tt> can also be inserted to indicate
vertical rules in LaTeX tables (they are ignored for other formats).
Note that not all formats offer alignment of heading or entries
in tables (<tt>rst</tt> and <tt>sphinx</tt> are examples). Also note that
Doconce tables are very simple: neither entries nor
headings can span several columns or rows. When that functionality
is needed, one can make use of the preprocessor and if-tests on
the format and insert format-specific code for tables.

<P>

<P>

<P>
<h3>Exercises, Problems, or Projects</h3>
<P>
Doconce has special support for three types of "exercises", named
<em>exercise</em>, <em>problem</em>, or <em>project</em>.
These are all typeset as special kind of
sections. Such sections start with a subsection or subsubsection
headline, indicated by 3 or 5 <tt>=</tt> characters, and last up to the
next headline or the end of the file. The headline itself must
consists of the word "Exercise", "Problem", or "Project", followed
by a colon and a title of the exercise, problem, or project.
The next line(s) may contain a label and specification of the
name of result file (if the answer to the exercise is to be handed
it) and a solution file:
<blockquote>    <!-- begin verbatim block  -->
<pre>
===== Project: Determine the Distance to the Moon =====
\label{proj:moondist} file=earth2moon.pdf
solution=eart2moon_sol.do.txt

Here goes the running text of the project....

__Hint 1.__ Do not plan a travel to the moon.

__Hint 2.__ Wikipedia is always helpful.
</pre>
</blockquote>   <! -- end verbatim block -->
Doconce will recognize the exercise, problem, or project <em>title</em>,
the <em>label</em>, the <em>result file</em>, the <em>solution file</em> (if any of
these three entities is present), the <em>text</em>, and a sequence of
<em>hints</em>. Tailored formatting of exercises in special output formats
can make use of this. For example, one can image web formats where
the hints are displayed one by one when needed and where the result
file can be uploaded. One can also think of mechanisms for downloading
the solution file if the result file meets certain criteria.
Doconce does not yet generate such functionality in any output format,
but this is an intended future feature to be impelemented.

<P>
Because exercises, problems, and projects are typeset as ordinary
sections (this is the most general approach that will work for many
formats), one must refer to an exercise, problem, or project
by its label, which normally will translate to the section number
(in LaTeX, for instance) or a link to the title of the section.
The <em>title</em> is typeset without any leading "Exercise:", "Problem:",
or "Project:" word, so that references like "see Problem ..."
works well in all formats ("..." will be a number in LaTeX and
the problem title in most other formats).

<P>
It is recommended to collect all exercises as subsetions (or subsubsections)
under a section (or subsection) named "Exercises", "Problems", or
"Projects".

<P>

<P>
<h3>Blocks of Verbatim Computer Code <a name="sec:verbatim:blocks"></A></h3>
<P>

<P>
Blocks of computer code, to be typeset verbatim, must appear inside a
"begin code" <tt>!bc</tt> keyword and an "end code" <tt>!ec</tt> keyword. Both
keywords must be on a single line and <em>start at the beginning of the
line</em>.  Before such a code block there must be a plain sentence
(at least if successful transformation to reST and
ASCII-type formats is desired). For example, a code block cannot come
directly after a section/paragraph heading or a table.

<P>
There may be an argument after the <tt>!bc</tt> tag to specify a
certain environment (for <tt>ptex2tex</tt> or Sphinx) for typesetting
the verbatim code. For instance, <tt>!bc dat</tt> corresponds to
the data file environment and <tt>!bc cod</tt> is typically
used for a code snippet. There are some predefined environments
explained below. If there is
no argument specifying the environment, one assumes some plain
verbatim typesetting (for <tt>ptex2tex</tt> this means the <tt>ccq</tt> environment,
which is defined in the config file <tt>.ptex2tex.cfg</tt>,
while for Sphinx it defaults to the <tt>python</tt> environment).

<P>
Since the config file for <tt>ptex2tex</tt> can define what some environment
maps onto with respect to typesetting, a similar possibility is
supported for Sphinx as well.  The argument after <tt>!bc</tt> is in case of
Sphinx output mapped onto a valid Pygments language for typesetting of
the verbatim block by Pygments. This mapping takes place in an
optional comment to be inserted in the Doconce source file, e.g.,
<blockquote>    <!-- begin verbatim block  -->
<pre>
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
</pre>
</blockquote>   <! -- end verbatim block -->
Here, three arguments are defined: <tt>pycod</tt> for Python code,
<tt>cod</tt> also for Python code, <tt>cppcod</tt> for C++ code, and <tt>sys</tt>
for terminal sessions. The same arguments would be defined
in <tt>.ptex2tex.cfg</tt> for how to typeset the blocks in LaTeX using
various verbatim styles (Pygments can also be used in a LaTeX
context).

<P>
By default, <tt>pro</tt> is used for complete programs in Python, <tt>cod</tt> is
for a code snippet in Python, while <tt>xcod</tt> and <tt>xpro</tt> implies computer
language specific typesetting where <tt>x</tt> can be <tt>f</tt> for Fortran, <tt>c</tt>
for C, <tt>cpp</tt> for C++, <tt>sh</tt> for Unix shells, <tt>pl</tt> for Perl, <tt>m</tt> for
Matlab, <tt>cy</tt> for Cython, and <tt>py</tt> for Python.  The argument <tt>sys</tt>
means by default <tt>console</tt> for Sphinx and <tt>CodeTerminal</tt> (ptex2tex
environent) for LaTeX. Other specifications are <tt>dat</tt> for a data file
or print out, and <tt>ipy</tt> for interactive Python sessions (the latter
does not introduce any environment  in <tt>sphinx</tt> output, as interactive
sessions are automatically recognized and handled).  All these
definitions of the arguments after <tt>!bc</tt> can be redefined in the
<tt>.ptex2tex.cfg</tt> configuration file for ptex2tex/LaTeX and in the
<tt>sphinx code-blocks</tt> comments for Sphinx. Support for other languages
is easily added.

<P>
<!-- (Any sphinx code-block comment, whether inside verbatim code -->
<!-- blocks or outside, yields a mapping between bc arguments -->
<!-- and computer languages. In case of muliple definitions, the -->
<!-- first one is used.) -->

<P>
The enclosing <tt>!ec</tt> tag of verbatim computer code blocks must
be followed by a newline.  A common error in list environments is to
forget to indent the plain text surrounding the code blocks. In
general, we recommend to use paragraph headings instead of list items
in combination with code blocks (it usually looks better, and some
common errors are naturally avoided).

<P>
Here is a verbatim code block with Python code (<tt>pycod</tt> style):
<blockquote>    <!-- begin verbatim block   pycod-->
<pre>
# regular expressions for inline tags:
inline_tag_begin = r'(?P&lt;begin&gt;(^|\s+))'
inline_tag_end = r'(?P&lt;end&gt;[.,?!;:)\s])'
INLINE_TAGS = {
    'emphasize':
    r'%s\*(?P&lt;subst&gt;[^ `][^*`]*)\*%s' % \
    (inline_tag_begin, inline_tag_end),
    'verbatim':
    r'%s`(?P&lt;subst&gt;[^ ][^`]*)`%s' % \
    (inline_tag_begin, inline_tag_end),
    'bold':
    r'%s_(?P&lt;subst&gt;[^ `][^_`]*)_%s' % \
    (inline_tag_begin, inline_tag_end),
}
</pre>
</blockquote>   <! -- end verbatim block -->
And here is a C++ code snippet (<tt>cppcod</tt> style):
<blockquote>    <!-- begin verbatim block   cppcod-->
<pre>
void myfunc(double* x, const double& myarr) {
    for (int i = 1; i &lt; myarr.size(); i++) {
        myarr[i] = myarr[i] - x[i]*myarr[i-1]
    }
}
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<!-- When showing copy from file in !bc envir, intent a character - otherwise -->
<!-- ptex2tex is confused and starts copying... -->
Computer code can be copied directly from a file, if desired. The syntax
is then
<blockquote>    <!-- begin verbatim block  -->
<pre>
 @@@CODE myfile.f
 @@@CODE myfile.f fromto: subroutine\s+test@^C\s{5}END1
</pre>
</blockquote>   <! -- end verbatim block -->
The first line implies that all lines in the file <tt>myfile.f</tt> are
copied into a verbatim block, typset in a <tt>!bc Xpro</tt> environment, where
<tt>X</tt> is the extension of the filename, here <tt>f</tt> (i.e., the environment
becomes <tt>!bc fpro</tt> and will typically lead to some Fortran-style
formatting in Linux and Sphinx).  The
second line has a <tt>fromto:</tt> directive, which implies copying code
between two lines in the code, typset within a !`bc Xcod`
environment (again, <tt>X</tt> is the filename extension, implying the
type of file). Note that the <tt>pro</tt> and <tt>cod</tt> arguments are only used for LaTeX
and Sphinx output, all other formats will have the code typeset within
a plain <tt>!bc</tt> environment.) Two regular expressions, separated by the
<tt>@</tt> sign, define the "from" and "to" lines.  The "from" line is
included in the verbatim block, while the "to" line is not. In the
example above, we copy code from the line matching <tt>subroutine test</tt>
(with as many blanks as desired between the two words) and the line
matching <tt>C END1</tt> (C followed by 5 blanks and then the text END1). The
final line with the "to" text is not included in the verbatim block.

<P>
Let us copy a whole file (the first line above):

<P>
<blockquote>    <!-- begin verbatim block   fpro-->
<pre>
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Let us then copy just a piece in the middle as indicated by the <tt>fromto:</tt>
directive above:

<P>
<blockquote>    <!-- begin verbatim block   fcod-->
<pre>
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
Note that the "to" line is not copied into the Doconce file, but the
"from" line is. Sometimes it is convenient to also neglect the
"from" line, a feature that is allowed by replacing <tt>fromto:</tt> by
<tt>from-to</tt> ("from with minus"). This allows for copying very similar
code segments throughout a file, while still distinguishing between them.
Copying the second set of parameters from the text
<blockquote>    <!-- begin verbatim block   cod-->
<pre>
# --- Start Example 1 ---
c = -1
A = 2
p0 = 4
simulate_and_plot(c, A, p0)
# --- End Example 1 ---

# --- Start Example 2 ---
c = -1
A = 1
p0 = 0
simulate_and_plot(c, A, p0)
# --- End Example 2 ---
</pre>
</blockquote>   <! -- end verbatim block -->
is easy with
<blockquote>    <!-- begin verbatim block  -->
<pre>
from-to: Start Example 2@End Example 2
</pre>
</blockquote>   <! -- end verbatim block -->
With only <tt>fromto:</tt> this would be impossible.

<P>
(Remark for those familiar with <tt>ptex2tex</tt>: The from-to
syntax is slightly different from that used in <tt>ptex2tex</tt>. When
transforming Doconce to LaTeX, one first transforms the document to a
<tt>.p.tex</tt> file to be treated by <tt>ptex2tex</tt>. However, the <tt>@@@CODE</tt> line
is interpreted by Doconce and replaced by the mentioned
pro or cod environment which are defined in the <tt>ptex2tex</tt> configuration
file.)

<P>

<P>
<h3>LaTeX Blocks of Mathematical Text <a name="mathtext"></A></h3>
<P>

<P>
Blocks of mathematical text are like computer code blocks, but
the opening tag is <tt>!bt</tt> (begin TeX) and the closing tag is
<tt>!et</tt>. It is important that <tt>!bt</tt> and <tt>!et</tt> appear on the beginning of the
line and followed by a newline.
<blockquote>    <!-- begin verbatim block  -->
<pre>
$$
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
$$
</pre>
</blockquote>   <! -- end verbatim block -->
Here is the result of the above <tt>!bt</tt> - <tt>!et</tt> block:
$$
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
$$

<P>
This text looks ugly in all Doconce supported formats, except from
LaTeX and Sphinx.  If HTML is desired, and Sphinx is not an option,
one can filter the Doconce text first to LaTeX and then use the tex4ht
tool to convert the dvi file to HTML, or one could just link a PDF
file (made from LaTeX) directly from HTML.

<P>
If the document targets both LaTeX, Sphinx, and other formats like
plain text and wiki, one can use the preprocessor to typeset the
mathematics in two versions. After <tt>#if FORMAT in ("latex", "pdflatex",
"sphinx", "mwiki")</tt> one places LaTeX mathematics, and after <tt>#else</tt> one can
write inline mathematics in a way that looks nice in plain text and
wiki formats without support for mathematical typesetting.

<P>

<P>
<h4>Mathematics for PowerPoint/OpenOffice</h4>
<P>
If you have LaTeX mathematics written in Doconce, it is fairly easy
to generate PNG images of all mathematical formulas and equations for
use with PowerPoint or OpenOffice documents.

<P>

<ol>
 <li> Make a Sphinx version of the Doconce file.
 <li> Go to the Sphinx directory and load the <tt>conf.py</tt> file into
    a browser.
 <li> Search for "math" and comment out the
    <tt>'sphinx.ext.mathjax'</tt> (enabled by default) and
    <tt>'matplotlib.sphinxext.mathmpl'</tt> (disabled by default)
    lines, and uncomment the <tt>'sphinx.ext.pngmath'</tt> package.
    This is the package that generates small PNG pictures
    of the mathematics.
 <li> Uncomment the line with <tt>pngmath_dvipng_args =</tt> and
    set the PNG resolution to <tt>-D 200</tt> when the purpose is to
    generate mathematics pictures for slides.
 <li> Run <tt>make html</tt>.
 <li> Look at the HTML source file in the <tt>_build/html</tt>
    directory: all mathematics are in <tt>img</tt> tags with <tt>src=</tt>
    pointing to a PNG file and <tt>alt=</tt> pointing to the LaTeX
    source for the formula in question. This makes it very
    easy to find the PNG file that corresponding to a particular
    mathematical expression.
</ol>
<h3>Macros (Newcommands) <a name="newcommands"></A></h3>
<P>

<P>
Doconce supports a type of macros via a LaTeX-style <em>newcommand</em>
construction.  The newcommands defined in a file with name
<tt>newcommand_replace.tex</tt> are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names <tt>newcommands.tex</tt> and
<tt>newcommands_keep.tex</tt> are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
<tt>!bt</tt> and <tt>!et</tt> in <tt>newcommands_keep.tex</tt> to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
<tt>newcommands_replace.tex</tt> and expanded by Doconce.  The definitions of
newcommands in the <tt>newcommands*.tex</tt> files <em>must</em> appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

<P>
<b>Example.</b> Suppose we have the following commands in
<tt>newcommand_replace.tex</tt>:

<P>
<blockquote>    <!-- begin verbatim block   pro-->
<pre>
\newcommand{\beqa}{\begin{eqnarray}}
\newcommand{\eeqa}{\end{eqnarray}}
\newcommand{\ep}{\thinspace . }
\newcommand{\uvec}{\vec u}
\newcommand{\Q}{\pmb{Q}}
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
and these in <tt>newcommands_keep.tex</tt>:

<P>
<blockquote>    <!-- begin verbatim block   pro-->
<pre>
\newcommand{\x}{\pmb{x}}
\newcommand{\normalvec}{\pmb{n}}
\newcommand{\Ddt}[1]{\frac{D#1}{dt}}
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The LaTeX block
<blockquote>    <!-- begin verbatim block  -->
<pre>
\beqa
\x\cdot\normalvec &=& 0, \label{my:eq1}\\
\Ddt{\uvec} &=& \Q \ep   \label{my:eq2}
\eeqa
</pre>
</blockquote>   <! -- end verbatim block -->
will then be rendered to
$$
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
$$
in the current format.

<P>
<h3>Preprocessing Steps</h3>
<P>
Doconce allows preprocessor commands for, e.g., including files,
leaving out text, or inserting special text depending on the format.
Two preprocessors are supported: preprocess
(<a href="http://code.google.com/p/preprocess"><tt>http://code.google.com/p/preprocess</tt></a>) and mako
(<a href="http://www.makotemplates.org/"><tt>http://www.makotemplates.org/</tt></a>). The former allows include and if-else
statements much like the well-known preprocessor in C and C++ (but it
does not allow sophisticated macro substitutions). The latter
preprocessor is a very powerful template system.  With Mako you can
automatically generate various type of text and steer the generation
through Python code embedded in the Doconce document. An arbitrary set
of <tt>name=value</tt> command-line arguments (at the end of the command line)
automatically define Mako variables that are substituted in the document.

<P>
Doconce will detect if preprocess or Mako commands are used and run
the relevant preprocessor prior to translating the Doconce source to a
specific format.

<P>
The preprocess and mako programs always have the variable <tt>FORMAT</tt>
defined as the desired output format of Doconce (<tt>html</tt>, <tt>latex</tt>,
<tt>plain</tt>, <tt>rst</tt>, <tt>sphinx</tt>, <tt>epydoc</tt>, <tt>st</tt>).  It is then easy to test on
the value of <tt>FORMAT</tt> and take different actions for different
formats. For example, one may create special LaTeX output for figures,
say with multiple plots within a figure, while other formats may apply
a separate figure for each plot. Below is an example (see the Doconce
source code of this document to understand how preprocess is used to
create the example).

<P>
<!-- If PNGFIGS is defined, PNG files are used, otherwise Encapsulated -->
<!-- PostScript files are used. -->

<P>

<P>
<!-- Use default Doconce figure handling for all other formats -->

<P>
<center><hr>
<caption><i>Wavepacket at time 0.1 s.</i></caption>
<p><img src="figs/wavepacket_0001.png" align="bottom" width=400></p>
</center>

<P>
<center><hr>
<caption><i>Wavepacket at time 0.2 s.</i></caption>
<p><img src="figs/wavepacket_0010.png" align="bottom" width=400></p>
</center>

<P>

<P>
Other user-defined variables for the preprocessor can be set at
the command line as explained in the section <a href="#doconce2formats">From Doconce to Other Formats</a>.

<P>
More advanced use of mako can include Python code that may automate
the writing of parts of the document.

<P>

<P>

<P>
<h3>Splitting Documents into Smaller Pieces</h3>
<P>
Long documents are conveniently split into smaller Doconce files.
However, there must be a master document including all the pieces,
otherwise references to sections and the index will not work properly.
The master document is preferably a file just containing a set of
preprocessor include statements of the form <tt>#include "file.do.txt"</tt>.
The preprocessor will put together all the pieces so that Doconce
sees a long file with the complete text.

<P>
For reST and Sphinx documents it is a point to have
separate <tt>.rst</tt> files and an index file listing the various <tt>.rst</tt>
that build up the document. To generate the various <tt>.rst</tt> files one
should not run Doconce on the individual <tt>.do.txt</tt> files, because then
references and index entries are not treated correctly. Instead,
run Doconce on the master file and invoke the script <tt>doconce split_rst</tt>
to split the long, complete <tt>.rst</tt> into pieces. This process requires
that each <tt>#include "file.do.txt</tt> line in the master file is preceded by a
"marker line" having the syntax <tt>#>>>>>> part: file >>>>>></tt>, where
<tt>file</tt> is the filename without extension. The number of greater than
signs is not important, but it has to be a comment line and it has
to contain the keyword <tt>part:</tt>.

<P>
Here is an example. Say the name of the master file is <tt>master.do.txt</tt>.
The following Bash script does the job:
We run
<blockquote>    <!-- begin verbatim block   cod-->
<pre>
doconce format sphinx master
# Split master.rst into parts
# as defined by #&gt;&gt;&gt;&gt;&gt; part: name &gt;&gt;&gt;&gt;&gt; lines
files=`doconce split_rst master.rst`

dir=sphinxm-rootdir

if [ ! -d $dir ]; then
  doconce sphinx_dir dirname=$dir author='me and you' \
          version=1.0 theme=default $files
  sh automake-sphinx.sh
else
  for file in $files; do
    cp $file.rst $dir
  done
  cd $dir
  make html
  cd ..
fi
</pre>
</blockquote>   <! -- end verbatim block -->
The autogenerated <tt>automake-sphinx.sh</tt> file (by <tt>doconce sphinx_dir</tt>)
is compatible with a master <tt>.rst</tt> file split into pieces as long as
the complete set of pieces in correct order is given to <tt>doconce sphinx_dir</tt>.
This set is the output of <tt>doconce split_rst</tt>, which we catch in a
variable <tt>files</tt> above.

<P>

<P>
<h3>Missing Features</h3>
<P>
Doconce does not aim to support sophisticated typesetting, simply because
sophisticated typesetting usually depend quite strongly on the particular
output format chosen. When a particular feature needed is not supported
by Doconce, it is recommended to hardcode that feature for a particular
format and use the if-else construction of the preprocessor. For example,
if a sophisticated table is desired in LaTeX output, test on the
<tt>FORMAT</tt> variable (<tt>#if FORMAT == "latex"</tt>) in the Doconce code and
insert the table in LaTeX format. The <tt>else</tt> or <tt>elif</tt> branches may
have the table in other formats or a simplified version in the Doconce
table format. Similarly, if certain adjustments are needed, like
pagebreaks in LaTeX, hardcode that in the Doconce format (and recall
that this is really LaTeX dependent - pagebreaks are not
relevant HTML formats).

<P>
Instead of inserting special code in the Doconce document, one can
alternatively script editing of the output from Doconce. That is,
we develop a Python or Bash script that runs the translation of
a Doconce document to a ready docoment in another format. Inside this
script, we may edit and fine-tune the output from Doconce.

<P>
As an example, say you want a table of contents in the LaTeX output
(Doconce does not support table of contents). By inserting a
recognizable comment in the Doconce source, say
<blockquote>    <!-- begin verbatim block  -->
<pre>
# table of contents
</pre>
</blockquote>   <! -- end verbatim block -->
we can use this comment to edit the LaTeX file. First, we run
Doconce <tt>doconce format latex mydoc</tt> to produce <tt>mydoc.p.tex</tt>. Then
we use the <tt>doconce replace</tt> and <tt>doconce subst</tt> commands to
replace the comment by the comment plus the table of contents command,
or just the latter:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Terminal&gt; doconce replace '% table of contents'
          '\tableofcontents' mydoc.p.tex
</pre>
</blockquote>   <! -- end verbatim block -->
The <tt>doconce replace from_text to_text filename</tt> command performs a
character-by-character replacement (using the <tt>replace</tt> method in
string objects in Python). If we want to preserve the comment and add
a new line with <tt>\tableofcontents</tt>, we should use <tt>doconce subst</tt>,
which applies regular expressions for substitutions and thereby
understands the newline character:
<blockquote>    <!-- begin verbatim block  -->
<pre>
Terminal&gt; doconce subst '% table of contents' \
          '% table of contents\n\\tableofcontents' mydoc.p.tex
</pre>
</blockquote>   <! -- end verbatim block -->
Note the double backshlash in front of the <tt>t</tt> character: without it we
would get a tab and no backslash.
The <tt>doconce subst</tt> is a powerful way to automatically edit the output
from Doconce and fine-tune a LaTeX document. Use of comment lines to
identify portions of the file to be edited is a smart idea.
Alternatively, the relevant LaTeX constructions can be inserted directly
in the Doconce file using if-else preprocessor directives.

<P>
<h3>Header and Footer</h3>
<P>
Some formats use a header and footer in the document. LaTeX and
HTML are two examples of such formats. When the document is to be
included in another document (which is often the case with
Doconce-based documents), the header and footer are not wanted, while
these are needed (at least in a LaTeX context) if the document is
stand-alone. We have introduce the convention that if <tt>TITLE:</tt> or
<tt>#TITLE:</tt> is found at the beginning of the line (i.e., the document
has, or has an intention have, a title), the header and footer
are included, otherwise not.

<P>

<P>
<h3>Emacs Doconce Formatter</h3>
<P>
The file <tt>misc/.doconce-mode.el</tt> in the Doconce source distribution
gives a "Doconce Editing Mode" in Emacs. The file is a rough edit of
the reST Editing Mode for Emacs. Some Doconce features are recognized,
but far from all, and sometimes portions of Doconce text just appear
as ordinary text.

<P>
Here is how to get the Doconce Editing Mode in Emacs.

<P>
<b>Step 1.</b> Download the Doconce tarball from <tt>code.google.com/p/doconce</tt>,
pack it out and go to the root directory.

<P>
<b>Step 2.</b> Copy the <tt>doconce-mode.el</tt> file to the home directory:
<blockquote>    <!-- begin verbatim block  -->
<pre>
cp misc/.doconce-mode.el $HOME
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<b>Step 3.</b> Add these lines to <tt>$HOME/.emacs</tt>:
<blockquote>    <!-- begin verbatim block  -->
<pre>
(load-file "~/hg/.doconce-mode.el")
(setq auto-mode-alist(cons '("\\.do\\.txt$" . doconce-mode) auto-mode-alist))
</pre>
</blockquote>   <! -- end verbatim block -->
Emacs will now recognize files with extension <tt>.do.txt</tt> and enter
the Doconce Editing Mode.

<P>

<P>
<h2>Troubleshooting</h2>
<P>
<h3>Disclaimer</h3>
<P>
Doconce has some support for syntax checking.  If you encounter Python
errors while running <tt>doconce format</tt>, the reason for the error is
most likely a syntax problem in your Doconce source file. You have to
track down this syntax problem yourself.

<P>
However, the problem may well be a bug in Doconce. The Doconce
software is incomplete, and many special cases of syntax are not yet
discovered to give problems. Such special cases are also seldom easy to
fix, so one important way of "debugging" Doconce is simply to change
the formatting so that Doconce treats it properly. Doconce is very much
based on regular expressions, which are known to be non-trivial to
debug years after they are created. The main developer of Doconce has
hardly any time to work on debugging the code, but the software works
well for his diverse applications of it.

<P>

<P>
<h3>General Problems</h3>
<P>
<h4>Something goes wrong in the preprocessing step</h4>
<P>
Doconce automatically removes the file <tt>__tmp.do.txt</tt>, which is the
resulting of the preprocessing stge and the file to examine if
something goes wrong in this stage (i.e., when <tt>mako</tt> and/or
<tt>preprocess</tt> is run). Add the <tt>--debug</tt> flag at the end of the
<tt>doconce</tt> command to (both make a debug file and) avoid that
<tt>__tmp.do.txt</tt> is deleted.

<P>
<h4>Figure captions are incomplete</h4>
<P>
If only the first part of a figure caption in the Doconce file is seen
in the target output format, the reason is usually that the caption
occupies multiple lines in the Doconce file. The figure caption must
be written as <em>one line</em>, at the same line as the FIGURE keyword.

<P>
<h4>Preprocessor directives do not work</h4>
<P>
Make sure the preprocessor instructions, in Preprocess or Mako, have
correct syntax. Also make sure that you do not mix Preprocess and Mako
instructions. Doconce will then only run Preprocess.

<P>
<h4>Problems with boldface and emphasize</h4>
<P>
Two boldface or emphasize expressions after each other are not rendered
correctly. Merge them into one common expression.

<P>
<h4>Links to local directories do not work</h4>
<P>
Links of the type
<blockquote>    <!-- begin verbatim block  -->
<pre>
see the "examples directory": "src/examples"
</pre>
</blockquote>   <! -- end verbatim block -->
do not work well. You need to link to a specific HTML file:
<blockquote>    <!-- begin verbatim block  -->
<pre>
see the "examples directory": "src/examples/index.html"
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h4>Links are not typeset correctly</h4>
<P>
Not all formats will allow formatting of the links. Verbatim words
in links are allowed if the whole link is typeset in verbatim:
<blockquote>    <!-- begin verbatim block  -->
<pre>
see the directory "`examples`": "src/examples/index.html".
</pre>
</blockquote>   <! -- end verbatim block -->
However, the following will not be typeset correctly:
<blockquote>    <!-- begin verbatim block  -->
<pre>
see the "`examples` directory": "src/examples/index.html"
</pre>
</blockquote>   <! -- end verbatim block -->
The back-ticks must be removed, or the text can be reformulated as
in the line above it.

<P>

<P>
<h4>Inline verbatim code is not detected</h4>
<P>
Make sure there is a space before the first back-tick.

<P>
<h4>Strange non-English characters</h4>
<P>
Check the encoding of the <tt>.do.txt</tt> file with the Unix <tt>file</tt> command
or with
<blockquote>    <!-- begin verbatim block  -->
<pre>
Unix&gt; doconce guess_encoding myfile.do.txt
</pre>
</blockquote>   <! -- end verbatim block -->
If the encoding is utf-8, convert to latin-1 using either of
the Unix commands
<blockquote>    <!-- begin verbatim block  -->
<pre>
Unix&gt; doconce change_encoding utf-8 LATIN1 myfile.do.txt

Unix&gt; iconv -f utf-8 -t LATIN1 myfile.do.txt --output newfile
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
<h4>Wrong Norwegian charcters</h4>
<P>
When Doconce documents have characters not in the standard ASCII set,
the format of the file must be LATIN1 and not UTF-8. See
the section "Strange non-English characters" above for how to
run <tt>doconce change_encoding</tt> to change the encoding of the Doconce file.

<P>
<h4>Inline verbatim text is not formatted correctly</h4>
<P>
Make sure there is whitespace surrounding the text in back-ticks.

<P>
<h4>Too short underlining of reST headlines</h4>
<P>
This may happen if there is a paragraph heading without
proceeding text before some section heading.

<P>

<P>
<h4>Found !bt but no tex blocks extracted (BUG)</h4>
<P>
This message points to a bug, but has been resolved by removing blank lines
between the text and the first <tt>!bt</tt> (inserting the blanks again did not
trigger the error message again...).

<P>
<h3>Problems with code or Tex Blocks</h3>
<P>
<h4>Code or math block errors in reST</h4>
<P>
First note that a code or math block must come after some plain
sentence (at least for successful output in reST), not directly
after a section/paragraph heading, table, comment, figure, or
movie, because the code or math block is indented and then become
parts of such constructions. Either the block becomes invisible or
error messages are issued.

<P>
Sometimes reST reports an "Unexpected indentation" at the beginning of
a code block. If you see a <tt>!bc</tt>, which should have been removed when
running <tt>doconce format sphinx</tt>, it is usually an error in the Doconce
source, or a problem with the rst/sphinx translator.  Check if the
line before the code block ends in one colon (not two!), a question
mark, an exclamation mark, a comma, a period, or just a newline/space
after text. If not, make sure that the ending is among the
mentioned. Then <tt>!bc</tt> will most likely be replaced and a double colon
at the preceding line will appear (which is the right way in reST to
indicate a verbatim block of text).

<P>
<h4>Strange errors around code or TeX blocks in reST</h4>
<P>
If <tt>idx</tt> commands for defining indices are placed inside paragraphs,
and especially right before a code block, the reST translator
(rst and sphinx formats) may get confused and produce strange
code blocks that cause errors when the reST text is transformed to
other formats. The remedy is to define items for the index outside
paragraphs.

<P>
<h4>Something is wrong with a verbatim code block</h4>
<P>
Check first that there is a "normal" sentence right before
the block (this is important for reST and similar
"ASCII-close" formats).

<P>
<h4>Code/TeX block is not shown in reST format</h4>
<P>
A comment right before a code or tex block will treat the whole
block also as a comment. It is important that there is normal
running text right before <tt>!bt</tt> and <tt>!bc</tt> environments.

<P>
<h4>Verbatim code blocks inside lists look ugly</h4>
<P>
Read the the section <a href="#sec:verbatim:blocks">Blocks of Verbatim Computer Code</a> above.  Start the
<tt>!bc</tt> and <tt>!ec</tt> tags in column 1 of the file, and be careful with
indenting the surrounding plain text of the list item correctly. If
you cannot resolve the problem this way, get rid of the list and use
paragraph headings instead. In fact, that is what is recommended:
avoid verbatim code blocks inside lists (it makes life easier).

<P>
<h4>LaTeX code blocks inside lists look ugly</h4>
<P>
Same solution as for computer code blocks as described in the
previous paragraph. Make sure the <tt>!bt</tt> and <tt>!et</tt> tags are in column 1
and that the rest of the non-LaTeX surrounding text is correctly indented.
Using paragraphs instead of list items is a good idea also here.

<P>

<P>
<h3>Problems with reST/Sphinx Output</h3>
<P>
<h4>Lists do not appear in .rst files</h4>
<P>
Check if you have a comment right above the list. That comment
will include the list if the list is indentend. Remove the comment.

<P>
<h4>Error message "Undefined substitution..." from reST</h4>
<P>
This may happen if there is much inline math in the text. reST cannot
understand inline LaTeX commands and interprets them as illegal code.
Just ignore these error messages.

<P>
<h4>Warning about duplicate link names</h4>
<P>
Link names should be unique, but if (e.g.) "file" is used as link text
several places in a reST file, the links still work. The warning can
therefore be ignorned.

<P>
<h4>Inconsistent headings in reST</h4>
<P>
The <tt>rst2*.py</tt> and Sphinx converters abort if the headers of sections
are not consistent, i.e., a subsection must come under a section,
and a subsubsection must come under a subsection (you cannot have
a subsubsection directly under a section). Search for <tt>===</tt>,
count the number of equality signs (or underscores if you use that)
and make sure they decrease by two every time a lower level is encountered.

<P>
<h4>No code environment appears before "bc ipy" blocks</h4>
<P>
The <tt>!bc ipy</tt> directive behaves this way for <tt>sphinx</tt> output because
interactive sessions are automatically handled. If this is not
appropriate, shift to <tt>!bc cod</tt> or another specification of the
verbatim environment.

<P>
<h3>Problems with LaTeX Output</h3>
<P>
<h4>Error when running latex: You must 'pygmentize' installed</h4>
<P>
This points to the used of the Minted style for typesetting verbatim
code. You need to run
<blockquote>    <!-- begin verbatim block   sys-->
<pre>
Terminal&gt; latex -shell-escape file
</pre>
</blockquote>   <! -- end verbatim block -->
if you have run <tt>ptex2tex</tt> with the <tt>-DMINTED</tt> option and turned on
the use of the Minted style (and therefore <tt>pygmentize</tt> program).

<P>
<h4>The LaTeX file does not compile</h4>
<P>
If the problem is undefined control sequence involving
<blockquote>    <!-- begin verbatim block  -->
<pre>
\code{...}
</pre>
</blockquote>   <! -- end verbatim block -->
the cause is usually a verbatim inline text (in back-ticks in the
Doconce file) spans more than one line. Make sure, in the Doconce source,
that all inline verbatim text appears on the same line.

<P>
<h4>Inline verbatim gives error</h4>
<P>
Check if the inline verbatim contains typical LaTeX commands, e.g.,
<blockquote>    <!-- begin verbatim block  -->
<pre>
some text with `\usepackage{mypack}` is difficult because
ptex2tex will replace this by \code{\usepackage{mypack}} and
then replace this by
{\fontsize{10pt}{10pt}\verb!\usepackage{mypack!}}
which is wrong because ptex2tex applies regex that don't
capture the second }
</pre>
</blockquote>   <! -- end verbatim block -->
The remedy is to place verbatim LaTeX commands in verbatim
blocks - that is safe.

<P>
<!-- Could have doconce configure file where inline verbatim is -->
<!-- configured to be \fontsize... directly, not via ptex2tex \code{}. -->

<P>

<P>
<h4>Errors in figure captions</h4>
<P>
Such errors typically arise from unbalanced curly braces, or dollar signs
around math, and similar LaTeX syntax errors.

<P>
(Note that verbatim font is likely to cause trouble inside figure captions,
but Doconce will automatically replace verbatim text in back-ticks by
a proper <tt>texttt</tt> command (since verbatim font constructions does not work
inside figure captions) and precede underscores by backslash.)

<P>
<h4>Chapters are ignored</h4>
<P>
The default LaTeX style is "article". If you chapters in the Doconce file,
you need to run <tt>ptex2tex</tt> with the option <tt>-DBOOK</tt> to set the LaTeX
documentstyle to "book".

<P>
<h4>I want to tune the top of the LaTeX file</h4>
<P>
The top of the LaTeX file, as generated by Doconce, is very simple.
If this LaTeX code is not sufficient for your needs, there are
two ways out of it:

<P>

<ol>
<li> Make a little Bash script that performs a series of
   <tt>doconce subst</tt> (regular expressions) or <tt>doconce replace</tt> (regular text)
   substitutions to change the text automatically (you probably have to
   repeat these edits so automating them is a good idea).
<li> Place the title, author(s), and date of the Doconce file in a separate
   file and use the preprocessor to include the rest. The rest is then
   one or more Doconce files without title, author(s), and date. This
   means that the <tt>doconce format latex</tt> command does not generate
   the LaTeX intro (preamble) and outro, just the core text, for these
   files.
   Make a new file by hand with the appropriate LaTeX intro and outro
   text and include the various text pieces in this file.
   To make the LaTeX document, you compile all Doconce files
   into LaTeX code, except the "top" Doconce file that includes the
   others. That file is not used for LaTeX output, but
   replaced by the hand-written LaTeX "top" file.
</ol>
<h3>Problems with gwiki Output</h3>
<P>
<h4>Strange nested lists in gwiki</h4>
<P>
Doconce cannot handle nested lists correctly in the gwiki format.
Use nonnested lists or edit the <tt>.gwiki</tt> file directly.

<P>
<h4>Lists in gwiki look ugly in the gwiki source</h4>
<P>
Because the Google Code wiki format requires all text of a list item to
be on one line, Doconce simply concatenates lines in that format,
and because of the indentation in the original Doconce text, the gwiki
output looks somewhat ugly. The good thing is that this gwiki source
is seldom to be looked at - it is the Doconce source that one edits
further.

<P>
<h3>Debugging</h3>
<P>
Given a problem, extract a small portion of text surrounding the
problematic area and debug that small piece of text. Doconce does a
series of transformations of the text. The effect of each of these
transformation steps are dumped to a logfile, named
<tt>_doconce_debugging.log</tt>, if the to <tt>doconce format</tt> after the filename
is <tt>debug</tt>. The logfile is inteded for the developers of Doconce, but
may still give some idea of what is wrong.  The section "Basic Parsing
Ideas" explains how the Doconce text is transformed into a specific
format, and you need to know these steps to make use of the logfile.

<P>

<P>

<P>
<h2>Basic Parsing Ideas</h2>
<P>
<!-- avoid list here since we have code in between (never a good idea) -->

<P>
The (parts of) files with computer code to be directly included in
the document are first copied into verbatim blocks.

<P>
All verbatim and TeX blocks are removed and stored elsewhere
to ensure that no formatting rules are not applied to these blocks.

<P>
The text is examined line by line for typesetting of lists, as well as
handling of blank lines and comment lines.
List parsing needs some awareness of the context.
Each line is interpreted by a regular expression

<P>
<blockquote>    <!-- begin verbatim block  -->
<pre>
(?P&lt;indent&gt; *(?P&lt;listtype&gt;[*o-] )? *)(?P&lt;keyword&gt;[^:]+?:)?(?P&lt;text&gt;.*)\s?
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
That is, a possible indent (which we measure), an optional list
item identifier, optional space, optional words ended by colon,
and optional text. All lines are of this form. However, some
ordinary (non-list) lines may contain a colon, and then the keyword
and text group must be added to get the line contents. Otherwise,
the text group will be the line.

<P>
When lists are typeset, the text is examined for sections, paragraphs,
title, author, date, plus all the inline tags for emphasized, boldface,
and verbatim text. Plain subsitutions based on regular expressions
are used for this purpose.

<P>
The final step is to insert the code and TeX blocks again (these should
be untouched and are therefore left out of the previous parsing).

<P>
It is important to keep the Doconce format and parsing simple.  When a
new format is needed and this format is not obtained by a simple edit
of the definition of existing formats, it might be better to convert
the document to reST and then to XML, parse the XML and
write out in the new format.  When the Doconce format is not
sufficient to getting the layout you want, it is suggested to filter
the document to another, more complex format, say reST or
LaTeX, and work further on the document in this format.

<P>

<P>
<h3>A Glimpse of How to Write a New Translator</h3>
<P>
This is the HTML-specific part of the
source code of the HTML translator:
(note that in HTML one of the the less-than and greater-than signs
in a link come up wrong because of the simple regex that is used
to substitute these pair of signs by special HTML expressions)

<P>

<P>
<blockquote>    <!-- begin verbatim block  -->
<pre>
FILENAME_EXTENSION['html'] = '.html'  # output file extension
BLANKLINE['html'] = '&lt;p&gt;\n'           # blank input line =&gt; new paragraph
INLINE_TAGS_SUBST['html'] = {         # from inline tags to HTML tags
    # keep math as is:
    'math': None,  # indicates no substitution
    'emphasize':     r'\g&lt;begin&gt;&lt;em&gt;\g&lt;subst&gt;&lt;/em&gt;\g&lt;end&gt;',
    'bold':          r'\g&lt;begin&gt;&lt;b&gt;\g&lt;subst&gt;&lt;/b&gt;\g&lt;end&gt;',
    'verbatim':      r'\g&lt;begin&gt;&lt;tt&gt;\g&lt;subst&gt;&lt;/tt&gt;\g&lt;end&gt;',
    'URL':           r'\g&lt;begin&gt;&lt;a href="\g&lt;url&gt;"&gt;\g&lt;link&gt;&lt;/a&gt;',
    'section':       r'&lt;h1&gt;\g&lt;subst&gt;&lt;/h1&gt;',
    'subsection':    r'&lt;h3&gt;\g&lt;subst&gt;&lt;/h3&gt;',
    'subsubsection': r'&lt;h5&gt;\g&lt;subst&gt;&lt;/h5&gt;',
    'paragraph':     r'&lt;b&gt;\g&lt;subst&gt;&lt;/b&gt;. ',
    'title':         r'&lt;title&gt;\g&lt;subst&gt;&lt;/title&gt;\n&lt;center&gt;&lt;h1&gt;\g&lt;subst&gt;&lt;/h1&gt;&lt;/center&gt;',
    'date':          r'&lt;center&gt;&lt;h3&gt;\g&lt;subst&gt;&lt;/h3&gt;&lt;/center&gt;',
    'author':        r'&lt;center&gt;&lt;h3&gt;\g&lt;subst&gt;&lt;/h3&gt;&lt;/center&gt;',
    }

# how to replace code and latex blocks by html (&lt;pre&gt;) environment:
def html_code(filestr):
    c = re.compile(r'^!bc(.*?)\n', re.MULTILINE)
    filestr = c.sub(r'&lt;!-- BEGIN VERBATIM BLOCK \g&lt;1&gt;--&gt;\n&lt;pre&gt;\n', filestr)
    filestr = re.sub(r'!ec\n',
                     r'&lt;/pre&gt;\n&lt;! -- END VERBATIM BLOCK --&gt;\n', filestr)
    c = re.compile(r'^!bt\n', re.MULTILINE)
    filestr = c.sub(r'&lt;pre&gt;\n', filestr)
    filestr = re.sub(r'!et\n', r'&lt;/pre&gt;\n', filestr)
    return filestr
CODE['html'] = html_code

# how to typeset lists and their items in html:
LIST['html'] = {
    'itemize':
    {'begin': '\n&lt;ul&gt;\n', 'item': '&lt;li&gt;', 'end': '&lt;/ul&gt;\n\n'},
    'enumerate':
    {'begin': '\n&lt;ol&gt;\n', 'item': '&lt;li&gt;', 'end': '&lt;/ol&gt;\n\n'},
    'description':
    {'begin': '\n&lt;dl&gt;\n', 'item': '&lt;dt&gt;%s&lt;dd&gt;', 'end': '&lt;/dl&gt;\n\n'},
    }

# how to type set description lists for function arguments, return
# values, and module/class variables:
ARGLIST['html'] = {
    'parameter': '&lt;b&gt;argument&lt;/b&gt;',
    'keyword': '&lt;b&gt;keyword argument&lt;/b&gt;',
    'return': '&lt;b&gt;return value(s)&lt;/b&gt;',
    'instance variable': '&lt;b&gt;instance variable&lt;/b&gt;',
    'class variable': '&lt;b&gt;class variable&lt;/b&gt;',
    'module variable': '&lt;b&gt;module variable&lt;/b&gt;',
    }

# document start:
INTRO['html'] = """
&lt;html&gt;
&lt;body bgcolor="white"&gt;
"""
# document ending:
OUTRO['html'] = """
&lt;/body&gt;
&lt;/html&gt;
"""
</pre>
</blockquote>   <! -- end verbatim block -->

<P>

<P>
<h3>Typesetting of Function Arguments, Return Values, and Variables</h3>
<P>
As part of comments (or doc strings) in computer code one often wishes
to explain what a function takes of arguments and what the return
values are. Similarly, it is desired to document class, instance, and
module variables.  Such arguments/variables can be typeset as
description lists of the form listed below and <em>placed at the end of
the doc string</em>. Note that <tt>argument</tt>, <tt>keyword argument</tt>, <tt>return</tt>,
<tt>instance variable</tt>, <tt>class variable</tt>, and <tt>module variable</tt> are the
only legal keywords (descriptions) for the description list in this
context.  If the output format is Epytext (Epydoc) or Sphinx, such lists of
arguments and variables are nicely formatted.

<P>
<blockquote>    <!-- begin verbatim block  -->
<pre>
    - argument x: x value (float),
      which must be a positive number.
    - keyword argument tolerance: tolerance (float) for stopping
      the iterations.
    - return: the root of the equation (float), if found, otherwise None.
    - instance variable eta: surface elevation (array).
    - class variable items: the total number of MyClass objects (int).
    - module variable debug: True: debug mode is on; False: no debugging
      (bool variable).
</pre>
</blockquote>   <! -- end verbatim block -->

<P>
The result depends on the output format: all formats except Epytext
and Sphinx just typeset the list as a list with keywords.

<P>

<dl>
    <dt><b>module variable</b> x:<dd> 
      x value (float),
      which must be a positive number.
    <dt><b>module variable</b> tolerance:<dd> 
      tolerance (float) for stopping
      the iterations.
</dl>

<h1>Bibliography</h1>

<P>
<ol>
  <p><li><a name="Python:Primer:09">  H. P. Langtangen. <em>A Primer on Scientific Programming with Python</em>. Springer, 2009.
  <p><li><a name="Osnes:98">  H. Osnes and H. P. Langtangen. An efficient probabilistic finite element method for stochastic  groundwater flow. <em>Advances in Water Resources</em>, vol 22, 185-195, 1998.
</ol>

<P>

<P>

</body>
</html>
    
************** File: manual.p.tex *****************
%%
%% Automatically generated ptex2tex (extended LaTeX) file
%% from Doconce source
%% http://code.google.com/p/doconce/
%%

% #ifdef BOOK
\documentclass{book}
% #else
\documentclass{article}
% #endif

\usepackage{relsize,epsfig,makeidx,amsmath,amsfonts}
\usepackage[latin1]{inputenc}
\usepackage{ptex2tex,subfigure}
% #ifdef MOVIE15
\usepackage{movie15}
% #endif
% #ifdef MINTED
\usepackage{minted}  % requires latex -shell-escape (for Minted_* ptex2tex envirs)
% #endif

% #ifdef HELVETICA
% Set helvetica as the default font family:
\RequirePackage{helvet}
\renewcommand\familydefault{phv}
% #endif

\usepackage[%
colorlinks=true,
linkcolor=blue,
citecolor=black,
filecolor=blue,
urlcolor=blue]{hyperref}
%\hyperbaseurl{}   % hyperlinks are relative to this root

\newcommand{\inlinecomment}[2]{  ({\bf #1}: \emph{#2})  }
%\newcommand{\inlinecomment}[2]{}  % turn off inline comments

\makeindex

\begin{document}

\input{newcommands_replace}
\input{newcommands_keep}


% #ifndef LATEX_HEADING
% #define LATEX_HEADING
% #endif

% ----------------- Title -------------------------
% #if LATEX_HEADING == "traditional"

\title{Doconce Description}

% #elif LATEX_HEADING == "titlepage"

\thispagestyle{empty}
\hbox{\ \ }
\vfill
\begin{center}
{\huge{\bfseries{Doconce Description}}}

% #else

\begin{center}
{\LARGE\bf Doconce Description}
\end{center}

% #endif



% ----------------- Author(s) -------------------------
% #if LATEX_HEADING == "traditional"
\author{Hans Petter Langtangen\footnote{Simula Research Laboratory and University of Oslo.}}

% #elif LATEX_HEADING == "titlepage"
\vspace{1.3cm}

{\Large\textsf{Hans Petter Langtangen${}^{1, 2}$}}\\ [3mm]

\ \\ [2mm]

{\large\textsf{${}^1$Simula Research Laboratory} \\ [1.5mm]}
{\large\textsf{${}^2$University of Oslo} \\ [1.5mm]}

% #else

\begin{center}
{\bf Hans Petter Langtangen${}^{1, 2}$} \\ [0mm]
\end{center}

\begin{center}
% List of all institutions:
\centerline{{\small ${}^1$Simula Research Laboratory}}
\centerline{{\small ${}^2$University of Oslo}}
\end{center}
% #endif
% ----------------- End of author(s) -------------------------



% ----------------- Date -------------------------

% #if LATEX_HEADING == "traditional"

\date{Jan 32, 2100}
\maketitle

% #elif LATEX_HEADING == "titlepage"

\ \\ [10mm]
{\large\textsf{Jan 32, 2100}}

\end{center}
\vfill
\clearpage

% #else

\begin{center}
Jan 32, 2100
\end{center}

% #endif

% lines beginning with # are comment lines


\section{What Is Doconce?}

\label{what:is:doconce}
\index{doconce!short explanation}

Doconce is two things:

\begin{enumerate}
 \item Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, {\LaTeX}, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via \code{rst2*} programs) go to XML, HTML,
    {\LaTeX}, PDF, OpenOffice, and from the latter (via \code{unoconv}) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, {\LaTeX}, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 \item Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".
\end{enumerate}

\noindent
Here are some Doconce features:

\begin{itemize}
  \item Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    {\LaTeX} and HTML.

  \item Doconce can be converted to plain \emph{untagged} text,
    often desirable for computer programs and email.

  \item Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  \item Doconce has full support for {\LaTeX} math and integrates well
    with big {\LaTeX} projects (books).

  \item Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, {\LaTeX}, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  \item Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in {\LaTeX}, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.
\end{itemize}

\noindent
Doconce was particularly written for the following sample applications:

\begin{itemize}
  \item Large books written in {\LaTeX}, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  \item Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as {\LaTeX} integrated in, e.g., a thesis.

  \item Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.
\end{itemize}

\noindent
History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, {\LaTeX}, Sphinx, and similar
formats.

\subsection{Dependencies and Installation}

Doconce itself is pure Python code hosted at \href{{http://code.google.com/p/doconce}}{\nolinkurl{http://code.google.com/p/doconce}}.  Its installation from the
Mercurial (\code{hg}) source follows the standard procedure:
\bsys
# Doconce
hg clone https://doconce.googlecode.com/hg/ doconce
cd doconce
sudo python setup.py install
cd ..
\esys

If you make use of the \href{{http://code.google.com/p/preprocess}}{Preprocess}
preprocessor, this program must be installed:
\bsys
svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
cd preprocess
cd doconce
sudo python setup.py install
cd ..
\esys
A much more advanced alternative to Preprocess is
\href{{http://www.makotemplates.org}}{Mako}. Its installation is most
conveniently done by \code{pip},
\bsys
pip install Mako
\esys
This command requires \code{pip} to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by
\bsys
sudo apt-get install python-pip
\esys
Alternatively, one can install from the \code{pip} \href{{http://pypi.python.org/pypi/pip}}{source code}.

To make {\LaTeX}
documents (without going through the reStructuredText format) you
need \href{{http://code.google.com/p/ptex2tex}}{ptex2tex}, which is
installed by
\bsys
svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
cd ptex2tex
sudo python setup.py install
cd latex
sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
cd ../..
\esys
As seen, \code{cp2texmf.sh} copies some special stylefiles that
that \code{ptex2tex} potentially makes use of. Some more standard stylefiles
are also needed. These are installed by
\bsys
sudo apt-get install texlive-latex-extra
\esys
on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the \code{~/texmf/tex/latex/misc} directory).

The \emph{minted} {\LaTeX} style is offered by \code{ptex2tex} and popular among
users. This style requires the package \href{{http://pygments.org}}{Pygments}:
\bsys
hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
cd pygments
sudo python setup.py install
\esys
If you use the minted style, you have to enable it by running
\code{ptex2tex -DMINTED} and then \code{latex -shell-escape}, see
the Section~\ref{doconce2formats}.

For \code{rst} output and further transformation to {\LaTeX}, HTML, XML,
OpenOffice, and so on, one needs \href{{http://docutils.sourceforge.net}}{docutils}.
The installation can be done by
\bsys
svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
cd docutils
sudo python setup.py install
cd ..
\esys
To use the OpenOffice suite you will typically on Debian systems install
\bsys
sudo apt-get install unovonv libreoffice libreoffice-dmaths
\esys

There is a possibility to create PDF files from reST documents
using ReportLab instead of {\LaTeX}. The enabling software is
\href{{http://code.google.com/p/rst2pdf}}{rst2pdf}. Either download the tarball
or clone the svn repository, go to the \code{rst2pdf} directory and
run \code{sudo python setup.py install}.


Output to \code{sphinx} requires of course \href{{http://sphinx.pocoo.org}}{Sphinx},
installed by
\bsys
hg clone https://bitbucket.org/birkenfeld/sphinx
cd sphinx
sudo python setup.py install
cd ..
\esys

When the output format is \code{epydoc} one needs that program too, installed
by
\bsys
svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
cd epydoc
sudo make install
cd ..
\esys

Finally, translation to \code{pandoc} requires the
\href{{http://johnmacfarlane.net/pandoc/}}{Pandoc} program
(written in Haskell) to be installed.
\bsys
sudo apt-get install pandoc
\esys

\paragraph{Remark.}
Several of the packages above installed from source code
are also available in Debian-based system through the
\code{apt-get install} command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For \code{svn} directories, go to the directory,
run \code{svn update}, and then \code{sudo python setup.py install}. For
Mercurial (\code{hg}) directories, go to the directory, run
\code{hg pull; hg update}, and then \code{sudo python setup.py install}.
Doconce itself is frequently updated so these commands should be
run regularly.


% 
% Here are some comment lines that do not affect any formatting
% these lines are converted to comments in the output format.
% This may have some side effects, especially in rst and sphinx
% where lines following the comment may be taken as part of
% the comment if there are no blank lines after the comment.
% 
% One can use ## and the mako preprocessor to remove comments
% \emph{before} doconce sees the text. That can be useful when
% doconce comments interferes with formatting.
% The mako tool also supports <%doc> .. </%doc>
% 

\subsection{Demos}

\index{demos}

The current text is generated from a Doconce format stored in the
\bsys
docs/manual/manual.do.txt
\esys
file in the Doconce source code tree. We have made a
\href{{https://doconce.googlecode.com/hg/doc/demos/manual/index.html}}{demo web page}
where you can compare the Doconce source with the output in many
different formats: HTML, {\LaTeX}, plain text, etc.

The file \code{make.sh} in the same directory as the \code{manual.do.txt} file
(the current text) shows how to run \code{doconce format} on the
Doconce file to obtain documents in various formats.

Another demo is found in
\bsys
docs/tutorial/tutorial.do.txt
\esys
In the \code{tutorial} directory there is also a \code{make.sh} file producing a
lot of formats, with a corresponding
\href{{https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html}}{web demo}
of the results.

% Example on including another Doconce file:


\section{From Doconce to Other Formats}

\label{doconce2formats}

Transformation of a Doconce document \code{mydoc.do.txt} to various other
formats applies the script \code{doconce format}:
\bsys
Terminal> doconce format format mydoc.do.txt
\esys
or just
\bsys
Terminal> doconce format format mydoc
\esys
The \code{mako} or \code{preprocess} programs are always used to preprocess the
file first, and options to \code{mako} or \code{preprocess} can be added after the
filename. For example,
\bsys
Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako
\esys
The variable \code{FORMAT} is always defined as the current format when
running \code{preprocess}. That is, in the last example, \code{FORMAT} is
defined as \code{latex}. Inside the Doconce document one can then perform
format specific actions through tests like \code{#if FORMAT == "latex"}.

Inline comments in the text are removed from the output by
\bsys
Terminal> doconce format latex mydoc --skip_inline_comments
\esys
One can also remove all such comments from the original Doconce
file by running:
\bccq
Terminal> doconce remove_inline_comments mydoc
\eccq
This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.

\subsection{HTML}

Making an HTML version of a Doconce file \code{mydoc.do.txt}
is performed by
\bsys
Terminal> doconce format html mydoc
\esys
The resulting file \code{mydoc.html} can be loaded into any web browser for viewing.

\subsection{Pandoc}

Output in Pandoc's extended Markdown format results from
\bsys
Terminal> doconce format pandoc mydoc
\esys
The name of the output file is \code{mydoc.mkd}.
From this format one can go to numerous other formats:
\bsys
Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd
\esys
Pandoc supports \code{latex}, \code{html}, \code{odt} (OpenOffice), \code{docx} (Microsoft
Word), \code{rtf}, \code{texinfo}, to mention some. The \code{-R} option makes
Pandoc pass raw HTML or {\LaTeX} to the output format instead of ignoring it.
See the \href{{http://johnmacfarlane.net/pandoc/README.html}}{Pandoc documentation}
for the many features of the \code{pandoc} program.

Pandoc is useful to go from {\LaTeX} mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
\code{doconce format pandoc} and then translating using \code{pandoc}, or
\code{doconce format latex}, and then going from {\LaTeX} to the desired format
using \code{pandoc}.
Here is an example on the latter strategy:
\bsys
Terminal> doconce format latex mydoc
Terminal> doconce ptex2tex mydoc
Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex
\esys
When we go through \code{pandoc}, only single equations or \code{align*}
environments are well understood.

Quite some \code{doconce replace} and \code{doconce subst} edits might be needed
on the \code{.mkd} or \code{.tex} files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via {\LaTeX}.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax:
\bsys
Terminal> doconce format pandoc mydoc
Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd
\esys
The \code{-s} option adds a proper header and footer to the \code{mydoc.html} file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.

\subsection{{\LaTeX}}

Making a {\LaTeX} file \code{mydoc.tex} from \code{mydoc.do.txt} is done in two steps:
% Note: putting code blocks inside a list is not successful in many
% formats - the text may be messed up. A better choice is a paragraph
% environment, as used here.

\paragraph{Step 1.}
Filter the doconce text to a pre-LaTeX form \code{mydoc.p.tex} for
     \code{ptex2tex}:
\bsys
Terminal> doconce format latex mydoc
\esys
LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files \code{newcommands.tex}, \code{newcommands_keep.tex}, or
\code{newcommands_replace.tex} (see Section~\ref{newcommands}).
If these files are present, they are included in the {\LaTeX} document
so that your commands are defined.

\paragraph{Step 2.}
Run \code{ptex2tex} (if you have it) to make a standard {\LaTeX} file,
\bsys
Terminal> ptex2tex mydoc
\esys
In case you do not have \code{ptex2tex}, you may run a (very) simplified version:
\bsys
Terminal> doconce ptex2tex mydoc
\esys

Note that Doconce generates a \code{.p.tex} file with some preprocessor macros
that can be used to steer certain properties of the {\LaTeX} document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run
\bsys
Terminal> ptex2tex -DHELVETICA mydoc
\esys
The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard {\LaTeX} "maketitle" heading
is also available through
\bsys
Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc
\esys
A separate titlepage can be generate by
\bsys
Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc
\esys

The \code{ptex2tex} tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in {\LaTeX}
documents. After any \code{!bc} command in the Doconce source you can
insert verbatim block styles as defined in your \code{.ptex2tex.cfg}
file, e.g., \code{!bc cod} for a code snippet, where \code{cod} is set to
a certain environment in \code{.ptex2tex.cfg} (e.g., \code{CodeIntended}).
There are about 40 styles to choose from.

Also the \code{doconce ptex2tex} command supports preprocessor directives
for processing the \code{.p.tex} file. The command allows specifications
of code environments as well. Here is an example:
\bsys
Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
          cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
          fpro=minted fcod=minted sys=verbatim
\esys
Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
\code{verbatim} above, which implies \code{\begin{verbatim}} and \code{\end{verbatim}}).
The value \code{minted} can be used for code environments where the
language is specified, as in \code{fpro}, where \code{minted} implies
\code{\begin{python}{fortran}}. There is a similar support for \code{ans}:
\code{cppcod=ans} imples \code{\begin{c++}} and \code{\end{c++}} using the
\code{anslistings} package.

\paragraph{Step 2b (optional).}
Edit the \code{mydoc.tex} file to your needs.
For example, you may want to substitute \code{section} by \code{section*} to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the \code{doconce replace} and \code{doconce subst}
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples:
\bsys
Terminal> doconce replace 'section{' 'section*{' mydoc.tex
Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
          'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex
\esys
A lot of tailored fixes to the {\LaTeX} document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the {\LaTeX} file.

\paragraph{Step 3.}
Compile \code{mydoc.tex}
and create the PDF file:
\bsys
Terminal> latex mydoc
Terminal> latex mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex mydoc
Terminal> dvipdf mydoc
\esys
If one wishes to use the \code{Minted_Python}, \code{Minted_Cpp}, etc.,
environments in \code{ptex2tex} for typesetting code (specified, e.g., in
the \code{*pro} and \code{*cod} environments in \code{.ptex2tex.cfg} or
\code{$HOME/.ptex2tex.cfg}), the \code{minted} {\LaTeX} package is needed.  This
package is included by running \code{doconce format} with the \code{-DMINTED}
option:
\bsys
Terminal> ptex2tex -DMINTED mydoc
\esys
In this case, \code{latex} must be run with the
\code{-shell-escape} option:
\bsys
Terminal> latex -shell-escape mydoc
Terminal> latex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> latex -shell-escape mydoc
Terminal> dvipdf mydoc
\esys

\subsection{PDFLaTeX}

Running \code{pdflatex} instead of \code{latex} follows almost the same steps,
but the start is
\bsys
Terminal> doconce format latex mydoc
\esys
Then \code{ptex2tex} is run as explained above, and finally
\bsys
Terminal> pdflatex -shell-escape mydoc
Terminal> makeindex mydoc   # if index
Terminal> bibitem mydoc     # if bibliography
Terminal> pdflatex -shell-escape mydoc
\esys

\subsection{Plain ASCII Text}

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code:
\bsys
Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt
\esys

\subsection{reStructuredText}

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file \code{mydoc.rst}:
\bsys
Terminal> doconce format rst mydoc.do.txt
\esys
We may now produce various other formats:
\bsys
Terminal> rst2html.py  mydoc.rst > mydoc.html # html
Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice
\esys

The OpenOffice file \code{mydoc.odt} can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program \code{unovonv}
to convert between the many formats OpenOffice supports \emph{on the command line}.
Run
\bsys
Terminal> unoconv --show
\esys
to see all the formats that are supported.
For example, the following commands take
\code{mydoc.odt} to Microsoft Office Open XML format,
classic MS Word format, and PDF:
\bsys
Terminal> unoconv -f ooxml mydoc.odt
Terminal> unoconv -f doc mydoc.odt
Terminal> unoconv -f pdf mydoc.odt
\esys

\paragraph{Remark about Mathematical Typesetting.}
At the time of this writing, there is no easy way to go from Doconce
and {\LaTeX} mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by \code{latex} as
output and to a wide extent also supported by the \code{sphinx} output format.
Some links for going from {\LaTeX} to Word are listed below.

\begin{itemize}
 \item \href{{http://ubuntuforums.org/showthread.php?t=1033441}}{\nolinkurl{http://ubuntuforums.org/showthread.php?t=1033441}}

 \item \href{{http://tug.org/utilities/texconv/textopc.html}}{\nolinkurl{http://tug.org/utilities/texconv/textopc.html}}

 \item \href{{http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html}}{\nolinkurl{http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html}}
\end{itemize}

\noindent

\subsection{Sphinx}

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the \code{doconce sphinx_dir} command:
\bsys
Terminal> doconce sphinx_dir author="authors' names" \
          title="some title" version=1.0 dirname=sphinxdir \
          theme=mytheme file1 file2 file3 ...
\esys
The keywords \code{author}, \code{title}, and \code{version} are used in the headings
of the Sphinx document. By default, \code{version} is 1.0 and the script
will try to deduce authors and title from the doconce files \code{file1},
\code{file2}, etc. that together represent the whole document. Note that
none of the individual Doconce files \code{file1}, \code{file2}, etc. should
include the rest as their union makes up the whole document.
The default value of \code{dirname} is \code{sphinx-rootdir}. The \code{theme}
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is \code{'default'}).

With a single-file document in \code{mydoc.do.txt} one often just runs
\bsys
Terminal> doconce sphinx_dir mydoc
\esys
and then an appropriate Sphinx directory \code{sphinx-rootdir} is made with
relevant files.

The \code{doconce sphinx_dir} command generates a script
\code{automake-sphinx.py} for compiling the Sphinx document into an HTML
document.  One can either run \code{automake-sphinx.py} or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te \code{doconce sphinx_dir} script copies directories named \code{figs} or \code{figures}
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, \code{automake-sphinx.py} must be edited accordingly.
Links to local files (not \code{http:} or \code{file:} URLs) must be placed
in the \code{_static} subdirectory of the Sphinx directory. The
utility \code{doconce sphinxfix_localURLs} is run to check for local
links: for each such link, say \code{dir1/dir2/myfile.txt} it replaces
the link by \code{_static/myfile.txt} and copies \code{dir1/dir2/myfile.txt}
to a local \code{_static} directory (in the same directory as the
script is run). The user must copy all \code{_static/*} files to the
\code{_static} subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the \code{_static} subdirectory of the Sphinx directory.
It may be wise to place relevant files in a \code{_static} directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the \code{conf.py}
configuration file for Sphinx is edited accordingly, and a script
\code{make-themes.sh} can make HTML documents with one or more themes.
For example,
to realize the themes \code{fenics} and \code{pyramid}, one writes
\bsys
Terminal> ./make-themes.sh fenics pyramid
\esys
The resulting directories with HTML documents are \code{_build/html_fenics}
and \code{_build/html_pyramid}, respectively. Without arguments,
\code{make-themes.sh} makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file \code{mydoc.do.txt}.

\paragraph{Step 1.}
Translate Doconce into the Sphinx format:
\bsys
Terminal> doconce format sphinx mydoc
\esys

\paragraph{Step 2.}
Create a Sphinx root directory
either manually or by using the interactive \code{sphinx-quickstart}
program. Here is a scripted version of the steps with the latter:
\bsys
mkdir sphinx-rootdir
sphinx-quickstart <<EOF
sphinx-rootdir
n
_
Name of My Sphinx Document
Author
version
version
.rst
index
n
y
n
n
n
n
y
n
n
y
y
y
EOF
\esys
The autogenerated \code{conf.py} file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The \code{doconce sphinx_dir} generator makes an extended \code{conv.py}
file where, among other things, several useful Sphinx extensions
are included.


\paragraph{Step 3.}
Copy the \code{mydoc.rst} file to the Sphinx root directory:
\bsys
Terminal> cp mydoc.rst sphinx-rootdir
\esys
If you have figures in your document, the relative paths to those will
be invalid when you work with \code{mydoc.rst} in the \code{sphinx-rootdir}
directory. Either edit \code{mydoc.rst} so that figure file paths are correct,
or simply copy your figure directories to \code{sphinx-rootdir}.
Links to local files in \code{mydoc.rst} must be modified to links to
files in the \code{_static} directory, see comment above.

\paragraph{Step 4.}
Edit the generated \code{index.rst} file so that \code{mydoc.rst}
is included, i.e., add \code{mydoc} to the \code{toctree} section so that it becomes
\bccq
.. toctree::
   :maxdepth: 2

   mydoc
\eccq
(The spaces before \code{mydoc} are important!)

\paragraph{Step 5.}
Generate, for instance, an HTML version of the Sphinx source:
\bsys
make clean   # remove old versions
make html
\esys

Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with \code{index.html} files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, {\LaTeX}, PDF (via {\LaTeX}), pure text, man pages,
and Texinfo files.

\paragraph{Step 6.}
View the result:
\bsys
Terminal> firefox _build/html/index.html
\esys

Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows \code{!bc}: \code{cod} gives Python
(\code{code-block:: python} in Sphinx syntax) and \code{cppcod} gives C++, but
all such arguments can be customized both for Sphinx and {\LaTeX} output.

\subsection{Wiki Formats}

There are many different wiki formats, but Doconce only supports three:
\href{{http://code.google.com/p/support/wiki/WikiSyntax<Google Code>}}{Googlecode wiki}, , MediaWiki, and Creole Wiki. These formats are called
\code{gwiki}, \code{mwiki}, and \code{cwiki}, respectively.
Transformation from Doconce to these formats is done by
\bsys
Terminal> doconce format gwiki mydoc.do.txt
Terminal> doconce format mwiki mydoc.do.txt
Terminal> doconce format cwiki mydoc.do.txt
\esys

The Googlecode wiki document, \code{mydoc.gwiki}, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the \code{.gwiki} file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of \href{{http://pediapress.com/code/}}{mwlib}. This means that one can
easily use Doconce to write \href{{http://en.wikibooks.org}}{Wikibooks}
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard {\LaTeX} book or a Sphinx web document.

\subsection{Tweaking the Doconce Output}

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
\code{.rst} file is going to be filtered to {\LaTeX} or HTML, it cannot know
if \code{.eps} or \code{.png} is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The \code{make.sh} files in \code{docs/manual} and \code{docs/tutorial}
constitute comprehensive examples on how such scripts can be made.


\section{The Doconce Markup Language}

The Doconce format introduces four constructs to markup text:
lists, special lines, inline tags, and environments.

\subsection{Lists}

An unordered bullet list makes use of the \code{*} as bullet sign
and is indented as follows

\bccq
   * item 1

   * item 2

     * subitem 1, if there are more
       lines, each line must
       be intended as shown here

     * subitem 2,
       also spans two lines

   * item 3
\eccq

This list gets typeset as

\begin{itemize}
   \item item 1

   \item item 2
\begin{itemize}

     \item subitem 1, if there are more
       lines, each line must
       be intended as shown here

     \item subitem 2,
       also spans two lines

\end{itemize}

\noindent
   \item item 3
\end{itemize}

\noindent
In an ordered list, each item starts with an \code{o} (as the first letter
in "ordered"):

\bccq
   o item 1

   o item 2

     * subitem 1

     * subitem 2

   o item 3
\eccq

resulting in

\begin{enumerate}
  \item item 1

  \item item 2
\begin{itemize}

     \item subitem 1

     \item subitem 2

\end{itemize}

\noindent
  \item item 3
\end{enumerate}

\noindent
Ordered lists cannot have an ordered sublist, i.e., the ordering
applies to the outer list only.

In a description list, each item is recognized by a dash followed
by a keyword followed by a colon:

\bccq
   - keyword1: explanation of keyword1

   - keyword2: explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)
\eccq

The result becomes

\begin{description}
   \item[keyword1:] 
     explanation of keyword1

   \item[keyword2:] 
     explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)
\end{description}

\noindent

\subsection{Special Lines}

The Doconce markup language has a concept called \emph{special lines}.
Such lines starts with a markup at the very beginning of the
line and are used to mark document title, authors, date,
sections, subsections, paragraphs., figures, movies, etc.

\index{TITLE@{\rm\texttt{TITLE}} keyword} \index{AUTHOR@{\rm\texttt{AUTHOR}} keyword} \index{DATE@{\rm\texttt{DATE}} keyword}

\paragraph{Heading with Title and Author(s).}
Lines starting with \code{TITLE:}, \code{AUTHOR:}, and \code{DATE:} are optional and used
to identify a title of the document, the authors, and the date. The
title is treated as the rest of the line, so is the date, but the
author text consists of the name and associated institution(s) with
the syntax
\bccq
name at institution1 and institution2 and institution3
\eccq
The \code{at} with surrounding spaces
is essential for adding information about institution(s)
to the author name, and the \code{and} with surrounding spaces is
essential as delimiter between different institutions.
An email address can optionally be included, using the syntax
\bccq
name Email: somename@site.net at institution1 and institution2
\eccq
Multiple authors require multiple \code{AUTHOR:} lines. All information
associated with \code{TITLE:} and \code{AUTHOR:} keywords must appear on a single
line.  Here is an example:
\bccq
TITLE: On an Ultimate Markup Language
AUTHOR: H. P. Langtangen at Center for Biomedical Computing, Simula Research Laboratory and Dept. of Informatics, Univ. of Oslo
AUTHOR: Kaare Dump Email: dump@cyb.space.com at Segfault, Cyberspace Inc.
AUTHOR: A. Dummy Author
DATE: November 9, 2016
\eccq
Note how one can specify a single institution, multiple institutions,
and no institution. In some formats (including \code{rst} and \code{sphinx})
only the author names appear. Some formats have
"intelligence" in listing authors and institutions, e.g., the plain text
format:
\bccq
Hans Petter Langtangen [1, 2]
Kaare Dump  (dump@cyb.space.com) [3]
A. Dummy Author

[1] Center for Biomedical Computing, Simula Research Laboratory
[2] Department of Informatics, University of Oslo
[3] Segfault, Cyberspace Inc.
\eccq
Similar typesetting is done for {\LaTeX} and HTML formats.

The current date can be specified as \code{today}.

\index{headlines} \index{section headings}

\paragraph{Section Headings.}
Section headings are recognized by being surrounded by equal signs (=) or
underscores before and after the text of the headline. Different
section levels are recognized by the associated number of underscores
or equal signs (=):

\begin{itemize}
   \item 9 \code{=} characters for chapters

   \item 7 for sections

   \item 5 for subsections

   \item 3 for subsubsections

   \item 2 \emph{underscrores} (only! - it looks best) for paragraphs
     (paragraph heading will be inlined)
\end{itemize}

\noindent
Headings can be surrounded by as many blanks as desired.

Doconce also supports abstracts. This is typeset as a paragraph, but
\emph{must} be followed by a section heading (everything up to the first
section heading is taken as part of the text of the abstract).


Here are some examples:
\bccq
__Abstract.__ The following text just attempts to exemplify
various section headings.

========= Example on a Chapter Heading =========

Some text.


======= Example on a Section Heading =======

The running text goes here.


===== Example on a Subsection Heading =====

The running text goes here.

===Example on a Subsubsection Heading===

The running text goes here.

__A Paragraph.__ The running text goes here.
\eccq


\section{Special Lines}

\subsection{Figures}

Figures are recognized by the special line syntax
\bccq
FIGURE:[filename, height=xxx width=yyy scale=zzz] possible caption
\eccq
The filename can be without extension, and Doconce will search for an
appropriate file with the right extension. If the extension is wrong,
say \code{.eps} when requesting an HTML format, Doconce tries to find another
file, and if not, the given file is converted to a proper format
(using ImageMagick's \code{convert} utility).

The height, width, and scale keywords (and others) can be included
if desired and may have effect for some formats. Note the comma
between the sespecifications and that there should be no space
around the = sign.

Note also that, like for \code{TITLE:} and \code{AUTHOR:} lines, all information
related to a figure line \emph{must be written on the same line}. Introducing
newlines in a long caption will destroy the formatting (only the
part of the caption appearing on the same line as \code{FIGURE:} will be
included in the formatted caption).


\begin{figure}
  \centerline{\includegraphics[width=0.9\linewidth]{figs/streamtubes.eps}}
  \caption{
  Streamtube visualization of a fluid flow. \label{fig:viz}
  }
\end{figure}


Combining several image files into one can be done by the
\code{convert} and \code{montage} programs from the ImageMagick suite:
\bsys
montage file1.png file2.png ... file4.png -geometry +2+2  result.png
montage file1.png file2.png -tile x1 result.png
montage file1.png file2.png -tile 1x result.png

convert -background white file1.png file2.png +append tmp.png
\esys
Use \code{+append} for stacking left to right, \code{-append} for top to bottom.
The positioning of the figures can be controlled by \code{-gravity}.

\subsection{Movies}

Here is an example on the \code{MOVIE:} keyword for embedding movies. This
feature works well for the \code{latex}, \code{html}, \code{rst}, and \code{sphinx} formats.
Other formats try to generate some HTML file and link to that file
for showing the movie.
\bccq
MOVIE: [filename, height=xxx width=yyy] possible caption
\eccq

% latex/PDF format can make use of the movie15 package for displaying movies,
% or just plain \href{run: ...}{...}


\begin{figure}[ht]
\begin{center}

% #ifdef MOVIE15
\includemovie[poster,
label=figs/mjolnir.mpeg,
autoplay,
%controls,
%toolbar,
% #ifdef EXTERNAL_MOVIE_VIEWER
externalviewer,
% #endif
text={\small (Loading figs/mjolnir.mpeg)},
repeat,
]{0.9\linewidth}{0.9\linewidth}{figs/mjolnir.mpeg}    % requires \usepackage{movie15}
% #ifndef EXTERNAL_MOVIE_VIEWER
\movieref[rate=0.5]{figs/mjolnir.mpeg}{Slower}
\movieref[rate=2]{figs/mjolnir.mpeg}{Faster}
\movieref[default]{figs/mjolnir.mpeg}{Normal}
\movieref[pause]{figs/mjolnir.mpeg}{Play/Pause}
\movieref[stop]{figs/mjolnir.mpeg}{Stop}
% #else
\href{run:figs/mjolnir.mpeg}{figs/mjolnir.mpeg}
% #endif

% #else
\href{run:figs/mjolnir.mpeg}{figs/mjolnir.mpeg}

% alternative: \movie command that comes with beamer
% \movie[options]{figs/mjolnir.mpeg}{figs/mjolnir.mpeg}
% #endif
\end{center}
\caption{}
\end{figure}


% MOVIE: [figs/wavepacket.gif, width=600 height=470]

% MOVIE: [figs/wavepacket2.mpeg, width=600 height=470]

The {\LaTeX} format results in a file that can either make use of
the movie15 package (requires the PDF to be shown in Acrobat Reader)
or just a plain address to the movie. The HTML, reST, and
Sphinx formats will play
the movie right away by embedding the file in a standard HTML code,
provided the output format is HTML.
For all other formats a URL to an HTML file, which can play the code,
is inserted in the output document.

When movies are embedded in the PDF file via {\LaTeX} and
the \code{movie15} package wanted, one has to turn on the preprocessor
variable \code{MOVIE15}. There is an associated variable
\code{EXTERNAL_MOVIE_VIEWER} which can be defined to launch an external
viewer when displaying the PDF file (in Acrobat Reader):
\bsys
Terminal> ptex2tex -DMOVIE15 -DEXTERNAL_MOVIE_VIEWER mydoc
\esys

The HTML, reST, and Sphinx formats can also treat filenames of the form
\code{myframes*.png}. In that case, an HTML file for showing the sequence of frames
is generated, and a link to this file is inserted in the output document.
That is, a simple "movie viewer" for the frames is made.

Many publish their scientific movies on YouTube, and Doconce recognizes
YouTube URLs as movies. When the output is an HTML file, the movie will
be embedded, otherwise a URL to the YouTube page is inserted.
You should equip the \code{MOVIE:} command with the right width and height
of embedded YouTube movies (the parameters appear when you request
the embedded HTML code for the movie on the YouTube page).

\subsection{Copying Computer Code from Source Files}

Another type of special lines starts with \code{@@@CODE} and enables copying
of computer code from a file directly into a verbatim environment, see
Section~\ref{sec:verbatim:blocks} below.

\subsection{Inline Tagging}

\label{inline:tagging}
\index{inline tagging} \index{emphasized words} \index{boldface words} \index{verbatim text}
\index{inline comments}

Doconce supports tags for \emph{emphasized phrases}, \textbf{boldface phrases},
and \code{verbatim text} (also called type writer text, for inline code)
plus {\LaTeX}/TeX inline mathematics, such as $\nu = \sin(x)$.

Emphasized text is typeset inside a pair of asterisk, and there should
be no spaces between an asterisk and the emphasized text, as in
\bccq
*emphasized words*
\eccq

Boldface font is recognized by an underscore instead of an asterisk:
\bccq
_several words in boldface_ followed by *ephasized text*.
\eccq
The line above gets typeset as
\textbf{several words in boldface} followed by \emph{ephasized text}.

Verbatim text, typically used for short inline code,
is typeset between back-ticks:
\bccq
`call myroutine(a, b)` looks like a Fortran call
while `void myfunc(double *a, double *b)` must be C.
\eccq
The typesetting result looks like this:
\code{call myroutine(a, b)} looks like a Fortran call
while \code{void myfunc(double *a, double *b)} must be C.

It is recommended to have inline verbatim text on the same line in
the Doconce file, because some formats ({\LaTeX} and \code{ptex2tex}) will have
problems with inline verbatim text that is split over two lines.

Watch out for mixing back-ticks and asterisk (i.e., verbatim and
emphasized code): the Doconce interpreter is not very smart so inline
computer code can soon lead to problems in the final format. Go back to the
Doconce source and modify it so the format to which you want to go
becomes correct (sometimes a trial and error process - sticking to
very simple formatting usually avoids such problems).

Web addresses with links are typeset as
\bccq
some URL like "Doconce": "http://code.google.com/p/doconce"
\eccq
which appears as some URL like \href{{http://google.com}}{Search Google}.
The space after colon is optional.
Links to files ending in \code{.txt}, \code{.html}, \code{.pdf}, \code{.py}, \code{.f},
\code{.f77}, \code{.f90}, \code{.f95}, \code{.sh}, \code{.csh}, \code{.ksh}, \code{.zsh},
\code{.c}, \code{.cpp}, \code{.cxx}, \code{.pl}, and \code{.java} follows the same
setup:
\bccq
see the "Doconce Manual": "manual.do.txt".
\eccq
which appears as see the \href{{manual.do.txt}}{Doconce Manual}.
If you want to view such source code files \emph{in the browser},
rather than dowloading the file, we recommend to transform
the source code file to HTML format by running
\code{pygmentize}, e.g.,
\bsys
Terminal> pygmentize -l bash -f html -O full,style=emacs \
          -o _static/make.sh.html subdir/make.sh
\esys
Then you can link to \code{_static/make.sh.html} instead of
\code{subdir/make.sh}. Or you can do both versions:
\bccq
See the code URL:"src/myprog.py" ("view: "_static/myprog.py.html").
\eccq

Links to files with other extensions must be realized
\emph{with the filename as link text}, written as
the keyword URL, followed by a colon, and then the filename enclosed
in double quotes:
\bccq
URL: "manual.html"
\eccq
resulting in the link \href{{manual.html}}{\nolinkurl{manual.html}}.

% This is now automatically carried out by the autogenerated
% script for sphinx:
% For such local links to
% work with the \code{sphinx} format, the \code{.rst} file needs a fix, carried
% out by
% !bc sys
% doconce sphinxfix_localURLs mydoc.rst
% !ec
% (The files, such as \code{manual.html}, are then copied to a subdirectory
% \code{_static}, which must be manually copied to the Sphinx directory's
% \code{_static} directory - links in the \code{.rst} files are automatically
% adjusted.)

To have the URL address itself as link text, put an "URL" or URL
before the address enclosed in double quotes:
\bccq
Click on this link: URL:"http://code.google.com/p/doconce".
\eccq
resulting in Click on this link: \href{{http://code.google.com/p/doconce}}{\nolinkurl{http://code.google.com/p/doconce}}.

Doconce also supports inline comments in the text:
\bccq
[name: comment]
\eccq
where \code{name} is the name of the author of the command, and \code{comment} is a
plain text text. \inlinecomment{hpl}{Note that there must be a space after the colon,
otherwise the comment is not recognized. Inline comments
can span
several lines,
if desired.}
The name and comment are visible in the output unless \code{doconce format}
is run with a command-line argument \code{--skip_inline_comments}
(see Chapter~\ref{doconce2formats} for an example). Inline comments
are helpful during development of a document since different authors
and readers can comment on formulations, missing points, etc.
All such comments can easily be removed from the \code{.do.txt} file
(see Chapter~\ref{doconce2formats}).

Inline mathematics is written as in {\LaTeX}, i.e., inside dollar signs.
Most formats leave this syntax as it is (including to dollar signs),
hence nice math formatting is only obtained in {\LaTeX} (Epytext has some
inline math support that is utilized).  However, mathematical
expressions in {\LaTeX} syntax often contains special formatting
commands, which may appear annoying in plain text. Doconce therefore
supports an extended inline math syntax where the writer can provide
an alternative syntax suited for formats close to plain ASCII:
\bccq
Here is an example on a linear system
${\bf A}{\bf x} = {\bf b}$|$Ax=b$,
where $\bf A$|$A$ is an $n\times n$|$nxn$ matrix, and
$\bf x$|$x$ and $\bf b$|$b$ are vectors of length $n$|$n$.
\eccq
That is, we provide two alternative expressions, both enclosed in
dollar signs and separated by a pipe symbol, the expression to the
left is used in {\LaTeX}, while the expression to the right is used for
all other formats.  The above text is typeset as "Here is an example
on a linear system ${\bf A}{\bf x} = {\bf b}$, where $\bf A$
is an $n\times n$ matrix, and $\bf x$ and $\bf b$
are vectors of length $n$."

\subsection{Comments}

Comments intended to be visible in the output document and read by
readers are known as \emph{inline comments} in Doconce and described
in Section~\ref{inline:tagging}.

Here we address comments in the Doconce source file that are not
intended to be visible in the output document. Basic comment
lines start with the hash \code{#}:
\bccq
#
# Here are some comment lines that do not affect any formatting.
# These lines are converted to comments in the output format.
#
\eccq
Such comment lines may have some side effects in the \code{rst} and \code{sphinx}
formats because following lines are taken as part of the comment if
there is not a blank line after the comment.

The Mako preprocessor supports comments that are filtered out \emph{before}
Doconce starts translating the document. Such comments are very valuable
as they will never interfere with the output format and they are only
present in the Doconce source. Mako has two types of comments:
lines starting with a double hash \code{##} and lines enclosed by
the \code{<%doc>} (beginning) and \code{<%doc/>} (closing) tags.

If you need a lot of comments in the Doconce file, consider using
Mako comments instead of the single hash, unless you want to
comments to be in the source code of the output document.

\subsection{Cross-Referencing}

\index{cross referencing} \index{labels} \index{references}

References and labels are supported. The syntax is simple:
\bccq
label{section:verbatim}   # defines a label
For more information we refer to Section ref{section:verbatim}.
\eccq
This syntax is close that that of labels and cross-references in
{\LaTeX}. When the label is placed after a section or subsection heading,
the plain text, Epytext, and StructuredText formats will simply
replace the reference by the title of the (sub)section.  All labels
will become invisible, except those in math environments.  In the
\code{rst} and \code{sphinx} formats, the end effect is the same, but
the "label" and "ref" commands are first translated to the proper
reST commands by \code{doconce format}. In the HTML and (Google
Code) wiki formats, labels become anchors and references become links,
and with {\LaTeX} "label" and "ref" are just equipped with backslashes so
these commands work as usual in {\LaTeX}.

It is, in general, recommended to use labels and references for
(sub)sections, equations, and figures only.
By the way, here is an example on referencing Figure~\ref{fig:viz}
(the label appears in the figure caption in the source code of this document).
Additional references to Sections~\ref{mathtext} and~\ref{newcommands} are
nice to demonstrate, as well as a reference to equations,
say (\ref{my:eq1})--(\ref{my:eq2}). A comparison of the output and
the source of this document illustrates how labels and references
are handled by the format in question.

Hyperlinks to files or web addresses are handled as explained
in Section~\ref{inline:tagging}.

\subsection{Index and Bibliography}

\index{index} \index{citations} \index{bibliography}

An index can be created for the \code{latex}, \code{rst}, and \code{sphinx} formats
by the \code{idx} keyword, following a LaTeX-inspired syntax:
\bccq
idx{some index entry}
idx{main entry!subentry}
idx{`verbatim_text` and more}
\eccq
The exclamation mark divides a main entry and a subentry. Backquotes
surround verbatim text, which is correctly transformed in a {\LaTeX} setting to
\bccq
\index{verbatim\_text@\texttt{\rm\smaller verbatim\_text and more}}
\eccq
Everything related to the index simply becomes invisible in plain
text, Epytext, StructuredText, HTML, and wiki formats.  Note: \code{idx}
commands should be inserted outside paragraphs, not in between the
text as this may cause some strange behaviour of reST and
Sphinx formatting.  As a recommended rule, index items are naturally
placed right after section headings, before the text begins, while
index items related to a paragraph should be placed above the
paragraph one a separate line (and not in between the text or between
the paragraph heading and the text body, although this works fine if
{\LaTeX} is the output format).

Literature citations also follow a LaTeX-inspired style:
\bccq
as found in cite{Larsen_1986,Nielsen_Kjeldstrup_1999}.
\eccq
Citation labels can be separated by comma. In {\LaTeX}, this is directly
translated to the corresponding \code{cite} command; in reST
and Sphinx the labels can be clicked, while in all the other text
formats the labels are consecutively numbered so the above citation
will typically look like
\bccq
as found in [3][14]
\eccq
if \code{Larsen_1986} has already appeared in the 3rd citation in the document
and \code{Nielsen_Kjeldstrup_1999} is a new (the 14th) citation. The citation labels
can be any sequence of characters, except for curly braces and comma.

The bibliography itself is specified by the special keyword \code{BIBFILE:},
which is optionally followed by a BibTeX file, having extension \code{.bib},
a corresponding reST bibliography, having extension \code{.rst},
or simply a Python dictionary written in a file with extension \code{.py}.
The dictionary in the latter file should have the citation labels as
keys, with corresponding values as the full reference text for an item
in the bibliography. Doconce markup can be used in this text, e.g.,
\bccq
{
'Nielsen_Kjeldstrup_1999': """
K. Nielsen and A. Kjeldstrup. *Some Comments on Markup Languages*.
URL:"http://some.where.net/nielsen/comments", 1999.
""",
'Larsen_1986':
"""
O. B. Larsen. On Markup and Generality.
*Personal Press*. 1986.
"""
}
\eccq
In the {\LaTeX} format, the \code{.bib} file will be used in the standard way,
in the \code{rst} and \code{sphinx} formats, the \code{.rst} file will be
copied into the document at the place where the \code{BIBFILE:} keyword
appears, while all other formats will make use of the Python dictionary
typeset as an ordered Doconce list, replacing the \code{BIBFILE:} line
in the document.

At present, only one file with bibliographic references can be used.

% see ketch/tex2rst for nice bibtex to rst converter which could
% be used here

Conversion of BibTeX databases to reST format can be
done by the \href{{http://pypi.python.org/pypi/bibliograph.parsing/}}{bibliograph.parsing} tool.

Finally, we here test the citation command and bibliography by
citing a book \cite{Python:Primer:09}, a paper \cite{Osnes:98},
and both of them simultaneously \cite{Python:Primer:09,Osnes:98}.

\inlinecomment{somereader}{comments, citations, and references in the latex style
is a special feature of doconce :-) }

\subsection{Tables}

A table like


\begin{quote}\begin{tabular}{rrr}
\hline
\multicolumn{1}{c}{time} & \multicolumn{1}{c}{velocity} & \multicolumn{1}{c}{acceleration} \\
\hline
0.0          & 1.4186       & -5.01        \\
2.0          & 1.376512     & 11.919       \\
4.0          & 1.1E+1       & 14.717624    \\
\hline
\end{tabular}\end{quote}

\noindent
is built up of pipe symbols and dashes:
\bccq
  |--------------------------------|
  |time  | velocity | acceleration |
  |--------------------------------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|
\eccq
The pipes and column values do not need to be aligned (but why write
the Doconce source in an ugly way?). In the line below the heading,
one can insert the characters \code{c}, \code{r}, or \code{l} to specify the
alignment of the columns (centered, right, or left, respectively).
Similar character can be inserted in the line above the header to
algn the headings. Pipes \code{|} can also be inserted to indicate
vertical rules in {\LaTeX} tables (they are ignored for other formats).
Note that not all formats offer alignment of heading or entries
in tables (\code{rst} and \code{sphinx} are examples). Also note that
Doconce tables are very simple: neither entries nor
headings can span several columns or rows. When that functionality
is needed, one can make use of the preprocessor and if-tests on
the format and insert format-specific code for tables.

\subsection{Exercises, Problems, or Projects}

Doconce has special support for three types of "exercises", named
\emph{exercise}, \emph{problem}, or \emph{project}.
These are all typeset as special kind of
sections. Such sections start with a subsection or subsubsection
headline, indicated by 3 or 5 \code{=} characters, and last up to the
next headline or the end of the file. The headline itself must
consists of the word "Exercise", "Problem", or "Project", followed
by a colon and a title of the exercise, problem, or project.
The next line(s) may contain a label and specification of the
name of result file (if the answer to the exercise is to be handed
it) and a solution file:
\bccq
===== Project: Determine the Distance to the Moon =====
label{proj:moondist} file=earth2moon.pdf
solution=eart2moon_sol.do.txt

Here goes the running text of the project....

__Hint 1.__ Do not plan a travel to the moon.

__Hint 2.__ Wikipedia is always helpful.
\eccq
Doconce will recognize the exercise, problem, or project \emph{title},
the \emph{label}, the \emph{result file}, the \emph{solution file} (if any of
these three entities is present), the \emph{text}, and a sequence of
\emph{hints}. Tailored formatting of exercises in special output formats
can make use of this. For example, one can image web formats where
the hints are displayed one by one when needed and where the result
file can be uploaded. One can also think of mechanisms for downloading
the solution file if the result file meets certain criteria.
Doconce does not yet generate such functionality in any output format,
but this is an intended future feature to be impelemented.

Because exercises, problems, and projects are typeset as ordinary
sections (this is the most general approach that will work for many
formats), one must refer to an exercise, problem, or project
by its label, which normally will translate to the section number
(in {\LaTeX}, for instance) or a link to the title of the section.
The \emph{title} is typeset without any leading "Exercise:", "Problem:",
or "Project:" word, so that references like "see Problem ..."
works well in all formats ("..." will be a number in {\LaTeX} and
the problem title in most other formats).

It is recommended to collect all exercises as subsetions (or subsubsections)
under a section (or subsection) named "Exercises", "Problems", or
"Projects".

\subsection{Blocks of Verbatim Computer Code}

\label{sec:verbatim:blocks}

Blocks of computer code, to be typeset verbatim, must appear inside a
"begin code" \code{!bc} keyword and an "end code" \code{!ec} keyword. Both
keywords must be on a single line and \emph{start at the beginning of the
line}.  Before such a code block there must be a plain sentence
(at least if successful transformation to reST and
ASCII-type formats is desired). For example, a code block cannot come
directly after a section/paragraph heading or a table.

There may be an argument after the \code{!bc} tag to specify a
certain environment (for \code{ptex2tex} or Sphinx) for typesetting
the verbatim code. For instance, \code{!bc dat} corresponds to
the data file environment and \code{!bc cod} is typically
used for a code snippet. There are some predefined environments
explained below. If there is
no argument specifying the environment, one assumes some plain
verbatim typesetting (for \code{ptex2tex} this means the \code{ccq} environment,
which is defined in the config file \code{.ptex2tex.cfg},
while for Sphinx it defaults to the \code{python} environment).

Since the config file for \code{ptex2tex} can define what some environment
maps onto with respect to typesetting, a similar possibility is
supported for Sphinx as well.  The argument after \code{!bc} is in case of
Sphinx output mapped onto a valid Pygments language for typesetting of
the verbatim block by Pygments. This mapping takes place in an
optional comment to be inserted in the Doconce source file, e.g.,
\bccq
# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
\eccq
Here, three arguments are defined: \code{pycod} for Python code,
\code{cod} also for Python code, \code{cppcod} for C++ code, and \code{sys}
for terminal sessions. The same arguments would be defined
in \code{.ptex2tex.cfg} for how to typeset the blocks in {\LaTeX} using
various verbatim styles (Pygments can also be used in a {\LaTeX}
context).

By default, \code{pro} is used for complete programs in Python, \code{cod} is
for a code snippet in Python, while \code{xcod} and \code{xpro} implies computer
language specific typesetting where \code{x} can be \code{f} for Fortran, \code{c}
for C, \code{cpp} for C++, \code{sh} for Unix shells, \code{pl} for Perl, \code{m} for
Matlab, \code{cy} for Cython, and \code{py} for Python.  The argument \code{sys}
means by default \code{console} for Sphinx and \code{CodeTerminal} (ptex2tex
environent) for {\LaTeX}. Other specifications are \code{dat} for a data file
or print out, and \code{ipy} for interactive Python sessions (the latter
does not introduce any environment  in \code{sphinx} output, as interactive
sessions are automatically recognized and handled).  All these
definitions of the arguments after \code{!bc} can be redefined in the
\code{.ptex2tex.cfg} configuration file for ptex2tex/{\LaTeX} and in the
\code{sphinx code-blocks} comments for Sphinx. Support for other languages
is easily added.

% (Any sphinx code-block comment, whether inside verbatim code
% blocks or outside, yields a mapping between bc arguments
% and computer languages. In case of muliple definitions, the
% first one is used.)

The enclosing \code{!ec} tag of verbatim computer code blocks must
be followed by a newline.  A common error in list environments is to
forget to indent the plain text surrounding the code blocks. In
general, we recommend to use paragraph headings instead of list items
in combination with code blocks (it usually looks better, and some
common errors are naturally avoided).

Here is a verbatim code block with Python code (\code{pycod} style):
\bpycod
# regular expressions for inline tags:
inline_tag_begin = r'(?P<begin>(^|\s+))'
inline_tag_end = r'(?P<end>[.,?!;:)\s])'
INLINE_TAGS = {
    'emphasize':
    r'%s\*(?P<subst>[^ `][^*`]*)\*%s' % \
    (inline_tag_begin, inline_tag_end),
    'verbatim':
    r'%s`(?P<subst>[^ ][^`]*)`%s' % \
    (inline_tag_begin, inline_tag_end),
    'bold':
    r'%s_(?P<subst>[^ `][^_`]*)_%s' % \
    (inline_tag_begin, inline_tag_end),
}
\epycod
And here is a C++ code snippet (\code{cppcod} style):
\bcppcod
void myfunc(double* x, const double& myarr) {
    for (int i = 1; i < myarr.size(); i++) {
        myarr[i] = myarr[i] - x[i]*myarr[i-1]
    }
}
\ecppcod

% When showing copy from file in !bc envir, intent a character - otherwise
% ptex2tex is confused and starts copying...
Computer code can be copied directly from a file, if desired. The syntax
is then
\bccq
 @@@CODE myfile.f
 @@@CODE myfile.f fromto: subroutine\s+test@^C\s{5}END1
\eccq
The first line implies that all lines in the file \code{myfile.f} are
copied into a verbatim block, typset in a \code{!bc Xpro} environment, where
\code{X} is the extension of the filename, here \code{f} (i.e., the environment
becomes \code{!bc fpro} and will typically lead to some Fortran-style
formatting in Linux and Sphinx).  The
second line has a \code{fromto:} directive, which implies copying code
between two lines in the code, typset within a !`bc Xcod`
environment (again, \code{X} is the filename extension, implying the
type of file). Note that the \code{pro} and \code{cod} arguments are only used for {\LaTeX}
and Sphinx output, all other formats will have the code typeset within
a plain \code{!bc} environment.) Two regular expressions, separated by the
\code{@} sign, define the "from" and "to" lines.  The "from" line is
included in the verbatim block, while the "to" line is not. In the
example above, we copy code from the line matching \code{subroutine test}
(with as many blanks as desired between the two words) and the line
matching \code{C END1} (C followed by 5 blanks and then the text END1). The
final line with the "to" text is not included in the verbatim block.

Let us copy a whole file (the first line above):

\bfpro
C     a comment

      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\efpro

Let us then copy just a piece in the middle as indicated by the \code{fromto:}
directive above:

\bfcod
      subroutine    test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\efcod

Note that the "to" line is not copied into the Doconce file, but the
"from" line is. Sometimes it is convenient to also neglect the
"from" line, a feature that is allowed by replacing \code{fromto:} by
\code{from-to} ("from with minus"). This allows for copying very similar
code segments throughout a file, while still distinguishing between them.
Copying the second set of parameters from the text
\bcod
# --- Start Example 1 ---
c = -1
A = 2
p0 = 4
simulate_and_plot(c, A, p0)
# --- End Example 1 ---

# --- Start Example 2 ---
c = -1
A = 1
p0 = 0
simulate_and_plot(c, A, p0)
# --- End Example 2 ---
\ecod
is easy with
\bccq
from-to: Start Example 2@End Example 2
\eccq
With only \code{fromto:} this would be impossible.

(Remark for those familiar with \code{ptex2tex}: The from-to
syntax is slightly different from that used in \code{ptex2tex}. When
transforming Doconce to {\LaTeX}, one first transforms the document to a
\code{.p.tex} file to be treated by \code{ptex2tex}. However, the \code{@@@CODE} line
is interpreted by Doconce and replaced by the mentioned
pro or cod environment which are defined in the \code{ptex2tex} configuration
file.)

\subsection{{\LaTeX} Blocks of Mathematical Text}

\label{mathtext}

Blocks of mathematical text are like computer code blocks, but
the opening tag is \code{!bt} (begin TeX) and the closing tag is
\code{!et}. It is important that \code{!bt} and \code{!et} appear on the beginning of the
line and followed by a newline.
\bccq
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
\eccq
Here is the result of the above \code{!bt} - \code{!et} block:
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}

This text looks ugly in all Doconce supported formats, except from
{\LaTeX} and Sphinx.  If HTML is desired, and Sphinx is not an option,
one can filter the Doconce text first to {\LaTeX} and then use the tex4ht
tool to convert the dvi file to HTML, or one could just link a PDF
file (made from {\LaTeX}) directly from HTML.

If the document targets both {\LaTeX}, Sphinx, and other formats like
plain text and wiki, one can use the preprocessor to typeset the
mathematics in two versions. After \code{#if FORMAT in ("latex", "pdflatex",
"sphinx", "mwiki")} one places {\LaTeX} mathematics, and after \code{#else} one can
write inline mathematics in a way that looks nice in plain text and
wiki formats without support for mathematical typesetting.

\paragraph{Mathematics for PowerPoint/OpenOffice.}
If you have {\LaTeX} mathematics written in Doconce, it is fairly easy
to generate PNG images of all mathematical formulas and equations for
use with PowerPoint or OpenOffice documents.

\begin{enumerate}
 \item Make a Sphinx version of the Doconce file.

 \item Go to the Sphinx directory and load the \code{conf.py} file into
    a browser.

 \item Search for "math" and comment out the
    \code{'sphinx.ext.mathjax'} (enabled by default) and
    \code{'matplotlib.sphinxext.mathmpl'} (disabled by default)
    lines, and uncomment the \code{'sphinx.ext.pngmath'} package.
    This is the package that generates small PNG pictures
    of the mathematics.

 \item Uncomment the line with \code{pngmath_dvipng_args =} and
    set the PNG resolution to \code{-D 200} when the purpose is to
    generate mathematics pictures for slides.

 \item Run \code{make html}.

 \item Look at the HTML source file in the \code{_build/html}
    directory: all mathematics are in \code{img} tags with \code{src=}
    pointing to a PNG file and \code{alt=} pointing to the {\LaTeX}
    source for the formula in question. This makes it very
    easy to find the PNG file that corresponding to a particular
    mathematical expression.
\end{enumerate}

\noindent

\subsection{Macros (Newcommands)}

\label{newcommands}

Doconce supports a type of macros via a LaTeX-style \emph{newcommand}
construction.  The newcommands defined in a file with name
\code{newcommand_replace.tex} are expanded when Doconce is filtered to
other formats, except for {\LaTeX} (since {\LaTeX} performs the expansion
itself).  Newcommands in files with names \code{newcommands.tex} and
\code{newcommands_keep.tex} are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands {\LaTeX} math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
\code{!bt} and \code{!et} in \code{newcommands_keep.tex} to keep them unchanged, at
least if they contribute to make the raw {\LaTeX} math text easier to
read in the formats that cannot render {\LaTeX}.  Newcommands used
elsewhere throughout the text will usually be placed in
\code{newcommands_replace.tex} and expanded by Doconce.  The definitions of
newcommands in the \code{newcommands*.tex} files \emph{must} appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

\paragraph{Example.}
Suppose we have the following commands in
\code{newcommand_replace.tex}:

\bpro
\newcommand{\beqa}{\begin{eqnarray}}
\newcommand{\eeqa}{\end{eqnarray}}
\newcommand{\ep}{\thinspace . }
\newcommand{\uvec}{\vec u}
\newcommand{\Q}{\pmb{Q}}
\epro

and these in \code{newcommands_keep.tex}:

\bpro
\newcommand{\x}{\pmb{x}}
\newcommand{\normalvec}{\pmb{n}}
\newcommand{\Ddt}[1]{\frac{D#1}{dt}}
\epro

The {\LaTeX} block
\bccq
\beqa
\x\cdot\normalvec &=& 0, label{my:eq1}\\
\Ddt{\uvec} &=& \Q \ep   label{my:eq2}
\eeqa
\eccq
will then be rendered to
\begin{align}
{\partial u\over\partial t} &= \nabla^2 u + f, \label{myeq1}\\
{\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
\end{align}
in the current format.

\subsection{Preprocessing Steps}

Doconce allows preprocessor commands for, e.g., including files,
leaving out text, or inserting special text depending on the format.
Two preprocessors are supported: preprocess
(\href{{http://code.google.com/p/preprocess}}{\nolinkurl{http://code.google.com/p/preprocess}}) and mako
(\href{{http://www.makotemplates.org/}}{\nolinkurl{http://www.makotemplates.org/}}). The former allows include and if-else
statements much like the well-known preprocessor in C and C++ (but it
does not allow sophisticated macro substitutions). The latter
preprocessor is a very powerful template system.  With Mako you can
automatically generate various type of text and steer the generation
through Python code embedded in the Doconce document. An arbitrary set
of \code{name=value} command-line arguments (at the end of the command line)
automatically define Mako variables that are substituted in the document.

Doconce will detect if preprocess or Mako commands are used and run
the relevant preprocessor prior to translating the Doconce source to a
specific format.

The preprocess and mako programs always have the variable \code{FORMAT}
defined as the desired output format of Doconce (\code{html}, \code{latex},
\code{plain}, \code{rst}, \code{sphinx}, \code{epydoc}, \code{st}).  It is then easy to test on
the value of \code{FORMAT} and take different actions for different
formats. For example, one may create special {\LaTeX} output for figures,
say with multiple plots within a figure, while other formats may apply
a separate figure for each plot. Below is an example (see the Doconce
source code of this document to understand how preprocess is used to
create the example).

% If PNGFIGS is defined, PNG files are used, otherwise Encapsulated
% PostScript files are used.

% Use latex with subfigures (a) and (b)
\begin{figure}
\label{fig:wavepackets}
  \begin{center}
\subfigure[]{\includegraphics[width=0.49\linewidth]{figs/wavepacket_0001.eps}}

\subfigure[]{\includegraphics[width=0.49\linewidth]{figs/wavepacket_0010.eps}}
  \end{center}
  \caption{
  Wavepackets at time (a) 0.1 s and (b) 0.2 s.
  }
\end{figure}


Other user-defined variables for the preprocessor can be set at
the command line as explained in Section~\ref{doconce2formats}.

More advanced use of mako can include Python code that may automate
the writing of parts of the document.

\subsection{Splitting Documents into Smaller Pieces}

Long documents are conveniently split into smaller Doconce files.
However, there must be a master document including all the pieces,
otherwise references to sections and the index will not work properly.
The master document is preferably a file just containing a set of
preprocessor include statements of the form \code{#include "file.do.txt"}.
The preprocessor will put together all the pieces so that Doconce
sees a long file with the complete text.

For reST and Sphinx documents it is a point to have
separate \code{.rst} files and an index file listing the various \code{.rst}
that build up the document. To generate the various \code{.rst} files one
should not run Doconce on the individual \code{.do.txt} files, because then
references and index entries are not treated correctly. Instead,
run Doconce on the master file and invoke the script \code{doconce split_rst}
to split the long, complete \code{.rst} into pieces. This process requires
that each \code{#include "file.do.txt} line in the master file is preceded by a
"marker line" having the syntax \code{#>>>>>> part: file >>>>>>}, where
\code{file} is the filename without extension. The number of greater than
signs is not important, but it has to be a comment line and it has
to contain the keyword \code{part:}.

Here is an example. Say the name of the master file is \code{master.do.txt}.
The following Bash script does the job:
We run
\bcod
doconce format sphinx master
# Split master.rst into parts
# as defined by #>>>>> part: name >>>>> lines
files=`doconce split_rst master.rst`

dir=sphinxm-rootdir

if [ ! -d $dir ]; then
  doconce sphinx_dir dirname=$dir author='me and you' \
          version=1.0 theme=default $files
  sh automake-sphinx.sh
else
  for file in $files; do
    cp $file.rst $dir
  done
  cd $dir
  make html
  cd ..
fi
\ecod
The autogenerated \code{automake-sphinx.sh} file (by \code{doconce sphinx_dir})
is compatible with a master \code{.rst} file split into pieces as long as
the complete set of pieces in correct order is given to \code{doconce sphinx_dir}.
This set is the output of \code{doconce split_rst}, which we catch in a
variable \code{files} above.

\subsection{Missing Features}

Doconce does not aim to support sophisticated typesetting, simply because
sophisticated typesetting usually depend quite strongly on the particular
output format chosen. When a particular feature needed is not supported
by Doconce, it is recommended to hardcode that feature for a particular
format and use the if-else construction of the preprocessor. For example,
if a sophisticated table is desired in {\LaTeX} output, test on the
\code{FORMAT} variable (\code{#if FORMAT == "latex"}) in the Doconce code and
insert the table in {\LaTeX} format. The \code{else} or \code{elif} branches may
have the table in other formats or a simplified version in the Doconce
table format. Similarly, if certain adjustments are needed, like
pagebreaks in {\LaTeX}, hardcode that in the Doconce format (and recall
that this is really {\LaTeX} dependent - pagebreaks are not
relevant HTML formats).

Instead of inserting special code in the Doconce document, one can
alternatively script editing of the output from Doconce. That is,
we develop a Python or Bash script that runs the translation of
a Doconce document to a ready docoment in another format. Inside this
script, we may edit and fine-tune the output from Doconce.

As an example, say you want a table of contents in the {\LaTeX} output
(Doconce does not support table of contents). By inserting a
recognizable comment in the Doconce source, say
\bccq
# table of contents
\eccq
we can use this comment to edit the {\LaTeX} file. First, we run
Doconce \code{doconce format latex mydoc} to produce \code{mydoc.p.tex}. Then
we use the \code{doconce replace} and \code{doconce subst} commands to
replace the comment by the comment plus the table of contents command,
or just the latter:
\bccq
Terminal> doconce replace '% table of contents'
          '\tableofcontents' mydoc.p.tex
\eccq
The \code{doconce replace from_text to_text filename} command performs a
character-by-character replacement (using the \code{replace} method in
string objects in Python). If we want to preserve the comment and add
a new line with \code{\tableofcontents}, we should use \code{doconce subst},
which applies regular expressions for substitutions and thereby
understands the newline character:
\bccq
Terminal> doconce subst '% table of contents' \
          '% table of contents\n\\tableofcontents' mydoc.p.tex
\eccq
Note the double backshlash in front of the \code{t} character: without it we
would get a tab and no backslash.
The \code{doconce subst} is a powerful way to automatically edit the output
from Doconce and fine-tune a {\LaTeX} document. Use of comment lines to
identify portions of the file to be edited is a smart idea.
Alternatively, the relevant {\LaTeX} constructions can be inserted directly
in the Doconce file using if-else preprocessor directives.

\subsection{Header and Footer}

Some formats use a header and footer in the document. {\LaTeX} and
HTML are two examples of such formats. When the document is to be
included in another document (which is often the case with
Doconce-based documents), the header and footer are not wanted, while
these are needed (at least in a {\LaTeX} context) if the document is
stand-alone. We have introduce the convention that if \code{TITLE:} or
\code{#TITLE:} is found at the beginning of the line (i.e., the document
has, or has an intention have, a title), the header and footer
are included, otherwise not.

\subsection{Emacs Doconce Formatter}

The file \code{misc/.doconce-mode.el} in the Doconce source distribution
gives a "Doconce Editing Mode" in Emacs. The file is a rough edit of
the reST Editing Mode for Emacs. Some Doconce features are recognized,
but far from all, and sometimes portions of Doconce text just appear
as ordinary text.

Here is how to get the Doconce Editing Mode in Emacs.

\paragraph{Step 1.}
Download the Doconce tarball from \code{code.google.com/p/doconce},
pack it out and go to the root directory.

\paragraph{Step 2.}
Copy the \code{doconce-mode.el} file to the home directory:
\bccq
cp misc/.doconce-mode.el $HOME
\eccq

\paragraph{Step 3.}
Add these lines to \code{$HOME/.emacs}:
\bccq
(load-file "~/hg/.doconce-mode.el")
(setq auto-mode-alist(cons '("\\.do\\.txt$" . doconce-mode) auto-mode-alist))
\eccq
Emacs will now recognize files with extension \code{.do.txt} and enter
the Doconce Editing Mode.


\section{Troubleshooting}

\subsection{Disclaimer}

Doconce has some support for syntax checking.  If you encounter Python
errors while running \code{doconce format}, the reason for the error is
most likely a syntax problem in your Doconce source file. You have to
track down this syntax problem yourself.

However, the problem may well be a bug in Doconce. The Doconce
software is incomplete, and many special cases of syntax are not yet
discovered to give problems. Such special cases are also seldom easy to
fix, so one important way of "debugging" Doconce is simply to change
the formatting so that Doconce treats it properly. Doconce is very much
based on regular expressions, which are known to be non-trivial to
debug years after they are created. The main developer of Doconce has
hardly any time to work on debugging the code, but the software works
well for his diverse applications of it.

\subsection{General Problems}

\paragraph{Something goes wrong in the preprocessing step.}
Doconce automatically removes the file \code{__tmp.do.txt}, which is the
resulting of the preprocessing stge and the file to examine if
something goes wrong in this stage (i.e., when \code{mako} and/or
\code{preprocess} is run). Add the \code{--debug} flag at the end of the
\code{doconce} command to (both make a debug file and) avoid that
\code{__tmp.do.txt} is deleted.

\paragraph{Figure captions are incomplete.}
If only the first part of a figure caption in the Doconce file is seen
in the target output format, the reason is usually that the caption
occupies multiple lines in the Doconce file. The figure caption must
be written as \emph{one line}, at the same line as the FIGURE keyword.

\paragraph{Preprocessor directives do not work.}
Make sure the preprocessor instructions, in Preprocess or Mako, have
correct syntax. Also make sure that you do not mix Preprocess and Mako
instructions. Doconce will then only run Preprocess.

\paragraph{Problems with boldface and emphasize.}
Two boldface or emphasize expressions after each other are not rendered
correctly. Merge them into one common expression.

\paragraph{Links to local directories do not work.}
Links of the type
\bccq
see the "examples directory": "src/examples"
\eccq
do not work well. You need to link to a specific HTML file:
\bccq
see the "examples directory": "src/examples/index.html"
\eccq

\paragraph{Links are not typeset correctly.}
Not all formats will allow formatting of the links. Verbatim words
in links are allowed if the whole link is typeset in verbatim:
\bccq
see the directory "`examples`": "src/examples/index.html".
\eccq
However, the following will not be typeset correctly:
\bccq
see the "`examples` directory": "src/examples/index.html"
\eccq
The back-ticks must be removed, or the text can be reformulated as
in the line above it.

\paragraph{Inline verbatim code is not detected.}
Make sure there is a space before the first back-tick.

\paragraph{Strange non-English characters.}
Check the encoding of the \code{.do.txt} file with the Unix \code{file} command
or with
\bccq
Unix> doconce guess_encoding myfile.do.txt
\eccq
If the encoding is utf-8, convert to latin-1 using either of
the Unix commands
\bccq
Unix> doconce change_encoding utf-8 LATIN1 myfile.do.txt

Unix> iconv -f utf-8 -t LATIN1 myfile.do.txt --output newfile
\eccq

\paragraph{Wrong Norwegian charcters.}
When Doconce documents have characters not in the standard ASCII set,
the format of the file must be LATIN1 and not UTF-8. See
the section "Strange non-English characters" above for how to
run \code{doconce change_encoding} to change the encoding of the Doconce file.

\paragraph{Inline verbatim text is not formatted correctly.}
Make sure there is whitespace surrounding the text in back-ticks.

\paragraph{Too short underlining of reST headlines.}
This may happen if there is a paragraph heading without
proceeding text before some section heading.

\paragraph{Found !bt but no tex blocks extracted (BUG).}
This message points to a bug, but has been resolved by removing blank lines
between the text and the first \code{!bt} (inserting the blanks again did not
trigger the error message again...).

\subsection{Problems with code or Tex Blocks}

\paragraph{Code or math block errors in reST.}
First note that a code or math block must come after some plain
sentence (at least for successful output in reST), not directly
after a section/paragraph heading, table, comment, figure, or
movie, because the code or math block is indented and then become
parts of such constructions. Either the block becomes invisible or
error messages are issued.

Sometimes reST reports an "Unexpected indentation" at the beginning of
a code block. If you see a \code{!bc}, which should have been removed when
running \code{doconce format sphinx}, it is usually an error in the Doconce
source, or a problem with the rst/sphinx translator.  Check if the
line before the code block ends in one colon (not two!), a question
mark, an exclamation mark, a comma, a period, or just a newline/space
after text. If not, make sure that the ending is among the
mentioned. Then \code{!bc} will most likely be replaced and a double colon
at the preceding line will appear (which is the right way in reST to
indicate a verbatim block of text).

\paragraph{Strange errors around code or TeX blocks in reST.}
If \code{idx} commands for defining indices are placed inside paragraphs,
and especially right before a code block, the reST translator
(rst and sphinx formats) may get confused and produce strange
code blocks that cause errors when the reST text is transformed to
other formats. The remedy is to define items for the index outside
paragraphs.

\paragraph{Something is wrong with a verbatim code block.}
Check first that there is a "normal" sentence right before
the block (this is important for reST and similar
"ASCII-close" formats).

\paragraph{Code/TeX block is not shown in reST format.}
A comment right before a code or tex block will treat the whole
block also as a comment. It is important that there is normal
running text right before \code{!bt} and \code{!bc} environments.

\paragraph{Verbatim code blocks inside lists look ugly.}
Read the Section~\ref{sec:verbatim:blocks} above.  Start the
\code{!bc} and \code{!ec} tags in column 1 of the file, and be careful with
indenting the surrounding plain text of the list item correctly. If
you cannot resolve the problem this way, get rid of the list and use
paragraph headings instead. In fact, that is what is recommended:
avoid verbatim code blocks inside lists (it makes life easier).

\paragraph{{\LaTeX} code blocks inside lists look ugly.}
Same solution as for computer code blocks as described in the
previous paragraph. Make sure the \code{!bt} and \code{!et} tags are in column 1
and that the rest of the non-LaTeX surrounding text is correctly indented.
Using paragraphs instead of list items is a good idea also here.

\subsection{Problems with reST/Sphinx Output}

\paragraph{Lists do not appear in .rst files.}
Check if you have a comment right above the list. That comment
will include the list if the list is indentend. Remove the comment.

\paragraph{Error message "Undefined substitution..." from reST.}
This may happen if there is much inline math in the text. reST cannot
understand inline {\LaTeX} commands and interprets them as illegal code.
Just ignore these error messages.

\paragraph{Warning about duplicate link names.}
Link names should be unique, but if (e.g.) "file" is used as link text
several places in a reST file, the links still work. The warning can
therefore be ignorned.

\paragraph{Inconsistent headings in reST.}
The \code{rst2*.py} and Sphinx converters abort if the headers of sections
are not consistent, i.e., a subsection must come under a section,
and a subsubsection must come under a subsection (you cannot have
a subsubsection directly under a section). Search for \code{===},
count the number of equality signs (or underscores if you use that)
and make sure they decrease by two every time a lower level is encountered.

\paragraph{No code environment appears before "bc ipy" blocks.}
The \code{!bc ipy} directive behaves this way for \code{sphinx} output because
interactive sessions are automatically handled. If this is not
appropriate, shift to \code{!bc cod} or another specification of the
verbatim environment.

\subsection{Problems with {\LaTeX} Output}

\paragraph{Error when running latex: You must 'pygmentize' installed.}
This points to the used of the Minted style for typesetting verbatim
code. You need to run
\bsys
Terminal> latex -shell-escape file
\esys
if you have run \code{ptex2tex} with the \code{-DMINTED} option and turned on
the use of the Minted style (and therefore \code{pygmentize} program).

\paragraph{The {\LaTeX} file does not compile.}
If the problem is undefined control sequence involving
\bccq
\code{...}
\eccq
the cause is usually a verbatim inline text (in back-ticks in the
Doconce file) spans more than one line. Make sure, in the Doconce source,
that all inline verbatim text appears on the same line.

\paragraph{Inline verbatim gives error.}
Check if the inline verbatim contains typical {\LaTeX} commands, e.g.,
\bccq
some text with `\usepackage{mypack}` is difficult because
ptex2tex will replace this by \code{\usepackage{mypack}} and
then replace this by
{\fontsize{10pt}{10pt}\verb!\usepackage{mypack!}}
which is wrong because ptex2tex applies regex that don't
capture the second }
\eccq
The remedy is to place verbatim {\LaTeX} commands in verbatim
blocks - that is safe.

% Could have doconce configure file where inline verbatim is
% configured to be \fontsize... directly, not via ptex2tex \code{}.

\paragraph{Errors in figure captions.}
Such errors typically arise from unbalanced curly braces, or dollar signs
around math, and similar {\LaTeX} syntax errors.

(Note that verbatim font is likely to cause trouble inside figure captions,
but Doconce will automatically replace verbatim text in back-ticks by
a proper \code{texttt} command (since verbatim font constructions does not work
inside figure captions) and precede underscores by backslash.)

\paragraph{Chapters are ignored.}
The default {\LaTeX} style is "article". If you chapters in the Doconce file,
you need to run \code{ptex2tex} with the option \code{-DBOOK} to set the {\LaTeX}
documentstyle to "book".

\paragraph{I want to tune the top of the {\LaTeX} file.}
The top of the {\LaTeX} file, as generated by Doconce, is very simple.
If this {\LaTeX} code is not sufficient for your needs, there are
two ways out of it:

\begin{enumerate}
\item Make a little Bash script that performs a series of
   \code{doconce subst} (regular expressions) or \code{doconce replace} (regular text)
   substitutions to change the text automatically (you probably have to
   repeat these edits so automating them is a good idea).

\item Place the title, author(s), and date of the Doconce file in a separate
   file and use the preprocessor to include the rest. The rest is then
   one or more Doconce files without title, author(s), and date. This
   means that the \code{doconce format latex} command does not generate
   the {\LaTeX} intro (preamble) and outro, just the core text, for these
   files.
   Make a new file by hand with the appropriate {\LaTeX} intro and outro
   text and include the various text pieces in this file.
   To make the {\LaTeX} document, you compile all Doconce files
   into {\LaTeX} code, except the "top" Doconce file that includes the
   others. That file is not used for {\LaTeX} output, but
   replaced by the hand-written {\LaTeX} "top" file.
\end{enumerate}

\noindent

\subsection{Problems with gwiki Output}

\paragraph{Strange nested lists in gwiki.}
Doconce cannot handle nested lists correctly in the gwiki format.
Use nonnested lists or edit the \code{.gwiki} file directly.

\paragraph{Lists in gwiki look ugly in the gwiki source.}
Because the Google Code wiki format requires all text of a list item to
be on one line, Doconce simply concatenates lines in that format,
and because of the indentation in the original Doconce text, the gwiki
output looks somewhat ugly. The good thing is that this gwiki source
is seldom to be looked at - it is the Doconce source that one edits
further.

\subsection{Debugging}

Given a problem, extract a small portion of text surrounding the
problematic area and debug that small piece of text. Doconce does a
series of transformations of the text. The effect of each of these
transformation steps are dumped to a logfile, named
\code{_doconce_debugging.log}, if the to \code{doconce format} after the filename
is \code{debug}. The logfile is inteded for the developers of Doconce, but
may still give some idea of what is wrong.  The section "Basic Parsing
Ideas" explains how the Doconce text is transformed into a specific
format, and you need to know these steps to make use of the logfile.


\section{Basic Parsing Ideas}

% avoid list here since we have code in between (never a good idea)

The (parts of) files with computer code to be directly included in
the document are first copied into verbatim blocks.

All verbatim and TeX blocks are removed and stored elsewhere
to ensure that no formatting rules are not applied to these blocks.

The text is examined line by line for typesetting of lists, as well as
handling of blank lines and comment lines.
List parsing needs some awareness of the context.
Each line is interpreted by a regular expression

\bccq
(?P<indent> *(?P<listtype>[*o-] )? *)(?P<keyword>[^:]+?:)?(?P<text>.*)\s?
\eccq

That is, a possible indent (which we measure), an optional list
item identifier, optional space, optional words ended by colon,
and optional text. All lines are of this form. However, some
ordinary (non-list) lines may contain a colon, and then the keyword
and text group must be added to get the line contents. Otherwise,
the text group will be the line.

When lists are typeset, the text is examined for sections, paragraphs,
title, author, date, plus all the inline tags for emphasized, boldface,
and verbatim text. Plain subsitutions based on regular expressions
are used for this purpose.

The final step is to insert the code and TeX blocks again (these should
be untouched and are therefore left out of the previous parsing).

It is important to keep the Doconce format and parsing simple.  When a
new format is needed and this format is not obtained by a simple edit
of the definition of existing formats, it might be better to convert
the document to reST and then to XML, parse the XML and
write out in the new format.  When the Doconce format is not
sufficient to getting the layout you want, it is suggested to filter
the document to another, more complex format, say reST or
{\LaTeX}, and work further on the document in this format.

\subsection{A Glimpse of How to Write a New Translator}

This is the HTML-specific part of the
source code of the HTML translator:


\bccq
FILENAME_EXTENSION['html'] = '.html'  # output file extension
BLANKLINE['html'] = '<p>\n'           # blank input line => new paragraph
INLINE_TAGS_SUBST['html'] = {         # from inline tags to HTML tags
    # keep math as is:
    'math': None,  # indicates no substitution
    'emphasize':     r'\g<begin><em>\g<subst></em>\g<end>',
    'bold':          r'\g<begin><b>\g<subst></b>\g<end>',
    'verbatim':      r'\g<begin><tt>\g<subst></tt>\g<end>',
    'URL':           r'\g<begin><a href="\g<url>">\g<link></a>',
    'section':       r'<h1>\g<subst></h1>',
    'subsection':    r'<h3>\g<subst></h3>',
    'subsubsection': r'<h5>\g<subst></h5>',
    'paragraph':     r'<b>\g<subst></b>. ',
    'title':         r'<title>\g<subst></title>\n<center><h1>\g<subst></h1></center>',
    'date':          r'<center><h3>\g<subst></h3></center>',
    'author':        r'<center><h3>\g<subst></h3></center>',
    }

# how to replace code and latex blocks by html (<pre>) environment:
def html_code(filestr):
    c = re.compile(r'^!bc(.*?)\n', re.MULTILINE)
    filestr = c.sub(r'<!-- BEGIN VERBATIM BLOCK \g<1>-->\n<pre>\n', filestr)
    filestr = re.sub(r'!ec\n',
                     r'</pre>\n<! -- END VERBATIM BLOCK -->\n', filestr)
    c = re.compile(r'^!bt\n', re.MULTILINE)
    filestr = c.sub(r'<pre>\n', filestr)
    filestr = re.sub(r'!et\n', r'</pre>\n', filestr)
    return filestr
CODE['html'] = html_code

# how to typeset lists and their items in html:
LIST['html'] = {
    'itemize':
    {'begin': '\n<ul>\n', 'item': '<li>', 'end': '</ul>\n\n'},
    'enumerate':
    {'begin': '\n<ol>\n', 'item': '<li>', 'end': '</ol>\n\n'},
    'description':
    {'begin': '\n<dl>\n', 'item': '<dt>%s<dd>', 'end': '</dl>\n\n'},
    }

# how to type set description lists for function arguments, return
# values, and module/class variables:
ARGLIST['html'] = {
    'parameter': '<b>argument</b>',
    'keyword': '<b>keyword argument</b>',
    'return': '<b>return value(s)</b>',
    'instance variable': '<b>instance variable</b>',
    'class variable': '<b>class variable</b>',
    'module variable': '<b>module variable</b>',
    }

# document start:
INTRO['html'] = """
<html>
<body bgcolor="white">
"""
# document ending:
OUTRO['html'] = """
</body>
</html>
"""
\eccq

\subsection{Typesetting of Function Arguments, Return Values, and Variables}

As part of comments (or doc strings) in computer code one often wishes
to explain what a function takes of arguments and what the return
values are. Similarly, it is desired to document class, instance, and
module variables.  Such arguments/variables can be typeset as
description lists of the form listed below and \emph{placed at the end of
the doc string}. Note that \code{argument}, \code{keyword argument}, \code{return},
\code{instance variable}, \code{class variable}, and \code{module variable} are the
only legal keywords (descriptions) for the description list in this
context.  If the output format is Epytext (Epydoc) or Sphinx, such lists of
arguments and variables are nicely formatted.

\bccq
    - argument x: x value (float),
      which must be a positive number.
    - keyword argument tolerance: tolerance (float) for stopping
      the iterations.
    - return: the root of the equation (float), if found, otherwise None.
    - instance variable eta: surface elevation (array).
    - class variable items: the total number of MyClass objects (int).
    - module variable debug: True: debug mode is on; False: no debugging
      (bool variable).
\eccq

The result depends on the output format: all formats except Epytext
and Sphinx just typeset the list as a list with keywords.

\begin{description}
    \item[module variable x:] 
      x value (float),
      which must be a positive number.

    \item[module variable tolerance:] 
      tolerance (float) for stopping
      the iterations.
\end{description}

\noindent
\bibliographystyle{plain}
\bibliography{manual_bib}

\printindex

\end{document}

************** File: manual.rst *****************
.. Automatically generated reST file from Doconce source
   (http://code.google.com/p/doconce/)

Doconce Description
===================

:Author: Hans Petter Langtangen

:Date: Jan 32, 2100

.. lines beginning with # are comment lines



.. _what:is:doconce:

What Is Doconce?
================

Doconce is two things:

 1. Doconce is a very simple and minimally tagged markup language that
    looks like ordinary ASCII text (much like what you would use in an
    email), but the text can be transformed to numerous other formats,
    including HTML, Pandoc, Google wiki, LaTeX, PDF, reStructuredText
    (reST), Sphinx, Epytext, and also plain text (where non-obvious
    formatting/tags are removed for clear reading in, e.g.,
    emails). From reST you can (via ``rst2*`` programs) go to XML, HTML,
    LaTeX, PDF, OpenOffice, and from the latter (via ``unoconv``) to
    RTF, numerous MS Word formats (including MS Office Open XML),
    DocBook, PDF, MediaWiki, XHTML. From Pandoc one can generate
    Markdown, reST, LaTeX, HTML, PDF, DocBook XML, OpenOffice, GNU
    Texinfo, MediaWiki, RTF, Groff, and other formats.

 2. Doconce is a working strategy for never duplicating information.
    Text is written in a single place and then transformed to
    a number of different destinations of diverse type (software
    source code, manuals, tutorials, books, wikis, memos, emails, etc.).
    The Doconce markup language support this working strategy.
    The slogan is: "Write once, include anywhere".

Here are some Doconce features:

  * Doconce markup does include tags, so the format is more tagged than
    Markdown and Pandoc, but less than reST, and very much less than
    LaTeX and HTML.

  * Doconce can be converted to plain *untagged* text,
    often desirable for computer programs and email.

  * Doconce has good support for copying in parts of computer code
    directly from the source code files via regular expressions
    for the start and end lines.

  * Doconce has full support for LaTeX math and integrates well
    with big LaTeX projects (books).

  * Doconce is almost self-explanatory and is a handy starting point
    for generating documents in more complicated markup languages, such
    as Google wiki, LaTeX, and Sphinx. A primary application of Doconce
    is just to make the initial versions of a Sphinx or wiki document.

  * Contrary to the similar (and superior) Pandoc translator, Doconce
    supports Sphinx, Google wiki, Creole wiki (for bitbucket.org),
    lots of computer code environments in LaTeX, and a special exercise
    syntax. Doconce also also runs preprocessors (including Mako)
    such that the author can mix ordinary text with programming
    construction for generating parts of the text.

Doconce was particularly written for the following sample applications:

  * Large books written in LaTeX, but where many pieces (computer demos,
    projects, examples) can be written in Doconce to appear in other
    contexts in other formats, including plain HTML, Sphinx, wiki, or MS Word.

  * Software documentation, primarily Python doc strings, which one wants
    to appear as plain untagged text for viewing in Pydoc, as reStructuredText
    for use with Sphinx, as wiki text when publishing the software at
    web sites, and as LaTeX integrated in, e.g., a thesis.

  * Quick memos, which start as plain text in email, then some small
    amount of Doconce tagging is added, before the memos can appear as
    Sphinx web pages, MS Word documents, or in wikis.

History: Doconce was developed in 2006 at a time when most popular
markup languages used quite some tagging.  Later, almost untagged
markup languages like Markdown and Pandoc became popular. Doconce is
not a replacement of Pandoc, which is a considerably more
sophisticated project. Moreover, Doconce was developed mainly to
fulfill the needs for a flexible source code base for books with much
mathematics and computer code.

Disclaimer: Doconce is a simple tool, largely based on interpreting
and handling text through regular expressions. The possibility for
tweaking the layout is obviously limited since the text can go to
all sorts of sophisticated markup languages. Moreover, because of
limitations of regular expressions, some formatting of Doconce syntax
may face problems when transformed to HTML, LaTeX, Sphinx, and similar
formats.



Dependencies and Installation
-----------------------------

Doconce itself is pure Python code hosted at `<http://code.google.com/p/doconce>`_.  Its installation from the
Mercurial (``hg``) source follows the standard procedure::


        # Doconce
        hg clone https://doconce.googlecode.com/hg/ doconce
        cd doconce
        sudo python setup.py install
        cd ..


If you make use of the `Preprocess <http://code.google.com/p/preprocess>`_
preprocessor, this program must be installed::


        svn checkout http://preprocess.googlecode.com/svn/trunk/ preprocess
        cd preprocess
        cd doconce
        sudo python setup.py install
        cd ..

A much more advanced alternative to Preprocess is
`Mako <http://www.makotemplates.org>`_. Its installation is most
conveniently done by ``pip``::


        pip install Mako

This command requires ``pip`` to be installed. On Debian Linux systems,
such as Ubuntu, the installation is simply done by::


        sudo apt-get install python-pip

Alternatively, one can install from the ``pip`` `source code <http://pypi.python.org/pypi/pip>`_.

To make LaTeX
documents (without going through the reStructuredText format) you
need `ptex2tex <http://code.google.com/p/ptex2tex>`_, which is
installed by::


        svn checkout http://ptex2tex.googlecode.com/svn/trunk/ ptex2tex
        cd ptex2tex
        sudo python setup.py install
        cd latex
        sh cp2texmf.sh  # copy stylefiles to ~/texmf directory
        cd ../..

As seen, ``cp2texmf.sh`` copies some special stylefiles that
that ``ptex2tex`` potentially makes use of. Some more standard stylefiles
are also needed. These are installed by::


        sudo apt-get install texlive-latex-extra

on Debian Linux (including Ubuntu) systems. TeXShop on Mac comes with
the necessary stylefiles (if not, they can be found by googling and installed
manually in the ``~/texmf/tex/latex/misc`` directory).

The *minted* LaTeX style is offered by ``ptex2tex`` and popular among
users. This style requires the package `Pygments <http://pygments.org>`_::


        hg clone ssh://hg@bitbucket.org/birkenfeld/pygments-main pygments
        cd pygments
        sudo python setup.py install

If you use the minted style, you have to enable it by running
``ptex2tex -DMINTED`` and then ``latex -shell-escape``, see
the the section `From Doconce to Other Formats`_.

For ``rst`` output and further transformation to LaTeX, HTML, XML,
OpenOffice, and so on, one needs `docutils <http://docutils.sourceforge.net>`_.
The installation can be done by::


        svn checkout http://docutils.svn.sourceforge.net/svnroot/docutils/trunk/docutils
        cd docutils
        sudo python setup.py install
        cd ..

To use the OpenOffice suite you will typically on Debian systems install::


        sudo apt-get install unovonv libreoffice libreoffice-dmaths


There is a possibility to create PDF files from reST documents
using ReportLab instead of LaTeX. The enabling software is
`rst2pdf <http://code.google.com/p/rst2pdf>`_. Either download the tarball
or clone the svn repository, go to the ``rst2pdf`` directory and
run ``sudo python setup.py install``.


Output to ``sphinx`` requires of course `Sphinx <http://sphinx.pocoo.org>`_,
installed by::


        hg clone https://bitbucket.org/birkenfeld/sphinx
        cd sphinx
        sudo python setup.py install
        cd ..


When the output format is ``epydoc`` one needs that program too, installed
by::


        svn co https://epydoc.svn.sourceforge.net/svnroot/epydoc/trunk/epydoc epydoc
        cd epydoc
        sudo make install
        cd ..


Finally, translation to ``pandoc`` requires the
`Pandoc <http://johnmacfarlane.net/pandoc/>`_ program
(written in Haskell) to be installed::


        sudo apt-get install pandoc


*Remark.* Several of the packages above installed from source code
are also available in Debian-based system through the
``apt-get install`` command. However, we recommend installation directly
from the version control system repository as there might be important
updates and bug fixes. For ``svn`` directories, go to the directory,
run ``svn update``, and then ``sudo python setup.py install``. For
Mercurial (``hg``) directories, go to the directory, run
``hg pull; hg update``, and then ``sudo python setup.py install``.
Doconce itself is frequently updated so these commands should be
run regularly.



.. Here are some comment lines that do not affect any formatting

.. these lines are converted to comments in the output format.

.. This may have some side effects, especially in rst and sphinx

.. where lines following the comment may be taken as part of

.. the comment if there are no blank lines after the comment.


.. One can use ## and the mako preprocessor to remove comments

.. *before* doconce sees the text. That can be useful when

.. doconce comments interferes with formatting.

.. The mako tool also supports <%doc> .. </%doc>




Demos
-----


The current text is generated from a Doconce format stored in the::


        docs/manual/manual.do.txt

file in the Doconce source code tree. We have made a
`demo web page <https://doconce.googlecode.com/hg/doc/demos/manual/index.html>`_
where you can compare the Doconce source with the output in many
different formats: HTML, LaTeX, plain text, etc.

The file ``make.sh`` in the same directory as the ``manual.do.txt`` file
(the current text) shows how to run ``doconce format`` on the
Doconce file to obtain documents in various formats.

Another demo is found in::


        docs/tutorial/tutorial.do.txt

In the ``tutorial`` directory there is also a ``make.sh`` file producing a
lot of formats, with a corresponding
`web demo <https://doconce.googlecode.com/hg/doc/demos/tutorial/index.html>`_
of the results.

.. Example on including another Doconce file:



.. _doconce2formats:

From Doconce to Other Formats
=============================

Transformation of a Doconce document ``mydoc.do.txt`` to various other
formats applies the script ``doconce format``::


        Terminal> doconce format format mydoc.do.txt

or just::


        Terminal> doconce format format mydoc

The ``mako`` or ``preprocess`` programs are always used to preprocess the
file first, and options to ``mako`` or ``preprocess`` can be added after the
filename. For example::


        Terminal> doconce format latex mydoc -Dextra_sections -DVAR1=5     # preprocess
        Terminal> doconce format latex yourdoc extra_sections=True VAR1=5  # mako

The variable ``FORMAT`` is always defined as the current format when
running ``preprocess``. That is, in the last example, ``FORMAT`` is
defined as ``latex``. Inside the Doconce document one can then perform
format specific actions through tests like ``#if FORMAT == "latex"``.

Inline comments in the text are removed from the output by::


        Terminal> doconce format latex mydoc --skip_inline_comments

One can also remove all such comments from the original Doconce
file by running::


        Terminal> doconce remove_inline_comments mydoc

This action is convenient when a Doconce document reaches its final form
and comments by different authors should be removed.


HTML
----

Making an HTML version of a Doconce file ``mydoc.do.txt``
is performed by::


        Terminal> doconce format html mydoc

The resulting file ``mydoc.html`` can be loaded into any web browser for viewing.

Pandoc
------

Output in Pandoc's extended Markdown format results from::


        Terminal> doconce format pandoc mydoc

The name of the output file is ``mydoc.mkd``.
From this format one can go to numerous other formats::


        Terminal> pandoc -R -t mediawiki -o mydoc.mwk mydoc.mkd

Pandoc supports ``latex``, ``html``, ``odt`` (OpenOffice), ``docx`` (Microsoft
Word), ``rtf``, ``texinfo``, to mention some. The ``-R`` option makes
Pandoc pass raw HTML or LaTeX to the output format instead of ignoring it.
See the `Pandoc documentation <http://johnmacfarlane.net/pandoc/README.html>`_
for the many features of the ``pandoc`` program.

Pandoc is useful to go from LaTeX mathematics to, e.g., HTML or MS Word.
There are two ways (experiment to find the best one for your document):
``doconce format pandoc`` and then translating using ``pandoc``, or
``doconce format latex``, and then going from LaTeX to the desired format
using ``pandoc``.
Here is an example on the latter strategy::


        Terminal> doconce format latex mydoc
        Terminal> doconce ptex2tex mydoc
        Terminal> pandoc -f latex -t docx -o mydoc.docx mydoc.tex

When we go through ``pandoc``, only single equations or ``align*``
environments are well understood.

Quite some ``doconce replace`` and ``doconce subst`` edits might be needed
on the ``.mkd`` or ``.tex`` files to successfully have mathematics that is
well translated to MS Word.  Also when going to reStructuredText using
Pandoc, it can be advantageous to go via LaTeX.

Here is an example where we take a Doconce snippet (without title, author,
and date), maybe with some unnumbered equations, and quickly generate
HTML with mathematics displayed my MathJax::


        Terminal> doconce format pandoc mydoc
        Terminal> pandoc -t html -o mydoc.html -s --mathjax mydoc.mkd

The ``-s`` option adds a proper header and footer to the ``mydoc.html`` file.
This recipe is a quick way of makeing HTML notes with (some) mathematics.


LaTeX
-----

Making a LaTeX file ``mydoc.tex`` from ``mydoc.do.txt`` is done in two steps:
.. Note: putting code blocks inside a list is not successful in many

.. formats - the text may be messed up. A better choice is a paragraph

.. environment, as used here.


*Step 1.* Filter the doconce text to a pre-LaTeX form ``mydoc.p.tex`` for
     ``ptex2tex``::


        Terminal> doconce format latex mydoc

LaTeX-specific commands ("newcommands") in math formulas and similar
can be placed in files ``newcommands.tex``, ``newcommands_keep.tex``, or
``newcommands_replace.tex`` (see the section `Macros (Newcommands)`_).
If these files are present, they are included in the LaTeX document
so that your commands are defined.

*Step 2.* Run ``ptex2tex`` (if you have it) to make a standard LaTeX file::


        Terminal> ptex2tex mydoc

In case you do not have ``ptex2tex``, you may run a (very) simplified version::


        Terminal> doconce ptex2tex mydoc


Note that Doconce generates a ``.p.tex`` file with some preprocessor macros
that can be used to steer certain properties of the LaTeX document.
For example, to turn on the Helvetica font instead of the standard
Computer Modern font, run::


        Terminal> ptex2tex -DHELVETICA mydoc

The title, authors, and date are by default typeset in a non-standard
way to enable a nicer treatment of multiple authors having
institutions in common. However, the standard LaTeX "maketitle" heading
is also available through::


        Terminal> ptex2tex -DLATEX_HEADING=traditional mydoc

A separate titlepage can be generate by::


        Terminal> ptex2tex -DLATEX_HEADING=titlepage mydoc


The ``ptex2tex`` tool makes it possible to easily switch between many
different fancy formattings of computer or verbatim code in LaTeX
documents. After any ``!bc`` command in the Doconce source you can
insert verbatim block styles as defined in your ``.ptex2tex.cfg``
file, e.g., ``!bc cod`` for a code snippet, where ``cod`` is set to
a certain environment in ``.ptex2tex.cfg`` (e.g., ``CodeIntended``).
There are about 40 styles to choose from.

Also the ``doconce ptex2tex`` command supports preprocessor directives
for processing the ``.p.tex`` file. The command allows specifications
of code environments as well. Here is an example::


        Terminal> doconce ptex2tex -DLATEX_HEADING=traditional -DMINTED \
                  cycod=\begin{quote}\begin{python};\end{python}\end{quote} \
                  fpro=minted fcod=minted sys=verbatim

Note that semicolon must be used to separate the begin and end
commands, unless only the environment name is given (such as
``verbatim`` above, which implies ``\begin{verbatim}`` and ``\end{verbatim}``).
The value ``minted`` can be used for code environments where the
language is specified, as in ``fpro``, where ``minted`` implies
``\begin{python}{fortran}``. There is a similar support for ``ans``:
``cppcod=ans`` imples ``\begin{c++}`` and ``\end{c++}`` using the
``anslistings`` package.

*Step 2b (optional).* Edit the ``mydoc.tex`` file to your needs.
For example, you may want to substitute ``section`` by ``section*`` to
avoid numbering of sections, you may want to insert linebreaks
(and perhaps space) in the title, etc. This can be automatically
edited with the aid of the ``doconce replace`` and ``doconce subst``
commands. The former works with substituting text directly, while the
latter performs substitutions using regular expressions.
Here are some examples::


        Terminal> doconce replace 'section{' 'section*{' mydoc.tex
        Terminal> doconce subst 'title\{(.+)Using (.+)\}' \
                  'title{\g<1> \\\\ [1.5mm] Using \g<2>' mydoc.tex

A lot of tailored fixes to the LaTeX document can be done by
an appropriate set of text replacements and regular expression
substitutions. You are anyway encourged to make a script for
generating PDF from the LaTeX file.

*Step 3.* Compile ``mydoc.tex``
and create the PDF file::


        Terminal> latex mydoc
        Terminal> latex mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex mydoc
        Terminal> dvipdf mydoc

If one wishes to use the ``Minted_Python``, ``Minted_Cpp``, etc.,
environments in ``ptex2tex`` for typesetting code (specified, e.g., in
the ``*pro`` and ``*cod`` environments in ``.ptex2tex.cfg`` or
``$HOME/.ptex2tex.cfg``), the ``minted`` LaTeX package is needed.  This
package is included by running ``doconce format`` with the ``-DMINTED``
option::


        Terminal> ptex2tex -DMINTED mydoc

In this case, ``latex`` must be run with the
``-shell-escape`` option::


        Terminal> latex -shell-escape mydoc
        Terminal> latex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> latex -shell-escape mydoc
        Terminal> dvipdf mydoc



PDFLaTeX
--------

Running ``pdflatex`` instead of ``latex`` follows almost the same steps,
but the start is::


        Terminal> doconce format latex mydoc

Then ``ptex2tex`` is run as explained above, and finally::


        Terminal> pdflatex -shell-escape mydoc
        Terminal> makeindex mydoc   # if index
        Terminal> bibitem mydoc     # if bibliography
        Terminal> pdflatex -shell-escape mydoc


Plain ASCII Text
----------------

We can go from Doconce "back to" plain untagged text suitable for viewing
in terminal windows, inclusion in email text, or for insertion in
computer source code::


        Terminal> doconce format plain mydoc.do.txt  # results in mydoc.txt


reStructuredText
----------------

Going from Doconce to reStructuredText gives a lot of possibilities to
go to other formats. First we filter the Doconce text to a
reStructuredText file ``mydoc.rst``::


        Terminal> doconce format rst mydoc.do.txt

We may now produce various other formats::


        Terminal> rst2html.py  mydoc.rst > mydoc.html # html
        Terminal> rst2latex.py mydoc.rst > mydoc.tex  # latex
        Terminal> rst2xml.py   mydoc.rst > mydoc.xml  # XML
        Terminal> rst2odt.py   mydoc.rst > mydoc.odt  # OpenOffice


The OpenOffice file ``mydoc.odt`` can be loaded into OpenOffice and
saved in, among other things, the RTF format or the Microsoft Word format.
However, it is more convenient to use the program ``unovonv``
to convert between the many formats OpenOffice supports *on the command line*.
Run::


        Terminal> unoconv --show

to see all the formats that are supported.
For example, the following commands take
``mydoc.odt`` to Microsoft Office Open XML format,
classic MS Word format, and PDF::


        Terminal> unoconv -f ooxml mydoc.odt
        Terminal> unoconv -f doc mydoc.odt
        Terminal> unoconv -f pdf mydoc.odt


*Remark about Mathematical Typesetting.* At the time of this writing, there is no easy way to go from Doconce
and LaTeX mathematics to reST and further to OpenOffice and the
"MS Word world". Mathematics is only fully supported by ``latex`` as
output and to a wide extent also supported by the ``sphinx`` output format.
Some links for going from LaTeX to Word are listed below.

 * `<http://ubuntuforums.org/showthread.php?t=1033441>`_

 * `<http://tug.org/utilities/texconv/textopc.html>`_

 * `<http://nileshbansal.blogspot.com/2007/12/latex-to-openofficeword.html>`_

Sphinx
------

Sphinx documents demand quite some steps in their creation. We have automated
most of the steps through the ``doconce sphinx_dir`` command::


        Terminal> doconce sphinx_dir author="authors' names" \
                  title="some title" version=1.0 dirname=sphinxdir \
                  theme=mytheme file1 file2 file3 ...

The keywords ``author``, ``title``, and ``version`` are used in the headings
of the Sphinx document. By default, ``version`` is 1.0 and the script
will try to deduce authors and title from the doconce files ``file1``,
``file2``, etc. that together represent the whole document. Note that
none of the individual Doconce files ``file1``, ``file2``, etc. should
include the rest as their union makes up the whole document.
The default value of ``dirname`` is ``sphinx-rootdir``. The ``theme``
keyword is used to set the theme for design of HTML output from
Sphinx (the default theme is ``'default'``).

With a single-file document in ``mydoc.do.txt`` one often just runs::


        Terminal> doconce sphinx_dir mydoc

and then an appropriate Sphinx directory ``sphinx-rootdir`` is made with
relevant files.

The ``doconce sphinx_dir`` command generates a script
``automake-sphinx.py`` for compiling the Sphinx document into an HTML
document.  One can either run ``automake-sphinx.py`` or perform the
steps in the script manually, possibly with necessary modifications.
You should at least read the script prior to executing it to have
some idea of what is done.

Te ``doconce sphinx_dir`` script copies directories named ``figs`` or ``figures``
over to the Sphinx directory so that figures are accessible in the
Sphinx compilation.  If figures or movies are located in other
directories, ``automake-sphinx.py`` must be edited accordingly.
Links to local files (not ``http:`` or ``file:`` URLs) must be placed
in the ``_static`` subdirectory of the Sphinx directory. The
utility ``doconce sphinxfix_localURLs`` is run to check for local
links: for each such link, say ``dir1/dir2/myfile.txt`` it replaces
the link by ``_static/myfile.txt`` and copies ``dir1/dir2/myfile.txt``
to a local ``_static`` directory (in the same directory as the
script is run). The user must copy all ``_static/*`` files to the
``_static`` subdirectory of the Sphinx directory. Links to local
HTML files (say another Sphinx document) may present a problem if they link
to other files: all necessary files must be correctly copied to
the ``_static`` subdirectory of the Sphinx directory.
It may be wise to place relevant files in a ``_static`` directory
and link to these directly from the Doconce document - then links
to not need to be modified when creating  a Sphinx version of
the document.

Doconce comes with a collection of HTML themes for Sphinx documents.
These are packed out in the Sphinx directory, the ``conf.py``
configuration file for Sphinx is edited accordingly, and a script
``make-themes.sh`` can make HTML documents with one or more themes.
For example,
to realize the themes ``fenics`` and ``pyramid``, one writes::


        Terminal> ./make-themes.sh fenics pyramid

The resulting directories with HTML documents are ``_build/html_fenics``
and ``_build/html_pyramid``, respectively. Without arguments,
``make-themes.sh`` makes all available themes (!).

If it is not desirable to use the autogenerated scripts explained
above, here is the complete manual procedure of generating a
Sphinx document from a file ``mydoc.do.txt``.

*Step 1.* Translate Doconce into the Sphinx format::


        Terminal> doconce format sphinx mydoc


*Step 2.* Create a Sphinx root directory
either manually or by using the interactive ``sphinx-quickstart``
program. Here is a scripted version of the steps with the latter::


        mkdir sphinx-rootdir
        sphinx-quickstart <<EOF
        sphinx-rootdir
        n
        _
        Name of My Sphinx Document
        Author
        version
        version
        .rst
        index
        n
        y
        n
        n
        n
        n
        y
        n
        n
        y
        y
        y
        EOF

The autogenerated ``conf.py`` file
may need some edits if you want to specific layout (Sphinx themes)
of HTML pages. The ``doconce sphinx_dir`` generator makes an extended ``conv.py``
file where, among other things, several useful Sphinx extensions
are included.


*Step 3.* Copy the ``mydoc.rst`` file to the Sphinx root directory::


        Terminal> cp mydoc.rst sphinx-rootdir

If you have figures in your document, the relative paths to those will
be invalid when you work with ``mydoc.rst`` in the ``sphinx-rootdir``
directory. Either edit ``mydoc.rst`` so that figure file paths are correct,
or simply copy your figure directories to ``sphinx-rootdir``.
Links to local files in ``mydoc.rst`` must be modified to links to
files in the ``_static`` directory, see comment above.

*Step 4.* Edit the generated ``index.rst`` file so that ``mydoc.rst``
is included, i.e., add ``mydoc`` to the ``toctree`` section so that it becomes::


        .. toctree::
           :maxdepth: 2
        
           mydoc

(The spaces before ``mydoc`` are important!)

*Step 5.* Generate, for instance, an HTML version of the Sphinx source::


        make clean   # remove old versions
        make html


Sphinx can generate a range of different formats:
standalone HTML, HTML in separate directories with ``index.html`` files,
a large single HTML file, JSON files, various help files (the qthelp, HTML,
and Devhelp projects), epub, LaTeX, PDF (via LaTeX), pure text, man pages,
and Texinfo files.

*Step 6.* View the result::


        Terminal> firefox _build/html/index.html


Note that verbatim code blocks can be typeset in a variety of ways
depending the argument that follows ``!bc``: ``cod`` gives Python
(``code-block:: python`` in Sphinx syntax) and ``cppcod`` gives C++, but
all such arguments can be customized both for Sphinx and LaTeX output.


Wiki Formats
------------

There are many different wiki formats, but Doconce only supports three:
`Googlecode wiki <http://code.google.com/p/support/wiki/WikiSyntax<Google Code>>`_, , MediaWiki, and Creole Wiki. These formats are called
``gwiki``, ``mwiki``, and ``cwiki``, respectively.
Transformation from Doconce to these formats is done by::


        Terminal> doconce format gwiki mydoc.do.txt
        Terminal> doconce format mwiki mydoc.do.txt
        Terminal> doconce format cwiki mydoc.do.txt


The Googlecode wiki document, ``mydoc.gwiki``, is most conveniently stored
in a directory which is a clone of the wiki part of the Googlecode project.
This is far easier than copying and pasting the entire text into the
wiki editor in a web browser.

When the Doconce file contains figures, each figure filename must in
the ``.gwiki`` file be replaced by a URL where the figure is
available. There are instructions in the file for doing this. Usually,
one performs this substitution automatically (see next section).

From the MediaWiki format one can go to other formats with aid
of `mwlib <http://pediapress.com/code/>`_. This means that one can
easily use Doconce to write `Wikibooks <http://en.wikibooks.org>`_
and publish these in PDF and MediaWiki format.
At the same time, the book can also be published as a
standard LaTeX book or a Sphinx web document.


Tweaking the Doconce Output
---------------------------

Occasionally, one would like to tweak the output in a certain format
from Doconce. One example is figure filenames when transforming
Doconce to reStructuredText. Since Doconce does not know if the
``.rst`` file is going to be filtered to LaTeX or HTML, it cannot know
if ``.eps`` or ``.png`` is the most appropriate image filename.
The solution is to use a text substitution command or code with, e.g., sed,
perl, python, or scitools subst, to automatically edit the output file
from Doconce. It is then wise to run Doconce and the editing commands
from a script to automate all steps in going from Doconce to the final
format(s). The ``make.sh`` files in ``docs/manual`` and ``docs/tutorial``
constitute comprehensive examples on how such scripts can be made.



The Doconce Markup Language
===========================

The Doconce format introduces four constructs to markup text:
lists, special lines, inline tags, and environments.

Lists
-----

An unordered bullet list makes use of the ``*`` as bullet sign
and is indented as follows::


           * item 1
        
           * item 2
        
             * subitem 1, if there are more
               lines, each line must
               be intended as shown here
        
             * subitem 2,
               also spans two lines
        
           * item 3


This list gets typeset as

   * item 1

   * item 2

     * subitem 1, if there are more
       lines, each line must
       be intended as shown here

     * subitem 2,
       also spans two lines


   * item 3

In an ordered list, each item starts with an ``o`` (as the first letter
in "ordered")::


           o item 1
        
           o item 2
        
             * subitem 1
        
             * subitem 2
        
           o item 3


resulting in

  1. item 1

  2. item 2

     * subitem 1

     * subitem 2


  3. item 3

Ordered lists cannot have an ordered sublist, i.e., the ordering
applies to the outer list only.

In a description list, each item is recognized by a dash followed
by a keyword followed by a colon::


           - keyword1: explanation of keyword1
        
           - keyword2: explanation
             of keyword2 (remember to indent properly
             if there are multiple
             lines)


The result becomes

   keyword1: 
     explanation of keyword1

   keyword2: 
     explanation
     of keyword2 (remember to indent properly
     if there are multiple
     lines)

Special Lines
-------------

The Doconce markup language has a concept called *special lines*.
Such lines starts with a markup at the very beginning of the
line and are used to mark document title, authors, date,
sections, subsections, paragraphs., figures, movies, etc.


*Heading with Title and Author(s).* Lines starting with ``TITLE:``, ``AUTHOR:``, and ``DATE:`` are optional and used
to identify a title of the document, the authors, and the date. The
title is treated as the rest of the line, so is the date, but the
author text consists of the name and associated institution(s) with
the syntax::


        name at institution1 and institution2 and institution3

The ``at`` with surrounding spaces
is essential for adding information about institution(s)
to the author name, and the ``and`` with surrounding spaces is
essential as delimiter between different institutions.
An email address can optionally be included, using the syntax::


        name Email: somename@site.net at institution1 and institution2

Multiple authors require multiple ``AUTHOR:`` lines. All information
associated with ``TITLE:`` and ``AUTHOR:`` keywords must appear on a single
line.  Here is an example::


        TITLE: On an Ultimate Markup Language
        AUTHOR: H. P. Langtangen at Center for Biomedical Computing, Simula Research Laboratory and Dept. of Informatics, Univ. of Oslo
        AUTHOR: Kaare Dump Email: dump@cyb.space.com at Segfault, Cyberspace Inc.
        AUTHOR: A. Dummy Author
        DATE: November 9, 2016

Note how one can specify a single institution, multiple institutions,
and no institution. In some formats (including ``rst`` and ``sphinx``)
only the author names appear. Some formats have
"intelligence" in listing authors and institutions, e.g., the plain text
format::


        Hans Petter Langtangen [1, 2]
        Kaare Dump  (dump@cyb.space.com) [3]
        A. Dummy Author
        
        [1] Center for Biomedical Computing, Simula Research Laboratory
        [2] Department of Informatics, University of Oslo
        [3] Segfault, Cyberspace Inc.

Similar typesetting is done for LaTeX and HTML formats.

The current date can be specified as ``today``.


*Section Headings.* Section headings are recognized by being surrounded by equal signs (=) or
underscores before and after the text of the headline. Different
section levels are recognized by the associated number of underscores
or equal signs (=):

   * 9 ``=`` characters for chapters

   * 7 for sections

   * 5 for subsections

   * 3 for subsubsections

   * 2 *underscrores* (only! - it looks best) for paragraphs
     (paragraph heading will be inlined)

Headings can be surrounded by as many blanks as desired.

Doconce also supports abstracts. This is typeset as a paragraph, but
*must* be followed by a section heading (everything up to the first
section heading is taken as part of the text of the abstract).


Here are some examples::


        __Abstract.__ The following text just attempts to exemplify
        various section headings.
        
        ========= Example on a Chapter Heading =========
        
        Some text.
        
        
        ======= Example on a Section Heading =======
        
        The running text goes here.
        
        
        ===== Example on a Subsection Heading =====
        
        The running text goes here.
        
        ===Example on a Subsubsection Heading===
        
        The running text goes here.
        
        __A Paragraph.__ The running text goes here.


Special Lines
=============

Figures
-------

Figures are recognized by the special line syntax::


        FIGURE:[filename, height=xxx width=yyy scale=zzz] possible caption

The filename can be without extension, and Doconce will search for an
appropriate file with the right extension. If the extension is wrong,
say ``.eps`` when requesting an HTML format, Doconce tries to find another
file, and if not, the given file is converted to a proper format
(using ImageMagick's ``convert`` utility).

The height, width, and scale keywords (and others) can be included
if desired and may have effect for some formats. Note the comma
between the sespecifications and that there should be no space
around the = sign.

Note also that, like for ``TITLE:`` and ``AUTHOR:`` lines, all information
related to a figure line *must be written on the same line*. Introducing
newlines in a long caption will destroy the formatting (only the
part of the caption appearing on the same line as ``FIGURE:`` will be
included in the formatted caption).


.. _fig:viz:

.. figure:: figs/streamtubes.png
   :width: 400

   *Streamtube visualization of a fluid flow*  (fig:viz)


Combining several image files into one can be done by the
``convert`` and ``montage`` programs from the ImageMagick suite::


        montage file1.png file2.png ... file4.png -geometry +2+2  result.png
        montage file1.png file2.png -tile x1 result.png
        montage file1.png file2.png -tile 1x result.png
        
        convert -background white file1.png file2.png +append tmp.png

Use ``+append`` for stacking left to right, ``-append`` for top to bottom.
The positioning of the figures can be controlled by ``-gravity``.

Movies
------

Here is an example on the ``MOVIE:`` keyword for embedding movies. This
feature works well for the ``latex``, ``html``, ``rst``, and ``sphinx`` formats.
Other formats try to generate some HTML file and link to that file
for showing the movie::


        MOVIE: [filename, height=xxx width=yyy] possible caption


.. latex/PDF format can make use of the movie15 package for displaying movies,

.. or just plain \h`run: ...`_{...}


.. raw:: html
        
        <embed src="figs/mjolnir.mpeg" width=600 height=470 autoplay="false" loop="true"></embed>
        <p>
        <em></em>
        </p>



.. MOVIE: [figs/wavepacket.gif, width=600 height=470]


.. MOVIE: [figs/wavepacket2.mpeg, width=600 height=470]


The LaTeX format results in a file that can either make use of
the movie15 package (requires the PDF to be shown in Acrobat Reader)
or just a plain address to the movie. The HTML, reST, and
Sphinx formats will play
the movie right away by embedding the file in a standard HTML code,
provided the output format is HTML.
For all other formats a URL to an HTML file, which can play the code,
is inserted in the output document.

When movies are embedded in the PDF file via LaTeX and
the ``movie15`` package wanted, one has to turn on the preprocessor
variable ``MOVIE15``. There is an associated variable
``EXTERNAL_MOVIE_VIEWER`` which can be defined to launch an external
viewer when displaying the PDF file (in Acrobat Reader)::


        Terminal> ptex2tex -DMOVIE15 -DEXTERNAL_MOVIE_VIEWER mydoc


The HTML, reST, and Sphinx formats can also treat filenames of the form
``myframes*.png``. In that case, an HTML file for showing the sequence of frames
is generated, and a link to this file is inserted in the output document.
That is, a simple "movie viewer" for the frames is made.

Many publish their scientific movies on YouTube, and Doconce recognizes
YouTube URLs as movies. When the output is an HTML file, the movie will
be embedded, otherwise a URL to the YouTube page is inserted.
You should equip the ``MOVIE:`` command with the right width and height
of embedded YouTube movies (the parameters appear when you request
the embedded HTML code for the movie on the YouTube page).



Copying Computer Code from Source Files
---------------------------------------

Another type of special lines starts with ``@@@CODE`` and enables copying
of computer code from a file directly into a verbatim environment, see
the section `Blocks of Verbatim Computer Code`_ below.


.. _inline:tagging:

Inline Tagging
--------------

Doconce supports tags for *emphasized phrases*, **boldface phrases**,
and ``verbatim text`` (also called type writer text, for inline code)
plus LaTeX/TeX inline mathematics, such as v = sin(x).

Emphasized text is typeset inside a pair of asterisk, and there should
be no spaces between an asterisk and the emphasized text, as in::


        *emphasized words*


Boldface font is recognized by an underscore instead of an asterisk::


        _several words in boldface_ followed by *ephasized text*.

The line above gets typeset as
**several words in boldface** followed by *ephasized text*.

Verbatim text, typically used for short inline code,
is typeset between back-ticks::


        `call myroutine(a, b)` looks like a Fortran call
        while `void myfunc(double *a, double *b)` must be C.

The typesetting result looks like this:
``call myroutine(a, b)`` looks like a Fortran call
while ``void myfunc(double *a, double *b)`` must be C.

It is recommended to have inline verbatim text on the same line in
the Doconce file, because some formats (LaTeX and ``ptex2tex``) will have
problems with inline verbatim text that is split over two lines.

Watch out for mixing back-ticks and asterisk (i.e., verbatim and
emphasized code): the Doconce interpreter is not very smart so inline
computer code can soon lead to problems in the final format. Go back to the
Doconce source and modify it so the format to which you want to go
becomes correct (sometimes a trial and error process - sticking to
very simple formatting usually avoids such problems).

Web addresses with links are typeset as::


        some URL like "Doconce": "http://code.google.com/p/doconce"

which appears as some URL like `Search Google <http://google.com>`_.
The space after colon is optional.
Links to files ending in ``.txt``, ``.html``, ``.pdf``, ``.py``, ``.f``,
``.f77``, ``.f90``, ``.f95``, ``.sh``, ``.csh``, ``.ksh``, ``.zsh``,
``.c``, ``.cpp``, ``.cxx``, ``.pl``, and ``.java`` follows the same
setup::


        see the "Doconce Manual": "manual.do.txt".

which appears as see the `Doconce Manual <manual.do.txt>`_.
If you want to view such source code files *in the browser*,
rather than dowloading the file, we recommend to transform
the source code file to HTML format by running
``pygmentize``, e.g.::


        Terminal> pygmentize -l bash -f html -O full,style=emacs \
                  -o _static/make.sh.html subdir/make.sh

Then you can link to ``_static/make.sh.html`` instead of
``subdir/make.sh``. Or you can do both versions::


        See the code URL:"src/myprog.py" ("view: "_static/myprog.py.html").


Links to files with other extensions must be realized
*with the filename as link text*, written as
the keyword URL, followed by a colon, and then the filename enclosed
in double quotes::


        URL: "manual.html"

resulting in the link `<manual.html>`_.

.. This is now automatically carried out by the autogenerated

.. script for sphinx:

.. For such local links to

.. work with the ``sphinx`` format, the ``.rst`` file needs a fix, carried

.. out by

.. !bc sys

.. doconce sphinxfix_localURLs mydoc.rst

.. 


.. (The files, such as ``manual.html``, are then copied to a subdirectory

.. ``_static``, which must be manually copied to the Sphinx directory's

.. ``_static`` directory - links in the ``.rst`` files are automatically

.. adjusted.)


To have the URL address itself as link text, put an "URL" or URL
before the address enclosed in double quotes::


        Click on this link: URL:"http://code.google.com/p/doconce".

resulting in Click on this link: `<http://code.google.com/p/doconce>`_.

Doconce also supports inline comments in the text::


        [name: comment]

where ``name`` is the name of the author of the command, and ``comment`` is a
plain text text. (**hpl**: Note that there must be a space after the colon,
otherwise the comment is not recognized. Inline comments
can span
several lines,
if desired.)
The name and comment are visible in the output unless ``doconce format``
is run with a command-line argument ``--skip_inline_comments``
(see the chapter `From Doconce to Other Formats`_ for an example). Inline comments
are helpful during development of a document since different authors
and readers can comment on formulations, missing points, etc.
All such comments can easily be removed from the ``.do.txt`` file
(see the chapter `From Doconce to Other Formats`_).

Inline mathematics is written as in LaTeX, i.e., inside dollar signs.
Most formats leave this syntax as it is (including to dollar signs),
hence nice math formatting is only obtained in LaTeX (Epytext has some
inline math support that is utilized).  However, mathematical
expressions in LaTeX syntax often contains special formatting
commands, which may appear annoying in plain text. Doconce therefore
supports an extended inline math syntax where the writer can provide
an alternative syntax suited for formats close to plain ASCII::


        Here is an example on a linear system
        ${\bf A}{\bf x} = {\bf b}$|$Ax=b$,
        where $\bf A$|$A$ is an $n\times n$|$nxn$ matrix, and
        $\bf x$|$x$ and $\bf b$|$b$ are vectors of length $n$|$n$.

That is, we provide two alternative expressions, both enclosed in
dollar signs and separated by a pipe symbol, the expression to the
left is used in LaTeX, while the expression to the right is used for
all other formats.  The above text is typeset as "Here is an example
on a linear system Ax=b, where A
is an nxn matrix, and x and b
are vectors of length n."

Comments
--------

Comments intended to be visible in the output document and read by
readers are known as *inline comments* in Doconce and described
in the section `Inline Tagging`_.

Here we address comments in the Doconce source file that are not
intended to be visible in the output document. Basic comment
lines start with the hash ``#``::


        #
        # Here are some comment lines that do not affect any formatting.
        # These lines are converted to comments in the output format.
        #

Such comment lines may have some side effects in the ``rst`` and ``sphinx``
formats because following lines are taken as part of the comment if
there is not a blank line after the comment.

The Mako preprocessor supports comments that are filtered out *before*
Doconce starts translating the document. Such comments are very valuable
as they will never interfere with the output format and they are only
present in the Doconce source. Mako has two types of comments:
lines starting with a double hash ``##`` and lines enclosed by
the ``<%doc>`` (beginning) and ``<%doc/>`` (closing) tags.

If you need a lot of comments in the Doconce file, consider using
Mako comments instead of the single hash, unless you want to
comments to be in the source code of the output document.


Cross-Referencing
-----------------

References and labels are supported. The syntax is simple::


        label{section:verbatim}   # defines a label
        For more information we refer to Section ref{section:verbatim}.

This syntax is close that that of labels and cross-references in
LaTeX. When the label is placed after a section or subsection heading,
the plain text, Epytext, and StructuredText formats will simply
replace the reference by the title of the (sub)section.  All labels
will become invisible, except those in math environments.  In the
``rst`` and ``sphinx`` formats, the end effect is the same, but
the "label" and "ref" commands are first translated to the proper
reST commands by ``doconce format``. In the HTML and (Google
Code) wiki formats, labels become anchors and references become links,
and with LaTeX "label" and "ref" are just equipped with backslashes so
these commands work as usual in LaTeX.

It is, in general, recommended to use labels and references for
(sub)sections, equations, and figures only.
By the way, here is an example on referencing Figure `fig:viz`_
(the label appears in the figure caption in the source code of this document).
Additional references to the sections `LaTeX Blocks of Mathematical Text`_ and `Macros (Newcommands)`_ are
nice to demonstrate, as well as a reference to equations,
say Equation (my:eq1)--Equation (my:eq2). A comparison of the output and
the source of this document illustrates how labels and references
are handled by the format in question.

Hyperlinks to files or web addresses are handled as explained
in the section `Inline Tagging`_.

Index and Bibliography
----------------------

An index can be created for the ``latex``, ``rst``, and ``sphinx`` formats
by the ``idx`` keyword, following a LaTeX-inspired syntax::


        idx{some index entry}
        idx{main entry!subentry}
        idx{`verbatim_text` and more}

The exclamation mark divides a main entry and a subentry. Backquotes
surround verbatim text, which is correctly transformed in a LaTeX setting to::


        \index{verbatim\_text@\texttt{\rm\smaller verbatim\_text and more}}

Everything related to the index simply becomes invisible in plain
text, Epytext, StructuredText, HTML, and wiki formats.  Note: ``idx``
commands should be inserted outside paragraphs, not in between the
text as this may cause some strange behaviour of reST and
Sphinx formatting.  As a recommended rule, index items are naturally
placed right after section headings, before the text begins, while
index items related to a paragraph should be placed above the
paragraph one a separate line (and not in between the text or between
the paragraph heading and the text body, although this works fine if
LaTeX is the output format).

Literature citations also follow a LaTeX-inspired style::


        as found in cite{Larsen_1986,Nielsen_Kjeldstrup_1999}.

Citation labels can be separated by comma. In LaTeX, this is directly
translated to the corresponding ``cite`` command; in reST
and Sphinx the labels can be clicked, while in all the other text
formats the labels are consecutively numbered so the above citation
will typically look like::


        as found in [3][14]

if ``Larsen_1986`` has already appeared in the 3rd citation in the document
and ``Nielsen_Kjeldstrup_1999`` is a new (the 14th) citation. The citation labels
can be any sequence of characters, except for curly braces and comma.

The bibliography itself is specified by the special keyword ``BIBFILE:``,
which is optionally followed by a BibTeX file, having extension ``.bib``,
a corresponding reST bibliography, having extension ``.rst``,
or simply a Python dictionary written in a file with extension ``.py``.
The dictionary in the latter file should have the citation labels as
keys, with corresponding values as the full reference text for an item
in the bibliography. Doconce markup can be used in this text, e.g.::


        {
        'Nielsen_Kjeldstrup_1999': """
        K. Nielsen and A. Kjeldstrup. *Some Comments on Markup Languages*.
        URL:"http://some.where.net/nielsen/comments", 1999.
        """,
        'Larsen_1986':
        """
        O. B. Larsen. On Markup and Generality.
        *Personal Press*. 1986.
        """
        }

In the LaTeX format, the ``.bib`` file will be used in the standard way,
in the ``rst`` and ``sphinx`` formats, the ``.rst`` file will be
copied into the document at the place where the ``BIBFILE:`` keyword
appears, while all other formats will make use of the Python dictionary
typeset as an ordered Doconce list, replacing the ``BIBFILE:`` line
in the document.

At present, only one file with bibliographic references can be used.

.. see ketch/tex2rst for nice bibtex to rst converter which could

.. be used here


Conversion of BibTeX databases to reST format can be
done by the `bibliograph.parsing <http://pypi.python.org/pypi/bibliograph.parsing/>`_ tool.

Finally, we here test the citation command and bibliography by
citing a book [Python:Primer:09]_, a paper [Osnes:98]_,
and both of them simultaneously [Python:Primer:09]_ [Osnes:98]_.

(**somereader**: comments, citations, and references in the latex style
is a special feature of doconce :-) )


Tables
------

A table like

============  ============  ============  
    time        velocity    acceleration  
============  ============  ============  
         0.0        1.4186         -5.01  
         2.0      1.376512        11.919  
         4.0        1.1E+1     14.717624  
============  ============  ============  

is built up of pipe symbols and dashes::


          |--------------------------------|
          |time  | velocity | acceleration |
          |--------------------------------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|

The pipes and column values do not need to be aligned (but why write
the Doconce source in an ugly way?). In the line below the heading,
one can insert the characters ``c``, ``r``, or ``l`` to specify the
alignment of the columns (centered, right, or left, respectively).
Similar character can be inserted in the line above the header to
algn the headings. Pipes ``|`` can also be inserted to indicate
vertical rules in LaTeX tables (they are ignored for other formats).
Note that not all formats offer alignment of heading or entries
in tables (``rst`` and ``sphinx`` are examples). Also note that
Doconce tables are very simple: neither entries nor
headings can span several columns or rows. When that functionality
is needed, one can make use of the preprocessor and if-tests on
the format and insert format-specific code for tables.



Exercises, Problems, or Projects
--------------------------------

Doconce has special support for three types of "exercises", named
*exercise*, *problem*, or *project*.
These are all typeset as special kind of
sections. Such sections start with a subsection or subsubsection
headline, indicated by 3 or 5 ``=`` characters, and last up to the
next headline or the end of the file. The headline itself must
consists of the word "Exercise", "Problem", or "Project", followed
by a colon and a title of the exercise, problem, or project.
The next line(s) may contain a label and specification of the
name of result file (if the answer to the exercise is to be handed
it) and a solution file::


        ===== Project: Determine the Distance to the Moon =====
        label{proj:moondist} file=earth2moon.pdf
        solution=eart2moon_sol.do.txt
        
        Here goes the running text of the project....
        
        __Hint 1.__ Do not plan a travel to the moon.
        
        __Hint 2.__ Wikipedia is always helpful.

Doconce will recognize the exercise, problem, or project *title*,
the *label*, the *result file*, the *solution file* (if any of
these three entities is present), the *text*, and a sequence of
*hints*. Tailored formatting of exercises in special output formats
can make use of this. For example, one can image web formats where
the hints are displayed one by one when needed and where the result
file can be uploaded. One can also think of mechanisms for downloading
the solution file if the result file meets certain criteria.
Doconce does not yet generate such functionality in any output format,
but this is an intended future feature to be impelemented.

Because exercises, problems, and projects are typeset as ordinary
sections (this is the most general approach that will work for many
formats), one must refer to an exercise, problem, or project
by its label, which normally will translate to the section number
(in LaTeX, for instance) or a link to the title of the section.
The *title* is typeset without any leading "Exercise:", "Problem:",
or "Project:" word, so that references like "see Problem ..."
works well in all formats ("..." will be a number in LaTeX and
the problem title in most other formats).

It is recommended to collect all exercises as subsetions (or subsubsections)
under a section (or subsection) named "Exercises", "Problems", or
"Projects".


.. _sec:verbatim:blocks:

Blocks of Verbatim Computer Code
--------------------------------

Blocks of computer code, to be typeset verbatim, must appear inside a
"begin code" ``!bc`` keyword and an "end code" ``!ec`` keyword. Both
keywords must be on a single line and *start at the beginning of the
line*.  Before such a code block there must be a plain sentence
(at least if successful transformation to reST and
ASCII-type formats is desired). For example, a code block cannot come
directly after a section/paragraph heading or a table.

There may be an argument after the ``!bc`` tag to specify a
certain environment (for ``ptex2tex`` or Sphinx) for typesetting
the verbatim code. For instance, ``!bc dat`` corresponds to
the data file environment and ``!bc cod`` is typically
used for a code snippet. There are some predefined environments
explained below. If there is
no argument specifying the environment, one assumes some plain
verbatim typesetting (for ``ptex2tex`` this means the ``ccq`` environment,
which is defined in the config file ``.ptex2tex.cfg``,
while for Sphinx it defaults to the ``python`` environment).

Since the config file for ``ptex2tex`` can define what some environment
maps onto with respect to typesetting, a similar possibility is
supported for Sphinx as well.  The argument after ``!bc`` is in case of
Sphinx output mapped onto a valid Pygments language for typesetting of
the verbatim block by Pygments. This mapping takes place in an
optional comment to be inserted in the Doconce source file, e.g.::


        # sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

Here, three arguments are defined: ``pycod`` for Python code,
``cod`` also for Python code, ``cppcod`` for C++ code, and ``sys``
for terminal sessions. The same arguments would be defined
in ``.ptex2tex.cfg`` for how to typeset the blocks in LaTeX using
various verbatim styles (Pygments can also be used in a LaTeX
context).

By default, ``pro`` is used for complete programs in Python, ``cod`` is
for a code snippet in Python, while ``xcod`` and ``xpro`` implies computer
language specific typesetting where ``x`` can be ``f`` for Fortran, ``c``
for C, ``cpp`` for C++, ``sh`` for Unix shells, ``pl`` for Perl, ``m`` for
Matlab, ``cy`` for Cython, and ``py`` for Python.  The argument ``sys``
means by default ``console`` for Sphinx and ``CodeTerminal`` (ptex2tex
environent) for LaTeX. Other specifications are ``dat`` for a data file
or print out, and ``ipy`` for interactive Python sessions (the latter
does not introduce any environment  in ``sphinx`` output, as interactive
sessions are automatically recognized and handled).  All these
definitions of the arguments after ``!bc`` can be redefined in the
``.ptex2tex.cfg`` configuration file for ptex2tex/LaTeX and in the
``sphinx code-blocks`` comments for Sphinx. Support for other languages
is easily added.

.. (Any sphinx code-block comment, whether inside verbatim code

.. blocks or outside, yields a mapping between bc arguments

.. and computer languages. In case of muliple definitions, the

.. first one is used.)


The enclosing ``!ec`` tag of verbatim computer code blocks must
be followed by a newline.  A common error in list environments is to
forget to indent the plain text surrounding the code blocks. In
general, we recommend to use paragraph headings instead of list items
in combination with code blocks (it usually looks better, and some
common errors are naturally avoided).

Here is a verbatim code block with Python code (``pycod`` style)::


        # regular expressions for inline tags:
        inline_tag_begin = r'(?P<begin>(^|\s+))'
        inline_tag_end = r'(?P<end>[.,?!;:)\s])'
        INLINE_TAGS = {
            'emphasize':
            r'%s\*(?P<subst>[^ `][^*`]*)\*%s' % \
            (inline_tag_begin, inline_tag_end),
            'verbatim':
            r'%s`(?P<subst>[^ ][^`]*)`%s' % \
            (inline_tag_begin, inline_tag_end),
            'bold':
            r'%s_(?P<subst>[^ `][^_`]*)_%s' % \
            (inline_tag_begin, inline_tag_end),
        }

And here is a C++ code snippet (``cppcod`` style)::


        void myfunc(double* x, const double& myarr) {
            for (int i = 1; i < myarr.size(); i++) {
                myarr[i] = myarr[i] - x[i]*myarr[i-1]
            }
        }


.. When showing copy from file in !bc envir, intent a character - otherwise

.. ptex2tex is confused and starts copying...

Computer code can be copied directly from a file, if desired. The syntax
is then::


         @@@CODE myfile.f
         @@@CODE myfile.f fromto: subroutine\s+test@^C\s{5}END1

The first line implies that all lines in the file ``myfile.f`` are
copied into a verbatim block, typset in a ``!bc Xpro`` environment, where
``X`` is the extension of the filename, here ``f`` (i.e., the environment
becomes ``!bc fpro`` and will typically lead to some Fortran-style
formatting in Linux and Sphinx).  The
second line has a ``fromto:`` directive, which implies copying code
between two lines in the code, typset within a !`bc Xcod`
environment (again, ``X`` is the filename extension, implying the
type of file). Note that the ``pro`` and ``cod`` arguments are only used for LaTeX
and Sphinx output, all other formats will have the code typeset within
a plain ``!bc`` environment.) Two regular expressions, separated by the
``@`` sign, define the "from" and "to" lines.  The "from" line is
included in the verbatim block, while the "to" line is not. In the
example above, we copy code from the line matching ``subroutine test``
(with as many blanks as desired between the two words) and the line
matching ``C END1`` (C followed by 5 blanks and then the text END1). The
final line with the "to" text is not included in the verbatim block.

Let us copy a whole file (the first line above)::


        C     a comment
        
              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return


Let us then copy just a piece in the middle as indicated by the ``fromto:``
directive above::


              subroutine    test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return


Note that the "to" line is not copied into the Doconce file, but the
"from" line is. Sometimes it is convenient to also neglect the
"from" line, a feature that is allowed by replacing ``fromto:`` by
``from-to`` ("from with minus"). This allows for copying very similar
code segments throughout a file, while still distinguishing between them.
Copying the second set of parameters from the text::


        # --- Start Example 1 ---
        c = -1
        A = 2
        p0 = 4
        simulate_and_plot(c, A, p0)
        # --- End Example 1 ---
        
        # --- Start Example 2 ---
        c = -1
        A = 1
        p0 = 0
        simulate_and_plot(c, A, p0)
        # --- End Example 2 ---

is easy with::


        from-to: Start Example 2@End Example 2

With only ``fromto:`` this would be impossible.

(Remark for those familiar with ``ptex2tex``: The from-to
syntax is slightly different from that used in ``ptex2tex``. When
transforming Doconce to LaTeX, one first transforms the document to a
``.p.tex`` file to be treated by ``ptex2tex``. However, the ``@@@CODE`` line
is interpreted by Doconce and replaced by the mentioned
pro or cod environment which are defined in the ``ptex2tex`` configuration
file.)


.. _mathtext:

LaTeX Blocks of Mathematical Text
---------------------------------

Blocks of mathematical text are like computer code blocks, but
the opening tag is ``!bt`` (begin TeX) and the closing tag is
``!et``. It is important that ``!bt`` and ``!et`` appear on the beginning of the
line and followed by a newline::


        !bt
        \begin{align}
        {\partial u\over\partial t} &= \nabla^2 u + f, label{myeq1}\\
        {\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
        \end{align}
        


Here is the result of the above ``!bt`` - ``!et`` block::

        \begin{align}
        {\partial u\over\partial t} &= \nabla^2 u + f, label{myeq1}\\
        {\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
        \end{align}


This text looks ugly in all Doconce supported formats, except from
LaTeX and Sphinx.  If HTML is desired, and Sphinx is not an option,
one can filter the Doconce text first to LaTeX and then use the tex4ht
tool to convert the dvi file to HTML, or one could just link a PDF
file (made from LaTeX) directly from HTML.

If the document targets both LaTeX, Sphinx, and other formats like
plain text and wiki, one can use the preprocessor to typeset the
mathematics in two versions. After ``#if FORMAT in ("latex", "pdflatex",
"sphinx", "mwiki")`` one places LaTeX mathematics, and after ``#else`` one can
write inline mathematics in a way that looks nice in plain text and
wiki formats without support for mathematical typesetting.


Mathematics for PowerPoint/OpenOffice
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If you have LaTeX mathematics written in Doconce, it is fairly easy
to generate PNG images of all mathematical formulas and equations for
use with PowerPoint or OpenOffice documents.

 1. Make a Sphinx version of the Doconce file.

 2. Go to the Sphinx directory and load the ``conf.py`` file into
    a browser.

 3. Search for "math" and comment out the
    ``'sphinx.ext.mathjax'`` (enabled by default) and
    ``'matplotlib.sphinxext.mathmpl'`` (disabled by default)
    lines, and uncomment the ``'sphinx.ext.pngmath'`` package.
    This is the package that generates small PNG pictures
    of the mathematics.

 4. Uncomment the line with ``pngmath_dvipng_args =`` and
    set the PNG resolution to ``-D 200`` when the purpose is to
    generate mathematics pictures for slides.

 5. Run ``make html``.

 6. Look at the HTML source file in the ``_build/html``
    directory: all mathematics are in ``img`` tags with ``src=``
    pointing to a PNG file and ``alt=`` pointing to the LaTeX
    source for the formula in question. This makes it very
    easy to find the PNG file that corresponding to a particular
    mathematical expression.

.. _newcommands:

Macros (Newcommands)
--------------------

Doconce supports a type of macros via a LaTeX-style *newcommand*
construction.  The newcommands defined in a file with name
``newcommand_replace.tex`` are expanded when Doconce is filtered to
other formats, except for LaTeX (since LaTeX performs the expansion
itself).  Newcommands in files with names ``newcommands.tex`` and
``newcommands_keep.tex`` are kept unaltered when Doconce text is
filtered to other formats, except for the Sphinx format. Since Sphinx
understands LaTeX math, but not newcommands if the Sphinx output is
HTML, it makes most sense to expand all newcommands.  Normally, a user
will put all newcommands that appear in math blocks surrounded by
``!bt`` and ``!et`` in ``newcommands_keep.tex`` to keep them unchanged, at
least if they contribute to make the raw LaTeX math text easier to
read in the formats that cannot render LaTeX.  Newcommands used
elsewhere throughout the text will usually be placed in
``newcommands_replace.tex`` and expanded by Doconce.  The definitions of
newcommands in the ``newcommands*.tex`` files *must* appear on a single
line (multi-line newcommands are too hard to parse with regular
expressions).

*Example.* Suppose we have the following commands in
``newcommand_replace.tex``::


        \newcommand{\beqa}{\begin{eqnarray}}
        \newcommand{\eeqa}{\end{eqnarray}}
        \newcommand{\ep}{\thinspace . }
        \newcommand{\uvec}{\vec u}
        \newcommand{\Q}{\pmb{Q}}


and these in ``newcommands_keep.tex``::


        \newcommand{\x}{\pmb{x}}
        \newcommand{\normalvec}{\pmb{n}}
        \newcommand{\Ddt}[1]{\frac{D#1}{dt}}


The LaTeX block::


        \beqa
        \x\cdot\normalvec &=& 0, label{my:eq1}\\
        \Ddt{\uvec} &=& \Q \ep   label{my:eq2}
        \eeqa

will then be rendered to::

        \begin{align}
        {\partial u\over\partial t} &= \nabla^2 u + f, label{myeq1}\\
        {\partial v\over\partial t} &= \nabla\cdot(q(u)\nabla v) + g
        \end{align}

in the current format.

Preprocessing Steps
-------------------

Doconce allows preprocessor commands for, e.g., including files,
leaving out text, or inserting special text depending on the format.
Two preprocessors are supported: preprocess
(`<http://code.google.com/p/preprocess>`_) and mako
(`<http://www.makotemplates.org/>`_). The former allows include and if-else
statements much like the well-known preprocessor in C and C++ (but it
does not allow sophisticated macro substitutions). The latter
preprocessor is a very powerful template system.  With Mako you can
automatically generate various type of text and steer the generation
through Python code embedded in the Doconce document. An arbitrary set
of ``name=value`` command-line arguments (at the end of the command line)
automatically define Mako variables that are substituted in the document.

Doconce will detect if preprocess or Mako commands are used and run
the relevant preprocessor prior to translating the Doconce source to a
specific format.

The preprocess and mako programs always have the variable ``FORMAT``
defined as the desired output format of Doconce (``html``, ``latex``,
``plain``, ``rst``, ``sphinx``, ``epydoc``, ``st``).  It is then easy to test on
the value of ``FORMAT`` and take different actions for different
formats. For example, one may create special LaTeX output for figures,
say with multiple plots within a figure, while other formats may apply
a separate figure for each plot. Below is an example (see the Doconce
source code of this document to understand how preprocess is used to
create the example).

.. If PNGFIGS is defined, PNG files are used, otherwise Encapsulated

.. PostScript files are used.



.. Use default Doconce figure handling for all other formats



.. figure:: figs/wavepacket_0001.png
   :width: 400

   Wavepacket at time 0.1 s



.. figure:: figs/wavepacket_0010.png
   :width: 400

   Wavepacket at time 0.2 s



Other user-defined variables for the preprocessor can be set at
the command line as explained in the section `From Doconce to Other Formats`_.

More advanced use of mako can include Python code that may automate
the writing of parts of the document.



Splitting Documents into Smaller Pieces
---------------------------------------

Long documents are conveniently split into smaller Doconce files.
However, there must be a master document including all the pieces,
otherwise references to sections and the index will not work properly.
The master document is preferably a file just containing a set of
preprocessor include statements of the form ``#include "file.do.txt"``.
The preprocessor will put together all the pieces so that Doconce
sees a long file with the complete text.

For reST and Sphinx documents it is a point to have
separate ``.rst`` files and an index file listing the various ``.rst``
that build up the document. To generate the various ``.rst`` files one
should not run Doconce on the individual ``.do.txt`` files, because then
references and index entries are not treated correctly. Instead,
run Doconce on the master file and invoke the script ``doconce split_rst``
to split the long, complete ``.rst`` into pieces. This process requires
that each ``#include "file.do.txt`` line in the master file is preceded by a
"marker line" having the syntax ``#>>>>>> part: file >>>>>>``, where
``file`` is the filename without extension. The number of greater than
signs is not important, but it has to be a comment line and it has
to contain the keyword ``part:``.

Here is an example. Say the name of the master file is ``master.do.txt``.
The following Bash script does the job:
We run::


        doconce format sphinx master
        # Split master.rst into parts
        # as defined by #>>>>> part: name >>>>> lines
        files=`doconce split_rst master.rst`
        
        dir=sphinxm-rootdir
        
        if [ ! -d $dir ]; then
          doconce sphinx_dir dirname=$dir author='me and you' \
                  version=1.0 theme=default $files
          sh automake-sphinx.sh
        else
          for file in $files; do
            cp $file.rst $dir
          done
          cd $dir
          make html
          cd ..
        fi

The autogenerated ``automake-sphinx.sh`` file (by ``doconce sphinx_dir``)
is compatible with a master ``.rst`` file split into pieces as long as
the complete set of pieces in correct order is given to ``doconce sphinx_dir``.
This set is the output of ``doconce split_rst``, which we catch in a
variable ``files`` above.


Missing Features
----------------

Doconce does not aim to support sophisticated typesetting, simply because
sophisticated typesetting usually depend quite strongly on the particular
output format chosen. When a particular feature needed is not supported
by Doconce, it is recommended to hardcode that feature for a particular
format and use the if-else construction of the preprocessor. For example,
if a sophisticated table is desired in LaTeX output, test on the
``FORMAT`` variable (``#if FORMAT == "latex"``) in the Doconce code and
insert the table in LaTeX format. The ``else`` or ``elif`` branches may
have the table in other formats or a simplified version in the Doconce
table format. Similarly, if certain adjustments are needed, like
pagebreaks in LaTeX, hardcode that in the Doconce format (and recall
that this is really LaTeX dependent - pagebreaks are not
relevant HTML formats).

Instead of inserting special code in the Doconce document, one can
alternatively script editing of the output from Doconce. That is,
we develop a Python or Bash script that runs the translation of
a Doconce document to a ready docoment in another format. Inside this
script, we may edit and fine-tune the output from Doconce.

As an example, say you want a table of contents in the LaTeX output
(Doconce does not support table of contents). By inserting a
recognizable comment in the Doconce source, say::


        # table of contents

we can use this comment to edit the LaTeX file. First, we run
Doconce ``doconce format latex mydoc`` to produce ``mydoc.p.tex``. Then
we use the ``doconce replace`` and ``doconce subst`` commands to
replace the comment by the comment plus the table of contents command,
or just the latter::


        Terminal> doconce replace '% table of contents'
                  '\tableofcontents' mydoc.p.tex

The ``doconce replace from_text to_text filename`` command performs a
character-by-character replacement (using the ``replace`` method in
string objects in Python). If we want to preserve the comment and add
a new line with ``\tableofcontents``, we should use ``doconce subst``,
which applies regular expressions for substitutions and thereby
understands the newline character::


        Terminal> doconce subst '% table of contents' \
                  '% table of contents\n\\tableofcontents' mydoc.p.tex

Note the double backshlash in front of the ``t`` character: without it we
would get a tab and no backslash.
The ``doconce subst`` is a powerful way to automatically edit the output
from Doconce and fine-tune a LaTeX document. Use of comment lines to
identify portions of the file to be edited is a smart idea.
Alternatively, the relevant LaTeX constructions can be inserted directly
in the Doconce file using if-else preprocessor directives.

Header and Footer
-----------------

Some formats use a header and footer in the document. LaTeX and
HTML are two examples of such formats. When the document is to be
included in another document (which is often the case with
Doconce-based documents), the header and footer are not wanted, while
these are needed (at least in a LaTeX context) if the document is
stand-alone. We have introduce the convention that if ``TITLE:`` or
``#TITLE:`` is found at the beginning of the line (i.e., the document
has, or has an intention have, a title), the header and footer
are included, otherwise not.


Emacs Doconce Formatter
-----------------------

The file ``misc/.doconce-mode.el`` in the Doconce source distribution
gives a "Doconce Editing Mode" in Emacs. The file is a rough edit of
the reST Editing Mode for Emacs. Some Doconce features are recognized,
but far from all, and sometimes portions of Doconce text just appear
as ordinary text.

Here is how to get the Doconce Editing Mode in Emacs.

*Step 1.* Download the Doconce tarball from ``code.google.com/p/doconce``,
pack it out and go to the root directory.

*Step 2.* Copy the ``doconce-mode.el`` file to the home directory::


        cp misc/.doconce-mode.el $HOME


*Step 3.* Add these lines to ``$HOME/.emacs``::


        (load-file "~/hg/.doconce-mode.el")
        (setq auto-mode-alist(cons '("\\.do\\.txt$" . doconce-mode) auto-mode-alist))

Emacs will now recognize files with extension ``.do.txt`` and enter
the Doconce Editing Mode.


Troubleshooting
===============

Disclaimer
----------

Doconce has some support for syntax checking.  If you encounter Python
errors while running ``doconce format``, the reason for the error is
most likely a syntax problem in your Doconce source file. You have to
track down this syntax problem yourself.

However, the problem may well be a bug in Doconce. The Doconce
software is incomplete, and many special cases of syntax are not yet
discovered to give problems. Such special cases are also seldom easy to
fix, so one important way of "debugging" Doconce is simply to change
the formatting so that Doconce treats it properly. Doconce is very much
based on regular expressions, which are known to be non-trivial to
debug years after they are created. The main developer of Doconce has
hardly any time to work on debugging the code, but the software works
well for his diverse applications of it.


General Problems
----------------

Something goes wrong in the preprocessing step
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Doconce automatically removes the file ``__tmp.do.txt``, which is the
resulting of the preprocessing stge and the file to examine if
something goes wrong in this stage (i.e., when ``mako`` and/or
``preprocess`` is run). Add the ``--debug`` flag at the end of the
``doconce`` command to (both make a debug file and) avoid that
``__tmp.do.txt`` is deleted.

Figure captions are incomplete
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If only the first part of a figure caption in the Doconce file is seen
in the target output format, the reason is usually that the caption
occupies multiple lines in the Doconce file. The figure caption must
be written as *one line*, at the same line as the FIGURE keyword.

Preprocessor directives do not work
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Make sure the preprocessor instructions, in Preprocess or Mako, have
correct syntax. Also make sure that you do not mix Preprocess and Mako
instructions. Doconce will then only run Preprocess.

Problems with boldface and emphasize
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Two boldface or emphasize expressions after each other are not rendered
correctly. Merge them into one common expression.

Links to local directories do not work
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Links of the type::


        see the "examples directory": "src/examples"

do not work well. You need to link to a specific HTML file::


        see the "examples directory": "src/examples/index.html"


Links are not typeset correctly
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Not all formats will allow formatting of the links. Verbatim words
in links are allowed if the whole link is typeset in verbatim::


        see the directory "`examples`": "src/examples/index.html".

However, the following will not be typeset correctly::


        see the "`examples` directory": "src/examples/index.html"

The back-ticks must be removed, or the text can be reformulated as
in the line above it.


Inline verbatim code is not detected
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Make sure there is a space before the first back-tick.

Strange non-English characters
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Check the encoding of the ``.do.txt`` file with the Unix ``file`` command
or with::


        Unix> doconce guess_encoding myfile.do.txt

If the encoding is utf-8, convert to latin-1 using either of
the Unix commands::


        Unix> doconce change_encoding utf-8 LATIN1 myfile.do.txt
        
        Unix> iconv -f utf-8 -t LATIN1 myfile.do.txt --output newfile


Wrong Norwegian charcters
~~~~~~~~~~~~~~~~~~~~~~~~~

When Doconce documents have characters not in the standard ASCII set,
the format of the file must be LATIN1 and not UTF-8. See
the section "Strange non-English characters" above for how to
run ``doconce change_encoding`` to change the encoding of the Doconce file.

Inline verbatim text is not formatted correctly
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Make sure there is whitespace surrounding the text in back-ticks.

Too short underlining of reST headlines
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This may happen if there is a paragraph heading without
proceeding text before some section heading.


Found !bt but no tex blocks extracted (BUG)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This message points to a bug, but has been resolved by removing blank lines
between the text and the first ``!bt`` (inserting the blanks again did not
trigger the error message again...).

Problems with code or Tex Blocks
--------------------------------

Code or math block errors in reST
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

First note that a code or math block must come after some plain
sentence (at least for successful output in reST), not directly
after a section/paragraph heading, table, comment, figure, or
movie, because the code or math block is indented and then become
parts of such constructions. Either the block becomes invisible or
error messages are issued.

Sometimes reST reports an "Unexpected indentation" at the beginning of
a code block. If you see a ``!bc``, which should have been removed when
running ``doconce format sphinx``, it is usually an error in the Doconce
source, or a problem with the rst/sphinx translator.  Check if the
line before the code block ends in one colon (not two!), a question
mark, an exclamation mark, a comma, a period, or just a newline/space
after text. If not, make sure that the ending is among the
mentioned. Then ``!bc`` will most likely be replaced and a double colon
at the preceding line will appear (which is the right way in reST to
indicate a verbatim block of text).

Strange errors around code or TeX blocks in reST
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If ``idx`` commands for defining indices are placed inside paragraphs,
and especially right before a code block, the reST translator
(rst and sphinx formats) may get confused and produce strange
code blocks that cause errors when the reST text is transformed to
other formats. The remedy is to define items for the index outside
paragraphs.

Something is wrong with a verbatim code block
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Check first that there is a "normal" sentence right before
the block (this is important for reST and similar
"ASCII-close" formats).

Code/TeX block is not shown in reST format
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

A comment right before a code or tex block will treat the whole
block also as a comment. It is important that there is normal
running text right before ``!bt`` and ``!bc`` environments.

Verbatim code blocks inside lists look ugly
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Read the the section `Blocks of Verbatim Computer Code`_ above.  Start the
``!bc`` and ``!ec`` tags in column 1 of the file, and be careful with
indenting the surrounding plain text of the list item correctly. If
you cannot resolve the problem this way, get rid of the list and use
paragraph headings instead. In fact, that is what is recommended:
avoid verbatim code blocks inside lists (it makes life easier).

LaTeX code blocks inside lists look ugly
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Same solution as for computer code blocks as described in the
previous paragraph. Make sure the ``!bt`` and ``!et`` tags are in column 1
and that the rest of the non-LaTeX surrounding text is correctly indented.
Using paragraphs instead of list items is a good idea also here.


Problems with reST/Sphinx Output
--------------------------------

Lists do not appear in .rst files
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Check if you have a comment right above the list. That comment
will include the list if the list is indentend. Remove the comment.

Error message "Undefined substitution..." from reST
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This may happen if there is much inline math in the text. reST cannot
understand inline LaTeX commands and interprets them as illegal code.
Just ignore these error messages.

Warning about duplicate link names
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Link names should be unique, but if (e.g.) "file" is used as link text
several places in a reST file, the links still work. The warning can
therefore be ignorned.

Inconsistent headings in reST
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The ``rst2*.py`` and Sphinx converters abort if the headers of sections
are not consistent, i.e., a subsection must come under a section,
and a subsubsection must come under a subsection (you cannot have
a subsubsection directly under a section). Search for ``===``,
count the number of equality signs (or underscores if you use that)
and make sure they decrease by two every time a lower level is encountered.

No code environment appears before "bc ipy" blocks
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The ``!bc ipy`` directive behaves this way for ``sphinx`` output because
interactive sessions are automatically handled. If this is not
appropriate, shift to ``!bc cod`` or another specification of the
verbatim environment.

Problems with LaTeX Output
--------------------------

Error when running latex: You must 'pygmentize' installed
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This points to the used of the Minted style for typesetting verbatim
code. You need to run::


        Terminal> latex -shell-escape file

if you have run ``ptex2tex`` with the ``-DMINTED`` option and turned on
the use of the Minted style (and therefore ``pygmentize`` program).

The LaTeX file does not compile
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If the problem is undefined control sequence involving::


        \code{...}

the cause is usually a verbatim inline text (in back-ticks in the
Doconce file) spans more than one line. Make sure, in the Doconce source,
that all inline verbatim text appears on the same line.

Inline verbatim gives error
~~~~~~~~~~~~~~~~~~~~~~~~~~~

Check if the inline verbatim contains typical LaTeX commands, e.g.::


        some text with `\usepackage{mypack}` is difficult because
        ptex2tex will replace this by \code{\usepackage{mypack}} and
        then replace this by
        {\fontsize{10pt}{10pt}\verb!\usepackage{mypack!}}
        which is wrong because ptex2tex applies regex that don't
        capture the second }

The remedy is to place verbatim LaTeX commands in verbatim
blocks - that is safe.

.. Could have doconce configure file where inline verbatim is

.. configured to be \fontsize... directly, not via ptex2tex \code{}.



Errors in figure captions
~~~~~~~~~~~~~~~~~~~~~~~~~

Such errors typically arise from unbalanced curly braces, or dollar signs
around math, and similar LaTeX syntax errors.

(Note that verbatim font is likely to cause trouble inside figure captions,
but Doconce will automatically replace verbatim text in back-ticks by
a proper ``texttt`` command (since verbatim font constructions does not work
inside figure captions) and precede underscores by backslash.)

Chapters are ignored
~~~~~~~~~~~~~~~~~~~~

The default LaTeX style is "article". If you chapters in the Doconce file,
you need to run ``ptex2tex`` with the option ``-DBOOK`` to set the LaTeX
documentstyle to "book".

I want to tune the top of the LaTeX file
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The top of the LaTeX file, as generated by Doconce, is very simple.
If this LaTeX code is not sufficient for your needs, there are
two ways out of it:

1. Make a little Bash script that performs a series of
   ``doconce subst`` (regular expressions) or ``doconce replace`` (regular text)
   substitutions to change the text automatically (you probably have to
   repeat these edits so automating them is a good idea).

2. Place the title, author(s), and date of the Doconce file in a separate
   file and use the preprocessor to include the rest. The rest is then
   one or more Doconce files without title, author(s), and date. This
   means that the ``doconce format latex`` command does not generate
   the LaTeX intro (preamble) and outro, just the core text, for these
   files.
   Make a new file by hand with the appropriate LaTeX intro and outro
   text and include the various text pieces in this file.
   To make the LaTeX document, you compile all Doconce files
   into LaTeX code, except the "top" Doconce file that includes the
   others. That file is not used for LaTeX output, but
   replaced by the hand-written LaTeX "top" file.

Problems with gwiki Output
--------------------------

Strange nested lists in gwiki
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Doconce cannot handle nested lists correctly in the gwiki format.
Use nonnested lists or edit the ``.gwiki`` file directly.

Lists in gwiki look ugly in the gwiki source
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Because the Google Code wiki format requires all text of a list item to
be on one line, Doconce simply concatenates lines in that format,
and because of the indentation in the original Doconce text, the gwiki
output looks somewhat ugly. The good thing is that this gwiki source
is seldom to be looked at - it is the Doconce source that one edits
further.

Debugging
---------

Given a problem, extract a small portion of text surrounding the
problematic area and debug that small piece of text. Doconce does a
series of transformations of the text. The effect of each of these
transformation steps are dumped to a logfile, named
``_doconce_debugging.log``, if the to ``doconce format`` after the filename
is ``debug``. The logfile is inteded for the developers of Doconce, but
may still give some idea of what is wrong.  The section "Basic Parsing
Ideas" explains how the Doconce text is transformed into a specific
format, and you need to know these steps to make use of the logfile.



Basic Parsing Ideas
===================

.. avoid list here since we have code in between (never a good idea)


The (parts of) files with computer code to be directly included in
the document are first copied into verbatim blocks.

All verbatim and TeX blocks are removed and stored elsewhere
to ensure that no formatting rules are not applied to these blocks.

The text is examined line by line for typesetting of lists, as well as
handling of blank lines and comment lines.
List parsing needs some awareness of the context.
Each line is interpreted by a regular expression::


        (?P<indent> *(?P<listtype>[*o-] )? *)(?P<keyword>[^:]+?:)?(?P<text>.*)\s?


That is, a possible indent (which we measure), an optional list
item identifier, optional space, optional words ended by colon,
and optional text. All lines are of this form. However, some
ordinary (non-list) lines may contain a colon, and then the keyword
and text group must be added to get the line contents. Otherwise,
the text group will be the line.

When lists are typeset, the text is examined for sections, paragraphs,
title, author, date, plus all the inline tags for emphasized, boldface,
and verbatim text. Plain subsitutions based on regular expressions
are used for this purpose.

The final step is to insert the code and TeX blocks again (these should
be untouched and are therefore left out of the previous parsing).

It is important to keep the Doconce format and parsing simple.  When a
new format is needed and this format is not obtained by a simple edit
of the definition of existing formats, it might be better to convert
the document to reST and then to XML, parse the XML and
write out in the new format.  When the Doconce format is not
sufficient to getting the layout you want, it is suggested to filter
the document to another, more complex format, say reST or
LaTeX, and work further on the document in this format.


A Glimpse of How to Write a New Translator
------------------------------------------

This is the HTML-specific part of the
source code of the HTML translator::


        FILENAME_EXTENSION['html'] = '.html'  # output file extension
        BLANKLINE['html'] = '<p>\n'           # blank input line => new paragraph
        INLINE_TAGS_SUBST['html'] = {         # from inline tags to HTML tags
            # keep math as is:
            'math': None,  # indicates no substitution
            'emphasize':     r'\g<begin><em>\g<subst></em>\g<end>',
            'bold':          r'\g<begin><b>\g<subst></b>\g<end>',
            'verbatim':      r'\g<begin><tt>\g<subst></tt>\g<end>',
            'URL':           r'\g<begin><a href="\g<url>">\g<link></a>',
            'section':       r'<h1>\g<subst></h1>',
            'subsection':    r'<h3>\g<subst></h3>',
            'subsubsection': r'<h5>\g<subst></h5>',
            'paragraph':     r'<b>\g<subst></b>. ',
            'title':         r'<title>\g<subst></title>\n<center><h1>\g<subst></h1></center>',
            'date':          r'<center><h3>\g<subst></h3></center>',
            'author':        r'<center><h3>\g<subst></h3></center>',
            }
        
        # how to replace code and latex blocks by html (<pre>) environment:
        def html_code(filestr):
            c = re.compile(r'^!bc(.*?)\n', re.MULTILINE)
            filestr = c.sub(r'<!-- BEGIN VERBATIM BLOCK \g<1>-->\n<pre>\n', filestr)
            filestr = re.sub(r'!ec\n',
                             r'</pre>\n<! -- END VERBATIM BLOCK -->\n', filestr)
            c = re.compile(r'^!bt\n', re.MULTILINE)
            filestr = c.sub(r'<pre>\n', filestr)
            filestr = re.sub(r'!et\n', r'</pre>\n', filestr)
            return filestr
        CODE['html'] = html_code
        
        # how to typeset lists and their items in html:
        LIST['html'] = {
            'itemize':
            {'begin': '\n<ul>\n', 'item': '<li>', 'end': '</ul>\n\n'},
            'enumerate':
            {'begin': '\n<ol>\n', 'item': '<li>', 'end': '</ol>\n\n'},
            'description':
            {'begin': '\n<dl>\n', 'item': '<dt>%s<dd>', 'end': '</dl>\n\n'},
            }
        
        # how to type set description lists for function arguments, return
        # values, and module/class variables:
        ARGLIST['html'] = {
            'parameter': '<b>argument</b>',
            'keyword': '<b>keyword argument</b>',
            'return': '<b>return value(s)</b>',
            'instance variable': '<b>instance variable</b>',
            'class variable': '<b>class