#include "../primitive_common.h"

const float vertices_of_cube[] =
{
   /* positions        normals            vertex_color          tex_coords  tangents    */
   /* Front */
    0.5, -0.5,  0.5,   0.0, -1.0,  0.0,   0.0, 1.0, 1.0, 1.0,   0.0, 0.0,  -1.0, 0.0, 0.0,
   -0.5, -0.5,  0.5,   0.0, -1.0,  0.0,   0.0, 1.0, 1.0, 1.0,   1.0, 0.0,  -1.0, 0.0, 0.0,
   -0.5, -0.5, -0.5,   0.0, -1.0,  0.0,   0.0, 1.0, 1.0, 1.0,   1.0, 1.0,  -1.0, 0.0, 0.0,
    0.5, -0.5, -0.5,   0.0, -1.0,  0.0,   0.0, 1.0, 1.0, 1.0,   0.0, 1.0,  -1.0, 0.0, 0.0,

   /* Left */
   -0.5, -0.5,  0.5,  -1.0,  0.0,  0.0,   0.0, 1.0, 0.0, 1.0,   1.0, 0.0,   0.0, 0.0, 1.0,
   -0.5,  0.5,  0.5,  -1.0,  0.0,  0.0,   0.0, 1.0, 0.0, 1.0,   1.0, 1.0,   0.0, 0.0, 1.0,
   -0.5,  0.5, -0.5,  -1.0,  0.0,  0.0,   0.0, 1.0, 0.0, 1.0,   0.0, 1.0,   0.0, 0.0, 1.0,
   -0.5, -0.5, -0.5,  -1.0,  0.0,  0.0,   0.0, 1.0, 0.0, 1.0,   0.0, 0.0,   0.0, 0.0, 1.0,

   /* Back */
   -0.5,  0.5,  0.5,   0.0,  1.0,  0.0,   1.0, 0.0, 1.0, 1.0,   0.0, 0.0,   1.0, 0.0, 0.0,
    0.5,  0.5,  0.5,   0.0,  1.0,  0.0,   1.0, 0.0, 1.0, 1.0,   1.0, 0.0,   1.0, 0.0, 0.0,
    0.5,  0.5, -0.5,   0.0,  1.0,  0.0,   1.0, 0.0, 1.0, 1.0,   1.0, 1.0,   1.0, 0.0, 0.0,
   -0.5,  0.5, -0.5,   0.0,  1.0,  0.0,   1.0, 0.0, 1.0, 1.0,   0.0, 1.0,   1.0, 0.0, 0.0,

   /* Right */
    0.5,  0.5,  0.5,   1.0,  0.0,  0.0,   1.0, 1.0, 0.0, 1.0,   0.0, 1.0,   0.0, 0.0, -1.0,
    0.5, -0.5,  0.5,   1.0,  0.0,  0.0,   1.0, 1.0, 0.0, 1.0,   0.0, 0.0,   0.0, 0.0, -1.0,
    0.5, -0.5, -0.5,   1.0,  0.0,  0.0,   1.0, 1.0, 0.0, 1.0,   1.0, 0.0,   0.0, 0.0, -1.0,
    0.5,  0.5, -0.5,   1.0,  0.0,  0.0,   1.0, 1.0, 0.0, 1.0,   1.0, 1.0,   0.0, 0.0, -1.0,

   /* Top */
   -0.5, -0.5,  0.5,   0.0,  0.0,  1.0,   1.0, 0.0, 0.0, 1.0,   0.0, 0.0,   1.0, 0.0, 0.0,
   -0.5,  0.5,  0.5,   0.0,  0.0,  1.0,   1.0, 0.0, 0.0, 1.0,   0.0, 1.0,   1.0, 0.0, 0.0,
    0.5,  0.5,  0.5,   0.0,  0.0,  1.0,   1.0, 0.0, 0.0, 1.0,   1.0, 1.0,   1.0, 0.0, 0.0,
    0.5, -0.5,  0.5,   0.0,  0.0,  1.0,   1.0, 0.0, 0.0, 1.0,   1.0, 0.0,   1.0, 0.0, 0.0,

   /* Bottom */
   -0.5, -0.5, -0.5,   0.0,  0.0, -1.0,   0.0, 0.0, 1.0, 1.0,   1.0, 0.0,  -1.0, 0.0, 0.0,
   -0.5,  0.5, -0.5,   0.0,  0.0, -1.0,   0.0, 0.0, 1.0, 1.0,   1.0, 1.0,  -1.0, 0.0, 0.0,
    0.5,  0.5, -0.5,   0.0,  0.0, -1.0,   0.0, 0.0, 1.0, 1.0,   0.0, 1.0,  -1.0, 0.0, 0.0,
    0.5, -0.5, -0.5,   0.0,  0.0, -1.0,   0.0, 0.0, 1.0, 1.0,   0.0, 0.0,  -1.0, 0.0, 0.0,
};

const unsigned short indices_of_cube[] =
{
   0,   1,  2,  6,  7,  4,
   4,   5,  6, 10, 11,  8,
   8,   9, 10, 14, 15, 12,
   12, 13, 14,  2,  3,  0,
   19, 16, 17, 17, 18, 19,
   23, 20, 21, 21, 22, 23
};

void
evas_model_set_from_cube_primitive(Evas_Canvas3D_Mesh *mesh, int frame)
{
   SET_VERTEX_DATA_FROM_ARRAY(mesh, frame, vertices_of_cube, 24, indices_of_cube, 36)
}
