/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include "Parallel/GetRef_cmd.h"
#include "Parallel/sublattice_cmd.h"

/*!
  constructor for GetNodeRefCommand

  \param globalRankAndComm
  \param meshname
*/
GetNodeRefCommand::GetNodeRefCommand(const MpiRankAndComm& globalRankAndComm,const string& meshname)
  : BroadcastCommand(globalRankAndComm, CMD_GETMESHNODEREF)
{
  append(meshname.c_str());
}

/*!
  constructor for GetFaceRefCommand

  \param globalRankAndComm
  \param meshname
*/
GetFaceRefCommand::GetFaceRefCommand(const MpiRankAndComm& globalRankAndComm,const string& meshname)
  : BroadcastCommand(globalRankAndComm, CMD_GETMESHFACEREF)
{
  append(meshname.c_str());
}
