!{\src2tex{textfont=tt}}
!!****m* etsf_io_data_group/etsf_io_data_read
!! NAME
!!  etsf_io_data_read
!!
!! FUNCTION
!!    High-level routine to read a lot of ETSF variable at once.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * filename = 
!!     the path to the file to be accessed.
!! * use_atomic_units = (optional) 
!!     set this flag to .true. makes the library use the value of the attribute
!!     scale_to_atomic_units to multiply the read variables (that are units dependent)
!!     by this factor (if different from 1.0d0).
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!! SIDE EFFECTS
!! * group_folder <type(etsf_groups)> = 
!!     a container for different groups. All groups specified in the @groups argument
!!     must be associated.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_data_read(filename, group_folder, lstat, error_data, use_atomic_units)

  !Arguments ------------------------------------
  character(len=*), intent(in) :: filename
  type(etsf_groups), intent(inout) :: group_folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  logical, optional, intent(in) :: use_atomic_units
  !Local variables-------------------------------
  character(len=*),parameter :: my_name = 'etsf_io_data_read'
  integer :: ncid, i
  logical :: my_use_atomic_units


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_data_read : enter'
!ENDDEBUG

  ! Get values for optional arguments, set default.
  if (present(use_atomic_units)) then
    my_use_atomic_units = use_atomic_units
  else
    my_use_atomic_units = .true.
  end if
  
  ! Open file for reading
  call etsf_io_low_open_read(ncid, trim(filename), lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  ! Get Data
  if (associated(group_folder%geometry)) then
    call etsf_io_geometry_get(ncid, group_folder%geometry, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (associated(group_folder%electrons)) then
    call etsf_io_electrons_get(ncid, group_folder%electrons, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (associated(group_folder%kpoints)) then
    call etsf_io_kpoints_get(ncid, group_folder%kpoints, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (associated(group_folder%basisdata)) then
    call etsf_io_basisdata_get(ncid, group_folder%basisdata, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (associated(group_folder%gwdata)) then
    call etsf_io_gwdata_get(ncid, group_folder%gwdata, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (associated(group_folder%dielectric)) then
    call etsf_io_dielectric_get(ncid, group_folder%dielectric, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (associated(group_folder%main)) then
    call etsf_io_main_get(ncid, group_folder%main, lstat, error_data, &
                         & use_atomic_units = my_use_atomic_units)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  
  ! Close file
  call etsf_io_low_close(ncid, lstat, error_data = error_data)
  if (.not. lstat) call etsf_io_low_error_update(error_data, my_name)

!DEBUG
!write (*,*) 'etsf_io_data_read : exit'
!ENDDEBUG

end subroutine etsf_io_data_read
!!***
