#!/usr/bin/python

##   GNOME Comics Organizer - Python Branch
##   Copyright (C) 2004 Mads Villadsen <maxximum@krakoa.dk>
    
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
   
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.
   
##   You should have received a copy of the GNU General Public License
##   along with this program; if not, write to the Free Software
##   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import comiclist
import fileops
from globals import *

import gobject
import sys
import pango
import cgi
import os.path
import string

try:
    import pygtk
    pygtk.require ("2.0")
    import gtk, gtk.glade, gnome, gnome.ui
except:
    print "pyGTK 2.0 not found."

COMICS_COLUMN_TITLE = 0
COMICS_COLUMN_PUBLISHER = 1
COMICS_COLUMN_COMIC_ID_HIDDEN = 2
COMICS_COLUMN_ISSUE_ID_HIDDEN = 3

class gco_mainwindow:
    def __init__(self):
        self.comics = []
        self.filename = None
        self.file_modified = False
        self.uuid_gen = comiclist.uuid_generator(0)
        self.highest_uuid = str(0)
        self.wTree = None
        try:
            self.wTree = gtk.glade.XML (gladefile, "main_window")
        except:
            self.wTree = gtk.glade.XML (devel_gladefile, "main_window")
        
        dic = {
            "on_main_window_destroy" : self.quit,
            "on_quit_activate" : self.quit,
            "on_about_activate" : self.about_activate,
            "on_statistics_activate" : self.statistics_activate,
            "on_new_activate" : self.new_activate,
            "on_save_activate" : self.save_activate,
            "on_save_as_activate" : self.save_as_activate,
            "on_open_activate" : self.open_activate,
            "on_comics_treeview_row_activated" : self.comics_treeview_activated,
            "on_remove_item_activate" : self.remove_item,
            "on_add_comic_activate" : self.add_comic,
            "on_add_issue_activate" : self.add_issue,
            "on_add_multiple_issues_activate" : self.add_multiple_issues,
            "on_properties_activate" : self.properties
            }
        self.wTree.signal_autoconnect (dic)
        
        # setup treeview
        self.comicsTreeView = self.wTree.get_widget ("comics_treeview")
        self.comicsTreeModel = gtk.TreeStore (gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING)
        self.comicsTreeView.set_model (self.comicsTreeModel)
        self.comicsTreeView.set_headers_visible (True)
        self.comicsTreeView.set_search_column(COMICS_COLUMN_TITLE)

        renderer = gtk.CellRendererText ()
        column = gtk.TreeViewColumn ("Title/issue", renderer, markup=COMICS_COLUMN_TITLE)
        column.set_resizable (True)
        self.comicsTreeView.append_column (column)

        renderer = gtk.CellRendererText ()
        column = gtk.TreeViewColumn ("Publisher", renderer, text=COMICS_COLUMN_PUBLISHER)
        column.set_resizable (True)
        self.comicsTreeView.append_column (column)

        renderer = gtk.CellRendererText ()
        column = gtk.TreeViewColumn ("comic item id (hidden)", renderer, text=COMICS_COLUMN_COMIC_ID_HIDDEN)
        column.set_resizable (True)

        renderer = gtk.CellRendererText ()
        column = gtk.TreeViewColumn ("issue item id (hidden)", renderer, text=COMICS_COLUMN_ISSUE_ID_HIDDEN)
        column.set_resizable (True)

        self.comicsTreeView.show ()

        self.main_window = self.wTree.get_widget ("main_window")
        try:
            self.main_window.set_icon_from_file(window_icon_file)
        except:
            pass
        self.set_window_title()
        return

    def quit(self, widget):
        if (self.file_modified):
            quit_dialogwTree = None
            try:
                quit_dialogwTree = gtk.glade.XML (gladefile, "quit_dialog")
            except:
                quit_dialogwTree = gtk.glade.XML (devel_gladefile, "quit_dialog")
            quit_dialog = quit_dialogwTree.get_widget("quit_dialog")
            quit_dialog.set_transient_for(self.main_window)
            try:
                quit_dialog.set_icon_from_file(window_icon_file)
            except:
                pass
            
            result = quit_dialog.run()

            if (result == gtk.RESPONSE_OK):
                gtk.main_quit()

            quit_dialog.destroy()
        else:
            gtk.main_quit()

    def set_window_title(self):
        title = ""
        if (self.filename != None):
            title = os.path.basename(self.filename)
        else:
            title = "Untitled"
        if (self.file_modified):
            title = title + " (*)"

        title = title + " - " + program_name
            
        self.main_window.set_title(title)
        
    def fill_comics_rows(self, comics):
        self.comicsTreeModel.clear()

        parent_iters = {}

        for i,comic in enumerate(comics):
            title = comic.get_title()
            if (comic.get_volume() != "1"):
                title = title + " (Vol. " + comic.get_volume() + ")"

            if (comic.get_group() != "" and not parent_iters.has_key(comic.get_group())):
                tmp_iter = self.comicsTreeModel.insert_before (None, None)

                self.comicsTreeModel.set_value (tmp_iter, COMICS_COLUMN_TITLE, "<i>" + cgi.escape(comic.get_group()) + "</i>")
                self.comicsTreeModel.set_value (tmp_iter, COMICS_COLUMN_COMIC_ID_HIDDEN, -1)

                parent_iters[comic.get_group()] = tmp_iter

            parent_iter = None
            if (comic.get_group() != ""):
                parent_iter = parent_iters[comic.get_group()]
            iter = self.insert_comic_row (self.comicsTreeModel,
                                          parent_iter,
                                          cgi.escape(title),
                                          comic.get_publisher(),
                                          i, -1)

            for j,issue in enumerate(comic.get_issues()):
                issue_iter = self.insert_comic_row (self.comicsTreeModel,
                                                    iter,
                                                    cgi.escape(issue.get_issue_number()),
                                                    "",
                                                    i, j)
                
        return

    def insert_comic_row (self, model, parent, title, publisher, comic_id, issue_id):
        iter = model.insert_before (parent, None)

        model.set_value (iter, COMICS_COLUMN_TITLE, cgi.escape(title))
        model.set_value (iter, COMICS_COLUMN_PUBLISHER, publisher)
        model.set_value (iter, COMICS_COLUMN_COMIC_ID_HIDDEN, comic_id)
        model.set_value (iter, COMICS_COLUMN_ISSUE_ID_HIDDEN, issue_id)
        return iter

    def comics_treeview_activated (self, widget, path, column):
        iter = self.comicsTreeModel.get_iter (path)
        comic_id =  self.comicsTreeModel.get_value (iter, COMICS_COLUMN_COMIC_ID_HIDDEN)
        issue_id =  self.comicsTreeModel.get_value (iter, COMICS_COLUMN_ISSUE_ID_HIDDEN)
        if (comic_id != "-1"):
            comic = self.comics[int(comic_id)]
            if (issue_id != "-1"):
                issue = self.comics[int(comic_id)].get_issues()[int(issue_id)]
                self.show_issue_description(issue, comic)
            else:
                self.show_comic_description(comic)
        
        return

    def show_comic_description (self, comic):
        descriptionTextView = self.wTree.get_widget ("description_textview")
        buffer = descriptionTextView.get_buffer ()
        buffer.delete (buffer.get_start_iter (), buffer.get_end_iter ())
        iter = buffer.get_start_iter ()
        
        bold_tag = buffer.create_tag(name=None, weight=pango.WEIGHT_BOLD)
        italic_tag = buffer.create_tag(name=None, style=pango.STYLE_ITALIC)
        
        title = comic.get_title()
        if (comic.get_volume() != "1"):
            title = title + " (Vol. " + comic.get_volume() + ")"

        buffer.insert_with_tags(iter, title + "\n", bold_tag)
        buffer.insert(iter, str(len(comic.get_issues())) + " issues available." +  "\n\n")
        
        buffer.insert_with_tags(iter, comic.get_publisher() + "\n", italic_tag)
        buffer.insert_with_tags(iter, comic.get_type() + "\n\n", italic_tag)
        if (comic.get_comment() != ""):
            buffer.insert(iter, comic.get_comment() + "\n\n")
        return    

    def show_issue_description (self, issue, comic):
        descriptionTextView = self.wTree.get_widget ("description_textview")
        buffer = descriptionTextView.get_buffer ()
        buffer.delete (buffer.get_start_iter (), buffer.get_end_iter ())
        iter = buffer.get_start_iter ()
        
        bold_tag = buffer.create_tag(name=None, weight=pango.WEIGHT_BOLD)
        italic_tag = buffer.create_tag(name=None, style=pango.STYLE_ITALIC)
        
        title = comic.get_title()
        if (comic.get_volume != "1"):
            title = title + " (Vol. " + comic.get_volume() + ")"

        buffer.insert_with_tags(iter, title + " #" + issue.get_issue_number(), bold_tag)
        buffer.insert(iter, " " + issue.get_price() + "\n")
        buffer.insert(iter, "Condition: " + comiclist.int2condition(int(issue.get_condition())) + "\n\n")
        if (issue.get_comment() != ""):
            buffer.insert(iter, issue.get_comment() + "\n\n")
        titles = issue.get_title()
        if (len(titles) > 0):
            if (len(titles) == 1):
                buffer.insert_with_tags(iter, "Title: ", italic_tag)
            else:
                buffer.insert_with_tags(iter, "Titles: ", italic_tag)
            for i,title in enumerate(titles):
                buffer.insert(iter, title)
                if (i+1 < len(titles)):
                    buffer.insert(iter, ", ")
            buffer.insert(iter, "\n")
        writers = issue.get_writer()
        if (len(writers) > 0):
            if (len(writers) == 1):
                buffer.insert_with_tags(iter, "Writer: ", italic_tag)
            else:
                buffer.insert_with_tags(iter, "Writers: ", italic_tag)
            for i,writer in enumerate(writers):
                buffer.insert(iter, writer)
                if (i+1 < len(writers)):
                    buffer.insert(iter, ", ")
            buffer.insert(iter, "\n")
        pencillers = issue.get_penciller()
        if (len(pencillers) > 0):
            if (len(pencillers) == 1):
                buffer.insert_with_tags(iter, "Penciller: ", italic_tag)
            else:
                buffer.insert_with_tags(iter, "Pencillers: ", italic_tag)
            for i,penciller in enumerate(pencillers):
                buffer.insert(iter, penciller)
                if (i+1 < len(pencillers)):
                    buffer.insert(iter, ", ")
            buffer.insert(iter, "\n")
        inkers = issue.get_inker()
        if (len(inkers) > 0):
            if (len(inkers) == 1):
                buffer.insert_with_tags(iter, "Inker: ", italic_tag)
            else:
                buffer.insert_with_tags(iter, "Inkers: ", italic_tag)
            for i,inker in enumerate(inkers):
                buffer.insert(iter, inker)
                if (i+1 < len(inkers)):
                    buffer.insert(iter, ", ")
            buffer.insert(iter, "\n")

        if (issue.get_image() != ""):
            buffer.insert(iter, "\n")
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(issue.get_image(), 200, 200)
            buffer.insert_pixbuf(iter, pixbuf)
            buffer.insert(iter, "\n")

        return    

    def remove_item(self, widget):
        selected = self.comicsTreeView.get_selection().get_selected()
        iter = selected[1]
        if (iter != None):
            comic_id = int(selected[0].get_value(iter, COMICS_COLUMN_COMIC_ID_HIDDEN))
            issue_id = int(selected[0].get_value(iter, COMICS_COLUMN_ISSUE_ID_HIDDEN))
            if (comic_id != -1):
                comic_title = self.comics[comic_id].get_title()
                if (self.comics[comic_id].get_volume() != "1"):
                    comic_title = comic_title + " (Vol. " + self.comics[comic_id].get_volume() + ")"
                comic_publisher = self.comics[comic_id].get_publisher()

                are_you_sure_dialogwTree = None
                try:
                    are_you_sure_dialogwTree = gtk.glade.XML (gladefile, "are_you_sure_dialog")
                except:
                    are_you_sure_dialogwTree = gtk.glade.XML (devel_gladefile, "are_you_sure_dialog")

                are_you_sure_dialog = are_you_sure_dialogwTree.get_widget("are_you_sure_dialog")
                are_you_sure_dialog.set_transient_for(self.main_window)
                try:
                    are_you_sure_dialog.set_icon_from_file(window_icon_file)
                except:
                    pass
                are_you_sure_label = are_you_sure_dialogwTree.get_widget("are_you_sure_label")
                if (issue_id == -1):
                    are_you_sure_label.set_markup("Are you sure you want to remove the <i>entire</i> comic and all issues?\n\n" + "<b>" + comic_title + "</b>\n<i>" + comic_publisher + "</i>\n")
                else:
                    issue_number = self.comics[comic_id].get_issues()[issue_id].get_issue_number()
                    are_you_sure_label.set_markup("Are you sure you want to remove this issue?\n\n" + "<b>" + comic_title + " #" + issue_number + "</b>\n<i>" + comic_publisher + "</i>\n")

                result = are_you_sure_dialog.run()

                if (result == gtk.RESPONSE_OK):
                    if (issue_id == -1):
                        # remove the entire comic
                        del self.comics[comic_id]
                    else:
                        # only remove the specific issue
                        del self.comics[comic_id].get_issues()[issue_id]
                
                        self.file_modified = True
                        self.set_window_title()

                        self.fill_comics_rows (self.comics)
                are_you_sure_dialog.destroy()
            else:
                msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "You cannot remove an entire group. Please select an issue or a comic.")
                try:
                    msg.set_icon_from_file(window_icon_file)
                except:
                    pass
                result = msg.run()
                msg.destroy()
        else:
            msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "You must select an issue or a comic before removing.")
            try:
                msg.set_icon_from_file(window_icon_file)
            except:
                pass
            result = msg.run()
            msg.destroy()

    def add_comic(self, widget):
        add_comic_dialogwTree = None
        try:
            add_comic_dialogwTree = gtk.glade.XML (gladefile, "add_comic_dialog")
        except:
            add_comic_dialogwTree = gtk.glade.XML (devel_gladefile, "add_comic_dialog")
        add_comic_dialog = add_comic_dialogwTree.get_widget("add_comic_dialog")
        add_comic_dialog.set_transient_for(self.main_window)
        try:
            add_comic_dialog.set_icon_from_file(window_icon_file)
        except:
            pass

        publisher_arr = []
        type_arr = []
        group_arr = []
        for comic in self.comics:
            if (comic.get_publisher() != ""):
                try:
                    exists = publisher_arr.index(comic.get_publisher())
                except:
                    publisher_arr.append(comic.get_publisher())
            if (comic.get_type() != ""):
                try:
                    exists = type_arr.index(comic.get_type())
                except:
                    type_arr.append(comic.get_type())
            if (comic.get_group() != ""):
                try:
                    exists = group_arr.index(comic.get_group())
                except:
                    group_arr.append(comic.get_group())

        #add_comic_dialogwTree.get_widget("publisher_comboboxentry").set_property("appears-as-list", True)
        add_comic_dialogwTree.get_widget("publisher_comboboxentry").set_property("wrap-width", 2)
        add_comic_dialogwTree.get_widget("publisher_comboboxentry").remove_text(0)

        #add_comic_dialogwTree.get_widget("type_comboboxentry").set_property("appears-as-list", True)
        add_comic_dialogwTree.get_widget("type_comboboxentry").set_property("wrap-width", 2)
        add_comic_dialogwTree.get_widget("type_comboboxentry").remove_text(0)

        #add_comic_dialogwTree.get_widget("group_comboboxentry").set_property("appears-as-list", True)
        add_comic_dialogwTree.get_widget("group_comboboxentry").set_property("wrap-width", 2)
        add_comic_dialogwTree.get_widget("group_comboboxentry").remove_text(0)

        type_arr.sort()
        for t in type_arr:
            add_comic_dialogwTree.get_widget("type_comboboxentry").append_text(t)

        publisher_arr.sort()
        for p in publisher_arr:
            add_comic_dialogwTree.get_widget("publisher_comboboxentry").append_text(p)

        group_arr.sort()
        for g in group_arr:
            add_comic_dialogwTree.get_widget("group_comboboxentry").append_text(g)

            

        result = add_comic_dialog.run()

        if (result == gtk.RESPONSE_OK):
            title = add_comic_dialogwTree.get_widget("title_entry").get_text()
            publisher = add_comic_dialogwTree.get_widget("publisher_comboboxentry").get_child().get_text()
            type = add_comic_dialogwTree.get_widget("type_comboboxentry").get_child().get_text()
            add_comic_dialogwTree.get_widget("volume_spinbutton").update()
            volume = str(add_comic_dialogwTree.get_widget("volume_spinbutton").get_value_as_int())
            group = add_comic_dialogwTree.get_widget("group_comboboxentry").get_child().get_text()
            buffer = add_comic_dialogwTree.get_widget("comment_textview").get_buffer()
            comment = buffer.get_text(buffer.get_start_iter (), buffer.get_end_iter ())

            comic = comiclist.ComicBook()
            self.highest_uuid = str(self.uuid_gen.next())
            comic.init(title, publisher, type, volume, group, comment, "", self.highest_uuid)
            self.comics.append(comic)
            self.comics.sort(comiclist.comic_compare_title)

            self.file_modified = True
            self.set_window_title()

            self.fill_comics_rows (self.comics)

        add_comic_dialog.destroy()

    def image_browse_clicked(self, widget, entry, image):
        open_dialogwTree = None
        try:
            open_dialogwTree = gtk.glade.XML (gladefile, "open_dialog")
        except:
            open_dialogwTree = gtk.glade.XML (devel_gladefile, "open_dialog")
        open_dialog = open_dialogwTree.get_widget("open_dialog")
        open_dialog.set_transient_for(self.main_window)
        try:
            open_dialog.set_icon_from_file(window_icon_file)
        except:
            pass

        result = open_dialog.run()
        if (result == gtk.RESPONSE_OK):
            fname = open_dialog.get_filename()

            image.set_from_file(fname)
            entry.child.set_text(fname)

        open_dialog.destroy()

    def list_add_clicked(self, widget, entry, model):
        # entry can be either a comboboxentry or just a basic entry
        actual_entry = None
        try:
            actual_entry = entry.child
        except:
            actual_entry = entry
        to_add = actual_entry.get_text()
        if (to_add != ""):
            iter = model.insert_before (None, None)
            model.set_value(iter, 0, to_add)

    def list_remove_clicked(self, widget, treeview):
        selection = treeview.get_selection()
        model = selection.get_selected()[0]
        iter = selection.get_selected()[1]
        if (iter != None):
            model.remove(iter)

    def treemodel_get_list_from_model(self, model, path, iter, list):
        list.append(model.get_value(iter, 0))
        

    def add_issue(self, widget):
        selected = self.comicsTreeView.get_selection().get_selected()
        iter = selected[1]
        if (iter != None):
            comic_id = int(selected[0].get_value(iter, COMICS_COLUMN_COMIC_ID_HIDDEN))
            if (comic_id != -1):
                comic_title = self.comics[comic_id].get_title()
                add_issue_dialogwTree = None
                try:
                    add_issue_dialogwTree = gtk.glade.XML (gladefile, "add_issue_dialog")
                except:
                    add_issue_dialogwTree = gtk.glade.XML (devel_gladefile, "add_issue_dialog")
                add_issue_dialog = add_issue_dialogwTree.get_widget("add_issue_dialog")
                add_issue_dialogwTree.get_widget("comic_title_label").set_markup("<b>" + cgi.escape(comic_title) + "</b>")
                add_issue_dialogwTree.get_widget("condition_combobox").set_active(1)

                add_issue_dialogwTree.get_widget("image_browse_button").connect("clicked", self.image_browse_clicked,
                                                                                add_issue_dialogwTree.get_widget("image_comboboxentry"),
                                                                                add_issue_dialogwTree.get_widget("image"))

                titles_treeview = add_issue_dialogwTree.get_widget("titles_treeview")
                titles_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                titles_treeview.set_model (titles_treemodel)
                titles_treeview.set_headers_visible (False)

                renderer = gtk.CellRendererText ()
                column = gtk.TreeViewColumn ("Title", renderer, text=0)
                column.set_resizable (True)
                titles_treeview.append_column (column)

                add_issue_dialogwTree.get_widget("titles_add_button").connect("clicked", self.list_add_clicked,
                                                                              add_issue_dialogwTree.get_widget("titles_entry"),
                                                                              titles_treemodel)
                add_issue_dialogwTree.get_widget("titles_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                 titles_treeview)

                writers_treeview = add_issue_dialogwTree.get_widget("writers_treeview")
                writers_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                writers_treeview.set_model (writers_treemodel)
                writers_treeview.set_headers_visible (False)

                renderer = gtk.CellRendererText ()
                column = gtk.TreeViewColumn ("Writer", renderer, text=0)
                column.set_resizable (True)
                writers_treeview.append_column (column)

                add_issue_dialogwTree.get_widget("writers_add_button").connect("clicked", self.list_add_clicked,
                                                                               add_issue_dialogwTree.get_widget("writers_comboboxentry"),
                                                                               writers_treemodel)
                add_issue_dialogwTree.get_widget("writers_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                  writers_treeview)

                pencillers_treeview = add_issue_dialogwTree.get_widget("pencillers_treeview")
                pencillers_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                pencillers_treeview.set_model (pencillers_treemodel)
                pencillers_treeview.set_headers_visible (False)

                renderer = gtk.CellRendererText ()
                column = gtk.TreeViewColumn ("Penciller", renderer, text=0)
                column.set_resizable (True)
                pencillers_treeview.append_column (column)

                add_issue_dialogwTree.get_widget("pencillers_add_button").connect("clicked", self.list_add_clicked,
                                                                                  add_issue_dialogwTree.get_widget("pencillers_comboboxentry"),
                                                                                  pencillers_treemodel)
                add_issue_dialogwTree.get_widget("pencillers_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                     pencillers_treeview)

                inkers_treeview = add_issue_dialogwTree.get_widget("inkers_treeview")
                inkers_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                inkers_treeview.set_model (inkers_treemodel)
                inkers_treeview.set_headers_visible (False)

                renderer = gtk.CellRendererText ()
                column = gtk.TreeViewColumn ("Inker", renderer, text=0)
                column.set_resizable (True)
                inkers_treeview.append_column (column)

                add_issue_dialogwTree.get_widget("inkers_add_button").connect("clicked", self.list_add_clicked,
                                                                              add_issue_dialogwTree.get_widget("inkers_comboboxentry"),
                                                                              inkers_treemodel)
                add_issue_dialogwTree.get_widget("inkers_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                 inkers_treeview)
                add_issue_dialog.set_transient_for(self.main_window)
                try:
                    add_issue_dialog.set_icon_from_file(window_icon_file)
                except:
                    pass




                #add_issue_dialogwTree.get_widget("cover_price_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("cover_price_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("cover_price_comboboxentry").remove_text(0)
                #add_issue_dialogwTree.get_widget("current_price_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("current_price_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("current_price_comboboxentry").remove_text(0)
                #add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").remove_text(0)
                #add_issue_dialogwTree.get_widget("location_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("location_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("location_comboboxentry").remove_text(0)
                #add_issue_dialogwTree.get_widget("writers_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("writers_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("writers_comboboxentry").remove_text(0)
                #add_issue_dialogwTree.get_widget("pencillers_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("pencillers_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("pencillers_comboboxentry").remove_text(0)
                #add_issue_dialogwTree.get_widget("inkers_comboboxentry").set_property("appears-as-list", True)
                add_issue_dialogwTree.get_widget("inkers_comboboxentry").set_property("wrap-width", 2)
                add_issue_dialogwTree.get_widget("inkers_comboboxentry").remove_text(0)

                cover_price_arr = []
                current_price_arr = []
                purchase_price_arr = []
                location_arr = []
                pencillers_arr = []
                writers_arr = []
                inkers_arr = []
                for comic in self.comics:
                    for issue in comic.get_issues():
                        if (issue.get_cover_price() != ""):
                            try:
                                exists = cover_price_arr.index(issue.get_cover_price())
                            except:
                                cover_price_arr.append(issue.get_cover_price())
                        if (issue.get_current_price() != ""):
                            try:
                                exists = current_price_arr.index(issue.get_current_price())
                            except:
                                current_price_arr.append(issue.get_current_price())
                        if (issue.get_purchase_price() != ""):
                            try:
                                exists = purchase_price_arr.index(issue.get_purchase_price())
                            except:
                                purchase_price_arr.append(issue.get_purchase_price())
                        if (issue.get_location() != ""):
                            try:
                                exists = location_arr.index(issue.get_location())
                            except:
                                location_arr.append(issue.get_location())
                        for p in issue.get_penciller():
                            try:
                                exists = pencillers_arr.index(p)
                            except:
                                pencillers_arr.append(p)
                        for p in issue.get_writer():
                            try:
                                exists = writers_arr.index(p)
                            except:
                                writers_arr.append(p)
                        for p in issue.get_inker():
                            try:
                                exists = inkers_arr.index(p)
                            except:
                                inkers_arr.append(p)

                cover_price_arr.sort()
                for g in cover_price_arr:
                    add_issue_dialogwTree.get_widget("cover_price_comboboxentry").append_text(g)
                current_price_arr.sort()
                for g in current_price_arr:
                    add_issue_dialogwTree.get_widget("current_price_comboboxentry").append_text(g)
                purchase_price_arr.sort()
                for g in purchase_price_arr:
                    add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").append_text(g)
                location_arr.sort()
                for g in location_arr:
                    add_issue_dialogwTree.get_widget("location_comboboxentry").append_text(g)
                pencillers_arr.sort()
                for g in pencillers_arr:
                    add_issue_dialogwTree.get_widget("pencillers_comboboxentry").append_text(g)
                writers_arr.sort()
                for g in writers_arr:
                    add_issue_dialogwTree.get_widget("writers_comboboxentry").append_text(g)
                inkers_arr.sort()
                for g in inkers_arr:
                    add_issue_dialogwTree.get_widget("inkers_comboboxentry").append_text(g)





                if (len(self.comics[comic_id].get_issues()) >= 1):
                    latest_iss = self.comics[comic_id].get_issues()[len(self.comics[comic_id].get_issues())-1]
                    try:
                        i = int(latest_iss.get_issue_number()) + 1
                        add_issue_dialogwTree.get_widget("issue_number_entry").set_text(str(i))
                    except:
                        pass
                    add_issue_dialogwTree.get_widget("cover_price_comboboxentry").child.set_text(latest_iss.get_price())
                    for writer in latest_iss.get_writer():
                        if (writer != ""):
                            iter = writers_treemodel.insert_before (None, None)
                            writers_treemodel.set_value(iter, 0, writer)
                    for penciller in latest_iss.get_penciller():
                        if (penciller != ""):
                            iter = pencillers_treemodel.insert_before (None, None)
                            pencillers_treemodel.set_value(iter, 0, penciller)
                    for inker in latest_iss.get_inker():
                        if (inker != ""):
                            iter = inkers_treemodel.insert_before (None, None)
                            inkers_treemodel.set_value(iter, 0, inker)
                

                result = add_issue_dialog.run()

                if (result == gtk.RESPONSE_OK):
                    issue_number = add_issue_dialogwTree.get_widget("issue_number_entry").get_text()
                    condition = str(add_issue_dialogwTree.get_widget("condition_combobox").get_active())
                    cover_price = add_issue_dialogwTree.get_widget("cover_price_comboboxentry").child.get_text()
                    purchase_price = add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").child.get_text()
                    current_price = add_issue_dialogwTree.get_widget("current_price_comboboxentry").child.get_text()

                    location = add_issue_dialogwTree.get_widget("location_comboboxentry").child.get_text()

                    image = add_issue_dialogwTree.get_widget("image_comboboxentry").child.get_text()

                    comment_buffer = add_issue_dialogwTree.get_widget("comment_textview").get_buffer()
                    comment = comment_buffer.get_text(comment_buffer.get_start_iter(), comment_buffer.get_end_iter())

                    date = str(add_issue_dialogwTree.get_widget("date_dateedit").get_time())

                    issue = comiclist.Issue()
                    issue.set_issue_number(issue_number)
                    issue.set_condition(condition)

                    issue.set_price(cover_price)
                    issue.set_purchase_price(purchase_price)
                    issue.set_current_price(current_price)

                    issue.set_location(location)

                    issue.set_image(image)

                    issue.set_comment(comment)

                    issue.set_date(date)

                    titles = []
                    titles_treemodel.foreach(self.treemodel_get_list_from_model, titles)
                    issue.set_title(titles)

                    writers = []
                    writers_treemodel.foreach(self.treemodel_get_list_from_model, writers)
                    issue.set_writer(writers)

                    pencillers = []
                    pencillers_treemodel.foreach(self.treemodel_get_list_from_model, pencillers)
                    issue.set_penciller(pencillers)

                    inkers = []
                    inkers_treemodel.foreach(self.treemodel_get_list_from_model, inkers)
                    issue.set_inker(inkers)

                    self.highest_uuid = str(self.uuid_gen.next())
                    issue.set_guid(self.highest_uuid)
                    
                    self.comics[comic_id].append_issue(issue)

                    self.comics[comic_id].get_issues().sort(comiclist.issue_compare_issue_number)
                    self.fill_comics_rows (self.comics)

                    self.file_modified = True
                    self.set_window_title()

                add_issue_dialog.destroy()
            else:
                msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "You cannot select a group to add issues to. Please select a comic instead.")
                try:
                    msg.set_icon_from_file(window_icon_file)
                except:
                    pass
                result = msg.run()
                msg.destroy()
        else:
            msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "You must select a comic before adding issues.")
            try:
                msg.set_icon_from_file(window_icon_file)
            except:
                pass
            result = msg.run()
            msg.destroy()
            

    def add_multiple_issues(self, widget):
        selected = self.comicsTreeView.get_selection().get_selected()
        iter = selected[1]
        if (iter != None):
            comic_id = int(selected[0].get_value(iter, COMICS_COLUMN_COMIC_ID_HIDDEN))
            if (comic_id != -1):
                comic_title = self.comics[comic_id].get_title()
                add_multiple_issues_dialogwTree = None
                try:
                    add_multiple_issues_dialogwTree = gtk.glade.XML (gladefile, "add_multiple_issues_dialog")
                except:
                    add_multiple_issues_dialogwTree = gtk.glade.XML (devel_gladefile, "add_multiple_issues_dialog")
                add_multiple_issues_dialog = add_multiple_issues_dialogwTree.get_widget("add_multiple_issues_dialog")
                add_multiple_issues_dialogwTree.get_widget("comic_title_label").set_markup("<b>" + cgi.escape(comic_title) + "</b>")

                add_multiple_issues_dialog.set_transient_for(self.main_window)
                try:
                    add_multiple_issues_dialog.set_icon_from_file(window_icon_file)
                except:
                    pass

                result = add_multiple_issues_dialog.run()

                if (result == gtk.RESPONSE_OK):
                    add_multiple_issues_dialogwTree.get_widget("from_issue_spinbutton").update()
                    add_multiple_issues_dialogwTree.get_widget("to_issue_spinbutton").update()
                    from_issue = add_multiple_issues_dialogwTree.get_widget("from_issue_spinbutton").get_value_as_int()
                    to_issue = add_multiple_issues_dialogwTree.get_widget("to_issue_spinbutton").get_value_as_int()

                    for i in range(from_issue, to_issue + 1):
                        issue = comiclist.Issue()
                        issue.set_issue_number(str(i))
                        self.highest_uuid = str(self.uuid_gen.next())
                        issue.set_guid(self.highest_uuid)
                        
                        self.comics[comic_id].append_issue(issue)

                    self.comics[comic_id].get_issues().sort(comiclist.issue_compare_issue_number)
                    self.fill_comics_rows (self.comics)

                    self.file_modified = True
                    self.set_window_title()

                add_multiple_issues_dialog.destroy()
            else:
                msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "You cannot select a group to add issues to. Please select a comic instead.")
                try:
                    msg.set_icon_from_file(window_icon_file)
                except:
                    pass
                result = msg.run()
                msg.destroy()
        else:
            msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "You must select a comic before adding issues.")
            try:
                msg.set_icon_from_file(window_icon_file)
            except:
                pass
            result = msg.run()
            msg.destroy()

    def properties(self, widget):
        selected = self.comicsTreeView.get_selection().get_selected()
        iter = selected[1]
        if (iter != None):
            comic_id =  self.comicsTreeModel.get_value (iter, COMICS_COLUMN_COMIC_ID_HIDDEN)
            issue_id =  self.comicsTreeModel.get_value (iter, COMICS_COLUMN_ISSUE_ID_HIDDEN)
            if (comic_id != "-1"):
                comic = self.comics[int(comic_id)]
                if (issue_id != "-1"):
                    issue = self.comics[int(comic_id)].get_issues()[int(issue_id)]

                    # TODO: "merge" this method with add_issue and add_comic

                    add_issue_dialogwTree = None
                    try:
                        add_issue_dialogwTree = gtk.glade.XML (gladefile, "add_issue_dialog")
                    except:
                        add_issue_dialogwTree = gtk.glade.XML (devel_gladefile, "add_issue_dialog")
                    add_issue_dialog = add_issue_dialogwTree.get_widget("add_issue_dialog")
                    add_issue_dialogwTree.get_widget("comic_title_label").set_markup("<b>" + cgi.escape(comic.get_title()) + "</b>")
                    add_issue_dialogwTree.get_widget("adding_to_label").set_text("Editing issue from:")

                    add_issue_dialogwTree.get_widget("issue_number_entry").set_text(issue.get_issue_number())
                    add_issue_dialogwTree.get_widget("condition_combobox").set_active(int(issue.get_condition()))
                    add_issue_dialogwTree.get_widget("cover_price_comboboxentry").child.set_text(issue.get_price())
                    add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").child.set_text(issue.get_purchase_price())
                    add_issue_dialogwTree.get_widget("current_price_comboboxentry").child.set_text(issue.get_current_price())
                    
                    add_issue_dialogwTree.get_widget("location_comboboxentry").child.set_text(issue.get_location())
                    
                    add_issue_dialogwTree.get_widget("image_comboboxentry").child.set_text(issue.get_image())
                    if (issue.get_image() != ""):
                        add_issue_dialogwTree.get_widget("image").set_from_file(issue.get_image())
                    
                    comment_buffer = add_issue_dialogwTree.get_widget("comment_textview").get_buffer()
                    comment_buffer.set_text(issue.get_comment())
                    
                    add_issue_dialogwTree.get_widget("date_dateedit").set_time(int(issue.get_date()))



                    add_issue_dialogwTree.get_widget("image_browse_button").connect("clicked", self.image_browse_clicked,
                                                                                    add_issue_dialogwTree.get_widget("image_comboboxentry"),
                                                                                    add_issue_dialogwTree.get_widget("image"))

                    titles_treeview = add_issue_dialogwTree.get_widget("titles_treeview")
                    titles_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                    titles_treeview.set_model (titles_treemodel)
                    titles_treeview.set_headers_visible (False)

                    renderer = gtk.CellRendererText ()
                    column = gtk.TreeViewColumn ("Title", renderer, text=0)
                    column.set_resizable (True)
                    titles_treeview.append_column (column)

                    add_issue_dialogwTree.get_widget("titles_add_button").connect("clicked", self.list_add_clicked,
                                                                                  add_issue_dialogwTree.get_widget("titles_entry"),
                                                                                  titles_treemodel)
                    add_issue_dialogwTree.get_widget("titles_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                     titles_treeview)

                    writers_treeview = add_issue_dialogwTree.get_widget("writers_treeview")
                    writers_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                    writers_treeview.set_model (writers_treemodel)
                    writers_treeview.set_headers_visible (False)

                    renderer = gtk.CellRendererText ()
                    column = gtk.TreeViewColumn ("Writer", renderer, text=0)
                    column.set_resizable (True)
                    writers_treeview.append_column (column)

                    add_issue_dialogwTree.get_widget("writers_add_button").connect("clicked", self.list_add_clicked,
                                                                                   add_issue_dialogwTree.get_widget("writers_comboboxentry"),
                                                                                   writers_treemodel)
                    add_issue_dialogwTree.get_widget("writers_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                      writers_treeview)

                    pencillers_treeview = add_issue_dialogwTree.get_widget("pencillers_treeview")
                    pencillers_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                    pencillers_treeview.set_model (pencillers_treemodel)
                    pencillers_treeview.set_headers_visible (False)

                    renderer = gtk.CellRendererText ()
                    column = gtk.TreeViewColumn ("Penciller", renderer, text=0)
                    column.set_resizable (True)
                    pencillers_treeview.append_column (column)

                    add_issue_dialogwTree.get_widget("pencillers_add_button").connect("clicked", self.list_add_clicked,
                                                                                      add_issue_dialogwTree.get_widget("pencillers_comboboxentry"),
                                                                                      pencillers_treemodel)
                    add_issue_dialogwTree.get_widget("pencillers_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                         pencillers_treeview)

                    inkers_treeview = add_issue_dialogwTree.get_widget("inkers_treeview")
                    inkers_treemodel = gtk.TreeStore (gobject.TYPE_STRING)
                    inkers_treeview.set_model (inkers_treemodel)
                    inkers_treeview.set_headers_visible (False)

                    renderer = gtk.CellRendererText ()
                    column = gtk.TreeViewColumn ("Inker", renderer, text=0)
                    column.set_resizable (True)
                    inkers_treeview.append_column (column)

                    add_issue_dialogwTree.get_widget("inkers_add_button").connect("clicked", self.list_add_clicked,
                                                                                  add_issue_dialogwTree.get_widget("inkers_comboboxentry"),
                                                                                  inkers_treemodel)
                    add_issue_dialogwTree.get_widget("inkers_remove_button").connect("clicked", self.list_remove_clicked,
                                                                                     inkers_treeview)
                    add_issue_dialog.set_transient_for(self.main_window)
                    try:
                        add_issue_dialog.set_icon_from_file(window_icon_file)
                    except:
                        pass
                    add_issue_dialog.set_title("Edit Issue")

                    for t in issue.get_title():
                        if (t != ""):
                            iter = titles_treemodel.insert_before (None, None)
                            titles_treemodel.set_value(iter, 0, t)

                    for w in issue.get_writer():
                        if (w != ""):
                            iter = writers_treemodel.insert_before (None, None)
                            writers_treemodel.set_value(iter, 0, w)

                    for p in issue.get_penciller():
                        if (p != ""):
                            iter = pencillers_treemodel.insert_before (None, None)
                            pencillers_treemodel.set_value(iter, 0, p)

                    for i in issue.get_inker():
                        if (i != ""):
                            iter = inkers_treemodel.insert_before (None, None)
                            inkers_treemodel.set_value(iter, 0, i)


                    result = add_issue_dialog.run()

                    if (result == gtk.RESPONSE_OK):
                        issue_number = add_issue_dialogwTree.get_widget("issue_number_entry").get_text()
                        condition = str(add_issue_dialogwTree.get_widget("condition_combobox").get_active())
                        cover_price = add_issue_dialogwTree.get_widget("cover_price_comboboxentry").child.get_text()
                        purchase_price = add_issue_dialogwTree.get_widget("purchase_price_comboboxentry").child.get_text()
                        current_price = add_issue_dialogwTree.get_widget("current_price_comboboxentry").child.get_text()

                        location = add_issue_dialogwTree.get_widget("location_comboboxentry").child.get_text()

                        image = add_issue_dialogwTree.get_widget("image_comboboxentry").child.get_text()

                        comment_buffer = add_issue_dialogwTree.get_widget("comment_textview").get_buffer()
                        comment = comment_buffer.get_text(comment_buffer.get_start_iter(), comment_buffer.get_end_iter())

                        date = str(add_issue_dialogwTree.get_widget("date_dateedit").get_time())

                        issue.set_issue_number(issue_number)
                        issue.set_condition(condition)

                        issue.set_price(cover_price)
                        issue.set_purchase_price(purchase_price)
                        issue.set_current_price(current_price)

                        issue.set_location(location)

                        issue.set_image(image)

                        issue.set_comment(comment)

                        issue.set_date(date)

                        titles = []
                        titles_treemodel.foreach(self.treemodel_get_list_from_model, titles)
                        issue.set_title(titles)

                        writers = []
                        writers_treemodel.foreach(self.treemodel_get_list_from_model, writers)
                        issue.set_writer(writers)

                        pencillers = []
                        pencillers_treemodel.foreach(self.treemodel_get_list_from_model, pencillers)
                        issue.set_penciller(pencillers)

                        inkers = []
                        inkers_treemodel.foreach(self.treemodel_get_list_from_model, inkers)
                        issue.set_inker(inkers)

                        self.comics[int(comic_id)].get_issues().sort(comiclist.issue_compare_issue_number)
                        self.fill_comics_rows (self.comics)

                        self.file_modified = True
                        self.set_window_title()

                    add_issue_dialog.destroy()

                else:
                    add_comic_dialogwTree = None
                    try:
                        add_comic_dialogwTree = gtk.glade.XML (gladefile, "add_comic_dialog")
                    except:
                        add_comic_dialogwTree = gtk.glade.XML (devel_gladefile, "add_comic_dialog")
                    add_comic_dialog = add_comic_dialogwTree.get_widget("add_comic_dialog")
                    add_comic_dialog.set_transient_for(self.main_window)
                    try:
                        add_comic_dialog.set_icon_from_file(window_icon_file)
                    except:
                        pass
                    add_comic_dialog.set_title("Edit Comic")

                    add_comic_dialogwTree.get_widget("title_entry").set_text(comic.get_title())
                    add_comic_dialogwTree.get_widget("publisher_comboboxentry").get_child().set_text(comic.get_publisher())
                    add_comic_dialogwTree.get_widget("type_comboboxentry").get_child().set_text(comic.get_type())
                    add_comic_dialogwTree.get_widget("volume_spinbutton").set_value(int(comic.get_volume()))
                    add_comic_dialogwTree.get_widget("group_comboboxentry").get_child().set_text(comic.get_group())
                    buffer = add_comic_dialogwTree.get_widget("comment_textview").get_buffer()
                    buffer.set_text(comic.get_comment())

                    result = add_comic_dialog.run()

                    if (result == gtk.RESPONSE_OK):
                        comic.set_title(add_comic_dialogwTree.get_widget("title_entry").get_text())
                        comic.set_publisher(add_comic_dialogwTree.get_widget("publisher_comboboxentry").get_child().get_text())
                        comic.set_type(add_comic_dialogwTree.get_widget("type_comboboxentry").get_child().get_text())
                        add_comic_dialogwTree.get_widget("volume_spinbutton").update()
                        comic.set_volume(str(add_comic_dialogwTree.get_widget("volume_spinbutton").get_value_as_int()))
                        comic.set_group(add_comic_dialogwTree.get_widget("group_comboboxentry").get_child().get_text())
                        buffer = add_comic_dialogwTree.get_widget("comment_textview").get_buffer()
                        comic.set_comment(buffer.get_text(buffer.get_start_iter (), buffer.get_end_iter ()))

                        self.comics.sort(comiclist.comic_compare_title)

                        self.file_modified = True
                        self.set_window_title()

                        self.fill_comics_rows (self.comics)

                    add_comic_dialog.destroy()

    def statistics_activate(self, widget):
        num_issues = 0

        num_with_cover_price = 0
        float_cover_price = 0.0
        invalid_cover_prices = 0

        mint_issues = 0
        near_mint_issues = 0
        
        for c in self.comics:
            for i in c.get_issues():
                num_issues = num_issues + 1
                if (i.get_price() != ""):
                    num_with_cover_price = num_with_cover_price + 1
                    try:
                        float_cover_price = float_cover_price + float(string.replace(i.get_price(), "$", ""))
                    except:
                        invalid_cover_prices = invalid_cover_prices + 1
                        print c.get_title() + " #" + i.get_issue_number()
                        print "Invalid price: " + i.get_price()

                if (i.get_condition() == "0"):
                    mint_issues = mint_issues + 1
                if (i.get_condition() == "1"):
                    near_mint_issues = near_mint_issues + 1
                    
        basic_info = str(len(self.comics)) + " comic titles.\n"
        basic_info = basic_info + str(num_issues) + " issues."

        cover_price = str(num_with_cover_price) + " issues has a cover price.\n"
        cover_price = cover_price + str(invalid_cover_prices) + " issues has an invalid cover price.\n"
        cover_price = cover_price + "Total value based on cover price: $" + str(float_cover_price) + ".\n"
        if (num_issues > 0):
            cover_price = cover_price + "Average price per issue based on cover price: $" + str(round(float_cover_price/num_issues, 2)) + "."

        stats_dialogwTree = None
        try:
            stats_dialogwTree = gtk.glade.XML (gladefile, "stats_dialog")
        except:
            stats_dialogwTree = gtk.glade.XML (devel_gladefile, "stats_dialog")
        stats_dialog = stats_dialogwTree.get_widget("stats_dialog")
        stats_dialogwTree.get_widget("basic_info_label").set_text(basic_info)
        stats_dialogwTree.get_widget("cover_price_label").set_text(cover_price)

        stats_dialog.set_transient_for(self.main_window)
        try:
            stats_dialog.set_icon_from_file(window_icon_file)
        except:
            pass

        stats_dialog.run()
        stats_dialog.destroy()
        
        num_with_purchase_price = 0
        float_purchase_price = 0.0
        invalid_purchase_prices = 0
        for c in self.comics:
            for i in c.get_issues():
                if (i.get_purchase_price() != ""):
                    num_with_purchase_price = num_with_purchase_price + 1
                    try:
                        float_purchase_price = float_purchase_price + float(string.replace(i.get_purchase_price(), "$", ""))
                    except:
                        invalid_purchase_prices = invalid_purchase_prices + 1
        print str(num_with_purchase_price) + " issues has a purchase price"
        print str(invalid_purchase_prices) + " issues has an invalid purchase price"
        print "Total value based on purchase price: $" + str(float_purchase_price)

        num_with_current_price = 0
        float_current_price = 0.0
        invalid_current_prices = 0
        for c in self.comics:
            for i in c.get_issues():
                if (i.get_current_price() != ""):
                    num_with_current_price = num_with_current_price + 1
                    try:
                        float_current_price = float_current_price + float(string.replace(i.get_current_price(), "$", ""))
                    except:
                        invalid_current_prices = invalid_current_prices + 1
        print str(num_with_current_price) + " issues has a current price"
        print str(invalid_current_prices) + " issues has an invalid current price"
        print "Total value based on current price: $" + str(float_current_price)

        print str(mint_issues) + " issues are in mint condition"
        print str(near_mint_issues) + " issues are in near mint condition"

    def about_activate(self, widget):
        about_dialogwTree = None
        try:
            about_dialogwTree = gtk.glade.XML (gladefile, "about")
        except:
            about_dialogwTree = gtk.glade.XML (devel_gladefile, "about")
        about_dialog = about_dialogwTree.get_widget("about")
        about_dialog.set_property('name', program_name)
        about_dialog.set_property('version', program_version)
        try:
            about_dialog.set_icon_from_file(window_icon_file)
        except:
            pass

    def new_activate(self, widget):
        self.comics = []
        self.filename = None
        self.comicsTreeModel.clear()
        self.file_modified = False
        self.set_window_title()
        
    def save_activate(self, widget):
        if (self.filename != None):
            fileops.save_gco(self.filename, self.comics, self.highest_uuid)
        else:
            self.save_as_activate(widget)

    def save_as_activate(self, widget):
        save_dialogwTree = None
        try:
            save_dialogwTree = gtk.glade.XML (gladefile, "save_dialog")
        except:
            save_dialogwTree = gtk.glade.XML (devel_gladefile, "save_dialog")
        save_dialog = save_dialogwTree.get_widget("save_dialog")
        save_dialog.set_transient_for(self.main_window)
        try:
            save_dialog.set_icon_from_file(window_icon_file)
        except:
            pass

        result = save_dialog.run()
        if (result == gtk.RESPONSE_OK):
            temp = save_dialog.get_filename()

            if (temp != ""):
                # TODO: Check that the file doesn't already exist. If it does display a warning.
                self.filename = temp
                self.file_modified = False
                self.set_window_title()
                fileops.save_gco(self.filename, self.comics, self.highest_uuid)

        save_dialog.destroy()

    def open_activate(self, widget):
        open_dialogwTree = None
        try:
            open_dialogwTree = gtk.glade.XML (gladefile, "open_dialog")
        except:
            open_dialogwTree = gtk.glade.XML (devel_gladefile, "open_dialog")
        open_dialog = open_dialogwTree.get_widget("open_dialog")
        open_dialog.set_transient_for(self.main_window)
        try:
            open_dialog.set_icon_from_file(window_icon_file)
        except:
            pass

        result = open_dialog.run()
        if (result == gtk.RESPONSE_OK):
            self.filename = open_dialog.get_filename()

            self.comics = fileops.load_gco_file(self.filename)
            if (self.comics != None):
                self.file_modified = False
                self.set_window_title()
                self.comics.sort(comiclist.comic_compare_title)
                for comic in self.comics:
                    comic.get_issues().sort(comiclist.issue_compare_issue_number)
                self.fill_comics_rows (self.comics)
                start_uuid = int(fileops.get_file_uuid(self.filename))
                self.highest_uuid = str(start_uuid)
                self.uuid_gen = comiclist.uuid_generator(start_uuid)
            else:
                msg = gtk.MessageDialog(self.main_window, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "Unable to load file " + self.filename + ".")
                result = msg.run()
                msg.destroy()

        open_dialog.destroy()
