/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpmessage_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpmessage
 * @title: gimpmessage
 * @short_description: Display a dialog box with a message.
 *
 * Display a dialog box with a message.
 **/


/**
 * gimp_message:
 * @message: Message to display in the dialog.
 *
 * Displays a dialog box with a message.
 *
 * Displays a dialog box with a message. Useful for status or error
 * reporting. The message must be in UTF-8 encoding.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_message (const gchar *message)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, message,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-message",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_message_get_handler:
 *
 * Returns the current state of where warning messages are displayed.
 *
 * This procedure returns the way g_message warnings are displayed.
 * They can be shown in a dialog box or printed on the console where
 * gimp was started.
 *
 * Returns: The current handler type.
 **/
GimpMessageHandlerType
gimp_message_get_handler (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpMessageHandlerType handler = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-message-get-handler",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    handler = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return handler;
}

/**
 * gimp_message_set_handler:
 * @handler: The new handler type.
 *
 * Controls where warning messages are displayed.
 *
 * This procedure controls how g_message warnings are displayed. They
 * can be shown in a dialog box or printed on the console where gimp
 * was started.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_message_set_handler (GimpMessageHandlerType handler)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_MESSAGE_HANDLER_TYPE, handler,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-message-set-handler",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
