
"The rendering context object."

import copy

_no_value = object()

class Context(dict):
    """The rendering context object.

    The rendering context is used by a node to communicate state to its
    children. It acts like a dictionary, in that values are stored and
    retrieved by keys, and like a stack, in that its state can be saved and
    restored.
    """

    def __init__(self, init=None):
        self.stack = []

        if init is not None:
            dict.__init__(self, init)
        else:
            dict.__init__(self)

    def push(self, key, value=_no_value):
        """Save the current state, then save a value.

        @return: A value that pops the current state on the exit of a
            C{with} statement.
        """

        if key in self:
            old = copy.copy(self[key])

            def restore():
                self[key] = old
        else:
            def restore():
                if key in self:
                    del self[key]

        self.stack.append(restore)

        if value is not _no_value:
            self[key] = value

        class Push(object):
            def __enter__(self_):
                pass

            def __exit__(self_, type, exc, tb):
                self.pop()

        return Push()

    def pop(self):
        "Pop the current state, undoing any changes since the last push."

        restore = self.stack.pop()
        restore()

    def __repr__(self):
        return 'Context(%s)' % dict.__repr__(self)
