-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/contents_handler.adb,v $
--  Description     : contents handler package                               --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/22 18:11:50 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This package implements the so called contents handler. The contents     --
--  handler package maintains the table of contents for the application.     --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--                                                                           --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;              use Ada.Strings.Unbounded;

package body Contents_Handler is

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize(
      This : in out Object ) is
   begin
      This.Self := This'Unchecked_Access;
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize(
      This : in out Object ) is
   begin
      null;
   end Finalize;

   ---------
   -- Key --
   ---------
   function Key(
      This : in Object'Class ) return String is
   begin
      return To_String( This.Key  );
   end Key;

   ---------
   -- Key --
   ---------
   function Key(
      This : in Object'Class ) return Unbounded_String is
   begin
      return This.Key;
   end Key;

   ---------
   -- Key --
   ---------
   procedure Key(
      This  : in out Object'Class;
      Value : in String ) is
   begin
      Key( This, To_Unbounded_String( Value ) );
   end Key;

   ---------
   -- Key --
   ---------
   procedure Key(
      This  : in out Object'Class;
      Value : in Unbounded_String ) is
   begin
      This.Key := Value;
   end Key;

   ----------
   -- self --
   ----------
   function Self(
      This : in Object'Class ) return Handle is
   begin
      return This.Self;
   end Self;


end Contents_Handler;
