// +build go1.13

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package azcore

import (
	"context"
	"crypto/tls"
	"net/http"
)

var defaultHTTPClient *http.Client

func init() {
	defaultTransport := http.DefaultTransport.(*http.Transport)
	transport := &http.Transport{
		Proxy:                 defaultTransport.Proxy,
		DialContext:           defaultTransport.DialContext,
		MaxIdleConns:          defaultTransport.MaxIdleConns,
		IdleConnTimeout:       defaultTransport.IdleConnTimeout,
		TLSHandshakeTimeout:   defaultTransport.TLSHandshakeTimeout,
		ExpectContinueTimeout: defaultTransport.ExpectContinueTimeout,
		TLSClientConfig: &tls.Config{
			MinVersion: tls.VersionTLS12,
		},
	}
	// TODO: in track 1 we created a cookiejar, do we need one here?  make it an option?  user-specified HTTP client policy?
	defaultHTTPClient = &http.Client{
		Transport: transport,
	}
}

// DefaultHTTPClientTransport ...
func DefaultHTTPClientTransport() Transport {
	return TransportFunc(func(ctx context.Context, req *http.Request) (*http.Response, error) {
		return defaultHTTPClient.Do(req.WithContext(ctx))
	})
}
