<h1><img src="https://img.fortawesome.com/349cfdf6/logo-fa-free.svg" alt="Font Awesome 5 Free" width="50%"></h1>

> Version 5 – the iconic SVG, font, and CSS framework

The internet's most popular icon toolkit has been redesigned and built from
scratch. On top of this, features like icon font ligatures, an SVG framework,
official NPM packages for popular frontend libraries like React, and access to
a new CDN.

Not familiar with Font Awesome 5? [Learn
more](https://www.kickstarter.com/projects/232193852/font-awesome-5) about our
successful Kickstarter and plan. You can also **[order Font Awesome
Pro](https://fontawesome.com/pro)** which includes tons more icons directly
from [fontawesome.com](https://fontawesome.com).

## Get started with 5!

Learn how to [get started](https://fontawesome.com/get-started) with Font Awesome or dive deeper into [other topics](https://fontawesome.com/how-to-use).

* [SVG with JS](https://fontawesome.com/how-to-use/svg-with-js)
* [Web Fonts with CSS](https://fontawesome.com/how-to-use/web-fonts-with-css)
* [Use on the Desktop](https://fontawesome.com/how-to-use/use-on-desktop)
* [Use with Node.js](https://fontawesome.com/how-to-use/use-with-node-js)
* [JS Component Packages](https://fontawesome.com/how-to-use/js-component-packages)
* [SVG Sprites](https://fontawesome.com/how-to-use/svg-sprites)
* [Upgrading from Version 4](https://fontawesome.com/how-to-use/upgrading-from-4)
* [Server Side Rendering](https://fontawesome.com/how-to-use/server-side-rendering)
* [Font Awesome API](https://fontawesome.com/how-to-use/font-awesome-api)
* [Performance and Security](https://fontawesome.com/how-to-use/performance-and-security)
* [Accessibility](https://fontawesome.com/how-to-use/accessibility)

### Where did Font Awesome 4 (or 3) go?

Now that Font Awesome 5 has been released we are marking version 4 as
end-of-life. We don't plan on releasing any further versions of the 4.x or 3.x.

Documentation is still available but it's moved to
[https://fontawesome.com/v4.7.0](https://fontawesome.com/v4.7.0) and
[https://fontawesome.com/v3.2.1](https://fontawesome.com/v3.2.1).

The Git repository for
[v4.7.0](https://github.com/FortAwesome/Font-Awesome/releases/tag/v4.7.0) and
[v3.2.1](https://github.com/FortAwesome/Font-Awesome/releases/tag/v3.2.1) can
be found in our GitHub releases.

## Change log

We'll keep track of each release in the [CHANGELOG.md](./CHANGELOG.md)

Looking for older versions of Font Awesome? Check the [releases](https://github.com/FortAwesome/Font-Awesome/releases).

## Upgrading

From time-to-time we'll have special upgrading instructions from one version to the next.

Check out the [UPGRADING.md](./UPGRADING.md) guide when you upgrade your dependencies.

## Code of conduct

We will behave ourselves if you behave yourselves. For more details see our
[CODE_OF_CONDUCT.md](./CODE_OF_CONDUCT.md).

## Contributing

Please read through our [contributing guidelines](./CONTRIBUTING.md).  Included
are directions for opening issues.

## Versioning

Font Awesome will be maintained under the Semantic Versioning guidelines as much as possible. Releases will be numbered
with the following format:

`<major>.<minor>.<patch>`

For more information on SemVer, please visit http://semver.org.

**The major version "5" is part of an umbrella release.  It includes many different types of files and technologies. Therefore
we deviate from normal SemVer in the following ways:**

* Any release may update the design, look-and-feel, or branding of an existing
  icon
* We will never intentionally release a `patch` version update that breaks
  backward compatibility
* A `minor` release **may include backward-incompatible changes** but we will
  write clear upgrading instructions in UPGRADING.md
* A `minor` or `patch` release will never remove icons
* Bug fixes will be addressed as `patch` releases unless they include backward
  incompability then they will be `minor` releases

## License

Font Awesome Free is free, open source, and GPL friendly. You can use it for
commercial projects, open source projects, or really almost whatever you want.

- Icons — CC BY 4.0 License
  - In the Font Awesome Free download, the CC BY 4.0 license applies to all icons packaged as .svg and .js files types.
- Fonts — SIL OFL 1.1 License
  - In the Font Awesome Free download, the SIL OLF license applies to all icons packaged as web and desktop font files.
- Code — MIT License
  - In the Font Awesome Free download, the MIT license applies to all non-font and non-icon files.

Attribution is required by MIT, SIL OLF, and CC BY licenses. Downloaded Font
Awesome Free files already contain embedded comments with sufficient
attribution, so you shouldn't need to do anything additional when using these
files normally.

We've kept attribution comments terse, so we ask that you do not actively work
to remove them from files, especially code. They're a great way for folks to
learn about Font Awesome.

## Team

* [Dave Gandy](https://github.com/davegandy)
* [Travis Chase](https://github.com/supercodepoet)
* [Rob Madole](https://github.com/robmadole)
* [Brian Talbot](https://github.com/talbs)
* [Jory Raphael](https://github.com/sensibleworld)
* [Mike Wilkerson](https://github.com/mlwilkerson)
