/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.performance.results;

import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GFileUtils;

import java.io.*;

public class FileRenderer {
    public <T> void render(T model, ReportRenderer<T, Writer> renderer, File outputFile) throws IOException {
        GFileUtils.parentMkdirs(outputFile);
        Writer writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFile), "UTF-8"));
        try {
            renderer.render(model, writer);
        } finally {
            writer.close();
        }
    }
}
