{- This module was generated from data in the Kate syntax
   highlighting file perl.xml, version 1.31, by Anders Lund (anders@alweb.dk) -}

module Text.Highlighting.Kate.Syntax.Perl
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Perl"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.pl;*.PL;*.pm"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Perl","normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Perl","normal") -> return ()
      ("Perl","find_quoted") -> return ()
      ("Perl","find_qqx") -> return ()
      ("Perl","find_qw") -> return ()
      ("Perl","ipstring_internal") -> return ()
      ("Perl","ip_string") -> return ()
      ("Perl","ip_string_2") -> return ()
      ("Perl","ip_string_3") -> return ()
      ("Perl","ip_string_4") -> return ()
      ("Perl","ip_string_5") -> return ()
      ("Perl","ip_string_6") -> return ()
      ("Perl","string") -> return ()
      ("Perl","string_2") -> return ()
      ("Perl","string_3") -> return ()
      ("Perl","string_4") -> return ()
      ("Perl","string_5") -> return ()
      ("Perl","string_6") -> return ()
      ("Perl","find_subst") -> return ()
      ("Perl","subst_curlybrace_pattern") -> return ()
      ("Perl","subst_curlybrace_middle") -> return ()
      ("Perl","subst_curlybrace_replace") -> return ()
      ("Perl","subst_curlybrace_replace_recursive") -> return ()
      ("Perl","subst_paren_pattern") -> return ()
      ("Perl","subst_paren_replace") -> return ()
      ("Perl","subst_bracket_pattern") -> return ()
      ("Perl","subst_bracket_replace") -> return ()
      ("Perl","subst_slash_pattern") -> return ()
      ("Perl","subst_slash_replace") -> return ()
      ("Perl","subst_sq_pattern") -> return ()
      ("Perl","subst_sq_replace") -> return ()
      ("Perl","tr") -> (popContext) >> pEndLine
      ("Perl","find_pattern") -> return ()
      ("Perl","pattern_slash") -> return ()
      ("Perl","pattern") -> return ()
      ("Perl","pattern_brace") -> return ()
      ("Perl","pattern_bracket") -> return ()
      ("Perl","pattern_paren") -> return ()
      ("Perl","pattern_sq") -> return ()
      ("Perl","regex_pattern_internal_rules_1") -> return ()
      ("Perl","regex_pattern_internal_rules_2") -> return ()
      ("Perl","regex_pattern_internal") -> return ()
      ("Perl","regex_pattern_internal_ip") -> return ()
      ("Perl","pat_ext") -> return ()
      ("Perl","pat_char_class") -> return ()
      ("Perl","find_variable") -> (popContext) >> pEndLine
      ("Perl","find_variable_unsafe") -> (popContext) >> pEndLine
      ("Perl","var_detect") -> (popContext >> popContext) >> pEndLine
      ("Perl","var_detect_unsafe") -> (popContext >> popContext) >> pEndLine
      ("Perl","var_detect_rules") -> (popContext >> popContext) >> pEndLine
      ("Perl","quote_word") -> return ()
      ("Perl","quote_word_paren") -> return ()
      ("Perl","quote_word_brace") -> return ()
      ("Perl","quote_word_bracket") -> return ()
      ("Perl","find_here_document") -> (popContext) >> pEndLine
      ("Perl","here_document") -> return ()
      ("Perl","here_document_dumb") -> return ()
      ("Perl","data_handle") -> return ()
      ("Perl","end_handle") -> return ()
      ("Perl","Backticked") -> return ()
      ("Perl","slash_safe_escape") -> (popContext) >> pEndLine
      ("Perl","package_qualified_blank") -> return ()
      ("Perl","sub_name_def") -> (popContext) >> pEndLine
      ("Perl","sub_arg_definition") -> return ()
      ("Perl","pod") -> return ()
      ("Perl","comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "if unless else elsif while until for each foreach next last break continue return my our local state BEGIN END package sub do given when default __END__ __DATA__ __FILE__ __LINE__ __PACKAGE__"
list_operators = Set.fromList $ words $ "= != ~= += -= *= /= **= |= ||= //= &= &&= ?= + - * % || // && | & < << > >> ^ -> => . , ; :: \\ and or not eq ne lt gt le ge cmp"
list_functions = Set.fromList $ words $ "abs accept alarm atan2 bind binmode bless caller chdir chmod chomp chop chown chr chroot close closedir connect cos crypt dbmclose dbmopen defined delete die dump endgrent endhostent endnetent endprotoent endpwent endservent eof eval exec exists exit exp fcntl fileno flock fork format formline getc getgrent getgrgid getgrnam gethostbyaddr gethostbyname gethostent getlogin getnetbyaddr getnetbyname getnetent getpeername getpgrp getppid getpriority getprotobyname getprotobynumber getprotoent getpwent getpwnam getpwuid getservbyname getservbyport getservent getsockname getsockopt glob gmtime goto grep hex import index int ioctl join keys kill last lc lcfirst length link listen localtime lock log lstat map mkdir msgctl msgget msgrcv msgsnd no oct open opendir ord pack package pipe pop pos print printf prototype push quotemeta rand read readdir readline readlink recv redo ref rename require reset return reverse rewinddir rindex rmdir scalar seek seekdir select semctl semget semop send setgrent sethostent setnetent setpgrp setpriority setprotoent setpwent setservent setsockopt shift shmctl shmget shmread shmwrite shutdown sin sleep socket socketpair sort splice split sprintf sqrt srand stat study sub substr symlink syscall sysread sysseek system syswrite tell telldir tie time times truncate uc ucfirst umask undef unlink unpack unshift untie use utime values vec wait waitpid wantarray warn write"
list_pragmas = Set.fromList $ words $ "strict english warnings vars subs utf8 sigtrap locale open less integer filetest constant bytes diagnostics"

regex_'23'21'5c'2f'2e'2a = compileRegex True "#!\\/.*"
regex_'5cbsub'5cs'2b = compileRegex True "\\bsub\\s+"
regex_'5c'3d'5cw'2b'28'5cs'7c'24'29 = compileRegex True "\\=\\w+(\\s|$)"
regex_'5cb'5c'2d'3f0'5bxX'5d'28'5b0'2d9a'2dfA'2dF'5d'7c'5f'5b0'2d9a'2dfA'2dF'5d'29'2b = compileRegex True "\\b\\-?0[xX]([0-9a-fA-F]|_[0-9a-fA-F])+"
regex_'5cb'5c'2d'3f0'5bbB'5d'28'5b01'5d'7c'5f'5b01'5d'29'2b = compileRegex True "\\b\\-?0[bB]([01]|_[01])+"
regex_'5cb'5c'2d'3f0'5b1'2d7'5d'28'5b0'2d7'5d'7c'5f'5b0'2d7'5d'29'2a = compileRegex True "\\b\\-?0[1-7]([0-7]|_[0-7])*"
regex_'5cb'5c'2d'3f'5b0'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'5c'2e'5b0'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'28'5beE'5d'5c'2d'3f'5b1'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'28'5c'2e'5b0'2d9'5d'2a'29'3f'29'3f = compileRegex True "\\b\\-?[0-9]([0-9]|_[0-9])*\\.[0-9]([0-9]|_[0-9])*([eE]\\-?[1-9]([0-9]|_[0-9])*(\\.[0-9]*)?)?"
regex_'5cb'5c'2d'3f'5b1'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'5cb = compileRegex True "\\b\\-?[1-9]([0-9]|_[0-9])*\\b"
regex_'5c'5c'28'5b'22'27'5d'29'5b'5e'5c1'5d = compileRegex True "\\\\([\"'])[^\\1]"
regex_'28'3f'3a'5b'24'40'5d'5cS'7c'25'5b'5cw'7b'5d'7c'5c'2a'5b'5e'5cd'5c'2a'7b'5c'24'40'25'3d'28'5d'29 = compileRegex True "(?:[$@]\\S|%[\\w{]|\\*[^\\d\\*{\\$@%=(])"
regex_'3c'5bA'2dZ0'2d9'5f'5d'2b'3e = compileRegex True "<[A-Z0-9_]+>"
regex_'5cs'2a'3c'3c'28'3f'3d'5cw'2b'7c'5cs'2a'5b'22'27'5d'29 = compileRegex True "\\s*<<(?=\\w+|\\s*[\"'])"
regex_'5cs'2a'5c'7d'5cs'2a'2f'7b1'2c2'7d = compileRegex True "\\s*\\}\\s*/{1,2}"
regex_'5cs'2a'5b'29'5c'5d'5d'5cs'2a'2f'7b1'2c2'7d = compileRegex True "\\s*[)\\]]\\s*/{1,2}"
regex_'5cw'2b'3a'3a = compileRegex True "\\w+::"
regex_'5cw'2b'5b'3d'5d = compileRegex True "\\w+[=]"
regex_'5cbq'28'3f'3d'5bqwx'5d'3f'5cs'2a'5b'5e'5cw'5cs'5d'29 = compileRegex True "\\bq(?=[qwx]?\\s*[^\\w\\s])"
regex_'5cbs'28'3f'3d'5cs'2a'5b'5e'5cw'5cs'5c'5d'7d'29'5d'29 = compileRegex True "\\bs(?=\\s*[^\\w\\s\\]})])"
regex_'5cb'28'3f'3atr'7cy'29'5cs'2a'28'3f'3d'5b'5e'5cw'5cs'5c'5d'7d'29'5d'29 = compileRegex True "\\b(?:tr|y)\\s*(?=[^\\w\\s\\]})])"
regex_'5cb'28'3f'3am'7cqr'29'28'3f'3d'5cs'2a'5b'5e'5cw'5cs'5c'5d'7d'29'5d'29 = compileRegex True "\\b(?:m|qr)(?=\\s*[^\\w\\s\\]})])"
regex_'5b'5cw'5f'5d'2b'5cs'2a'2f = compileRegex True "[\\w_]+\\s*/"
regex_'5b'3c'3e'22'27'3a'5d'2f = compileRegex True "[<>\"':]/"
regex_'2d'5brwxoRWXOeszfdlpSbctugkTBMAC'5d'5cb = compileRegex True "-[rwxoRWXOeszfdlpSbctugkTBMAC]\\b"
regex_x'5cs'2a'28'27'29 = compileRegex True "x\\s*(')"
regex_'28'5b'5ea'2dzA'2dZ0'2d9'5f'5cs'5b'5c'5d'7b'7d'28'29'5d'29 = compileRegex True "([^a-zA-Z0-9_\\s[\\]{}()])"
regex_'5cs'2b'23'2e'2a = compileRegex True "\\s+#.*"
regex_'5c'5c'5bUuLlEtnaefr'5d = compileRegex True "\\\\[UuLlEtnaefr]"
regex_'5c'5c'2e = compileRegex True "\\\\."
regex_'28'3f'3a'5b'5c'24'40'5d'5cS'7c'25'5b'5cw'7b'5d'29 = compileRegex True "(?:[\\$@]\\S|%[\\w{])"
regex_'28'5b'5e'5cw'5cs'5b'5c'5d'7b'7d'28'29'5d'29 = compileRegex True "([^\\w\\s[\\]{}()])"
regex_'5cs'2b'23'2e'2a'24 = compileRegex True "\\s+#.*$"
regex_'23'2e'2a'24 = compileRegex True "#.*$"
regex_'5c'7d'5bcegimosx'5d'2a = compileRegex True "\\}[cegimosx]*"
regex_'5c'29'5bcegimosx'5d'2a = compileRegex True "\\)[cegimosx]*"
regex_'5c'5d'5bcegimosx'5d'2a = compileRegex True "\\][cegimosx]*"
regex_'27'5bcegimosx'5d'2a = compileRegex True "'[cegimosx]*"
regex_'5c'28'5b'5e'29'5d'2a'5c'29'5cs'2a'5c'28'3f'3a'5b'5e'29'5d'2a'5c'29 = compileRegex True "\\([^)]*\\)\\s*\\(?:[^)]*\\)"
regex_'5c'7b'5b'5e'7d'5d'2a'5c'7d'5cs'2a'5c'7b'5b'5e'7d'5d'2a'5c'7d = compileRegex True "\\{[^}]*\\}\\s*\\{[^}]*\\}"
regex_'5c'5b'5b'5e'5d'5d'2a'5c'5d'5cs'2a'5c'5b'5b'5e'5c'5d'5d'2a'5c'5d = compileRegex True "\\[[^]]*\\]\\s*\\[[^\\]]*\\]"
regex_'28'5b'5ea'2dzA'2dZ0'2d9'5f'5cs'5b'5c'5d'7b'7d'28'29'5d'29'2e'2a'5c1'2e'2a'5c1 = compileRegex True "([^a-zA-Z0-9_\\s[\\]{}()]).*\\1.*\\1"
regex_'28'5b'5e'5cw'5cs'5d'29 = compileRegex True "([^\\w\\s])"
regex_'5c'24'28'3f'3d'2f'29 = compileRegex True "\\$(?=/)"
regex_'2f'5bcgimosx'5d'2a = compileRegex True "/[cgimosx]*"
regex_'5c'7d'5bcgimosx'5d'2a = compileRegex True "\\}[cgimosx]*"
regex_'5c'5d'5bcgimosx'5d'2a = compileRegex True "\\][cgimosx]*"
regex_'5c'29'5bcgimosx'5d'2a = compileRegex True "\\)[cgimosx]*"
regex_'27'5bcgimosx'5d'2a = compileRegex True "'[cgimosx]*"
regex_'5c'5c'5banDdSsWw'5d = compileRegex True "\\\\[anDdSsWw]"
regex_'5c'5c'5bABbEGLlNUuQdQZz'5d = compileRegex True "\\\\[ABbEGLlNUuQdQZz]"
regex_'5c'5c'5b'5cd'5d'2b = compileRegex True "\\\\[\\d]+"
regex_'5b'28'29'3f'5e'2a'2b'7c'5d = compileRegex True "[()?^*+|]"
regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d = compileRegex True "\\{[\\d, ]+\\}"
regex_'5cs'7b3'2c'7d'23'2e'2a'24 = compileRegex True "\\s{3,}#.*$"
regex_'5b'24'40'5d'5b'5e'5d'5cs'7b'7d'28'29'7c'3e'27'5d = compileRegex True "[$@][^]\\s{}()|>']"
regex_'5c'23'5b'5e'29'5d'2a = compileRegex True "\\#[^)]*"
regex_'5b'3a'3d'21'3e'3c'5d'2b = compileRegex True "[:=!><]+"
regex_'5c'5b'3a'5c'5e'3f'5ba'2dz'5d'2b'3a'5c'5d = compileRegex True "\\[:\\^?[a-z]+:\\]"
regex_'5c'24'5b0'2d9'5d'2b = compileRegex True "\\$[0-9]+"
regex_'5b'40'5c'24'5d'28'3f'3a'5b'5c'2b'5c'2d'5f'5d'5cB'7cARGV'5cb'7cINC'5cb'29 = compileRegex True "[@\\$](?:[\\+\\-_]\\B|ARGV\\b|INC\\b)"
regex_'5b'25'5c'24'5d'28'3f'3aINC'5cb'7cENV'5cb'7cSIG'5cb'29 = compileRegex True "[%\\$](?:INC\\b|ENV\\b|SIG\\b)"
regex_'5c'24'5c'24'5b'5c'24'5cw'5f'5d = compileRegex True "\\$\\$[\\$\\w_]"
regex_'5c'24'5b'23'5f'5d'5b'5cw'5f'5d = compileRegex True "\\$[#_][\\w_]"
regex_'5c'24'2b'3a'3a = compileRegex True "\\$+::"
regex_'5c'24'5b'5ea'2dzA'2dZ0'2d9'5cs'7b'5d'5bA'2dZ'5d'3f = compileRegex True "\\$[^a-zA-Z0-9\\s{][A-Z]?"
regex_'5b'5c'24'40'25'5d'5c'7b'5b'5cw'5f'5d'2b'5c'7d = compileRegex True "[\\$@%]\\{[\\w_]+\\}"
regex_'5c'2a'5ba'2dzA'2dZ'5f'5d'2b = compileRegex True "\\*[a-zA-Z_]+"
regex_'5c'2a'5b'5ea'2dzA'2dZ0'2d9'5cs'7b'5d'5bA'2dZ'5d'3f = compileRegex True "\\*[^a-zA-Z0-9\\s{][A-Z]?"
regex_'5b'5c'24'40'25'5d = compileRegex True "[\\$@%]"
regex_'5c'2a'5cw'2b = compileRegex True "\\*\\w+"
regex_'5b'5cw'5f'5d'2b = compileRegex True "[\\w_]+"
regex_'28'5cw'2b'29'5cs'2a'3b'3f = compileRegex True "(\\w+)\\s*;?"
regex_'5cs'2a'22'28'5b'5e'22'5d'2b'29'22'5cs'2a'3b'3f = compileRegex True "\\s*\"([^\"]+)\"\\s*;?"
regex_'5cs'2a'60'28'5b'5e'60'5d'2b'29'60'5cs'2a'3b'3f = compileRegex True "\\s*`([^`]+)`\\s*;?"
regex_'5cs'2a'27'28'5b'5e'27'5d'2b'29'27'5cs'2a'3b'3f = compileRegex True "\\s*'([^']+)'\\s*;?"
regex_'5c'3d'5cs'2a'3c'3c'5cs'2a'5b'22'27'5d'3f'28'5bA'2dZ0'2d9'5f'5c'2d'5d'2b'29'5b'22'27'5d'3f = compileRegex True "\\=\\s*<<\\s*[\"']?([A-Z0-9_\\-]+)[\"']?"
regex_'5c'3d'28'3f'3ahead'5b1'2d6'5d'7cover'7cback'7citem'7cfor'7cbegin'7cend'7cpod'29'5cs'2b'2e'2a = compileRegex True "\\=(?:head[1-6]|over|back|item|for|begin|end|pod)\\s+.*"
regex_'5c'3d'28'3f'3ahead'5b1'2d6'5d'7cover'7cback'7citem'7cfor'7cbegin'7cend'7cpod'29'5cs'2a'2e'2a = compileRegex True "\\=(?:head[1-6]|over|back|item|for|begin|end|pod)\\s*.*"
regex_'5cs'2a'5b'29'5c'5d'5d'3f'5cs'2a'2f'7b1'2c2'7d = compileRegex True "\\s*[)\\]]?\\s*/{1,2}"
regex_'5cw'2b = compileRegex True "\\w+"
regex_'5c'24'5cS = compileRegex True "\\$\\S"
regex_'5cs'2a'5c'28 = compileRegex True "\\s*\\("
regex_'5c'3dcut'2e'2a'24 = compileRegex True "\\=cut.*$"

parseRules ("Perl","normal") =
  (((pColumn 0 >> pRegExpr regex_'23'21'5c'2f'2e'2a >>= withAttribute KeywordTok))
   <|>
   ((pFirstNonSpace >> pString False "__DATA__" >>= withAttribute KeywordTok) >>~ pushContext ("Perl","data_handle"))
   <|>
   ((pFirstNonSpace >> pString False "__END__" >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbsub'5cs'2b >>= withAttribute KeywordTok) >>~ pushContext ("Perl","sub_name_def"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_operators >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_pragmas >>= withAttribute KeywordTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'3d'5cw'2b'28'5cs'7c'24'29 >>= withAttribute CommentTok) >>~ pushContext ("Perl","pod"))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Perl","comment"))
   <|>
   ((pRegExpr regex_'5cb'5c'2d'3f0'5bxX'5d'28'5b0'2d9a'2dfA'2dF'5d'7c'5f'5b0'2d9a'2dfA'2dF'5d'29'2b >>= withAttribute BaseNTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((pRegExpr regex_'5cb'5c'2d'3f0'5bbB'5d'28'5b01'5d'7c'5f'5b01'5d'29'2b >>= withAttribute BaseNTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((pRegExpr regex_'5cb'5c'2d'3f0'5b1'2d7'5d'28'5b0'2d7'5d'7c'5f'5b0'2d7'5d'29'2a >>= withAttribute BaseNTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((pRegExpr regex_'5cb'5c'2d'3f'5b0'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'5c'2e'5b0'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'28'5beE'5d'5c'2d'3f'5b1'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'28'5c'2e'5b0'2d9'5d'2a'29'3f'29'3f >>= withAttribute FloatTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((pRegExpr regex_'5cb'5c'2d'3f'5b1'2d9'5d'28'5b0'2d9'5d'7c'5f'5b0'2d9'5d'29'2a'5cb >>= withAttribute DecValTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((pInt >>= withAttribute DecValTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((pRegExpr regex_'5c'5c'28'5b'22'27'5d'29'5b'5e'5c1'5d >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '&' '\'' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","ip_string"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string"))
   <|>
   ((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","Backticked"))
   <|>
   ((lookAhead (pRegExpr regex_'28'3f'3a'5b'24'40'5d'5cS'7c'25'5b'5cw'7b'5d'7c'5c'2a'5b'5e'5cd'5c'2a'7b'5c'24'40'25'3d'28'5d'29) >> pushContext ("Perl","find_variable") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'3c'5bA'2dZ0'2d9'5f'5d'2b'3e >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cs'2a'3c'3c'28'3f'3d'5cw'2b'7c'5cs'2a'5b'22'27'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","find_here_document"))
   <|>
   ((pRegExpr regex_'5cs'2a'5c'7d'5cs'2a'2f'7b1'2c2'7d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cs'2a'5b'29'5c'5d'5d'5cs'2a'2f'7b1'2c2'7d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cw'2b'3a'3a >>= withAttribute FunctionTok) >>~ pushContext ("Perl","sub_name_def"))
   <|>
   ((pRegExpr regex_'5cw'2b'5b'3d'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cbq'28'3f'3d'5bqwx'5d'3f'5cs'2a'5b'5e'5cw'5cs'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","find_quoted"))
   <|>
   ((pRegExpr regex_'5cbs'28'3f'3d'5cs'2a'5b'5e'5cw'5cs'5c'5d'7d'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","find_subst"))
   <|>
   ((pRegExpr regex_'5cb'28'3f'3atr'7cy'29'5cs'2a'28'3f'3d'5b'5e'5cw'5cs'5c'5d'7d'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","tr"))
   <|>
   ((pRegExpr regex_'5cb'28'3f'3am'7cqr'29'28'3f'3d'5cs'2a'5b'5e'5cw'5cs'5c'5d'7d'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","find_pattern"))
   <|>
   ((pRegExpr regex_'5b'5cw'5f'5d'2b'5cs'2a'2f >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b'3c'3e'22'27'3a'5d'2f >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '/' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","pattern_slash"))
   <|>
   ((pRegExpr regex_'2d'5brwxoRWXOeszfdlpSbctugkTBMAC'5d'5cb >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","find_quoted") =
  (((pRegExpr regex_x'5cs'2a'28'27'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string_6"))
   <|>
   ((pAnyChar "qx" >>= withAttribute KeywordTok) >>~ pushContext ("Perl","find_qqx"))
   <|>
   ((pDetectChar False 'w' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","find_qw"))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string_2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string_3"))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string_4"))
   <|>
   ((pDetectChar False '<' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string_5"))
   <|>
   ((pRegExpr regex_'28'5b'5ea'2dzA'2dZ0'2d9'5f'5cs'5b'5c'5d'7b'7d'28'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","string_6"))
   <|>
   ((pRegExpr regex_'5cs'2b'23'2e'2a >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","find_quoted")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","find_qqx") =
  (((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","ip_string_2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","ip_string_3"))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","ip_string_4"))
   <|>
   ((pDetectChar False '<' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","ip_string_5"))
   <|>
   ((pRegExpr regex_'28'5b'5ea'2dzA'2dZ0'2d9'5f'5cs'5b'5c'5d'7b'7d'28'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","ip_string_6"))
   <|>
   ((pRegExpr regex_'5cs'2b'23'2e'2a >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","find_qqx")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","find_qw") =
  (((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","quote_word_paren"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","quote_word_brace"))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","quote_word_bracket"))
   <|>
   ((pRegExpr regex_'28'5b'5ea'2dzA'2dZ0'2d9'5f'5cs'5b'5c'5d'7b'7d'28'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","quote_word"))
   <|>
   ((pRegExpr regex_'5cs'2b'23'2e'2a >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","find_qw")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","ipstring_internal") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bUuLlEtnaefr'5d >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute StringTok))
   <|>
   ((lookAhead (pRegExpr regex_'28'3f'3a'5b'5c'24'40'5d'5cS'7c'25'5b'5cw'7b'5d'29) >> pushContext ("Perl","find_variable_unsafe") >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ipstring_internal")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","ip_string") =
  (((pDetectChar False '"' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ip_string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","ip_string_2") =
  (((pRangeDetect '(' ')' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ip_string_2")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","ip_string_3") =
  (((pRangeDetect '{' '}' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ip_string_3")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","ip_string_4") =
  (((pRangeDetect '[' ']' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ip_string_4")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","ip_string_5") =
  (((pRangeDetect '<' '>' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ip_string_5")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","ip_string_6") =
  (((pRegExprDynamic "\\%1" >>= withAttribute StringTok))
   <|>
   ((pDetectChar True '1' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","ip_string_6")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","string") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' '\'' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","string_2") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' ')' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pRangeDetect '(' ')' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","string_2")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","string_3") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' '}' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pRangeDetect '{' '}' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","string_3")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","string_4") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' ']' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pRangeDetect '[' ']' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","string_4")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","string_5") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' '<' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '>' >>= withAttribute StringTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","string_5")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","string_6") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pRegExprDynamic "\\%1" >>= withAttribute CharTok))
   <|>
   ((pDetectChar True '1' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","string_6")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","find_subst") =
  (((pRegExpr regex_'5cs'2b'23'2e'2a >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_curlybrace_pattern"))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_paren_pattern"))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_bracket_pattern"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_sq_pattern"))
   <|>
   ((pRegExpr regex_'28'5b'5e'5cw'5cs'5b'5c'5d'7b'7d'28'29'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_slash_pattern"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","find_subst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","subst_curlybrace_pattern") =
  (((pRegExpr regex_'5cs'2b'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_curlybrace_middle"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_curlybrace_pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","subst_curlybrace_middle") =
  (((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_curlybrace_replace"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_curlybrace_middle")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","subst_curlybrace_replace") =
  (((parseRules ("Perl","ipstring_internal")))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Perl","subst_curlybrace_replace_recursive"))
   <|>
   ((pRegExpr regex_'5c'7d'5bcegimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_curlybrace_replace")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","subst_curlybrace_replace_recursive") =
  (((pDetectChar False '{' >>= withAttribute StringTok) >>~ pushContext ("Perl","subst_curlybrace_replace_recursive"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_curlybrace_replace_recursive")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","subst_paren_pattern") =
  (((pRegExpr regex_'5cs'2b'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_paren_replace"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_paren_pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","subst_paren_replace") =
  (((parseRules ("Perl","ipstring_internal")))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'29'5bcegimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_paren_replace")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","subst_bracket_pattern") =
  (((pRegExpr regex_'5cs'2b'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_bracket_replace"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_bracket_pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","subst_bracket_replace") =
  (((parseRules ("Perl","ipstring_internal")))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'5d'5bcegimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_bracket_replace")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","subst_slash_pattern") =
  (((pRegExprDynamic "\\$(?=%1)" >>= withAttribute CharTok))
   <|>
   ((pRegExprDynamic "(%1)" >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_slash_replace"))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_slash_pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","subst_slash_replace") =
  (((pRegExprDynamic "%1[cegimosx]*" >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_slash_replace")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","subst_sq_pattern") =
  (((pRegExpr regex_'5cs'2b'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((parseRules ("Perl","regex_pattern_internal")))
   <|>
   ((pDetectChar False '\'' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","subst_sq_replace"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_sq_pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","subst_sq_replace") =
  (((pRegExpr regex_'27'5bcegimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","subst_sq_replace")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","tr") =
  (((pRegExpr regex_'5c'28'5b'5e'29'5d'2a'5c'29'5cs'2a'5c'28'3f'3a'5b'5e'29'5d'2a'5c'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'7b'5b'5e'7d'5d'2a'5c'7d'5cs'2a'5c'7b'5b'5e'7d'5d'2a'5c'7d >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5b'5b'5e'5d'5d'2a'5c'5d'5cs'2a'5c'5b'5b'5e'5c'5d'5d'2a'5c'5d >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'5b'5ea'2dzA'2dZ0'2d9'5f'5cs'5b'5c'5d'7b'7d'28'29'5d'29'2e'2a'5c1'2e'2a'5c1 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Perl","find_pattern") =
  (((pRegExpr regex_'5cs'2b'23'2e'2a >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","pattern_brace"))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","pattern_paren"))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","pattern_bracket"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute KeywordTok) >>~ pushContext ("Perl","pattern_sq"))
   <|>
   ((pRegExpr regex_'28'5b'5e'5cw'5cs'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Perl","pattern"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","find_pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pattern_slash") =
  (((pRegExpr regex_'5c'24'28'3f'3d'2f'29 >>= withAttribute CharTok))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   ((pRegExpr regex_'2f'5bcgimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pattern_slash")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pattern") =
  (((pRegExprDynamic "\\$(?=%1)" >>= withAttribute CharTok))
   <|>
   ((pRegExprDynamic "%1[cgimosx]*" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   ((pRegExprDynamic "\\$(?=\\%1)" >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pattern")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pattern_brace") =
  (((pRegExpr regex_'5c'7d'5bcgimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pattern_brace")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pattern_bracket") =
  (((pRegExpr regex_'5c'5d'5bcgimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pattern_bracket")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pattern_paren") =
  (((pRegExpr regex_'5c'29'5bcgimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_ip")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pattern_paren")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pattern_sq") =
  (((pRegExpr regex_'27'5bcgimosx'5d'2a >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Perl","regex_pattern_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pattern_sq")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","regex_pattern_internal_rules_1") =
  (((pFirstNonSpace >> pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5c'5c'5banDdSsWw'5d >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bABbEGLlNUuQdQZz'5d >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5c'5c'5b'5cd'5d'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","regex_pattern_internal_rules_1")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","regex_pattern_internal_rules_2") =
  (((pDetect2Chars False '(' '?' >>= withAttribute CharTok) >>~ pushContext ("Perl","pat_ext"))
   <|>
   ((pDetectChar False '[' >>= withAttribute CharTok) >>~ pushContext ("Perl","pat_char_class"))
   <|>
   ((pRegExpr regex_'5b'28'29'3f'5e'2a'2b'7c'5d >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '$' >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5cs'7b3'2c'7d'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","regex_pattern_internal_rules_2")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","regex_pattern_internal") =
  (((parseRules ("Perl","regex_pattern_internal_rules_1")))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_rules_2")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","regex_pattern_internal")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","regex_pattern_internal_ip") =
  (((parseRules ("Perl","regex_pattern_internal_rules_1")))
   <|>
   ((lookAhead (pRegExpr regex_'5b'24'40'5d'5b'5e'5d'5cs'7b'7d'28'29'7c'3e'27'5d) >> pushContext ("Perl","find_variable_unsafe") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("Perl","regex_pattern_internal_rules_2")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","regex_pattern_internal_ip")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Perl","pat_ext") =
  (((pRegExpr regex_'5c'23'5b'5e'29'5d'2a >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b'3a'3d'21'3e'3c'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pat_ext")) >> pDefault >>= withAttribute CharTok))

parseRules ("Perl","pat_char_class") =
  (((pDetectChar False '^' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute BaseNTok))
   <|>
   ((pDetect2Chars False '\\' ']' >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5c'5b'3a'5c'5e'3f'5ba'2dz'5d'2b'3a'5c'5d >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pat_char_class")) >> pDefault >>= withAttribute BaseNTok))

parseRules ("Perl","find_variable") =
  (((pRegExpr regex_'5c'24'5b0'2d9'5d'2b >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5b'40'5c'24'5d'28'3f'3a'5b'5c'2b'5c'2d'5f'5d'5cB'7cARGV'5cb'7cINC'5cb'29 >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5b'25'5c'24'5d'28'3f'3aINC'5cb'7cENV'5cb'7cSIG'5cb'29 >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5c'24'5c'24'5b'5c'24'5cw'5f'5d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5c'24'5b'23'5f'5d'5b'5cw'5f'5d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5c'24'2b'3a'3a >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5c'24'5b'5ea'2dzA'2dZ0'2d9'5cs'7b'5d'5bA'2dZ'5d'3f >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5b'5c'24'40'25'5d'5c'7b'5b'5cw'5f'5d'2b'5c'7d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pAnyChar "$@%" >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5c'2a'5ba'2dzA'2dZ'5f'5d'2b >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect"))
   <|>
   ((pRegExpr regex_'5c'2a'5b'5ea'2dzA'2dZ0'2d9'5cs'7b'5d'5bA'2dZ'5d'3f >>= withAttribute DataTypeTok))
   <|>
   ((pAnyChar "$@%*" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Perl","find_variable_unsafe") =
  (((pRegExpr regex_'5c'24'5b0'2d9'5d'2b >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5b'40'5c'24'5d'28'3f'3a'5b'5c'2b'5c'2d'5f'5d'5cB'7cARGV'5cb'7cINC'5cb'29 >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5b'25'5c'24'5d'28'3f'3aINC'5cb'7cENV'5cb'7cSIG'5cb'29 >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5c'24'5c'24'5b'5c'24'5cw'5f'5d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5c'24'5b'23'5f'5d'5b'5cw'5f'5d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5c'24'2b'3a'3a >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5c'24'5b'5ea'2dzA'2dZ0'2d9'5cs'7b'5d'5bA'2dZ'5d'3f >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5b'5c'24'40'25'5d'5c'7b'5b'5cw'5f'5d'2b'5c'7d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5b'5c'24'40'25'5d >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pRegExpr regex_'5c'2a'5cw'2b >>= withAttribute DataTypeTok) >>~ pushContext ("Perl","var_detect_unsafe"))
   <|>
   ((pAnyChar "$@%*" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Perl","var_detect") =
  (((parseRules ("Perl","var_detect_rules")))
   <|>
   ((parseRules ("Perl","slash_safe_escape")))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules ("Perl","var_detect_unsafe") =
  (((parseRules ("Perl","var_detect_rules")))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules ("Perl","var_detect_rules") =
  (((pRegExpr regex_'5b'5cw'5f'5d'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False ':' ':' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False '-' '>' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '+' '+' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","var_detect_rules")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("Perl","quote_word") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pRegExprDynamic "\\\\%1" >>= withAttribute NormalTok))
   <|>
   ((pDetectChar True '1' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","quote_word")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","quote_word_paren") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '\\' ')' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","quote_word_paren")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","quote_word_brace") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '\\' '}' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","quote_word_brace")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","quote_word_bracket") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '\\' ']' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","quote_word_bracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","find_here_document") =
  (((pRegExpr regex_'28'5cw'2b'29'5cs'2a'3b'3f >>= withAttribute KeywordTok) >>~ pushContext ("Perl","here_document"))
   <|>
   ((pRegExpr regex_'5cs'2a'22'28'5b'5e'22'5d'2b'29'22'5cs'2a'3b'3f >>= withAttribute KeywordTok) >>~ pushContext ("Perl","here_document"))
   <|>
   ((pRegExpr regex_'5cs'2a'60'28'5b'5e'60'5d'2b'29'60'5cs'2a'3b'3f >>= withAttribute KeywordTok) >>~ pushContext ("Perl","here_document"))
   <|>
   ((pRegExpr regex_'5cs'2a'27'28'5b'5e'27'5d'2b'29'27'5cs'2a'3b'3f >>= withAttribute KeywordTok) >>~ pushContext ("Perl","here_document_dumb"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","find_here_document")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","here_document") =
  (((pDetectSpaces >>= withAttribute StringTok))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%1\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5c'3d'5cs'2a'3c'3c'5cs'2a'5b'22'27'5d'3f'28'5bA'2dZ0'2d9'5f'5c'2d'5d'2b'29'5b'22'27'5d'3f >>= withAttribute KeywordTok) >>~ pushContext ("Perl","here_document"))
   <|>
   ((parseRules ("Perl","ipstring_internal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","here_document")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","here_document_dumb") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","here_document_dumb")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","data_handle") =
  (((pColumn 0 >> pRegExpr regex_'5c'3d'28'3f'3ahead'5b1'2d6'5d'7cover'7cback'7citem'7cfor'7cbegin'7cend'7cpod'29'5cs'2b'2e'2a >>= withAttribute CommentTok) >>~ pushContext ("Perl","pod"))
   <|>
   ((pFirstNonSpace >> pString False "__END__" >>= withAttribute KeywordTok) >>~ pushContext ("Perl","normal"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","data_handle")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","end_handle") =
  (((pColumn 0 >> pRegExpr regex_'5c'3d'28'3f'3ahead'5b1'2d6'5d'7cover'7cback'7citem'7cfor'7cbegin'7cend'7cpod'29'5cs'2a'2e'2a >>= withAttribute CommentTok) >>~ pushContext ("Perl","pod"))
   <|>
   ((pFirstNonSpace >> pString False "__DATA__" >>= withAttribute KeywordTok) >>~ pushContext ("Perl","data_handle"))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","end_handle")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Perl","Backticked") =
  (((parseRules ("Perl","ipstring_internal")))
   <|>
   ((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","Backticked")) >> pDefault >>= withAttribute StringTok))

parseRules ("Perl","slash_safe_escape") =
  (((pRegExpr regex_'5cs'2a'5c'7d'5cs'2a'2f'7b1'2c2'7d >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'5b'29'5c'5d'5d'3f'5cs'2a'2f'7b1'2c2'7d >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Perl","package_qualified_blank") =
  (((pRegExpr regex_'5b'5cw'5f'5d'2b >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","package_qualified_blank")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Perl","sub_name_def") =
  (((pRegExpr regex_'5cw'2b >>= withAttribute FunctionTok))
   <|>
   ((lookAhead (pRegExpr regex_'5c'24'5cS) >> pushContext ("Perl","find_variable") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5cs'2a'5c'28 >>= withAttribute NormalTok) >>~ pushContext ("Perl","sub_arg_definition"))
   <|>
   ((pDetect2Chars False ':' ':' >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Perl","sub_arg_definition") =
  (((pAnyChar "*$@%" >>= withAttribute DataTypeTok))
   <|>
   ((pAnyChar "&\\[];" >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ pushContext ("Perl","slash_safe_escape"))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules ("Perl","pod") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'3d'28'3f'3ahead'5b1'2d6'5d'7cover'7cback'7citem'7cfor'7cbegin'7cend'7cpod'29'5cs'2a'2e'2a >>= withAttribute CommentTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'3dcut'2e'2a'24 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","pod")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Perl","comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Perl","comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("Perl","normal") <|> fail ("Unknown context" ++ show x)
