package CExpr::Alignof;

use 5.6.0;
use strict;
use warnings;

use CExpr;

our @ISA = qw/CExpr/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $type = shift;

    my $self = {type => $type,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $type = $self->{type}->dump_c;

    return "__alignof__($type)";
  }

sub type
  {
    my $self = shift;

    return $self->{type};
  }

sub compute
  {
    my $self = shift;

    my $bits = $self->{type}->alignment;

    # Round up
    if ($bits % 8 == 0)
      {
        return $bits / 8;
      }
    else
      {
        return ($bits / 8) + 1;
      }
  }

sub get_refs
  {
    my $self = shift;
    return ($self->{type}->get_refs);
  }

sub layout
  {
    my $self = shift;
    my $accept_incomplete = shift;
    my $namespace = shift;
    $self->{type}->layout($accept_incomplete, $namespace);
  }

1;
