package CParse::Op::Cast;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;

use CExpr::Cast;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $arg = shift;
    my $type = shift;

    my $self = {arg => $arg,
                type => $type,
               };
    bless $self, $class;
    return $self;
  }

sub args
  {
    my $self = shift;
    return ($self->{arg});
  }

sub dump_c
  {
    my $self = shift;
    my $type = $self->{type}->dump_c;
    my $arg = $self->{arg}->dump_c;

    return "(($type) $arg)";
  }

sub get_expr
  {
    my $self = shift;
    my $namespace = shift;

    my $type = $self->{type}->get_type($namespace);
    my $arg = $self->{arg}->get_expr($namespace);

    return new CExpr::Cast $type, $arg;
  }

1;
