/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2004-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl>
 *
 */


#ifndef PUBLIC_VERIFY_X509
 #define PUBLIC_VERIFY_X509


/* verify_x509_setParameter options are stated in the verify_x509_datatypes.h file */
#include "verify_x509_datatypes.h"
#include "log.h"

/* 
 * The life cycle of the function is the following:
 * 1. verify_X509_init (&verify_datastruct);
 * 2. verify_X509_setParameter (&verify_datastruct, VERIFY_X509_CERTIFICATE_PEM, pemstring);
 * .. verify_X509_setParameter (&verify_datastruct, VERIFY_X509_PRIVATEKEY_PEM, pemprivatekeystring);
 * .. verify_X509_setParameter (&verify_datastruct, VERIFY_X509_CA_PATH, capath);
 * 3. verify_X509_verify (&verify_datastruct);
 * 4. verify_X509_term (&verify_datastruct);
 */
 
 
/* These are the interacting function for a stand-alone verification call out.
   To prepare for multi-threaded environments, a pointer to the internal_verify_x509_data_t structure
   is initialized, and needs to be passed on throughout the life cycle of the functions until its destruction */


int verify_X509_init         (internal_verify_x509_data_t **);
/* int verify_X509_setParameter (internal_verify_x509_data_t **, int, void *); */
int verify_X509_setParameter (internal_verify_x509_data_t **, int, ...);
int verify_X509_verify       (internal_verify_x509_data_t **);
int verify_X509_term         (internal_verify_x509_data_t **);

lcmaps_proxy_type_t lcmaps_type_of_proxy(X509 *);

#endif /* PUBLIC_VERIFY_X509 */
