#!/usr/bin/python
from gi.repository import Gtk
Gtk.require_version('2.0')
from gi.repository import Grip


# XXX For now, we'll use Grip directly. Once we have a good sense of what's
# going to be needed in general for general Python code using Grip, we might
# want to put that stuff in a wrapper grip module, and import everything from
# there instead.


class GestureTester(object):

    def __init__(self):
        builder = Gtk.Builder()
        builder.add_from_file("pygrip-gestures.xml")
        builder.connect_signals(self)
        self.window = builder.get_object("window1")
        self.gesture_manager = Grip.GestureManager()
        self.window.show()

    def window_mapped(self, widget, data=None):
        # The gesture manager is only going to be needed for GTK2, since GTK3
        # will have the gesture API natively. Conversely, pygrip will only be
        # for GTK2, since PyGTK3 will having the bindings.
 
        finger_count = 2
        self.gesture_manager.register_window(widget, Grip.GestureType.PINCH, finger_count, self.callback, None)

    def callback(self, window, time_type, gesture_event, data):
        print "received gesture"

    def quit(self, widget, data=None):
        Gtk.main_quit()


if __name__ == "__main__":
    app = GestureTester()
    Gtk.main()
