/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.spi;

import java.io.IOException;
import java.util.Collection;

/**
 * An interface for obtaining DeploymentRepository for a Profile.
 *  
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public interface ProfileRepository
{
   /**
    * Get the keys for all known profiles
    * @return keys for all known profiles
    */
   public Collection<ProfileKey> getProfileKeys();

   /**
    * Create a new DeploymentRepository for a profile.
    * 
    * @param key - the key for the Profile to create the DeploymentRepository for.
    * @return the profile DeploymentRepository
    * @throws IOException thrown if the repository cannot be created or
    *    already exists
    * @throws Exception for any error
    */
   public DeploymentRepository createProfileDeploymentRepository(ProfileKey key)
      throws Exception;

   /**
    * Get the DeploymentRepository for the given profile key.
    * 
    * @param key - the key for the Profile to obtain the DeploymentRepository for.
    * @return the profile DeploymentRepository
    * @throws NoSuchProfileException thrown if there is no such profile.
    * @throws Exception for any error
    */
   public DeploymentRepository getProfileDeploymentRepository(ProfileKey key)
      throws Exception, NoSuchProfileException;

   /**
    * Remove the DeploymentRepository for the given profile key.
    * @param key - the key for the Profile to obtain the DeploymentRepository for.
    * @throws IOException thrown on error removing the repository
    * @throws NoSuchProfileException thrown if there is no such profile.
    * @throws Exception for any error
    */
   public void removeProfileDeploymentRepository(ProfileKey key)
      throws Exception, NoSuchProfileException;
}
