/* ----- core/inv3sntrup857, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_inv3sntrup857_checksums[] = {
  "beebb8615a6dd9308e9366214edc0bfda955b1bcdbd191941c48d7febf3412cd",
  "b7973784222ad1aec8dc6b5cd12bdd500f7297561bbd70a7e899598d4bda2cd1",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_inv3sntrup857_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_inv3sntrup857_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_inv3sntrup857_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_inv3sntrup857_CONSTBYTES

static void *storage_core_inv3sntrup857_h;
static unsigned char *test_core_inv3sntrup857_h;
static void *storage_core_inv3sntrup857_n;
static unsigned char *test_core_inv3sntrup857_n;
static void *storage_core_inv3sntrup857_k;
static unsigned char *test_core_inv3sntrup857_k;
static void *storage_core_inv3sntrup857_c;
static unsigned char *test_core_inv3sntrup857_c;
static void *storage_core_inv3sntrup857_h2;
static unsigned char *test_core_inv3sntrup857_h2;
static void *storage_core_inv3sntrup857_n2;
static unsigned char *test_core_inv3sntrup857_n2;
static void *storage_core_inv3sntrup857_k2;
static unsigned char *test_core_inv3sntrup857_k2;
static void *storage_core_inv3sntrup857_c2;
static unsigned char *test_core_inv3sntrup857_c2;

#define precomputed_core_inv3sntrup857_NUM 5

static const unsigned char precomputed_core_inv3sntrup857_h[precomputed_core_inv3sntrup857_NUM][crypto_core_OUTPUTBYTES] = {
  {255,255,255,0,255,255,1,1,1,1,1,0,1,255,255,1,0,255,1,1,0,1,1,1,0,1,255,0,1,0,0,255,1,0,0,1,255,1,1,1,1,0,1,255,255,1,1,0,0,255,0,1,1,0,1,255,1,1,0,1,0,1,1,255,0,0,1,0,0,0,0,255,0,0,1,1,255,0,1,255,255,0,255,1,255,255,255,0,0,0,1,255,255,255,0,255,0,1,1,1,255,1,1,0,255,0,255,255,255,1,255,1,255,0,255,1,1,255,1,1,255,0,0,255,0,0,255,0,0,255,255,1,0,0,1,1,1,0,1,0,1,0,0,0,0,1,1,1,1,0,255,255,0,1,1,255,1,255,255,255,0,255,0,1,255,0,0,255,255,255,0,1,0,1,1,0,0,1,255,255,1,0,255,0,255,0,255,255,1,0,1,255,1,1,255,0,255,0,1,0,1,255,0,1,0,1,255,1,1,1,1,0,1,0,0,1,1,1,1,0,1,255,1,0,255,255,1,0,0,0,1,1,0,0,0,1,1,0,255,1,255,0,255,0,255,0,0,1,255,1,0,1,1,255,255,0,0,0,0,255,255,0,1,255,255,255,0,0,1,1,0,255,255,255,0,0,255,0,1,0,0,1,255,255,1,1,1,0,255,1,1,0,255,0,0,0,1,1,255,1,1,0,255,0,255,1,1,0,0,255,0,0,0,1,1,255,1,0,255,0,1,0,0,1,1,255,1,255,255,255,0,255,1,255,1,0,255,255,1,1,1,255,0,255,255,1,0,0,1,0,1,0,1,255,255,1,255,255,255,255,0,255,1,255,1,0,255,1,255,0,255,1,1,0,1,0,0,0,1,1,1,255,1,255,0,255,0,1,255,0,0,255,1,255,1,0,255,1,1,1,1,1,255,1,0,0,0,1,1,1,255,1,0,1,0,0,0,1,1,1,0,0,1,1,255,1,0,0,255,1,1,255,1,0,255,1,255,1,1,255,1,0,0,1,255,1,0,1,255,0,0,0,1,1,1,1,1,1,1,0,1,255,1,0,255,0,255,1,1,255,1,0,255,1,255,255,0,0,255,0,0,255,0,1,255,1,255,0,255,255,255,1,0,1,0,0,1,1,0,255,1,1,1,255,0,0,1,1,255,0,255,0,0,1,0,0,0,1,1,0,255,255,1,0,0,1,255,1,1,0,255,255,0,1,1,1,0,255,0,1,0,0,0,255,1,1,1,255,0,0,255,1,255,1,255,255,1,0,1,0,255,1,255,255,0,1,0,0,255,1,0,255,0,0,255,255,0,1,1,1,0,255,0,255,0,0,1,1,1,1,1,0,0,1,0,0,0,0,1,255,255,255,1,0,255,1,1,0,1,1,0,0,1,0,0,1,255,1,1,0,0,255,0,255,1,255,0,0,255,1,1,255,0,0,1,1,0,255,255,1,1,1,255,1,255,1,1,0,0,0,0,1,255,0,255,1,1,0,255,255,1,1,1,0,255,0,1,255,255,1,0,255,255,1,255,255,0,255,1,1,255,255,0,1,0,1,255,1,1,1,255,0,0,1,255,255,0,1,0,1,1,0,1,255,0,0,255,255,255,1,255,0,255,0,0,0,1,1,0,0,1,255,255,0,255,1,255,1,255,255,255,255,0,255,1,1,1,1,1,0,0,0,255,255,0,0,0,255,1,255,0,0,1,1,0,0,0,255,0,1,255,0,1,0,0,0,0,0,1,255,1,255,1,0,1,255,0,1,1,0,255,255,255,0,255,1,1,1,255,0,1,1,1,1,0,1,1,1,1,1,0,1,1,255,255,0,1,255,255,1,255,255,1,255,1,255,1,255,255,255,255,0,0,255,1,0,1,1,1,255,255,255,0,255,255,1,1,255,1,255,255,255,255,0,0,1,0,0,1,1,255,1,0,255,255,255,0,0},
  {255,255,255,255,255,255,1,0,255,1,1,0,0,0,1,255,255,1,255,255,255,1,255,1,0,1,0,255,255,0,1,1,0,255,0,0,255,255,1,0,255,1,255,0,255,255,255,1,0,1,0,255,0,255,1,0,0,0,0,255,255,0,255,255,0,1,1,0,0,1,1,1,255,255,1,255,0,0,0,255,255,255,1,1,1,0,255,255,1,0,1,1,0,0,255,0,255,0,1,0,1,1,0,1,1,0,255,0,0,1,0,0,1,0,0,1,1,255,0,1,1,255,255,1,255,255,0,1,255,0,0,1,1,0,1,1,1,255,0,1,255,1,1,0,255,0,255,255,0,255,1,255,1,0,0,0,1,255,1,0,1,0,255,0,255,0,0,1,0,255,255,0,0,1,255,0,255,255,0,255,0,255,1,1,255,0,255,0,255,255,255,0,255,1,0,255,0,255,255,255,255,255,255,0,0,0,255,255,0,1,1,0,255,1,1,255,1,0,255,0,1,1,1,0,1,1,0,255,0,0,255,0,0,255,0,255,1,0,1,0,0,0,255,1,1,1,0,255,1,1,0,1,0,0,1,255,0,1,1,0,255,1,1,0,1,0,0,255,255,0,0,0,1,0,0,255,255,1,0,0,1,0,255,0,1,0,1,1,255,255,0,1,1,255,255,0,1,1,255,0,0,1,1,0,255,0,0,1,1,0,0,0,255,255,255,1,1,1,0,0,1,1,1,255,255,1,255,1,255,0,0,1,1,0,0,0,1,1,0,255,255,1,255,0,0,255,0,255,1,1,255,255,0,255,255,255,1,0,0,255,0,0,255,1,255,0,255,1,255,255,1,0,0,0,1,1,0,255,255,1,1,255,1,0,1,0,255,1,0,255,1,255,0,0,255,255,1,1,0,1,1,1,1,255,0,1,1,255,1,1,1,255,0,255,0,255,1,1,255,255,255,0,1,1,0,0,1,0,0,1,1,0,255,255,255,1,1,255,1,0,0,255,1,1,1,1,1,0,0,255,1,0,255,255,0,0,0,1,255,1,0,0,0,255,255,0,0,255,255,0,255,255,0,1,255,0,1,0,0,1,1,1,1,1,255,255,1,1,255,255,1,0,1,0,1,255,1,1,0,255,1,0,1,0,255,0,0,0,255,255,1,1,1,255,1,0,0,1,0,0,0,0,0,255,0,0,1,0,255,0,1,1,0,0,1,255,1,255,1,0,255,1,0,255,0,255,0,255,1,1,255,255,255,255,0,255,1,1,1,1,1,0,1,0,1,1,255,255,0,255,1,255,1,255,1,0,0,1,255,0,1,255,0,0,255,255,1,0,255,1,1,0,1,1,1,0,255,1,0,255,255,1,1,1,0,0,255,255,0,1,0,1,255,0,1,255,1,1,0,0,255,1,1,255,1,0,1,255,255,1,0,1,1,0,255,255,0,0,0,1,0,255,1,255,1,0,255,255,1,1,255,0,1,255,255,255,0,255,255,1,0,0,255,0,1,255,255,0,255,255,255,255,1,0,255,255,0,255,0,0,255,0,1,255,0,0,255,0,1,1,0,255,0,255,0,255,1,255,1,0,255,0,0,1,1,1,1,255,1,1,255,1,0,0,0,1,255,0,1,255,0,1,0,0,255,0,255,0,255,255,255,1,255,1,0,255,0,255,0,255,0,255,0,1,0,255,0,0,1,0,255,0,1,0,1,1,1,0,1,255,255,0,255,0,0,255,1,0,255,1,1,1,255,1,255,255,0,255,0,1,255,255,1,255,0,1,255,1,0,0,0,0,255,255,255,1,1,1,1,0,255,255,0,1,1,0,0,1,1,0,1,255,1,255,255,0,0,1,1,0,0,255,0,255,1,1,0,1,255,1,255,1,1,255,255,255,255,1,1,255,255,255,255,0,0,1,1,1,1,255,255,255,255,1,0,0,0,0},
  {0,1,255,255,255,0,255,0,0,255,1,0,0,0,0,0,255,1,0,255,0,0,255,1,0,0,1,255,0,255,1,255,255,0,255,255,1,1,0,1,0,0,0,0,255,0,1,1,0,0,255,0,1,255,1,1,1,255,255,1,255,1,0,0,1,255,255,255,1,1,0,255,1,0,0,255,1,0,255,255,1,1,0,0,255,0,255,1,255,0,0,255,1,1,0,255,255,0,1,0,1,1,1,1,0,0,1,0,0,1,255,0,255,0,1,1,255,0,0,1,1,255,0,255,1,1,255,255,1,1,0,255,0,255,255,255,1,0,1,1,1,255,0,1,1,0,0,0,255,0,255,0,0,255,255,0,255,1,0,255,1,1,1,1,0,1,0,255,1,0,255,255,0,1,0,0,0,1,1,1,0,0,255,255,255,0,1,1,1,0,255,1,1,1,1,0,1,1,0,0,0,0,1,0,1,1,1,0,0,1,255,0,255,0,255,0,1,0,0,255,1,1,0,0,0,1,0,255,1,0,1,0,1,1,255,1,0,0,0,255,0,255,255,255,1,255,255,255,255,255,1,255,255,0,0,255,0,255,1,0,0,255,1,0,1,0,255,255,1,1,255,1,0,0,255,0,255,255,0,255,1,255,255,0,0,0,1,255,255,255,255,1,255,255,0,255,0,255,255,1,255,255,0,1,1,0,0,255,0,255,0,1,255,255,1,0,255,0,255,0,1,0,1,0,0,255,255,0,1,0,1,0,1,1,0,0,255,255,1,0,1,255,1,0,0,1,255,0,0,1,0,0,0,0,255,1,255,0,255,1,255,1,0,0,255,255,0,0,0,0,0,1,0,0,255,0,255,1,255,255,1,255,255,1,1,1,0,255,255,1,0,255,0,1,255,0,0,255,0,1,255,255,0,0,1,1,0,1,0,1,255,0,1,255,1,1,1,0,255,0,0,1,1,255,1,0,1,0,0,255,1,255,255,0,255,255,0,0,255,0,0,255,255,1,0,255,0,0,1,1,255,0,1,0,255,1,1,0,0,0,0,1,1,1,255,1,1,255,255,1,1,255,1,255,1,1,255,1,255,1,255,0,255,0,255,0,1,0,0,0,1,0,255,1,0,0,1,0,0,0,0,1,255,0,255,255,0,1,1,0,0,0,255,255,0,1,255,255,255,255,255,255,255,0,1,1,255,0,255,255,255,0,1,255,0,1,255,255,255,1,1,1,255,0,1,1,1,0,1,0,255,0,0,1,1,255,255,255,0,0,255,1,255,1,1,1,0,1,1,0,255,255,0,0,0,255,0,0,255,0,255,255,255,255,255,0,1,255,255,1,0,0,255,255,255,255,1,1,255,1,1,1,255,0,0,0,0,1,1,0,255,0,255,1,255,0,0,255,0,0,255,255,255,0,1,1,1,0,255,255,255,1,255,1,255,0,255,1,0,255,0,255,0,0,255,255,0,1,255,1,255,255,255,1,255,0,255,1,1,0,1,255,255,0,255,0,0,0,255,1,0,1,255,255,1,1,0,1,255,0,1,1,0,0,1,255,255,1,255,1,1,255,255,255,1,1,255,255,0,1,0,1,1,0,1,255,0,0,255,1,255,1,255,0,255,1,0,0,0,0,255,1,0,0,0,1,0,0,0,0,1,255,0,255,1,1,255,1,1,0,255,0,255,0,0,255,1,1,1,255,255,0,0,1,0,255,255,255,1,0,255,0,1,0,1,255,255,0,0,1,0,1,0,0,1,0,1,0,1,0,0,255,0,1,255,255,0,255,1,0,0,255,1,255,0,1,0,0,255,1,255,255,255,255,255,0,1,1,255,1,255,0,1,255,0,0,255,0,255,255,255,0,1,0,255,0,255,255,255,0,1,1,1,0,0,0,1,0,0,1,1,0,255,1,255,0,1,255,0,1,1,1,255,255,1,0,0,0},
  {0,1,255,255,255,255,255,255,255,255,0,0,0,255,255,255,1,1,255,255,255,0,0,1,255,255,255,255,0,255,1,1,0,1,1,0,1,0,0,1,255,1,1,0,0,0,1,1,1,0,1,1,255,1,1,1,1,0,255,255,1,0,1,1,255,1,255,0,255,0,0,1,1,255,1,1,255,255,0,255,0,0,255,1,1,1,255,255,255,255,255,0,1,1,1,255,255,255,1,0,1,1,1,255,255,255,0,1,1,1,255,1,0,255,0,1,0,1,1,1,1,255,1,1,1,0,0,0,1,0,1,1,1,0,1,1,255,0,1,255,1,1,1,1,0,1,0,0,255,255,255,1,1,255,255,0,1,255,1,1,1,255,0,0,1,0,255,1,1,255,1,1,1,255,255,255,1,1,0,255,0,0,1,0,255,0,1,1,0,0,0,1,255,1,0,1,1,1,0,255,0,0,1,0,1,255,1,255,1,0,0,1,0,0,1,1,0,1,255,1,255,255,1,255,0,0,1,0,255,255,1,1,255,0,0,1,1,0,0,255,255,0,0,1,0,0,0,0,0,1,255,1,255,255,1,1,255,1,255,255,1,1,255,1,1,255,0,1,0,1,255,255,255,1,1,0,0,255,1,1,1,1,1,1,1,0,1,1,0,255,255,255,0,0,255,255,255,255,255,0,1,1,1,255,255,1,255,0,1,1,255,255,255,1,255,255,1,1,255,1,255,255,0,1,1,0,1,255,255,1,255,0,0,255,1,255,255,1,1,0,1,0,1,255,1,255,255,1,255,0,255,0,0,1,1,0,255,0,255,255,0,0,255,1,1,255,255,255,1,255,255,255,1,255,1,0,0,1,1,255,255,0,255,255,255,0,1,0,255,255,0,0,0,0,0,255,1,0,1,1,255,255,1,255,255,0,1,1,0,0,1,255,0,255,0,1,1,0,1,1,1,0,1,255,1,1,0,1,1,255,255,0,1,1,0,1,255,1,0,0,0,255,1,1,0,1,1,0,0,0,0,0,255,0,1,1,1,255,0,1,255,1,1,1,255,1,0,1,0,0,255,0,0,0,255,255,255,255,0,0,0,1,1,0,0,1,1,1,255,1,0,1,255,0,0,1,0,0,0,0,0,0,1,1,255,255,0,255,0,1,1,0,1,255,255,1,0,0,255,1,255,0,255,255,0,0,255,0,1,0,0,1,255,1,1,255,255,255,1,1,0,0,255,0,255,1,255,255,255,0,255,255,0,255,255,1,255,0,1,0,255,0,0,0,1,255,0,0,1,1,1,255,1,255,1,0,0,0,0,0,0,1,1,0,0,0,1,255,255,1,1,1,0,1,1,1,255,1,1,0,0,0,0,255,1,255,255,0,255,1,255,1,255,1,0,1,255,1,1,0,255,0,0,0,1,255,0,1,1,255,255,255,0,0,255,255,0,1,0,255,1,255,0,0,1,1,1,255,1,0,0,0,1,255,1,0,1,0,1,255,0,0,0,255,255,0,1,255,0,255,1,255,1,0,1,255,0,0,1,1,255,1,1,1,0,255,0,0,0,255,1,1,0,255,0,1,0,0,1,255,255,1,255,0,1,255,0,0,255,1,0,1,255,1,255,255,255,1,1,255,1,255,0,1,0,255,255,255,0,255,0,255,0,1,0,0,0,255,255,255,1,0,0,0,1,0,255,255,255,255,0,255,1,255,0,1,1,0,0,1,255,255,0,1,1,0,1,1,1,255,255,0,0,1,255,1,0,1,255,255,255,255,0,0,1,0,255,1,0,255,255,0,0,1,1,1,255,255,255,0,255,255,1,255,255,255,255,1,1,0,0,0,1,255,255,255,1,1,1,0,1,0,255,255,255,255,1,0,0,1,0,1,0,0,0,255,1,255,0,255,0,0,1,255,1,255,0,1,0,1,1,255,0,0,1,0,255,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255},
} ;

static const unsigned char precomputed_core_inv3sntrup857_n[precomputed_core_inv3sntrup857_NUM][crypto_core_INPUTBYTES] = {
  {106,191,4,203,41,122,134,42,100,123,44,27,110,22,1,148,130,213,82,167,202,213,111,45,178,241,10,133,225,117,185,159,145,213,78,38,92,242,248,107,176,33,115,180,115,116,151,53,219,74,178,148,196,79,225,99,82,250,89,31,231,29,253,98,76,108,221,219,207,155,205,200,42,3,9,152,25,35,210,146,222,15,172,115,33,131,78,80,117,51,130,150,57,228,188,164,58,35,123,102,238,33,161,115,36,17,111,35,77,96,218,242,246,218,196,55,139,7,21,228,56,66,228,111,217,149,238,0,246,138,108,30,167,65,164,54,118,110,215,161,202,34,221,133,134,202,239,10,214,136,10,182,20,179,80,159,159,80,169,173,157,157,19,242,179,143,189,245,59,189,243,107,142,51,12,50,137,217,202,220,79,163,210,137,117,10,237,25,70,182,237,58,177,32,9,74,120,180,105,16,93,11,255,240,245,156,109,19,224,14,166,250,161,177,211,115,223,123,123,25,195,103,87,154,135,107,26,123,116,113,242,60,155,125,95,84,232,160,97,231,148,249,136,131,106,84,210,102,231,17,112,245,208,72,232,92,141,37,172,3,199,190,10,50,89,204,89,24,229,44,127,101,109,2,84,181,197,152,212,253,142,42,39,206,103,17,218,220,93,202,250,22,249,245,130,175,9,74,228,197,74,231,141,219,42,46,202,15,3,31,84,138,206,185,94,25,131,243,178,12,229,86,140,195,61,92,69,236,71,207,20,37,253,194,81,251,102,60,94,93,142,48,95,160,133,219,104,18,195,233,240,31,176,95,54,187,11,153,69,237,108,128,140,194,216,192,103,70,128,114,171,107,50,174,248,44,199,175,117,126,229,22,217,8,178,77,77,126,92,220,102,111,206,204,17,244,45,122,101,1,25,39,24,223,253,72,141,92,119,187,53,137,37,85,115,98,119,7,49,222,36,132,48,132,249,125,144,69,199,126,144,141,159,162,123,69,131,199,121,239,169,180,207,29,6,201,227,207,117,229,95,133,38,54,252,31,159,24,17,123,50,96,23,223,5,71,181,228,98,68,117,74,97,27,61,245,27,180,253,63,54,171,162,95,137,26,191,120,238,212,98,82,15,212,237,10,97,2,56,148,226,45,104,157,154,157,47,220,47,17,68,79,52,209,206,149,9,121,8,45,187,183,196,28,65,174,17,141,140,22,131,88,124,146,249,229,192,58,254,139,123,68,185,197,250,124,170,242,185,172,30,24,212,156,110,102,208,202,178,112,39,242,138,75,142,221,146,159,34,206,227,197,15,216,97,109,163,108,72,37,177,64,249,122,59,48,27,151,176,19,189,136,31,16,155,163,83,18,205,171,54,186,253,62,36,126,80,34,240,50,100,24,106,3,86,215,99,194,201,118,11,37,173,191,46,228,143,222,191,80,58,34,18,136,129,28,18,192,55,106,250,202,2,74,161,136,220,105,155,43,170,247,47,179,107,187,203,160,82,61,79,251,51,2,255,187,10,26,157,71,31,83,217,0,7,180,66,93,172,47,252,190,100,37,212,235,172,105,133,108,27,43,35,2,241,123,227,4,195,156,213,7,228,187,161,204,110,89,168,158,57,225,171,250,207,18,202,154,101,176,18,22,190,133,51,61,33,123,163,139,115,180,73,53,194,244,17,142,247,145,165,44,231,236,219,171,52,240,205,233,119,170,227,24,24,110,144,121,32,103,182,188,216,107,31,243,90,5,227,94,222,149,184,87,126,61,227,209,65,128,51,212,159,150,213,205,140,95,250,111,203,142,164,251,100,50,236,74,61,206,32,136,103,162,237,126,120,166,65,43,213,23,143,83,75,181,30,91,228,86,81,233,179,134,87,245,135,103,145,244,155,177,69,201,37,111,75,71,175,153,125,122,170,217,139,189,254,213,40,95,136,41,113,171,30,177,175},
  {61,158,165,254,206,200,239,69,151,3,41,64,127,149,190,156,94,166,145,58,201,177,2,211,85,52,183,29,31,246,56,65,162,2,96,217,99,191,132,201,105,175,95,79,85,136,235,199,85,82,110,158,21,81,192,147,59,155,143,85,215,125,128,192,24,35,193,255,4,205,202,25,101,131,102,240,57,63,111,216,145,110,124,29,53,96,152,24,77,182,87,112,51,191,240,17,56,25,60,171,8,29,249,10,28,33,242,177,97,186,142,180,75,153,200,83,18,57,250,53,48,114,66,82,221,235,189,148,152,125,254,234,164,184,41,94,129,65,56,216,48,148,111,101,255,35,100,45,34,8,23,26,114,234,240,30,236,57,14,150,234,89,16,145,47,225,168,212,134,103,190,255,141,123,105,212,10,30,215,244,182,150,12,6,75,159,106,120,30,10,235,69,14,49,32,30,161,13,32,11,48,137,218,115,70,200,24,48,45,129,53,209,54,8,244,96,27,81,233,222,68,180,9,117,236,30,189,224,95,10,248,135,254,188,121,24,0,66,190,53,229,214,210,189,102,66,93,0,9,199,28,195,124,9,14,131,6,177,66,169,133,206,102,105,34,187,147,226,53,87,63,225,231,172,36,186,201,176,58,77,89,18,209,199,155,123,75,145,239,72,11,98,232,167,183,117,179,113,102,103,75,65,125,141,118,120,182,71,32,72,205,108,211,201,108,23,81,110,68,74,172,76,134,95,185,129,218,65,195,176,169,239,55,77,89,188,30,41,109,100,28,209,90,25,139,95,7,102,53,244,69,109,149,195,34,148,103,143,134,255,199,204,47,213,186,239,156,200,255,186,249,143,73,193,177,130,127,95,199,45,146,108,64,4,135,86,210,231,139,15,108,133,209,219,49,73,64,172,106,67,117,227,241,80,232,141,181,35,84,182,187,118,37,92,38,89,27,90,20,20,188,232,242,224,199,0,69,143,199,223,113,47,30,217,22,129,239,5,134,126,99,235,4,191,145,170,132,146,157,29,76,155,183,10,8,76,190,224,43,36,0,0,76,122,30,183,76,28,217,223,11,68,7,240,73,41,98,105,29,158,122,250,144,44,230,14,187,52,140,38,6,197,205,99,14,202,25,41,191,160,13,30,46,156,120,209,36,105,64,197,134,231,29,85,98,7,206,178,186,208,90,88,56,208,60,94,24,144,105,90,105,220,97,8,45,62,8,167,16,251,188,188,96,132,247,255,109,231,59,160,77,178,67,169,215,148,254,116,189,135,248,201,151,241,8,48,43,65,4,12,8,168,233,183,45,72,167,81,128,185,200,180,88,161,156,183,102,192,70,171,229,168,63,238,235,163,131,69,156,188,188,116,159,175,231,155,68,66,88,139,80,189,134,234,126,63,200,233,119,172,89,182,200,231,240,26,83,105,182,55,106,159,164,131,54,129,136,84,32,241,69,236,88,121,192,200,238,84,48,71,153,179,146,107,90,28,193,145,249,209,38,235,2,235,83,216,43,75,195,80,164,215,212,198,115,73,30,206,39,179,153,140,184,25,126,51,80,7,44,29,218,217,146,41,31,2,252,247,173,77,185,45,32,21,218,204,123,23,28,138,46,19,254,221,4,143,165,158,188,10,191,88,48,113,87,228,245,51,58,31,0,38,87,188,99,175,208,191,233,164,77,102,61,6,15,241,215,196,227,150,255,150,91,17,155,64,70,239,180,85,188,181,42,237,101,82,251,110,212,197,174,51,32,203,236,83,199,164,218,129,117,220,223,98,103,36,202,161,31,103,137,171,132,207,168,220,39,177,39,176,133,39,133,136,244,6,169,196,43,255,39,174,23,33,154,73,248,165,125,197,77,186,236,147,126,127,31,208,113,240,1,19,121,231,120,181,85,39,174,146,63,69,131,186,251,105,145,250,199,115,75,239,39,21,50,82,111},
  {7,144,188,244,28,146,30,101,163,63,101,23,95,48,25,28,101,224,18,94,195,119,108,173,213,240,80,163,81,57,225,208,19,155,93,112,28,114,8,153,141,113,205,251,250,146,19,47,32,53,29,128,190,200,197,20,255,136,248,213,31,120,124,247,106,94,242,161,198,63,44,33,7,149,99,207,246,191,7,226,76,121,157,136,52,42,240,210,126,139,6,206,5,17,190,171,22,216,54,229,79,23,255,96,189,121,68,154,1,120,237,151,174,100,70,56,116,56,95,164,162,29,57,59,83,83,124,30,153,86,129,181,88,35,116,245,115,96,128,151,78,4,179,235,236,40,29,172,143,167,81,14,226,135,65,1,147,88,126,55,21,19,180,107,200,38,105,241,89,253,51,67,233,188,171,77,29,170,185,107,48,216,87,124,75,245,7,190,224,217,201,247,131,179,44,107,28,232,210,142,250,0,6,54,193,60,42,35,69,155,66,251,86,78,132,194,233,201,222,181,216,21,51,113,253,49,76,226,108,153,169,131,137,164,27,133,123,220,119,224,20,235,203,123,38,113,198,190,204,2,160,67,24,168,14,229,237,253,85,134,99,94,191,249,15,165,22,179,88,137,49,228,9,113,16,112,60,241,17,14,219,252,186,75,6,15,85,55,189,30,108,90,168,228,244,197,110,207,108,247,179,32,101,251,191,113,105,219,254,56,134,26,107,27,182,75,242,206,157,209,9,113,117,172,193,77,183,236,125,78,243,249,101,63,130,132,38,47,188,222,87,240,165,74,18,15,42,10,56,169,237,237,70,8,224,245,209,71,44,84,99,27,246,223,223,7,212,50,73,121,142,41,124,183,239,191,247,0,35,77,182,153,170,245,36,247,57,19,100,17,128,134,49,68,217,244,215,80,12,19,249,167,185,54,7,94,42,33,253,199,36,252,209,172,133,188,42,131,71,242,194,12,62,238,239,154,218,81,13,111,105,130,246,199,241,103,151,206,136,251,240,163,7,238,35,221,167,149,221,67,13,173,80,66,167,78,214,82,213,134,232,55,215,204,14,39,122,143,12,27,150,7,212,146,61,85,228,183,241,119,58,81,66,181,4,89,251,106,20,90,36,88,209,187,242,83,206,214,108,150,23,8,110,60,92,90,233,228,140,146,250,230,43,241,37,245,88,75,92,70,129,238,202,68,74,137,41,3,106,221,61,76,53,216,206,120,128,148,230,254,22,230,117,20,191,226,78,193,181,227,224,229,36,221,193,14,243,166,189,58,15,66,14,219,144,198,55,61,127,39,125,53,17,122,245,144,0,227,43,126,3,94,243,53,141,202,38,168,96,199,216,58,69,203,242,88,43,105,203,119,84,77,231,209,134,253,39,242,191,153,235,115,152,17,149,164,157,189,249,236,46,84,72,181,186,42,19,58,33,204,189,233,88,132,154,153,128,239,117,253,73,61,19,152,229,174,58,211,202,144,200,53,235,59,73,132,102,26,22,204,29,161,83,242,4,88,3,247,171,92,192,13,59,10,40,54,26,45,210,185,212,211,1,129,153,180,133,142,246,34,242,93,78,75,113,170,209,255,84,95,252,37,163,81,194,135,254,29,14,67,72,206,100,72,186,79,64,108,228,93,163,207,231,130,12,132,37,195,18,149,201,169,175,58,247,253,65,160,233,166,129,53,135,83,135,100,121,82,1,29,54,125,23,20,220,226,13,140,251,231,2,94,45,186,137,44,43,108,237,249,222,191,70,76,25,156,87,153,17,203,140,52,233,56,100,20,222,101,167,90,52,249,187,81,40,159,213,53,53,67,205,151,64,23,241,116,17,49,204,55,115,14,163,118,67,34,183,167,209,60,60,93,6,73,248,166,32,11,47,125,239,48,96,193,102,189,70,143,48,237,94,255,246,74,218,206,183,74,68,202,224,42,179,63,93,141,31},
  {125,252,224,120,134,246,239,29,175,107,41,61,20,76,172,159,111,113,208,121,202,115,46,178,182,4,186,220,156,155,151,68,228,218,206,28,247,162,136,229,49,248,115,196,252,214,231,125,195,120,97,61,132,103,111,89,1,29,36,242,100,10,223,223,0,202,114,166,219,59,93,169,114,79,137,27,175,9,25,204,235,212,205,61,70,51,157,54,34,171,60,84,141,243,109,7,73,161,64,132,123,222,230,114,44,201,61,211,166,180,130,145,206,114,41,241,78,224,70,191,224,154,169,72,197,156,217,80,111,109,208,117,48,74,168,231,80,144,114,180,42,38,241,45,45,197,44,103,140,216,113,241,68,108,65,199,114,16,236,58,110,36,56,251,54,197,193,167,93,89,128,7,136,213,56,75,115,234,213,207,50,209,2,221,255,193,70,143,6,82,136,168,61,75,6,70,223,231,229,27,171,129,234,114,101,61,198,47,102,241,26,15,103,14,244,243,37,213,198,168,47,49,252,62,84,78,205,245,131,59,209,72,218,173,130,35,154,92,180,190,6,192,35,51,101,93,34,166,16,72,180,92,17,202,216,254,245,132,89,179,52,238,144,21,207,237,174,108,245,227,205,216,149,175,205,253,243,148,75,12,193,29,178,30,109,239,142,161,189,223,41,110,91,192,104,27,253,111,124,136,196,170,45,152,46,141,111,43,31,208,184,74,184,151,172,130,52,139,219,95,174,4,79,164,103,45,15,221,20,110,234,222,127,175,185,240,177,113,61,17,239,195,140,79,171,48,162,4,244,11,100,120,134,47,7,86,9,231,49,204,51,37,137,123,20,160,228,25,139,83,174,107,78,130,158,68,254,163,24,150,49,231,33,216,234,18,201,171,146,211,84,98,168,149,21,211,97,122,241,210,218,73,115,70,42,183,138,229,80,248,179,104,119,30,213,133,48,19,231,28,43,50,22,90,216,66,239,251,85,66,234,250,80,182,83,92,2,16,12,52,255,146,111,17,237,16,238,58,91,95,93,218,120,148,73,207,239,30,242,214,241,138,210,59,211,49,224,135,146,226,101,216,163,204,134,59,233,1,238,169,84,21,143,135,247,234,28,249,150,212,168,91,69,1,118,203,138,91,163,106,189,175,160,161,213,169,92,226,100,15,212,163,126,59,242,223,190,121,234,231,196,2,199,126,168,182,106,30,239,148,143,118,247,140,141,231,244,47,23,96,181,248,132,174,251,82,7,57,50,162,28,227,117,92,216,205,55,227,192,244,200,190,243,139,180,227,0,227,21,171,181,105,183,138,178,194,6,87,11,7,210,62,172,197,73,198,71,185,137,215,238,146,71,19,224,192,13,211,195,104,227,61,98,186,247,32,128,185,12,92,138,173,171,5,215,83,39,77,200,6,237,26,167,248,186,204,93,201,103,251,196,62,48,90,216,75,223,76,63,84,238,35,209,194,176,129,221,201,40,252,164,136,113,191,35,129,82,14,227,169,55,132,177,166,202,155,159,75,79,174,122,59,225,130,172,128,172,113,177,255,239,50,162,141,15,162,61,3,151,77,183,77,9,201,245,170,121,5,178,53,14,234,178,72,53,103,205,251,179,80,114,148,121,12,169,232,255,181,148,164,40,81,21,107,133,131,142,243,57,224,193,142,173,106,236,60,171,238,247,1,152,151,122,87,167,246,189,222,106,208,3,29,121,13,117,151,71,42,6,14,9,229,97,235,213,67,92,184,71,64,160,219,163,39,222,148,229,65,197,116,52,125,186,57,247,5,201,222,10,86,6,6,11,79,161,121,114,181,154,204,231,58,166,173,215,85,219,131,171,94,187,2,175,85,202,138,113,79,101,31,23,158,190,48,148,252,135,172,174,162,233,233,41,138,208,209,177,123,84,139,97,116,120,156,60,31,78,1,31,117,254,67,28,165,16,39,31},
  {1,0,0,1,255,0,0,0,1,1,1,255,0,255,1,255,255,0,0,1,1,0,1,255,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_inv3sntrup857_k[precomputed_core_inv3sntrup857_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_inv3sntrup857_c[precomputed_core_inv3sntrup857_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_inv3sntrup857_impl(long long impl)
{
  unsigned char *h = test_core_inv3sntrup857_h;
  unsigned char *n = test_core_inv3sntrup857_n;
  unsigned char *k = test_core_inv3sntrup857_k;
  unsigned char *c = test_core_inv3sntrup857_c;
  unsigned char *h2 = test_core_inv3sntrup857_h2;
  unsigned char *n2 = test_core_inv3sntrup857_n2;
  unsigned char *k2 = test_core_inv3sntrup857_k2;
  unsigned char *c2 = test_core_inv3sntrup857_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup857_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_inv3sntrup857(impl);
    printf("core_inv3sntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup857_implementation(impl),ntruprime_dispatch_core_inv3sntrup857_compiler(impl));
  } else {
    crypto_core = ntruprime_core_inv3sntrup857;
    printf("core_inv3sntrup857 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup857_implementation(),ntruprime_core_inv3sntrup857_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_inv3sntrup857_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_inv3sntrup857_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_inv3sntrup857_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_inv3sntrup857_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_inv3sntrup857_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_inv3sntrup857_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_inv3sntrup857_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_inv3sntrup857_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_inv3sntrup857_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_inv3sntrup857_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_inv3sntrup857(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup857")) return;
  storage_core_inv3sntrup857_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_inv3sntrup857_h = aligned(storage_core_inv3sntrup857_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_inv3sntrup857_n = callocplus(crypto_core_INPUTBYTES);
  test_core_inv3sntrup857_n = aligned(storage_core_inv3sntrup857_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_inv3sntrup857_k = callocplus(crypto_core_KEYBYTES);
  test_core_inv3sntrup857_k = aligned(storage_core_inv3sntrup857_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_inv3sntrup857_c = callocplus(crypto_core_CONSTBYTES);
  test_core_inv3sntrup857_c = aligned(storage_core_inv3sntrup857_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_inv3sntrup857_h2 = callocplus(maxalloc);
  test_core_inv3sntrup857_h2 = aligned(storage_core_inv3sntrup857_h2,crypto_core_OUTPUTBYTES);
  storage_core_inv3sntrup857_n2 = callocplus(maxalloc);
  test_core_inv3sntrup857_n2 = aligned(storage_core_inv3sntrup857_n2,crypto_core_INPUTBYTES);
  storage_core_inv3sntrup857_k2 = callocplus(maxalloc);
  test_core_inv3sntrup857_k2 = aligned(storage_core_inv3sntrup857_k2,crypto_core_KEYBYTES);
  storage_core_inv3sntrup857_c2 = callocplus(maxalloc);
  test_core_inv3sntrup857_c2 = aligned(storage_core_inv3sntrup857_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_inv3sntrup857 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup857();++impl)
      forked(test_core_inv3sntrup857_impl,impl);
    ++test_core_inv3sntrup857_h;
    ++test_core_inv3sntrup857_n;
    ++test_core_inv3sntrup857_k;
    ++test_core_inv3sntrup857_c;
    ++test_core_inv3sntrup857_h2;
    ++test_core_inv3sntrup857_n2;
    ++test_core_inv3sntrup857_k2;
    ++test_core_inv3sntrup857_c2;
  }
  free(storage_core_inv3sntrup857_c2);
  free(storage_core_inv3sntrup857_k2);
  free(storage_core_inv3sntrup857_n2);
  free(storage_core_inv3sntrup857_h2);
  free(storage_core_inv3sntrup857_c);
  free(storage_core_inv3sntrup857_k);
  free(storage_core_inv3sntrup857_n);
  free(storage_core_inv3sntrup857_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

