/* ----- decode/1013xint16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1013xint16_checksums[] = {
  "5938f68c9c3c3631517ca16dcadd1e96b2553bd6b494161c901c1db455e21173",
  "fe23340654861a9e08289b59a9901d646fd8b2cd98b628e8f34889763b7c2a91",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1013xint16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1013xint16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1013xint16_ITEMBYTES

static void *storage_decode_1013xint16_x;
static unsigned char *test_decode_1013xint16_x;
static void *storage_decode_1013xint16_s;
static unsigned char *test_decode_1013xint16_s;
static void *storage_decode_1013xint16_x2;
static unsigned char *test_decode_1013xint16_x2;
static void *storage_decode_1013xint16_s2;
static unsigned char *test_decode_1013xint16_s2;

#define precomputed_decode_1013xint16_NUM 4

static const uint16_t precomputed_decode_1013xint16_x[precomputed_decode_1013xint16_NUM][crypto_decode_ITEMS] = {
  {31782,20057,2688,22103,38817,5759,26006,60032,37514,53695,28892,22904,58001,39580,28324,6016,4813,17208,20868,19387,17492,53713,22928,5118,22942,35620,58727,43130,1790,51387,4252,22161,60500,49775,15951,50327,49507,14045,26171,22175,3779,7934,57934,57267,6348,25308,8175,58620,44070,54061,6476,6525,40224,22118,1731,21643,6211,25074,31456,54210,13085,33969,55357,33643,52274,47055,15387,58483,61132,4592,55808,37985,39875,11960,55375,16353,55992,33102,28972,4504,8089,21727,47363,64178,49238,27584,9870,21006,19990,24661,36914,13110,33599,28508,62851,2816,31249,18560,57355,15895,30299,36062,60098,41799,22175,28894,28085,49434,40436,44723,33880,56134,57782,44646,49133,41267,6060,54030,23301,41418,62683,26157,16739,46363,44494,55573,21966,14551,39961,388,698,44172,7511,53536,47219,54799,8102,5507,25782,3793,30391,17565,47274,51436,44910,37128,33419,32198,37571,62147,3113,26252,5383,35366,47057,59897,39098,22918,50222,28174,28726,53287,54254,6885,64530,7147,45541,25017,52549,9178,20664,59560,17739,39972,24533,58616,58685,21656,22252,21848,13503,44220,34440,34546,32505,12145,49130,45100,44634,33728,16391,59344,51148,31164,36675,48484,49445,58591,4706,49963,38549,21785,18606,48420,53313,45262,31709,49624,57390,25611,34238,46054,16078,28025,52116,52564,31400,7604,22851,45012,33708,58692,13835,13238,49177,28016,6549,13301,63879,23101,14585,3116,9655,13318,23044,31151,20461,462,47837,8526,59721,10626,35978,18309,27761,60507,64319,5005,58895,15710,37076,43859,38575,18994,48340,13406,44792,33363,11278,22018,62200,20553,29968,31495,63916,49039,12298,21096,2768,43327,31432,1477,60991,22205,47439,31325,38406,22977,23950,48910,34601,18142,60384,38958,63672,13593,38751,43614,23854,33540,62526,24869,17343,31626,30266,35795,55898,27547,54914,37882,11641,34793,54788,42925,42671,31540,47795,14516,37743,572,29986,56830,13740,19631,23907,61804,4859,26369,61823,12127,28973,54673,25626,55414,44932,18619,50789,5625,36598,7061,37447,26062,51328,15704,32861,21361,22225,10552,45626,53285,57895,7612,38169,25961,58924,41337,5512,2799,17720,51820,25583,48355,42527,25860,31608,25723,16256,28071,34561,54102,43897,5640,27799,16652,12312,41230,8460,9437,2795,53497,22013,42222,19968,23527,41178,49228,11930,56656,36810,23954,38223,36623,6222,11158,30866,30979,46382,22322,11544,27627,1769,21203,35390,17648,13658,53772,15812,44219,11299,26972,7727,3300,17668,35621,46817,43823,61789,21078,1975,53244,4672,52139,37248,32977,35975,50544,21579,26975,50657,27634,62465,20112,8502,63161,8040,39532,9850,3610,12900,52000,31961,37499,36947,63905,51856,42714,22662,54509,29313,16622,37662,11414,62931,28242,7709,15397,28646,15968,34462,1598,61018,60817,28363,13870,35000,51504,55168,42588,10791,52824,32829,51799,35175,40037,12949,29779,24652,53997,65248,65079,44870,26656,27001,8018,1234,52063,19153,39443,7207,16013,22251,47651,64483,26776,52753,36739,56667,41708,2268,900,57121,50017,11712,59539,6427,14710,33850,30178,50747,52740,49080,47101,43889,30308,62929,64053,40728,3165,6003,838,47360,53771,28360,59922,21140,2141,34023,55424,51476,2776,46184,18914,29142,64231,18522,42995,57107,9560,18041,30188,45926,21571,12963,55949,12952,52042,20346,7865,46844,64998,56645,64165,13716,4776,22135,32602,52351,12526,14684,18047,40603,2416,62116,51188,45104,53575,50265,11365,5393,11204,13821,57092,15132,34288,14792,11393,15055,27946,52491,41973,4920,13704,17545,39800,2165,10844,17677,38385,44553,55134,22364,15123,2955,36751,50912,30068,9228,26805,42333,12140,45909,3128,28581,45098,34384,17143,12477,58250,42800,24445,32540,8293,42337,39361,39591,12137,22390,21983,27390,6757,25327,51977,3216,7113,19291,49505,18108,21016,1045,11151,28388,42354,58971,44786,18819,26959,57719,47548,45972,39490,47122,21832,43241,23368,47750,19831,47429,49765,6672,14009,44698,20824,52189,50243,22332,44057,62899,30805,4753,12325,6714,1563,35064,14659,22472,51574,33700,30360,59585,3640,41835,30217,63119,17394,62329,22225,20604,59313,39320,25668,13308,8843,46963,28191,29836,64991,48989,61541,11077,63614,31771,39742,30892,9350,52066,43889,1600,48829,28635,52398,64570,55576,51447,26902,42043,2676,4049,9497,24700,41942,9672,9345,24445,47631,21262,47210,60775,60467,33381,20114,15826,30762,22060,9623,10327,31622,30883,22600,22204,16088,9229,16036,42671,35481,36183,51091,44003,23799,22801,61898,13065,54365,38042,31810,36398,44021,13606,24779,14072,28492,48362,11515,10535,23753,22971,43091,4877,63122,59855,33080,59652,52499,34089,60159,10359,46630,21783,46869,29056,56585,47969,50562,64903,32416,31240,45695,29245,45734,16314,35507,47488,27637,14275,63708,62716,56959,29452,55000,30422,33955,5906,23411,24628,4244,56265,14940,42314,28104,12505,33547,43686,41834,14405,60176,9530,8269,46879,32191,39327,28241,16349,1125,13636,16859,18247,35721,31889,39380,52499,24832,34887,18189,13133,19294,15206,18357,17459,57982,32571,48357,29369,63654,31595,61281,14307,41687,19988,36740,1744,47769,59554,35987,58387,44354,61681,21213,5187,19750,60029,61524,31421,41266,18097,53805,12509,49924,30827,23038,7423,33308,8116,36184,15244,14254,46193,19463,62203,54016,42139,3993,43380,21564,12889,39166,22887,57209,8380,10440,16500,44256,42334,50171,3656,23483,53583,49231,51416,49761,34480,48502,26653,35300,7068,4690,64987,10985,52061,9883,44590,55979,45526,12881,49141,33450,17682,47465,28883,49981,62356,17566,14635,15668,4332,7504,39063,45912,36165,17636,36349,11758,62471,28365,41909,57064,59998,13005,52013,8828,63622,2710,6769,56913,51155,41952,240,49882,20394,54829,42633,51801,9716,15630,53581,57661,55149,63966,1710,60010,13357,52897,58757,13709,13292,45263,22332,57521,40479,8212,5903,49121,12332,52621,8773,37071,40966,42450,64912,25592,17389,11084,11184,38327,51814,15888,62911,61523,58981,99,3483,28421,11818,22031,54556,60538,55612,62886,40202,11891,36984,29118,33136,24075,19742,28887,14934,35930,12316,56583,14599,9915,38903,2612,49896,55030,33109,31954,43445,15441,58838,55450,12978,9421,38448,19222,4101,50939,46260,15288,17910,34551,44995,4913,25629},
  {29341,22869,52969,31763,31265,44258,19916,27404,4588,23066,38464,33178,23433,62030,12685,27325,18724,14442,23887,37618,945,45490,137,31039,43526,18302,12287,3173,36344,12911,143,47144,7497,63245,20163,1604,31451,44759,25420,14889,22506,7766,1361,17718,54919,27265,61133,62731,3152,6765,38113,2827,395,34362,53618,6275,8936,36706,26871,38041,20952,57237,11429,27280,21897,32902,51317,18684,52209,20637,57823,56480,8867,63572,40169,41038,12159,34832,24904,4566,25459,2535,34015,36460,65171,9871,53696,8803,15923,12677,34084,48454,1017,48986,35392,39183,44226,601,17609,20295,20128,64967,43156,51693,48157,6091,16522,20513,46631,28779,43193,24030,37992,14616,15175,21345,55032,12606,58070,58739,52297,49465,58940,20920,60451,31583,9831,26596,49708,22622,28264,2870,13968,64116,25018,47687,42077,9007,6710,47879,16827,60312,40920,43697,27731,16636,32425,42464,12183,61904,32632,62191,34462,45261,35044,18404,1620,58044,57628,62836,34859,60604,62557,19420,29831,51667,37078,21846,2910,12207,11297,12696,42092,26998,32527,55930,28160,58648,17984,42033,22283,335,41171,40312,44133,11528,63858,44191,49093,12184,50172,4770,33122,29925,12718,37935,9981,50422,43133,48424,46708,1251,47193,58797,30050,36352,23052,9627,3848,8710,6198,57755,27370,62916,58630,38657,49566,42698,21902,63996,9724,19666,60533,60911,55946,60648,25902,50743,56542,28431,53378,62251,3557,18958,30337,15873,2450,59895,53029,36803,47031,4549,61934,12369,42589,53552,9250,12439,39317,29171,37044,62481,59629,18031,53450,3920,12264,45662,53361,34941,52579,31035,56155,35510,6026,27495,53816,61699,47657,6061,12840,34818,41859,42501,47553,869,52413,25200,39669,24842,16190,54336,6376,31500,60618,44551,144,58631,50529,6830,45884,1330,40627,8096,50141,46677,42933,50492,59705,36308,2210,11115,18438,8495,482,28005,25883,40822,52353,39023,42066,34335,65462,46219,31279,32875,20700,18498,24460,62462,15608,16206,32754,39901,63592,14705,7941,43544,64874,20988,49922,56889,32216,40469,2655,44357,53857,5321,52009,52875,24754,45901,2967,25904,47733,51593,19534,21170,44829,10506,47945,50264,46767,11294,53732,29150,2914,37114,37387,37474,47260,11871,3373,54216,41668,47910,55861,42617,65054,26031,26527,7485,12440,4674,9560,65324,63697,46837,53272,48903,37836,33184,24285,31666,29939,49860,28409,24474,37353,51114,6957,29321,18258,21058,2194,5348,17953,39840,30167,39283,35755,49926,54797,48721,39384,13154,37099,28612,56630,21462,6588,9900,57103,31476,35655,41638,2192,28160,51880,24369,1123,18687,3124,44027,25667,52245,42184,48347,59026,50731,14408,10011,2695,21162,44717,50558,56586,32675,36817,65336,17620,33254,7645,40139,60157,49524,39890,15476,39396,17691,15498,30009,6739,31916,1411,59193,48235,27298,41830,36206,63181,28463,23765,44534,27472,21914,18228,62800,1812,12309,44046,10738,1482,10456,44876,56390,18230,11951,14680,55088,31305,50357,54830,21827,4418,49645,42502,65201,167,29505,20447,50922,14984,3308,57473,20073,45091,10527,53019,33274,53375,12535,65463,32368,26634,56630,64726,9950,55621,15537,20364,24274,4895,8171,29085,4949,11321,55881,61924,43960,47952,20896,20932,29126,64766,38523,27305,62026,2258,40794,24014,27307,26368,18165,44172,34691,22315,59556,27248,17214,3603,2803,16322,45688,61872,37903,60696,36791,61619,8319,36938,19049,23125,26565,54601,59853,51741,8072,44063,59835,22109,32997,42942,40470,19048,24041,60160,25867,16922,24981,4288,16453,44146,55724,60456,6533,40074,55883,20104,49008,42909,63981,38853,47080,13139,6221,23005,46789,4361,37998,53185,32332,39840,8179,38256,42256,25905,19074,65489,53541,33071,35884,50995,20771,41206,25507,22584,31228,54273,59493,22475,28979,36772,61454,53128,38264,24809,46759,15311,4922,57274,25508,46500,46671,28848,53273,51645,337,20033,24858,34933,44768,61080,26084,7342,27728,57137,44217,35816,62931,19584,8234,10064,54219,17898,12073,32612,61446,26865,26751,65143,22753,41722,59518,16332,64700,190,32629,10085,24049,27582,33948,20785,17503,57945,29702,34287,60695,46616,35586,38956,46687,29587,8627,34784,52475,62708,39046,50055,64941,53751,45211,21664,51154,1355,24623,3710,26936,11138,45227,35884,32097,44107,38535,9831,37875,39209,52580,7037,37535,11432,46514,8221,44968,56249,9753,41675,350,27369,55297,30817,57044,3334,37618,51608,27593,56420,6437,26362,26677,63570,14429,33718,19816,7929,19221,3283,51517,25995,27295,4347,26014,8527,12705,19316,52997,35588,54869,64099,46518,14059,29026,3703,38210,4231,40246,54353,7010,60965,56670,191,46508,47651,32204,30476,32924,13923,27356,59350,45095,4742,21935,43492,37229,6772,65505,20300,6298,20157,58205,23856,50401,52306,28542,8940,7250,42074,10965,48722,35877,59344,60004,8995,8072,56706,49410,59998,59946,51388,50862,29059,22538,29361,29271,43716,22848,62181,10906,31783,710,29379,54972,11553,61199,61563,13021,47789,31088,39251,11651,49000,23101,27197,18021,44413,45432,29713,17946,37385,42737,27353,39255,24436,27573,24701,49597,43682,27495,22189,46623,9696,36788,26164,20700,17666,55587,34657,37988,7869,28605,47072,24143,54176,10558,51136,38519,30244,27880,46829,6723,36576,11265,34507,30700,38684,29687,1201,62980,43510,48066,50723,8013,50367,63611,40823,64976,36479,6393,22126,17056,33410,60221,27466,56888,10793,40648,9242,51799,56322,64325,41318,6921,61292,61603,62101,56987,4422,24996,26850,15061,14815,44542,37305,15844,63898,26014,35148,2609,65380,35592,25811,48388,36393,32506,61383,51648,48013,31305,34740,39663,1403,64389,22974,14575,20409,23013,39603,13464,11437,76,49641,44781,58055,60968,50132,46661,12764,30971,48580,42182,48420,2706,57569,21372,18966,63201,26696,58485,63547,11208,25280,5864,14326,57794,62018,54598,59984,20352,2234,27235,29992,30816,65134,20541,60588,47312,15712,19930,21703,47704,8462,19806,54260,54201,44693,40778,9079,2491,22601,45336,59836,23435,7888,38153,20504,19764,48345,56820,58724,50799,51529,2307,40979,5566,29858,20332,38748,45416,14790,36177,37179,56129,41271,59091,24765,46522,55904,11841,15985,59746,12826,25350,55574,53272,43631,17028,37456,35471,53158,39956,31411,28713,36284},
  {55954,45007,33599,15653,41406,988,34966,15802,40157,36816,6283,13988,15022,3653,14620,36437,58730,14954,9912,52107,46510,10895,50691,20083,20634,12379,42135,30469,46206,27970,7933,62429,33877,22444,50643,3261,64760,42155,43470,28115,29940,14822,28692,1253,29555,62195,62775,51254,6428,29879,4617,15892,2831,11088,47837,52663,15881,47129,63118,64743,45363,48941,65098,38327,17293,20061,22131,236,28346,54087,44909,60373,24435,23343,10801,43932,52885,43476,23848,47876,30874,11680,45554,43646,51487,36574,39717,46041,16188,15283,51128,59336,38261,7650,46934,64190,957,39462,27893,23243,32084,25676,38451,38917,61383,51540,26546,18603,2237,39010,40066,62868,50442,44205,59506,61081,54121,3544,50886,39412,10248,35322,43924,52975,54623,38566,49768,34441,60636,8457,30295,41222,10675,55011,32632,41456,8538,19011,33507,32410,62865,43708,1598,26586,14701,17183,1526,32182,55453,57552,19271,13205,52391,22767,1655,21935,64199,13296,60759,36113,12389,503,39904,10341,47295,56625,43709,18973,35465,54395,15082,18482,6415,58690,36277,52137,14531,59254,50173,21918,15778,43932,57972,3590,63023,9792,61105,59485,6019,30844,51261,26104,46853,29933,3264,54198,55965,55926,53345,9555,35835,53813,16052,32497,29520,4859,2497,45060,875,48680,23603,62464,1582,49961,10000,9957,62636,52926,2400,55424,47119,49088,4215,15962,46334,5368,6523,11733,15306,29982,58105,38133,5808,44526,58052,58811,45686,63253,54796,44003,46442,63773,26827,45582,7464,10664,57812,26175,38238,30549,11067,35831,62322,32496,8305,31121,56974,20841,48676,39399,29200,2289,31325,47540,17967,14697,11667,11131,10583,62727,46893,61822,38602,60106,28583,40126,59362,25611,47566,10059,42677,43046,52819,21147,35150,28810,64480,25750,18971,26548,6982,26793,5380,64399,63339,62900,15138,62426,42978,23215,34190,63157,6547,62249,21713,40448,46405,32813,53709,45912,61109,6428,35648,33552,62479,19560,53532,22095,65154,43034,59001,7982,24404,17621,53575,9674,33747,34735,35188,22830,4746,30212,1734,30465,24065,24740,30179,25360,16794,62900,4664,15890,39494,61725,27043,19538,28435,63427,37873,5753,55778,28842,53006,57030,10190,60465,22417,58748,38694,2929,41832,62485,36016,20661,34512,39543,41952,11238,5042,32056,19176,56303,30881,40770,55701,22217,36378,15394,11220,40139,12682,16372,40155,61374,34058,5380,15576,44076,27116,22922,10012,57004,54254,5808,63120,14227,65439,47310,22189,32682,64260,51759,60687,31105,30170,10229,5480,25112,48431,53834,58863,30564,682,37846,28370,15426,13542,34505,25706,41754,8042,18061,14650,59720,2959,43169,59197,12441,49513,10988,4852,36092,29427,27485,52404,23270,46143,3316,48759,7758,13305,18826,28899,65149,60150,64482,60194,55187,17018,3311,58266,44606,21125,49850,48985,43138,40500,13304,23165,41041,59070,19769,37570,43680,12065,55709,44813,12972,57330,32059,50698,1258,25878,56126,51711,1983,97,31771,6585,54874,48135,28762,24267,22966,41733,56596,64487,59087,55317,57810,42569,64521,2081,22007,10280,7483,17544,58041,56833,54995,40791,55627,56432,3907,15477,44320,51017,37955,32779,28038,8447,46427,12803,34567,16855,40942,33624,59084,24585,4215,56807,45139,9930,13813,56339,31609,44713,35898,37195,375,19862,19535,57581,25183,38135,41777,40137,61260,3140,2637,36561,26039,15413,62443,30236,15479,14861,40179,8892,38907,11976,20222,32423,60626,16623,50074,63606,42448,29971,59629,59331,16775,59178,48894,33616,63771,1751,36559,56347,26613,15025,6870,46710,49158,17005,43970,27626,27148,51939,19909,17741,65269,15793,11007,59544,52909,18410,39805,31528,65053,96,35765,54182,63634,48099,61424,12101,26325,22196,39042,18744,45313,59549,52645,6926,63593,10327,839,52985,17192,17655,58564,12591,3896,3264,21345,22851,4096,56635,46770,11460,11479,38017,63620,63528,39426,51304,49000,56251,29932,23456,43056,53232,36102,10771,22745,39420,49129,42389,41995,46697,63546,41213,49118,61015,21255,56037,34122,19289,25232,30835,38545,50015,52517,33527,47831,13583,2759,53199,51786,59283,46554,17769,63870,16324,14346,27217,7430,32676,51553,34381,2784,61810,49284,16184,846,57790,52746,26712,25003,12775,1786,20940,41767,2461,14207,58126,38465,3650,59868,12007,9950,51432,25537,62722,33183,32604,39239,33806,62592,9781,19207,6202,45076,45625,64728,60422,33268,58149,30270,60075,40706,22635,44224,18826,16512,65390,18595,64349,3899,61847,21852,8231,35312,19419,46255,16111,33897,29432,3824,42158,13398,11886,40050,30563,3073,29674,65362,1974,50207,15969,53928,34266,26186,11561,50316,46172,30312,21770,51506,13523,8893,45770,46808,54484,29309,36028,61851,38025,9999,48515,40838,61211,21399,51260,64282,36936,42666,27210,32667,33548,52391,27191,5375,58134,4212,43040,15484,19610,53266,46767,36633,44081,48064,15920,26830,60604,19194,25708,13542,23750,43647,22954,16988,7288,48775,9531,1322,17679,43857,58950,33598,6181,30611,3296,54449,62805,24457,62398,6124,38305,18620,23914,53178,56495,38389,56958,39404,45487,60430,7831,33531,40538,13784,18037,56825,22886,1848,20106,32428,45920,22304,20940,12113,10985,57146,49082,54550,52221,30901,6770,64673,65325,52141,36009,48400,69,1130,61177,36777,24638,34306,39705,54249,24681,58246,41824,51527,5965,8087,45249,58836,56646,11972,25653,27824,10629,27220,5324,2281,469,17437,46612,22873,46976,26237,37933,46692,224,41833,7222,31540,59297,27589,36945,30546,27903,15097,25004,32101,39602,16906,29043,31919,45748,29901,49583,54500,27484,60342,3596,36938,23916,4905,21639,56557,55862,6118,49567,17243,53790,11603,46394,35442,51254,31013,29147,14427,26679,39255,13580,62724,61920,36656,56909,51391,8967,65088,42042,21371,7547,24353,7091,27991,7674,737,8128,12472,605,52444,55366,62272,55457,6518,46980,9069,24178,17170,9887,24127,60070,43231,46705,64172,5480,56444,37634,28407,34530,24087,39470,7897,53898,45417,37192,52800,31189,28533,57578,37428,12268,26441,55655,15599,63426,15365,33756,23949,20575,39103,11727,21307,17947,65199,50135,58311,58197,15812,37847,8909,54,22199,47591,9513,32618,41342,41012,19939,33492,38140,60510,64247,52642,12482,12884,63298,32919,37421,34705,63462,65179,59565,2416},
  {18625,25845,19217,15363,14683,46841,55537,65061,46977,25890,15199,36998,38278,29894,57959,17061,9577,28089,56332,24133,63493,64312,52019,11486,51202,63710,61319,42052,48579,6393,59705,2416,16874,45444,55451,23637,1757,39740,31292,3481,8880,61404,4106,63676,37459,21263,21754,57177,47976,18377,37093,41097,2803,5225,16325,39163,59933,30456,31160,4588,17354,35810,38809,43591,40976,52721,33166,59378,16262,59146,34303,46363,47863,30325,18380,29970,65115,11784,751,25837,51442,55252,41555,943,3579,32220,52835,28221,19167,28192,43939,63780,41729,41127,11274,20390,65434,24452,46665,41203,20487,51332,55789,48545,22082,41185,47191,186,32759,32387,18913,9693,44339,55506,3966,51935,18670,58737,18425,23355,42220,39422,57799,37066,43292,43712,4100,23590,16538,40549,39396,32136,29930,22240,61003,58585,38033,39740,29569,9987,21103,22852,13926,13570,46316,7509,32438,10342,55688,58972,52906,61836,49535,27688,32893,8871,16463,4506,3026,2400,61541,20930,6129,21714,63874,15299,63730,17850,34207,42289,47033,2359,32832,14659,4961,44699,53596,14239,11017,33705,56184,23817,47628,56020,12347,54999,51556,916,51050,64877,26039,34007,28740,16709,2882,57971,2730,42064,39095,45115,10484,40999,61018,57778,16298,4923,50346,56722,18755,61969,41350,47565,31972,27250,54611,39384,18709,61194,43769,23262,51047,1409,63374,15506,11936,6412,40750,42078,28557,1086,38271,15622,49272,25605,22386,29798,65424,39203,16013,15751,44609,38636,16757,20261,462,31124,18959,63905,33100,53385,5454,57729,9254,31373,33383,53338,59462,34904,2744,48620,27055,1329,21922,11733,8798,31283,49771,57461,26583,14193,27005,56234,11052,32473,477,28007,40391,55018,2820,8620,26180,42465,17647,8575,31365,35660,6715,3031,54625,61530,32342,60106,45965,5613,2448,34127,20668,10991,39069,60108,14753,47915,3268,20985,6820,32966,15863,60520,52502,3919,22512,16610,49808,15228,10895,53732,33993,12108,63576,37427,18671,39755,9465,9619,37810,45023,53141,9282,48020,64223,59915,20742,23037,35175,727,21698,41271,49768,25127,57716,31127,64973,38287,62194,4039,18311,49138,17736,20561,41921,32927,17582,59215,37101,12178,21524,33212,26178,9161,6089,650,31488,28941,59592,26495,61075,7289,15293,38045,54169,18561,48958,63399,9062,20278,6793,9697,7351,32905,47882,2322,58554,36087,50699,8068,64711,39991,18637,15937,7311,12111,36489,24213,59666,38641,28042,53726,23704,53965,5726,43072,62665,40505,22824,52871,51244,54188,64082,18079,43624,11588,34883,45239,30129,11950,23167,51895,50260,60178,63270,11944,54613,58924,35017,2082,18875,30276,63314,14461,50016,11955,28719,38002,43870,43231,3125,60257,55475,45676,27848,17208,36586,31396,3507,24052,28467,32463,44414,3046,19987,20967,33510,21685,54713,23030,40215,43054,52730,30855,15700,16294,19526,11957,45957,52753,613,46290,340,5083,39047,37540,21260,15595,29795,56126,34344,38159,24305,4995,20613,19663,13812,47289,7353,26731,16828,53098,25518,24667,19921,38661,51111,6725,30722,57060,50017,46779,5969,35482,61811,52199,55239,32011,40206,61201,55646,23907,10173,44083,21706,59308,55452,26920,5492,2078,19924,38509,51817,14438,14952,6238,35236,62023,17133,42804,63864,55383,53955,23038,5474,44579,29255,10865,20390,1557,58340,35575,50510,25382,44972,7254,7710,59229,30971,50237,113,28765,51699,31650,41260,52251,10880,10982,4854,63890,33424,38339,34384,12150,41717,14758,46575,63914,64721,18927,11949,31761,28505,65398,56382,7556,49899,47714,38296,60082,31790,37998,12935,49077,59302,32268,17302,34691,8903,37550,44910,38629,17280,31681,37299,38817,63831,16034,11307,3157,56665,54159,10155,39021,46346,62588,24250,56969,2981,47459,12742,49351,65467,38683,24594,2307,38140,43781,49411,3441,43328,38922,11586,30985,45583,64247,1312,64269,27693,39349,8807,37342,58392,17812,59180,24708,22405,65070,32984,38474,7044,58514,49333,54667,7816,45904,20022,21754,19352,54166,1831,737,60427,15195,38255,25871,63036,29381,58178,54628,19240,51790,27627,8780,5843,12317,61557,57684,18903,1853,65241,40213,63011,62416,43953,6622,2124,15319,17050,29147,50273,52743,38182,47081,16954,54409,47395,28303,23738,57375,11318,18805,34534,55600,5641,11192,11441,42485,55118,23811,39420,41696,45908,1019,47930,60201,40709,40163,18257,61583,2779,6505,46527,58045,13603,41810,8294,39262,65433,7683,3837,14146,5428,18644,18392,49369,38442,22924,41160,29274,1224,37802,46538,33573,2796,14836,19042,7281,20107,29182,32934,51585,57954,21589,54378,60036,425,61206,45407,36783,156,63704,11570,10011,62413,40556,47525,7228,23374,50051,11399,21535,7250,26583,1758,9436,53104,35054,25004,11932,11132,3673,11069,19828,59599,35186,31,63978,20245,27868,17925,47877,4231,42194,38735,2020,54498,35009,60352,848,61471,32346,33918,55770,48136,63461,22855,13326,31237,50082,29579,54407,36779,7681,49258,47185,14600,50900,60830,29227,38419,37093,20338,61957,45019,26984,7667,15704,30663,61001,2381,51189,5481,8459,61006,16624,36450,17025,42706,47541,8121,43901,1475,37799,38755,61497,39045,13009,923,27911,28521,1914,10462,8816,12437,44714,43665,10893,2680,57220,47015,13339,3734,20009,32472,357,41719,34256,34479,32206,7000,64024,36121,16997,18298,62984,18136,24421,38264,58233,33162,56679,57977,12408,32842,31958,39224,45524,64473,64845,47563,8349,16666,18356,24903,50506,54843,8882,47465,7686,61882,20811,37592,27947,42996,31160,45900,21586,48419,40082,58670,49595,8777,48252,57623,24675,4612,114,64487,10164,28710,31953,36017,6278,15922,30975,43411,40658,53211,62485,8704,65422,41016,39873,21358,30524,20569,45091,16397,18474,59618,17559,978,20383,5764,48001,38800,41741,22749,51571,31104,7844,15280,41020,49766,10302,43522,12791,53550,41551,56624,18805,57735,51394,24943,25731,63825,13417,30120,62247,43153,64152,17597,18219,1989,39391,15045,45360,2689,15095,38740,20338,41432,3540,6087,43903,1376,41835,27876,42937,64955,36960,54074,61080,50468,24345,61188,53892,38161,9008,57963,53959,39900,44075,35943,57871,64031,14407,21270,8673,42544,35527,63047,43059,37113,529,42846,2003,266,54287,26985,53569,39881,55538,63786,62094,12409,61660},
} ;

static const unsigned char precomputed_decode_1013xint16_s[precomputed_decode_1013xint16_NUM][crypto_decode_STRBYTES] = {
  {38,124,89,78,128,10,87,86,161,151,127,22,150,101,128,234,138,146,191,209,220,112,120,89,145,226,156,154,164,110,128,23,205,18,56,67,132,81,187,75,84,68,209,209,144,89,254,19,158,89,36,139,103,229,122,168,254,6,187,200,156,16,145,86,84,236,111,194,79,62,151,196,99,193,221,54,59,102,159,86,195,14,254,30,78,226,179,223,204,24,220,98,239,31,252,228,38,172,45,211,76,25,125,25,32,157,102,86,195,6,139,84,67,24,242,97,224,122,194,211,29,51,177,132,61,216,107,131,50,204,207,183,27,60,115,228,204,238,240,17,0,218,97,148,195,155,184,46,79,216,225,63,184,218,78,129,44,113,152,17,153,31,223,84,3,185,178,250,86,192,192,107,142,38,14,82,22,78,85,96,50,144,54,51,63,131,92,111,131,245,0,11,17,122,128,72,11,224,23,62,91,118,222,140,194,234,71,163,159,86,222,112,181,109,26,193,244,157,179,174,88,132,70,219,182,225,102,174,237,191,51,161,172,23,14,211,5,91,202,161,219,244,45,102,99,65,27,181,206,173,21,217,206,85,215,56,25,156,132,1,186,2,140,172,87,29,32,209,115,184,15,214,166,31,131,21,182,100,209,14,183,118,157,68,170,184,236,200,110,175,8,145,139,130,198,125,195,146,195,242,41,12,140,102,7,21,38,138,209,183,249,233,186,152,134,89,46,196,14,110,54,112,39,208,238,211,229,26,18,252,235,27,229,177,185,97,69,205,218,35,184,80,168,232,75,69,36,156,213,95,248,228,61,229,152,84,236,86,88,85,191,52,188,172,136,134,242,134,249,126,113,47,234,191,44,176,90,174,192,131,7,64,208,231,204,199,188,121,67,143,100,189,37,193,223,228,98,18,43,195,149,150,25,85,174,72,36,189,65,208,206,176,221,123,216,193,46,224,11,100,190,133,230,179,206,62,121,109,148,203,84,205,168,122,180,29,67,89,212,175,172,131,68,229,11,54,182,51,25,192,112,109,149,25,245,51,135,249,61,90,249,56,44,12,183,37,6,52,4,90,175,121,237,79,206,1,221,186,78,33,73,233,130,41,138,140,133,71,113,108,91,236,63,251,141,19,15,230,94,61,212,144,83,171,175,150,50,74,212,188,94,52,248,174,83,130,14,44,2,86,248,242,73,80,16,117,7,123,172,249,143,191,10,48,104,82,208,10,63,169,200,122,197,5,63,238,189,86,79,185,93,122,6,150,193,89,142,93,14,191,41,135,222,70,224,235,46,152,184,248,25,53,95,151,94,170,46,93,4,131,62,244,37,97,191,67,138,123,58,118,211,139,90,218,155,107,130,214,250,147,121,45,233,135,4,214,173,167,175,166,52,123,179,186,180,56,111,147,60,2,34,117,254,221,172,53,175,76,99,93,108,241,251,18,1,103,127,241,95,47,45,113,145,213,26,100,118,216,132,175,187,72,101,198,249,21,246,142,149,27,71,146,206,101,128,200,88,61,93,128,113,83,209,86,56,41,58,178,37,208,39,226,188,29,25,149,105,101,44,230,121,161,136,21,239,10,56,69,108,202,239,99,227,188,31,166,4,101,120,123,123,100,128,63,167,109,1,135,86,211,121,171,8,22,151,108,12,65,24,48,14,161,12,33,221,36,235,10,249,208,253,85,238,164,0,78,231,91,218,160,76,192,154,46,80,221,202,143,146,93,79,149,15,143,78,24,150,43,146,120,3,121,46,181,50,87,24,45,235,107,233,6,211,82,62,138,240,68,90,53,12,210,196,61,187,172,35,44,92,105,47,30,228,12,4,69,37,139,225,182,47,171,93,241,86,82,183,7,252,207,64,18,171,203,128,145,209,128,135,140,112,197,75,84,95,105,225,197,242,107,1,244,144,78,54,33,185,246,104,31,108,154,122,38,26,14,100,50,32,203,217,124,123,146,83,144,161,249,144,202,218,166,134,88,237,212,129,114,238,64,30,147,150,44,211,245,82,110,29,30,37,60,230,111,96,62,158,134,62,6,90,238,145,237,203,110,46,54,184,136,48,201,128,215,92,166,39,42,88,206,61,128,87,202,103,137,101,156,149,50,83,116,76,96,237,210,224,254,55,254,70,175,32,104,121,105,82,31,210,4,95,203,209,74,19,154,39,28,141,62,235,86,35,186,227,251,152,104,17,206,131,143,91,221,236,162,220,8,132,3,33,223,97,195,192,45,147,232,27,25,118,57,58,132,226,117,59,198,4,206,184,191,253,183,113,171,100,118,209,245,53,250,24,159,93,12,115,23,70,3,0,185,11,210,200,110,18,234,148,82,93,8,231,132,128,216,20,201,216,10,104,180,226,73,214,113,231,250,90,72,243,167,19,223,88,37,121,70,236,117,102,179,67,84,163,50,141,218,152,50,74,203,122,79,185,30,252,182,230,253,69,221,165,250,148,53,168,18,119,86,90,127,127,204,238,48,92,57,127,70,155,158,112,9,164,242,244,199,48,176,71,209,89,196,101,44,17,21,196,43,253,53,4,223,28,59,240,133,200,57,129,44,207,58,42,109,11,205,245,163,56,19,136,53,137,68,120,155,117,8,92,42,13,69,241,149,9,174,94,215,92,87,19,59,139,11,143,143,224,198,116,117,12,36,181,104,93,165,108,47,85,179,56,12,165,111,42,176,80,134,247,66,189,48,138,227,48,167,125,95,28,127,101,32,97,165,193,153,167,154,105,47,118,87,223,85,254,106,101,26,239,98,9,203,144,12,201,27,91,75,97,193,188,70,24,82,21,4,143,43,228,110,114,165,91,230,242,174,131,73,79,105,119,225,188,185,148,179,66,154,18,184,72,85,233,168,72,91,134,186,119,77,69,185,101,194,16,26,185,54,154,174,88,81,221,203,67,196,60,87,25,172,179,245,85,120,145,18,37,48,58,26,27,6,248,136,67,57,200,87,118,201,164,131,152,118,193,232,56,14,107,163,9,118,143,246,242,67,121,243,209,86,124,80,177,231,152,153,68,100,252,51,139,34,115,183,31,110,140,116,223,253,93,191,101,240,69,43,126,248,27,124,62,155,172,120,134,36,98,203,113,171,64,6,189,190,219,111,174,204,58,252,24,217,247,200,22,105,59,164,116,10,209,15,25,37,124,96,214,163,200,37,129,36,125,95,15,186,14,83,106,184,103,237,51,236,101,130,146,78,210,61,42,120,44,86,151,37,87,40,134,123,163,120,72,88,188,86,216,62,13,36,164,62,175,166,153,138,87,141,147,199,227,171,247,92,17,89,202,241,9,51,93,212,154,148,66,124,46,142,245,171,38,53,203,96,248,54,76,111,234,188,251,44,39,41,201,92,187,89,83,168,13,19,146,246,207,233,56,129,4,233,19,205,41,133,255,234,119,40,38,182,23,85,21,183,128,113,9,221,97,187,130,197,135,253,160,126,8,122,127,178,61,114,166,178,186,63,179,138,128,185,245,107,195,55,220,248,252,244,127,222,12,115,216,214,214,118,163,132,18,23,115,91,52,96,148,16,201,219,92,58,74,165,200,109,217,48,11,131,166,170,106,163,69,56,16,235,58,37,77,32,31,183,191,125,159,153,81,110,221,63,101,4,68,53,219,65,71,71,137,139,145,124,212,153,19,205,0,97,71,136,13,71,77,51,94,75,102,59,181,71,51,68,126,226,59,127,229,188,185,114,166,248,107,123,97,239,227,55,215,162,20,78,132,143,208,6,153,186,162,232,147,140,19,228,66,173,241,240,221,82,67,20,38,77,125,234,84,240,189,122,50,161,177,70,45,210,221,48,4,195,107,120,254,89,255,28,28,130,180,31,88,141,140,59,174,55,113,180,7,76,251,242,0,211,155,164,153,15,116,169,60,84,89,50,254,152,103,89,121,223,188,32,200,40,116,64,224,172,94,165,251,195,72,14,187,91,79,209,79,192,216,200,97,194,176,134,118,189,29,104,228,137,156,27,82,18,219,253,233,42,93,203,155,38,46,174,171,218,214,177,81,50,245,191,170,130,18,69,105,185,211,112,61,195,148,243,158,68,43,57,52,61,236,16,80,29,151,152,88,179,69,141,228,68,253,141,238,45,7,244,205,110,181,163,232,222,94,234,205,50,45,203,124,34,134,248,150,10,113,26,81,222,211,199,224,163,240,0,218,194,170,79,45,214,137,166,89,202,244,37,14,61,77,209,61,225,109,215,222,249,174,6,106,234,45,52,161,206,133,229,141,53,236,51,207,176,60,87,177,224,31,158,20,32,15,23,225,191,44,48,141,205,69,34,207,144,6,160,210,165,144,253,248,99,237,67,76,43,176,43,183,149,102,202,16,62,191,245,83,240,101,230,99,0,155,13,5,111,42,46,15,86,28,213,122,236,60,217,166,245,10,157,115,46,120,144,190,113,112,129,11,94,30,77,215,112,86,58,90,140,28,48,7,221,7,57,187,38,247,151,52,10,232,194,246,214,85,129,210,124,181,169,81,60,214,229,154,216,178,50,205,36,48,150,22,75,5,16,251,198,180,180,184,59,246,69,247,134,195,175,49,19,29,100},
  {157,114,85,89,233,206,19,124,33,122,226,172,204,77,12,107,236,17,26,90,64,150,154,129,137,91,78,242,141,49,189,106,36,73,106,56,79,93,242,146,177,3,178,177,137,0,63,121,6,170,126,71,255,47,101,12,248,141,111,50,143,0,40,184,73,29,13,247,195,78,68,6,219,122,215,174,76,99,41,58,234,87,86,30,81,5,54,69,135,214,129,106,205,238,11,245,80,12,109,26,225,148,11,11,139,1,58,134,114,209,131,24,232,34,98,143,247,104,153,148,216,81,149,223,165,44,144,106,137,85,134,128,117,200,252,72,241,203,157,80,223,225,160,220,163,34,84,248,233,156,78,160,127,47,16,136,72,97,214,17,115,99,231,9,223,132,108,142,147,254,143,38,192,209,99,34,51,62,133,49,36,133,70,189,249,3,90,191,64,138,15,153,194,172,89,2,201,68,71,79,160,78,199,253,148,168,237,201,29,188,203,23,138,64,33,80,39,182,107,112,185,168,222,93,104,148,24,57,71,59,97,83,248,214,62,49,214,226,115,229,73,204,57,193,60,230,184,81,35,236,95,123,103,38,228,103,44,194,94,88,104,110,54,11,144,54,116,250,186,97,71,186,93,164,47,35,54,26,7,187,187,65,152,235,216,159,177,170,83,108,252,64,169,126,224,165,151,47,208,241,120,127,239,242,158,134,205,176,228,136,228,71,84,6,188,226,28,225,116,245,43,136,188,236,93,244,220,75,135,116,211,201,214,144,86,85,94,11,175,47,33,44,152,49,108,164,118,105,15,127,122,218,0,110,24,229,64,70,49,164,11,87,79,1,211,160,120,157,101,172,8,45,114,249,159,172,197,191,152,47,252,195,162,18,98,129,229,116,174,49,47,148,253,38,246,196,125,168,40,189,116,182,227,4,89,184,173,229,98,117,0,142,12,90,155,37,8,15,6,34,54,24,155,225,234,106,196,245,6,229,1,151,158,193,202,166,142,85,252,249,252,37,210,76,117,236,239,237,138,218,232,236,46,101,55,198,222,220,15,111,130,208,43,243,229,13,14,74,129,118,1,62,146,9,247,233,37,207,195,143,183,183,197,17,238,241,81,48,93,166,48,209,34,36,151,48,149,153,243,113,180,144,17,244,237,232,111,70,202,208,80,15,232,47,94,178,113,208,125,136,99,205,59,121,91,219,182,138,138,23,103,107,56,210,3,241,41,186,173,23,40,50,2,136,131,163,5,166,193,185,101,3,189,204,112,98,245,154,10,97,62,63,64,212,232,24,12,123,202,236,7,174,144,0,7,229,97,197,174,26,60,179,50,5,179,158,160,31,221,195,85,182,181,167,60,197,57,233,212,141,162,8,107,43,6,72,47,33,226,1,101,109,27,101,118,159,129,204,111,152,82,164,31,134,182,255,139,180,47,122,107,128,220,80,66,72,140,95,254,243,248,60,78,63,242,127,221,155,104,248,113,57,5,31,24,170,106,253,252,81,2,195,57,222,216,125,21,158,95,10,69,173,97,210,201,20,41,203,139,206,178,96,77,179,151,11,48,101,117,186,137,201,78,76,178,82,29,175,10,41,73,187,88,196,175,182,30,44,228,209,222,113,98,11,250,144,11,146,98,146,156,184,95,46,45,13,200,211,196,162,38,187,53,218,121,166,30,254,175,101,159,103,61,29,152,48,66,18,88,37,44,255,209,248,245,182,24,208,7,191,204,147,160,129,221,94,178,123,243,116,196,194,249,110,154,95,233,145,170,199,45,27,137,114,82,71,66,82,146,8,228,20,33,70,160,155,215,117,115,153,171,139,6,195,13,214,81,190,216,153,98,51,235,144,196,111,54,221,214,83,188,25,172,38,15,223,244,122,71,139,166,162,144,8,0,110,168,202,49,95,99,4,255,72,52,12,251,171,67,100,21,204,200,164,219,188,146,230,43,198,72,56,27,39,135,10,170,82,173,174,126,197,10,221,163,127,209,143,56,255,212,68,230,129,221,29,203,156,253,234,116,193,210,155,116,60,228,153,27,69,138,60,57,117,83,26,172,124,131,5,57,231,107,188,162,106,102,163,110,141,205,246,47,111,213,92,246,173,80,107,154,85,52,71,80,245,20,7,21,48,14,172,242,41,202,5,216,40,76,175,70,220,54,71,175,46,88,57,48,215,73,122,181,196,46,214,67,85,66,17,237,193,6,166,177,254,167,0,65,115,223,79,234,198,136,58,236,12,129,224,105,78,35,176,31,41,27,207,250,129,127,208,247,48,183,255,112,126,10,104,54,221,214,252,222,38,69,217,177,60,140,79,210,94,31,19,235,31,157,113,85,19,57,44,73,218,228,241,184,171,80,187,160,81,196,81,198,113,254,252,123,150,169,106,74,242,210,8,90,159,206,93,171,106,0,103,245,70,140,172,131,135,43,87,164,232,112,106,62,67,19,14,243,10,194,63,120,178,176,241,15,148,24,237,183,143,179,240,127,32,74,144,105,74,85,90,197,103,73,213,205,233,29,202,136,31,31,172,187,233,93,86,229,128,190,167,22,158,104,74,233,93,0,235,11,101,26,66,149,97,192,16,69,64,114,172,172,217,40,236,133,25,138,156,75,218,136,78,112,191,157,167,237,249,197,151,232,183,83,51,77,24,221,89,197,182,9,17,110,148,193,207,76,126,160,155,243,31,112,149,16,165,49,101,130,74,209,255,37,209,47,129,44,140,51,199,35,81,246,160,163,99,56,88,252,121,1,212,101,232,203,87,51,113,164,143,14,240,136,207,120,149,233,96,167,182,207,59,58,19,186,223,164,99,164,181,79,182,176,112,25,208,189,201,81,1,65,78,26,97,117,136,224,174,152,238,228,101,174,28,80,108,49,223,185,172,232,139,211,245,128,76,42,32,80,39,203,211,234,69,41,47,100,127,6,240,241,104,127,104,119,254,225,88,250,162,126,232,204,63,188,252,190,0,117,127,101,39,241,93,190,107,156,132,49,81,95,68,89,226,6,116,239,133,23,237,24,182,2,139,44,152,95,182,147,115,179,33,224,135,251,204,244,244,134,152,135,195,173,253,247,209,155,176,160,84,210,199,75,5,47,96,126,14,56,105,130,43,171,176,44,140,97,125,75,172,135,150,103,38,243,147,41,153,100,205,125,27,159,146,168,44,178,181,29,32,168,175,185,219,25,38,203,162,94,1,233,106,1,216,97,120,212,222,6,13,242,146,152,201,201,107,100,220,37,25,250,102,53,104,82,248,93,56,182,131,104,77,249,30,21,75,211,12,61,201,139,101,159,106,251,16,158,101,79,33,161,49,116,75,5,207,4,139,85,214,99,250,182,181,235,54,98,113,119,14,66,149,135,16,54,157,81,212,98,27,37,238,94,221,191,0,172,181,35,186,204,125,12,119,156,128,99,54,220,106,214,231,39,176,134,18,175,85,228,169,109,145,116,26,225,255,76,79,154,24,189,78,93,227,48,93,225,196,82,204,126,111,236,34,82,28,90,164,213,42,82,190,37,140,208,231,100,234,35,35,136,31,130,221,2,193,94,234,42,234,188,200,174,198,131,113,10,88,177,114,87,114,196,170,64,89,229,242,154,42,39,124,198,2,195,114,188,214,33,45,15,239,123,240,221,50,173,186,112,121,83,153,131,45,104,191,61,90,61,106,101,70,125,173,120,177,17,116,26,70,9,146,241,166,217,106,87,153,116,95,181,107,125,96,189,193,162,170,103,107,173,86,31,182,224,37,180,143,52,102,220,80,2,69,35,217,97,135,100,148,189,30,189,111,224,183,79,94,160,211,62,41,192,199,119,150,36,118,232,108,237,182,67,26,224,142,1,44,203,134,236,119,28,151,247,115,177,4,4,246,246,169,194,187,35,198,77,31,191,196,123,248,119,159,208,253,127,142,249,24,110,86,160,66,130,130,61,235,74,107,56,222,41,42,200,158,26,36,87,202,2,220,69,251,102,161,9,27,108,239,163,240,149,242,155,222,70,17,164,97,226,104,213,58,223,57,254,173,185,145,228,61,154,249,158,101,76,137,49,10,100,255,8,139,211,100,4,189,41,142,250,126,199,239,192,201,141,187,73,122,180,135,239,154,123,5,133,251,190,89,239,56,185,79,229,89,179,154,152,52,173,44,76,0,233,193,237,174,199,226,40,238,212,195,69,182,220,49,251,120,196,189,198,164,36,189,146,10,225,224,124,83,22,74,225,246,72,104,117,228,59,248,200,43,192,98,232,22,246,55,194,225,66,242,70,213,80,234,128,79,186,8,99,106,40,117,96,120,110,254,61,80,172,236,208,184,96,61,218,77,199,84,88,186,14,33,94,77,244,211,185,211,149,174,74,159,119,35,187,9,73,88,24,177,188,233,139,91,208,30,9,149,24,80,52,77,217,188,244,221,100,229,111,198,73,201,3,9,19,160,190,21,162,116,108,79,92,151,104,177,198,57,81,141,59,145,65,219,55,161,211,230,189,96,186,181,96,218,65,46,113,62,98,233,26,50,6,99,22,217,24,208,111,170,132,66,80,146,143,138,166,207,20,156,179,122,41,112,188,141},
  {146,218,207,175,63,131,37,61,190,161,220,3,150,136,186,61,221,156,208,143,139,24,164,54,174,58,69,14,28,57,85,142,106,229,106,58,184,38,139,203,174,181,143,42,3,198,115,78,154,80,91,48,151,164,5,119,126,180,66,109,253,30,221,243,85,132,172,87,211,197,189,12,248,252,171,164,206,169,211,109,244,116,230,57,20,112,229,4,115,115,243,242,55,245,54,200,28,25,183,116,9,18,20,62,15,11,80,43,221,186,183,205,9,62,25,184,142,246,231,252,51,177,45,191,74,254,183,149,141,67,93,78,115,86,236,0,186,110,71,211,109,175,213,235,115,95,47,91,49,42,156,171,149,206,212,169,40,93,4,187,154,120,160,45,242,177,126,170,31,201,222,142,37,155,217,179,60,63,179,59,184,199,200,231,117,149,226,29,86,183,190,250,189,3,38,154,245,108,203,90,84,125,76,100,51,150,5,152,199,239,84,201,178,103,171,72,189,8,98,152,130,156,148,245,10,197,173,172,114,232,153,238,105,211,216,13,198,198,244,153,8,40,250,137,148,171,239,206,95,213,166,150,104,194,137,134,220,236,9,33,87,118,6,161,179,41,227,214,120,127,240,161,90,33,67,74,227,130,154,126,145,245,188,170,62,6,218,103,109,57,31,67,246,5,182,125,157,216,208,224,71,75,149,51,167,204,239,88,119,6,175,85,199,250,240,51,87,237,17,141,101,48,247,1,224,155,101,40,191,184,49,221,189,170,29,74,137,138,123,212,234,58,50,72,15,25,66,229,181,141,169,203,195,56,118,231,253,195,158,85,162,61,156,171,116,226,6,14,47,246,64,38,177,238,93,232,131,23,124,120,61,200,248,101,5,183,237,116,192,12,182,211,157,218,118,218,97,208,83,37,251,139,53,210,180,62,241,126,80,115,251,18,193,9,4,176,107,3,40,190,51,92,0,244,46,6,41,195,16,39,229,38,172,244,190,206,96,9,128,216,15,184,192,191,119,16,90,62,254,180,248,20,123,25,213,45,202,59,30,117,249,226,245,148,176,22,238,173,196,226,187,229,118,178,21,247,12,214,227,171,106,181,29,249,203,104,14,178,40,29,168,41,212,225,63,102,94,149,85,119,59,43,247,139,114,243,240,126,113,32,145,121,142,222,105,81,36,190,231,153,16,114,241,8,93,122,180,185,47,70,105,57,147,45,123,43,87,41,7,245,45,183,126,241,202,150,202,234,167,111,190,156,226,231,11,100,206,185,75,39,181,166,38,168,83,206,155,82,78,137,138,112,224,251,150,100,27,74,180,103,70,27,169,104,4,21,143,251,107,247,180,245,34,59,218,243,226,167,175,90,142,133,181,246,147,25,41,243,209,84,0,158,69,181,45,128,205,209,88,179,181,238,28,25,64,139,16,131,15,244,104,76,28,209,79,86,130,254,26,168,121,230,46,31,84,95,213,68,71,209,202,37,211,131,175,135,116,137,46,89,138,18,4,118,198,6,1,119,1,94,164,96,227,117,16,99,154,65,180,245,56,18,18,62,70,154,29,241,163,105,82,76,19,111,195,247,241,147,121,22,226,217,170,112,14,207,198,222,206,39,49,236,145,87,124,229,38,151,113,11,104,163,21,244,176,140,181,80,208,134,119,154,224,163,230,43,178,19,56,125,232,74,239,219,161,120,66,159,149,217,201,86,26,142,34,60,212,43,203,156,138,49,244,63,219,156,190,239,10,133,4,21,216,60,44,172,236,105,138,89,28,39,172,222,238,211,176,22,144,246,147,55,159,255,206,184,173,86,170,127,4,251,47,202,15,237,129,121,218,117,245,39,104,21,24,98,47,189,74,210,239,229,100,119,170,2,214,147,210,110,66,60,230,52,201,134,106,100,26,163,106,31,141,70,58,57,72,233,143,11,161,168,61,231,153,48,105,193,236,42,244,18,252,140,243,114,93,107,180,204,230,90,63,180,244,12,119,190,78,30,249,51,138,73,227,112,125,254,246,234,226,251,34,235,147,215,122,66,239,12,154,227,62,174,133,82,186,194,89,191,130,168,52,158,248,51,125,90,81,160,190,230,57,77,194,146,160,170,33,47,157,217,13,175,172,50,242,223,59,125,10,198,234,4,22,101,62,219,255,201,191,7,97,0,27,124,185,25,90,214,7,188,90,112,203,94,182,89,5,163,20,221,231,251,207,230,21,216,210,225,73,166,9,252,33,8,247,85,40,40,59,29,136,68,185,226,1,222,211,214,87,159,75,217,112,220,67,15,117,60,32,173,73,199,67,148,11,128,134,109,255,32,91,181,3,50,7,135,215,65,238,159,88,131,204,230,9,96,119,16,231,221,83,176,202,38,245,53,19,220,121,123,169,174,58,140,75,145,119,1,150,77,79,76,237,224,95,98,247,148,49,163,201,156,76,239,68,12,77,10,209,142,183,101,53,60,235,243,28,118,119,60,13,58,243,156,188,34,251,151,200,46,254,78,167,126,210,236,239,64,154,195,118,248,208,165,19,117,237,232,195,231,135,65,42,231,254,190,80,131,27,249,215,6,207,142,27,220,245,103,177,58,214,26,118,182,6,192,109,66,194,171,234,107,12,106,227,202,197,77,77,69,245,254,177,61,255,42,152,232,173,206,234,71,125,155,40,123,29,254,96,0,181,139,166,211,146,248,227,187,240,239,69,47,213,102,180,86,130,152,56,73,1,177,157,232,165,205,14,27,105,248,87,40,71,3,249,206,40,67,247,68,196,228,47,49,56,15,192,12,97,83,67,89,0,16,59,221,178,182,196,44,215,44,129,148,132,248,40,248,2,154,104,200,104,191,187,219,236,116,160,91,48,168,240,207,6,141,19,42,217,88,252,153,233,191,149,165,11,164,105,182,58,248,253,160,222,191,87,238,7,83,229,218,74,133,89,75,144,98,115,120,145,150,95,195,37,205,247,130,215,186,15,53,199,10,207,207,74,202,147,231,218,181,105,69,126,249,196,63,10,56,81,106,6,29,164,127,97,201,77,134,224,10,114,241,132,192,56,63,78,3,190,225,10,206,88,104,171,97,231,49,250,6,204,81,39,163,157,9,127,55,14,227,65,150,66,14,220,233,231,46,222,38,232,200,193,99,2,245,159,129,92,127,71,153,14,132,128,244,53,38,7,75,58,24,20,176,57,178,216,252,6,236,244,129,37,227,62,118,171,234,2,159,107,88,192,172,138,73,128,64,110,255,163,72,93,251,59,15,151,241,92,85,39,32,240,137,219,75,175,180,239,62,105,132,248,114,240,14,174,164,86,52,110,46,114,156,99,119,1,12,234,115,82,255,182,7,31,196,97,62,168,210,218,133,74,102,41,45,140,196,92,180,104,118,10,85,50,201,211,52,189,34,202,178,216,182,212,212,125,114,188,140,155,241,137,148,15,39,131,189,134,159,27,239,151,83,60,200,26,251,72,144,170,166,74,106,155,127,12,131,167,204,55,106,255,20,22,227,116,16,32,168,124,60,154,76,18,208,175,182,25,143,49,172,192,187,48,62,206,104,188,236,250,74,108,100,230,52,198,92,127,170,170,89,92,66,120,28,135,190,59,37,42,5,15,69,81,171,70,230,62,131,37,24,147,119,224,12,177,212,85,245,137,95,190,243,236,23,161,149,188,72,106,93,186,207,175,220,245,149,126,222,236,153,175,177,14,236,151,30,251,130,90,158,216,53,117,70,249,221,102,89,56,7,138,78,172,126,96,179,32,87,204,81,81,47,233,42,58,223,186,191,22,213,253,203,181,120,114,26,161,252,45,255,173,203,169,140,16,189,69,0,106,4,249,238,169,143,62,96,2,134,25,155,233,211,105,96,134,227,96,163,71,201,77,23,151,31,193,176,212,229,70,221,196,46,53,100,176,108,133,41,84,106,204,20,233,8,213,1,29,68,20,182,89,89,128,183,125,102,45,148,100,182,224,0,105,163,54,28,52,123,161,231,197,107,81,144,82,119,255,108,249,58,172,97,101,125,178,154,10,66,115,113,175,124,180,178,205,116,175,193,228,212,92,107,182,235,12,14,74,144,108,93,41,19,135,84,237,220,54,218,230,23,159,193,91,67,30,210,83,45,58,181,114,138,54,200,37,121,219,113,91,56,55,104,87,153,12,53,4,245,224,241,48,143,77,222,191,200,7,35,64,254,58,164,123,83,123,29,33,95,179,27,87,109,250,29,225,2,192,31,184,48,93,2,220,204,70,216,64,243,161,216,118,25,132,183,109,35,114,94,18,67,159,38,63,94,166,234,223,168,113,182,172,250,104,21,124,220,2,147,247,110,226,134,23,94,46,154,217,30,138,210,105,177,72,145,64,206,213,121,117,111,234,224,52,146,236,47,73,103,103,217,239,60,194,247,5,60,220,131,141,93,95,80,191,152,207,45,59,83,27,70,175,254,215,195,199,227,85,227,196,61,215,147,205,34,54,0,183,86,231,185,41,37,106,127,126,161,52,160,227,77,212,130,252,148,94,236,247,250,162,205,194,48,84,50,66,247,151,128,45,146,145,135,230,247,155,254,173,232,112,9},
  {193,72,245,100,17,75,3,60,91,57,249,182,241,216,37,254,129,183,34,101,95,59,134,144,134,149,198,116,103,226,165,66,105,37,185,109,12,220,69,94,5,248,56,251,51,203,222,44,2,200,222,248,135,239,68,164,195,189,249,24,57,233,112,9,234,65,132,177,155,216,85,92,221,6,60,155,60,122,153,13,176,34,220,239,10,16,188,248,83,146,15,83,250,84,89,223,104,187,201,71,229,144,137,160,243,10,105,20,197,63,251,152,29,234,248,118,184,121,236,17,202,67,226,139,153,151,71,170,16,160,241,205,142,129,242,231,134,63,10,231,255,133,27,181,247,186,117,118,204,71,18,117,91,254,8,46,239,2,237,100,242,200,212,215,83,162,175,3,251,13,220,125,99,206,61,110,223,74,32,110,163,171,36,249,1,163,167,160,10,44,166,79,154,255,132,95,73,182,243,160,7,80,132,200,237,217,161,189,66,86,225,160,87,184,186,0,247,127,131,126,225,73,221,37,51,173,210,216,126,15,223,202,238,72,113,229,249,71,59,91,236,164,254,153,199,225,202,144,28,169,192,170,4,16,38,92,154,64,101,158,228,153,136,125,234,116,224,86,75,238,217,228,145,148,60,155,129,115,3,39,111,82,68,89,102,54,2,53,236,180,85,29,182,126,102,40,136,217,92,230,170,206,140,241,127,193,40,108,125,128,167,34,79,64,154,17,210,11,96,9,101,240,194,81,241,23,210,84,130,249,195,59,242,248,186,69,159,133,49,165,185,183,55,9,64,128,67,57,97,19,155,174,92,209,159,55,9,43,169,131,120,219,9,93,12,186,212,218,59,48,215,214,100,201,148,3,106,199,109,253,183,101,215,132,68,112,69,65,66,11,115,226,170,10,80,164,183,152,59,176,244,40,39,160,90,238,178,225,170,63,59,19,170,196,146,221,67,73,17,242,134,161,205,185,228,124,114,106,83,213,216,153,21,73,10,239,249,170,222,90,103,199,129,5,142,247,146,60,160,46,12,25,46,159,94,164,141,111,62,4,127,149,6,61,120,192,5,100,114,87,102,116,144,255,35,153,141,62,135,61,65,174,236,150,117,65,37,79,206,1,148,121,15,74,161,249,76,129,137,208,78,21,129,225,38,36,141,122,103,130,90,208,70,232,88,136,184,10,236,189,175,105,49,5,162,85,213,45,94,34,51,122,107,194,117,224,215,103,113,55,125,105,170,219,44,43,217,126,221,1,103,109,199,157,234,214,4,11,172,33,68,102,225,165,239,68,127,33,133,122,76,139,59,26,215,11,97,213,90,240,86,126,202,234,141,179,237,21,144,9,79,133,188,80,239,42,157,152,204,234,161,57,43,187,196,12,249,81,164,26,198,128,247,61,104,236,22,205,79,15,240,87,226,64,144,194,124,59,143,42,228,209,201,132,76,47,88,248,51,146,239,72,75,155,249,36,147,37,178,147,223,175,149,207,66,36,148,187,223,250,11,234,6,81,253,89,103,137,215,2,194,84,55,161,104,194,39,98,116,225,151,121,205,253,143,149,242,242,199,15,135,71,242,191,72,69,81,80,193,163,159,128,174,68,79,231,237,144,146,47,20,84,188,129,66,102,201,35,201,23,138,2,0,123,13,113,200,232,127,103,147,238,121,28,189,59,157,148,153,211,129,72,62,191,167,247,102,35,54,79,137,26,225,37,183,28,137,128,10,187,18,9,186,228,247,140,11,198,132,31,199,252,55,156,205,72,65,62,143,28,79,47,137,142,149,94,18,233,241,150,138,109,222,209,152,92,205,210,94,22,64,168,201,244,57,158,40,89,135,206,44,200,172,211,82,250,159,70,104,170,68,45,67,136,183,176,177,117,174,46,127,90,183,202,84,196,18,235,38,247,168,46,85,213,44,230,201,136,34,8,187,73,68,118,82,247,125,56,96,195,179,46,47,112,114,148,94,171,223,168,53,12,97,235,179,216,108,178,200,108,56,67,234,142,164,122,179,13,244,93,51,111,207,126,126,173,230,11,19,78,231,81,230,130,181,84,185,213,246,89,23,157,46,168,250,205,135,120,84,61,166,63,70,76,181,46,133,179,17,206,101,2,210,180,84,1,219,19,135,152,164,146,12,83,235,60,99,116,62,219,40,134,15,149,241,94,131,19,133,80,207,76,244,53,185,184,185,28,107,104,188,65,106,207,174,99,91,96,209,77,5,151,167,199,69,26,2,120,228,222,97,195,187,182,81,23,154,138,115,241,231,203,199,215,11,125,14,157,17,239,94,217,99,93,189,39,51,172,202,84,172,231,156,216,40,105,116,21,30,8,212,77,109,150,105,202,102,56,104,58,94,24,164,137,71,242,237,66,52,167,120,249,87,216,195,210,254,89,98,21,35,174,71,114,113,42,166,79,21,6,228,227,247,138,78,197,38,99,172,175,86,28,30,30,93,231,251,120,61,196,113,0,93,112,243,201,162,123,44,161,27,204,128,42,230,42,246,18,146,249,144,130,195,149,80,134,118,47,245,162,166,57,239,181,170,249,209,252,239,73,173,46,17,124,89,111,118,255,62,220,132,29,235,194,98,186,152,149,178,234,46,124,110,148,135,50,181,191,166,231,12,126,150,67,131,135,199,34,174,146,110,175,229,150,128,67,193,123,179,145,161,151,87,249,162,62,43,44,85,12,89,221,143,211,171,39,109,152,10,181,124,244,186,94,137,222,165,11,99,185,198,49,199,192,187,255,27,151,18,96,3,9,252,148,5,171,3,193,113,13,64,169,10,152,66,45,9,121,15,178,247,250,32,5,13,251,45,108,181,153,103,34,222,145,24,228,148,69,44,231,132,96,133,87,46,254,216,128,74,150,132,27,146,228,181,192,139,213,136,30,80,179,54,78,250,84,152,75,150,211,39,7,225,2,11,236,91,59,111,149,15,101,60,246,197,114,66,227,100,213,40,75,78,202,235,107,76,34,211,22,29,48,117,240,84,225,215,73,61,7,217,254,21,157,35,246,208,243,177,171,222,25,76,8,215,59,154,66,219,113,97,196,7,206,38,149,233,183,58,66,137,212,35,185,143,110,186,92,31,224,54,44,117,73,230,134,48,217,9,22,184,43,177,44,245,165,78,215,3,93,252,153,224,162,84,179,251,3,58,187,41,235,5,159,227,156,81,71,143,240,219,10,105,25,191,181,189,226,35,53,82,163,102,32,94,153,153,255,3,30,253,14,66,55,52,21,212,72,216,71,217,192,42,150,140,89,200,160,90,114,200,4,170,147,202,181,37,131,236,10,244,57,98,74,113,28,139,78,254,113,166,128,129,201,98,226,85,84,106,212,132,234,169,1,22,239,95,177,175,143,156,0,216,248,50,45,27,39,205,243,108,158,165,185,60,28,78,91,131,195,135,44,31,84,82,28,215,103,222,6,220,36,112,207,238,136,172,97,156,46,124,43,89,14,61,43,116,77,207,232,114,137,31,0,234,249,21,79,220,108,5,70,5,187,135,16,210,164,79,151,228,7,226,212,193,136,192,235,80,3,31,240,90,126,126,132,218,217,8,188,229,247,71,89,14,52,5,122,162,195,139,115,135,212,171,143,1,30,106,192,81,184,8,57,212,198,158,237,43,114,19,150,229,144,114,79,5,242,219,175,104,105,243,29,88,61,199,119,73,238,77,9,245,199,105,21,11,33,78,238,240,64,98,142,129,66,210,166,181,185,185,31,125,171,195,5,167,147,99,151,57,240,133,152,209,50,155,3,7,109,105,111,122,7,222,40,112,34,149,48,170,174,145,170,141,42,120,10,132,223,167,183,27,52,150,14,41,78,216,126,101,1,247,162,208,133,175,134,206,125,88,27,24,250,25,141,101,66,122,71,8,246,216,70,101,95,120,149,121,227,138,129,103,221,121,226,120,48,74,128,214,124,56,153,212,177,217,251,77,253,203,185,157,32,26,65,180,71,71,97,74,197,59,214,178,34,105,185,6,30,186,241,75,81,216,146,43,109,244,167,184,121,76,179,82,84,35,189,146,156,46,229,187,193,73,34,124,188,23,225,99,96,4,18,114,0,231,251,180,39,38,112,209,124,177,140,134,24,50,62,255,120,147,169,210,158,219,207,21,244,0,34,142,255,56,160,193,155,110,83,60,119,89,80,35,176,13,64,42,72,226,232,151,68,210,3,159,79,132,22,129,187,144,151,13,163,221,88,115,201,128,121,164,30,176,59,60,160,102,194,62,40,2,170,247,49,46,209,79,162,48,221,117,73,135,225,194,200,111,97,131,100,81,249,105,52,168,117,39,243,145,168,152,250,189,68,43,71,197,7,223,153,197,58,48,177,129,10,247,58,84,151,114,79,216,161,212,13,199,23,127,171,96,5,107,163,228,108,185,167,187,253,96,144,58,211,152,238,36,197,25,95,4,239,132,210,17,149,48,35,107,226,199,210,220,155,43,172,103,140,15,226,31,250,71,56,22,83,225,33,48,166,199,138,71,246,51,168,249,144,17,2,94,167,211,7,10,1,15,212,105,105,65,209,201,155,242,216,42,249,142,242,121,48,220,240},
} ;

static void test_decode_1013xint16_impl(long long impl)
{
  unsigned char *x = test_decode_1013xint16_x;
  unsigned char *s = test_decode_1013xint16_s;
  unsigned char *x2 = test_decode_1013xint16_x2;
  unsigned char *s2 = test_decode_1013xint16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1013xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1013xint16(impl);
    printf("decode_1013xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013xint16_implementation(impl),ntruprime_dispatch_decode_1013xint16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1013xint16;
    printf("decode_1013xint16 selected implementation %s compiler %s\n",ntruprime_decode_1013xint16_implementation(),ntruprime_decode_1013xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1013xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1013xint16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1013xint16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1013xint16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1013xint16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1013xint16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1013xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013xint16")) return;
  storage_decode_1013xint16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1013xint16_x = aligned(storage_decode_1013xint16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1013xint16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1013xint16_s = aligned(storage_decode_1013xint16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1013xint16_x2 = callocplus(maxalloc);
  test_decode_1013xint16_x2 = aligned(storage_decode_1013xint16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1013xint16_s2 = callocplus(maxalloc);
  test_decode_1013xint16_s2 = aligned(storage_decode_1013xint16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1013xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1013xint16();++impl)
      forked(test_decode_1013xint16_impl,impl);
    ++test_decode_1013xint16_x;
    ++test_decode_1013xint16_s;
    ++test_decode_1013xint16_x2;
    ++test_decode_1013xint16_s2;
  }
  free(storage_decode_1013xint16_s2);
  free(storage_decode_1013xint16_x2);
  free(storage_decode_1013xint16_s);
  free(storage_decode_1013xint16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

