// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _MoniTool_Option_HeaderFile
#define _MoniTool_Option_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_MoniTool_Option_HeaderFile
#include <Handle_MoniTool_Option.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Handle_MoniTool_TypedValue_HeaderFile
#include <Handle_MoniTool_TypedValue.hxx>
#endif
#ifndef _Handle_Dico_DictionaryOfTransient_HeaderFile
#include <Handle_Dico_DictionaryOfTransient.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfAsciiString.hxx>
#endif
class Standard_Type;
class MoniTool_TypedValue;
class Dico_DictionaryOfTransient;
class Standard_Transient;
class TCollection_AsciiString;
class TColStd_HSequenceOfAsciiString;


//! An Option gives a way of recording an enumerated list of <br>
//!           instances of a given class, each instance being identified <br>
//!           by a case name. <br>
//! <br>
//!           Also, an Option allows to manage basic types through a Typed <br>
//!           Value (which also applies to Static Parameter). It may record <br>
//!           an enumerated list of values for a TypedValue or Static <br>
//!           Parameter, each of them is recorded as a string (HAsciiString) <br>
//! <br>
//!           An Option is defined by the type of the class to be optioned, <br>
//!           or (mutually exclusive) the TypedValue/Static of which values <br>
//!           are to be optioned, a specific name, a list of named values. <br>
//!           It brings a current case with its name and value <br>
//!           It may also have a default case (the first recorded one if not <br>
//!           precised) <br>
//! <br>
//!           An Option may be created from another one, by sharing its Type <br>
//!           and its list of Items (one per case), with the same name or <br>
//!           another one. It may then be duplicated to break this sharing. <br>
class MoniTool_Option : public MMgt_TShared {

public:

  //! Creates an Option from scratch, with a Type and a Name <br>
  Standard_EXPORT   MoniTool_Option(const Handle(Standard_Type)& atype,const Standard_CString aname);
  //! Creates an Option for a TypedValue (for basic, non-cdl-typed, <br>
//!           value : integer, real, string ...) <br>
//!           If <name> is not given, the name of the TypedValue is taken <br>
//!           Remark that Type is then enforced to TCollection_HAsciiString <br>
  Standard_EXPORT   MoniTool_Option(const Handle(MoniTool_TypedValue)& aval,const Standard_CString aname = "");
  //! Creates an Option from another one, the name can be redefined <br>
//!           The Type remains the same. The list of Items, too, it can also <br>
//!           be later duplicated by call to Duplicate <br>
  Standard_EXPORT   MoniTool_Option(const Handle(MoniTool_Option)& other,const Standard_CString aname = "");
  //! Adds an item : value and name (replaces it if name is already <br>
//!           recorded) <br>
//!           Returns True when done, False if <val> is not Kind of the <br>
//!           definition Type <br>
//!           For a TypedValue, val must be a HAsciiString, its content must <br>
//!           satisfy the definition of the TypedValue <br>
  Standard_EXPORT     Standard_Boolean Add(const Standard_CString name,const Handle(Standard_Transient)& val) ;
  //! Short-cut to add an item for a TypedValue (basic type) : name <br>
//!           is the name of the case, val is its value as a CString <br>
//!           If val is not provided, val = name is assumed <br>
//!           Returns True when done, False if this Option is not for a <br>
//!           TypedValue or if the new value does not satisfy the definition <br>
//!           of the TypedValue <br>
  Standard_EXPORT     Standard_Boolean AddBasic(const Standard_CString name,const Standard_CString val = "") ;
  //! Duplicates the list of items <br>
//!           It starts with the same definitions as before Duplicate, but <br>
//!           it is not longer shared with other options <br>
  Standard_EXPORT     void Duplicate() ;
  //! Returns the Name of the Option <br>
  Standard_EXPORT    const TCollection_AsciiString& Name() const;
  //! Returns the Type of the Option <br>
  Standard_EXPORT     Handle_Standard_Type Type() const;
  //! Returns the TypedValue of the Option, or a Null Handle <br>
  Standard_EXPORT     Handle_MoniTool_TypedValue TypedValue() const;
  //! Gives the value bound with a name, in val <br>
//!           Returns True if <name> is found, False else <br>
//!           This way of returning a Transient, bound with the Type Control <br>
//!           avoids DownCast and ensures the value is directly usable <br>
  Standard_EXPORT     Standard_Boolean Item(const Standard_CString name,Handle(Standard_Transient)& val) const;
  //! Returns the list of available item names <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfAsciiString ItemList() const;
  //! Returns the list of cases, other than <name>, which bring the <br>
//!           same value as <name> <br>
//!           Empty list (not a Null Handle) if no alias, or <name> unknown <br>
//!           if <exact> is True (D), exact name is required, no completion <br>
//!           if <exact> is False and <name> is not complete, but addresses <br>
//!           only one item, completion is done and the list includes the <br>
//!           complete name <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfAsciiString Aliases(const Standard_CString name,const Standard_Boolean exact = Standard_True) const;
  //! Commands the Option to switch on an item name <br>
//!           Returns True when done, False if <name> is not recorded <br>
//!             (in that case, former switch remains unchanged) <br>
//!           If no switch has been called, it is active on the last added <br>
//!           items <br>
  Standard_EXPORT     Standard_Boolean Switch(const Standard_CString name) ;
  //! Returns the Name of the currently switched item (Case) <br>
  Standard_EXPORT    const TCollection_AsciiString& CaseName() const;
  //! Returns the Value of the currently switch item <br>
//!           To be down-casted as needed before use <br>
  Standard_EXPORT     Handle_Standard_Transient CaseValue() const;
  //! Returns the Value of the currently switch item <br>
//!           This way of returning a Transient, bound with the Type Control <br>
//!           avoids DownCast and ensures the value is directly usable <br>
//!           For a TypedValue, returns the corresponding HAsciiString <br>
  Standard_EXPORT     void Value(Handle(Standard_Transient)& val) const;




  DEFINE_STANDARD_RTTI(MoniTool_Option)

protected:




private: 

  //! Returns the list of items, to be shared (to copy an option) <br>
  Standard_EXPORT     Handle_Dico_DictionaryOfTransient Items() const;

TCollection_AsciiString thename;
Handle_Standard_Type thetype;
Handle_MoniTool_TypedValue thevalue;
Handle_Dico_DictionaryOfTransient theitems;
TCollection_AsciiString thecase;
Handle_Standard_Transient theval;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
