# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################
import time

from osv import fields, osv
from tools.translate import _

class account_use_model(osv.osv_memory):

    _name = 'account.use.model'
    _description = 'Use model'
    _columns = {
        'model': fields.many2many('account.model', 'account_use_model_relation', 'account_id', 'model_id', 'Account Model'),
    }

    def view_init(self, cr , uid , fields_list, context=None):
        account_model_obj = self.pool.get('account.model')
        if context is None:
            context = {}
        if context.get('active_ids',False):
            data_model = account_model_obj.browse(cr, uid, context['active_ids'])
            for model in data_model:
                for line in model.lines_id:
                    if line.date_maturity == 'partner':
                        if not line.partner_id:
                            raise osv.except_osv(_('Error !'), _("Maturity date of entry line generated by model line '%s' is based on partner payment term!"\
                                                                    "\nPlease define partner on it!")%line.name)
        pass

    def create_entries(self, cr, uid, ids, context=None):
        account_model_obj = self.pool.get('account.model')
        mod_obj = self.pool.get('ir.model.data')
        if context is None:
            context = {}
        data =  self.read(cr, uid, ids, context=context)[0]
        record_id = context and context.get('model_line', False) or False
        if record_id:
            model_ids = data['model']
        else:
            model_ids = context['active_ids']
        move_ids = account_model_obj.generate(cr, uid, model_ids, context=context)

        context.update({'move_ids':move_ids})
        model_data_ids = mod_obj.search(cr, uid,[('model','=','ir.ui.view'),('name','=','view_move_form')], context=context)
        resource_id = mod_obj.read(cr, uid, model_data_ids, fields=['res_id'], context=context)[0]['res_id']
        return {
            'domain': "[('id','in', ["+','.join(map(str,context['move_ids']))+"])]",
            'name': 'Entries',
            'view_type': 'form',
            'view_mode': 'tree,form',
            'res_model': 'account.move',
            'views': [(False,'tree'),(resource_id,'form')],
            'type': 'ir.actions.act_window',
        }

account_use_model()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
