#!perl -T

use Test::Most tests => 2;

use App::Parcimonie;
use Path::Class;

my $gnupg_options;

# without any gpg.conf
$gnupg_options = {
    homedir => dir('t', 'data', 'gnupg_homedir_without_gpgconf')
};

dies_ok { checkGpgHasDefinedKeyserver($gnupg_options) }
    "checkGpgHasDefinedKeyserver throws an exception if no gpg.conf can be found";

# without any defined keyserver in gpg.conf
$gnupg_options = {
    homedir => dir('t', 'data', 'gnupg_homedir_without_defined_keyserver')
};

dies_ok { checkGpgHasDefinedKeyserver($gnupg_options) }
    "checkGpgHasDefinedKeyserver throws an exception if no keyserver is defined in gpg.conf";
