<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- 
     This file contains templates for constructing the summary of
     roll, sheet, digital, and digimage elements that is used to
     converted into an HTML index by index.xsl.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"
              encoding="utf-8"/>

  <!-- Template matching document root. -->
  <xsl:template match="/">
    <xsl:apply-templates select="//roll|//sheet|//digital|
                                 //digimage[not(ancestor::digital)]"/>
  </xsl:template>


  <!-- Extract relevant details from roll, sheet, and digital elements. -->
  <xsl:template match="roll|sheet|digital">
    <xsl:element name="{name(.)}">
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:if test="count((//roll|//sheet|//digital)[@id=current()/@id])=1">
        <xsl:attribute name="aid">
          <xsl:value-of select="concat('#',name(.),'-',@id)"/>
        </xsl:attribute>
      </xsl:if>
      <startdate>
        <xsl:value-of select="descendant::frame[descendant::
                      scene/occasion/date!=''][1]/scene/occasion/date"/>
      </startdate>
      <enddate>
        <xsl:value-of select="descendant::frame[descendant::
                      scene/occasion/date!=''][last()]/scene/occasion/date"/>
      </enddate>
      <xsl:variable name="equipment-explicit" select="descendant::frame
                      [descendant::equipment/body][1]/equipment/body"/>

      <xsl:variable name="equipment-implicit"
                    select="preceding-sibling::defaults
                            [descendant::equipment/body][1]//equipment/body"/>
      <xsl:choose>
        <xsl:when test="$equipment-explicit">
          <xsl:apply-templates select="$equipment-explicit"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="$equipment-implicit"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="film"/>
    </xsl:element>
  </xsl:template>


  <!-- Extract relevant details from digimage elements. -->
  <xsl:template match="digimage">
    <xsl:copy>
      <xsl:apply-templates select="@group-id|@frame-id|@image-id"/>
    </xsl:copy>
  </xsl:template>


  <!-- Copy all elements, attributes, and text nodes. -->
  <xsl:template match="*|@*|text()">
     <xsl:copy>
       <xsl:apply-templates select="*|@*|text()"/>
     </xsl:copy>
  </xsl:template>


  <!-- Don't copy any comments. -->
  <xsl:template match="comment()">
  </xsl:template>

</xsl:stylesheet>
