<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- 
     This file contains templates for upgrading DigImageML files from
     DTD version 0.01 to version 0.02.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes"
	    doctype-public="-//BW//DTD DigImageML 0.02//EN"
            doctype-system="digimage.dtd"/>


<!-- Default template -->
<xsl:template match="@*|*|text()|comment()">
  <xsl:copy>
    <xsl:apply-templates select="@*|*|text()|comment()"/>
  </xsl:copy>
</xsl:template>


<!-- Handle changes to source element -->
<xsl:template match="source">
  <history>
    <origin>
      <xsl:if test="scanning/date">
         <xsl:apply-templates select="scanning/date"/>
      </xsl:if>
      <xsl:apply-templates/>
    </origin>
  </history>
</xsl:template>


<!-- Handle changes to scanning element -->
<xsl:template match="scanning">
  <scanner>
    <xsl:apply-templates select="hardware|software|settings|note"/>
  </scanner>
</xsl:template>


<!-- Handle changes to parent element -->
<xsl:template match="parent">
  <source image-id="{@image-id}">
    <xsl:apply-templates/>
  </source>
</xsl:template>


</xsl:stylesheet>
