/*	Error_Report

PIRL CVS ID: Error_Report.java,v 1.7 2012/04/16 06:04:11 castalia Exp

Copyright (C) 2008-2012 Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor.Maestro;

import	PIRL.Viewers.Icons;
import	PIRL.Viewers.View_Locator;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.JTextArea;
import	javax.swing.JScrollPane;
import	javax.swing.JLabel;
import	javax.swing.JButton;
import	javax.swing.ImageIcon;
import	java.awt.Frame;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.BorderLayout;
import	java.awt.Dimension;
import	java.awt.event.*;
import	java.awt.Toolkit;
import	java.io.PrintWriter;
import	java.io.StringWriter;
import	java.lang.Math;


/**	An <I>Error_Report</I> is a window for reporting error messages.
<p>
	The window title may be specified or the default "Error Report" may
	be used.
<p>
	If the error icon can be loaded it is displayed in the upper-left
	corner of the window pane.
<p>
	A short error message is displayed at the top of the window, to the
	right of the error icon.
<p>
	A long error report is displayed in a scoll pane below the error
	message. The error report may be provided as text or as an Exception
	from which a stack trace report will be obtained.
<p>
	@author	Bradford Castalia, UA/PIRL
	@version 1.7
*/
public class Error_Report
	extends JFrame
{
public static final String
	ID = "PIRL.Conductor.Maestro.Error_Report (1.7 2012/04/16 06:04:11)";


/**	The default window title.
*/
public static final String
	DEFAULT_TITLE			= "Error Report";

/**	The filename for the error icon image.
<p>
	The filename will be sought in the Icons sibling directory relative
	to the location of this class.
*/
public static String
	Error_Icon_Name			= "Exclamation.png";
private static ImageIcon
	Error_Icon				= null;

//	The size of the scroll pane.
private static final Dimension
	SCROLL_PANE_SIZE		= new Dimension (250, 125);

private static final String
	NL						= System.getProperty ("line.separator");


//  DEBUG control.
private static final int
	DEBUG_OFF				= 0,
	DEBUG_CONSTRUCTOR		= 1 << 0,
	DEBUG_ALL				= -1,

	DEBUG					= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
/**	Constructs an Error_Report using optional report text.
<p>
	@param	title	The String to be used as the title of the window.
		If null the title will be "Error Report".
	@param	message	The message to be displayed at the top of the window.
	@param	report	The error report to be displayed in a scroll pane.
		If null no scroll pane will be displayed.
	@param	owner	The parent Frame opver which the window will be
		centered. If null the window will be centered on the screen.
*/
public Error_Report
	(
	String		title,
	String		message,
	String		report,
	Frame		owner
	)
{
super ((title == null) ? DEFAULT_TITLE : title);
GUI (title, message, report, owner);
}

/**	Constructs an Error_Report using an optional Exception report.
<p>
	@param	title	The String to be used as the title of the window.
		If null the title will be "Error Report".
	@param	message	The message to be displayed at the top of the window.
	@param	exception	The Exception to have its stack trace displayed
		in a scroll pane. If null no scroll pane will be displayed.
	@param	owner	The parent Frame opver which the window will be
		centered. If null the window will be centered on the screen.
*/
public Error_Report
	(
	String		title,
	String		message,
	Exception	exception,
	Frame		owner
	)
{
super ((title == null) ? DEFAULT_TITLE : title);
String
	report = null;
if (exception != null)
	{
	StringWriter
		report_writer = new StringWriter ();
	exception.printStackTrace (new PrintWriter (report_writer, true));
	report = report_writer.toString ();
	}
GUI (title, message, report, owner);
}

/**	Constructs an Error_Report with only a message.
<p>
	@param	title	The String to be used as the title of the window.
		If null the title will be "Error Report".
	@param	message	The message to be displayed at the top of the window.
	@param	owner	The parent Frame opver which the window will be
		centered. If null the window will be centered on the screen.
*/
public Error_Report
	(
	String		title,
	String		message,
	Frame		owner
	)
{this (title, message, (String)null, owner);}


private Error_Report ()
{}

/*==============================================================================
	GUI
*/
private void GUI
	(
	String		title,
	String		message,
	String		report,
	Frame		owner
	)
{
if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		(">>> Error_Report.GUI: " + title + NL
		+"    Message -" + NL
		+ message + NL
		+"    Report -" + NL
		+ report);

JPanel
	panel = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

location.anchor		= GridBagConstraints.NORTHWEST;
location.fill		= GridBagConstraints.NONE;
location.weightx	= 0.0;
location.weighty	= 0.0;
location.insets		= new Insets (10, 10, 10, 10);

if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("    Load_Icon...");
Load_Icon ();
if (Error_Icon != null)
	panel.add (new JLabel (Error_Icon), location);

if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("    Message JTextArea ...");
JTextArea
	text			= new JTextArea (message);
text.setEditable (false);
text.setBackground (panel.getBackground ());
location.fill		= GridBagConstraints.BOTH;
location.weightx	= 1.0;
location.gridwidth	= GridBagConstraints.REMAINDER;
panel.add (text, location);

if (report != null)
	{
	if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
		System.out.println
			("    Report JTextArea ...");
	text				= new JTextArea (report);
	text.setEditable (false);
	text.setMargin (new Insets (5, 5, 5, 5));
	JScrollPane
		scroll_pane		= new JScrollPane (text);
	scroll_pane.setPreferredSize (SCROLL_PANE_SIZE);
	scroll_pane.setVerticalScrollBarPolicy
		(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
	scroll_pane.setHorizontalScrollBarPolicy
		(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

	location.insets		= new Insets (0, 5, 0, 5);
	location.fill		= GridBagConstraints.BOTH;
	location.weightx	= 1.0;
	location.weighty	= 1.0;
	panel.add (scroll_pane, location);
	}

if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("    JButton ...");
JButton
	button			= new JButton ("Close");
button.setMnemonic ('C');
button.setDefaultCapable (true);
getRootPane ().setDefaultButton (button);
button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{setVisible (false);}});

location.anchor		= GridBagConstraints.EAST;
location.fill		= GridBagConstraints.NONE;
location.weightx	= 0.0;
location.weighty	= 0.0;
location.insets		= new Insets (5, 5, 5, 5);
panel.add (button, location);

if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("    Add panel to content pane and pack ...");
getContentPane ().add (panel, BorderLayout.CENTER);
pack ();

if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("    View_Locator ...");
View_Locator
	locator = new View_Locator ()
		.Vertical (View_Locator.CENTER)
		.Horizontal (View_Locator.CENTER);
locator.Relocate (this, owner);

Toolkit.getDefaultToolkit ().beep ();
setDefaultCloseOperation (JFrame.DISPOSE_ON_CLOSE);
setVisible (true);
if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("<<< Error_Report.GUI");
}

/*==============================================================================
	Helpers
*/
/**	Loads the icon.
*/
private void Load_Icon ()
{
if (Error_Icon == null &&
	Error_Icon_Name != null)
	{
	Icons.Directory ("Icons", this.getClass ());
	Error_Icon = Icons.Load_Icon (Error_Icon_Name);
	}
}


}
